/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.collector.cron;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.descriptor.Descriptor;
import org.torproject.metrics.collector.conf.Configuration;
import org.torproject.metrics.collector.conf.ConfigurationException;
import org.torproject.metrics.collector.conf.Key;
import org.torproject.metrics.collector.conf.SourceType;
import org.torproject.metrics.collector.sync.SyncManager;

public abstract class CollecTorMain
extends SyncManager
implements Callable<Object>,
Runnable {
    private static final Logger logger = LoggerFactory.getLogger(CollecTorMain.class);
    private static final long LIMIT_MB = 200L;
    public static final String SOURCES = "Sources";
    protected Configuration config = new Configuration();
    protected final Map<String, Class<? extends Descriptor>> mapPathDescriptors = new HashMap<String, Class<? extends Descriptor>>();

    public CollecTorMain(Configuration conf) {
        this.config.putAll(conf.getPropertiesCopy());
    }

    @Override
    public final void run() {
        try {
            if (!this.isSyncOnly()) {
                logger.info("Starting {} module of CollecTor.", (Object)this.module());
                this.startProcessing();
                logger.info("Terminating {} module of CollecTor.", (Object)this.module());
            }
        }
        catch (Throwable th) {
            logger.error("The {} module failed: {}", new Object[]{this.module(), th.getMessage(), th});
        }
        try {
            if (this.isSync()) {
                logger.info("Starting sync-run of module {} of CollecTor.", (Object)this.module());
                this.merge(this.config, this.syncMarker(), this.syncMapPathsDescriptors());
                logger.info("Finished sync-run of module {} of CollecTor.", (Object)this.module());
            }
        }
        catch (Throwable th) {
            logger.error("Sync-run of {} module failed: {}", new Object[]{this.module(), th.getMessage(), th});
        }
    }

    private boolean isSync() throws ConfigurationException {
        String key = this.syncMarker() + SOURCES;
        return Key.has(key) && this.config.getSourceTypeSet(Key.valueOf(key)).contains((Object)SourceType.Sync);
    }

    private boolean isSyncOnly() throws ConfigurationException {
        String key = this.syncMarker() + SOURCES;
        return this.isSync() && this.config.getSourceTypeSet(Key.valueOf(key)).size() == 1;
    }

    @Override
    public final Object call() {
        this.run();
        return null;
    }

    protected abstract void startProcessing() throws ConfigurationException;

    protected abstract String syncMarker();

    public abstract String module();

    public Map<String, Class<? extends Descriptor>> syncMapPathsDescriptors() {
        return Collections.unmodifiableMap(this.mapPathDescriptors);
    }

    public static void checkAvailableSpace(Path location) {
        try {
            long megaBytes = Files.getFileStore(location.toFile().getAbsoluteFile().toPath().getRoot()).getUsableSpace() / 1024L / 1024L;
            if (megaBytes < 200L) {
                logger.warn("Available storage critical for {}; only {} MiB left.", (Object)location, (Object)megaBytes);
            } else {
                logger.trace("Available storage for {}: {} MiB", (Object)location, (Object)megaBytes);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Cannot access " + location + " reason: " + ioe.getMessage(), ioe);
        }
    }

    public SortedSet<Path> readProcessedFiles(Path stateFile) {
        TreeSet<Path> processedFiles = new TreeSet<Path>();
        if (Files.exists(stateFile, new LinkOption[0])) {
            try {
                for (String line : Files.readAllLines(stateFile)) {
                    processedFiles.add(Paths.get(line, new String[0]));
                }
            }
            catch (IOException e) {
                logger.warn("I/O error while reading processed files.", (Throwable)e);
            }
        }
        return processedFiles;
    }

    public void writeProcessedFiles(Path stateFile, SortedSet<Path> processedFiles) {
        ArrayList<String> lines = new ArrayList<String>();
        for (Path processedFile : processedFiles) {
            lines.add(processedFile.toString());
        }
        try {
            if (!Files.exists(stateFile, new LinkOption[0])) {
                Files.createDirectories(stateFile.getParent(), new FileAttribute[0]);
            }
            Files.write(stateFile, lines, new OpenOption[0]);
        }
        catch (IOException e) {
            logger.warn("I/O error while writing processed files.", (Throwable)e);
        }
    }
}

