/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.collector.webstats;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.LocalDate;
import java.util.Optional;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.metrics.collector.webstats.LogMetadata;

public class LogFileMap
extends TreeMap<String, TreeMap<String, TreeMap<LocalDate, LogMetadata>>> {
    private static final Logger logger = LoggerFactory.getLogger(LogFileMap.class);

    public LogFileMap(Path startDir) {
        this.collectFiles(this, startDir);
    }

    private void collectFiles(final LogFileMap logFileMap, Path startDir) {
        try {
            Files.walkFileTree(startDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes att) {
                    Optional<LogMetadata> optionalMetadata = LogMetadata.create(path);
                    optionalMetadata.ifPresent(logFileMap::add);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path path, IOException ex) {
                    return this.logIfError(path, ex);
                }

                @Override
                public FileVisitResult postVisitDirectory(Path path, IOException ex) {
                    return this.logIfError(path, ex);
                }

                private FileVisitResult logIfError(Path path, IOException ex) {
                    if (null != ex) {
                        logger.warn("Cannot process '{}'.", (Object)path, (Object)ex);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException ex) {
            logger.error("Cannot read directory '{}'.", (Object)startDir, (Object)ex);
        }
    }

    public void add(LogMetadata metadata) {
        TreeMap virtualHosts = this.computeIfAbsent(metadata.virtualHost, k -> new TreeMap());
        TreeMap physicalHosts = virtualHosts.computeIfAbsent(metadata.physicalHost, k -> new TreeMap());
        physicalHosts.put(metadata.date, metadata);
    }
}

