/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.collector.snowflake;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.SortedSet;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.descriptor.Descriptor;
import org.torproject.descriptor.DescriptorParser;
import org.torproject.descriptor.DescriptorSourceFactory;
import org.torproject.descriptor.SnowflakeStats;
import org.torproject.metrics.collector.conf.Annotation;
import org.torproject.metrics.collector.conf.Configuration;
import org.torproject.metrics.collector.conf.ConfigurationException;
import org.torproject.metrics.collector.conf.Key;
import org.torproject.metrics.collector.cron.CollecTorMain;
import org.torproject.metrics.collector.downloader.Downloader;
import org.torproject.metrics.collector.persist.PersistenceUtils;
import org.torproject.metrics.collector.persist.SnowflakeStatsPersistence;

public class SnowflakeStatsDownloader
extends CollecTorMain {
    private static final Logger logger = LoggerFactory.getLogger(SnowflakeStatsDownloader.class);
    private String recentPathName;
    private String outputPathName;

    public SnowflakeStatsDownloader(Configuration config) {
        super(config);
        this.mapPathDescriptors.put("recent/snowflakes", SnowflakeStats.class);
    }

    @Override
    public String module() {
        return "SnowflakeStats";
    }

    @Override
    protected String syncMarker() {
        return "SnowflakeStats";
    }

    @Override
    protected void startProcessing() throws ConfigurationException {
        byte[] downloadedBytes;
        this.recentPathName = this.config.getPath(Key.RecentPath).toString();
        logger.debug("Downloading snowflake stats...");
        URL url = this.config.getUrl(Key.SnowflakeStatsUrl);
        try {
            downloadedBytes = Downloader.downloadFromHttpServer(url);
        }
        catch (IOException e) {
            logger.warn("Failed downloading {}.", (Object)url, (Object)e);
            return;
        }
        if (null == downloadedBytes) {
            logger.warn("Could not download {}.", (Object)url);
            return;
        }
        logger.debug("Finished downloading {}.", (Object)url);
        Path parsedSnowflakeStatsFile = this.config.getPath(Key.StatsPath).resolve("processed-snowflake-stats");
        SortedSet<Path> previouslyProcessedFiles = this.readProcessedFiles(parsedSnowflakeStatsFile);
        TreeSet<Path> processedFiles = new TreeSet<Path>();
        DescriptorParser descriptorParser = DescriptorSourceFactory.createDescriptorParser();
        TreeSet<LocalDateTime> snowflakeStatsEnds = new TreeSet<LocalDateTime>();
        this.outputPathName = this.config.getPath(Key.OutputPath).toString();
        for (Descriptor descriptor : descriptorParser.parseDescriptors(downloadedBytes, null, null)) {
            File[] outputFiles;
            if (!(descriptor instanceof SnowflakeStats)) continue;
            SnowflakeStats snowflakeStats = (SnowflakeStats)descriptor;
            LocalDateTime snowflakeStatsEnd = snowflakeStats.snowflakeStatsEnd();
            snowflakeStatsEnds.add(snowflakeStatsEnd);
            SnowflakeStatsPersistence persistence = new SnowflakeStatsPersistence(snowflakeStats);
            File tarballFile = new File(this.outputPathName + "/" + persistence.getStoragePath());
            Path relativeFileName = Paths.get(tarballFile.getName(), new String[0]);
            processedFiles.add(relativeFileName);
            if (previouslyProcessedFiles.contains(relativeFileName) || tarballFile.exists()) continue;
            File rsyncFile = new File(this.recentPathName + "/" + persistence.getRecentPath());
            for (File outputFile : outputFiles = new File[]{tarballFile, rsyncFile}) {
                this.writeToFile(outputFile, Annotation.SnowflakeStats.bytes(), snowflakeStats.getRawDescriptorBytes());
            }
        }
        if (snowflakeStatsEnds.isEmpty()) {
            logger.warn("Could not parse downloaded snowflake stats.");
            return;
        }
        if (((LocalDateTime)snowflakeStatsEnds.last()).isBefore(LocalDateTime.now().minusHours(48L))) {
            logger.warn("The latest snowflake stats are older than 48 hours: {}.", snowflakeStatsEnds.last());
        }
        this.writeProcessedFiles(parsedSnowflakeStatsFile, processedFiles);
        this.cleanUpDirectories();
    }

    private void writeToFile(File outputFile, byte[] ... bytes) {
        try {
            if (!outputFile.getParentFile().exists() && !outputFile.getParentFile().mkdirs()) {
                logger.warn("Could not create parent directories of {}.", (Object)outputFile);
                return;
            }
            FileOutputStream os = new FileOutputStream(outputFile);
            for (byte[] b : bytes) {
                ((OutputStream)os).write(b);
            }
            ((OutputStream)os).close();
        }
        catch (IOException e) {
            logger.warn("Could not write downloaded snowflake stats to {}", (Object)outputFile.getAbsolutePath(), (Object)e);
        }
    }

    private void cleanUpDirectories() {
        PersistenceUtils.cleanDirectory(Paths.get(this.recentPathName, "snowflakes"), Instant.now().minus(3L, ChronoUnit.DAYS).toEpochMilli());
        PersistenceUtils.cleanDirectory(Paths.get(this.outputPathName, "snowflakes"), Instant.now().minus(49L, ChronoUnit.DAYS).toEpochMilli());
    }
}

