/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.collector.relaydescs;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.metrics.collector.relaydescs.RelayDescriptorParser;

public class CachedRelayDescriptorReader {
    private static final Logger logger = LoggerFactory.getLogger(CachedRelayDescriptorReader.class);
    private RelayDescriptorParser rdp;
    private String[] inputDirectories;
    private File importHistoryFile;
    private StringBuilder dumpStats;
    private Set<String> lastImportHistory = new HashSet<String>();
    private Set<String> currentImportHistory = new HashSet<String>();

    CachedRelayDescriptorReader(RelayDescriptorParser rdp, String[] inputDirectories, File statsDirectory) {
        if (rdp == null || inputDirectories == null || inputDirectories.length == 0 || statsDirectory == null) {
            throw new IllegalArgumentException();
        }
        this.rdp = rdp;
        this.inputDirectories = inputDirectories;
        this.importHistoryFile = new File(statsDirectory, "cacheddesc-import-history");
        this.dumpStats = new StringBuilder("Finished importing relay descriptors from local Tor data directories:");
    }

    public void readDescriptors() {
        this.readHistoryFile();
        this.readDescriptorFiles();
        this.writeHistoryFile();
    }

    private void readHistoryFile() {
        if (this.importHistoryFile.exists()) {
            try {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(this.importHistoryFile));
                while ((line = br.readLine()) != null) {
                    this.lastImportHistory.add(line);
                }
                br.close();
            }
            catch (IOException e) {
                logger.warn("Could not read import history from {}.", (Object)this.importHistoryFile.getAbsolutePath(), (Object)e);
            }
        }
    }

    private void readDescriptorFiles() {
        for (String inputDirectory : this.inputDirectories) {
            File cachedDescDir = new File(inputDirectory);
            if (!cachedDescDir.exists()) {
                logger.warn("Directory {} does not exist. Skipping.", (Object)cachedDescDir.getAbsolutePath());
                continue;
            }
            logger.debug("Reading {} directory.", (Object)cachedDescDir.getAbsolutePath());
            TreeSet<File> cachedDescFiles = new TreeSet<File>();
            Stack<File> files = new Stack<File>();
            files.add(cachedDescDir);
            while (!files.isEmpty()) {
                File file = (File)files.pop();
                if (file.isDirectory()) {
                    files.addAll(Arrays.asList(file.listFiles()));
                    continue;
                }
                cachedDescFiles.add(file);
            }
            for (File f : cachedDescFiles) {
                try {
                    int sig;
                    int start;
                    int len;
                    BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f));
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    byte[] data = new byte[1024];
                    while ((len = bis.read(data, 0, 1024)) >= 0) {
                        baos.write(data, 0, len);
                    }
                    bis.close();
                    byte[] allData = baos.toByteArray();
                    if (f.getName().equals("cached-consensus")) {
                        String line;
                        BufferedReader br = new BufferedReader(new StringReader(new String(allData, StandardCharsets.US_ASCII)));
                        while ((line = br.readLine()) != null) {
                            if (!line.startsWith("valid-after ")) continue;
                            this.dumpStats.append("\n").append(f.getName()).append(": ").append(line.substring("valid-after ".length()));
                            SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            if (dateTimeFormat.parse(line.substring("valid-after ".length())).getTime() >= System.currentTimeMillis() - 21600000L) break;
                            logger.warn("Cached descriptor files in {} are stale. The valid-after line in cached-consensus is '{}'.", (Object)cachedDescDir.getAbsolutePath(), (Object)line);
                            this.dumpStats.append(" (stale!)");
                            break;
                        }
                        br.close();
                        String digest = Hex.encodeHexString(DigestUtils.sha1(allData));
                        if (!this.lastImportHistory.contains(digest) && !this.currentImportHistory.contains(digest)) {
                            this.rdp.parse(allData, null);
                        } else {
                            this.dumpStats.append(" (skipped)");
                        }
                        this.currentImportHistory.add(digest);
                        continue;
                    }
                    if (f.getName().equals("v3-status-votes")) {
                        int parsedNum = 0;
                        int skippedNum = 0;
                        String ascii = new String(allData, StandardCharsets.US_ASCII);
                        String startToken = "network-status-version ";
                        int end = ascii.length();
                        int start2 = ascii.indexOf(startToken);
                        while (start2 >= 0 && start2 < end) {
                            int next = ascii.indexOf(startToken, start2 + 1);
                            if (next < 0) {
                                next = end;
                            }
                            if (start2 < next) {
                                byte[] rawNetworkStatusBytes = new byte[next - start2];
                                System.arraycopy(allData, start2, rawNetworkStatusBytes, 0, next - start2);
                                String digest = Hex.encodeHexString(DigestUtils.sha1(rawNetworkStatusBytes));
                                if (!this.lastImportHistory.contains(digest) && !this.currentImportHistory.contains(digest)) {
                                    this.rdp.parse(rawNetworkStatusBytes, null);
                                    ++parsedNum;
                                } else {
                                    ++skippedNum;
                                }
                                this.currentImportHistory.add(digest);
                            }
                            start2 = next;
                        }
                        this.dumpStats.append("\n").append(f.getName()).append(": parsed ").append(parsedNum).append(", skipped ").append(skippedNum).append(" votes");
                        continue;
                    }
                    if (!f.getName().startsWith("cached-descriptors") && !f.getName().startsWith("cached-extrainfo")) continue;
                    String ascii = new String(allData, StandardCharsets.US_ASCII);
                    int end = -1;
                    String startToken = f.getName().startsWith("cached-descriptors") ? "router " : "extra-info ";
                    String sigToken = "\nrouter-signature\n";
                    String endToken = "\n-----END SIGNATURE-----\n";
                    int parsedNum = 0;
                    int skippedNum = 0;
                    while (end < ascii.length() && (start = ascii.indexOf(startToken, end)) >= 0 && (sig = ascii.indexOf(sigToken, start)) >= 0 && (end = ascii.indexOf(endToken, sig += sigToken.length())) >= 0) {
                        byte[] descBytes = new byte[(end += endToken.length()) - start];
                        System.arraycopy(allData, start, descBytes, 0, end - start);
                        String digest = Hex.encodeHexString(DigestUtils.sha1(descBytes));
                        if (!this.lastImportHistory.contains(digest) && !this.currentImportHistory.contains(digest)) {
                            this.rdp.parse(descBytes, null);
                            ++parsedNum;
                        } else {
                            ++skippedNum;
                        }
                        this.currentImportHistory.add(digest);
                    }
                    this.dumpStats.append("\n").append(f.getName()).append(": parsed ").append(parsedNum).append(", skipped ").append(skippedNum).append(" ").append(f.getName().startsWith("cached-descriptors") ? "server" : "extra-info").append(" descriptors");
                }
                catch (IOException | ParseException e) {
                    logger.warn("Failed reading {} directory.", (Object)cachedDescDir.getAbsolutePath(), (Object)e);
                }
            }
            logger.debug("Finished reading {} directory.", (Object)cachedDescDir.getAbsolutePath());
        }
    }

    private void writeHistoryFile() {
        try {
            this.importHistoryFile.getParentFile().mkdirs();
            BufferedWriter bw = new BufferedWriter(new FileWriter(this.importHistoryFile));
            for (String digest : this.currentImportHistory) {
                bw.write(digest + "\n");
            }
            bw.close();
        }
        catch (IOException e) {
            logger.warn("Could not write import history to {}.", (Object)this.importHistoryFile.getAbsolutePath(), (Object)e);
        }
        logger.info(this.dumpStats.toString());
    }
}

