/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.collector.persist;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.descriptor.TorperfResult;
import org.torproject.metrics.collector.conf.Annotation;
import org.torproject.metrics.collector.persist.DescriptorPersistence;
import org.torproject.metrics.collector.persist.PersistenceUtils;

public class OnionPerfPersistence
extends DescriptorPersistence<TorperfResult> {
    private static final Logger logger = LoggerFactory.getLogger(OnionPerfPersistence.class);
    private static final String ONIONPERF = "torperf";

    public OnionPerfPersistence(TorperfResult desc) {
        super(desc, Annotation.OnionPerf.bytes());
        this.calculatePaths();
    }

    private void calculatePaths() {
        String[] parts = PersistenceUtils.dateTimeParts(((TorperfResult)this.desc).getStartMillis());
        String name = ((TorperfResult)this.desc).getSource() + "-" + ((TorperfResult)this.desc).getFileSize() + "-" + parts[0] + "-" + parts[1] + "-" + parts[2] + ".tpf";
        this.recentPath = Paths.get(ONIONPERF, name).toString();
        this.storagePath = Paths.get(ONIONPERF, parts[0], parts[1], parts[2], name).toString();
    }

    @Override
    public boolean storeOut(String outRoot, StandardOpenOption option) {
        if (((TorperfResult)this.desc).getDescriptorFile().getName().endsWith(".tpf")) {
            return super.storeOut(outRoot, StandardOpenOption.APPEND);
        }
        String fileName = ((TorperfResult)this.desc).getDescriptorFile().getName();
        String[] dateParts = fileName.split("\\.")[0].split("-");
        return this.copyIfNotExists(Paths.get(outRoot, "onionperf", dateParts[0], dateParts[1], dateParts[2], fileName));
    }

    @Override
    public boolean storeRecent(String recentRoot, StandardOpenOption option) {
        if (((TorperfResult)this.desc).getDescriptorFile().getName().endsWith(".tpf")) {
            return super.storeRecent(recentRoot, StandardOpenOption.APPEND);
        }
        String fileName = ((TorperfResult)this.desc).getDescriptorFile().getName();
        return this.copyIfNotExists(Paths.get(recentRoot, "onionperf", fileName));
    }

    private boolean copyIfNotExists(Path destinationFile) {
        if (Files.exists(destinationFile, new LinkOption[0])) {
            return false;
        }
        Path originalFile = ((TorperfResult)this.desc).getDescriptorFile().toPath();
        try {
            Files.createDirectories(destinationFile.getParent(), new FileAttribute[0]);
            Files.copy(originalFile, destinationFile, new CopyOption[0]);
        }
        catch (IOException e) {
            logger.warn("Unable to copy file.", e);
            return false;
        }
        return true;
    }
}

