/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.collector.persist;

import java.nio.file.Paths;
import org.torproject.descriptor.BridgeNetworkStatus;
import org.torproject.metrics.collector.conf.Annotation;
import org.torproject.metrics.collector.persist.DescriptorPersistence;
import org.torproject.metrics.collector.persist.PersistenceUtils;

public class BridgeNetworkStatusPersistence
extends DescriptorPersistence<BridgeNetworkStatus> {
    private static final String STATUSES = "statuses";

    public BridgeNetworkStatusPersistence(BridgeNetworkStatus descriptor, String authorityFingerprint) {
        super(descriptor, Annotation.Status.bytes());
        this.calculatePaths(PersistenceUtils.dateTimeParts(descriptor.getPublishedMillis()), authorityFingerprint);
    }

    public BridgeNetworkStatusPersistence(byte[] descriptorBytes, String published, String authorityFingerprint) {
        super(descriptorBytes);
        this.calculatePaths(published.split("[ :-]"), authorityFingerprint);
    }

    private void calculatePaths(String[] publishedParts, String authorityFingerprint) {
        String fileOut = publishedParts[0] + publishedParts[1] + publishedParts[2] + "-" + publishedParts[3] + publishedParts[4] + publishedParts[5] + "-" + authorityFingerprint;
        this.recentPath = Paths.get("bridge-descriptors", STATUSES, fileOut).toString();
        this.storagePath = Paths.get("bridge-descriptors", publishedParts[0], publishedParts[1], STATUSES, publishedParts[2], fileOut).toString();
    }
}

