/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.collector.persist;

import java.nio.file.Paths;
import org.torproject.descriptor.BridgeExtraInfoDescriptor;
import org.torproject.metrics.collector.conf.Annotation;
import org.torproject.metrics.collector.persist.DescriptorPersistence;
import org.torproject.metrics.collector.persist.PersistenceUtils;

public class BridgeExtraInfoDescriptorPersistence
extends DescriptorPersistence<BridgeExtraInfoDescriptor> {
    public BridgeExtraInfoDescriptorPersistence(BridgeExtraInfoDescriptor descriptor, long received) {
        super(descriptor, Annotation.BridgeExtraInfo.bytes());
        this.calculatePaths(PersistenceUtils.dateTimeParts(descriptor.getPublishedMillis()), PersistenceUtils.dateTime(received), descriptor.getDigestSha1Hex().toLowerCase());
    }

    public BridgeExtraInfoDescriptorPersistence(byte[] descriptorBytes, String publishedString, String receivedString, String descriptorDigest) {
        super(descriptorBytes);
        this.calculatePaths(publishedString.split("[ :-]"), receivedString, descriptorDigest.toLowerCase());
    }

    private void calculatePaths(String[] publishedParts, String receivedString, String descriptorDigest) {
        this.recentPath = Paths.get("bridge-descriptors", "extra-infos", receivedString + "-" + "extra-infos").toString();
        this.storagePath = Paths.get("bridge-descriptors", publishedParts[0], publishedParts[1], "extra-infos", descriptorDigest.substring(0, 1), descriptorDigest.substring(1, 2), descriptorDigest).toString();
    }
}

