/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.collector.cron;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.metrics.collector.conf.Configuration;
import org.torproject.metrics.collector.conf.ConfigurationException;
import org.torproject.metrics.collector.conf.Key;
import org.torproject.metrics.collector.cron.CollecTorMain;

public final class Scheduler
implements ThreadFactory {
    public static final String ACTIVATED = "Activated";
    public static final String PERIODMIN = "PeriodMinutes";
    public static final String OFFSETMIN = "OffsetMinutes";
    private static final long MILLIS_IN_A_MINUTE = 60000L;
    private static final Logger logger = LoggerFactory.getLogger(Scheduler.class);
    private final ThreadFactory threads = Executors.defaultThreadFactory();
    private int currentThreadNo = 0;
    private long gracePeriodMinutes = 10L;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(10, this);
    private static Scheduler instance = new Scheduler();

    private Scheduler() {
    }

    public static Scheduler getInstance() {
        return instance;
    }

    public boolean scheduleModuleRuns(Map<Key, Class<? extends CollecTorMain>> collecTorMains, Configuration conf) {
        try {
            this.gracePeriodMinutes = conf.getLong(Key.ShutdownGraceWaitMinutes);
        }
        catch (ConfigurationException ce) {
            logger.warn("Cannot read grace period.", ce);
            this.gracePeriodMinutes = 10L;
        }
        ArrayList<Callable<Object>> runOnceMains = new ArrayList<Callable<Object>>();
        for (Map.Entry<Key, Class<? extends CollecTorMain>> ctmEntry : collecTorMains.entrySet()) {
            try {
                if (!conf.getBool(ctmEntry.getKey())) continue;
                String prefix = ctmEntry.getKey().name().replace(ACTIVATED, "");
                CollecTorMain ctm = ctmEntry.getValue().getConstructor(Configuration.class).newInstance(conf);
                if (conf.getBool(Key.RunOnce)) {
                    logger.info("Prepare single run for {}.", (Object)ctm.getClass().getName());
                    runOnceMains.add(Executors.callable(ctm));
                    continue;
                }
                this.scheduleExecutions(ctm, conf.getInt(Key.valueOf(prefix + OFFSETMIN)), conf.getInt(Key.valueOf(prefix + PERIODMIN)));
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | NullPointerException | InvocationTargetException | RejectedExecutionException | ConfigurationException ex) {
                logger.error("Cannot schedule {}. Reason: {}", ctmEntry.getValue().getName(), ex.getMessage(), ex);
            }
        }
        try {
            if (conf.getBool(Key.RunOnce)) {
                this.scheduler.invokeAll(runOnceMains);
                return false;
            }
        }
        catch (InterruptedException | NullPointerException | RejectedExecutionException | ConfigurationException ex) {
            logger.error("Cannot schedule run-once: {}", (Object)ex.getMessage(), (Object)ex);
        }
        return true;
    }

    private void scheduleExecutions(CollecTorMain ctm, int offset, int period) {
        logger.info("Periodic updater started for {}; offset={}, period={}.", ctm.getClass().getName(), offset, period);
        long periodMillis = (long)period * 60000L;
        long initialDelayMillis = Scheduler.computeInitialDelayMillis(System.currentTimeMillis(), (long)offset * 60000L, periodMillis);
        logger.info("Periodic updater will first run in {} and then every {} minutes.", (Object)(initialDelayMillis < 60000L ? "under 1 minute" : initialDelayMillis / 60000L + " minute(s)"), (Object)period);
        this.scheduler.scheduleAtFixedRate(ctm, initialDelayMillis, periodMillis, TimeUnit.MILLISECONDS);
    }

    protected static long computeInitialDelayMillis(long currentMillis, long offsetMillis, long periodMillis) {
        return (periodMillis - currentMillis % periodMillis + offsetMillis) % periodMillis;
    }

    public void shutdownScheduler() {
        block2: {
            try {
                logger.info("Waiting at most {} minutes for termination of running tasks ... ", (Object)this.gracePeriodMinutes);
                this.scheduler.shutdown();
                this.scheduler.awaitTermination(this.gracePeriodMinutes, TimeUnit.MINUTES);
                logger.info("Shutdown of all scheduled tasks completed successfully.");
            }
            catch (InterruptedException ie) {
                List<Runnable> notTerminated = this.scheduler.shutdownNow();
                logger.error("Regular shutdown failed for: {}", (Object)notTerminated);
                if (notTerminated.isEmpty()) break block2;
                logger.error("Forced shutdown failed for: {}", (Object)notTerminated);
            }
        }
    }

    @Override
    public Thread newThread(Runnable runner) {
        Thread newThread = this.threads.newThread(runner);
        newThread.setDaemon(true);
        newThread.setName("CollecTor-Scheduled-Thread-" + ++this.currentThreadNo);
        logger.info("New Thread created: {}", (Object)newThread.getName());
        return newThread;
    }
}

