/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.collector.conf;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.EnumSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.torproject.metrics.collector.conf.ConfigurationException;
import org.torproject.metrics.collector.conf.Key;
import org.torproject.metrics.collector.conf.SourceType;

public class Configuration {
    public static final String FIELDSEP = ",";
    private final Properties props = new Properties();

    public void loadAndCheckConfiguration(Path confPath) throws ConfigurationException {
        try (FileInputStream fis = new FileInputStream(confPath.toFile());){
            this.props.load(fis);
            this.anythingActivated();
        }
        catch (IOException e) {
            throw new ConfigurationException("Cannot load configuration file. Reason: " + e.getMessage(), e);
        }
    }

    private void anythingActivated() throws ConfigurationException {
        if (!(this.getBool(Key.RelaydescsActivated) || this.getBool(Key.BridgedescsActivated) || this.getBool(Key.BridgePoolAssignmentsActivated) || this.getBool(Key.BridgedbMetricsActivated) || this.getBool(Key.BridgestrapStatsActivated) || this.getBool(Key.ExitlistsActivated) || this.getBool(Key.UpdateindexActivated) || this.getBool(Key.OnionPerfActivated) || this.getBool(Key.SnowflakeStatsActivated) || this.getBool(Key.WebstatsActivated))) {
            throw new ConfigurationException("Nothing is activated!\nPlease edit collector.properties. Exiting.");
        }
    }

    public Properties getPropertiesCopy() {
        return (Properties)this.props.clone();
    }

    public void load(InputStream fis) throws IOException {
        this.props.load(fis);
    }

    public String getProperty(String key) {
        return this.props.getProperty(key);
    }

    public String getProperty(String key, String def) {
        return this.props.getProperty(key, def);
    }

    public void setProperty(String key, String value) {
        this.props.setProperty(key, value);
    }

    public void clear() {
        this.props.clear();
    }

    public void putAll(Properties allProps) {
        this.props.putAll((Map<?, ?>)allProps);
    }

    public int size() {
        return this.props.size();
    }

    public String[] getStringArray(Key key) throws ConfigurationException {
        try {
            this.checkClass(key, String[].class);
            String[] res = this.props.getProperty(key.name()).split(FIELDSEP);
            for (int i = 0; i < res.length; ++i) {
                res[i] = res[i].trim();
            }
            return res;
        }
        catch (RuntimeException re) {
            throw new ConfigurationException("Corrupt property: " + (Object)((Object)key) + " reason: " + re.getMessage(), re);
        }
    }

    private void checkClass(Key key, Class clazz) {
        if (!key.keyClass().getSimpleName().equals(clazz.getSimpleName())) {
            throw new RuntimeException("Wrong type wanted! My class is " + key.keyClass().getSimpleName());
        }
    }

    public boolean getBool(Key key) throws ConfigurationException {
        try {
            this.checkClass(key, Boolean.class);
            return Boolean.parseBoolean(this.props.getProperty(key.name()));
        }
        catch (RuntimeException re) {
            throw new ConfigurationException("Corrupt property: " + (Object)((Object)key) + " reason: " + re.getMessage(), re);
        }
    }

    public int getInt(Key key) throws ConfigurationException {
        try {
            this.checkClass(key, Integer.class);
            String prop = this.props.getProperty(key.name());
            if ("inf".equals(prop)) {
                return Integer.MAX_VALUE;
            }
            return Integer.parseInt(prop);
        }
        catch (RuntimeException re) {
            throw new ConfigurationException("Corrupt property: " + (Object)((Object)key) + " reason: " + re.getMessage(), re);
        }
    }

    public long getLong(Key key) throws ConfigurationException {
        try {
            this.checkClass(key, Long.class);
            String prop = this.props.getProperty(key.name());
            return Long.parseLong(prop);
        }
        catch (RuntimeException re) {
            throw new ConfigurationException("Corrupt property: " + (Object)((Object)key) + " reason: " + re.getMessage(), re);
        }
    }

    public Path getPath(Key key) throws ConfigurationException {
        try {
            this.checkClass(key, Path.class);
            return Paths.get(this.props.getProperty(key.name()), new String[0]);
        }
        catch (RuntimeException re) {
            throw new ConfigurationException("Corrupt property: " + (Object)((Object)key) + " reason: " + re.getMessage(), re);
        }
    }

    public Set<SourceType> getSourceTypeSet(Key key) throws ConfigurationException {
        EnumSet<SourceType> res = null;
        try {
            String[] interim;
            this.checkClass(key, SourceType[].class);
            for (String anInterim : interim = this.props.getProperty(key.name()).split(FIELDSEP)) {
                SourceType st = SourceType.valueOf(anInterim.trim());
                if (null == res) {
                    res = EnumSet.of(st);
                    continue;
                }
                res.add(st);
            }
            return res;
        }
        catch (RuntimeException re) {
            throw new ConfigurationException("Corrupt property: " + (Object)((Object)key) + " reason: " + re.getMessage(), re);
        }
    }

    public URL getUrl(Key key) throws ConfigurationException {
        try {
            this.checkClass(key, URL.class);
            return new URL(this.props.getProperty(key.name()));
        }
        catch (RuntimeException | MalformedURLException mue) {
            throw new ConfigurationException("Corrupt property: " + (Object)((Object)key) + " reason: " + mue.getMessage(), mue);
        }
    }

    public URL[] getUrlArray(Key key) throws ConfigurationException {
        try {
            this.checkClass(key, URL[].class);
            String[] interim = this.props.getProperty(key.name()).split(FIELDSEP);
            URL[] res = new URL[interim.length];
            for (int i = 0; i < interim.length; ++i) {
                res[i] = new URL(interim[i].trim());
            }
            return res;
        }
        catch (RuntimeException | MalformedURLException re) {
            throw new ConfigurationException("Corrupt property: " + (Object)((Object)key) + " reason: " + re.getMessage(), re);
        }
    }
}

