/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.collector.bridgestrap;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.SortedSet;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.descriptor.BridgestrapStats;
import org.torproject.descriptor.Descriptor;
import org.torproject.descriptor.DescriptorParser;
import org.torproject.descriptor.DescriptorSourceFactory;
import org.torproject.metrics.collector.conf.Annotation;
import org.torproject.metrics.collector.conf.Configuration;
import org.torproject.metrics.collector.conf.ConfigurationException;
import org.torproject.metrics.collector.conf.Key;
import org.torproject.metrics.collector.cron.CollecTorMain;
import org.torproject.metrics.collector.downloader.Downloader;
import org.torproject.metrics.collector.persist.BridgestrapStatsPersistence;
import org.torproject.metrics.collector.persist.PersistenceUtils;

public class BridgestrapStatsDownloader
extends CollecTorMain {
    private static final Logger logger = LoggerFactory.getLogger(BridgestrapStatsDownloader.class);
    private String recentPathName;
    private String outputPathName;

    public BridgestrapStatsDownloader(Configuration config) {
        super(config);
        this.mapPathDescriptors.put("recent/bridgestrap", BridgestrapStats.class);
    }

    @Override
    public String module() {
        return "BridgestrapStats";
    }

    @Override
    protected String syncMarker() {
        return "BridgestrapStats";
    }

    @Override
    protected void startProcessing() throws ConfigurationException {
        byte[] downloadedBytes;
        this.recentPathName = this.config.getPath(Key.RecentPath).toString();
        logger.debug("Downloading bridgestrap stats...");
        URL url = this.config.getUrl(Key.BridgestrapStatsUrl);
        try {
            downloadedBytes = Downloader.downloadFromHttpServer(url);
        }
        catch (IOException e) {
            logger.warn("Failed downloading {}.", (Object)url, (Object)e);
            return;
        }
        if (null == downloadedBytes) {
            logger.warn("Could not download {}.", (Object)url);
            return;
        }
        logger.debug("Finished downloading {}.", (Object)url);
        Path parsedBridgestrapStatsFile = this.config.getPath(Key.StatsPath).resolve("processed-bridgestrap-stats");
        SortedSet<Path> previouslyProcessedFiles = this.readProcessedFiles(parsedBridgestrapStatsFile);
        TreeSet<Path> processedFiles = new TreeSet<Path>();
        DescriptorParser descriptorParser = DescriptorSourceFactory.createDescriptorParser();
        TreeSet<LocalDateTime> bridgestrapStatsEnds = new TreeSet<LocalDateTime>();
        this.outputPathName = this.config.getPath(Key.OutputPath).toString();
        for (Descriptor descriptor : descriptorParser.parseDescriptors(downloadedBytes, null, null)) {
            File[] outputFiles;
            if (!(descriptor instanceof BridgestrapStats)) continue;
            BridgestrapStats bridgestrapStats = (BridgestrapStats)descriptor;
            LocalDateTime bridgestrapStatsEnd = bridgestrapStats.bridgestrapStatsEnd();
            bridgestrapStatsEnds.add(bridgestrapStatsEnd);
            BridgestrapStatsPersistence persistence = new BridgestrapStatsPersistence(bridgestrapStats);
            File tarballFile = new File(this.outputPathName + "/" + persistence.getStoragePath());
            Path relativeFileName = Paths.get(tarballFile.getName(), new String[0]);
            processedFiles.add(relativeFileName);
            if (previouslyProcessedFiles.contains(relativeFileName) || tarballFile.exists()) continue;
            File rsyncFile = new File(this.recentPathName + "/" + persistence.getRecentPath());
            for (File outputFile : outputFiles = new File[]{tarballFile, rsyncFile}) {
                this.writeToFile(outputFile, Annotation.BridgestrapStats.bytes(), bridgestrapStats.getRawDescriptorBytes());
            }
        }
        if (bridgestrapStatsEnds.isEmpty()) {
            logger.warn("Could not parse downloaded bridgestrap stats.");
            return;
        }
        if (((LocalDateTime)bridgestrapStatsEnds.last()).isBefore(LocalDateTime.now().minusHours(48L))) {
            logger.warn("The latest bridgestrap stats are older than 48 hours: {}.", bridgestrapStatsEnds.last());
        }
        this.writeProcessedFiles(parsedBridgestrapStatsFile, processedFiles);
        this.cleanUpDirectories();
    }

    private void writeToFile(File outputFile, byte[] ... bytes) {
        try {
            if (!outputFile.getParentFile().exists() && !outputFile.getParentFile().mkdirs()) {
                logger.warn("Could not create parent directories of {}.", (Object)outputFile);
                return;
            }
            FileOutputStream os = new FileOutputStream(outputFile);
            for (byte[] b : bytes) {
                ((OutputStream)os).write(b);
            }
            ((OutputStream)os).close();
        }
        catch (IOException e) {
            logger.warn("Could not write downloaded bridgestrap stats to {}", (Object)outputFile.getAbsolutePath(), (Object)e);
        }
    }

    private void cleanUpDirectories() {
        PersistenceUtils.cleanDirectory(Paths.get(this.recentPathName, "bridgestrap"), Instant.now().minus(3L, ChronoUnit.DAYS).toEpochMilli());
        PersistenceUtils.cleanDirectory(Paths.get(this.outputPathName, "bridgestrap"), Instant.now().minus(49L, ChronoUnit.DAYS).toEpochMilli());
    }
}

