/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.collector.bridgedescs;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.HashSet;
import java.util.Stack;
import java.util.TreeSet;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.descriptor.BridgeExtraInfoDescriptor;
import org.torproject.descriptor.BridgeNetworkStatus;
import org.torproject.descriptor.BridgeServerDescriptor;
import org.torproject.metrics.collector.bridgedescs.SanitizedBridgeExtraInfoDescriptor;
import org.torproject.metrics.collector.bridgedescs.SanitizedBridgeNetworkStatus;
import org.torproject.metrics.collector.bridgedescs.SanitizedBridgeServerDescriptor;
import org.torproject.metrics.collector.bridgedescs.SensitivePartsSanitizer;
import org.torproject.metrics.collector.conf.Configuration;
import org.torproject.metrics.collector.conf.ConfigurationException;
import org.torproject.metrics.collector.conf.Key;
import org.torproject.metrics.collector.cron.CollecTorMain;
import org.torproject.metrics.collector.persist.BridgeExtraInfoDescriptorPersistence;
import org.torproject.metrics.collector.persist.BridgeNetworkStatusPersistence;
import org.torproject.metrics.collector.persist.BridgeServerDescriptorPersistence;
import org.torproject.metrics.collector.persist.PersistenceUtils;

public class SanitizedBridgesWriter
extends CollecTorMain {
    private static final Logger logger = LoggerFactory.getLogger(SanitizedBridgesWriter.class);
    private String rsyncCatString;
    private Path outputDirectory;
    private Path recentDirectory;
    private SensitivePartsSanitizer sensitivePartsSanitizer;
    private String maxNetworkStatusPublishedTime = null;
    private String maxServerDescriptorPublishedTime = null;
    private String maxExtraInfoDescriptorPublishedTime = null;

    public SanitizedBridgesWriter(Configuration config) {
        super(config);
        this.mapPathDescriptors.put("recent/bridge-descriptors/statuses", BridgeNetworkStatus.class);
        this.mapPathDescriptors.put("recent/bridge-descriptors/server-descriptors", BridgeServerDescriptor.class);
        this.mapPathDescriptors.put("recent/bridge-descriptors/extra-infos", BridgeExtraInfoDescriptor.class);
    }

    @Override
    public String module() {
        return "bridgedescs";
    }

    @Override
    protected String syncMarker() {
        return "Bridge";
    }

    @Override
    protected void startProcessing() throws ConfigurationException {
        this.outputDirectory = this.config.getPath(Key.OutputPath);
        this.recentDirectory = this.config.getPath(Key.RecentPath);
        Path inputDirectory = this.config.getPath(Key.BridgeLocalOrigins);
        Path statsDirectory = this.config.getPath(Key.StatsPath);
        boolean replaceIpAddressesWithHashes = this.config.getBool(Key.ReplaceIpAddressesWithHashes);
        DateTimeFormatter rsyncCatFormat = DateTimeFormatter.ofPattern("uuuu-MM-dd-HH-mm-ss");
        this.rsyncCatString = LocalDateTime.now().format(rsyncCatFormat);
        Path bridgeIpSecretsFile = statsDirectory.resolve("bridge-ip-secrets");
        if (replaceIpAddressesWithHashes) {
            long limitBridgeSanitizingIntervalDays = this.config.getInt(Key.BridgeDescriptorMappingsLimit);
            this.sensitivePartsSanitizer = new SensitivePartsSanitizer(bridgeIpSecretsFile, limitBridgeSanitizingIntervalDays);
        } else {
            this.sensitivePartsSanitizer = new SensitivePartsSanitizer();
        }
        this.readBridgeSnapshots(inputDirectory, statsDirectory);
        if (replaceIpAddressesWithHashes) {
            this.sensitivePartsSanitizer.finishWriting();
        }
        this.checkStaleDescriptors();
        this.cleanUpDirectories();
    }

    private void readBridgeSnapshots(Path bridgeDirectoriesDir, Path statsDirectory) {
        if (bridgeDirectoriesDir == null || statsDirectory == null) {
            throw new IllegalArgumentException();
        }
        TreeSet<String> parsed = new TreeSet<String>();
        Path pbdFile = statsDirectory.resolve("parsed-bridge-directories");
        boolean modified = false;
        if (Files.exists(bridgeDirectoriesDir, new LinkOption[0])) {
            if (Files.exists(pbdFile, new LinkOption[0])) {
                logger.debug("Reading file {}...", (Object)pbdFile);
                try {
                    parsed.addAll(Files.readAllLines(pbdFile));
                    logger.debug("Finished reading file {}.", (Object)pbdFile);
                }
                catch (IOException e) {
                    logger.warn("Failed reading file {}!", (Object)pbdFile, (Object)e);
                    return;
                }
            }
            logger.debug("Importing files in directory {}/...", (Object)bridgeDirectoriesDir);
            HashSet<String> descriptorImportHistory = new HashSet<String>();
            int parsedFiles = 0;
            int skippedFiles = 0;
            int parsedStatuses = 0;
            int parsedServerDescriptors = 0;
            int skippedServerDescriptors = 0;
            int parsedExtraInfoDescriptors = 0;
            int skippedExtraInfoDescriptors = 0;
            Stack<Path> filesInInputDir = new Stack<Path>();
            filesInInputDir.add(bridgeDirectoriesDir);
            block26: while (!filesInInputDir.isEmpty()) {
                Path pop = (Path)filesInInputDir.pop();
                String fn = pop.getFileName().toString();
                if (Files.isDirectory(pop, new LinkOption[0])) {
                    try {
                        Files.list(pop).forEachOrdered(filesInInputDir::add);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (parsed.contains(pop.getFileName().toString())) continue;
                try {
                    InputStream in = Files.newInputStream(pop, new OpenOption[0]);
                    try {
                        if (in.available() > 0) {
                            String authorityFingerprint;
                            TarArchiveInputStream tais;
                            if (fn.endsWith(".tar.gz")) {
                                GzipCompressorInputStream gcis = new GzipCompressorInputStream(in);
                                tais = new TarArchiveInputStream(gcis);
                            } else {
                                if (!fn.endsWith(".tar")) continue;
                                tais = new TarArchiveInputStream(in);
                            }
                            BufferedInputStream bis = new BufferedInputStream(tais);
                            String[] fnParts = fn.split("-");
                            if (fnParts.length != 5) {
                                logger.warn("Invalid bridge descriptor tarball file name: {}. Skipping.", (Object)fn);
                                continue;
                            }
                            String authorityPart = String.format("%s-%s-", fnParts[0], fnParts[1]);
                            String datePart = String.format("%s-%s-%s", fnParts[2], fnParts[3], fnParts[4]);
                            switch (authorityPart) {
                                case "from-tonga-": {
                                    authorityFingerprint = "4A0CCD2DDC7995083D73F5D667100C8A5831F16D";
                                    break;
                                }
                                case "from-bifroest-": {
                                    authorityFingerprint = "1D8F3A91C37C5D1C4C19B1AD1D0CFBE8BF72D8E1";
                                    break;
                                }
                                case "from-serge-": {
                                    authorityFingerprint = "BA44A889E64B93FAA2B114E02C2A279A8555C533";
                                    break;
                                }
                                default: {
                                    logger.warn("Did not recognize the bridge authority that generated {}. Skipping.", (Object)fn);
                                    continue block26;
                                }
                            }
                            String dateTime = datePart.substring(0, 10) + " " + datePart.substring(11, 13) + ":" + datePart.substring(13, 15) + ":" + datePart.substring(15, 17);
                            while (tais.getNextTarEntry() != null) {
                                String firstLine;
                                int len;
                                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                                byte[] data = new byte[1024];
                                while ((len = bis.read(data, 0, 1024)) >= 0) {
                                    baos.write(data, 0, len);
                                }
                                byte[] allData = baos.toByteArray();
                                if (allData.length == 0) continue;
                                String fileDigest = Hex.encodeHexString(DigestUtils.sha1(allData));
                                String ascii = new String(allData, StandardCharsets.US_ASCII);
                                BufferedReader br3 = new BufferedReader(new StringReader(ascii));
                                while ((firstLine = br3.readLine()) != null && firstLine.startsWith("@")) {
                                }
                                if (firstLine == null) continue;
                                if (firstLine.startsWith("published ") || firstLine.startsWith("flag-thresholds ") || firstLine.startsWith("r ")) {
                                    this.sanitizeAndStoreNetworkStatus(allData, dateTime, authorityFingerprint);
                                    ++parsedStatuses;
                                } else {
                                    int sig;
                                    int start;
                                    if (descriptorImportHistory.contains(fileDigest)) {
                                        ++skippedFiles;
                                        continue;
                                    }
                                    int end = -1;
                                    String startToken = firstLine.startsWith("router ") ? "router " : "extra-info ";
                                    String sigToken = "\nrouter-signature\n";
                                    String endToken = "\n-----END SIGNATURE-----\n";
                                    while (end < ascii.length() && (start = ascii.indexOf(startToken, end)) >= 0 && (sig = ascii.indexOf(sigToken, start)) >= 0 && (end = ascii.indexOf(endToken, sig += sigToken.length())) >= 0) {
                                        byte[] descBytes = new byte[(end += endToken.length()) - start];
                                        System.arraycopy(allData, start, descBytes, 0, end - start);
                                        String descriptorDigest = Hex.encodeHexString(DigestUtils.sha1(descBytes));
                                        if (!descriptorImportHistory.contains(descriptorDigest)) {
                                            descriptorImportHistory.add(descriptorDigest);
                                            if (firstLine.startsWith("router ")) {
                                                this.sanitizeAndStoreServerDescriptor(descBytes);
                                                ++parsedServerDescriptors;
                                                continue;
                                            }
                                            this.sanitizeAndStoreExtraInfoDescriptor(descBytes);
                                            ++parsedExtraInfoDescriptors;
                                            continue;
                                        }
                                        if (firstLine.startsWith("router ")) {
                                            ++skippedServerDescriptors;
                                            continue;
                                        }
                                        ++skippedExtraInfoDescriptors;
                                    }
                                }
                                descriptorImportHistory.add(fileDigest);
                                ++parsedFiles;
                            }
                            bis.close();
                        }
                        System.gc();
                        parsed.add(fn);
                        modified = true;
                    }
                    finally {
                        if (in == null) continue;
                        in.close();
                    }
                }
                catch (IOException e) {
                    logger.warn("Could not parse bridge snapshot {}!", (Object)pop, (Object)e);
                }
            }
            logger.debug("Finished importing files in directory {}/. In total, we parsed {} files (skipped {}) containing {} statuses, {} server descriptors (skipped {}), and {} extra-info descriptors (skipped {}).", bridgeDirectoriesDir, parsedFiles, skippedFiles, parsedStatuses, parsedServerDescriptors, skippedServerDescriptors, parsedExtraInfoDescriptors, skippedExtraInfoDescriptors);
            if (!parsed.isEmpty() && modified) {
                logger.debug("Writing file {}...", (Object)pbdFile);
                try {
                    Files.createDirectories(pbdFile.getParent(), new FileAttribute[0]);
                    Files.write(pbdFile, parsed, new OpenOption[0]);
                    logger.debug("Finished writing file {}.", (Object)pbdFile);
                }
                catch (IOException e) {
                    logger.warn("Failed writing file {}!", (Object)pbdFile, (Object)e);
                }
            }
        }
    }

    public void sanitizeAndStoreNetworkStatus(byte[] data, String publicationTime, String authorityFingerprint) {
        SanitizedBridgeNetworkStatus sanitizedBridgeNetworkStatus = new SanitizedBridgeNetworkStatus(data, this.sensitivePartsSanitizer, publicationTime, authorityFingerprint);
        if (!sanitizedBridgeNetworkStatus.sanitizeDescriptor()) {
            logger.warn("Unable to sanitize bridge network status.");
            return;
        }
        byte[] scrubbedBytes = sanitizedBridgeNetworkStatus.getSanitizedBytes();
        publicationTime = sanitizedBridgeNetworkStatus.getPublishedString();
        if (null == this.maxNetworkStatusPublishedTime || publicationTime.compareTo(this.maxNetworkStatusPublishedTime) > 0) {
            this.maxNetworkStatusPublishedTime = publicationTime;
        }
        new BridgeNetworkStatusPersistence(scrubbedBytes, publicationTime, authorityFingerprint).storeAll(this.recentDirectory, this.outputDirectory);
    }

    public void sanitizeAndStoreServerDescriptor(byte[] data) {
        SanitizedBridgeServerDescriptor sanitizedBridgeServerDescriptor = new SanitizedBridgeServerDescriptor(data, this.sensitivePartsSanitizer);
        if (!sanitizedBridgeServerDescriptor.sanitizeDescriptor()) {
            logger.warn("Unable to sanitize bridge server descriptor.");
            return;
        }
        byte[] scrubbedBytes = sanitizedBridgeServerDescriptor.getSanitizedBytes();
        String published = sanitizedBridgeServerDescriptor.getPublishedString();
        if (null == this.maxServerDescriptorPublishedTime || published.compareTo(this.maxServerDescriptorPublishedTime) > 0) {
            this.maxServerDescriptorPublishedTime = published;
        }
        String descriptorDigest = sanitizedBridgeServerDescriptor.getDescriptorDigest();
        new BridgeServerDescriptorPersistence(scrubbedBytes, published, this.rsyncCatString, descriptorDigest).storeAll(this.recentDirectory, this.outputDirectory);
    }

    public void sanitizeAndStoreExtraInfoDescriptor(byte[] data) {
        SanitizedBridgeExtraInfoDescriptor sanitizedBridgeExtraInfoDescriptor = new SanitizedBridgeExtraInfoDescriptor(data, this.sensitivePartsSanitizer);
        if (!sanitizedBridgeExtraInfoDescriptor.sanitizeDescriptor()) {
            logger.warn("Unable to sanitize bridge extra-info descriptor.");
            return;
        }
        byte[] scrubbedBytes = sanitizedBridgeExtraInfoDescriptor.getSanitizedBytes();
        String published = sanitizedBridgeExtraInfoDescriptor.getPublishedString();
        if (null == this.maxExtraInfoDescriptorPublishedTime || published.compareTo(this.maxExtraInfoDescriptorPublishedTime) > 0) {
            this.maxExtraInfoDescriptorPublishedTime = published;
        }
        String descriptorDigest = sanitizedBridgeExtraInfoDescriptor.getDescriptorDigest();
        new BridgeExtraInfoDescriptorPersistence(scrubbedBytes, published, this.rsyncCatString, descriptorDigest).storeAll(this.recentDirectory, this.outputDirectory);
    }

    private void checkStaleDescriptors() {
        LocalDateTime maxExtraInfoDescriptorPublished;
        LocalDateTime maxServerDescriptorPublished;
        LocalDateTime maxNetworkStatusPublished;
        DateTimeFormatter dateTimeFormat = DateTimeFormatter.ofPattern("uuuu-MM-dd HH:mm:ss");
        LocalDateTime tooOld = LocalDateTime.now().minusMinutes(330L);
        if (null != this.maxNetworkStatusPublishedTime && (maxNetworkStatusPublished = LocalDateTime.parse(this.maxNetworkStatusPublishedTime, dateTimeFormat)).isBefore(tooOld)) {
            logger.warn("The last known bridge network status was published {}, which is more than 5:30 hours in the past.", (Object)this.maxNetworkStatusPublishedTime);
        }
        if (null != this.maxServerDescriptorPublishedTime && (maxServerDescriptorPublished = LocalDateTime.parse(this.maxServerDescriptorPublishedTime, dateTimeFormat)).isBefore(tooOld)) {
            logger.warn("The last known bridge server descriptor was published {}, which is more than 5:30 hours in the past.", (Object)this.maxServerDescriptorPublishedTime);
        }
        if (null != this.maxExtraInfoDescriptorPublishedTime && (maxExtraInfoDescriptorPublished = LocalDateTime.parse(this.maxExtraInfoDescriptorPublishedTime, dateTimeFormat)).isBefore(tooOld)) {
            logger.warn("The last known bridge extra-info descriptor was published {}, which is more than 5:30 hours in the past.", (Object)this.maxExtraInfoDescriptorPublishedTime);
        }
    }

    private void cleanUpDirectories() {
        PersistenceUtils.cleanDirectory(this.recentDirectory.resolve("bridge-descriptors"), Instant.now().minus(3L, ChronoUnit.DAYS).toEpochMilli());
        PersistenceUtils.cleanDirectory(this.outputDirectory.resolve("bridge-descriptors"), Instant.now().minus(49L, ChronoUnit.DAYS).toEpochMilli());
    }
}

