/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.collector.bridgedescs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.metrics.collector.bridgedescs.DescriptorBuilder;
import org.torproject.metrics.collector.bridgedescs.SanitizedBridgeDescriptor;
import org.torproject.metrics.collector.bridgedescs.SensitivePartsSanitizer;
import org.torproject.metrics.collector.conf.Annotation;

public class SanitizedBridgeServerDescriptor
extends SanitizedBridgeDescriptor {
    private static final Logger logger = LoggerFactory.getLogger(SanitizedBridgeServerDescriptor.class);
    private String descriptorDigest;

    SanitizedBridgeServerDescriptor(byte[] originalBytes, SensitivePartsSanitizer sensitivePartsSanitizer) {
        super(originalBytes, sensitivePartsSanitizer);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    boolean sanitizeDescriptor() {
        if (this.sensitivePartsSanitizer.hasPersistenceProblemWithSecrets()) {
            return false;
        }
        String address = null;
        byte[] fingerprintBytes = null;
        StringBuilder scrubbedAddress = null;
        HashMap<StringBuilder, String> scrubbedTcpPorts = new HashMap<StringBuilder, String>();
        HashMap<StringBuilder, String> scrubbedIpAddressesAndTcpPorts = new HashMap<StringBuilder, String>();
        String masterKeyEd25519FromIdentityEd25519 = null;
        DescriptorBuilder scrubbed = new DescriptorBuilder();
        try (BufferedReader br = new BufferedReader(new StringReader(new String(this.originalBytes, StandardCharsets.US_ASCII)));){
            String line;
            scrubbed.append(Annotation.BridgeServer.toString());
            String masterKeyEd25519 = null;
            boolean skipCrypto = false;
            while ((line = br.readLine()) != null) {
                String[] parts;
                if (skipCrypto && !line.startsWith("-----END ")) continue;
                if (line.startsWith("router ")) {
                    parts = line.split(" ");
                    if (parts.length != 6) {
                        logger.warn("Invalid router line: '{}'.  Skipping.", (Object)line);
                        boolean bl = false;
                        return bl;
                    }
                    address = parts[2];
                    scrubbedAddress = new StringBuilder();
                    StringBuilder scrubbedOrPort = new StringBuilder();
                    scrubbedTcpPorts.put(scrubbedOrPort, parts[3]);
                    StringBuilder scrubbedDirPort = new StringBuilder();
                    scrubbedTcpPorts.put(scrubbedDirPort, parts[4]);
                    StringBuilder scrubbedSocksPort = new StringBuilder();
                    scrubbedTcpPorts.put(scrubbedSocksPort, parts[5]);
                    scrubbed.append("router ").append(parts[1]).space().append(scrubbedAddress).space().append(scrubbedOrPort).space().append(scrubbedDirPort).space().append(scrubbedSocksPort).newLine();
                    continue;
                }
                if (line.startsWith("or-address ")) {
                    String orAddress = line.substring("or-address ".length());
                    StringBuilder scrubbedOrAddress = new StringBuilder();
                    scrubbedIpAddressesAndTcpPorts.put(scrubbedOrAddress, orAddress);
                    scrubbed.append("or-address ").append(scrubbedOrAddress).newLine();
                    continue;
                }
                if (line.startsWith("published ")) {
                    this.publishedString = line.substring("published ".length());
                    scrubbed.append(line).newLine();
                    continue;
                }
                if (line.startsWith("opt fingerprint ") || line.startsWith("fingerprint ")) {
                    String fingerprint = line.substring(line.startsWith("opt ") ? "opt fingerprint".length() : "fingerprint".length()).replaceAll(" ", "").toLowerCase();
                    fingerprintBytes = Hex.decodeHex(fingerprint.toCharArray());
                    String hashedBridgeIdentity = DigestUtils.sha1Hex(fingerprintBytes).toLowerCase();
                    scrubbed.append(line.startsWith("opt ") ? "opt " : "").append("fingerprint");
                    for (int i = 0; i < hashedBridgeIdentity.length() / 4; ++i) {
                        scrubbed.space().append(hashedBridgeIdentity.substring(4 * i, 4 * (i + 1)).toUpperCase());
                    }
                    scrubbed.newLine();
                    continue;
                }
                if (line.startsWith("contact ")) {
                    scrubbed.append("contact somebody").newLine();
                    continue;
                }
                if (line.startsWith("router-signature")) {
                    break;
                }
                if (line.startsWith("opt extra-info-digest ") || line.startsWith("extra-info-digest ")) {
                    parts = line.split(" ");
                    if (line.startsWith("opt ")) {
                        scrubbed.append("opt ");
                        parts = line.substring(4).split(" ");
                    }
                    if (parts.length > 3) {
                        logger.warn("extra-info-digest line contains more arguments thanexpected: '{}'.  Skipping descriptor.", (Object)line);
                        boolean hashedBridgeIdentity = false;
                        return hashedBridgeIdentity;
                    }
                    scrubbed.append("extra-info-digest ").append(DigestUtils.sha1Hex(Hex.decodeHex(parts[1].toCharArray())).toUpperCase());
                    if (parts.length > 2) {
                        if (!Base64.isBase64(parts[2])) {
                            logger.warn("Illegal base64 character in extra-info-digest line '{}'.  Skipping descriptor.", (Object)line);
                            boolean hashedBridgeIdentity = false;
                            return hashedBridgeIdentity;
                        }
                        scrubbed.space().append(Base64.encodeBase64String(DigestUtils.sha256(Base64.decodeBase64(parts[2]))).replaceAll("=", ""));
                    }
                    scrubbed.newLine();
                    continue;
                }
                if (line.startsWith("reject ")) {
                    if (address != null && line.startsWith("reject " + address)) {
                        scrubbed.append("reject ").append(scrubbedAddress).append(line.substring("reject ".length() + address.length())).newLine();
                        continue;
                    }
                    scrubbed.append(line).newLine();
                    continue;
                }
                if (line.equals("identity-ed25519")) {
                    StringBuilder sb = new StringBuilder();
                    while ((line = br.readLine()) != null && !line.equals("-----END ED25519 CERT-----")) {
                        if (line.equals("-----BEGIN ED25519 CERT-----")) continue;
                        sb.append(line);
                    }
                    masterKeyEd25519FromIdentityEd25519 = this.parseMasterKeyEd25519FromIdentityEd25519(sb.toString());
                    if (masterKeyEd25519FromIdentityEd25519 == null) {
                        logger.warn("Could not parse master-key-ed25519 from identity-ed25519.  Skipping descriptor.");
                        boolean hashedBridgeIdentity = false;
                        return hashedBridgeIdentity;
                    }
                    String sha256MasterKeyEd25519 = Base64.encodeBase64String(DigestUtils.sha256(Base64.decodeBase64(masterKeyEd25519FromIdentityEd25519 + "="))).replaceAll("=", "");
                    scrubbed.append("master-key-ed25519 ").append(sha256MasterKeyEd25519).newLine();
                    if (masterKeyEd25519 == null || masterKeyEd25519.equals(masterKeyEd25519FromIdentityEd25519)) continue;
                    logger.warn("Mismatch between identity-ed25519 and master-key-ed25519.  Skipping.");
                    boolean bl = false;
                    return bl;
                }
                if (line.startsWith("master-key-ed25519 ")) {
                    masterKeyEd25519 = line.substring(line.indexOf(" ") + 1);
                    if (masterKeyEd25519FromIdentityEd25519 == null || masterKeyEd25519FromIdentityEd25519.equals(masterKeyEd25519)) continue;
                    logger.warn("Mismatch between identity-ed25519 and master-key-ed25519.  Skipping.");
                    boolean sb = false;
                    return sb;
                }
                if (line.startsWith("accept ") || line.startsWith("platform ") || line.startsWith("opt protocols ") || line.startsWith("protocols ") || line.startsWith("proto ") || line.startsWith("uptime ") || line.startsWith("bandwidth ") || line.startsWith("opt hibernating ") || line.startsWith("hibernating ") || line.startsWith("ntor-onion-key ") || line.equals("opt hidden-service-dir") || line.equals("hidden-service-dir") || line.equals("opt caches-extra-info") || line.equals("caches-extra-info") || line.equals("opt allow-single-hop-exits") || line.equals("allow-single-hop-exits") || line.startsWith("ipv6-policy ") || line.equals("tunnelled-dir-server") || line.startsWith("bridge-distribution-request ")) {
                    scrubbed.append(line).newLine();
                    continue;
                }
                if (line.startsWith("overload-general 1 ")) {
                    scrubbed.append(line).newLine();
                    continue;
                }
                if (line.startsWith("family ")) {
                    DescriptorBuilder familyLine = new DescriptorBuilder("family");
                    for (String s : line.substring(7).split(" ")) {
                        if (s.startsWith("$")) {
                            familyLine.append(" $").append(DigestUtils.sha1Hex(Hex.decodeHex(s.substring(1).toCharArray())).toUpperCase());
                            continue;
                        }
                        familyLine.space().append(s);
                    }
                    scrubbed.append(familyLine.toString()).newLine();
                    continue;
                }
                if (line.startsWith("@purpose ")) continue;
                if (line.startsWith("-----BEGIN ") || line.equals("onion-key") || line.equals("signing-key") || line.equals("onion-key-crosscert") || line.startsWith("ntor-onion-key-crosscert ")) {
                    skipCrypto = true;
                    continue;
                }
                if (line.startsWith("-----END ")) {
                    skipCrypto = false;
                    continue;
                }
                if (line.startsWith("router-sig-ed25519 ")) continue;
                logger.warn("Unrecognized line '{}'. Skipping.", (Object)line);
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            logger.warn("Could not parse server descriptor.", e);
            return false;
        }
        if (null == address || null == fingerprintBytes || null == this.publishedString) {
            logger.warn("Missing either of the following lines that are required to sanitize this server bridge descriptor: \"router\", \"fingerprint\", \"published\". Skipping descriptor.");
            return false;
        }
        try {
            String scrubbedAddressString = this.sensitivePartsSanitizer.scrubIpv4Address(address, fingerprintBytes, this.getPublishedString());
            if (null == scrubbedAddressString) {
                logger.warn("Invalid IP address in \"router\" line in bridge server descriptor. Skipping descriptor.");
                return false;
            }
            scrubbedAddress.append(scrubbedAddressString);
            for (Map.Entry e : scrubbedIpAddressesAndTcpPorts.entrySet()) {
                String scrubbedOrAddress = this.sensitivePartsSanitizer.scrubOrAddress((String)e.getValue(), fingerprintBytes, this.getPublishedString());
                if (null == scrubbedOrAddress) {
                    logger.warn("Invalid IP address or TCP port in \"or-address\" line in bridge server descriptor. Skipping descriptor.");
                    return false;
                }
                ((StringBuilder)e.getKey()).append(scrubbedOrAddress);
            }
            for (Map.Entry e : scrubbedTcpPorts.entrySet()) {
                String scrubbedTcpPort = this.sensitivePartsSanitizer.scrubTcpPort((String)e.getValue(), fingerprintBytes, this.getPublishedString());
                if (null == scrubbedTcpPort) {
                    logger.warn("Invalid TCP port in \"router\" line in bridge server descriptor. Skipping descriptor.");
                    return false;
                }
                ((StringBuilder)e.getKey()).append(scrubbedTcpPort);
            }
        }
        catch (IOException exception) {
            return false;
        }
        this.descriptorDigest = this.computeDescriptorDigest(this.originalBytes, "router ", "\nrouter-signature\n");
        String descriptorDigestSha256Base64 = null;
        if (masterKeyEd25519FromIdentityEd25519 != null) {
            descriptorDigestSha256Base64 = this.computeSha256Base64Digest(this.originalBytes, "router ", "\n-----END SIGNATURE-----\n");
        }
        if (null != descriptorDigestSha256Base64) {
            scrubbed.append("router-digest-sha256 ").append(descriptorDigestSha256Base64).newLine();
        }
        if (null != this.descriptorDigest) {
            scrubbed.append("router-digest ").append(this.descriptorDigest.toUpperCase()).newLine();
        }
        this.sanitizedBytes = scrubbed.toBytes();
        return true;
    }

    byte[] getSanitizedBytes() {
        return this.sanitizedBytes;
    }

    public String getPublishedString() {
        return this.publishedString;
    }

    public String getDescriptorDigest() {
        return this.descriptorDigest;
    }
}

