/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.collector.bridgedb;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.SortedSet;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.descriptor.BridgedbMetrics;
import org.torproject.descriptor.Descriptor;
import org.torproject.descriptor.DescriptorSourceFactory;
import org.torproject.descriptor.UnparseableDescriptor;
import org.torproject.metrics.collector.conf.Configuration;
import org.torproject.metrics.collector.conf.ConfigurationException;
import org.torproject.metrics.collector.conf.Key;
import org.torproject.metrics.collector.cron.CollecTorMain;
import org.torproject.metrics.collector.persist.BridgedbMetricsPersistence;
import org.torproject.metrics.collector.persist.PersistenceUtils;

public class BridgedbMetricsProcessor
extends CollecTorMain {
    private static final Logger logger = LoggerFactory.getLogger(BridgedbMetricsProcessor.class);
    private File inputDirectory;
    private Path parsedBridgedbMetricsFile;
    private String outputPathName;
    private String recentPathName;

    public BridgedbMetricsProcessor(Configuration config) {
        super(config);
    }

    @Override
    public String module() {
        return "BridgedbMetrics";
    }

    @Override
    protected String syncMarker() {
        return "BridgedbMetrics";
    }

    @Override
    protected void startProcessing() throws ConfigurationException {
        logger.info("Starting BridgeDB statistics module of CollecTor.");
        this.initializeConfiguration();
        SortedSet<Path> previouslyProcessedFiles = this.readProcessedFiles(this.parsedBridgedbMetricsFile);
        TreeSet<Path> processedFiles = new TreeSet<Path>();
        logger.info("Reading BridgeDB statistics files in {}.", (Object)this.inputDirectory);
        for (Descriptor descriptor : DescriptorSourceFactory.createDescriptorReader().readDescriptors(this.inputDirectory)) {
            processedFiles.add(descriptor.getDescriptorFile().toPath());
            if (previouslyProcessedFiles.contains(descriptor.getDescriptorFile().toPath())) continue;
            if (descriptor instanceof BridgedbMetrics) {
                BridgedbMetrics bridgedbMetrics = (BridgedbMetrics)descriptor;
                BridgedbMetricsPersistence persistence = new BridgedbMetricsPersistence(bridgedbMetrics);
                Path tarballPath = Paths.get(this.outputPathName, persistence.getStoragePath());
                Path rsyncPath = Paths.get(this.recentPathName, persistence.getRecentPath());
                this.writeDescriptor(bridgedbMetrics.getRawDescriptorBytes(), tarballPath, rsyncPath);
                continue;
            }
            if (descriptor instanceof UnparseableDescriptor) {
                logger.warn("Skipping unparseable descriptor in file {}.", (Object)descriptor.getDescriptorFile(), (Object)((UnparseableDescriptor)descriptor).getDescriptorParseException());
                continue;
            }
            logger.warn("Skipping unexpected descriptor of type {} in file {}.", (Object)descriptor.getClass(), (Object)descriptor.getDescriptorFile());
        }
        logger.info("Cleaning up directories {} and {}.", (Object)this.recentPathName, (Object)this.outputPathName);
        this.writeProcessedFiles(this.parsedBridgedbMetricsFile, processedFiles);
        this.cleanUpDirectories();
        logger.info("Finished processing BridgeDB statistics file(s).");
    }

    private void initializeConfiguration() throws ConfigurationException {
        this.parsedBridgedbMetricsFile = this.config.getPath(Key.StatsPath).resolve("processed-bridgedb-metrics");
        this.outputPathName = this.config.getPath(Key.OutputPath).toString();
        this.recentPathName = this.config.getPath(Key.RecentPath).toString();
        this.inputDirectory = this.config.getPath(Key.BridgedbMetricsLocalOrigins).toFile();
    }

    private void writeDescriptor(byte[] rawDescriptorBytes, Path ... outputPaths) {
        for (Path outputPath : outputPaths) {
            try {
                File outputFile = outputPath.toFile();
                if (outputFile.exists()) continue;
                if (!outputFile.getParentFile().exists() && !outputFile.getParentFile().mkdirs()) {
                    logger.warn("Could not create parent directories of {}.", (Object)outputFile);
                    return;
                }
                Files.write(outputPath, rawDescriptorBytes, new OpenOption[0]);
            }
            catch (IOException e) {
                logger.warn("Unable to write descriptor to file {}.", (Object)outputPath, (Object)e);
            }
        }
    }

    private void cleanUpDirectories() {
        PersistenceUtils.cleanDirectory(Paths.get(this.recentPathName, new String[0]).resolve("bridgedb-metrics"), Instant.now().minus(3L, ChronoUnit.DAYS).toEpochMilli());
        PersistenceUtils.cleanDirectory(Paths.get(this.outputPathName, new String[0]).resolve("bridgedb-metrics"), Instant.now().minus(49L, ChronoUnit.DAYS).toEpochMilli());
    }
}

