/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.collector.persist;

import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.descriptor.WebServerAccessLog;
import org.torproject.descriptor.internal.FileType;
import org.torproject.metrics.collector.persist.DescriptorPersistence;

public class WebServerAccessLogPersistence
extends DescriptorPersistence<WebServerAccessLog> {
    public static final String SEP = "_";
    public static final FileType COMPRESSION = FileType.XZ;
    private static final Logger log = LoggerFactory.getLogger(WebServerAccessLogPersistence.class);
    private DateTimeFormatter yearPattern = DateTimeFormatter.ofPattern("yyyy");
    private DateTimeFormatter monthPattern = DateTimeFormatter.ofPattern("MM");
    private DateTimeFormatter dayPattern = DateTimeFormatter.ofPattern("dd");

    public WebServerAccessLogPersistence(WebServerAccessLog desc) {
        super(desc, new byte[0]);
        this.calculatePaths();
    }

    private void calculatePaths() {
        String name = ((WebServerAccessLog)this.desc).getVirtualHost() + SEP + ((WebServerAccessLog)this.desc).getPhysicalHost() + SEP + "access.log" + SEP + ((WebServerAccessLog)this.desc).getLogDate().format(DateTimeFormatter.BASIC_ISO_DATE) + "." + COMPRESSION.name().toLowerCase();
        this.recentPath = Paths.get("webstats", name).toString();
        this.storagePath = Paths.get("webstats", ((WebServerAccessLog)this.desc).getVirtualHost(), ((WebServerAccessLog)this.desc).getLogDate().format(this.yearPattern), ((WebServerAccessLog)this.desc).getLogDate().format(this.monthPattern), ((WebServerAccessLog)this.desc).getLogDate().format(this.dayPattern), name).toString();
    }

    @Override
    public boolean storeAll(String recentRoot, String outRoot) {
        return this.storeAll(recentRoot, outRoot, StandardOpenOption.CREATE_NEW, StandardOpenOption.CREATE_NEW);
    }

    @Override
    public boolean storeRecent(String recentRoot) {
        return this.storeRecent(recentRoot, StandardOpenOption.CREATE_NEW);
    }
}

