/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.collector.cron;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.descriptor.Descriptor;
import org.torproject.metrics.collector.conf.Configuration;
import org.torproject.metrics.collector.conf.ConfigurationException;
import org.torproject.metrics.collector.conf.Key;
import org.torproject.metrics.collector.conf.SourceType;
import org.torproject.metrics.collector.sync.SyncManager;

public abstract class CollecTorMain
extends SyncManager
implements Callable<Object>,
Observer,
Runnable {
    private static final Logger logger = LoggerFactory.getLogger(CollecTorMain.class);
    private static final long LIMIT_MB = 200L;
    public static final String SOURCES = "Sources";
    private final AtomicBoolean newConfigAvailable = new AtomicBoolean(false);
    protected Configuration config = new Configuration();
    private Configuration newConfig;
    protected final Map<String, Class<? extends Descriptor>> mapPathDescriptors = new HashMap<String, Class<? extends Descriptor>>();

    public CollecTorMain(Configuration conf) {
        this.config.putAll(conf.getPropertiesCopy());
        conf.addObserver(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        CollecTorMain collecTorMain = this;
        synchronized (collecTorMain) {
            if (this.newConfigAvailable.get()) {
                logger.info("Module {} is using the new configuration.", (Object)this.module());
                Configuration configuration = this.newConfig;
                synchronized (configuration) {
                    this.config.clear();
                    this.config.putAll(this.newConfig.getPropertiesCopy());
                    this.newConfigAvailable.set(false);
                }
            }
        }
        try {
            if (!this.isSyncOnly()) {
                logger.info("Starting {} module of CollecTor.", (Object)this.module());
                this.startProcessing();
                logger.info("Terminating {} module of CollecTor.", (Object)this.module());
            }
        }
        catch (Throwable th) {
            logger.error("The {} module failed: {}", new Object[]{this.module(), th.getMessage(), th});
        }
        try {
            if (this.isSync()) {
                logger.info("Starting sync-run of module {} of CollecTor.", (Object)this.module());
                this.merge(this.config, this.syncMarker(), this.syncMapPathsDescriptors());
                logger.info("Finished sync-run of module {} of CollecTor.", (Object)this.module());
            }
        }
        catch (Throwable th) {
            logger.error("Sync-run of {} module failed: {}", new Object[]{this.module(), th.getMessage(), th});
        }
    }

    private boolean isSync() throws ConfigurationException {
        String key = this.syncMarker() + SOURCES;
        return Key.has(key) && this.config.getSourceTypeSet(Key.valueOf(key)).contains((Object)SourceType.Sync);
    }

    private boolean isSyncOnly() throws ConfigurationException {
        String key = this.syncMarker() + SOURCES;
        return this.isSync() && this.config.getSourceTypeSet(Key.valueOf(key)).size() == 1;
    }

    @Override
    public final Object call() {
        this.run();
        return null;
    }

    @Override
    public synchronized void update(Observable obs, Object obj) {
        this.newConfigAvailable.set(true);
        if (obs instanceof Configuration) {
            this.newConfig = (Configuration)obs;
            logger.info("Module {} just received a new configuration.", (Object)this.module());
        }
    }

    protected abstract void startProcessing() throws ConfigurationException;

    protected abstract String syncMarker();

    public abstract String module();

    public Map<String, Class<? extends Descriptor>> syncMapPathsDescriptors() {
        return Collections.unmodifiableMap(this.mapPathDescriptors);
    }

    public static void checkAvailableSpace(Path location) {
        try {
            long megaBytes = Files.getFileStore(location.toFile().getAbsoluteFile().toPath().getRoot()).getUsableSpace() / 1024L / 1024L;
            if (megaBytes < 200L) {
                logger.warn("Available storage critical for {}; only {} MiB left.", (Object)location, (Object)megaBytes);
            } else {
                logger.trace("Available storage for {}: {} MiB", (Object)location, (Object)megaBytes);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Cannot access " + location + " reason: " + ioe.getMessage(), ioe);
        }
    }
}

