/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.collector.sync;

import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.collector.conf.Configuration;
import org.torproject.collector.conf.ConfigurationException;
import org.torproject.collector.conf.Key;
import org.torproject.collector.sync.ProcessCriterium;
import org.torproject.collector.sync.SyncPersistence;
import org.torproject.descriptor.Descriptor;
import org.torproject.descriptor.DescriptorFile;
import org.torproject.descriptor.DescriptorReader;
import org.torproject.descriptor.DescriptorSourceFactory;
import org.torproject.descriptor.index.DescriptorIndexCollector;

public class SyncManager {
    private static final Logger log = LoggerFactory.getLogger(SyncManager.class);
    public static final String SYNCORIGINS = "SyncOrigins";
    private Date collectionDate;

    public void merge(Configuration conf, String marker, Map<String, Class<? extends Descriptor>> mapPathDesc) throws ConfigurationException {
        URL[] sources = conf.getUrlArray(Key.valueOf(marker + SYNCORIGINS));
        this.collectionDate = new Date();
        this.collectFromOtherInstances(sources, mapPathDesc.keySet(), marker, conf);
        this.mergeWithLocalStorage(sources, mapPathDesc, marker, conf);
    }

    private void collectFromOtherInstances(URL[] sources, Set<String> dirs, String marker, Configuration conf) throws ConfigurationException {
        Path basePath = conf.getPath(Key.SyncPath);
        DescriptorIndexCollector descriptorCollector = new DescriptorIndexCollector();
        for (URL source : sources) {
            try {
                File storage = new File(basePath.toFile(), marker + "-" + source.getHost());
                storage.mkdirs();
                log.info("Collecting {} from {} ...", (Object)marker, (Object)source.getHost());
                descriptorCollector.collectDescriptors(source.toString(), dirs.toArray(new String[dirs.size()]), 0L, storage, true);
                log.info("Done collecting {} from {}.", (Object)marker, (Object)source.getHost());
            }
            catch (Throwable th) {
                log.warn("Cannot download {} from {}.", dirs, source, th);
            }
        }
    }

    private void mergeWithLocalStorage(URL[] sources, Map<String, Class<? extends Descriptor>> mapPathDesc, String marker, Configuration conf) throws ConfigurationException {
        Path basePath = conf.getPath(Key.SyncPath);
        SyncPersistence persist = new SyncPersistence(conf);
        for (URL source : sources) {
            File base = new File(basePath.toFile(), marker + "-" + source.getHost());
            log.info("Merging {} from {} into storage ...", (Object)marker, (Object)source.getHost());
            for (Map.Entry<String, Class<? extends Descriptor>> entry : mapPathDesc.entrySet()) {
                DescriptorReader descriptorReader = DescriptorSourceFactory.createDescriptorReader();
                descriptorReader.addDirectory(new File(base, entry.getKey()));
                String histFileEnding = entry.getValue().getSimpleName() + (entry.getKey().contains("consensus-microdesc") ? "-micro" : "");
                descriptorReader.setExcludeFiles(new File(basePath.toFile(), "sync-history-" + source.getHost() + "-" + marker + "-" + histFileEnding));
                log.info("Reading {} of type {} ... ", (Object)marker, (Object)histFileEnding);
                Iterator<DescriptorFile> descriptorFiles = descriptorReader.readDescriptors();
                log.info("Done reading {} of type {}.", (Object)marker, (Object)histFileEnding);
                ProcessCriterium crit = new ProcessCriterium(entry.getValue());
                while (descriptorFiles.hasNext()) {
                    DescriptorFile descFile = descriptorFiles.next();
                    log.debug("Operating on desc-file containing {} descs.", (Object)descFile.getDescriptors().size());
                    if (!crit.applies(descFile)) {
                        log.warn("Not processing {} in {}.", (Object)descFile.getFileName(), (Object)descFile.getDirectory());
                        continue;
                    }
                    Exception ex = descFile.getException();
                    if (null != ex) {
                        log.warn("Parsing of {} caused Exception(s). Processing anyway.", (Object)(descFile.getDirectory() + "/" + descFile.getFileName()), (Object)ex);
                    }
                    persist.storeDescs(descFile.getDescriptors(), descFile.getFile().getName(), this.collectionDate.getTime());
                }
            }
            log.info("Done merging {} from {}.", (Object)marker, (Object)source.getHost());
        }
    }
}

