/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.collector.relaydescs;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TimeZone;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.collector.conf.Annotation;
import org.torproject.collector.conf.Configuration;
import org.torproject.collector.conf.ConfigurationException;
import org.torproject.collector.conf.Key;
import org.torproject.collector.conf.SourceType;
import org.torproject.collector.cron.CollecTorMain;
import org.torproject.collector.relaydescs.ArchiveReader;
import org.torproject.collector.relaydescs.CachedRelayDescriptorReader;
import org.torproject.collector.relaydescs.ReferenceChecker;
import org.torproject.collector.relaydescs.RelayDescriptorDownloader;
import org.torproject.collector.relaydescs.RelayDescriptorParser;
import org.torproject.descriptor.DescriptorParseException;
import org.torproject.descriptor.DescriptorParser;
import org.torproject.descriptor.DescriptorSourceFactory;
import org.torproject.descriptor.RelayExtraInfoDescriptor;
import org.torproject.descriptor.RelayNetworkStatusConsensus;
import org.torproject.descriptor.RelayNetworkStatusVote;
import org.torproject.descriptor.RelayServerDescriptor;

public class ArchiveWriter
extends CollecTorMain {
    private static final Logger logger = LoggerFactory.getLogger(ArchiveWriter.class);
    private long now = System.currentTimeMillis();
    private String outputDirectory;
    private String rsyncCatString;
    private DescriptorParser descriptorParser;
    private int storedConsensusesCounter = 0;
    private int storedMicrodescConsensusesCounter = 0;
    private int storedVotesCounter = 0;
    private int storedCertsCounter = 0;
    private int storedServerDescriptorsCounter = 0;
    private int storedExtraInfoDescriptorsCounter = 0;
    private int storedMicrodescriptorsCounter = 0;
    private SortedMap<Long, SortedSet<String>> storedConsensuses = new TreeMap<Long, SortedSet<String>>();
    private SortedMap<Long, SortedSet<String>> storedMicrodescConsensuses = new TreeMap<Long, SortedSet<String>>();
    private SortedMap<Long, Integer> expectedVotes = new TreeMap<Long, Integer>();
    private SortedMap<Long, SortedMap<String, SortedSet<String>>> storedVotes = new TreeMap<Long, SortedMap<String, SortedSet<String>>>();
    private SortedMap<Long, Map<String, String>> storedServerDescriptors = new TreeMap<Long, Map<String, String>>();
    private SortedMap<Long, Set<String>> storedExtraInfoDescriptors = new TreeMap<Long, Set<String>>();
    private SortedMap<Long, Set<String>> storedMicrodescriptors = new TreeMap<Long, Set<String>>();
    private File storedServerDescriptorsFile;
    private File storedExtraInfoDescriptorsFile;
    private File storedMicrodescriptorsFile;
    private StringBuilder intermediateStats = new StringBuilder();
    private Path recentPath;
    private String recentPathName;
    private static final String RELAY_DESCRIPTORS = "relay-descriptors";
    private static final String MICRO = "micro";
    private static final String CONSENSUS_MICRODESC = "consensus-microdesc";
    private static final String MICRODESC = "microdesc";
    private static final String MICRODESCS = "microdescs";

    public ArchiveWriter(Configuration config) throws ConfigurationException {
        super(config);
        this.mapPathDescriptors.put("recent/relay-descriptors/votes", RelayNetworkStatusVote.class);
        this.mapPathDescriptors.put("recent/relay-descriptors/consensuses", RelayNetworkStatusConsensus.class);
        this.mapPathDescriptors.put("recent/relay-descriptors/microdescs/consensus-microdesc", RelayNetworkStatusConsensus.class);
        this.mapPathDescriptors.put("recent/relay-descriptors/server-descriptors", RelayServerDescriptor.class);
        this.mapPathDescriptors.put("recent/relay-descriptors/extra-infos", RelayExtraInfoDescriptor.class);
    }

    @Override
    public String module() {
        return "relaydescs";
    }

    @Override
    protected String syncMarker() {
        return "Relay";
    }

    @Override
    protected void startProcessing() throws ConfigurationException {
        this.recentPath = this.config.getPath(Key.RecentPath);
        CollecTorMain.checkAvailableSpace(this.recentPath);
        this.recentPathName = this.recentPath.toString();
        File statsDir = this.config.getPath(Key.StatsPath).toFile();
        this.storedServerDescriptorsFile = new File(statsDir, "stored-server-descriptors");
        this.storedExtraInfoDescriptorsFile = new File(statsDir, "stored-extra-info-descriptors");
        this.storedMicrodescriptorsFile = new File(statsDir, "stored-microdescriptors");
        File statsDirectory = this.config.getPath(Key.StatsPath).toFile();
        this.outputDirectory = Paths.get(this.config.getPath(Key.OutputPath).toString(), RELAY_DESCRIPTORS).toString();
        SimpleDateFormat rsyncCatFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
        rsyncCatFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.rsyncCatString = rsyncCatFormat.format(System.currentTimeMillis());
        this.descriptorParser = DescriptorSourceFactory.createDescriptorParser();
        this.loadDescriptorDigests();
        RelayDescriptorParser rdp = new RelayDescriptorParser(this);
        RelayDescriptorDownloader rdd = null;
        Set<SourceType> sources = this.config.getSourceTypeSet(Key.RelaySources);
        if (sources.contains((Object)SourceType.Remote)) {
            String[] dirSources = this.config.getStringArray(Key.DirectoryAuthoritiesAddresses);
            rdd = new RelayDescriptorDownloader(rdp, dirSources, this.config.getStringArray(Key.DirectoryAuthoritiesFingerprintsForVotes), true, true, true, true, true, true, this.config.getBool(Key.DownloadAllServerDescriptors), this.config.getBool(Key.DownloadAllExtraInfoDescriptors), this.config.getBool(Key.CompressRelayDescriptorDownloads));
            rdp.setRelayDescriptorDownloader(rdd);
        }
        if (sources.contains((Object)SourceType.Cache)) {
            new CachedRelayDescriptorReader(rdp, this.config.getStringArray(Key.RelayCacheOrigins), statsDirectory);
            this.intermediateStats("importing relay descriptors from local Tor data directories");
        }
        if (sources.contains((Object)SourceType.Local)) {
            new ArchiveReader(rdp, this.config.getPath(Key.RelayLocalOrigins).toFile(), statsDirectory, this.config.getBool(Key.KeepDirectoryArchiveImportHistory));
            this.intermediateStats("importing relay descriptors from local directory");
        }
        if (rdd != null) {
            rdd.downloadDescriptors();
            rdd.writeFile();
            rdd = null;
            this.intermediateStats("downloading relay descriptors from the directory authorities");
        }
        this.checkMissingDescriptors();
        this.checkStaledescriptors();
        this.cleanUpRsyncDirectory();
        this.saveDescriptorDigests();
        new ReferenceChecker(this.recentPath.toFile(), new File(statsDir, "references"), new File(statsDir, "references-history")).check();
        CollecTorMain.checkAvailableSpace(this.recentPath);
        this.cleanUp();
    }

    private void cleanUp() {
        this.expectedVotes.clear();
        this.intermediateStats = new StringBuilder();
        this.storedConsensuses.clear();
        this.storedMicrodescConsensuses.clear();
        this.storedVotes.clear();
        this.storedServerDescriptors.clear();
        this.storedExtraInfoDescriptors.clear();
        this.storedMicrodescriptors.clear();
    }

    private void loadDescriptorDigests() {
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dateTimeFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            long published;
            String[] parts;
            String line;
            BufferedReader br;
            if (this.storedServerDescriptorsFile.exists()) {
                br = new BufferedReader(new FileReader(this.storedServerDescriptorsFile));
                while ((line = br.readLine()) != null) {
                    parts = line.split(",");
                    if (parts.length != 3) {
                        logger.warn("Could not load server descriptor digests because of illegal line '" + line + "'.  We might not be able to correctly check descriptors for completeness.");
                        break;
                    }
                    published = dateTimeFormat.parse(parts[0]).getTime();
                    if (published < this.now - 172800000L) continue;
                    if (!this.storedServerDescriptors.containsKey(published)) {
                        this.storedServerDescriptors.put(published, new HashMap());
                    }
                    String serverDescriptorDigest = parts[1];
                    String extraInfoDescriptorDigest = parts[2].equals("NA") ? null : parts[2];
                    ((Map)this.storedServerDescriptors.get(published)).put(serverDescriptorDigest, extraInfoDescriptorDigest);
                }
                br.close();
            }
            if (this.storedExtraInfoDescriptorsFile.exists()) {
                br = new BufferedReader(new FileReader(this.storedExtraInfoDescriptorsFile));
                while ((line = br.readLine()) != null) {
                    parts = line.split(",");
                    if (parts.length != 2) {
                        logger.warn("Could not load extra-info descriptor digests because of illegal line '" + line + "'.  We might not be able to correctly check descriptors for completeness.");
                        break;
                    }
                    published = dateTimeFormat.parse(parts[0]).getTime();
                    if (published < this.now - 172800000L) continue;
                    if (!this.storedExtraInfoDescriptors.containsKey(published)) {
                        this.storedExtraInfoDescriptors.put(published, new HashSet());
                    }
                    String extraInfoDescriptorDigest = parts[1];
                    ((Set)this.storedExtraInfoDescriptors.get(published)).add(extraInfoDescriptorDigest);
                }
                br.close();
            }
            if (this.storedMicrodescriptorsFile.exists()) {
                br = new BufferedReader(new FileReader(this.storedMicrodescriptorsFile));
                while ((line = br.readLine()) != null) {
                    parts = line.split(",");
                    if (parts.length != 2) {
                        logger.warn("Could not load microdescriptor digests because of illegal line '" + line + "'.  We might not be able to correctly check descriptors for completeness.");
                        break;
                    }
                    long validAfter = dateTimeFormat.parse(parts[0]).getTime();
                    if (validAfter < this.now - 3456000000L) continue;
                    if (!this.storedMicrodescriptors.containsKey(validAfter)) {
                        this.storedMicrodescriptors.put(validAfter, new HashSet());
                    }
                    String microdescriptorDigest = parts[1];
                    ((Set)this.storedMicrodescriptors.get(validAfter)).add(microdescriptorDigest);
                }
                br.close();
            }
        }
        catch (IOException | ParseException e) {
            logger.warn("Could not load descriptor digests.  We might not be able to correctly check descriptors for completeness.", e);
        }
    }

    public void intermediateStats(String event) {
        this.intermediateStats.append("While " + event + ", we stored " + this.storedConsensusesCounter + " consensus(es), " + this.storedMicrodescConsensusesCounter + " microdesc consensus(es), " + this.storedVotesCounter + " vote(s), " + this.storedCertsCounter + " certificate(s), " + this.storedServerDescriptorsCounter + " server descriptor(s), " + this.storedExtraInfoDescriptorsCounter + " extra-info descriptor(s), and " + this.storedMicrodescriptorsCounter + " microdescriptor(s) to disk.\n");
        this.storedConsensusesCounter = 0;
        this.storedMicrodescConsensusesCounter = 0;
        this.storedVotesCounter = 0;
        this.storedCertsCounter = 0;
        this.storedServerDescriptorsCounter = 0;
        this.storedExtraInfoDescriptorsCounter = 0;
        this.storedMicrodescriptorsCounter = 0;
    }

    private void checkMissingDescriptors() {
        boolean bl;
        boolean bl2;
        StringBuilder sb = new StringBuilder("Finished writing relay descriptors to disk.\n");
        sb.append(this.intermediateStats.toString());
        sb.append("Statistics on the completeness of written relay descriptors:");
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dateTimeFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        HashMap<String, String> knownServerDescriptors = new HashMap<String, String>();
        for (Map<String, String> map : this.storedServerDescriptors.values()) {
            knownServerDescriptors.putAll(map);
        }
        HashSet<String> knownExtraInfoDescriptors = new HashSet<String>();
        for (Set<String> set : this.storedExtraInfoDescriptors.values()) {
            knownExtraInfoDescriptors.addAll(set);
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (Set<String> set : this.storedMicrodescriptors.values()) {
            hashSet.addAll(set);
        }
        boolean bl3 = false;
        boolean bl4 = false;
        boolean missingMicrodescConsensus = false;
        for (Map.Entry<Long, SortedSet<String>> c : this.storedConsensuses.entrySet()) {
            int allVotes;
            Object fingerprint;
            String extraInfoDescriptorDigest;
            long validAfterMillis = c.getKey();
            String validAfterTime = dateTimeFormat.format(validAfterMillis);
            int foundVotes = 0;
            if (this.storedVotes.containsKey(validAfterMillis)) {
                foundVotes = ((SortedMap)this.storedVotes.get(validAfterMillis)).size();
                for (Map.Entry v : ((SortedMap)this.storedVotes.get(validAfterMillis)).entrySet()) {
                    int voteFoundServerDescs = 0;
                    int voteAllServerDescs = 0;
                    int voteFoundExtraInfos = 0;
                    int voteAllExtraInfos = 0;
                    for (String serverDescriptorDigest : (SortedSet)v.getValue()) {
                        ++voteAllServerDescs;
                        if (!knownServerDescriptors.containsKey(serverDescriptorDigest)) continue;
                        ++voteFoundServerDescs;
                        if (knownServerDescriptors.get(serverDescriptorDigest) == null) continue;
                        extraInfoDescriptorDigest = (String)knownServerDescriptors.get(serverDescriptorDigest);
                        ++voteAllExtraInfos;
                        if (!knownExtraInfoDescriptors.contains(extraInfoDescriptorDigest)) continue;
                        ++voteFoundExtraInfos;
                    }
                    sb.append("\nV, " + validAfterTime);
                    if (voteAllServerDescs > 0) {
                        sb.append(String.format(", %d/%d S (%.1f%%)", voteFoundServerDescs, voteAllServerDescs, 100.0 * (double)voteFoundServerDescs / (double)voteAllServerDescs));
                    } else {
                        sb.append(", 0/0 S");
                    }
                    if (voteAllExtraInfos > 0) {
                        sb.append(String.format(", %d/%d E (%.1f%%)", voteFoundExtraInfos, voteAllExtraInfos, 100.0 * (double)voteFoundExtraInfos / (double)voteAllExtraInfos));
                    } else {
                        sb.append(", 0/0 E");
                    }
                    if (((String)(fingerprint = (String)v.getKey())).equalsIgnoreCase("27B6B5996C426270A5C95488AA5BCEB6BCC86956") || voteFoundServerDescs * 1000 >= voteAllServerDescs * 995 && voteFoundExtraInfos * 1000 >= voteAllExtraInfos * 995) continue;
                    bl2 = true;
                }
            }
            int foundServerDescs = 0;
            int allServerDescs = 0;
            int foundExtraInfos = 0;
            int allExtraInfos = 0;
            int foundMicrodescriptors = 0;
            int allMicrodescriptors = 0;
            fingerprint = c.getValue().iterator();
            while (fingerprint.hasNext()) {
                String serverDescriptorDigest;
                serverDescriptorDigest = (String)fingerprint.next();
                ++allServerDescs;
                if (!knownServerDescriptors.containsKey(serverDescriptorDigest)) continue;
                ++foundServerDescs;
                if (knownServerDescriptors.get(serverDescriptorDigest) == null) continue;
                ++allExtraInfos;
                extraInfoDescriptorDigest = (String)knownServerDescriptors.get(serverDescriptorDigest);
                if (!knownExtraInfoDescriptors.contains(extraInfoDescriptorDigest)) continue;
                ++foundExtraInfos;
            }
            sb.append("\nC, " + validAfterTime);
            int n = allVotes = this.expectedVotes.containsKey(validAfterMillis) ? (Integer)this.expectedVotes.get(validAfterMillis) : 0;
            if (allVotes > 0) {
                sb.append(String.format(", %d/%d V (%.1f%%)", foundVotes, allVotes, 100.0 * (double)foundVotes / (double)allVotes));
            } else {
                sb.append(", 0/0 V");
            }
            if (allServerDescs > 0) {
                sb.append(String.format(", %d/%d S (%.1f%%)", foundServerDescs, allServerDescs, 100.0 * (double)foundServerDescs / (double)allServerDescs));
            } else {
                sb.append(", 0/0 S");
            }
            if (allExtraInfos > 0) {
                sb.append(String.format(", %d/%d E (%.1f%%)", foundExtraInfos, allExtraInfos, 100.0 * (double)foundExtraInfos / (double)allExtraInfos));
            } else {
                sb.append(", 0/0 E");
            }
            if (this.storedMicrodescConsensuses.containsKey(validAfterMillis)) {
                for (String microdescriptorDigest : (SortedSet)this.storedMicrodescConsensuses.get(validAfterMillis)) {
                    ++allMicrodescriptors;
                    if (!hashSet.contains(microdescriptorDigest)) continue;
                    ++foundMicrodescriptors;
                }
                sb.append("\nM, " + validAfterTime);
                if (allMicrodescriptors > 0) {
                    sb.append(String.format(", %d/%d M (%.1f%%)", foundMicrodescriptors, allMicrodescriptors, 100.0 * (double)foundMicrodescriptors / (double)allMicrodescriptors));
                } else {
                    sb.append(", 0/0 M");
                }
            } else {
                missingMicrodescConsensus = true;
            }
            if (foundServerDescs * 1000 < allServerDescs * 995 || foundExtraInfos * 1000 < allExtraInfos * 995 || foundMicrodescriptors * 1000 < allMicrodescriptors * 995) {
                bl2 = true;
            }
            if (foundVotes >= allVotes) continue;
            bl = true;
        }
        logger.info(sb.toString());
        if (bl2) {
            logger.debug("We are missing at least 0.5% of server or extra-info descriptors referenced from a consensus or vote or at least 0.5% of microdescriptors referenced from a microdesc consensus.");
        }
        if (bl) {
            logger.debug("We are missing at least one vote that was referenced from a consensus.");
        }
        if (missingMicrodescConsensus) {
            logger.debug("We are missing at least one microdesc consensus that was published together with a known consensus.");
        }
    }

    private void checkStaledescriptors() {
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dateTimeFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        long tooOldMillis = this.now - 19800000L;
        if (!this.storedConsensuses.isEmpty() && this.storedConsensuses.lastKey() < tooOldMillis) {
            logger.warn("The last known relay network status consensus was valid after " + dateTimeFormat.format(this.storedConsensuses.lastKey()) + ", which is more than 5:30 hours in the past.");
        }
        if (!this.storedMicrodescConsensuses.isEmpty() && this.storedMicrodescConsensuses.lastKey() < tooOldMillis) {
            logger.warn("The last known relay network status microdesc consensus was valid after " + dateTimeFormat.format(this.storedMicrodescConsensuses.lastKey()) + ", which is more than 5:30 hours in the past.");
        }
        if (!this.storedVotes.isEmpty() && this.storedVotes.lastKey() < tooOldMillis) {
            logger.warn("The last known relay network status vote was valid after " + dateTimeFormat.format(this.storedVotes.lastKey()) + ", which is more than 5:30 hours in the past.");
        }
        if (!this.storedServerDescriptors.isEmpty() && this.storedServerDescriptors.lastKey() < tooOldMillis) {
            logger.warn("The last known relay server descriptor was published at " + dateTimeFormat.format(this.storedServerDescriptors.lastKey()) + ", which is more than 5:30 hours in the past.");
        }
        if (!this.storedExtraInfoDescriptors.isEmpty() && this.storedExtraInfoDescriptors.lastKey() < tooOldMillis) {
            logger.warn("The last known relay extra-info descriptor was published at " + dateTimeFormat.format(this.storedExtraInfoDescriptors.lastKey()) + ", which is more than 5:30 hours in the past.");
        }
        if (!this.storedMicrodescriptors.isEmpty() && this.storedMicrodescriptors.lastKey() < tooOldMillis) {
            logger.warn("The last known relay microdescriptor was contained in a microdesc consensus that was valid after " + dateTimeFormat.format(this.storedMicrodescriptors.lastKey()) + ", which is more than 5:30 hours in the past.");
        }
    }

    public void cleanUpRsyncDirectory() {
        long cutOffMillis = System.currentTimeMillis() - 259200000L;
        long cutOffMicroMillis = cutOffMillis - 2332800000L;
        Stack<File> allFiles = new Stack<File>();
        allFiles.add(new File(this.recentPathName, RELAY_DESCRIPTORS));
        while (!allFiles.isEmpty()) {
            File file = (File)allFiles.pop();
            if (file.isDirectory()) {
                allFiles.addAll(Arrays.asList(file.listFiles()));
                continue;
            }
            if (file.getName().endsWith("-micro")) {
                if (file.lastModified() >= cutOffMicroMillis) continue;
                file.delete();
                continue;
            }
            if (file.lastModified() < cutOffMillis) {
                file.delete();
                continue;
            }
            if (!file.getName().endsWith(".tmp")) continue;
            file.renameTo(new File(file.getParentFile(), file.getName().substring(0, file.getName().lastIndexOf(".tmp"))));
        }
    }

    private void saveDescriptorDigests() {
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dateTimeFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            String published;
            this.storedServerDescriptorsFile.getParentFile().mkdirs();
            BufferedWriter bw = new BufferedWriter(new FileWriter(this.storedServerDescriptorsFile));
            for (Map.Entry<Long, Map<String, String>> entry : this.storedServerDescriptors.entrySet()) {
                published = dateTimeFormat.format(entry.getKey());
                for (Map.Entry<String, String> f : entry.getValue().entrySet()) {
                    String serverDescriptorDigest = f.getKey();
                    String extraInfoDescriptorDigest = f.getValue() == null ? "NA" : f.getValue();
                    bw.write(String.format("%s,%s,%s%n", published, serverDescriptorDigest, extraInfoDescriptorDigest));
                }
            }
            bw.close();
            this.storedExtraInfoDescriptorsFile.getParentFile().mkdirs();
            bw = new BufferedWriter(new FileWriter(this.storedExtraInfoDescriptorsFile));
            for (Map.Entry<Long, Object> entry : this.storedExtraInfoDescriptors.entrySet()) {
                published = dateTimeFormat.format(entry.getKey());
                for (String extraInfoDescriptorDigest : (Set)entry.getValue()) {
                    bw.write(String.format("%s,%s%n", published, extraInfoDescriptorDigest));
                }
            }
            bw.close();
            this.storedMicrodescriptorsFile.getParentFile().mkdirs();
            bw = new BufferedWriter(new FileWriter(this.storedMicrodescriptorsFile));
            for (Map.Entry<Long, Object> entry : this.storedMicrodescriptors.entrySet()) {
                String validAfter = dateTimeFormat.format(entry.getKey());
                for (String microdescriptorDigest : (Set)entry.getValue()) {
                    bw.write(String.format("%s,%s%n", validAfter, microdescriptorDigest));
                }
            }
            bw.close();
        }
        catch (IOException e) {
            logger.warn("Could not save descriptor digests.  We might not be able to correctly check descriptors for completeness in the next run.", e);
        }
    }

    public void storeConsensus(byte[] data, long validAfter, SortedSet<String> dirSources, SortedSet<String> serverDescriptorDigests) {
        SimpleDateFormat printFormat = new SimpleDateFormat("yyyy/MM/dd/yyyy-MM-dd-HH-mm-ss");
        printFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        File tarballFile = Paths.get(this.outputDirectory, "consensus", printFormat.format(new Date(validAfter)) + "-consensus").toFile();
        boolean tarballFileExistedBefore = tarballFile.exists();
        File rsyncFile = Paths.get(this.recentPathName, RELAY_DESCRIPTORS, "consensuses", tarballFile.getName()).toFile();
        File[] outputFiles = new File[]{tarballFile, rsyncFile};
        if (this.store(Annotation.Consensus.bytes(), data, outputFiles, null)) {
            ++this.storedConsensusesCounter;
        }
        if (!tarballFileExistedBefore && this.now - validAfter < 10800000L) {
            this.storedConsensuses.put(validAfter, serverDescriptorDigests);
            this.expectedVotes.put(validAfter, dirSources.size());
        }
    }

    public void storeMicrodescConsensus(byte[] data, long validAfter, SortedSet<String> microdescriptorDigests) {
        SimpleDateFormat yearMonthDirectoryFormat = new SimpleDateFormat("yyyy/MM");
        yearMonthDirectoryFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        SimpleDateFormat dayDirectoryFileFormat = new SimpleDateFormat("dd/yyyy-MM-dd-HH-mm-ss");
        dayDirectoryFileFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        File tarballFile = Paths.get(this.outputDirectory, MICRODESC, yearMonthDirectoryFormat.format(validAfter), CONSENSUS_MICRODESC, dayDirectoryFileFormat.format(validAfter) + "-consensus-microdesc").toFile();
        boolean tarballFileExistedBefore = tarballFile.exists();
        File rsyncFile = Paths.get(this.recentPathName, RELAY_DESCRIPTORS, MICRODESCS, CONSENSUS_MICRODESC, tarballFile.getName()).toFile();
        File[] outputFiles = new File[]{tarballFile, rsyncFile};
        if (this.store(Annotation.MicroConsensus.bytes(), data, outputFiles, null)) {
            ++this.storedMicrodescConsensusesCounter;
        }
        if (!tarballFileExistedBefore && this.now - validAfter < 10800000L) {
            this.storedMicrodescConsensuses.put(validAfter, microdescriptorDigests);
        }
    }

    public void storeVote(byte[] data, long validAfter, String fingerprint, String digest, SortedSet<String> serverDescriptorDigests) {
        SimpleDateFormat printFormat = new SimpleDateFormat("yyyy/MM/dd/yyyy-MM-dd-HH-mm-ss");
        printFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        File tarballFile = Paths.get(this.outputDirectory, "vote", printFormat.format(new Date(validAfter)) + "-vote-" + fingerprint + "-" + digest).toFile();
        boolean tarballFileExistedBefore = tarballFile.exists();
        File rsyncFile = Paths.get(this.recentPathName, RELAY_DESCRIPTORS, "votes", tarballFile.getName()).toFile();
        File[] outputFiles = new File[]{tarballFile, rsyncFile};
        if (this.store(Annotation.Vote.bytes(), data, outputFiles, null)) {
            ++this.storedVotesCounter;
        }
        if (!tarballFileExistedBefore && this.now - validAfter < 10800000L) {
            if (!this.storedVotes.containsKey(validAfter)) {
                this.storedVotes.put(validAfter, new TreeMap());
            }
            ((SortedMap)this.storedVotes.get(validAfter)).put(fingerprint, serverDescriptorDigests);
        }
    }

    public void storeCertificate(byte[] data, String fingerprint, long published) {
        SimpleDateFormat printFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
        printFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        File tarballFile = Paths.get(this.outputDirectory, "certs", fingerprint + "-" + printFormat.format(new Date(published))).toFile();
        File[] outputFiles = new File[]{tarballFile};
        if (this.store(Annotation.Cert.bytes(), data, outputFiles, null)) {
            ++this.storedCertsCounter;
        }
    }

    public void storeServerDescriptor(byte[] data, String digest, long published, String extraInfoDigest) {
        SimpleDateFormat printFormat = new SimpleDateFormat("yyyy/MM/");
        printFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        File tarballFile = Paths.get(this.outputDirectory, "server-descriptor", printFormat.format(new Date(published)), digest.substring(0, 1), digest.substring(1, 2), digest).toFile();
        boolean tarballFileExistedBefore = tarballFile.exists();
        File rsyncCatFile = Paths.get(this.recentPathName, RELAY_DESCRIPTORS, "server-descriptors", this.rsyncCatString + "-server-descriptors.tmp").toFile();
        File[] outputFiles = new File[]{tarballFile, rsyncCatFile};
        boolean[] append = new boolean[]{false, true};
        if (this.store(Annotation.Server.bytes(), data, outputFiles, append)) {
            ++this.storedServerDescriptorsCounter;
        }
        if (!tarballFileExistedBefore && this.now - published < 172800000L) {
            if (!this.storedServerDescriptors.containsKey(published)) {
                this.storedServerDescriptors.put(published, new HashMap());
            }
            ((Map)this.storedServerDescriptors.get(published)).put(digest, extraInfoDigest);
        }
    }

    public void storeExtraInfoDescriptor(byte[] data, String extraInfoDigest, long published) {
        SimpleDateFormat descriptorFormat = new SimpleDateFormat("yyyy/MM/");
        descriptorFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        File tarballFile = Paths.get(this.outputDirectory, "extra-info", descriptorFormat.format(new Date(published)), extraInfoDigest.substring(0, 1), extraInfoDigest.substring(1, 2), extraInfoDigest).toFile();
        boolean tarballFileExistedBefore = tarballFile.exists();
        File rsyncCatFile = Paths.get(this.recentPathName, RELAY_DESCRIPTORS, "extra-infos", this.rsyncCatString + "-extra-infos.tmp").toFile();
        File[] outputFiles = new File[]{tarballFile, rsyncCatFile};
        boolean[] append = new boolean[]{false, true};
        if (this.store(Annotation.ExtraInfo.bytes(), data, outputFiles, append)) {
            ++this.storedExtraInfoDescriptorsCounter;
        }
        if (!tarballFileExistedBefore && this.now - published < 172800000L) {
            if (!this.storedExtraInfoDescriptors.containsKey(published)) {
                this.storedExtraInfoDescriptors.put(published, new HashSet());
            }
            ((Set)this.storedExtraInfoDescriptors.get(published)).add(extraInfoDigest);
        }
    }

    public void storeMicrodescriptor(byte[] data, String microdescriptorDigest, long validAfter) {
        SimpleDateFormat descriptorFormat = new SimpleDateFormat("yyyy/MM/");
        descriptorFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        File tarballFile = Paths.get(this.outputDirectory, MICRODESC, descriptorFormat.format(validAfter), MICRO, microdescriptorDigest.substring(0, 1), microdescriptorDigest.substring(1, 2), microdescriptorDigest).toFile();
        boolean tarballFileExistedBefore = tarballFile.exists();
        File rsyncCatFile = Paths.get(this.recentPathName, RELAY_DESCRIPTORS, MICRODESCS, MICRO, this.rsyncCatString + "-micro.tmp").toFile();
        File[] outputFiles = new File[]{tarballFile, rsyncCatFile};
        boolean[] append = new boolean[]{false, true};
        if (this.store(Annotation.Microdescriptor.bytes(), data, outputFiles, append)) {
            ++this.storedMicrodescriptorsCounter;
        }
        if (!tarballFileExistedBefore && this.now - validAfter < 3456000000L) {
            if (!this.storedMicrodescriptors.containsKey(validAfter)) {
                this.storedMicrodescriptors.put(validAfter, new HashSet());
            }
            ((Set)this.storedMicrodescriptors.get(validAfter)).add(microdescriptorDigest);
        }
    }

    private boolean store(byte[] typeAnnotation, byte[] data, File[] outputFiles, boolean[] append) {
        try {
            logger.trace("Storing " + outputFiles[0]);
            if (this.descriptorParser.parseDescriptors(data, outputFiles[0].getName()).size() != 1) {
                logger.info("Relay descriptor file " + outputFiles[0] + " doesn't contain exactly one descriptor.  Storing anyway.");
            }
        }
        catch (DescriptorParseException e) {
            logger.info("Could not parse relay descriptor " + outputFiles[0] + " before storing it to disk.  Storing anyway.", e);
        }
        try {
            for (int i = 0; i < outputFiles.length; ++i) {
                File outputFile = outputFiles[i];
                boolean appendToFile = append == null ? false : append[i];
                outputFile.getParentFile().mkdirs();
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(outputFile, appendToFile));
                if (data.length > 0 && data[0] != 64) {
                    bos.write(typeAnnotation, 0, typeAnnotation.length);
                }
                bos.write(data, 0, data.length);
                bos.close();
            }
            return true;
        }
        catch (IOException e) {
            logger.warn("Could not store relay descriptor " + outputFiles[0], e);
            return false;
        }
    }
}

