/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.collector.persist;

import java.io.UnsupportedEncodingException;
import java.nio.file.Paths;
import org.apache.commons.codec.digest.DigestUtils;
import org.torproject.collector.conf.Annotation;
import org.torproject.collector.persist.DescriptorPersistence;
import org.torproject.collector.persist.PersistenceUtils;
import org.torproject.descriptor.RelayNetworkStatusVote;

public class VotePersistence
extends DescriptorPersistence<RelayNetworkStatusVote> {
    private static final String VOTE = "vote";
    private static final String VOTES = "votes";

    public VotePersistence(RelayNetworkStatusVote desc, long received) {
        super(desc, Annotation.Vote.bytes());
        this.calculatePaths(received);
    }

    private void calculatePaths(long received) {
        String fileOut = PersistenceUtils.dateTime(((RelayNetworkStatusVote)this.desc).getValidAfterMillis());
        String[] parts = fileOut.split("-");
        String digest = VotePersistence.calcDigestFromBytes(((RelayNetworkStatusVote)this.desc).getRawDescriptorBytes());
        fileOut = fileOut + "-vote-" + ((RelayNetworkStatusVote)this.desc).getSignatures().get(0).getIdentity() + "-" + digest;
        this.recentPath = Paths.get("relay-descriptors", VOTES, fileOut).toString();
        this.storagePath = Paths.get("relay-descriptors", VOTE, parts[0], parts[1], parts[2], fileOut).toString();
    }

    private static String calcDigestFromBytes(byte[] bytes) {
        String digest = "";
        String startToken = "network-status-version ";
        String sigToken = "directory-signature ";
        try {
            String ascii = new String(bytes, "US-ASCII");
            int start = ascii.indexOf(startToken);
            int sig = ascii.indexOf(sigToken);
            if (start >= 0 && sig >= 0 && sig > start) {
                byte[] forDigest = new byte[(sig += sigToken.length()) - start];
                System.arraycopy(bytes, start, forDigest, 0, sig - start);
                digest = DigestUtils.shaHex(forDigest).toUpperCase();
            } else {
                log.error("No digest calculation possible.  Returning empty string.");
            }
        }
        catch (UnsupportedEncodingException uee) {
            log.error("Unsupported encoding.  Returning empty string.", uee);
        }
        return digest;
    }
}

