/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.collector.persist;

import java.nio.file.Paths;
import org.torproject.collector.conf.Annotation;
import org.torproject.collector.persist.DescriptorPersistence;
import org.torproject.collector.persist.PersistenceUtils;
import org.torproject.descriptor.RelayServerDescriptor;

public class ServerDescriptorPersistence
extends DescriptorPersistence<RelayServerDescriptor> {
    private static final String RELAY_DESCRIPTORS = "relay-descriptors";

    public ServerDescriptorPersistence(RelayServerDescriptor desc, long received) {
        super(desc, Annotation.Server.bytes());
        this.calculatePaths(received);
    }

    private void calculatePaths(long received) {
        String file = PersistenceUtils.dateTime(received);
        String[] parts = PersistenceUtils.dateTimeParts(((RelayServerDescriptor)this.desc).getPublishedMillis());
        this.recentPath = Paths.get(RELAY_DESCRIPTORS, "server-descriptors", file + "-" + "server-descriptors").toString();
        String digest = ((RelayServerDescriptor)this.desc).getServerDescriptorDigest();
        this.storagePath = Paths.get(RELAY_DESCRIPTORS, "server-descriptor", parts[0], parts[1], digest.substring(0, 1), digest.substring(1, 2), digest).toString();
    }
}

