/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.collector.exitlists;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Stack;
import java.util.TimeZone;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.collector.conf.Annotation;
import org.torproject.collector.conf.Configuration;
import org.torproject.collector.conf.ConfigurationException;
import org.torproject.collector.conf.Key;
import org.torproject.collector.cron.CollecTorMain;
import org.torproject.descriptor.Descriptor;
import org.torproject.descriptor.DescriptorParseException;
import org.torproject.descriptor.DescriptorParser;
import org.torproject.descriptor.DescriptorSourceFactory;
import org.torproject.descriptor.ExitList;

public class ExitListDownloader
extends CollecTorMain {
    private static final Logger logger = LoggerFactory.getLogger(ExitListDownloader.class);
    private static final String EXITLISTS = "exit-lists";
    private String outputPathName;
    private String recentPathName;

    public ExitListDownloader(Configuration config) {
        super(config);
        this.mapPathDescriptors.put("recent/exit-lists", ExitList.class);
    }

    @Override
    public String module() {
        return "exitlists";
    }

    @Override
    protected String syncMarker() {
        return "Exitlist";
    }

    @Override
    protected void startProcessing() throws ConfigurationException {
        File[] outputFiles;
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dateTimeFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.outputPathName = Paths.get(this.config.getPath(Key.OutputPath).toString(), EXITLISTS).toString();
        this.recentPathName = Paths.get(this.config.getPath(Key.RecentPath).toString(), EXITLISTS).toString();
        Date downloadedDate = new Date();
        String downloadedExitList = null;
        try {
            int len;
            logger.debug("Downloading exit list...");
            StringBuilder sb = new StringBuilder();
            sb.append(Annotation.ExitList.toString());
            sb.append("Downloaded " + dateTimeFormat.format(downloadedDate) + "\n");
            URL url = this.config.getUrl(Key.ExitlistUrl);
            HttpURLConnection huc = (HttpURLConnection)url.openConnection();
            huc.setRequestMethod("GET");
            huc.connect();
            int response = huc.getResponseCode();
            if (response != 200) {
                logger.warn("Could not download exit list. Response code " + response);
                return;
            }
            BufferedInputStream in = new BufferedInputStream(huc.getInputStream());
            byte[] data = new byte[1024];
            while ((len = in.read(data, 0, 1024)) >= 0) {
                sb.append(new String(data, 0, len));
            }
            in.close();
            downloadedExitList = sb.toString();
            logger.debug("Finished downloading exit list.");
        }
        catch (IOException e) {
            logger.warn("Failed downloading exit list", e);
            return;
        }
        if (downloadedExitList == null) {
            logger.warn("Failed downloading exit list.");
            return;
        }
        SimpleDateFormat tarballFormat = new SimpleDateFormat("yyyy/MM/dd/yyyy-MM-dd-HH-mm-ss");
        tarballFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        File tarballFile = Paths.get(this.outputPathName, tarballFormat.format(downloadedDate)).toFile();
        long maxScanMillis = 0L;
        try {
            DescriptorParser descriptorParser = DescriptorSourceFactory.createDescriptorParser();
            List<Descriptor> parsedDescriptors = descriptorParser.parseDescriptors(downloadedExitList.getBytes(), tarballFile.getName());
            if (parsedDescriptors.size() != 1 || !(parsedDescriptors.get(0) instanceof ExitList)) {
                logger.warn("Could not parse downloaded exit list");
                return;
            }
            File[] parsedExitList = (File[])parsedDescriptors.get(0);
            for (ExitList.Entry entry : parsedExitList.getEntries()) {
                for (long scanMillis : entry.getExitAddresses().values()) {
                    maxScanMillis = Math.max(maxScanMillis, scanMillis);
                }
            }
        }
        catch (DescriptorParseException e) {
            logger.warn("Could not parse downloaded exit list", e);
        }
        if (maxScanMillis > 0L && maxScanMillis + 19800000L < System.currentTimeMillis()) {
            logger.warn("The last reported scan in the downloaded exit list took place at " + dateTimeFormat.format(maxScanMillis) + ", which is more than 5:30 hours in the past.");
        }
        File rsyncFile = new File(this.recentPathName, tarballFile.getName());
        for (File outputFile : outputFiles = new File[]{tarballFile, rsyncFile}) {
            try {
                outputFile.getParentFile().mkdirs();
                BufferedWriter bw = new BufferedWriter(new FileWriter(outputFile));
                bw.write(downloadedExitList);
                bw.close();
            }
            catch (IOException e) {
                logger.warn("Could not write downloaded exit list to " + outputFile.getAbsolutePath(), e);
            }
        }
        StringBuilder dumpStats = new StringBuilder("Finished downloading exit list.\nLast three exit lists are:");
        Stack<File> filesInInputDir = new Stack<File>();
        filesInInputDir.add(new File(this.outputPathName));
        TreeSet<File> lastThreeExitLists = new TreeSet<File>();
        while (!filesInInputDir.isEmpty()) {
            File pop = (File)filesInInputDir.pop();
            if (pop.isDirectory()) {
                TreeSet<File> lastThreeElements = new TreeSet<File>();
                for (File f : pop.listFiles()) {
                    lastThreeElements.add(f);
                }
                while (lastThreeElements.size() > 3) {
                    lastThreeElements.remove(lastThreeElements.first());
                }
                for (File f : lastThreeElements) {
                    filesInInputDir.add(f);
                }
                continue;
            }
            lastThreeExitLists.add(pop);
            while (lastThreeExitLists.size() > 3) {
                lastThreeExitLists.remove(lastThreeExitLists.first());
            }
        }
        for (File f : lastThreeExitLists) {
            dumpStats.append("\n" + f.getName());
        }
        logger.info(dumpStats.toString());
        this.cleanUpRsyncDirectory();
    }

    public void cleanUpRsyncDirectory() throws ConfigurationException {
        long cutOffMillis = System.currentTimeMillis() - 259200000L;
        Stack<File> allFiles = new Stack<File>();
        allFiles.add(new File(this.recentPathName, EXITLISTS));
        while (!allFiles.isEmpty()) {
            File file = (File)allFiles.pop();
            if (file.isDirectory()) {
                allFiles.addAll(Arrays.asList(file.listFiles()));
                continue;
            }
            if (file.lastModified() >= cutOffMillis) continue;
            file.delete();
        }
    }
}

