/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.descriptor.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.SortedSet;
import java.util.TreeSet;
import org.torproject.descriptor.DescriptorParseException;
import org.torproject.descriptor.DirSourceEntry;
import org.torproject.descriptor.impl.ParseHelper;

public class DirSourceEntryImpl
implements DirSourceEntry {
    private byte[] dirSourceEntryBytes;
    private boolean failUnrecognizedDescriptorLines;
    private List<String> unrecognizedLines;
    private SortedSet<String> exactlyOnceKeywords;
    private SortedSet<String> atMostOnceKeywords;
    private String nickname;
    private String identity;
    private boolean isLegacy;
    private String hostname;
    private String ip;
    private int dirPort;
    private int orPort;
    private String contactLine;
    private String voteDigest;

    @Override
    public byte[] getDirSourceEntryBytes() {
        return this.dirSourceEntryBytes;
    }

    protected List<String> getAndClearUnrecognizedLines() {
        List<String> lines = this.unrecognizedLines;
        this.unrecognizedLines = null;
        return lines;
    }

    protected DirSourceEntryImpl(byte[] dirSourceEntryBytes, boolean failUnrecognizedDescriptorLines) throws DescriptorParseException {
        this.dirSourceEntryBytes = dirSourceEntryBytes;
        this.failUnrecognizedDescriptorLines = failUnrecognizedDescriptorLines;
        this.initializeKeywords();
        this.parseDirSourceEntryBytes();
        this.checkAndClearKeywords();
    }

    private void initializeKeywords() {
        this.exactlyOnceKeywords = new TreeSet<String>();
        this.exactlyOnceKeywords.add("dir-source");
        this.exactlyOnceKeywords.add("vote-digest");
        this.atMostOnceKeywords = new TreeSet<String>();
        this.atMostOnceKeywords.add("contact");
    }

    private void parsedExactlyOnceKeyword(String keyword) throws DescriptorParseException {
        if (!this.exactlyOnceKeywords.contains(keyword)) {
            throw new DescriptorParseException("Duplicate '" + keyword + "' line in dir-source.");
        }
        this.exactlyOnceKeywords.remove(keyword);
    }

    private void parsedAtMostOnceKeyword(String keyword) throws DescriptorParseException {
        if (!this.atMostOnceKeywords.contains(keyword)) {
            throw new DescriptorParseException("Duplicate " + keyword + "line in dir-source.");
        }
        this.atMostOnceKeywords.remove(keyword);
    }

    private void checkAndClearKeywords() throws DescriptorParseException {
        if (!this.exactlyOnceKeywords.isEmpty()) {
            throw new DescriptorParseException("dir-source does not contain a '" + this.exactlyOnceKeywords.first() + "' line.");
        }
        this.exactlyOnceKeywords = null;
        this.atMostOnceKeywords = null;
    }

    private void parseDirSourceEntryBytes() throws DescriptorParseException {
        Scanner scanner = new Scanner(new String(this.dirSourceEntryBytes)).useDelimiter("\n");
        boolean skipCrypto = false;
        block14: while (scanner.hasNext()) {
            String line = scanner.next();
            String[] parts = line.split(" ");
            switch (parts[0]) {
                case "dir-source": {
                    this.parseDirSourceLine(line);
                    continue block14;
                }
                case "contact": {
                    this.parseContactLine(line);
                    continue block14;
                }
                case "vote-digest": {
                    this.parseVoteDigestLine(line);
                    continue block14;
                }
                case "-----BEGIN": {
                    skipCrypto = true;
                    continue block14;
                }
                case "-----END": {
                    skipCrypto = false;
                    continue block14;
                }
            }
            if (skipCrypto) continue;
            if (this.failUnrecognizedDescriptorLines) {
                throw new DescriptorParseException("Unrecognized line '" + line + "' in dir-source entry.");
            }
            if (this.unrecognizedLines == null) {
                this.unrecognizedLines = new ArrayList<String>();
            }
            this.unrecognizedLines.add(line);
        }
    }

    private void parseDirSourceLine(String line) throws DescriptorParseException {
        this.parsedExactlyOnceKeyword("dir-source");
        String[] parts = line.split("[ \t]+");
        if (parts.length != 7) {
            throw new DescriptorParseException("Invalid line '" + line + "'.");
        }
        String nickname = parts[1];
        if (nickname.endsWith("-legacy")) {
            nickname = nickname.substring(0, nickname.length() - "-legacy".length());
            this.isLegacy = true;
            this.parsedExactlyOnceKeyword("vote-digest");
        }
        this.nickname = ParseHelper.parseNickname(line, nickname);
        this.identity = ParseHelper.parseTwentyByteHexString(line, parts[2]);
        if (parts[3].length() < 1) {
            throw new DescriptorParseException("Illegal hostname in '" + line + "'.");
        }
        this.hostname = parts[3];
        this.ip = ParseHelper.parseIpv4Address(line, parts[4]);
        this.dirPort = ParseHelper.parsePort(line, parts[5]);
        this.orPort = ParseHelper.parsePort(line, parts[6]);
    }

    private void parseContactLine(String line) throws DescriptorParseException {
        this.parsedAtMostOnceKeyword("contact");
        this.contactLine = line.length() > "contact ".length() ? line.substring("contact ".length()) : "";
    }

    private void parseVoteDigestLine(String line) throws DescriptorParseException {
        this.parsedExactlyOnceKeyword("vote-digest");
        String[] parts = line.split("[ \t]+");
        if (parts.length != 2) {
            throw new DescriptorParseException("Invalid line '" + line + "'.");
        }
        this.voteDigest = ParseHelper.parseTwentyByteHexString(line, parts[1]);
    }

    @Override
    public String getNickname() {
        return this.nickname;
    }

    @Override
    public String getIdentity() {
        return this.identity;
    }

    @Override
    public boolean isLegacy() {
        return this.isLegacy;
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public String getIp() {
        return this.ip;
    }

    @Override
    public int getDirPort() {
        return this.dirPort;
    }

    @Override
    public int getOrPort() {
        return this.orPort;
    }

    @Override
    public String getContactLine() {
        return this.contactLine;
    }

    @Override
    public String getVoteDigest() {
        return this.voteDigest;
    }
}

