/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.descriptor.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;
import java.util.SortedMap;
import java.util.TreeMap;
import org.torproject.descriptor.BridgePoolAssignment;
import org.torproject.descriptor.DescriptorParseException;
import org.torproject.descriptor.impl.DescriptorImpl;
import org.torproject.descriptor.impl.ParseHelper;

public class BridgePoolAssignmentImpl
extends DescriptorImpl
implements BridgePoolAssignment {
    private long publishedMillis;
    private SortedMap<String, String> entries = new TreeMap<String, String>();

    protected static List<BridgePoolAssignment> parseDescriptors(byte[] descriptorsBytes, boolean failUnrecognizedDescriptorLines) throws DescriptorParseException {
        ArrayList<BridgePoolAssignment> parsedDescriptors = new ArrayList<BridgePoolAssignment>();
        List<byte[]> splitDescriptorsBytes = DescriptorImpl.splitRawDescriptorBytes(descriptorsBytes, "bridge-pool-assignment ");
        for (byte[] descriptorBytes : splitDescriptorsBytes) {
            BridgePoolAssignmentImpl parsedDescriptor = new BridgePoolAssignmentImpl(descriptorBytes, failUnrecognizedDescriptorLines);
            parsedDescriptors.add(parsedDescriptor);
        }
        return parsedDescriptors;
    }

    protected BridgePoolAssignmentImpl(byte[] descriptorBytes, boolean failUnrecognizedDescriptorLines) throws DescriptorParseException {
        super(descriptorBytes, failUnrecognizedDescriptorLines, false);
        this.parseDescriptorBytes();
        HashSet<String> exactlyOnceKeywords = new HashSet<String>(Arrays.asList("bridge-pool-assignment"));
        this.checkExactlyOnceKeywords(exactlyOnceKeywords);
        this.checkFirstKeyword("bridge-pool-assignment");
        this.clearParsedKeywords();
    }

    private void parseDescriptorBytes() throws DescriptorParseException {
        Scanner scanner = new Scanner(new String(this.rawDescriptorBytes)).useDelimiter("\n");
        while (scanner.hasNext()) {
            String line = scanner.next();
            if (line.startsWith("bridge-pool-assignment ")) {
                this.parseBridgePoolAssignmentLine(line);
                continue;
            }
            this.parseBridgeLine(line);
        }
    }

    private void parseBridgePoolAssignmentLine(String line) throws DescriptorParseException {
        String[] parts = line.split("[ \t]+");
        if (parts.length != 3) {
            throw new DescriptorParseException("Illegal line '" + line + "' in bridge pool assignment.");
        }
        this.publishedMillis = ParseHelper.parseTimestampAtIndex(line, parts, 1, 2);
    }

    private void parseBridgeLine(String line) throws DescriptorParseException {
        String[] parts = line.split("[ \t]+");
        if (parts.length < 2) {
            throw new DescriptorParseException("Illegal line '" + line + "' in bridge pool assignment.");
        }
        String fingerprint = ParseHelper.parseTwentyByteHexString(line, parts[0]);
        String poolAndDetails = line.substring(line.indexOf(" ") + 1);
        this.entries.put(fingerprint, poolAndDetails);
    }

    @Override
    public long getPublishedMillis() {
        return this.publishedMillis;
    }

    @Override
    public SortedMap<String, String> getEntries() {
        return new TreeMap<String, String>(this.entries);
    }
}

