/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.descriptor.index;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.descriptor.DescriptorCollector;
import org.torproject.descriptor.index.FileNode;
import org.torproject.descriptor.index.IndexNode;

public class DescriptorIndexCollector
implements DescriptorCollector {
    private static Logger log = LoggerFactory.getLogger(DescriptorIndexCollector.class);

    @Override
    public void collectDescriptors(String collecTorIndexUrlString, String[] remoteDirectories, long minLastModified, File localDirectory, boolean deleteExtraneousLocalFiles) {
        if (minLastModified < 0L) {
            throw new IllegalArgumentException("A negative minimum last-modified time is not permitted.");
        }
        if (null == localDirectory || localDirectory.isFile()) {
            throw new IllegalArgumentException("Local directory already exists and is not a directory.");
        }
        SortedMap<String, Long> localFiles = DescriptorIndexCollector.statLocalDirectory(localDirectory);
        SortedMap<String, FileNode> remoteFiles = null;
        IndexNode index = null;
        String indexUrlString = "";
        try {
            URL indexUrl = new URL(collecTorIndexUrlString);
            indexUrlString = indexUrl.toString();
            if (indexUrl.getPath().isEmpty()) {
                indexUrlString = indexUrlString + "/index/index.json";
            }
            index = IndexNode.fetchIndex(indexUrlString);
            remoteFiles = index.retrieveFilesIn(remoteDirectories);
        }
        catch (Exception ex) {
            throw new RuntimeException("Cannot fetch index from '" + indexUrlString + "'.", ex);
        }
        this.fetchRemoteFiles(index.path, remoteFiles, minLastModified, localDirectory, localFiles);
        if (deleteExtraneousLocalFiles) {
            DescriptorIndexCollector.deleteExtraneousLocalFiles(remoteFiles, localDirectory, localFiles);
        }
    }

    void fetchRemoteFiles(String baseUrl, SortedMap<String, FileNode> remotes, long minLastModified, File localDir, SortedMap<String, Long> locals) {
        for (Map.Entry<String, FileNode> entry : remotes.entrySet()) {
            String filepathname = entry.getKey();
            String filename = entry.getValue().path;
            File filepath = new File(localDir, filepathname.replace(filename, ""));
            long lastModifiedMillis = entry.getValue().lastModifiedMillis();
            if (lastModifiedMillis < minLastModified || locals.containsKey(filepathname) && (Long)locals.get(filepathname) >= lastModifiedMillis) continue;
            if (!filepath.exists() && !filepath.mkdirs()) {
                throw new RuntimeException("Cannot create dir: " + filepath);
            }
            File destinationFile = new File(filepath, filename);
            File tempDestinationFile = new File(filepath, "." + filename);
            try {
                InputStream is = new URL(baseUrl + "/" + filepathname).openStream();
                Throwable throwable = null;
                try {
                    Files.copy(is, tempDestinationFile.toPath(), new CopyOption[0]);
                    if (tempDestinationFile.length() == entry.getValue().size) {
                        tempDestinationFile.renameTo(destinationFile);
                        destinationFile.setLastModified(lastModifiedMillis);
                        continue;
                    }
                    log.warn("File sizes don't match. Expected {},  but received {}.", (Object)entry.getValue().size, (Object)tempDestinationFile.length());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            catch (IOException e) {
                log.error("Cannot fetch remote file: {}", (Object)filename, (Object)e);
            }
        }
    }

    static void deleteExtraneousLocalFiles(SortedMap<String, FileNode> remoteFiles, File localDir, SortedMap<String, Long> locals) {
        for (String localPath : locals.keySet()) {
            if (remoteFiles.containsKey(localPath)) continue;
            new File(localDir, localPath).delete();
        }
    }

    static SortedMap<String, Long> statLocalDirectory(final File localDir) {
        final TreeMap<String, Long> locals = new TreeMap<String, Long>();
        if (!localDir.exists()) {
            return locals;
        }
        try {
            Files.walkFileTree(localDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes bfa) throws IOException {
                    locals.put(path.toFile().getAbsolutePath().replace(localDir.getAbsolutePath() + "/", ""), path.toFile().lastModified());
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException ioe) {
            log.error("Cannot stat local directory.", ioe);
        }
        return locals;
    }
}

