/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.collector.torperf;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.Stack;
import java.util.TimeZone;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.collector.conf.Annotation;
import org.torproject.collector.conf.Configuration;
import org.torproject.collector.conf.ConfigurationException;
import org.torproject.collector.conf.Key;
import org.torproject.collector.cron.CollecTorMain;

public class TorperfDownloader
extends CollecTorMain {
    private static final Logger logger = LoggerFactory.getLogger(TorperfDownloader.class);
    private static final String TORPERF = "torperf";
    private File torperfOutputDirectory = null;
    private Map<String, String> torperfSources = new HashMap<String, String>();
    private String[] torperfFilesLines = null;
    private SimpleDateFormat dateFormat;
    private File torperfLastMergedFile;
    SortedMap<String, String> lastMergedTimestamps = new TreeMap<String, String>();
    private SortedMap<Integer, String> dataTimestamps;
    private String cachedSource;
    private int cachedFileSize;
    private String cachedStartDate;
    private SortedMap<String, String> cachedTpfLines;

    public TorperfDownloader(Configuration configuration) {
        super(configuration);
    }

    @Override
    public String module() {
        return TORPERF;
    }

    @Override
    protected String syncMarker() {
        return "TorperfFiles";
    }

    @Override
    protected void startProcessing() throws ConfigurationException {
        this.torperfFilesLines = this.config.getStringArray(Key.TorperfFilesLines);
        this.torperfOutputDirectory = new File(this.config.getPath(Key.OutputPath).toString(), TORPERF);
        this.torperfLastMergedFile = new File(this.config.getPath(Key.StatsPath).toFile(), "torperf-last-merged");
        if (!this.torperfOutputDirectory.exists()) {
            this.torperfOutputDirectory.mkdirs();
        }
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.readLastMergedTimestamps();
        for (String[] stringArray : this.config.getStringArrayArray(Key.TorperfHosts)) {
            this.torperfSources.put(stringArray[0], stringArray[1]);
        }
        for (String[] stringArray : this.torperfFilesLines) {
            this.downloadAndMergeFiles((String)stringArray);
        }
        this.writeLastMergedTimestamps();
        this.cleanUpRsyncDirectory();
    }

    private void readLastMergedTimestamps() {
        if (!this.torperfLastMergedFile.exists()) {
            return;
        }
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.torperfLastMergedFile));
            while ((string = bufferedReader.readLine()) != null) {
                String[] stringArray = string.split(" ");
                String string2 = null;
                String string3 = null;
                if (stringArray.length == 2) {
                    try {
                        Double.parseDouble(stringArray[1]);
                        string2 = stringArray[0];
                        string3 = stringArray[1];
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (string2 == null || string3 == null) {
                    logger.warn("Invalid line '" + string + "' in " + this.torperfLastMergedFile.getAbsolutePath() + ".  Ignoring past history of merging .data and .extradata files.");
                    this.lastMergedTimestamps.clear();
                    break;
                }
                this.lastMergedTimestamps.put(string2, string3);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            logger.warn("Error while reading '" + this.torperfLastMergedFile.getAbsolutePath() + ".  Ignoring past history of merging .data and .extradata files.");
            this.lastMergedTimestamps.clear();
        }
    }

    private void writeLastMergedTimestamps() {
        try {
            this.torperfLastMergedFile.getParentFile().mkdirs();
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.torperfLastMergedFile));
            for (Map.Entry<String, String> entry : this.lastMergedTimestamps.entrySet()) {
                String string = entry.getKey();
                String string2 = entry.getValue();
                bufferedWriter.write(string + " " + string2 + "\n");
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            logger.warn("Error while writing '" + this.torperfLastMergedFile.getAbsolutePath() + ".  This may result in ignoring history of merging .data and .extradata files in the next execution.", iOException);
        }
    }

    private void downloadAndMergeFiles(String string) throws ConfigurationException {
        String[] stringArray = string.split(" ");
        String string2 = stringArray[0];
        int n = -1;
        try {
            n = Integer.parseInt(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            logger.warn("Could not parse file size in TorperfFiles configuration line '" + string + "'.", numberFormatException);
            return;
        }
        String string3 = stringArray[2];
        String string4 = this.torperfSources.get(string2);
        String string5 = string4 + string3;
        String string6 = string2 + "-" + string3;
        File file = new File(this.torperfOutputDirectory, string6);
        boolean bl = this.downloadAndAppendFile(string5, file, true);
        String string7 = stringArray[3];
        String string8 = string4 + string7;
        String string9 = string2 + "-" + string7;
        File file2 = new File(this.torperfOutputDirectory, string9);
        boolean bl2 = this.downloadAndAppendFile(string8, file2, false);
        if (!bl && !bl2) {
            return;
        }
        String string10 = null;
        if (this.lastMergedTimestamps.containsKey(string6)) {
            string10 = (String)this.lastMergedTimestamps.get(string6);
        }
        try {
            string10 = this.mergeFiles(file, file2, string2, n, string10);
        }
        catch (IOException iOException) {
            logger.warn("Failed merging " + file + " and " + file2 + ".", iOException);
        }
        if (string10 != null) {
            this.lastMergedTimestamps.put(string6, string10);
        }
    }

    private boolean downloadAndAppendFile(String string, File file, boolean bl) {
        Object object;
        Object object2;
        String string2 = null;
        int n = 0;
        if (file.exists()) {
            try {
                object2 = new BufferedReader(new FileReader(file));
                while ((object = ((BufferedReader)object2).readLine()) != null) {
                    if (bl || ((String)object).contains(" LAUNCH")) {
                        string2 = object;
                        n = 0;
                        continue;
                    }
                    ++n;
                }
                ((BufferedReader)object2).close();
            }
            catch (IOException iOException) {
                logger.warn("Failed reading '" + file.getAbsolutePath() + "' to determine the first line to append to it.", iOException);
                return false;
            }
        }
        try {
            String string3;
            boolean bl2;
            logger.debug("Downloading " + (bl ? ".data" : ".extradata") + " file from '" + string + "' and merging it into '" + file.getAbsolutePath() + "'.");
            object2 = new URL(string);
            object = (HttpURLConnection)((URL)object2).openConnection();
            ((HttpURLConnection)object).setRequestMethod("GET");
            ((URLConnection)object).connect();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(((URLConnection)object).getInputStream()));
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file, true));
            boolean bl3 = bl2 = string2 == null;
            while ((string3 = bufferedReader.readLine()) != null) {
                if (bl2 && n == 0) {
                    if (bl || string3.contains(" LAUNCH")) {
                        string2 = string3;
                    }
                    bufferedWriter.write(string3 + "\n");
                    continue;
                }
                if (bl2 && n > 0) {
                    --n;
                    continue;
                }
                if (!string3.equals(string2)) continue;
                bl2 = true;
            }
            bufferedWriter.close();
            bufferedReader.close();
            if (!bl2) {
                logger.warn("The last timestamp line in '" + file.getAbsolutePath() + "' is not contained in the new file downloaded from '" + object2 + "'.  Cannot append new lines without possibly leaving a gap.  Skipping.");
                return false;
            }
        }
        catch (IOException iOException) {
            logger.warn("Failed downloading and/or merging '" + string + "'.", iOException);
            return false;
        }
        if (string2 == null) {
            logger.warn("'" + file.getAbsolutePath() + "' doesn't contain any timestamp lines.  Unable to check whether that file is stale or not.");
        } else {
            long l = -1L;
            l = bl ? Long.parseLong(string2.substring(0, string2.indexOf(" "))) * 1000L : Long.parseLong(string2.substring(string2.indexOf(" LAUNCH=") + " LAUNCH=".length(), string2.indexOf(".", string2.indexOf(" LAUNCH=")))) * 1000L;
            if (l < System.currentTimeMillis() - 19800000L) {
                logger.warn("The last timestamp in '" + file.getAbsolutePath() + "' is more than 5:30 hours old: " + l);
            }
        }
        return true;
    }

    private String mergeFiles(File file, File file2, String string, int n, String string2) throws IOException, ConfigurationException {
        if (!file.exists() || !file2.exists()) {
            logger.warn("File " + file.getAbsolutePath() + " or " + file2.getAbsolutePath() + " is missing.");
            return null;
        }
        logger.debug("Merging " + file.getAbsolutePath() + " and " + file2.getAbsolutePath() + " into .tpf format.");
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        BufferedReader bufferedReader2 = new BufferedReader(new FileReader(file2));
        String string3 = bufferedReader.readLine();
        String string4 = bufferedReader2.readLine();
        int n2 = 1;
        int n3 = 1;
        String string5 = null;
        Object object = null;
        while (string3 != null) {
            Object object2;
            if (string3.isEmpty()) {
                logger.trace("Skipping empty line " + file.getName() + ":" + n2++ + ".");
                string3 = bufferedReader.readLine();
                continue;
            }
            SortedMap<String, String> sortedMap = this.parseDataLine(string3);
            if (sortedMap == null) {
                logger.trace("Skipping illegal line " + file.getName() + ":" + n2++ + " '" + string3 + "'.");
                string3 = bufferedReader.readLine();
                continue;
            }
            String string6 = (String)sortedMap.get("DATACOMPLETE");
            double d = Double.parseDouble(string6);
            if (string2 != null && string6.compareTo(string2) < 0) {
                logger.trace("Skipping " + file.getName() + ":" + n2++ + " which we already processed before.");
                string3 = bufferedReader.readLine();
                continue;
            }
            string5 = string6;
            SortedMap<String, String> sortedMap2 = null;
            while (string4 != null) {
                if (string4.isEmpty()) {
                    logger.trace("Skipping " + file2.getName() + ":" + n3++ + " which is empty.");
                    string4 = bufferedReader2.readLine();
                    continue;
                }
                if (string4.startsWith("BUILDTIMEOUT_SET ")) {
                    logger.trace("Skipping " + file2.getName() + ":" + n3++ + " which is a BUILDTIMEOUT_SET line.");
                    string4 = bufferedReader2.readLine();
                    continue;
                }
                if (string4.startsWith("ok ") || string4.startsWith("error ")) {
                    logger.trace("Skipping " + file2.getName() + ":" + n3++ + " which is in the old format.");
                    string4 = bufferedReader2.readLine();
                    continue;
                }
                sortedMap2 = this.parseExtradataLine(string4);
                if (sortedMap2 == null) {
                    logger.trace("Skipping Illegal line " + file2.getName() + ":" + n3++ + " '" + string4 + "'.");
                    string4 = bufferedReader2.readLine();
                    continue;
                }
                if (!sortedMap2.containsKey("USED_AT")) {
                    logger.trace("Skipping " + file2.getName() + ":" + n3++ + " which doesn't contain a USED_AT element.");
                    string4 = bufferedReader2.readLine();
                    continue;
                }
                object2 = (String)sortedMap2.get("USED_AT");
                double d2 = Double.parseDouble((String)object2);
                if (string2 != null && ((String)object2).compareTo(string2) < 0) {
                    logger.trace("Skipping " + file2.getName() + ":" + n3++ + " which we already processed before.");
                    string4 = bufferedReader2.readLine();
                    continue;
                }
                object = object2;
                if (Math.abs(d2 - d) <= 1.0) {
                    logger.debug("Merging " + file2.getName() + ":" + n3++ + " into the current .data line.");
                    string4 = bufferedReader2.readLine();
                    break;
                }
                if (d2 > d) {
                    logger.trace("Comparing " + file2.getName() + " to the next .data line.");
                    sortedMap2 = null;
                    break;
                }
                logger.trace("Skipping " + file2.getName() + ":" + n3++ + " which is too old to be merged with " + file.getName() + ":" + n2 + ".");
                string4 = bufferedReader2.readLine();
            }
            object2 = new TreeMap<String, String>();
            object2.put("SOURCE", string);
            object2.put("FILESIZE", String.valueOf(n));
            if (sortedMap2 != null) {
                object2.putAll(sortedMap2);
            }
            object2.putAll(sortedMap);
            logger.debug("Writing " + file.getName() + ":" + n2++ + ".");
            string3 = bufferedReader.readLine();
            try {
                this.writeTpfLine(string, n, (SortedMap<String, String>)object2);
            }
            catch (IOException iOException) {
                logger.warn("Error writing output line.  Aborting to merge " + file.getName() + " and " + file2.getName() + ".", (Object)n3);
                break;
            }
        }
        bufferedReader.close();
        bufferedReader2.close();
        this.writeCachedTpfLines();
        if (string5 == null) {
            return object;
        }
        if (object == null) {
            return string5;
        }
        if (string5.compareTo((String)object) > 0) {
            return object;
        }
        return string5;
    }

    private SortedMap<String, String> parseDataLine(String string) {
        String[] stringArray = string.trim().split(" ");
        if (string.length() == 0 || stringArray.length < 20) {
            return null;
        }
        if (this.dataTimestamps == null) {
            this.dataTimestamps = new TreeMap<Integer, String>();
            this.dataTimestamps.put(0, "START");
            this.dataTimestamps.put(2, "SOCKET");
            this.dataTimestamps.put(4, "CONNECT");
            this.dataTimestamps.put(6, "NEGOTIATE");
            this.dataTimestamps.put(8, "REQUEST");
            this.dataTimestamps.put(10, "RESPONSE");
            this.dataTimestamps.put(12, "DATAREQUEST");
            this.dataTimestamps.put(14, "DATARESPONSE");
            this.dataTimestamps.put(16, "DATACOMPLETE");
            this.dataTimestamps.put(21, "DATAPERC10");
            this.dataTimestamps.put(23, "DATAPERC20");
            this.dataTimestamps.put(25, "DATAPERC30");
            this.dataTimestamps.put(27, "DATAPERC40");
            this.dataTimestamps.put(29, "DATAPERC50");
            this.dataTimestamps.put(31, "DATAPERC60");
            this.dataTimestamps.put(33, "DATAPERC70");
            this.dataTimestamps.put(35, "DATAPERC80");
            this.dataTimestamps.put(37, "DATAPERC90");
        }
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        try {
            for (Map.Entry<Integer, String> entry : this.dataTimestamps.entrySet()) {
                int n = entry.getKey();
                if (stringArray.length <= n + 1) continue;
                String string2 = entry.getValue();
                String string3 = String.format("%s.%02d", stringArray[n], Integer.parseInt(stringArray[n + 1]) / 10000);
                treeMap.put(string2, string3);
            }
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        treeMap.put("WRITEBYTES", stringArray[18]);
        treeMap.put("READBYTES", stringArray[19]);
        if (stringArray.length >= 21) {
            treeMap.put("DIDTIMEOUT", stringArray[20]);
        }
        return treeMap;
    }

    private SortedMap<String, String> parseExtradataLine(String string) {
        String[] stringArray = string.split(" ");
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        String string2 = null;
        for (String string3 : stringArray) {
            String string4;
            String[] stringArray2 = string3.split("=", -1);
            if (stringArray2.length == 2) {
                string2 = string4 = stringArray2[0];
                String string5 = stringArray2[1];
                if (string5.contains(".") && string5.lastIndexOf(".") == string5.length() - 2) {
                    string5 = string5 + "0";
                }
                treeMap.put(string4, string5);
                continue;
            }
            if (stringArray2.length == 1 && string2 != null) {
                string4 = stringArray2[0];
                if (string2.equals("STREAM_FAIL_REASONS") && (string4.equals("MISC") || string4.equals("EXITPOLICY") || string4.equals("RESOURCELIMIT") || string4.equals("RESOLVEFAILED"))) {
                    treeMap.put(string2, (String)treeMap.get(string2) + ":" + string4);
                    continue;
                }
                return null;
            }
            return null;
        }
        return treeMap;
    }

    private void writeTpfLine(String string, int n, SortedMap<String, String> sortedMap) throws ConfigurationException, IOException {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        for (Map.Entry<String, String> object2 : sortedMap.entrySet()) {
            String l = object2.getKey();
            String string2 = object2.getValue();
            stringBuilder.append((n2++ > 0 ? " " : "") + l + "=" + string2);
        }
        String string4 = stringBuilder.toString();
        String string3 = (String)sortedMap.get("START");
        long l = Long.parseLong(string3.substring(0, string3.indexOf("."))) * 1000L;
        String string5 = this.dateFormat.format(l);
        if (this.cachedTpfLines == null || !string.equals(this.cachedSource) || n != this.cachedFileSize || !string5.equals(this.cachedStartDate)) {
            this.writeCachedTpfLines();
            this.readTpfLinesToCache(string, n, string5);
        }
        if (!this.cachedTpfLines.containsKey(string3) || string4.length() > ((String)this.cachedTpfLines.get(string3)).length()) {
            this.cachedTpfLines.put(string3, string4);
        }
    }

    private void readTpfLinesToCache(String string, int n, String string2) throws IOException {
        String string3;
        this.cachedTpfLines = new TreeMap<String, String>();
        this.cachedSource = string;
        this.cachedFileSize = n;
        this.cachedStartDate = string2;
        File file = new File(this.torperfOutputDirectory, string2.replaceAll("-", "/") + "/" + string + "-" + String.valueOf(n) + "-" + string2 + ".tpf");
        if (!file.exists()) {
            return;
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        while ((string3 = bufferedReader.readLine()) != null) {
            if (string3.startsWith("@type ") || !string3.contains("START=")) continue;
            String string4 = string3.substring(string3.indexOf("START=") + "START=".length()).split(" ")[0];
            this.cachedTpfLines.put(string4, string3);
        }
        bufferedReader.close();
    }

    private void writeCachedTpfLines() throws ConfigurationException, IOException {
        File[] fileArray;
        if (this.cachedSource == null || this.cachedFileSize == 0 || this.cachedStartDate == null || this.cachedTpfLines == null) {
            return;
        }
        File file = new File(this.torperfOutputDirectory, this.cachedStartDate.replaceAll("-", "/") + "/" + this.cachedSource + "-" + String.valueOf(this.cachedFileSize) + "-" + this.cachedStartDate + ".tpf");
        File file2 = new File(this.config.getPath(Key.RecentPath).toFile(), "torperf/" + file.getName());
        for (File file3 : fileArray = new File[]{file, file2}) {
            file3.getParentFile().mkdirs();
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file3));
            for (String string : this.cachedTpfLines.values()) {
                bufferedWriter.write(Annotation.Torperf.toString());
                bufferedWriter.write(string + "\n");
            }
            bufferedWriter.close();
        }
        this.cachedSource = null;
        this.cachedFileSize = 0;
        this.cachedStartDate = null;
        this.cachedTpfLines = null;
    }

    public void cleanUpRsyncDirectory() throws ConfigurationException {
        long l = System.currentTimeMillis() - 259200000L;
        Stack<File> stack = new Stack<File>();
        stack.add(new File(this.config.getPath(Key.RecentPath).toFile(), TORPERF));
        while (!stack.isEmpty()) {
            File file = (File)stack.pop();
            if (file.isDirectory()) {
                stack.addAll(Arrays.asList(file.listFiles()));
                continue;
            }
            if (file.lastModified() >= l) continue;
            file.delete();
        }
    }
}

