/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.collector.relaydescs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import java.util.TreeSet;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.collector.relaydescs.ArchiveReader;
import org.torproject.collector.relaydescs.ArchiveWriter;
import org.torproject.collector.relaydescs.RelayDescriptorDownloader;

public class RelayDescriptorParser {
    private ArchiveWriter aw;
    private ArchiveReader ar;
    private RelayDescriptorDownloader rdd;
    private static final Logger logger = LoggerFactory.getLogger(RelayDescriptorParser.class);
    private SimpleDateFormat dateTimeFormat;

    public RelayDescriptorParser(ArchiveWriter archiveWriter) {
        this.aw = archiveWriter;
        this.dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.dateTimeFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public void setRelayDescriptorDownloader(RelayDescriptorDownloader relayDescriptorDownloader) {
        this.rdd = relayDescriptorDownloader;
    }

    public void setArchiveReader(ArchiveReader archiveReader) {
        this.ar = archiveReader;
    }

    public boolean parse(byte[] byArray) {
        boolean bl = false;
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new StringReader(new String(byArray, "US-ASCII")));
            while ((string = bufferedReader.readLine()) != null && string.startsWith("@")) {
            }
            if (string == null) {
                logger.debug("We were given an empty descriptor for parsing. Ignoring.");
                return false;
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            if (string.startsWith("network-status-version 3")) {
                String string2;
                String string3;
                String[] stringArray;
                String string4 = "consensus";
                if (string.equals("network-status-version 3 microdesc")) {
                    string4 = "consensus-microdesc";
                }
                String string5 = null;
                String string6 = null;
                String string7 = null;
                long l = -1L;
                long l2 = -1L;
                TreeSet<String> treeSet = new TreeSet<String>();
                TreeSet<String> treeSet2 = new TreeSet<String>();
                TreeSet<String> treeSet3 = new TreeSet<String>();
                TreeSet<String> treeSet4 = new TreeSet<String>();
                TreeSet<String> treeSet5 = new TreeSet<String>();
                StringBuilder stringBuilder = null;
                String string8 = null;
                String string9 = null;
                while ((string = bufferedReader.readLine()) != null) {
                    if (stringBuilder != null) {
                        if (string.startsWith("r ")) {
                            string8 = stringBuilder.toString();
                            stringBuilder = null;
                        } else {
                            stringBuilder.append(string + "\n");
                        }
                    }
                    if (string.equals("vote-status vote")) {
                        string4 = "vote";
                        continue;
                    }
                    if (string.startsWith("valid-after ")) {
                        string5 = string.substring("valid-after ".length());
                        l = simpleDateFormat.parse(string5).getTime();
                        continue;
                    }
                    if (string.startsWith("dir-source ")) {
                        string7 = string.split(" ")[2];
                        continue;
                    }
                    if (string.startsWith("vote-digest ")) {
                        treeSet.add(string7);
                        continue;
                    }
                    if (string.startsWith("dir-key-certificate-version ")) {
                        stringBuilder = new StringBuilder();
                        stringBuilder.append(string + "\n");
                        continue;
                    }
                    if (string.startsWith("fingerprint ")) {
                        string6 = string.split(" ")[1];
                        continue;
                    }
                    if (string.startsWith("dir-key-published ")) {
                        stringArray = string.substring("dir-key-published ".length());
                        l2 = simpleDateFormat.parse((String)stringArray).getTime();
                        continue;
                    }
                    if (string.startsWith("r ")) {
                        stringArray = string.split(" ");
                        if (stringArray.length == 8) {
                            string9 = Hex.encodeHexString(Base64.decodeBase64(stringArray[2] + "=")).toLowerCase();
                            continue;
                        }
                        if (stringArray.length == 9) {
                            string9 = Hex.encodeHexString(Base64.decodeBase64(stringArray[2] + "=")).toLowerCase();
                            string3 = Hex.encodeHexString(Base64.decodeBase64(stringArray[3] + "=")).toLowerCase();
                            string2 = stringArray[4] + " " + stringArray[5];
                            treeSet2.add(string2 + "," + string9 + "," + string3);
                            treeSet3.add(string3);
                            continue;
                        }
                        logger.warn("Could not parse r line '" + string + "' in descriptor. Skipping.");
                        break;
                    }
                    if (!string.startsWith("m ")) continue;
                    stringArray = string.split(" ");
                    if (stringArray.length == 2 && stringArray[1].length() == 43) {
                        string3 = stringArray[1];
                        treeSet4.add(string5 + "," + string9 + "," + string3);
                        string2 = Hex.encodeHexString(Base64.decodeBase64(string3 + "=")).toLowerCase();
                        treeSet5.add(string2);
                        continue;
                    }
                    if (stringArray.length == 3 && stringArray[2].startsWith("sha256=") && stringArray[2].length() == 50) continue;
                    logger.warn("Could not parse m line '" + string + "' in descriptor. Skipping.");
                    break;
                }
                if (string4.equals("consensus")) {
                    if (this.rdd != null) {
                        this.rdd.haveParsedConsensus(string5, treeSet, treeSet2);
                    }
                    if (this.aw != null) {
                        this.aw.storeConsensus(byArray, l, treeSet, treeSet3);
                        bl = true;
                    }
                } else if (string4.equals("consensus-microdesc")) {
                    if (this.rdd != null) {
                        this.rdd.haveParsedMicrodescConsensus(string5, treeSet4);
                    }
                    if (this.ar != null) {
                        this.ar.haveParsedMicrodescConsensus(string5, treeSet5);
                    }
                    if (this.aw != null) {
                        this.aw.storeMicrodescConsensus(byArray, l, treeSet5);
                        bl = true;
                    }
                } else if (this.aw != null || this.rdd != null) {
                    stringArray = new String(byArray, "US-ASCII");
                    string3 = "network-status-version ";
                    string2 = "directory-signature ";
                    int n = stringArray.indexOf(string3);
                    int n2 = stringArray.indexOf(string2);
                    if (n >= 0 && n2 >= 0 && n2 > n) {
                        byte[] byArray2 = new byte[(n2 += string2.length()) - n];
                        System.arraycopy(byArray, n, byArray2, 0, n2 - n);
                        String string10 = DigestUtils.shaHex(byArray2).toUpperCase();
                        if (this.aw != null) {
                            this.aw.storeVote(byArray, l, string7, string10, treeSet3);
                            bl = true;
                        }
                        if (this.rdd != null) {
                            this.rdd.haveParsedVote(string5, string6, treeSet2);
                        }
                    }
                    if (string8 != null && this.aw != null) {
                        this.aw.storeCertificate(string8.getBytes(), string7, l2);
                        bl = true;
                    }
                }
            } else if (string.startsWith("router ")) {
                String string11 = null;
                String string12 = null;
                String string13 = null;
                long l = -1L;
                while ((string = bufferedReader.readLine()) != null) {
                    if (string.startsWith("published ")) {
                        string11 = string.substring("published ".length());
                        l = simpleDateFormat.parse(string11).getTime();
                        continue;
                    }
                    if (string.startsWith("opt fingerprint") || string.startsWith("fingerprint")) {
                        string13 = string.substring(string.startsWith("opt ") ? "opt fingerprint".length() : "fingerprint".length()).replaceAll(" ", "").toLowerCase();
                        continue;
                    }
                    if (!string.startsWith("opt extra-info-digest ") && !string.startsWith("extra-info-digest ")) continue;
                    string12 = string.startsWith("opt ") ? string.split(" ")[2].toLowerCase() : string.split(" ")[1].toLowerCase();
                }
                String string14 = new String(byArray, "US-ASCII");
                String string15 = "router ";
                String string16 = "\nrouter-signature\n";
                int n = string14.indexOf(string15);
                int n3 = string14.indexOf(string16) + string16.length();
                String string17 = null;
                if (n >= 0 || n3 >= 0 || n3 > n) {
                    byte[] byArray3 = new byte[n3 - n];
                    System.arraycopy(byArray, n, byArray3, 0, n3 - n);
                    string17 = DigestUtils.shaHex(byArray3);
                }
                if (this.aw != null && string17 != null) {
                    this.aw.storeServerDescriptor(byArray, string17, l, string12);
                    bl = true;
                }
                if (this.rdd != null && string17 != null) {
                    this.rdd.haveParsedServerDescriptor(string11, string13, string17, string12);
                }
            } else if (string.startsWith("extra-info ")) {
                String string18 = null;
                String string19 = string.split(" ")[2];
                long l = -1L;
                while ((string = bufferedReader.readLine()) != null) {
                    if (!string.startsWith("published ")) continue;
                    string18 = string.substring("published ".length());
                    l = simpleDateFormat.parse(string18).getTime();
                }
                String string20 = new String(byArray, "US-ASCII");
                String string21 = "extra-info ";
                String string22 = "\nrouter-signature\n";
                String string23 = null;
                int n = string20.indexOf(string21);
                if (n > 0 && (n = string20.indexOf("\n" + string21)) > 0) {
                    ++n;
                }
                int n4 = string20.indexOf(string22) + string22.length();
                if (n >= 0 && n4 >= 0 && n4 > n) {
                    byte[] byArray4 = new byte[n4 - n];
                    System.arraycopy(byArray, n, byArray4, 0, n4 - n);
                    string23 = DigestUtils.shaHex(byArray4);
                }
                if (this.aw != null && string23 != null) {
                    this.aw.storeExtraInfoDescriptor(byArray, string23, l);
                    bl = true;
                }
                if (this.rdd != null && string23 != null) {
                    this.rdd.haveParsedExtraInfoDescriptor(string18, string19.toLowerCase(), string23);
                }
            } else if (string.equals("onion-key")) {
                // empty if block
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            logger.warn("Could not parse descriptor. Skipping.", iOException);
        }
        catch (ParseException parseException) {
            logger.warn("Could not parse descriptor. Skipping.", parseException);
        }
        return bl;
    }

    public void storeMicrodescriptor(byte[] byArray, String string, String string2, long l) {
        if (this.aw != null) {
            this.aw.storeMicrodescriptor(byArray, string, l);
        }
        if (this.rdd != null) {
            this.rdd.haveParsedMicrodescriptor(string2);
        }
    }
}

