/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.collector.relaydescs;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.descriptor.Descriptor;
import org.torproject.descriptor.DescriptorFile;
import org.torproject.descriptor.DescriptorReader;
import org.torproject.descriptor.DescriptorSourceFactory;
import org.torproject.descriptor.DirSourceEntry;
import org.torproject.descriptor.ExtraInfoDescriptor;
import org.torproject.descriptor.Microdescriptor;
import org.torproject.descriptor.NetworkStatusEntry;
import org.torproject.descriptor.RelayNetworkStatusConsensus;
import org.torproject.descriptor.RelayNetworkStatusVote;
import org.torproject.descriptor.ServerDescriptor;

public class ReferenceChecker {
    private static final Logger logger = LoggerFactory.getLogger(ReferenceChecker.class);
    private File descriptorsDir;
    private File referencesFile;
    private File historyFile;
    private long currentTimeMillis;
    private SortedSet<Reference> references = new TreeSet<Reference>();
    private static DateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
    private static final long ONE_HOUR = 3600000L;
    private static final long THREE_HOURS = 10800000L;
    private static final long SIX_HOURS = 21600000L;
    private static final long ONE_DAY = 86400000L;
    private static final long THIRTY_DAYS = 2592000000L;

    public ReferenceChecker(File file, File file2, File file3) {
        this.descriptorsDir = file;
        this.referencesFile = file2;
        this.historyFile = file3;
    }

    public void check() {
        this.getCurrentTimeMillis();
        this.readReferencesFile();
        this.readNewDescriptors();
        this.dropStaleReferences();
        this.checkReferences();
        this.writeReferencesFile();
    }

    private void getCurrentTimeMillis() {
        this.currentTimeMillis = System.currentTimeMillis();
    }

    private void readReferencesFile() {
        if (!this.referencesFile.exists()) {
            return;
        }
        Gson gson = new Gson();
        try (FileReader fileReader = new FileReader(this.referencesFile);){
            this.references.addAll(Arrays.asList((Object[])gson.fromJson((Reader)fileReader, Reference[].class)));
        }
        catch (IOException iOException) {
            logger.warn("Cannot read existing references file from previous run.", iOException);
        }
        catch (RuntimeException runtimeException) {
            logger.warn("Content of {} cannot be parsed. File will be erased and rewritten. In general, {} shouldn't be edited manually.  Error reason: {}", this.referencesFile.toString(), this.referencesFile.toString(), runtimeException.getMessage());
            try {
                Files.deleteIfExists(this.referencesFile.toPath());
            }
            catch (IOException iOException) {
                logger.warn("Cannot delete '{}', reason: {}", this.referencesFile.toString(), iOException.getMessage(), iOException);
            }
        }
    }

    private void readNewDescriptors() {
        DescriptorReader descriptorReader = DescriptorSourceFactory.createDescriptorReader();
        descriptorReader.addDirectory(this.descriptorsDir);
        descriptorReader.setExcludeFiles(this.historyFile);
        Iterator<DescriptorFile> iterator = descriptorReader.readDescriptors();
        while (iterator.hasNext()) {
            DescriptorFile descriptorFile = iterator.next();
            for (Descriptor descriptor : descriptorFile.getDescriptors()) {
                if (descriptor instanceof RelayNetworkStatusConsensus) {
                    RelayNetworkStatusConsensus relayNetworkStatusConsensus = (RelayNetworkStatusConsensus)descriptor;
                    String string = relayNetworkStatusConsensus.getConsensusFlavor();
                    if (string == null) {
                        this.readRelayNetworkStatusConsensusUnflavored(relayNetworkStatusConsensus);
                        continue;
                    }
                    if (!string.equals("microdesc")) continue;
                    this.readRelayNetworkStatusConsensusMicrodesc(relayNetworkStatusConsensus);
                    continue;
                }
                if (descriptor instanceof RelayNetworkStatusVote) {
                    this.readRelayNetworkStatusVote((RelayNetworkStatusVote)descriptor);
                    continue;
                }
                if (descriptor instanceof ServerDescriptor) {
                    this.readServerDescriptor((ServerDescriptor)descriptor);
                    continue;
                }
                if (descriptor instanceof ExtraInfoDescriptor) {
                    this.readExtraInfoDescriptor((ExtraInfoDescriptor)descriptor);
                    continue;
                }
                if (!(descriptor instanceof Microdescriptor)) continue;
                this.readMicrodescriptor((Microdescriptor)descriptor);
            }
        }
    }

    private void readRelayNetworkStatusConsensusUnflavored(RelayNetworkStatusConsensus relayNetworkStatusConsensus) {
        String string = dateTimeFormat.format(relayNetworkStatusConsensus.getValidAfterMillis());
        String string2 = String.format("C-%s", string);
        this.addReference(string2, String.format("M-%s", string), 1.0, relayNetworkStatusConsensus.getValidAfterMillis() + 10800000L);
        for (DirSourceEntry dirSourceEntry : relayNetworkStatusConsensus.getDirSourceEntries().values()) {
            if (dirSourceEntry.isLegacy()) continue;
            this.addReference(string2, String.format("V-%s-%s", string, dirSourceEntry.getIdentity()), 1.0, relayNetworkStatusConsensus.getValidAfterMillis() + 10800000L);
        }
        double d = 200.0 / (double)relayNetworkStatusConsensus.getStatusEntries().size();
        for (NetworkStatusEntry networkStatusEntry : relayNetworkStatusConsensus.getStatusEntries().values()) {
            this.addReference(string2, String.format("S-%s", networkStatusEntry.getDescriptor()), d, networkStatusEntry.getPublishedMillis() + 10800000L);
        }
    }

    private void readRelayNetworkStatusConsensusMicrodesc(RelayNetworkStatusConsensus relayNetworkStatusConsensus) {
        String string = dateTimeFormat.format(relayNetworkStatusConsensus.getValidAfterMillis());
        String string2 = String.format("M-%s", string);
        this.addReference(string2, String.format("C-%s", string), 1.0, relayNetworkStatusConsensus.getValidAfterMillis() + 10800000L);
        double d = 200.0 / (double)relayNetworkStatusConsensus.getStatusEntries().size();
        for (NetworkStatusEntry networkStatusEntry : relayNetworkStatusConsensus.getStatusEntries().values()) {
            for (String string3 : networkStatusEntry.getMicrodescriptorDigests()) {
                this.addReference(string2, String.format("D-%s", string3), d, networkStatusEntry.getPublishedMillis() + 10800000L);
            }
        }
    }

    private void readRelayNetworkStatusVote(RelayNetworkStatusVote relayNetworkStatusVote) {
        String string = dateTimeFormat.format(relayNetworkStatusVote.getValidAfterMillis());
        String string2 = String.format("V-%s-%s", string, relayNetworkStatusVote.getIdentity());
        double d = 200.0 / (double)relayNetworkStatusVote.getStatusEntries().size();
        for (NetworkStatusEntry networkStatusEntry : relayNetworkStatusVote.getStatusEntries().values()) {
            this.addReference(string2, String.format("S-%s", networkStatusEntry.getDescriptor()), d, networkStatusEntry.getPublishedMillis() + 21600000L);
        }
    }

    private void readServerDescriptor(ServerDescriptor serverDescriptor) {
        String string = serverDescriptor.getExtraInfoDigest() == null ? "" : String.format("E-%s", serverDescriptor.getExtraInfoDigest());
        this.addReference(String.format("S-%s", serverDescriptor.getServerDescriptorDigest()), string, 0.01, serverDescriptor.getPublishedMillis() + 21600000L);
    }

    private void readExtraInfoDescriptor(ExtraInfoDescriptor extraInfoDescriptor) {
        this.addReference(String.format("E-%s", extraInfoDescriptor.getExtraInfoDigest()), "", 0.005, extraInfoDescriptor.getPublishedMillis() + 21600000L);
    }

    private void readMicrodescriptor(Microdescriptor microdescriptor) {
        this.addReference(String.format("D-%s", microdescriptor.getMicrodescriptorDigest()), "", 0.0, this.currentTimeMillis + 2592000000L);
    }

    private void addReference(String string, String string2, double d, long l) {
        this.references.add(new Reference(string.toUpperCase(), string2.toUpperCase(), d, l));
    }

    private void dropStaleReferences() {
        TreeSet<Reference> treeSet = new TreeSet<Reference>();
        for (Reference reference : this.references) {
            if (this.currentTimeMillis > reference.expiresAfterMillis) continue;
            treeSet.add(reference);
        }
        this.references = treeSet;
    }

    private void checkReferences() {
        HashSet<String> hashSet = new HashSet<String>();
        for (Reference reference : this.references) {
            hashSet.add(reference.referencing);
        }
        double d = 0.0;
        TreeSet<String> treeSet = new TreeSet<String>();
        StringBuilder stringBuilder = new StringBuilder("Missing referenced descriptors:");
        for (Reference reference : this.references) {
            if (reference.referenced.length() <= 0 || hashSet.contains(reference.referenced)) continue;
            if (!treeSet.contains(reference.referenced)) {
                d += reference.weight;
            }
            treeSet.add(reference.referenced);
            stringBuilder.append(String.format("%n%s -> %s (%.4f -> %.4f)", reference.referencing, reference.referenced, reference.weight, d));
        }
        logger.info(stringBuilder.toString());
        if (d > 0.999) {
            logger.warn("Missing too many referenced descriptors (" + d + ").");
        }
    }

    private void writeReferencesFile() {
        Gson gson = new Gson();
        try {
            FileWriter fileWriter = new FileWriter(this.referencesFile);
            gson.toJson(this.references, (Appendable)fileWriter);
            fileWriter.close();
        }
        catch (IOException iOException) {
            logger.warn("Cannot write references file for next run.", iOException);
        }
    }

    static {
        dateTimeFormat.setLenient(false);
        dateTimeFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    private static class Reference
    implements Comparable<Reference> {
        private String referencing;
        private String referenced;
        private double weight;
        private long expiresAfterMillis;

        public Reference() {
        }

        public Reference(String string, String string2, double d, long l) {
            this.referencing = string;
            this.referenced = string2;
            this.weight = d;
            this.expiresAfterMillis = l;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Reference)) {
                return false;
            }
            Reference reference = (Reference)object;
            return this.referencing.equals(reference.referencing) && this.referenced.equals(reference.referenced);
        }

        public int hashCode() {
            return this.referencing.hashCode() + this.referenced.hashCode();
        }

        @Override
        public int compareTo(Reference reference) {
            int n = this.referencing.compareTo(reference.referencing);
            if (n == 0) {
                n = this.referenced.compareTo(reference.referenced);
            }
            return n;
        }
    }
}

