/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.collector.cron;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.collector.conf.Configuration;
import org.torproject.collector.conf.ConfigurationException;
import org.torproject.collector.conf.Key;
import org.torproject.collector.conf.SourceType;
import org.torproject.collector.sync.SyncManager;
import org.torproject.descriptor.Descriptor;

public abstract class CollecTorMain
extends SyncManager
implements Callable<Object>,
Observer,
Runnable {
    private static final Logger logger = LoggerFactory.getLogger(CollecTorMain.class);
    private static final long LIMIT_MB = 200L;
    public static final String SOURCES = "Sources";
    private final AtomicBoolean newConfigAvailable = new AtomicBoolean(false);
    protected Configuration config = new Configuration();
    private Configuration newConfig;
    protected final Map<String, Class<? extends Descriptor>> mapPathDescriptors = new HashMap<String, Class<? extends Descriptor>>();

    public CollecTorMain(Configuration configuration) {
        this.config.putAll(configuration.getPropertiesCopy());
        configuration.addObserver(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        CollecTorMain collecTorMain = this;
        synchronized (collecTorMain) {
            if (this.newConfigAvailable.get()) {
                logger.info("Module {} is using the new configuration.", (Object)this.module());
                Configuration configuration = this.newConfig;
                synchronized (configuration) {
                    this.config.clear();
                    this.config.putAll(this.newConfig.getPropertiesCopy());
                    this.newConfigAvailable.set(false);
                }
            }
        }
        try {
            if (!this.isSyncOnly()) {
                logger.info("Starting {} module of CollecTor.", (Object)this.module());
                this.startProcessing();
                logger.info("Terminating {} module of CollecTor.", (Object)this.module());
            }
        }
        catch (Throwable throwable) {
            logger.error("The {} module failed: {}", this.module(), throwable.getMessage(), throwable);
        }
        try {
            if (this.isSync()) {
                logger.info("Starting sync-run of module {} of CollecTor.", (Object)this.module());
                this.merge(this.config, this.syncMarker(), this.syncMapPathsDescriptors());
                logger.info("Finished sync-run of module {} of CollecTor.", (Object)this.module());
            }
        }
        catch (Throwable throwable) {
            logger.error("Sync-run of {} module failed: {}", this.module(), throwable.getMessage(), throwable);
        }
    }

    private boolean isSync() throws ConfigurationException {
        String string = this.syncMarker() + SOURCES;
        return Key.has(string) && this.config.getSourceTypeSet(Key.valueOf(string)).contains((Object)SourceType.Sync);
    }

    private boolean isSyncOnly() throws ConfigurationException {
        String string = this.syncMarker() + SOURCES;
        return this.isSync() && this.config.getSourceTypeSet(Key.valueOf(string)).size() == 1;
    }

    @Override
    public final Object call() {
        this.run();
        return null;
    }

    @Override
    public synchronized void update(Observable observable, Object object) {
        this.newConfigAvailable.set(true);
        if (observable instanceof Configuration) {
            this.newConfig = (Configuration)observable;
            logger.info("Module {} just received a new configuration.", (Object)this.module());
        }
    }

    protected abstract void startProcessing() throws ConfigurationException;

    protected abstract String syncMarker();

    public abstract String module();

    public Map<String, Class<? extends Descriptor>> syncMapPathsDescriptors() {
        return Collections.unmodifiableMap(this.mapPathDescriptors);
    }

    public static void checkAvailableSpace(Path path) {
        try {
            long l = Files.getFileStore(path.toFile().getAbsoluteFile().toPath().getRoot()).getUsableSpace() / 1024L / 1024L;
            if (l < 200L) {
                logger.warn("Available storage critical for {}; only {} MiB left.", (Object)path, (Object)l);
            } else {
                logger.trace("Available storage for {}: {} MiB", (Object)path, (Object)l);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("Cannot access " + path + " reason: " + iOException.getMessage(), iOException);
        }
    }
}

