/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.collector.bridgedescs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.collector.bridgedescs.SanitizedBridgesWriter;
import org.torproject.collector.conf.ConfigurationException;

public class BridgeDescriptorParser {
    private SanitizedBridgesWriter sbw;
    private static final Logger logger = LoggerFactory.getLogger(BridgeDescriptorParser.class);

    public BridgeDescriptorParser(SanitizedBridgesWriter sanitizedBridgesWriter) {
        if (null == sanitizedBridgesWriter) {
            throw new IllegalArgumentException("SanitizedBridgesWriter has to be provided, but was null.");
        }
        this.sbw = sanitizedBridgesWriter;
    }

    public void parse(byte[] byArray, String string, String string2) throws ConfigurationException {
        try {
            BufferedReader bufferedReader = new BufferedReader(new StringReader(new String(byArray, "US-ASCII")));
            String string3 = bufferedReader.readLine();
            if (string3 == null) {
                return;
            }
            if (string3.startsWith("router ")) {
                this.sbw.sanitizeAndStoreServerDescriptor(byArray);
            } else if (string3.startsWith("extra-info ")) {
                this.sbw.sanitizeAndStoreExtraInfoDescriptor(byArray);
            } else {
                this.sbw.sanitizeAndStoreNetworkStatus(byArray, string, string2);
            }
        }
        catch (IOException iOException) {
            logger.warn("Could not parse or write bridge descriptor.", iOException);
            return;
        }
    }
}

