/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.collector.sync;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.collector.conf.Configuration;
import org.torproject.collector.conf.ConfigurationException;
import org.torproject.collector.conf.Key;
import org.torproject.collector.persist.BridgeExtraInfoPersistence;
import org.torproject.collector.persist.BridgeServerDescriptorPersistence;
import org.torproject.collector.persist.ConsensusPersistence;
import org.torproject.collector.persist.DescriptorPersistence;
import org.torproject.collector.persist.ExitlistPersistence;
import org.torproject.collector.persist.ExtraInfoPersistence;
import org.torproject.collector.persist.MicroConsensusPersistence;
import org.torproject.collector.persist.PersistenceUtils;
import org.torproject.collector.persist.ServerDescriptorPersistence;
import org.torproject.collector.persist.StatusPersistence;
import org.torproject.collector.persist.VotePersistence;
import org.torproject.descriptor.BridgeExtraInfoDescriptor;
import org.torproject.descriptor.BridgeNetworkStatus;
import org.torproject.descriptor.BridgeServerDescriptor;
import org.torproject.descriptor.Descriptor;
import org.torproject.descriptor.ExitList;
import org.torproject.descriptor.RelayExtraInfoDescriptor;
import org.torproject.descriptor.RelayNetworkStatusConsensus;
import org.torproject.descriptor.RelayNetworkStatusVote;
import org.torproject.descriptor.RelayServerDescriptor;

public class SyncPersistence {
    private static final Logger log = LoggerFactory.getLogger(SyncPersistence.class);
    private final Path recentPath;
    private final Path outputPath;
    private final String recentPathName;
    private final String outputPathName;
    private static final String DASH = "-";

    public SyncPersistence(Configuration configuration) throws ConfigurationException {
        this.recentPath = configuration.getPath(Key.RecentPath);
        this.recentPathName = this.recentPath.toString();
        this.outputPath = configuration.getPath(Key.OutputPath);
        this.outputPathName = this.outputPath.toString();
    }

    public void storeDescs(List<Descriptor> list, String string, long l) {
        for (Descriptor descriptor : list) {
            boolean bl = false;
            block23: for (Class<?> clazz : descriptor.getClass().getInterfaces()) {
                DescriptorPersistence descriptorPersistence = null;
                switch (clazz.getSimpleName()) {
                    case "RelayNetworkStatusVote": {
                        descriptorPersistence = new VotePersistence((RelayNetworkStatusVote)descriptor, l);
                        break;
                    }
                    case "RelayNetworkStatusConsensus": {
                        RelayNetworkStatusConsensus relayNetworkStatusConsensus = (RelayNetworkStatusConsensus)descriptor;
                        if (null == relayNetworkStatusConsensus.getConsensusFlavor()) {
                            descriptorPersistence = new ConsensusPersistence(relayNetworkStatusConsensus, l);
                            break;
                        }
                        if (!"microdesc".equals(relayNetworkStatusConsensus.getConsensusFlavor())) break;
                        descriptorPersistence = new MicroConsensusPersistence(relayNetworkStatusConsensus, l);
                        break;
                    }
                    case "RelayServerDescriptor": {
                        descriptorPersistence = new ServerDescriptorPersistence((RelayServerDescriptor)descriptor, l);
                        break;
                    }
                    case "BridgeExtraInfoDescriptor": {
                        descriptorPersistence = new BridgeExtraInfoPersistence((BridgeExtraInfoDescriptor)descriptor, l);
                        break;
                    }
                    case "RelayExtraInfoDescriptor": {
                        descriptorPersistence = new ExtraInfoPersistence((RelayExtraInfoDescriptor)descriptor, l);
                        break;
                    }
                    case "BridgeNetworkStatus": {
                        descriptorPersistence = new StatusPersistence((BridgeNetworkStatus)descriptor, string.split(DASH)[2], l);
                        break;
                    }
                    case "BridgeServerDescriptor": {
                        descriptorPersistence = new BridgeServerDescriptorPersistence((BridgeServerDescriptor)descriptor, l);
                        break;
                    }
                    case "ExitList": {
                        descriptorPersistence = new ExitlistPersistence((ExitList)descriptor, l);
                        break;
                    }
                    default: {
                        log.trace("Invalid descriptor type {} for sync-merge.", (Object)clazz.getName());
                        continue block23;
                    }
                }
                if (null == descriptorPersistence) break;
                descriptorPersistence.storeAll(this.recentPathName, this.outputPathName);
                bl = true;
                break;
            }
            if (bl) continue;
            log.error("Unknown descriptor type {} implementing {}.", (Object)descriptor.getClass().getSimpleName(), (Object)descriptor.getClass().getInterfaces());
        }
        try {
            PersistenceUtils.cleanDirectory(this.recentPath);
        }
        catch (IOException iOException) {
            log.error("Cleaning of {} failed.", (Object)this.recentPath.toString(), (Object)iOException);
        }
    }
}

