/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.collector.sync;

import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.collector.conf.Configuration;
import org.torproject.collector.conf.ConfigurationException;
import org.torproject.collector.conf.Key;
import org.torproject.collector.sync.ProcessCriterium;
import org.torproject.collector.sync.SyncPersistence;
import org.torproject.descriptor.Descriptor;
import org.torproject.descriptor.DescriptorFile;
import org.torproject.descriptor.DescriptorReader;
import org.torproject.descriptor.DescriptorSourceFactory;
import org.torproject.descriptor.index.DescriptorIndexCollector;

public class SyncManager {
    private static final Logger log = LoggerFactory.getLogger(SyncManager.class);
    public static final String SYNCORIGINS = "SyncOrigins";
    private Date collectionDate;

    public void merge(Configuration configuration, String string, Map<String, Class<? extends Descriptor>> map) throws ConfigurationException {
        URL[] uRLArray = configuration.getUrlArray(Key.valueOf(string + SYNCORIGINS));
        this.collectionDate = new Date();
        this.collectFromOtherInstances(uRLArray, map.keySet(), string, configuration);
        this.mergeWithLocalStorage(uRLArray, map, string, configuration);
    }

    private void collectFromOtherInstances(URL[] uRLArray, Set<String> set, String string, Configuration configuration) throws ConfigurationException {
        Path path = configuration.getPath(Key.SyncPath);
        DescriptorIndexCollector descriptorIndexCollector = new DescriptorIndexCollector();
        for (URL uRL : uRLArray) {
            try {
                File file = new File(path.toFile(), string + "-" + uRL.getHost());
                file.mkdirs();
                log.info("Collecting {} from {} ...", (Object)string, (Object)uRL.getHost());
                descriptorIndexCollector.collectDescriptors(uRL.toString(), set.toArray(new String[set.size()]), 0L, file, true);
                log.info("Done collecting {} from {}.", (Object)string, (Object)uRL.getHost());
            }
            catch (Throwable throwable) {
                log.warn("Cannot download {} from {}.", set, uRL, throwable);
            }
        }
    }

    private void mergeWithLocalStorage(URL[] uRLArray, Map<String, Class<? extends Descriptor>> map, String string, Configuration configuration) throws ConfigurationException {
        Path path = configuration.getPath(Key.SyncPath);
        SyncPersistence syncPersistence = new SyncPersistence(configuration);
        for (URL uRL : uRLArray) {
            File file = new File(path.toFile(), string + "-" + uRL.getHost());
            log.info("Merging {} from {} into storage ...", (Object)string, (Object)uRL.getHost());
            for (Map.Entry<String, Class<? extends Descriptor>> entry : map.entrySet()) {
                DescriptorReader descriptorReader = DescriptorSourceFactory.createDescriptorReader();
                descriptorReader.addDirectory(new File(file, entry.getKey()));
                String string2 = entry.getValue().getSimpleName() + (entry.getKey().contains("consensus-microdesc") ? "-micro" : "");
                descriptorReader.setExcludeFiles(new File(path.toFile(), "sync-history-" + uRL.getHost() + "-" + string + "-" + string2));
                log.info("Reading {} of type {} ... ", (Object)string, (Object)string2);
                Iterator<DescriptorFile> iterator = descriptorReader.readDescriptors();
                log.info("Done reading {} of type {}.", (Object)string, (Object)string2);
                ProcessCriterium processCriterium = new ProcessCriterium(entry.getValue());
                while (iterator.hasNext()) {
                    DescriptorFile descriptorFile = iterator.next();
                    log.debug("Operating on desc-file containing {} descs.", (Object)descriptorFile.getDescriptors().size());
                    if (!processCriterium.applies(descriptorFile)) {
                        log.warn("Not processing {} in {}.", (Object)descriptorFile.getFileName(), (Object)descriptorFile.getDirectory());
                        continue;
                    }
                    Exception exception = descriptorFile.getException();
                    if (null != exception) {
                        log.warn("Parsing of {} caused Exception(s). Processing anyway.", (Object)(descriptorFile.getDirectory() + "/" + descriptorFile.getFileName()), (Object)exception);
                    }
                    syncPersistence.storeDescs(descriptorFile.getDescriptors(), descriptorFile.getFile().getName(), this.collectionDate.getTime());
                }
            }
            log.info("Done merging {} from {}.", (Object)string, (Object)uRL.getHost());
        }
    }
}

