/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.collector.relaydescs;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.zip.InflaterInputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.collector.relaydescs.RelayDescriptorParser;

public class RelayDescriptorDownloader {
    private File missingDescriptorsFile;
    private SortedMap<String, String> missingDescriptors;
    private Map<String, Set<String>> microdescriptorKeys;
    private Set<String> missingMicrodescriptors;
    private File lastDownloadedAllDescriptorsFile;
    private Map<String, String> lastDownloadedAllDescriptors;
    private RelayDescriptorParser rdp;
    private List<String> authorities;
    private List<String> authorityFingerprints;
    private boolean downloadCurrentConsensus;
    private boolean downloadCurrentMicrodescConsensus;
    private boolean downloadCurrentVotes;
    private boolean downloadMissingServerDescriptors;
    private boolean downloadMissingExtraInfos;
    private boolean downloadMissingMicrodescriptors;
    private boolean downloadAllServerDescriptors;
    private boolean downloadAllExtraInfos;
    private boolean downloadCompressed;
    private String currentValidAfter;
    private String descriptorCutOff;
    private String downloadAllDescriptorsCutOff;
    private Set<String> downloadAllDescriptorsFromAuthorities;
    private String currentTimestamp;
    private static final Logger logger = LoggerFactory.getLogger(RelayDescriptorDownloader.class);
    private Map<String, Integer> requestsByAuthority;
    private int oldMissingConsensuses = 0;
    private int oldMissingMicrodescConsensuses = 0;
    private int oldMissingVotes = 0;
    private int oldMissingServerDescriptors = 0;
    private int oldMissingExtraInfoDescriptors = 0;
    private int oldMissingMicrodescriptors = 0;
    private int newMissingConsensuses = 0;
    private int newMissingMicrodescConsensuses = 0;
    private int newMissingVotes = 0;
    private int newMissingServerDescriptors = 0;
    private int newMissingExtraInfoDescriptors = 0;
    private int newMissingMicrodescriptors = 0;
    private int requestedConsensuses = 0;
    private int requestedMicrodescConsensuses = 0;
    private int requestedVotes = 0;
    private int requestedMissingServerDescriptors = 0;
    private int requestedAllServerDescriptors = 0;
    private int requestedMissingExtraInfoDescriptors = 0;
    private int requestedAllExtraInfoDescriptors = 0;
    private int requestedMissingMicrodescriptors = 0;
    private int downloadedConsensuses = 0;
    private int downloadedMicrodescConsensuses = 0;
    private int downloadedVotes = 0;
    private int downloadedMissingServerDescriptors = 0;
    private int downloadedAllServerDescriptors = 0;
    private int downloadedMissingExtraInfoDescriptors = 0;
    private int downloadedAllExtraInfoDescriptors = 0;
    private int downloadedMissingMicrodescriptors = 0;

    public RelayDescriptorDownloader(RelayDescriptorParser relayDescriptorParser, String[] stringArray, String[] stringArray2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9) {
        String string;
        String[] stringArray3;
        String string22;
        Object object;
        this.rdp = relayDescriptorParser;
        this.authorities = Arrays.asList(stringArray);
        this.authorityFingerprints = Arrays.asList(stringArray2);
        this.downloadCurrentConsensus = bl;
        this.downloadCurrentMicrodescConsensus = bl2;
        this.downloadCurrentVotes = bl3;
        this.downloadMissingServerDescriptors = bl4;
        this.downloadMissingExtraInfos = bl5;
        this.downloadMissingMicrodescriptors = bl6;
        this.downloadAllServerDescriptors = bl7;
        this.downloadAllExtraInfos = bl8;
        this.downloadCompressed = bl9;
        Collections.shuffle(this.authorities);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        long l = System.currentTimeMillis();
        this.currentValidAfter = simpleDateFormat.format(l / 3600000L * 3600000L);
        this.descriptorCutOff = simpleDateFormat.format(l - 86400000L);
        this.currentTimestamp = simpleDateFormat.format(l);
        this.downloadAllDescriptorsCutOff = simpleDateFormat.format(l - 82800000L - 1800000L);
        this.missingDescriptors = new TreeMap<String, String>();
        this.microdescriptorKeys = new HashMap<String, Set<String>>();
        this.missingMicrodescriptors = new HashSet<String>();
        this.missingDescriptorsFile = new File("stats/missing-relay-descriptors");
        if (this.missingDescriptorsFile.exists()) {
            try {
                logger.debug("Reading file " + this.missingDescriptorsFile.getAbsolutePath() + "...");
                object = new BufferedReader(new FileReader(this.missingDescriptorsFile));
                while ((string22 = ((BufferedReader)object).readLine()) != null) {
                    if (string22.split(",").length > 2) {
                        stringArray3 = string22.split(",")[1];
                        if ((!string22.startsWith("consensus,") && !string22.startsWith("consensus-microdesc,") && !string22.startsWith("vote,") || !this.currentValidAfter.equals(stringArray3)) && (!string22.startsWith("server,") && !string22.startsWith("extra,") && !string22.startsWith("micro,") || this.descriptorCutOff.compareTo((String)stringArray3) >= 0)) continue;
                        if (string22.endsWith("NA")) {
                            if (string22.startsWith("consensus,")) {
                                ++this.oldMissingConsensuses;
                            } else if (string22.startsWith("consensus-microdesc,")) {
                                ++this.oldMissingMicrodescConsensuses;
                            } else if (string22.startsWith("vote,")) {
                                ++this.oldMissingVotes;
                            } else if (string22.startsWith("server,")) {
                                ++this.oldMissingServerDescriptors;
                            } else if (string22.startsWith("extra,")) {
                                ++this.oldMissingExtraInfoDescriptors;
                            }
                        }
                        int n = string22.lastIndexOf(",");
                        this.missingDescriptors.put(string22.substring(0, n), string22.substring(n + 1));
                        if (!string22.startsWith("micro,")) continue;
                        string = string22.split(",")[3];
                        String string3 = string22.substring(0, string22.lastIndexOf(","));
                        if (!this.microdescriptorKeys.containsKey(string)) {
                            this.microdescriptorKeys.put(string, new HashSet());
                        }
                        this.microdescriptorKeys.get(string).add(string3);
                        if (!string22.endsWith("NA") || this.missingMicrodescriptors.contains(string)) continue;
                        this.missingMicrodescriptors.add(string);
                        ++this.oldMissingMicrodescriptors;
                        continue;
                    }
                    logger.debug("Invalid line '" + string22 + "' in " + this.missingDescriptorsFile.getAbsolutePath() + ". Ignoring.");
                }
                ((BufferedReader)object).close();
                logger.debug("Finished reading file " + this.missingDescriptorsFile.getAbsolutePath() + ".");
            }
            catch (IOException iOException) {
                logger.warn("Failed to read file " + this.missingDescriptorsFile.getAbsolutePath() + "! This means that we might forget to dowload relay descriptors we are missing.", iOException);
            }
        }
        this.lastDownloadedAllDescriptors = new HashMap<String, String>();
        this.lastDownloadedAllDescriptorsFile = new File("stats/last-downloaded-all-descriptors");
        if (this.lastDownloadedAllDescriptorsFile.exists()) {
            try {
                logger.debug("Reading file " + this.lastDownloadedAllDescriptorsFile.getAbsolutePath() + "...");
                object = new BufferedReader(new FileReader(this.lastDownloadedAllDescriptorsFile));
                while ((string22 = ((BufferedReader)object).readLine()) != null) {
                    if (string22.split(",").length != 2) {
                        logger.debug("Invalid line '" + string22 + "' in " + this.lastDownloadedAllDescriptorsFile.getAbsolutePath() + ". Ignoring.");
                        continue;
                    }
                    stringArray3 = string22.split(",");
                    String string4 = stringArray3[0];
                    string = stringArray3[1];
                    this.lastDownloadedAllDescriptors.put(string4, string);
                }
                ((BufferedReader)object).close();
                logger.debug("Finished reading file " + this.lastDownloadedAllDescriptorsFile.getAbsolutePath() + ".");
            }
            catch (IOException iOException) {
                logger.warn("Failed to read file " + this.lastDownloadedAllDescriptorsFile.getAbsolutePath() + "! This means that we might download all server and extra-info descriptors more often than we should.", iOException);
            }
        }
        this.downloadAllDescriptorsFromAuthorities = new HashSet<String>();
        for (String string22 : this.authorities) {
            if (!this.lastDownloadedAllDescriptors.containsKey(string22) || this.lastDownloadedAllDescriptors.get(string22).compareTo(this.downloadAllDescriptorsCutOff) < 0) {
                this.downloadAllDescriptorsFromAuthorities.add(string22);
            }
            if (this.downloadAllDescriptorsFromAuthorities.size() < 2) continue;
            break;
        }
        this.requestsByAuthority = new HashMap<String, Integer>();
        for (String string22 : this.authorities) {
            this.requestsByAuthority.put(string22, 0);
        }
    }

    public void haveParsedConsensus(String string, Set<String> set, Set<String> set2) {
        String string2;
        if (this.currentValidAfter.equals(string)) {
            String string3 = "consensus," + string;
            this.missingDescriptors.put(string3, this.currentTimestamp);
            for (String string4 : set) {
                string2 = "vote," + string + "," + string4;
                if (this.missingDescriptors.containsKey(string2)) continue;
                this.missingDescriptors.put(string2, "NA");
                ++this.newMissingVotes;
            }
        }
        for (String string5 : set2) {
            String string4;
            string4 = string5.split(",")[0];
            if (this.descriptorCutOff.compareTo(string4) >= 0 || this.missingDescriptors.containsKey(string2 = "server," + string5)) continue;
            this.missingDescriptors.put(string2, "NA");
            ++this.newMissingServerDescriptors;
        }
    }

    public void haveParsedMicrodescConsensus(String string, Set<String> set) {
        String string2;
        if (this.currentValidAfter.equals(string)) {
            string2 = "consensus-microdesc," + string;
            this.missingDescriptors.put(string2, this.currentTimestamp);
        }
        if (this.descriptorCutOff.compareTo(string) < 0) {
            string2 = string.substring(0, "YYYY-MM".length());
            for (String string3 : set) {
                String string4 = "micro," + string3;
                String string5 = "NA";
                String string6 = string3.split(",")[2];
                if (this.microdescriptorKeys.containsKey(string6)) {
                    for (String string7 : this.microdescriptorKeys.get(string6)) {
                        String string8;
                        String string9 = string7.split(",")[1];
                        if (!string9.startsWith(string2) || (string8 = (String)this.missingDescriptors.get(string7)) == null || string8.equals("NA")) continue;
                        string5 = string8;
                        break;
                    }
                } else {
                    this.microdescriptorKeys.put(string6, new HashSet());
                }
                this.microdescriptorKeys.get(string6).add(string4);
                this.missingDescriptors.put(string4, string5);
                if (!string5.equals("NA") || this.missingMicrodescriptors.contains(string6)) continue;
                this.missingMicrodescriptors.add(string6);
                ++this.newMissingMicrodescriptors;
            }
        }
    }

    public void haveParsedVote(String string, String string2, Set<String> set) {
        if (this.currentValidAfter.equals(string)) {
            String string3 = "vote," + string + "," + string2;
            this.missingDescriptors.put(string3, this.currentTimestamp);
        }
        for (String string4 : set) {
            String string5;
            String string6 = string4.split(",")[0];
            if (this.descriptorCutOff.compareTo(string6) >= 0 || this.missingDescriptors.containsKey(string5 = "server," + string4)) continue;
            this.missingDescriptors.put(string5, "NA");
            ++this.newMissingServerDescriptors;
        }
    }

    public void haveParsedServerDescriptor(String string, String string2, String string3, String string4) {
        if (this.descriptorCutOff.compareTo(string) < 0) {
            String string5;
            String string6 = "server," + string + "," + string2 + "," + string3;
            this.missingDescriptors.put(string6, this.currentTimestamp);
            if (string4 != null && !this.missingDescriptors.containsKey(string5 = "extra," + string + "," + string2 + "," + string4)) {
                this.missingDescriptors.put(string5, "NA");
                ++this.newMissingExtraInfoDescriptors;
            }
        }
    }

    public void haveParsedExtraInfoDescriptor(String string, String string2, String string3) {
        if (this.descriptorCutOff.compareTo(string) < 0) {
            String string4 = "extra," + string + "," + string2 + "," + string3;
            this.missingDescriptors.put(string4, this.currentTimestamp);
        }
    }

    public void haveParsedMicrodescriptor(String string) {
        if (this.microdescriptorKeys.containsKey(string)) {
            for (String string2 : this.microdescriptorKeys.get(string)) {
                String string3 = string2.split(",")[0];
                if (this.descriptorCutOff.compareTo(string3) >= 0) continue;
                this.missingDescriptors.put(string2, this.currentTimestamp);
            }
            this.missingMicrodescriptors.remove(string);
        }
    }

    public void downloadDescriptors() {
        String[] stringArray;
        String string;
        String string2 = "consensus," + this.currentValidAfter;
        if (!this.missingDescriptors.containsKey(string2)) {
            this.missingDescriptors.put(string2, "NA");
            ++this.newMissingConsensuses;
        }
        if (!this.missingDescriptors.containsKey(string = "consensus-microdesc," + this.currentValidAfter)) {
            this.missingDescriptors.put(string, "NA");
            ++this.newMissingMicrodescConsensuses;
        }
        for (String string3 : this.authorityFingerprints) {
            stringArray = "vote," + this.currentValidAfter + "," + string3;
            if (this.missingDescriptors.containsKey(stringArray)) continue;
            this.missingDescriptors.put((String)stringArray, "NA");
            ++this.newMissingVotes;
        }
        for (String string3 : this.authorities) {
            try {
                if (this.downloadCurrentConsensus && this.missingDescriptors.containsKey(string2) && ((String)this.missingDescriptors.get(string2)).equals("NA")) {
                    ++this.requestedConsensuses;
                    this.downloadedConsensuses += this.downloadResourceFromAuthority(string3, "/tor/status-vote/current/consensus");
                }
                if (this.downloadCurrentMicrodescConsensus && this.missingDescriptors.containsKey(string) && ((String)this.missingDescriptors.get(string)).equals("NA")) {
                    ++this.requestedMicrodescConsensuses;
                    this.downloadedMicrodescConsensuses += this.downloadResourceFromAuthority(string3, "/tor/status-vote/current/consensus-microdesc");
                }
                if (this.downloadCurrentVotes) {
                    stringArray = "vote," + this.currentValidAfter;
                    TreeSet<String> treeSet = new TreeSet<String>();
                    for (Map.Entry<String, String> entry : this.missingDescriptors.entrySet()) {
                        if (!entry.getValue().equals("NA") || !entry.getKey().startsWith((String)stringArray)) continue;
                        String string4 = entry.getKey().split(",")[2];
                        treeSet.add(string4);
                    }
                    for (String string5 : treeSet) {
                        ++this.requestedVotes;
                        this.downloadedVotes += this.downloadResourceFromAuthority(string3, "/tor/status-vote/current/" + string5);
                    }
                }
                for (String string6 : new String[]{"server", "extra", "micro"}) {
                    if (this.downloadAllDescriptorsFromAuthorities.contains(string3) && (string6.equals("server") && this.downloadAllServerDescriptors || string6.equals("extra") && this.downloadAllExtraInfos)) {
                        int n = this.downloadResourceFromAuthority(string3, "/tor/" + string6 + "/all");
                        if (string6.equals("server")) {
                            ++this.requestedAllServerDescriptors;
                            this.downloadedAllServerDescriptors += n;
                            continue;
                        }
                        if (!string6.equals("extra")) continue;
                        ++this.requestedAllExtraInfoDescriptors;
                        this.downloadedAllExtraInfoDescriptors += n;
                        continue;
                    }
                    if (!(string6.equals("server") && this.downloadMissingServerDescriptors || string6.equals("extra") && this.downloadMissingExtraInfos) && (!string6.equals("micro") || !this.downloadMissingMicrodescriptors)) continue;
                    TreeSet<String> treeSet = new TreeSet<String>();
                    for (Map.Entry<String, String> entry : this.missingDescriptors.entrySet()) {
                        if (!entry.getValue().equals("NA") || !entry.getKey().startsWith(string6 + ",") || this.descriptorCutOff.compareTo(entry.getKey().split(",")[1]) >= 0) continue;
                        String string7 = entry.getKey().split(",")[3];
                        treeSet.add(string7);
                    }
                    Object object = null;
                    int n = 0;
                    int n2 = 0;
                    int n3 = 0;
                    int n4 = string6.equals("micro") ? 92 : 96;
                    String string8 = string6.equals("micro") ? "-" : "+";
                    for (String string9 : treeSet) {
                        if (n >= n4) {
                            n2 += n;
                            n3 += this.downloadResourceFromAuthority(string3, ((StringBuilder)object).toString());
                            object = null;
                            n = 0;
                        }
                        if (n == 0) {
                            object = new StringBuilder("/tor/" + string6 + "/d/" + string9);
                        } else {
                            ((StringBuilder)object).append(string8 + string9);
                        }
                        ++n;
                    }
                    if (n > 0) {
                        n2 += n;
                        n3 += this.downloadResourceFromAuthority(string3, ((StringBuilder)object).toString());
                    }
                    if (string6.equals("server")) {
                        this.requestedMissingServerDescriptors += n2;
                        this.downloadedMissingServerDescriptors += n3;
                        continue;
                    }
                    if (string6.equals("extra")) {
                        this.requestedMissingExtraInfoDescriptors += n2;
                        this.downloadedMissingExtraInfoDescriptors += n3;
                        continue;
                    }
                    if (!string6.equals("micro")) continue;
                    this.requestedMissingMicrodescriptors += n2;
                    this.downloadedMissingMicrodescriptors += n3;
                }
            }
            catch (IOException iOException) {
                logger.debug("Failed downloading from " + string3 + "!", iOException);
            }
        }
    }

    private int downloadResourceFromAuthority(String string, String string2) throws IOException {
        int n;
        block12: {
            Object object;
            byte[] byArray;
            block14: {
                block13: {
                    byArray = null;
                    this.requestsByAuthority.put(string, this.requestsByAuthority.get(string) + 1);
                    String string3 = "http://" + string + string2 + (this.downloadCompressed && !string2.startsWith("/tor/extra/") ? ".z" : "");
                    URL uRL = new URL(string3);
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                    httpURLConnection.setRequestMethod("GET");
                    httpURLConnection.connect();
                    int n2 = httpURLConnection.getResponseCode();
                    if (n2 == 200) {
                        int n3;
                        BufferedInputStream bufferedInputStream = this.downloadCompressed && !string2.startsWith("/tor/extra/") ? new BufferedInputStream(new InflaterInputStream(httpURLConnection.getInputStream())) : new BufferedInputStream(httpURLConnection.getInputStream());
                        object = new ByteArrayOutputStream();
                        byte[] byArray2 = new byte[1024];
                        while ((n3 = bufferedInputStream.read(byArray2, 0, 1024)) >= 0) {
                            ((ByteArrayOutputStream)object).write(byArray2, 0, n3);
                        }
                        bufferedInputStream.close();
                        byArray = ((ByteArrayOutputStream)object).toByteArray();
                    }
                    logger.debug("Downloaded " + string3 + " -> " + n2 + " (" + (byArray == null ? 0 : byArray.length) + " bytes)");
                    n = 0;
                    if (byArray == null) break block12;
                    if (!string2.startsWith("/tor/status-vote/current/")) break block13;
                    this.rdp.parse(byArray);
                    n = 1;
                    break block12;
                }
                if (!string2.startsWith("/tor/server/") && !string2.startsWith("/tor/extra/")) break block14;
                if (string2.equals("/tor/server/all") || string2.equals("/tor/extra/all")) {
                    this.lastDownloadedAllDescriptors.put(string, this.currentTimestamp);
                }
                object = null;
                try {
                    object = new String(byArray, "US-ASCII");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                int n4 = -1;
                int n5 = -1;
                int n6 = -1;
                String string4 = string2.startsWith("/tor/server/") ? "router " : "extra-info ";
                String string5 = "\nrouter-signature\n";
                String string6 = "\n-----END SIGNATURE-----\n";
                while (n6 < ((String)object).length() && (n4 = ((String)object).indexOf(string4, n6)) >= 0 && (n5 = ((String)object).indexOf(string5, n4)) >= 0 && (n6 = ((String)object).indexOf(string6, n5 += string5.length())) >= 0) {
                    byte[] byArray3 = new byte[(n6 += string6.length()) - n4];
                    System.arraycopy(byArray, n4, byArray3, 0, n6 - n4);
                    this.rdp.parse(byArray3);
                    ++n;
                }
                break block12;
            }
            if (!string2.startsWith("/tor/micro/")) break block12;
            object = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            ((DateFormat)object).setTimeZone(TimeZone.getTimeZone("UTC"));
            String string7 = null;
            try {
                string7 = new String(byArray, "US-ASCII");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            int n7 = -1;
            int n8 = -1;
            String string8 = "onion-key\n";
            while (n8 < string7.length() && (n7 = string7.indexOf(string8, n8)) >= 0 && ((n8 = string7.indexOf(string8, n7 + 1)) >= 0 || (n8 = string7.length()) > n7)) {
                byte[] byArray4 = new byte[n8 - n7];
                System.arraycopy(byArray, n7, byArray4, 0, n8 - n7);
                String string9 = Base64.encodeBase64String(DigestUtils.sha256(byArray4)).replaceAll("=", "");
                if (!this.microdescriptorKeys.containsKey(string9)) continue;
                String string10 = DigestUtils.sha256Hex(byArray4);
                for (String string11 : this.microdescriptorKeys.get(string9)) {
                    String string12 = string11.split(",")[1];
                    try {
                        long l = ((DateFormat)object).parse(string12).getTime();
                        this.rdp.storeMicrodescriptor(byArray4, string10, string9, l);
                    }
                    catch (ParseException parseException) {
                        logger.warn("Could not parse valid-after time '" + string12 + "' in microdescriptor key. Not storing microdescriptor.", parseException);
                    }
                }
                ++n;
            }
        }
        return n;
    }

    public void writeFile() {
        String string;
        String string2;
        Appendable appendable;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        try {
            logger.debug("Writing file " + this.missingDescriptorsFile.getAbsolutePath() + "...");
            this.missingDescriptorsFile.getParentFile().mkdirs();
            appendable = new BufferedWriter(new FileWriter(this.missingDescriptorsFile));
            for (Map.Entry<String, String> object : this.missingDescriptors.entrySet()) {
                string2 = object.getKey();
                string = object.getValue();
                if (string.equals("NA")) {
                    if (string2.startsWith("consensus,")) {
                        ++n;
                    } else if (string2.startsWith("consensus-microdesc,")) {
                        ++n2;
                    } else if (string2.startsWith("vote,")) {
                        ++n3;
                    } else if (string2.startsWith("server,")) {
                        ++n4;
                    } else if (string2.startsWith("extra,")) {
                        ++n5;
                    } else if (string2.startsWith("micro,")) {
                        // empty if block
                    }
                }
                ((Writer)appendable).write(string2 + "," + string + "\n");
            }
            ((BufferedWriter)appendable).close();
            logger.debug("Finished writing file " + this.missingDescriptorsFile.getAbsolutePath() + ".");
        }
        catch (IOException iOException) {
            logger.warn("Failed writing " + this.missingDescriptorsFile.getAbsolutePath() + "!", iOException);
        }
        try {
            logger.debug("Writing file " + this.lastDownloadedAllDescriptorsFile.getAbsolutePath() + "...");
            this.lastDownloadedAllDescriptorsFile.getParentFile().mkdirs();
            appendable = new BufferedWriter(new FileWriter(this.lastDownloadedAllDescriptorsFile));
            for (Map.Entry<String, String> entry : this.lastDownloadedAllDescriptors.entrySet()) {
                string2 = entry.getKey();
                string = entry.getValue();
                ((Writer)appendable).write(string2 + "," + string + "\n");
            }
            ((BufferedWriter)appendable).close();
            logger.debug("Finished writing file " + this.lastDownloadedAllDescriptorsFile.getAbsolutePath() + ".");
        }
        catch (IOException iOException) {
            logger.warn("Failed writing " + this.lastDownloadedAllDescriptorsFile.getAbsolutePath() + "!", iOException);
        }
        logger.info("Finished downloading relay descriptors from the directory authorities.");
        logger.info("At the beginning of this execution, we were missing " + this.oldMissingConsensuses + " consensus(es), " + this.oldMissingMicrodescConsensuses + " microdesc consensus(es), " + this.oldMissingVotes + " vote(s), " + this.oldMissingServerDescriptors + " server descriptor(s), " + this.oldMissingExtraInfoDescriptors + " extra-info descriptor(s), and " + this.oldMissingMicrodescriptors + " microdescriptor(s).");
        logger.info("During this execution, we added " + this.newMissingConsensuses + " consensus(es), " + this.newMissingMicrodescConsensuses + " microdesc consensus(es), " + this.newMissingVotes + " vote(s), " + this.newMissingServerDescriptors + " server descriptor(s), " + this.newMissingExtraInfoDescriptors + " extra-info descriptor(s), and " + this.newMissingMicrodescriptors + " microdescriptor(s) to the missing list, some of which we also requested and removed from the list again.");
        logger.info("We requested " + this.requestedConsensuses + " consensus(es), " + this.requestedMicrodescConsensuses + " microdesc consensus(es), " + this.requestedVotes + " vote(s), " + this.requestedMissingServerDescriptors + " missing server descriptor(s), " + this.requestedAllServerDescriptors + " times all server descriptors, " + this.requestedMissingExtraInfoDescriptors + " missing extra-info descriptor(s), " + this.requestedAllExtraInfoDescriptors + " times all extra-info descriptors, and " + this.requestedMissingMicrodescriptors + " missing microdescriptor(s) from the directory authorities.");
        appendable = new StringBuilder();
        for (String string3 : this.authorities) {
            ((StringBuilder)appendable).append(" " + string3 + "=" + this.requestsByAuthority.get(string3));
        }
        logger.info("We sent these numbers of requests to the directory authorities:" + ((StringBuilder)appendable).toString());
        logger.info("We successfully downloaded " + this.downloadedConsensuses + " consensus(es), " + this.downloadedMicrodescConsensuses + " microdesc consensus(es), " + this.downloadedVotes + " vote(s), " + this.downloadedMissingServerDescriptors + " missing server descriptor(s), " + this.downloadedAllServerDescriptors + " server descriptor(s) when downloading all descriptors, " + this.downloadedMissingExtraInfoDescriptors + " missing extra-info descriptor(s), " + this.downloadedAllExtraInfoDescriptors + " extra-info descriptor(s) when downloading all descriptors, and " + this.downloadedMissingMicrodescriptors + " missing microdescriptor(s).");
        logger.info("At the end of this execution, we are missing " + n + " consensus(es), " + n2 + " microdesc consensus(es), " + n3 + " vote(s), " + n4 + " server descriptor(s), " + n5 + " extra-info descriptor(s), and " + this.missingMicrodescriptors.size() + " microdescriptor(s), some of which we may try in the next execution.");
    }
}

