/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.collector.relaydescs;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TimeZone;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.collector.conf.Annotation;
import org.torproject.collector.conf.Configuration;
import org.torproject.collector.conf.ConfigurationException;
import org.torproject.collector.conf.Key;
import org.torproject.collector.conf.SourceType;
import org.torproject.collector.cron.CollecTorMain;
import org.torproject.collector.relaydescs.ArchiveReader;
import org.torproject.collector.relaydescs.CachedRelayDescriptorReader;
import org.torproject.collector.relaydescs.ReferenceChecker;
import org.torproject.collector.relaydescs.RelayDescriptorDownloader;
import org.torproject.collector.relaydescs.RelayDescriptorParser;
import org.torproject.descriptor.DescriptorParseException;
import org.torproject.descriptor.DescriptorParser;
import org.torproject.descriptor.DescriptorSourceFactory;
import org.torproject.descriptor.RelayExtraInfoDescriptor;
import org.torproject.descriptor.RelayNetworkStatusConsensus;
import org.torproject.descriptor.RelayNetworkStatusVote;
import org.torproject.descriptor.RelayServerDescriptor;

public class ArchiveWriter
extends CollecTorMain {
    private static final Logger logger = LoggerFactory.getLogger(ArchiveWriter.class);
    private long now = System.currentTimeMillis();
    private String outputDirectory;
    private String rsyncCatString;
    private DescriptorParser descriptorParser;
    private int storedConsensusesCounter = 0;
    private int storedMicrodescConsensusesCounter = 0;
    private int storedVotesCounter = 0;
    private int storedCertsCounter = 0;
    private int storedServerDescriptorsCounter = 0;
    private int storedExtraInfoDescriptorsCounter = 0;
    private int storedMicrodescriptorsCounter = 0;
    private SortedMap<Long, SortedSet<String>> storedConsensuses = new TreeMap<Long, SortedSet<String>>();
    private SortedMap<Long, SortedSet<String>> storedMicrodescConsensuses = new TreeMap<Long, SortedSet<String>>();
    private SortedMap<Long, Integer> expectedVotes = new TreeMap<Long, Integer>();
    private SortedMap<Long, SortedMap<String, SortedSet<String>>> storedVotes = new TreeMap<Long, SortedMap<String, SortedSet<String>>>();
    private SortedMap<Long, Map<String, String>> storedServerDescriptors = new TreeMap<Long, Map<String, String>>();
    private SortedMap<Long, Set<String>> storedExtraInfoDescriptors = new TreeMap<Long, Set<String>>();
    private SortedMap<Long, Set<String>> storedMicrodescriptors = new TreeMap<Long, Set<String>>();
    private File storedServerDescriptorsFile;
    private File storedExtraInfoDescriptorsFile;
    private File storedMicrodescriptorsFile;
    private StringBuilder intermediateStats = new StringBuilder();
    private Path recentPath;
    private String recentPathName;
    private static final String RELAY_DESCRIPTORS = "relay-descriptors";
    private static final String MICRO = "micro";
    private static final String CONSENSUS_MICRODESC = "consensus-microdesc";
    private static final String MICRODESC = "microdesc";
    private static final String MICRODESCS = "microdescs";

    public ArchiveWriter(Configuration configuration) throws ConfigurationException {
        super(configuration);
        this.mapPathDescriptors.put("recent/relay-descriptors/votes", RelayNetworkStatusVote.class);
        this.mapPathDescriptors.put("recent/relay-descriptors/consensuses", RelayNetworkStatusConsensus.class);
        this.mapPathDescriptors.put("recent/relay-descriptors/microdescs/consensus-microdesc", RelayNetworkStatusConsensus.class);
        this.mapPathDescriptors.put("recent/relay-descriptors/server-descriptors", RelayServerDescriptor.class);
        this.mapPathDescriptors.put("recent/relay-descriptors/extra-infos", RelayExtraInfoDescriptor.class);
    }

    @Override
    public String module() {
        return "relaydescs";
    }

    @Override
    protected String syncMarker() {
        return "Relay";
    }

    @Override
    protected void startProcessing() throws ConfigurationException {
        this.recentPath = this.config.getPath(Key.RecentPath);
        CollecTorMain.checkAvailableSpace(this.recentPath);
        this.recentPathName = this.recentPath.toString();
        File file = this.config.getPath(Key.StatsPath).toFile();
        this.storedServerDescriptorsFile = new File(file, "stored-server-descriptors");
        this.storedExtraInfoDescriptorsFile = new File(file, "stored-extra-info-descriptors");
        this.storedMicrodescriptorsFile = new File(file, "stored-microdescriptors");
        File file2 = this.config.getPath(Key.StatsPath).toFile();
        this.outputDirectory = Paths.get(this.config.getPath(Key.OutputPath).toString(), RELAY_DESCRIPTORS).toString();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.rsyncCatString = simpleDateFormat.format(System.currentTimeMillis());
        this.descriptorParser = DescriptorSourceFactory.createDescriptorParser();
        this.loadDescriptorDigests();
        RelayDescriptorParser relayDescriptorParser = new RelayDescriptorParser(this);
        RelayDescriptorDownloader relayDescriptorDownloader = null;
        Set<SourceType> set = this.config.getSourceTypeSet(Key.RelaySources);
        if (set.contains((Object)SourceType.Remote)) {
            String[] stringArray = this.config.getStringArray(Key.DirectoryAuthoritiesAddresses);
            relayDescriptorDownloader = new RelayDescriptorDownloader(relayDescriptorParser, stringArray, this.config.getStringArray(Key.DirectoryAuthoritiesFingerprintsForVotes), true, true, true, true, true, true, this.config.getBool(Key.DownloadAllServerDescriptors), this.config.getBool(Key.DownloadAllExtraInfoDescriptors), this.config.getBool(Key.CompressRelayDescriptorDownloads));
            relayDescriptorParser.setRelayDescriptorDownloader(relayDescriptorDownloader);
        }
        if (set.contains((Object)SourceType.Cache)) {
            new CachedRelayDescriptorReader(relayDescriptorParser, this.config.getStringArray(Key.RelayCacheOrigins), file2);
            this.intermediateStats("importing relay descriptors from local Tor data directories");
        }
        if (set.contains((Object)SourceType.Local)) {
            new ArchiveReader(relayDescriptorParser, this.config.getPath(Key.RelayLocalOrigins).toFile(), file2, this.config.getBool(Key.KeepDirectoryArchiveImportHistory));
            this.intermediateStats("importing relay descriptors from local directory");
        }
        if (relayDescriptorDownloader != null) {
            relayDescriptorDownloader.downloadDescriptors();
            relayDescriptorDownloader.writeFile();
            relayDescriptorDownloader = null;
            this.intermediateStats("downloading relay descriptors from the directory authorities");
        }
        this.checkMissingDescriptors();
        this.checkStaledescriptors();
        this.cleanUpRsyncDirectory();
        this.saveDescriptorDigests();
        new ReferenceChecker(this.recentPath.toFile(), new File(file, "references"), new File(file, "references-history")).check();
        CollecTorMain.checkAvailableSpace(this.recentPath);
        this.cleanUp();
    }

    private void cleanUp() {
        this.expectedVotes.clear();
        this.intermediateStats = new StringBuilder();
        this.storedConsensuses.clear();
        this.storedMicrodescConsensuses.clear();
        this.storedVotes.clear();
        this.storedServerDescriptors.clear();
        this.storedExtraInfoDescriptors.clear();
        this.storedMicrodescriptors.clear();
    }

    private void loadDescriptorDigests() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            String string;
            long l;
            String[] stringArray;
            String string2;
            BufferedReader bufferedReader;
            if (this.storedServerDescriptorsFile.exists()) {
                bufferedReader = new BufferedReader(new FileReader(this.storedServerDescriptorsFile));
                while ((string2 = bufferedReader.readLine()) != null) {
                    stringArray = string2.split(",");
                    if (stringArray.length != 3) {
                        logger.warn("Could not load server descriptor digests because of illegal line '" + string2 + "'.  We might not be able to correctly check descriptors for completeness.");
                        break;
                    }
                    l = simpleDateFormat.parse(stringArray[0]).getTime();
                    if (l < this.now - 172800000L) continue;
                    if (!this.storedServerDescriptors.containsKey(l)) {
                        this.storedServerDescriptors.put(l, new HashMap());
                    }
                    string = stringArray[1];
                    String string3 = stringArray[2].equals("NA") ? null : stringArray[2];
                    ((Map)this.storedServerDescriptors.get(l)).put(string, string3);
                }
                bufferedReader.close();
            }
            if (this.storedExtraInfoDescriptorsFile.exists()) {
                bufferedReader = new BufferedReader(new FileReader(this.storedExtraInfoDescriptorsFile));
                while ((string2 = bufferedReader.readLine()) != null) {
                    stringArray = string2.split(",");
                    if (stringArray.length != 2) {
                        logger.warn("Could not load extra-info descriptor digests because of illegal line '" + string2 + "'.  We might not be able to correctly check descriptors for completeness.");
                        break;
                    }
                    l = simpleDateFormat.parse(stringArray[0]).getTime();
                    if (l < this.now - 172800000L) continue;
                    if (!this.storedExtraInfoDescriptors.containsKey(l)) {
                        this.storedExtraInfoDescriptors.put(l, new HashSet());
                    }
                    string = stringArray[1];
                    ((Set)this.storedExtraInfoDescriptors.get(l)).add(string);
                }
                bufferedReader.close();
            }
            if (this.storedMicrodescriptorsFile.exists()) {
                bufferedReader = new BufferedReader(new FileReader(this.storedMicrodescriptorsFile));
                while ((string2 = bufferedReader.readLine()) != null) {
                    stringArray = string2.split(",");
                    if (stringArray.length != 2) {
                        logger.warn("Could not load microdescriptor digests because of illegal line '" + string2 + "'.  We might not be able to correctly check descriptors for completeness.");
                        break;
                    }
                    l = simpleDateFormat.parse(stringArray[0]).getTime();
                    if (l < this.now - 3456000000L) continue;
                    if (!this.storedMicrodescriptors.containsKey(l)) {
                        this.storedMicrodescriptors.put(l, new HashSet());
                    }
                    string = stringArray[1];
                    ((Set)this.storedMicrodescriptors.get(l)).add(string);
                }
                bufferedReader.close();
            }
        }
        catch (IOException | ParseException exception) {
            logger.warn("Could not load descriptor digests.  We might not be able to correctly check descriptors for completeness.", exception);
        }
    }

    public void intermediateStats(String string) {
        this.intermediateStats.append("While " + string + ", we stored " + this.storedConsensusesCounter + " consensus(es), " + this.storedMicrodescConsensusesCounter + " microdesc consensus(es), " + this.storedVotesCounter + " vote(s), " + this.storedCertsCounter + " certificate(s), " + this.storedServerDescriptorsCounter + " server descriptor(s), " + this.storedExtraInfoDescriptorsCounter + " extra-info descriptor(s), and " + this.storedMicrodescriptorsCounter + " microdescriptor(s) to disk.\n");
        this.storedConsensusesCounter = 0;
        this.storedMicrodescConsensusesCounter = 0;
        this.storedVotesCounter = 0;
        this.storedCertsCounter = 0;
        this.storedServerDescriptorsCounter = 0;
        this.storedExtraInfoDescriptorsCounter = 0;
        this.storedMicrodescriptorsCounter = 0;
    }

    private void checkMissingDescriptors() {
        boolean bl;
        boolean bl2;
        StringBuilder stringBuilder = new StringBuilder("Finished writing relay descriptors to disk.\n");
        stringBuilder.append(this.intermediateStats.toString());
        stringBuilder.append("Statistics on the completeness of written relay descriptors:");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map<String, String> hashSet2 : this.storedServerDescriptors.values()) {
            hashMap.putAll(hashSet2);
        }
        HashSet hashSet3 = new HashSet();
        for (Set<String> set : this.storedExtraInfoDescriptors.values()) {
            hashSet3.addAll(set);
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (Set<String> set : this.storedMicrodescriptors.values()) {
            hashSet.addAll(set);
        }
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        for (Map.Entry<Long, SortedSet<String>> entry : this.storedConsensuses.entrySet()) {
            int n;
            String string5;
            int n2;
            int n3;
            int n4;
            int n5;
            long l = entry.getKey();
            String string2 = simpleDateFormat.format(l);
            int n6 = 0;
            if (this.storedVotes.containsKey(l)) {
                n6 = ((SortedMap)this.storedVotes.get(l)).size();
                for (Map.Entry entry2 : ((SortedMap)this.storedVotes.get(l)).entrySet()) {
                    n5 = 0;
                    n4 = 0;
                    n3 = 0;
                    n2 = 0;
                    Object object = ((SortedSet)entry2.getValue()).iterator();
                    while (object.hasNext()) {
                        String string3 = (String)object.next();
                        ++n4;
                        if (!hashMap.containsKey(string3)) continue;
                        ++n5;
                        if (hashMap.get(string3) == null) continue;
                        string5 = (String)hashMap.get(string3);
                        ++n2;
                        if (!hashSet3.contains(string5)) continue;
                        ++n3;
                    }
                    stringBuilder.append("\nV, " + string2);
                    if (n4 > 0) {
                        stringBuilder.append(String.format(", %d/%d S (%.1f%%)", n5, n4, 100.0 * (double)n5 / (double)n4));
                    } else {
                        stringBuilder.append(", 0/0 S");
                    }
                    if (n2 > 0) {
                        stringBuilder.append(String.format(", %d/%d E (%.1f%%)", n3, n2, 100.0 * (double)n3 / (double)n2));
                    } else {
                        stringBuilder.append(", 0/0 E");
                    }
                    if (((String)(object = (String)entry2.getKey())).equalsIgnoreCase("27B6B5996C426270A5C95488AA5BCEB6BCC86956") || n5 * 1000 >= n4 * 995 && n3 * 1000 >= n2 * 995) continue;
                    bl2 = true;
                }
            }
            int n7 = 0;
            int n8 = 0;
            n5 = 0;
            n4 = 0;
            n3 = 0;
            n2 = 0;
            for (String string4 : entry.getValue()) {
                ++n8;
                if (!hashMap.containsKey(string4)) continue;
                ++n7;
                if (hashMap.get(string4) == null) continue;
                ++n4;
                string5 = (String)hashMap.get(string4);
                if (!hashSet3.contains(string5)) continue;
                ++n5;
            }
            stringBuilder.append("\nC, " + string2);
            int n9 = n = this.expectedVotes.containsKey(l) ? (Integer)this.expectedVotes.get(l) : 0;
            if (n > 0) {
                stringBuilder.append(String.format(", %d/%d V (%.1f%%)", n6, n, 100.0 * (double)n6 / (double)n));
            } else {
                stringBuilder.append(", 0/0 V");
            }
            if (n8 > 0) {
                stringBuilder.append(String.format(", %d/%d S (%.1f%%)", n7, n8, 100.0 * (double)n7 / (double)n8));
            } else {
                stringBuilder.append(", 0/0 S");
            }
            if (n4 > 0) {
                stringBuilder.append(String.format(", %d/%d E (%.1f%%)", n5, n4, 100.0 * (double)n5 / (double)n4));
            } else {
                stringBuilder.append(", 0/0 E");
            }
            if (this.storedMicrodescConsensuses.containsKey(l)) {
                for (String string5 : (SortedSet)this.storedMicrodescConsensuses.get(l)) {
                    ++n2;
                    if (!hashSet.contains(string5)) continue;
                    ++n3;
                }
                stringBuilder.append("\nM, " + string2);
                if (n2 > 0) {
                    stringBuilder.append(String.format(", %d/%d M (%.1f%%)", n3, n2, 100.0 * (double)n3 / (double)n2));
                } else {
                    stringBuilder.append(", 0/0 M");
                }
            } else {
                bl5 = true;
            }
            if (n7 * 1000 < n8 * 995 || n5 * 1000 < n4 * 995 || n3 * 1000 < n2 * 995) {
                bl2 = true;
            }
            if (n6 >= n) continue;
            bl = true;
        }
        logger.info(stringBuilder.toString());
        if (bl2) {
            logger.debug("We are missing at least 0.5% of server or extra-info descriptors referenced from a consensus or vote or at least 0.5% of microdescriptors referenced from a microdesc consensus.");
        }
        if (bl) {
            logger.debug("We are missing at least one vote that was referenced from a consensus.");
        }
        if (bl5) {
            logger.debug("We are missing at least one microdesc consensus that was published together with a known consensus.");
        }
    }

    private void checkStaledescriptors() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        long l = this.now - 19800000L;
        if (!this.storedConsensuses.isEmpty() && this.storedConsensuses.lastKey() < l) {
            logger.warn("The last known relay network status consensus was valid after " + simpleDateFormat.format(this.storedConsensuses.lastKey()) + ", which is more than 5:30 hours in the past.");
        }
        if (!this.storedMicrodescConsensuses.isEmpty() && this.storedMicrodescConsensuses.lastKey() < l) {
            logger.warn("The last known relay network status microdesc consensus was valid after " + simpleDateFormat.format(this.storedMicrodescConsensuses.lastKey()) + ", which is more than 5:30 hours in the past.");
        }
        if (!this.storedVotes.isEmpty() && this.storedVotes.lastKey() < l) {
            logger.warn("The last known relay network status vote was valid after " + simpleDateFormat.format(this.storedVotes.lastKey()) + ", which is more than 5:30 hours in the past.");
        }
        if (!this.storedServerDescriptors.isEmpty() && this.storedServerDescriptors.lastKey() < l) {
            logger.warn("The last known relay server descriptor was published at " + simpleDateFormat.format(this.storedServerDescriptors.lastKey()) + ", which is more than 5:30 hours in the past.");
        }
        if (!this.storedExtraInfoDescriptors.isEmpty() && this.storedExtraInfoDescriptors.lastKey() < l) {
            logger.warn("The last known relay extra-info descriptor was published at " + simpleDateFormat.format(this.storedExtraInfoDescriptors.lastKey()) + ", which is more than 5:30 hours in the past.");
        }
        if (!this.storedMicrodescriptors.isEmpty() && this.storedMicrodescriptors.lastKey() < l) {
            logger.warn("The last known relay microdescriptor was contained in a microdesc consensus that was valid after " + simpleDateFormat.format(this.storedMicrodescriptors.lastKey()) + ", which is more than 5:30 hours in the past.");
        }
    }

    public void cleanUpRsyncDirectory() {
        long l = System.currentTimeMillis() - 259200000L;
        long l2 = l - 2332800000L;
        Stack<File> stack = new Stack<File>();
        stack.add(new File(this.recentPathName, RELAY_DESCRIPTORS));
        while (!stack.isEmpty()) {
            File file = (File)stack.pop();
            if (file.isDirectory()) {
                stack.addAll(Arrays.asList(file.listFiles()));
                continue;
            }
            if (file.getName().endsWith("-micro")) {
                if (file.lastModified() >= l2) continue;
                file.delete();
                continue;
            }
            if (file.lastModified() < l) {
                file.delete();
                continue;
            }
            if (!file.getName().endsWith(".tmp")) continue;
            file.renameTo(new File(file.getParentFile(), file.getName().substring(0, file.getName().lastIndexOf(".tmp"))));
        }
    }

    private void saveDescriptorDigests() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            String string;
            this.storedServerDescriptorsFile.getParentFile().mkdirs();
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.storedServerDescriptorsFile));
            for (Map.Entry<Long, Map<String, String>> entry : this.storedServerDescriptors.entrySet()) {
                string = simpleDateFormat.format(entry.getKey());
                for (Map.Entry<String, String> entry2 : entry.getValue().entrySet()) {
                    String string2 = entry2.getKey();
                    String string3 = entry2.getValue() == null ? "NA" : entry2.getValue();
                    bufferedWriter.write(String.format("%s,%s,%s%n", string, string2, string3));
                }
            }
            bufferedWriter.close();
            this.storedExtraInfoDescriptorsFile.getParentFile().mkdirs();
            bufferedWriter = new BufferedWriter(new FileWriter(this.storedExtraInfoDescriptorsFile));
            for (Map.Entry<Long, Object> entry : this.storedExtraInfoDescriptors.entrySet()) {
                string = simpleDateFormat.format(entry.getKey());
                for (String string4 : (Set)entry.getValue()) {
                    bufferedWriter.write(String.format("%s,%s%n", string, string4));
                }
            }
            bufferedWriter.close();
            this.storedMicrodescriptorsFile.getParentFile().mkdirs();
            bufferedWriter = new BufferedWriter(new FileWriter(this.storedMicrodescriptorsFile));
            for (Map.Entry<Long, Object> entry : this.storedMicrodescriptors.entrySet()) {
                string = simpleDateFormat.format(entry.getKey());
                for (String string5 : (Set)entry.getValue()) {
                    bufferedWriter.write(String.format("%s,%s%n", string, string5));
                }
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            logger.warn("Could not save descriptor digests.  We might not be able to correctly check descriptors for completeness in the next run.", iOException);
        }
    }

    public void storeConsensus(byte[] byArray, long l, SortedSet<String> sortedSet, SortedSet<String> sortedSet2) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd/yyyy-MM-dd-HH-mm-ss");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        File file = Paths.get(this.outputDirectory, "consensus", simpleDateFormat.format(new Date(l)) + "-consensus").toFile();
        boolean bl = file.exists();
        File file2 = Paths.get(this.recentPathName, RELAY_DESCRIPTORS, "consensuses", file.getName()).toFile();
        File[] fileArray = new File[]{file, file2};
        if (this.store(Annotation.Consensus.bytes(), byArray, fileArray, null)) {
            ++this.storedConsensusesCounter;
        }
        if (!bl && this.now - l < 10800000L) {
            this.storedConsensuses.put(l, sortedSet2);
            this.expectedVotes.put(l, sortedSet.size());
        }
    }

    public void storeMicrodescConsensus(byte[] byArray, long l, SortedSet<String> sortedSet) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("dd/yyyy-MM-dd-HH-mm-ss");
        simpleDateFormat2.setTimeZone(TimeZone.getTimeZone("UTC"));
        File file = Paths.get(this.outputDirectory, MICRODESC, simpleDateFormat.format(l), CONSENSUS_MICRODESC, simpleDateFormat2.format(l) + "-consensus-microdesc").toFile();
        boolean bl = file.exists();
        File file2 = Paths.get(this.recentPathName, RELAY_DESCRIPTORS, MICRODESCS, CONSENSUS_MICRODESC, file.getName()).toFile();
        File[] fileArray = new File[]{file, file2};
        if (this.store(Annotation.MicroConsensus.bytes(), byArray, fileArray, null)) {
            ++this.storedMicrodescConsensusesCounter;
        }
        if (!bl && this.now - l < 10800000L) {
            this.storedMicrodescConsensuses.put(l, sortedSet);
        }
    }

    public void storeVote(byte[] byArray, long l, String string, String string2, SortedSet<String> sortedSet) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd/yyyy-MM-dd-HH-mm-ss");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        File file = Paths.get(this.outputDirectory, "vote", simpleDateFormat.format(new Date(l)) + "-vote-" + string + "-" + string2).toFile();
        boolean bl = file.exists();
        File file2 = Paths.get(this.recentPathName, RELAY_DESCRIPTORS, "votes", file.getName()).toFile();
        File[] fileArray = new File[]{file, file2};
        if (this.store(Annotation.Vote.bytes(), byArray, fileArray, null)) {
            ++this.storedVotesCounter;
        }
        if (!bl && this.now - l < 10800000L) {
            if (!this.storedVotes.containsKey(l)) {
                this.storedVotes.put(l, new TreeMap());
            }
            ((SortedMap)this.storedVotes.get(l)).put(string, sortedSet);
        }
    }

    public void storeCertificate(byte[] byArray, String string, long l) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        File file = Paths.get(this.outputDirectory, "certs", string + "-" + simpleDateFormat.format(new Date(l))).toFile();
        File[] fileArray = new File[]{file};
        if (this.store(Annotation.Cert.bytes(), byArray, fileArray, null)) {
            ++this.storedCertsCounter;
        }
    }

    public void storeServerDescriptor(byte[] byArray, String string, long l, String string2) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        File file = Paths.get(this.outputDirectory, "server-descriptor", simpleDateFormat.format(new Date(l)), string.substring(0, 1), string.substring(1, 2), string).toFile();
        boolean bl = file.exists();
        File file2 = Paths.get(this.recentPathName, RELAY_DESCRIPTORS, "server-descriptors", this.rsyncCatString + "-server-descriptors.tmp").toFile();
        File[] fileArray = new File[]{file, file2};
        boolean[] blArray = new boolean[]{false, true};
        if (this.store(Annotation.Server.bytes(), byArray, fileArray, blArray)) {
            ++this.storedServerDescriptorsCounter;
        }
        if (!bl && this.now - l < 172800000L) {
            if (!this.storedServerDescriptors.containsKey(l)) {
                this.storedServerDescriptors.put(l, new HashMap());
            }
            ((Map)this.storedServerDescriptors.get(l)).put(string, string2);
        }
    }

    public void storeExtraInfoDescriptor(byte[] byArray, String string, long l) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        File file = Paths.get(this.outputDirectory, "extra-info", simpleDateFormat.format(new Date(l)), string.substring(0, 1), string.substring(1, 2), string).toFile();
        boolean bl = file.exists();
        File file2 = Paths.get(this.recentPathName, RELAY_DESCRIPTORS, "extra-infos", this.rsyncCatString + "-extra-infos.tmp").toFile();
        File[] fileArray = new File[]{file, file2};
        boolean[] blArray = new boolean[]{false, true};
        if (this.store(Annotation.ExtraInfo.bytes(), byArray, fileArray, blArray)) {
            ++this.storedExtraInfoDescriptorsCounter;
        }
        if (!bl && this.now - l < 172800000L) {
            if (!this.storedExtraInfoDescriptors.containsKey(l)) {
                this.storedExtraInfoDescriptors.put(l, new HashSet());
            }
            ((Set)this.storedExtraInfoDescriptors.get(l)).add(string);
        }
    }

    public void storeMicrodescriptor(byte[] byArray, String string, long l) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        File file = Paths.get(this.outputDirectory, MICRODESC, simpleDateFormat.format(l), MICRO, string.substring(0, 1), string.substring(1, 2), string).toFile();
        boolean bl = file.exists();
        File file2 = Paths.get(this.recentPathName, RELAY_DESCRIPTORS, MICRODESCS, MICRO, this.rsyncCatString + "-micro.tmp").toFile();
        File[] fileArray = new File[]{file, file2};
        boolean[] blArray = new boolean[]{false, true};
        if (this.store(Annotation.Microdescriptor.bytes(), byArray, fileArray, blArray)) {
            ++this.storedMicrodescriptorsCounter;
        }
        if (!bl && this.now - l < 3456000000L) {
            if (!this.storedMicrodescriptors.containsKey(l)) {
                this.storedMicrodescriptors.put(l, new HashSet());
            }
            ((Set)this.storedMicrodescriptors.get(l)).add(string);
        }
    }

    private boolean store(byte[] byArray, byte[] byArray2, File[] fileArray, boolean[] blArray) {
        try {
            logger.trace("Storing " + fileArray[0]);
            if (this.descriptorParser.parseDescriptors(byArray2, fileArray[0].getName()).size() != 1) {
                logger.info("Relay descriptor file " + fileArray[0] + " doesn't contain exactly one descriptor.  Storing anyway.");
            }
        }
        catch (DescriptorParseException descriptorParseException) {
            logger.info("Could not parse relay descriptor " + fileArray[0] + " before storing it to disk.  Storing anyway.", descriptorParseException);
        }
        try {
            for (int i = 0; i < fileArray.length; ++i) {
                File file = fileArray[i];
                boolean bl = blArray == null ? false : blArray[i];
                file.getParentFile().mkdirs();
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file, bl));
                if (byArray2.length > 0 && byArray2[0] != 64) {
                    bufferedOutputStream.write(byArray, 0, byArray.length);
                }
                bufferedOutputStream.write(byArray2, 0, byArray2.length);
                bufferedOutputStream.close();
            }
            return true;
        }
        catch (IOException iOException) {
            logger.warn("Could not store relay descriptor " + fileArray[0], iOException);
            return false;
        }
    }
}

