/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.collector.persist;

import java.io.UnsupportedEncodingException;
import java.nio.file.Paths;
import org.apache.commons.codec.digest.DigestUtils;
import org.torproject.collector.conf.Annotation;
import org.torproject.collector.persist.DescriptorPersistence;
import org.torproject.collector.persist.PersistenceUtils;
import org.torproject.descriptor.RelayNetworkStatusVote;

public class VotePersistence
extends DescriptorPersistence<RelayNetworkStatusVote> {
    private static final String VOTE = "vote";
    private static final String VOTES = "votes";

    public VotePersistence(RelayNetworkStatusVote relayNetworkStatusVote, long l) {
        super(relayNetworkStatusVote, Annotation.Vote.bytes());
        this.calculatePaths(l);
    }

    private void calculatePaths(long l) {
        String string = PersistenceUtils.dateTime(((RelayNetworkStatusVote)this.desc).getValidAfterMillis());
        String[] stringArray = string.split("-");
        String string2 = VotePersistence.calcDigestFromBytes(((RelayNetworkStatusVote)this.desc).getRawDescriptorBytes());
        string = string + "-vote-" + ((RelayNetworkStatusVote)this.desc).getSignatures().get(0).getIdentity() + "-" + string2;
        this.recentPath = Paths.get("relay-descriptors", VOTES, string).toString();
        this.storagePath = Paths.get("relay-descriptors", VOTE, stringArray[0], stringArray[1], stringArray[2], string).toString();
    }

    private static String calcDigestFromBytes(byte[] byArray) {
        String string = "";
        String string2 = "network-status-version ";
        String string3 = "directory-signature ";
        try {
            String string4 = new String(byArray, "US-ASCII");
            int n = string4.indexOf(string2);
            int n2 = string4.indexOf(string3);
            if (n >= 0 && n2 >= 0 && n2 > n) {
                byte[] byArray2 = new byte[(n2 += string3.length()) - n];
                System.arraycopy(byArray, n, byArray2, 0, n2 - n);
                string = DigestUtils.shaHex(byArray2).toUpperCase();
            } else {
                log.error("No digest calculation possible.  Returning empty string.");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            log.error("Unsupported encoding.  Returning empty string.", unsupportedEncodingException);
        }
        return string;
    }
}

