/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.collector.persist;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceUtils {
    private static final Logger log = LoggerFactory.getLogger(PersistenceUtils.class);
    public static final String TEMPFIX = ".tmp";

    public static boolean storeToFileSystem(byte[] byArray, byte[] byArray2, Path path, StandardOpenOption standardOpenOption) {
        return PersistenceUtils.storeToFileSystem(byArray, byArray2, path, standardOpenOption, false);
    }

    public static boolean storeToFileSystem(byte[] byArray, byte[] byArray2, Path path, StandardOpenOption standardOpenOption, boolean bl) {
        Path path2 = path;
        try {
            if (bl) {
                path2 = new File(path.toFile().getParent(), path.toFile().getName() + TEMPFIX).toPath();
                if (Files.exists(path, new LinkOption[0]) && StandardOpenOption.CREATE_NEW == standardOpenOption) {
                    return false;
                }
                if (Files.exists(path, new LinkOption[0]) && !Files.exists(path2, new LinkOption[0]) && StandardOpenOption.APPEND == standardOpenOption) {
                    Files.copy(path, path2, StandardCopyOption.REPLACE_EXISTING);
                }
            }
            return PersistenceUtils.createOrAppend(byArray, byArray2, path2, standardOpenOption);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            log.debug("Already have descriptor(s) of type '{}': {}. Skipping.", (Object)new String(byArray), (Object)path);
        }
        catch (IOException | SecurityException | UnsupportedOperationException exception) {
            log.warn("Could not store descriptor(s) {} of type '{}'", path, new String(byArray), exception);
        }
        catch (Throwable throwable) {
            log.warn("Problem storing descriptor(s) {} of type '{}'", path, new String(byArray), throwable);
        }
        return false;
    }

    private static boolean createOrAppend(byte[] byArray, byte[] byArray2, Path path, StandardOpenOption standardOpenOption) throws IOException {
        StandardOpenOption standardOpenOption2 = standardOpenOption;
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        if (byArray2.length > 0 && byArray2[0] != 64) {
            Files.write(path, byArray, standardOpenOption2, StandardOpenOption.CREATE);
            standardOpenOption2 = StandardOpenOption.APPEND;
        }
        Files.write(path, byArray2, standardOpenOption2, StandardOpenOption.CREATE);
        return true;
    }

    public static void cleanDirectory(Path path) throws IOException {
        SimpleFileVisitor<Path> simpleFileVisitor = new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                String string = path.toString();
                if (string.endsWith(PersistenceUtils.TEMPFIX)) {
                    Path path2 = Paths.get(string.substring(0, string.length() - PersistenceUtils.TEMPFIX.length()), new String[0]);
                    Files.deleteIfExists(path2);
                    path.toFile().renameTo(path2.toFile());
                }
                return FileVisitResult.CONTINUE;
            }
        };
        Files.walkFileTree(path, (FileVisitor<? super Path>)simpleFileVisitor);
    }

    public static String[] dateTimeParts(long l) {
        return PersistenceUtils.dateTimeParts(new Date(l));
    }

    public static String[] dateTimeParts(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return simpleDateFormat.format(date).split("-");
    }

    public static String dateTime(long l) {
        return PersistenceUtils.dateTime(new Date(l));
    }

    public static String dateTime(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return simpleDateFormat.format(date);
    }
}

