/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.collector.persist;

import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.collector.persist.PersistenceUtils;
import org.torproject.descriptor.Descriptor;

public abstract class DescriptorPersistence<T extends Descriptor> {
    protected static final Logger log = LoggerFactory.getLogger(DescriptorPersistence.class);
    protected static final String BRIDGEDESCS = "bridge-descriptors";
    protected static final String DASH = "-";
    protected static final String MICRODESC = "microdesc";
    protected static final String MICRODESCS = "microdescs";
    protected static final String RELAYDESCS = "relay-descriptors";
    protected static final String EXTRA_INFO = "extra-info";
    protected static final String EXTRA_INFOS = "extra-infos";
    protected static final String SERVERDESC = "server-descriptor";
    protected static final String SERVERDESCS = "server-descriptors";
    protected final T desc;
    protected final byte[] annotation;
    protected String storagePath;
    protected String recentPath;

    protected DescriptorPersistence(T t, byte[] byArray) {
        this.desc = t;
        this.annotation = byArray;
    }

    public boolean storeAll(String string, String string2) {
        return this.storeAll(string, string2, StandardOpenOption.APPEND, StandardOpenOption.CREATE_NEW);
    }

    public boolean storeAll(String string, String string2, StandardOpenOption standardOpenOption, StandardOpenOption standardOpenOption2) {
        if (this.storeOut(string2, standardOpenOption2)) {
            return this.storeRecent(string, standardOpenOption);
        }
        return false;
    }

    public boolean storeRecent(String string) {
        return this.storeRecent(string, StandardOpenOption.APPEND);
    }

    public boolean storeRecent(String string, StandardOpenOption standardOpenOption) {
        return PersistenceUtils.storeToFileSystem(this.annotation, this.desc.getRawDescriptorBytes(), Paths.get(string, this.getRecentPath()), standardOpenOption, true);
    }

    public boolean storeOut(String string) {
        return this.storeOut(string, StandardOpenOption.CREATE_NEW);
    }

    public boolean storeOut(String string, StandardOpenOption standardOpenOption) {
        return PersistenceUtils.storeToFileSystem(this.annotation, this.desc.getRawDescriptorBytes(), Paths.get(string, this.getStoragePath()), standardOpenOption);
    }

    public String getStoragePath() {
        if (null == this.storagePath) {
            throw new RuntimeException("Storage path not initialized!");
        }
        return this.storagePath;
    }

    public String getRecentPath() {
        if (null == this.recentPath) {
            throw new RuntimeException("Recent path not initialized!");
        }
        return this.recentPath;
    }
}

