/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.collector.bridgedescs;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.SortedMap;
import java.util.Stack;
import java.util.TimeZone;
import java.util.TreeMap;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.collector.bridgedescs.BridgeDescriptorParser;
import org.torproject.collector.bridgedescs.BridgeSnapshotReader;
import org.torproject.collector.conf.Annotation;
import org.torproject.collector.conf.Configuration;
import org.torproject.collector.conf.ConfigurationException;
import org.torproject.collector.conf.Key;
import org.torproject.collector.cron.CollecTorMain;
import org.torproject.descriptor.BridgeExtraInfoDescriptor;
import org.torproject.descriptor.BridgeNetworkStatus;
import org.torproject.descriptor.BridgeServerDescriptor;

public class SanitizedBridgesWriter
extends CollecTorMain {
    private static final Logger logger = LoggerFactory.getLogger(SanitizedBridgesWriter.class);
    private static final String BRIDGE_DESCRIPTORS = "bridge-descriptors";
    private String rsyncCatString;
    private File bridgeDirectoriesDirectory;
    private File sanitizedBridgesDirectory;
    private boolean replaceIpAddressesWithHashes;
    private boolean persistenceProblemWithSecrets;
    private SortedMap<String, byte[]> secretsForHashingIpAddresses;
    private String bridgeSanitizingCutOffTimestamp;
    private boolean haveWarnedAboutInterval;
    private File bridgeIpSecretsFile;
    private SecureRandom secureRandom;
    private String outputPathName;
    private String recentPathName;
    private String maxNetworkStatusPublishedTime = "1970-01-01 00:00:00";
    private String maxServerDescriptorPublishedTime = "1970-01-01 00:00:00";
    private String maxExtraInfoDescriptorPublishedTime = "1970-01-01 00:00:00";

    public SanitizedBridgesWriter(Configuration configuration) {
        super(configuration);
        this.mapPathDescriptors.put("recent/bridge-descriptors/statuses", BridgeNetworkStatus.class);
        this.mapPathDescriptors.put("recent/bridge-descriptors/server-descriptors", BridgeServerDescriptor.class);
        this.mapPathDescriptors.put("recent/bridge-descriptors/extra-infos", BridgeExtraInfoDescriptor.class);
    }

    @Override
    public String module() {
        return "bridgedescs";
    }

    @Override
    protected String syncMarker() {
        return "Bridge";
    }

    @Override
    protected void startProcessing() throws ConfigurationException {
        long l;
        String[] stringArray;
        this.outputPathName = Paths.get(this.config.getPath(Key.OutputPath).toString(), BRIDGE_DESCRIPTORS).toString();
        this.recentPathName = Paths.get(this.config.getPath(Key.RecentPath).toString(), BRIDGE_DESCRIPTORS).toString();
        File file = this.config.getPath(Key.BridgeLocalOrigins).toFile();
        File file2 = new File(this.outputPathName);
        File file3 = this.config.getPath(Key.StatsPath).toFile();
        if (file == null || file2 == null || file3 == null) {
            throw new ConfigurationException("BridgeSnapshotsDirectory, SanitizedBridgesWriteDirectory, StatsPath should be set. Please, edit the 'collector.properties' file.");
        }
        this.bridgeDirectoriesDirectory = file;
        this.sanitizedBridgesDirectory = file2;
        this.replaceIpAddressesWithHashes = this.config.getBool(Key.ReplaceIpAddressesWithHashes);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.rsyncCatString = simpleDateFormat.format(System.currentTimeMillis());
        if (this.replaceIpAddressesWithHashes) {
            try {
                this.secureRandom = SecureRandom.getInstance("SHA1PRNG", "SUN");
            }
            catch (GeneralSecurityException generalSecurityException) {
                logger.warn("Could not initialize secure random number generator! Not calculating any IP address hashes in this execution!", generalSecurityException);
                this.persistenceProblemWithSecrets = true;
            }
        }
        this.secretsForHashingIpAddresses = new TreeMap<String, byte[]>();
        this.bridgeIpSecretsFile = new File(file3, "bridge-ip-secrets");
        if (this.bridgeIpSecretsFile.exists()) {
            try {
                String string;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(this.bridgeIpSecretsFile));
                while ((string = bufferedReader.readLine()) != null) {
                    stringArray = string.split(",");
                    if (string.length() != "yyyy-MM,".length() + 62 && string.length() != "yyyy-MM,".length() + 100 && string.length() != "yyyy-MM,".length() + 166 || stringArray.length != 2) {
                        logger.warn("Invalid line in bridge-ip-secrets file starting with '" + string.substring(0, 7) + "'! Not calculating any IP address hashes in this execution!");
                        this.persistenceProblemWithSecrets = true;
                        break;
                    }
                    String string2 = stringArray[0];
                    byte[] byArray = Hex.decodeHex(stringArray[1].toCharArray());
                    this.secretsForHashingIpAddresses.put(string2, byArray);
                }
                bufferedReader.close();
                if (!this.persistenceProblemWithSecrets) {
                    logger.debug("Read " + this.secretsForHashingIpAddresses.size() + " secrets for hashing bridge IP addresses.");
                }
            }
            catch (DecoderException decoderException) {
                logger.warn("Failed to decode hex string in " + this.bridgeIpSecretsFile + "! Not calculating any IP address hashes in this execution!", decoderException);
                this.persistenceProblemWithSecrets = true;
            }
            catch (IOException iOException) {
                logger.warn("Failed to read " + this.bridgeIpSecretsFile + "! Not calculating any IP address hashes in this execution!", iOException);
                this.persistenceProblemWithSecrets = true;
            }
        }
        if ((l = (long)this.config.getInt(Key.BridgeDescriptorMappingsLimit)) >= 0L) {
            stringArray = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            stringArray.setTimeZone(TimeZone.getTimeZone("UTC"));
            this.bridgeSanitizingCutOffTimestamp = stringArray.format(System.currentTimeMillis() - 86400000L * l);
        } else {
            this.bridgeSanitizingCutOffTimestamp = "1999-12-31 23:59:59";
        }
        stringArray = new BridgeDescriptorParser(this);
        new BridgeSnapshotReader((BridgeDescriptorParser)stringArray, this.bridgeDirectoriesDirectory, file3);
        this.finishWriting();
        this.checkStaleDescriptors();
        this.cleanUpRsyncDirectory();
    }

    private String scrubOrAddress(String string, byte[] byArray, String string2) throws IOException {
        if (!string.contains(":")) {
            return null;
        }
        String string3 = string.substring(0, string.lastIndexOf(":"));
        String string4 = string.substring(string.lastIndexOf(":") + 1);
        String string5 = null;
        string5 = string3.startsWith("[") ? this.scrubIpv6Address(string3, byArray, string2) : this.scrubIpv4Address(string3, byArray, string2);
        String string6 = this.scrubTcpPort(string4, byArray, string2);
        return string5 == null ? null : string5 + ":" + string6;
    }

    private String scrubIpv4Address(String string, byte[] byArray, String string2) throws IOException {
        if (this.replaceIpAddressesWithHashes) {
            if (this.persistenceProblemWithSecrets) {
                return null;
            }
            byte[] byArray2 = new byte[55];
            String[] stringArray = string.split("\\.");
            for (int i = 0; i < 4; ++i) {
                byArray2[i] = (byte)Integer.parseInt(stringArray[i]);
            }
            System.arraycopy(byArray, 0, byArray2, 4, 20);
            String string3 = string2.substring(0, "yyyy-MM".length());
            byte[] byArray3 = this.getSecretForMonth(string3);
            System.arraycopy(byArray3, 0, byArray2, 24, 31);
            byte[] byArray4 = DigestUtils.sha256(byArray2);
            String string4 = "10." + (byArray4[0] + 256) % 256 + "." + (byArray4[1] + 256) % 256 + "." + (byArray4[2] + 256) % 256;
            return string4;
        }
        return "127.0.0.1";
    }

    private String scrubIpv6Address(String string, byte[] byArray, String string2) throws IOException {
        StringBuilder stringBuilder = new StringBuilder("[fd9f:2e19:3bcf::");
        if (this.replaceIpAddressesWithHashes) {
            Object object;
            Object object2;
            String string32;
            if (this.persistenceProblemWithSecrets) {
                return null;
            }
            String[] stringArray = string.substring(1, string.length() - 1).split("::", -1);
            if (stringArray.length > 2) {
                return null;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string32 : stringArray) {
                object2 = new StringBuilder();
                object = string32.split(":", -1);
                if (((String[])object).length < 1 || ((String[])object).length > 8) {
                    return null;
                }
                for (int i = 0; i < ((String[])object).length; ++i) {
                    String string4 = object[i];
                    if (string4.contains(".")) {
                        String[] stringArray2 = string4.split("\\.");
                        byte[] byArray2 = new byte[4];
                        if (stringArray2.length != 4) {
                            return null;
                        }
                        for (int j = 0; j < 4; ++j) {
                            byArray2[j] = (byte)Integer.parseInt(stringArray2[j]);
                        }
                        ((StringBuilder)object2).append(Hex.encodeHexString(byArray2));
                        continue;
                    }
                    if (string4.length() > 4) {
                        return null;
                    }
                    for (int j = string4.length(); j < 4; ++j) {
                        ((StringBuilder)object2).append("0");
                    }
                    ((StringBuilder)object2).append(string4);
                }
                arrayList.add(((StringBuilder)object2).toString());
            }
            StringBuilder stringBuilder2 = new StringBuilder();
            stringBuilder2.append((String)arrayList.get(0));
            if (arrayList.size() == 2) {
                for (int i = 32 - ((String)arrayList.get(0)).length() - ((String)arrayList.get(1)).length(); i > 0; --i) {
                    stringBuilder2.append("0");
                }
                stringBuilder2.append((String)arrayList.get(1));
            }
            byte[] byArray3 = null;
            try {
                byArray3 = Hex.decodeHex(stringBuilder2.toString().toCharArray());
            }
            catch (DecoderException decoderException) {
                return null;
            }
            if (byArray3.length != 16) {
                return null;
            }
            byte[] byArray4 = new byte[55];
            System.arraycopy(byArray3, 0, byArray4, 0, 16);
            System.arraycopy(byArray, 0, byArray4, 16, 20);
            string32 = string2.substring(0, "yyyy-MM".length());
            object2 = this.getSecretForMonth(string32);
            System.arraycopy(object2, 31, byArray4, 36, 19);
            object = DigestUtils.sha256Hex(byArray4);
            stringBuilder.append(((String)object).substring(((String)object).length() - 6, ((String)object).length() - 4));
            stringBuilder.append(":");
            stringBuilder.append(((String)object).substring(((String)object).length() - 4));
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private String scrubTcpPort(String string, byte[] byArray, String string2) throws IOException {
        if (string.equals("0")) {
            return "0";
        }
        if (this.replaceIpAddressesWithHashes) {
            if (this.persistenceProblemWithSecrets) {
                return null;
            }
            byte[] byArray2 = new byte[55];
            int n = Integer.parseInt(string);
            byArray2[0] = (byte)(n >> 8);
            byArray2[1] = (byte)n;
            System.arraycopy(byArray, 0, byArray2, 2, 20);
            String string3 = string2.substring(0, "yyyy-MM".length());
            byte[] byArray3 = this.getSecretForMonth(string3);
            System.arraycopy(byArray3, 50, byArray2, 22, 33);
            byte[] byArray4 = DigestUtils.sha256(byArray2);
            int n2 = ((byArray4[0] & 0xFF) << 8 | byArray4[1] & 0xFF) >> 2 | 0xC000;
            return String.valueOf(n2);
        }
        return "1";
    }

    private byte[] getSecretForMonth(String string) throws IOException {
        if (!this.secretsForHashingIpAddresses.containsKey(string) || ((byte[])this.secretsForHashingIpAddresses.get(string)).length < 83) {
            byte[] byArray = new byte[83];
            this.secureRandom.nextBytes(byArray);
            if (this.secretsForHashingIpAddresses.containsKey(string)) {
                System.arraycopy(this.secretsForHashingIpAddresses.get(string), 0, byArray, 0, ((byte[])this.secretsForHashingIpAddresses.get(string)).length);
            }
            if (string.compareTo(this.bridgeSanitizingCutOffTimestamp) < 0) {
                logger.warn("Generated a secret that we won't make persistent, because it's outside our bridge descriptor sanitizing interval.");
            } else {
                try {
                    if (!this.bridgeIpSecretsFile.exists()) {
                        this.bridgeIpSecretsFile.getParentFile().mkdirs();
                    }
                    BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.bridgeIpSecretsFile, this.bridgeIpSecretsFile.exists()));
                    bufferedWriter.write(string + "," + Hex.encodeHexString(byArray) + "\n");
                    bufferedWriter.close();
                }
                catch (IOException iOException) {
                    logger.warn("Could not store new secret to disk! Not calculating any IP address or TCP port hashes in this execution!", iOException);
                    this.persistenceProblemWithSecrets = true;
                    throw new IOException(iOException);
                }
            }
            this.secretsForHashingIpAddresses.put(string, byArray);
        }
        return (byte[])this.secretsForHashingIpAddresses.get(string);
    }

    public void sanitizeAndStoreNetworkStatus(byte[] byArray, String string, String string2) throws ConfigurationException {
        Object object;
        File[] fileArray;
        Object object2;
        Object object3;
        String string3;
        String string4;
        Object object4;
        CharSequence charSequence;
        CharSequence charSequence2;
        if (this.persistenceProblemWithSecrets) {
            return;
        }
        if (string.compareTo(this.maxNetworkStatusPublishedTime) > 0) {
            this.maxNetworkStatusPublishedTime = string;
        }
        if (this.bridgeSanitizingCutOffTimestamp.compareTo(string) > 0) {
            charSequence2 = "Sanitizing and storing network status with publication time outside our descriptor sanitizing interval.";
            if (this.haveWarnedAboutInterval) {
                logger.debug((String)charSequence2);
            } else {
                logger.warn((String)charSequence2);
                this.haveWarnedAboutInterval = true;
            }
        }
        charSequence2 = new StringBuilder();
        TreeMap<File[], String> treeMap = new TreeMap<File[], String>();
        try {
            charSequence = new StringBuilder();
            object4 = new BufferedReader(new StringReader(new String(byArray, "US-ASCII")));
            string4 = null;
            string3 = null;
            object3 = null;
            object2 = null;
            fileArray = null;
            while ((string4 = ((BufferedReader)object4).readLine()) != null) {
                if (string4.startsWith("published ")) {
                    string = string4.substring("published ".length());
                    continue;
                }
                if (string4.startsWith("flag-thresholds ")) {
                    ((StringBuilder)charSequence2).append(string4 + "\n");
                    continue;
                }
                if (string4.startsWith("r ")) {
                    String[] stringArray;
                    if (((StringBuilder)charSequence).length() > 0) {
                        String string5 = ((StringBuilder)charSequence).toString();
                        treeMap.put(fileArray, string5);
                        charSequence = new StringBuilder();
                    }
                    if ((stringArray = string4.split(" ")).length < 9) {
                        logger.warn("Illegal line '" + string4 + "' in bridge network status.  Skipping descriptor.");
                        return;
                    }
                    if (!Base64.isBase64(stringArray[2])) {
                        logger.warn("Illegal base64 character in r line '" + stringArray[2] + "'.  Skipping descriptor.");
                        return;
                    }
                    object3 = Base64.decodeBase64(stringArray[2] + "==");
                    object2 = stringArray[4] + " " + stringArray[5];
                    String string6 = stringArray[6];
                    String string7 = stringArray[7];
                    String string8 = stringArray[8];
                    if (((String)object2).compareTo(string) <= 0 && (string3 == null || ((String)object2).compareTo(string3) > 0)) {
                        string3 = object2;
                    }
                    object = DigestUtils.sha((byte[])object3);
                    String string9 = Base64.encodeBase64String((byte[])object).substring(0, 27);
                    fileArray = Hex.encodeHexString((byte[])object);
                    String string10 = stringArray[3];
                    String string11 = Base64.encodeBase64String(DigestUtils.sha(Base64.decodeBase64(string10 + "=="))).substring(0, 27);
                    String string12 = this.scrubIpv4Address(string6, (byte[])object3, (String)object2);
                    String string13 = stringArray[1];
                    String string14 = this.scrubTcpPort(string7, (byte[])object3, (String)object2);
                    String string15 = this.scrubTcpPort(string8, (byte[])object3, (String)object2);
                    ((StringBuilder)charSequence).append("r " + string13 + " " + (String)string9 + " " + string11 + " " + (String)object2 + " " + string12 + " " + string14 + " " + string15 + "\n");
                    continue;
                }
                if (string4.startsWith("a ")) {
                    String string16 = this.scrubOrAddress(string4.substring("a ".length()), (byte[])object3, (String)object2);
                    if (string16 != null) {
                        ((StringBuilder)charSequence).append("a " + string16 + "\n");
                        continue;
                    }
                    logger.warn("Invalid address in line '" + string4 + "' in bridge network status.  Skipping line!");
                    continue;
                }
                if (string4.startsWith("s ") || string4.equals("s") || string4.startsWith("w ") || string4.equals("w") || string4.startsWith("p ") || string4.equals("p")) {
                    ((StringBuilder)charSequence).append(string4 + "\n");
                    continue;
                }
                logger.debug("Unknown line '" + string4 + "' in bridge network status. Not writing to disk!");
                return;
            }
            ((BufferedReader)object4).close();
            if (((StringBuilder)charSequence).length() > 0) {
                String string17 = ((StringBuilder)charSequence).toString();
                treeMap.put(fileArray, string17);
                charSequence = new StringBuilder();
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            if (simpleDateFormat.parse(string).getTime() - simpleDateFormat.parse(string3).getTime() > 3600000L) {
                logger.warn("The most recent descriptor in the bridge network status published at " + string + " was published at " + string3 + " which is more than 1 hour before the status. This is a sign for the status being stale. Please check!");
            }
        }
        catch (ParseException parseException) {
            logger.warn("Could not parse timestamp in bridge network status.", parseException);
            return;
        }
        catch (IOException iOException) {
            logger.warn("Could not parse bridge network status.", iOException);
            return;
        }
        try {
            charSequence = string.substring(0, 4);
            object4 = string.substring(5, 7);
            string4 = string.substring(8, 10);
            string3 = string.substring(11, 13) + string.substring(14, 16) + string.substring(17, 19);
            object3 = new File(this.sanitizedBridgesDirectory.getAbsolutePath() + "/" + (String)charSequence + "/" + (String)object4 + "/statuses/" + string4 + "/" + (String)charSequence + (String)object4 + string4 + "-" + string3 + "-" + string2);
            object2 = new File(this.recentPathName, "statuses/" + ((File)object3).getName());
            for (File file : fileArray = new File[]{object3, object2}) {
                file.getParentFile().mkdirs();
                object = new BufferedWriter(new FileWriter(file));
                ((Writer)object).write(Annotation.Status.toString());
                ((Writer)object).write("published " + string + "\n");
                ((Writer)object).write(((StringBuilder)charSequence2).toString());
                for (String string10 : treeMap.values()) {
                    ((Writer)object).write(string10);
                }
                ((BufferedWriter)object).close();
            }
        }
        catch (IOException iOException) {
            logger.warn("Could not write sanitized bridge network status to disk.", iOException);
            return;
        }
    }

    public void sanitizeAndStoreServerDescriptor(byte[] byArray) {
        Serializable serializable;
        Object object;
        Object object2;
        String string;
        String string2;
        CharSequence charSequence;
        Object object3;
        if (this.persistenceProblemWithSecrets) {
            return;
        }
        Object object4 = null;
        String string3 = null;
        String string4 = null;
        try {
            object3 = new BufferedReader(new StringReader(new String(byArray, "US-ASCII")));
            charSequence = new StringBuilder();
            string2 = null;
            string = null;
            String string5 = null;
            String string6 = null;
            object2 = null;
            object = null;
            String string7 = null;
            serializable = null;
            ArrayList<String> arrayList = null;
            boolean bl = false;
            while ((string2 = ((BufferedReader)object3).readLine()) != null) {
                int n;
                Object object5;
                Object object6;
                Object object7;
                if (bl && !string2.startsWith("-----END ")) continue;
                if (string2.startsWith("router ")) {
                    object7 = string2.split(" ");
                    if (((String[])object7).length != 6) {
                        logger.warn("Invalid router line: '" + string2 + "'.  Skipping.");
                        return;
                    }
                    string5 = object7[2];
                    string6 = string2;
                    continue;
                }
                if (string2.startsWith("or-address ")) {
                    if (serializable == null) {
                        serializable = new ArrayList<String>();
                    }
                    serializable.add(string2.substring("or-address ".length()));
                    continue;
                }
                if (string2.startsWith("published ")) {
                    string3 = string2.substring("published ".length());
                    if (string3.compareTo(this.maxServerDescriptorPublishedTime) > 0) {
                        this.maxServerDescriptorPublishedTime = string3;
                    }
                    if (this.bridgeSanitizingCutOffTimestamp.compareTo(string3) > 0) {
                        object7 = "Sanitizing and storing server descriptor with publication time outside our descriptor sanitizing interval.";
                        if (this.haveWarnedAboutInterval) {
                            logger.debug((String)object7);
                        } else {
                            logger.warn((String)object7);
                            this.haveWarnedAboutInterval = true;
                        }
                    }
                    ((StringBuilder)charSequence).append(string2 + "\n");
                    continue;
                }
                if (string2.startsWith("opt fingerprint ") || string2.startsWith("fingerprint ")) {
                    object7 = string2.substring(string2.startsWith("opt ") ? "opt fingerprint".length() : "fingerprint".length()).replaceAll(" ", "").toLowerCase();
                    object6 = Hex.decodeHex(((String)object7).toCharArray());
                    string = DigestUtils.shaHex(object6).toLowerCase();
                    try {
                        String string8;
                        Object object8;
                        object = this.scrubIpv4Address(string5, (byte[])object6, string3);
                        if (serializable != null) {
                            arrayList = new ArrayList<String>();
                            object8 = serializable.iterator();
                            while (object8.hasNext()) {
                                string8 = (String)object8.next();
                                object5 = this.scrubOrAddress(string8, (byte[])object6, string3);
                                if (object5 != null) {
                                    arrayList.add((String)object5);
                                    continue;
                                }
                                logger.warn("Invalid address in line 'or-address " + string8 + "' in bridge server descriptor.  Skipping line!");
                            }
                        }
                        object8 = string6.split(" ");
                        string8 = object8[1];
                        object5 = this.scrubTcpPort((String)object8[3], (byte[])object6, string3);
                        String string9 = this.scrubTcpPort((String)object8[4], (byte[])object6, string3);
                        String string10 = this.scrubTcpPort((String)object8[5], (byte[])object6, string3);
                        object2 = String.format("router %s %s %s %s %s%n", string8, object, object5, string9, string10);
                    }
                    catch (IOException iOException) {
                        this.persistenceProblemWithSecrets = true;
                        return;
                    }
                    ((StringBuilder)charSequence).append((string2.startsWith("opt ") ? "opt " : "") + "fingerprint");
                    for (n = 0; n < string.length() / 4; ++n) {
                        ((StringBuilder)charSequence).append(" " + string.substring(4 * n, 4 * (n + 1)).toUpperCase());
                    }
                    ((StringBuilder)charSequence).append("\n");
                    continue;
                }
                if (string2.startsWith("contact ")) {
                    ((StringBuilder)charSequence).append("contact somebody\n");
                    continue;
                }
                if (string2.startsWith("router-signature")) {
                    object4 = object2;
                    if (arrayList != null) {
                        object7 = arrayList.iterator();
                        while (object7.hasNext()) {
                            object6 = (String)object7.next();
                            object4 = (String)object4 + "or-address " + (String)object6 + "\n";
                        }
                    }
                    object4 = object4 + ((StringBuilder)charSequence).toString();
                    break;
                }
                if (string2.startsWith("opt extra-info-digest ") || string2.startsWith("extra-info-digest ")) {
                    object7 = string2.split(" ");
                    if (string2.startsWith("opt ")) {
                        ((StringBuilder)charSequence).append("opt ");
                        object7 = string2.substring(4).split(" ");
                    }
                    if (((Object)object7).length > 3) {
                        logger.warn("extra-info-digest line contains more arguments thanexpected: '" + string2 + "'.  Skipping descriptor.");
                        return;
                    }
                    ((StringBuilder)charSequence).append("extra-info-digest " + DigestUtils.shaHex(Hex.decodeHex(((String)object7[1]).toCharArray())).toUpperCase());
                    if (((Object)object7).length > 2) {
                        if (!Base64.isBase64((String)object7[2])) {
                            logger.warn("Illegal base64 character in extra-info-digest line '" + string2 + "'.  Skipping descriptor.");
                            return;
                        }
                        ((StringBuilder)charSequence).append(" " + Base64.encodeBase64String(DigestUtils.sha256(Base64.decodeBase64((String)object7[2]))).replaceAll("=", ""));
                    }
                    ((StringBuilder)charSequence).append("\n");
                    continue;
                }
                if (string2.startsWith("reject ")) {
                    if (string5 != null && string2.startsWith("reject " + string5)) {
                        ((StringBuilder)charSequence).append("reject " + (String)object + string2.substring("reject ".length() + string5.length()) + "\n");
                        continue;
                    }
                    ((StringBuilder)charSequence).append(string2 + "\n");
                    continue;
                }
                if (string2.equals("identity-ed25519")) {
                    object7 = new StringBuilder();
                    while ((string2 = ((BufferedReader)object3).readLine()) != null && !string2.equals("-----END ED25519 CERT-----")) {
                        if (string2.equals("-----BEGIN ED25519 CERT-----")) continue;
                        ((StringBuilder)object7).append(string2);
                    }
                    string4 = this.parseMasterKeyEd25519FromIdentityEd25519(((StringBuilder)object7).toString());
                    if (string4 == null) {
                        logger.warn("Could not parse master-key-ed25519 from identity-ed25519.  Skipping descriptor.");
                        return;
                    }
                    object6 = Base64.encodeBase64String(DigestUtils.sha256(Base64.decodeBase64(string4 + "="))).replaceAll("=", "");
                    ((StringBuilder)charSequence).append("master-key-ed25519 " + (String)object6 + "\n");
                    if (string7 == null || string7.equals(string4)) continue;
                    logger.warn("Mismatch between identity-ed25519 and master-key-ed25519.  Skipping.");
                    return;
                }
                if (string2.startsWith("master-key-ed25519 ")) {
                    string7 = string2.substring(string2.indexOf(" ") + 1);
                    if (string4 == null || string4.equals(string7)) continue;
                    logger.warn("Mismatch between identity-ed25519 and master-key-ed25519.  Skipping.");
                    return;
                }
                if (string2.startsWith("accept ") || string2.startsWith("platform ") || string2.startsWith("opt protocols ") || string2.startsWith("protocols ") || string2.startsWith("proto ") || string2.startsWith("uptime ") || string2.startsWith("bandwidth ") || string2.startsWith("opt hibernating ") || string2.startsWith("hibernating ") || string2.startsWith("ntor-onion-key ") || string2.equals("opt hidden-service-dir") || string2.equals("hidden-service-dir") || string2.equals("opt caches-extra-info") || string2.equals("caches-extra-info") || string2.equals("opt allow-single-hop-exits") || string2.equals("allow-single-hop-exits") || string2.startsWith("ipv6-policy ") || string2.equals("tunnelled-dir-server")) {
                    ((StringBuilder)charSequence).append(string2 + "\n");
                    continue;
                }
                if (string2.startsWith("family ")) {
                    object7 = new StringBuilder("family");
                    object6 = string2.substring(7).split(" ");
                    n = ((byte[])object6).length;
                    for (int i = 0; i < n; ++i) {
                        object5 = object6[i];
                        if (((String)object5).startsWith("$")) {
                            ((StringBuilder)object7).append(" $" + DigestUtils.shaHex(Hex.decodeHex(((String)object5).substring(1).toCharArray())).toUpperCase());
                            continue;
                        }
                        ((StringBuilder)object7).append(" " + (String)object5);
                    }
                    ((StringBuilder)charSequence).append(((StringBuilder)object7).toString() + "\n");
                    continue;
                }
                if (string2.startsWith("@purpose ")) continue;
                if (string2.startsWith("-----BEGIN ") || string2.equals("onion-key") || string2.equals("signing-key") || string2.equals("onion-key-crosscert") || string2.startsWith("ntor-onion-key-crosscert ")) {
                    bl = true;
                    continue;
                }
                if (string2.startsWith("-----END ")) {
                    bl = false;
                    continue;
                }
                if (string2.startsWith("router-sig-ed25519 ")) continue;
                logger.warn("Unrecognized line '" + string2 + "'. Skipping.");
                return;
            }
            ((BufferedReader)object3).close();
        }
        catch (Exception exception) {
            logger.warn("Could not parse server descriptor.", exception);
            return;
        }
        object3 = null;
        try {
            charSequence = new String(byArray, "US-ASCII");
            string2 = "router ";
            string = "\nrouter-signature\n";
            int n = ((String)charSequence).indexOf(string2);
            int n2 = ((String)charSequence).indexOf(string) + string.length();
            if (n >= 0 && n2 >= 0 && n2 > n) {
                object2 = new byte[n2 - n];
                System.arraycopy(byArray, n, object2, 0, n2 - n);
                object3 = DigestUtils.shaHex(DigestUtils.sha(object2));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (object3 == null) {
            logger.warn("Could not calculate server descriptor digest.");
            return;
        }
        charSequence = null;
        if (string4 != null) {
            try {
                string2 = new String(byArray, "US-ASCII");
                string = "router ";
                String string11 = "\n-----END SIGNATURE-----\n";
                int n = string2.indexOf(string);
                int n3 = string2.indexOf(string11) + string11.length();
                if (n >= 0 && n3 >= 0 && n3 > n) {
                    object = new byte[n3 - n];
                    System.arraycopy(byArray, n, object, 0, n3 - n);
                    charSequence = Base64.encodeBase64String(DigestUtils.sha256(DigestUtils.sha256((byte[])object))).replaceAll("=", "");
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            if (charSequence == null) {
                logger.warn("Could not calculate server descriptor SHA256 digest.");
                return;
            }
        }
        string2 = string3.substring(0, 4);
        string = string3.substring(5, 7);
        File file = new File(this.sanitizedBridgesDirectory.getAbsolutePath() + "/" + string2 + "/" + string + "/server-descriptors//" + ((String)object3).charAt(0) + "/" + ((String)object3).charAt(1) + "/" + (String)object3);
        try {
            File file2 = new File(this.config.getPath(Key.RecentPath).toFile(), "bridge-descriptors/server-descriptors/" + this.rsyncCatString + "-server-descriptors.tmp");
            File[] fileArray = new File[]{file, file2};
            object = new boolean[]{false, true};
            for (int i = 0; i < fileArray.length; ++i) {
                serializable = fileArray[i];
                Object object9 = object[i];
                if (!((File)serializable).exists() || object9 != false) {
                    ((File)serializable).getParentFile().mkdirs();
                    BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter((File)serializable, (boolean)object9));
                    bufferedWriter.write(Annotation.BridgeServer.toString());
                    bufferedWriter.write((String)object4);
                    if (charSequence != null) {
                        bufferedWriter.write("router-digest-sha256 " + (String)charSequence + "\n");
                    }
                    bufferedWriter.write("router-digest " + ((String)object3).toUpperCase() + "\n");
                    bufferedWriter.close();
                    continue;
                }
                break;
            }
        }
        catch (IOException | ConfigurationException exception) {
            logger.warn("Could not write sanitized server descriptor to disk.", exception);
            return;
        }
    }

    private String parseMasterKeyEd25519FromIdentityEd25519(String string) {
        byte[] byArray = Base64.decodeBase64(string);
        if (byArray.length < 40) {
            logger.warn("Invalid length of identity-ed25519 (in bytes): " + byArray.length);
        } else if (byArray[0] != 1) {
            logger.warn("Unknown version in identity-ed25519: " + byArray[0]);
        } else if (byArray[1] != 4) {
            logger.warn("Unknown cert type in identity-ed25519: " + byArray[1]);
        } else if (byArray[6] != 1) {
            logger.warn("Unknown certified key type in identity-ed25519: " + byArray[1]);
        } else if (byArray[39] == 0) {
            logger.warn("No extensions in identity-ed25519 (which would contain the encoded master-key-ed25519): " + byArray[39]);
        } else {
            int n = 40;
            for (int i = 0; i < byArray[39]; ++i) {
                if (byArray.length < n + 4) {
                    logger.warn("Invalid extension with id " + i + " in identity-ed25519.");
                    break;
                }
                int n2 = byArray[n];
                n2 <<= 8;
                byte by = byArray[n + 2];
                if ((n2 += byArray[n + 1]) == 32 && by == 4) {
                    if (byArray.length < n + 4 + 32) {
                        logger.warn("Invalid extension with id " + i + " in identity-ed25519.");
                        break;
                    }
                    byte[] byArray2 = new byte[32];
                    System.arraycopy(byArray, n + 4, byArray2, 0, byArray2.length);
                    String string2 = Base64.encodeBase64String(byArray2);
                    String string3 = string2.replaceAll("=", "");
                    return string3;
                }
                n += 4 + n2;
            }
        }
        logger.warn("Unable to locate master-key-ed25519 in identity-ed25519.");
        return null;
    }

    public void sanitizeAndStoreExtraInfoDescriptor(byte[] byArray) {
        Object object;
        Object object2;
        String string;
        CharSequence charSequence;
        String string2;
        Object object3;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        try {
            object3 = new BufferedReader(new StringReader(new String(byArray, "US-ASCII")));
            string2 = null;
            charSequence = null;
            string = null;
            String string6 = null;
            while ((string2 = ((BufferedReader)object3).readLine()) != null) {
                String[] stringArray = string2.split(" ");
                if (string2.startsWith("extra-info ")) {
                    if (stringArray.length < 3) {
                        logger.debug("Illegal line in extra-info descriptor: '" + string2 + "'.  Skipping descriptor.");
                        return;
                    }
                    string = DigestUtils.shaHex(Hex.decodeHex(stringArray[2].toCharArray())).toLowerCase();
                    charSequence = new StringBuilder("extra-info " + stringArray[1] + " " + string.toUpperCase() + "\n");
                    continue;
                }
                if (string2.startsWith("published ")) {
                    ((StringBuilder)charSequence).append(string2 + "\n");
                    string4 = string2.substring("published ".length());
                    if (string4.compareTo(this.maxExtraInfoDescriptorPublishedTime) <= 0) continue;
                    this.maxExtraInfoDescriptorPublishedTime = string4;
                    continue;
                }
                if (string2.startsWith("transport ")) {
                    if (stringArray.length < 3) {
                        logger.debug("Illegal line in extra-info descriptor: '" + string2 + "'.  Skipping descriptor.");
                        return;
                    }
                    ((StringBuilder)charSequence).append("transport " + stringArray[1] + "\n");
                    continue;
                }
                if (string2.startsWith("transport-info ")) continue;
                if (string2.equals("identity-ed25519")) {
                    object2 = new StringBuilder();
                    while ((string2 = ((BufferedReader)object3).readLine()) != null && !string2.equals("-----END ED25519 CERT-----")) {
                        if (string2.equals("-----BEGIN ED25519 CERT-----")) continue;
                        ((StringBuilder)object2).append(string2);
                    }
                    string5 = this.parseMasterKeyEd25519FromIdentityEd25519(((StringBuilder)object2).toString());
                    object = Base64.encodeBase64String(DigestUtils.sha256(Base64.decodeBase64(string5 + "="))).replaceAll("=", "");
                    ((StringBuilder)charSequence).append("master-key-ed25519 " + (String)object + "\n");
                    if (string6 == null || string6.equals(string5)) continue;
                    logger.warn("Mismatch between identity-ed25519 and master-key-ed25519.  Skipping.");
                    return;
                }
                if (string2.startsWith("master-key-ed25519 ")) {
                    string6 = string2.substring(string2.indexOf(" ") + 1);
                    if (string5 == null || string5.equals(string6)) continue;
                    logger.warn("Mismatch between identity-ed25519 and master-key-ed25519.  Skipping.");
                    return;
                }
                if (string2.startsWith("write-history ") || string2.startsWith("read-history ") || string2.startsWith("geoip-start-time ") || string2.startsWith("geoip-client-origins ") || string2.startsWith("geoip-db-digest ") || string2.startsWith("geoip6-db-digest ") || string2.startsWith("conn-bi-direct ") || string2.startsWith("bridge-") || string2.startsWith("dirreq-") || string2.startsWith("cell-") || string2.startsWith("entry-") || string2.startsWith("exit-")) {
                    ((StringBuilder)charSequence).append(string2 + "\n");
                    continue;
                }
                if (string2.startsWith("router-signature")) {
                    string3 = ((StringBuilder)charSequence).toString();
                    break;
                }
                if (string2.startsWith("router-sig-ed25519 ")) continue;
                logger.warn("Unrecognized line '" + string2 + "'. Skipping.");
                return;
            }
            ((BufferedReader)object3).close();
        }
        catch (IOException iOException) {
            logger.warn("Could not parse extra-info descriptor.", iOException);
            return;
        }
        catch (DecoderException decoderException) {
            logger.warn("Could not parse extra-info descriptor.", decoderException);
            return;
        }
        object3 = null;
        try {
            string2 = new String(byArray, "US-ASCII");
            charSequence = "extra-info ";
            string = "\nrouter-signature\n";
            int n = string2.indexOf((String)charSequence);
            int n2 = string2.indexOf(string) + string.length();
            if (n >= 0 && n2 >= 0 && n2 > n) {
                object2 = new byte[n2 - n];
                System.arraycopy(byArray, n, object2, 0, n2 - n);
                object3 = DigestUtils.shaHex(DigestUtils.sha((byte[])object2));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (object3 == null) {
            logger.warn("Could not calculate extra-info descriptor digest.");
            return;
        }
        string2 = null;
        if (string5 != null) {
            try {
                charSequence = new String(byArray, "US-ASCII");
                string = "extra-info ";
                String string7 = "\n-----END SIGNATURE-----\n";
                int n = ((String)charSequence).indexOf(string);
                int n3 = ((String)charSequence).indexOf(string7) + string7.length();
                if (n >= 0 && n3 >= 0 && n3 > n) {
                    object = new byte[n3 - n];
                    System.arraycopy(byArray, n, object, 0, n3 - n);
                    string2 = Base64.encodeBase64String(DigestUtils.sha256(DigestUtils.sha256(object))).replaceAll("=", "");
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            if (string2 == null) {
                logger.warn("Could not calculate extra-info descriptor SHA256 digest.");
                return;
            }
        }
        charSequence = string4.substring(0, 4);
        string = string4.substring(5, 7);
        File file = new File(this.sanitizedBridgesDirectory.getAbsolutePath() + "/" + (String)charSequence + "/" + string + "/extra-infos/" + ((String)object3).charAt(0) + "/" + ((String)object3).charAt(1) + "/" + (String)object3);
        try {
            File file2 = new File(this.config.getPath(Key.RecentPath).toFile(), "bridge-descriptors/extra-infos/" + this.rsyncCatString + "-extra-infos.tmp");
            File[] fileArray = new File[]{file, file2};
            object = new boolean[]{false, true};
            for (int i = 0; i < fileArray.length; ++i) {
                File file3 = fileArray[i];
                boolean bl = object[i];
                if (!file3.exists() || bl) {
                    file3.getParentFile().mkdirs();
                    BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file3, bl));
                    bufferedWriter.write(Annotation.BridgeExtraInfo.toString());
                    bufferedWriter.write(string3);
                    if (string2 != null) {
                        bufferedWriter.write("router-digest-sha256 " + string2 + "\n");
                    }
                    bufferedWriter.write("router-digest " + ((String)object3).toUpperCase() + "\n");
                    bufferedWriter.close();
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            logger.warn("Could not write sanitized extra-info descriptor to disk.", exception);
        }
    }

    public void finishWriting() {
        if (!this.secretsForHashingIpAddresses.isEmpty() && this.secretsForHashingIpAddresses.firstKey().compareTo(this.bridgeSanitizingCutOffTimestamp) < 0) {
            try {
                int n = 0;
                int n2 = 0;
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.bridgeIpSecretsFile));
                for (Map.Entry<String, byte[]> entry : this.secretsForHashingIpAddresses.entrySet()) {
                    if (entry.getKey().compareTo(this.bridgeSanitizingCutOffTimestamp) < 0) {
                        ++n2;
                        continue;
                    }
                    bufferedWriter.write(entry.getKey() + "," + Hex.encodeHexString(entry.getValue()) + "\n");
                    ++n;
                }
                bufferedWriter.close();
                logger.info("Deleted " + n2 + " secrets that we don't need anymore and kept " + n + ".");
            }
            catch (IOException iOException) {
                logger.warn("Could not store reduced set of secrets to disk! This is a bad sign, better check what's going on!", iOException);
            }
        }
    }

    private void checkStaleDescriptors() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        long l = System.currentTimeMillis() - 19800000L;
        try {
            long l2;
            long l3;
            long l4 = simpleDateFormat.parse(this.maxNetworkStatusPublishedTime).getTime();
            if (l4 > 0L && l4 < l) {
                logger.warn("The last known bridge network status was published " + this.maxNetworkStatusPublishedTime + ", which is more than 5:30 hours in the past.");
            }
            if ((l3 = simpleDateFormat.parse(this.maxServerDescriptorPublishedTime).getTime()) > 0L && l3 < l) {
                logger.warn("The last known bridge server descriptor was published " + this.maxServerDescriptorPublishedTime + ", which is more than 5:30 hours in the past.");
            }
            if ((l2 = simpleDateFormat.parse(this.maxExtraInfoDescriptorPublishedTime).getTime()) > 0L && l2 < l) {
                logger.warn("The last known bridge extra-info descriptor was published " + this.maxExtraInfoDescriptorPublishedTime + ", which is more than 5:30 hours in the past.");
            }
        }
        catch (ParseException parseException) {
            logger.warn("Unable to parse timestamp for stale check.", parseException);
        }
    }

    public void cleanUpRsyncDirectory() throws ConfigurationException {
        long l = System.currentTimeMillis() - 259200000L;
        Stack<File> stack = new Stack<File>();
        stack.add(new File(this.config.getPath(Key.RecentPath).toFile(), BRIDGE_DESCRIPTORS));
        while (!stack.isEmpty()) {
            File file = (File)stack.pop();
            if (file.isDirectory()) {
                stack.addAll(Arrays.asList(file.listFiles()));
                continue;
            }
            if (file.lastModified() < l) {
                file.delete();
                continue;
            }
            if (!file.getName().endsWith(".tmp")) continue;
            file.renameTo(new File(file.getParentFile(), file.getName().substring(0, file.getName().lastIndexOf(".tmp"))));
        }
    }
}

