/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.collector.exitlists;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Stack;
import java.util.TimeZone;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.collector.conf.Configuration;
import org.torproject.collector.conf.ConfigurationException;
import org.torproject.collector.conf.Key;
import org.torproject.collector.cron.CollecTorMain;
import org.torproject.descriptor.Descriptor;
import org.torproject.descriptor.DescriptorParseException;
import org.torproject.descriptor.DescriptorSourceFactory;
import org.torproject.descriptor.ExitList;

public class ExitListDownloader
extends CollecTorMain {
    private static final Logger logger = LoggerFactory.getLogger(ExitListDownloader.class);

    public ExitListDownloader(Configuration configuration) {
        super(configuration);
    }

    @Override
    public String module() {
        return "exitlists";
    }

    @Override
    protected void startProcessing() throws ConfigurationException {
        Object object2;
        Object object3;
        Serializable serializable;
        Serializable serializable2;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date date = new Date();
        String string = null;
        try {
            int n;
            logger.debug("Downloading exit list...");
            serializable2 = new StringBuilder();
            ((StringBuilder)serializable2).append("@type tordnsel 1.0\n");
            ((StringBuilder)serializable2).append("Downloaded " + simpleDateFormat.format(date) + "\n");
            serializable = this.config.getUrl(Key.ExitlistUrl);
            HttpURLConnection httpURLConnection = (HttpURLConnection)((URL)serializable).openConnection();
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.connect();
            int n2 = httpURLConnection.getResponseCode();
            if (n2 != 200) {
                logger.warn("Could not download exit list. Response code " + n2);
                return;
            }
            object3 = new BufferedInputStream(httpURLConnection.getInputStream());
            object2 = new byte[1024];
            while ((n = ((BufferedInputStream)object3).read((byte[])object2, 0, 1024)) >= 0) {
                ((StringBuilder)serializable2).append(new String((byte[])object2, 0, n));
            }
            ((BufferedInputStream)object3).close();
            string = ((StringBuilder)serializable2).toString();
            logger.debug("Finished downloading exit list.");
        }
        catch (IOException iOException) {
            logger.warn("Failed downloading exit list", iOException);
            return;
        }
        if (string == null) {
            logger.warn("Failed downloading exit list.");
            return;
        }
        serializable2 = new SimpleDateFormat("yyyy/MM/dd/yyyy-MM-dd-HH-mm-ss");
        ((DateFormat)serializable2).setTimeZone(TimeZone.getTimeZone("UTC"));
        serializable = new File(this.config.getPath(Key.ExitlistOutputDirectory).toFile(), ((DateFormat)serializable2).format(date));
        long l = 0L;
        try {
            object3 = DescriptorSourceFactory.createDescriptorParser();
            List<Descriptor> list = object3.parseDescriptors(string.getBytes(), ((File)serializable).getName());
            if (list.size() != 1 || !(list.get(0) instanceof ExitList)) {
                logger.warn("Could not parse downloaded exit list");
                return;
            }
            object2 = (ExitList)list.get(0);
            for (ExitList.Entry entry : object2.getEntries()) {
                for (long l2 : entry.getExitAddresses().values()) {
                    l = Math.max(l, l2);
                }
            }
        }
        catch (DescriptorParseException descriptorParseException) {
            logger.warn("Could not parse downloaded exit list", descriptorParseException);
        }
        if (l > 0L && l + 19800000L < System.currentTimeMillis()) {
            logger.warn("The last reported scan in the downloaded exit list took place at " + simpleDateFormat.format(l) + ", which is more than 5:30 hours in the past.");
        }
        object3 = new File(this.config.getPath(Key.RecentPath).toFile(), "exit-lists/" + ((File)serializable).getName());
        File[] fileArray = new File[]{serializable, object3};
        for (File file : fileArray) {
            try {
                file.getParentFile().mkdirs();
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
                bufferedWriter.write(string);
                bufferedWriter.close();
            }
            catch (IOException iOException) {
                logger.warn("Could not write downloaded exit list to " + file.getAbsolutePath(), iOException);
            }
        }
        object2 = new StringBuilder("Finished downloading exit list.\nLast three exit lists are:");
        Stack<File> stack = new Stack<File>();
        stack.add(this.config.getPath(Key.ExitlistOutputDirectory).toFile());
        TreeSet<File> treeSet = new TreeSet<File>();
        while (!stack.isEmpty()) {
            File file = (File)stack.pop();
            if (file.isDirectory()) {
                TreeSet<File> treeSet2 = new TreeSet<File>();
                for (File file2 : file.listFiles()) {
                    treeSet2.add(file2);
                }
                while (treeSet2.size() > 3) {
                    treeSet2.remove(treeSet2.first());
                }
                for (File file3 : treeSet2) {
                    stack.add(file3);
                }
                continue;
            }
            treeSet.add(file);
            while (treeSet.size() > 3) {
                treeSet.remove(treeSet.first());
            }
        }
        for (File file : treeSet) {
            ((StringBuilder)object2).append("\n" + file.getName());
        }
        logger.info(((StringBuilder)object2).toString());
        this.cleanUpRsyncDirectory();
    }

    public void cleanUpRsyncDirectory() throws ConfigurationException {
        long l = System.currentTimeMillis() - 259200000L;
        Stack<File> stack = new Stack<File>();
        stack.add(new File(this.config.getPath(Key.RecentPath).toFile(), "/exit-lists"));
        while (!stack.isEmpty()) {
            File file = (File)stack.pop();
            if (file.isDirectory()) {
                stack.addAll(Arrays.asList(file.listFiles()));
                continue;
            }
            if (file.lastModified() >= l) continue;
            file.delete();
        }
    }
}

