/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.collector.cron;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.collector.conf.Configuration;
import org.torproject.collector.conf.ConfigurationException;

public abstract class CollecTorMain
implements Callable<Object>,
Observer,
Runnable {
    private static final Logger logger = LoggerFactory.getLogger(CollecTorMain.class);
    private static final long LIMIT_MB = 200L;
    private final AtomicBoolean newConfigAvailable = new AtomicBoolean(false);
    protected Configuration config = new Configuration();
    private Configuration newConfig;

    public CollecTorMain(Configuration configuration) {
        this.config.putAll(configuration.getPropertiesCopy());
        configuration.addObserver(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        CollecTorMain collecTorMain = this;
        synchronized (collecTorMain) {
            if (this.newConfigAvailable.get()) {
                logger.info("Module {} is using the new configuration.", (Object)this.module());
                Configuration configuration = this.newConfig;
                synchronized (configuration) {
                    this.config.clear();
                    this.config.putAll(this.newConfig.getPropertiesCopy());
                    this.newConfigAvailable.set(false);
                }
            }
        }
        logger.info("Starting {} module of CollecTor.", (Object)this.module());
        try {
            this.startProcessing();
        }
        catch (Throwable throwable) {
            logger.error("The {} module failed: {}", this.module(), throwable.getMessage(), throwable);
        }
        logger.info("Terminating {} module of CollecTor.", (Object)this.module());
    }

    @Override
    public final Object call() {
        this.run();
        return null;
    }

    @Override
    public synchronized void update(Observable observable, Object object) {
        this.newConfigAvailable.set(true);
        if (observable instanceof Configuration) {
            this.newConfig = (Configuration)observable;
            logger.info("Module {} just received a new configuration.", (Object)this.module());
        }
    }

    protected abstract void startProcessing() throws ConfigurationException;

    public abstract String module();

    public static void checkAvailableSpace(Path path) {
        try {
            long l = Files.getFileStore(path.toFile().getAbsoluteFile().toPath().getRoot()).getUsableSpace() / 1024L / 1024L;
            if (l < 200L) {
                logger.warn("Available storage critical for {}; only {} MiB left.", (Object)path, (Object)l);
            } else {
                logger.trace("Available storage for {}: {} MiB", (Object)path, (Object)l);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("Cannot access " + path + " reason: " + iOException.getMessage(), iOException);
        }
    }
}

