/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.collector.bridgedescs;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.Writer;
import java.util.HashSet;
import java.util.Stack;
import java.util.TreeSet;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.collector.bridgedescs.BridgeDescriptorParser;
import org.torproject.collector.conf.ConfigurationException;

public class BridgeSnapshotReader {
    private static final Logger logger = LoggerFactory.getLogger(BridgeSnapshotReader.class);

    public BridgeSnapshotReader(BridgeDescriptorParser bridgeDescriptorParser, File file, File file2) throws ConfigurationException {
        if (bridgeDescriptorParser == null || file == null || file2 == null) {
            throw new IllegalArgumentException();
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        File file3 = file;
        File file4 = new File(file2, "parsed-bridge-directories");
        boolean bl = false;
        if (file3.exists()) {
            Object object;
            Object object2;
            Object object3;
            if (file4.exists()) {
                logger.debug("Reading file " + file4.getAbsolutePath() + "...");
                try {
                    object3 = new BufferedReader(new FileReader(file4));
                    String string = null;
                    while ((string = ((BufferedReader)object3).readLine()) != null) {
                        treeSet.add(string);
                    }
                    ((BufferedReader)object3).close();
                    logger.debug("Finished reading file " + file4.getAbsolutePath() + ".");
                }
                catch (IOException iOException) {
                    logger.warn("Failed reading file " + file4.getAbsolutePath() + "!", iOException);
                    return;
                }
            }
            logger.debug("Importing files in directory " + file + "/...");
            object3 = new HashSet();
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            Stack<Object> stack = new Stack<Object>();
            stack.add(file3);
            block24: while (!stack.isEmpty()) {
                object2 = (File)stack.pop();
                if (((File)object2).isDirectory()) {
                    for (File file5 : ((File)object2).listFiles()) {
                        stack.add(file5);
                    }
                    continue;
                }
                if (treeSet.contains(((File)object2).getName())) continue;
                try {
                    object = new FileInputStream((File)object2);
                    if (((FileInputStream)object).available() > 0) {
                        String string;
                        TarArchiveInputStream tarArchiveInputStream = null;
                        if (((File)object2).getName().endsWith(".tar.gz")) {
                            GzipCompressorInputStream gzipCompressorInputStream = new GzipCompressorInputStream((InputStream)object);
                            tarArchiveInputStream = new TarArchiveInputStream(gzipCompressorInputStream);
                        } else {
                            if (!((File)object2).getName().endsWith(".tar")) continue;
                            tarArchiveInputStream = new TarArchiveInputStream((InputStream)object);
                        }
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(tarArchiveInputStream);
                        String string2 = ((File)object2).getName();
                        String[] stringArray = string2.split("-");
                        if (stringArray.length != 5) {
                            logger.warn("Invalid bridge descriptor tarball file name: " + string2 + ".  Skipping.");
                            continue;
                        }
                        String string3 = String.format("%s-%s-", stringArray[0], stringArray[1]);
                        String string4 = String.format("%s-%s-%s", stringArray[2], stringArray[3], stringArray[4]);
                        switch (string3) {
                            case "from-tonga-": {
                                string = "4A0CCD2DDC7995083D73F5D667100C8A5831F16D";
                                break;
                            }
                            case "from-bifroest-": {
                                string = "1D8F3A91C37C5D1C4C19B1AD1D0CFBE8BF72D8E1";
                                break;
                            }
                            default: {
                                logger.warn("Did not recognize the bridge authority that generated " + string2 + ".  Skipping.");
                                continue block24;
                            }
                        }
                        String string5 = string4.substring(0, 10) + " " + string4.substring(11, 13) + ":" + string4.substring(13, 15) + ":" + string4.substring(15, 17);
                        while (tarArchiveInputStream.getNextTarEntry() != null) {
                            int n8;
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                            byte[] byArray = new byte[1024];
                            while ((n8 = bufferedInputStream.read(byArray, 0, 1024)) >= 0) {
                                byteArrayOutputStream.write(byArray, 0, n8);
                            }
                            byte[] byArray2 = byteArrayOutputStream.toByteArray();
                            if (byArray2.length == 0) continue;
                            String string6 = Hex.encodeHexString(DigestUtils.sha(byArray2));
                            String string7 = new String(byArray2, "US-ASCII");
                            BufferedReader bufferedReader = new BufferedReader(new StringReader(string7));
                            String string8 = null;
                            while ((string8 = bufferedReader.readLine()) != null && string8.startsWith("@")) {
                            }
                            if (string8 == null) continue;
                            if (string8.startsWith("published ") || string8.startsWith("flag-thresholds ") || string8.startsWith("r ")) {
                                bridgeDescriptorParser.parse(byArray2, string5, string);
                                ++n3;
                            } else {
                                if (object3.contains(string6)) {
                                    ++n2;
                                    continue;
                                }
                                int n9 = -1;
                                int n10 = -1;
                                int n11 = -1;
                                String string9 = string8.startsWith("router ") ? "router " : "extra-info ";
                                String string10 = "\nrouter-signature\n";
                                String string11 = "\n-----END SIGNATURE-----\n";
                                while (n11 < string7.length() && (n9 = string7.indexOf(string9, n11)) >= 0 && (n10 = string7.indexOf(string10, n9)) >= 0 && (n11 = string7.indexOf(string11, n10 += string10.length())) >= 0) {
                                    byte[] byArray3 = new byte[(n11 += string11.length()) - n9];
                                    System.arraycopy(byArray2, n9, byArray3, 0, n11 - n9);
                                    String string12 = Hex.encodeHexString(DigestUtils.sha(byArray3));
                                    if (!object3.contains(string12)) {
                                        bridgeDescriptorParser.parse(byArray3, string5, string);
                                        object3.add(string12);
                                        if (string8.startsWith("router ")) {
                                            ++n4;
                                            continue;
                                        }
                                        ++n6;
                                        continue;
                                    }
                                    if (string8.startsWith("router ")) {
                                        ++n5;
                                        continue;
                                    }
                                    ++n7;
                                }
                            }
                            object3.add(string6);
                            ++n;
                        }
                        bufferedInputStream.close();
                    }
                    ((FileInputStream)object).close();
                    System.gc();
                    treeSet.add(((File)object2).getName());
                    bl = true;
                }
                catch (IOException iOException) {
                    logger.warn("Could not parse bridge snapshot " + ((File)object2).getName() + "!", iOException);
                }
            }
            logger.debug("Finished importing files in directory " + file + "/.  In total, we parsed " + n + " files (skipped " + n2 + ") containing " + n3 + " statuses, " + n4 + " server descriptors (skipped " + n5 + "), and " + n6 + " extra-info descriptors (skipped " + n7 + ").");
            if (!treeSet.isEmpty() && bl) {
                logger.debug("Writing file " + file4.getAbsolutePath() + "...");
                file4.getParentFile().mkdirs();
                try {
                    object2 = new BufferedWriter(new FileWriter(file4));
                    object = null;
                    try {
                        for (String string : treeSet) {
                            ((Writer)object2).append(string + "\n");
                        }
                        logger.debug("Finished writing file " + file4.getAbsolutePath() + ".");
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (object2 != null) {
                            if (object != null) {
                                try {
                                    ((BufferedWriter)object2).close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                ((BufferedWriter)object2).close();
                            }
                        }
                    }
                }
                catch (IOException iOException) {
                    logger.warn("Failed writing file " + file4.getAbsolutePath() + "!", iOException);
                }
            }
        }
    }
}

