/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.collector.relaydescs;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.collector.relaydescs.RelayDescriptorParser;

public class ArchiveReader {
    private static final Logger logger = LoggerFactory.getLogger(ArchiveReader.class);
    private Map<String, Set<String>> microdescriptorValidAfterTimes = new HashMap<String, Set<String>>();

    public ArchiveReader(RelayDescriptorParser relayDescriptorParser, File file, File file2, boolean bl) {
        ArrayList<Object> arrayList;
        Object object;
        if (relayDescriptorParser == null || file == null || file2 == null) {
            throw new IllegalArgumentException();
        }
        relayDescriptorParser.setArchiveReader(this);
        int n = 0;
        int n2 = 0;
        TreeSet<String> treeSet = new TreeSet<String>();
        File file3 = new File(file2, "archives-import-history");
        if (bl && file3.exists()) {
            try {
                object = new BufferedReader(new FileReader(file3));
                arrayList = null;
                while ((arrayList = ((BufferedReader)object).readLine()) != null) {
                    treeSet.add((String)((Object)arrayList));
                }
                ((BufferedReader)object).close();
            }
            catch (IOException iOException) {
                logger.warn("Could not read in archives import history file. Skipping.", iOException);
            }
        }
        if (file.exists()) {
            byte[] byArray;
            Object object2;
            logger.debug("Importing files in directory " + file + "/...");
            object = new Stack();
            ((Vector)object).add(file);
            arrayList = new ArrayList<Object>();
            HashSet<Object> object4 = new HashSet<Object>();
            while (!((Vector)object).isEmpty()) {
                object2 = (File)((Stack)object).pop();
                if (((File)object2).isDirectory()) {
                    for (File file4 : ((File)object2).listFiles()) {
                        ((Vector)object).add(file4);
                    }
                    continue;
                }
                if (relayDescriptorParser == null) continue;
                try {
                    int n3;
                    Closeable iOException;
                    Object n7 = null;
                    if (bl && treeSet.contains(((File)object2).getName())) {
                        ++n2;
                        continue;
                    }
                    if (((File)object2).getName().endsWith(".tar.bz2")) {
                        logger.warn("Cannot parse compressed tarball " + ((File)object2).getAbsolutePath() + ". Skipping.");
                        continue;
                    }
                    if (((File)object2).getName().endsWith(".bz2")) {
                        iOException = new FileInputStream((File)object2);
                        BZip2CompressorInputStream closeable = new BZip2CompressorInputStream((InputStream)iOException);
                        n7 = new BufferedInputStream(closeable);
                    } else {
                        iOException = new FileInputStream((File)object2);
                        n7 = new BufferedInputStream((InputStream)iOException);
                    }
                    iOException = new ByteArrayOutputStream();
                    byte[] byArray2 = new byte[1024];
                    while ((n3 = ((BufferedInputStream)n7).read(byArray2, 0, 1024)) >= 0) {
                        ((ByteArrayOutputStream)iOException).write(byArray2, 0, n3);
                    }
                    ((BufferedInputStream)n7).close();
                    byArray = ((ByteArrayOutputStream)iOException).toByteArray();
                    boolean bl2 = relayDescriptorParser.parse(byArray);
                    if (!bl2) {
                        object4.add(object2);
                        continue;
                    }
                    if (bl) {
                        treeSet.add(((File)object2).getName());
                    }
                    ++n;
                }
                catch (IOException iOException) {
                    arrayList.add(object2);
                    if (arrayList.size() <= 3) continue;
                    break;
                }
            }
            for (Object n7 : object4) {
                if (relayDescriptorParser == null) continue;
                try {
                    String string;
                    int n4;
                    BufferedInputStream bufferedInputStream = null;
                    if (((File)n7).getName().endsWith(".bz2")) {
                        FileInputStream fileInputStream = new FileInputStream((File)n7);
                        BZip2CompressorInputStream bZip2CompressorInputStream = new BZip2CompressorInputStream(fileInputStream);
                        bufferedInputStream = new BufferedInputStream(bZip2CompressorInputStream);
                    } else {
                        FileInputStream fileInputStream = new FileInputStream((File)n7);
                        bufferedInputStream = new BufferedInputStream(fileInputStream);
                    }
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    byArray = new byte[1024];
                    while ((n4 = bufferedInputStream.read(byArray, 0, 1024)) >= 0) {
                        byteArrayOutputStream.write(byArray, 0, n4);
                    }
                    bufferedInputStream.close();
                    byte[] byArray3 = byteArrayOutputStream.toByteArray();
                    BufferedReader bufferedReader = new BufferedReader(new StringReader(new String(byArray3, "US-ASCII")));
                    while ((string = bufferedReader.readLine()) != null && string.startsWith("@")) {
                    }
                    bufferedReader.close();
                    if (string == null) {
                        logger.debug("We were given an empty descriptor for parsing. Ignoring.");
                        continue;
                    }
                    if (!string.equals("onion-key")) {
                        logger.debug("Skipping non-recognized descriptor.");
                        continue;
                    }
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                    String string2 = null;
                    try {
                        string2 = new String(byArray3, "US-ASCII");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    int n5 = -1;
                    int n6 = -1;
                    String string3 = "onion-key\n";
                    while (n6 < string2.length() && (n5 = string2.indexOf(string3, n6)) >= 0 && ((n6 = string2.indexOf(string3, n5 + 1)) >= 0 || (n6 = string2.length()) > n5)) {
                        byte[] byArray4 = new byte[n6 - n5];
                        System.arraycopy(byArray3, n5, byArray4, 0, n6 - n5);
                        String string4 = Base64.encodeBase64String(DigestUtils.sha256(byArray4)).replaceAll("=", "");
                        String string5 = DigestUtils.sha256Hex(byArray4);
                        if (!this.microdescriptorValidAfterTimes.containsKey(string5)) {
                            logger.debug("Could not store microdescriptor '" + string5 + "', which was not contained in a microdesc consensus.");
                            continue;
                        }
                        for (String string6 : this.microdescriptorValidAfterTimes.get(string5)) {
                            try {
                                long l = simpleDateFormat.parse(string6).getTime();
                                relayDescriptorParser.storeMicrodescriptor(byArray4, string5, string4, l);
                            }
                            catch (ParseException parseException) {
                                logger.warn("Could not parse valid-after time '" + string6 + "'. Not storing microdescriptor.", parseException);
                            }
                        }
                    }
                    if (bl) {
                        treeSet.add(((File)n7).getName());
                    }
                    ++n;
                }
                catch (IOException iOException) {
                    arrayList.add(n7);
                    if (arrayList.size() <= 3) continue;
                    break;
                }
            }
            if (arrayList.isEmpty()) {
                logger.debug("Finished importing files in directory " + file + "/.");
            } else {
                object2 = new StringBuilder("Failed importing files in directory " + file + "/:");
                int n7 = 0;
                for (File file5 : arrayList) {
                    ((StringBuilder)object2).append("\n  " + file5.getAbsolutePath());
                    if (++n7 < 3) continue;
                    ((StringBuilder)object2).append("\n  ... more");
                    break;
                }
            }
        }
        if (bl) {
            try {
                file3.getParentFile().mkdirs();
                object = new BufferedWriter(new FileWriter(file3));
                for (String string : treeSet) {
                    ((Writer)object).write(string + "\n");
                }
                ((BufferedWriter)object).close();
            }
            catch (IOException iOException) {
                logger.warn("Could not write archives import history file.");
            }
        }
        logger.info("Finished importing relay descriptors from local directory:\nParsed " + n + ", ignored " + n2 + " files.");
    }

    public void haveParsedMicrodescConsensus(String string, SortedSet<String> sortedSet) {
        for (String string2 : sortedSet) {
            if (!this.microdescriptorValidAfterTimes.containsKey(string2)) {
                this.microdescriptorValidAfterTimes.put(string2, new HashSet());
            }
            this.microdescriptorValidAfterTimes.get(string2).add(string);
        }
    }
}

