/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.collector.index;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.collector.conf.Configuration;
import org.torproject.collector.conf.ConfigurationException;
import org.torproject.collector.conf.Key;
import org.torproject.collector.cron.CollecTorMain;

public class CreateIndexJson
extends CollecTorMain {
    private static final Logger logger = LoggerFactory.getLogger(CreateIndexJson.class);
    private static File indexJsonFile;
    private static String basePath;
    private static File[] indexedDirectories;
    private static final String dateTimePattern = "yyyy-MM-dd HH:mm";
    private static final Locale dateTimeLocale;
    private static final TimeZone dateTimezone;
    private static DateFormat dateTimeFormat;

    public CreateIndexJson(Configuration configuration) {
        super(configuration);
    }

    @Override
    public String module() {
        return "updateindex";
    }

    @Override
    protected void startProcessing() throws ConfigurationException {
        try {
            indexJsonFile = new File(this.config.getPath(Key.IndexPath).toFile(), "index.json");
            basePath = this.config.getProperty(Key.InstanceBaseUrl.name());
            indexedDirectories = new File[]{this.config.getPath(Key.ArchivePath).toFile(), this.config.getPath(Key.RecentPath).toFile()};
            this.writeIndex(this.indexDirectories());
        }
        catch (Exception exception) {
            logger.error("Cannot run index creation: " + exception.getMessage(), exception);
            throw new RuntimeException(exception);
        }
    }

    private IndexNode indexDirectories() {
        TreeSet<DirectoryNode> treeSet = new TreeSet<DirectoryNode>();
        logger.trace("indexing: " + indexedDirectories[0] + " " + indexedDirectories[1]);
        for (File file : indexedDirectories) {
            DirectoryNode directoryNode;
            if (!file.exists() || !file.isDirectory() || null == (directoryNode = this.indexDirectory(file))) continue;
            treeSet.add(directoryNode);
        }
        return new IndexNode(dateTimeFormat.format(System.currentTimeMillis()), basePath, null, treeSet);
    }

    private DirectoryNode indexDirectory(File file) {
        TreeSet<FileNode> treeSet = new TreeSet<FileNode>();
        TreeSet<DirectoryNode> treeSet2 = new TreeSet<DirectoryNode>();
        logger.trace("indexing: " + file);
        File[] fileArray = file.listFiles();
        if (null == fileArray) {
            logger.warn("Indexing dubious directory: " + file);
            return null;
        }
        for (File file2 : fileArray) {
            if (file2.getName().startsWith(".")) continue;
            if (file2.isFile()) {
                treeSet.add(this.indexFile(file2));
                continue;
            }
            DirectoryNode directoryNode = this.indexDirectory(file2);
            if (null == directoryNode) continue;
            treeSet2.add(directoryNode);
        }
        DirectoryNode directoryNode = new DirectoryNode(file.getName(), treeSet.isEmpty() ? null : treeSet, treeSet2.isEmpty() ? null : treeSet2);
        return directoryNode;
    }

    private FileNode indexFile(File file) {
        FileNode fileNode = new FileNode(file.getName(), file.length(), dateTimeFormat.format(file.lastModified()));
        return fileNode;
    }

    private void writeIndex(IndexNode indexNode) throws IOException {
        Writer[] writerArray;
        Gson gson = new GsonBuilder().create();
        String string = gson.toJson(indexNode);
        for (Writer writer : writerArray = new Writer[]{new FileWriter(indexJsonFile), new OutputStreamWriter(new GZIPOutputStream(new FileOutputStream(indexJsonFile + ".gz"))), new OutputStreamWriter(new XZCompressorOutputStream(new FileOutputStream(indexJsonFile + ".xz"))), new OutputStreamWriter(new BZip2CompressorOutputStream(new FileOutputStream(indexJsonFile + ".bz2")))}) {
            BufferedWriter bufferedWriter = new BufferedWriter(writer);
            bufferedWriter.write(string);
            bufferedWriter.close();
        }
    }

    static {
        dateTimeLocale = Locale.US;
        dateTimezone = TimeZone.getTimeZone("UTC");
        dateTimeFormat = new SimpleDateFormat(dateTimePattern, dateTimeLocale);
        dateTimeFormat.setLenient(false);
        dateTimeFormat.setTimeZone(dateTimezone);
    }

    private class FileNode
    implements Comparable<FileNode> {
        String path;
        long size;
        String last_modified;

        FileNode(String string, long l, String string2) {
            this.path = string;
            this.size = l;
            this.last_modified = string2;
        }

        @Override
        public int compareTo(FileNode fileNode) {
            return this.path.compareTo(fileNode.path);
        }
    }

    private class IndexNode {
        String index_created;
        String path;
        SortedSet<FileNode> files;
        SortedSet<DirectoryNode> directories;

        IndexNode(String string, String string2, SortedSet<FileNode> sortedSet, SortedSet<DirectoryNode> sortedSet2) {
            this.index_created = string;
            this.path = string2;
            this.files = sortedSet;
            this.directories = sortedSet2;
        }
    }

    private class DirectoryNode
    implements Comparable<DirectoryNode> {
        String path;
        SortedSet<FileNode> files;
        SortedSet<DirectoryNode> directories;

        DirectoryNode(String string, SortedSet<FileNode> sortedSet, SortedSet<DirectoryNode> sortedSet2) {
            this.path = string;
            this.files = sortedSet;
            this.directories = sortedSet2;
        }

        @Override
        public int compareTo(DirectoryNode directoryNode) {
            return this.path.compareTo(directoryNode.path);
        }
    }
}

