/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.collector.cron;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.collector.conf.Configuration;
import org.torproject.collector.conf.ConfigurationException;
import org.torproject.collector.conf.Key;
import org.torproject.collector.cron.CollecTorMain;

public final class Scheduler
implements ThreadFactory {
    public static final String ACTIVATED = "Activated";
    public static final String PERIODMIN = "PeriodMinutes";
    public static final String OFFSETMIN = "OffsetMinutes";
    private static final Logger logger = LoggerFactory.getLogger(Scheduler.class);
    private final ThreadFactory threads = Executors.defaultThreadFactory();
    private int currentThreadNo = 0;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(10, this);
    private static Scheduler instance = new Scheduler();
    private static final long MILLIS_IN_A_MINUTE = 60000L;

    private Scheduler() {
    }

    public static Scheduler getInstance() {
        return instance;
    }

    public void scheduleModuleRuns(Map<Key, Class<? extends CollecTorMain>> map, Configuration configuration) {
        for (Map.Entry<Key, Class<? extends CollecTorMain>> entry : map.entrySet()) {
            try {
                if (!configuration.getBool(entry.getKey())) continue;
                String string = entry.getKey().name().replace(ACTIVATED, "");
                CollecTorMain collecTorMain = entry.getValue().getConstructor(Configuration.class).newInstance(configuration);
                this.scheduleExecutions(configuration.getBool(Key.RunOnce), collecTorMain, configuration.getInt(Key.valueOf(string + OFFSETMIN)), configuration.getInt(Key.valueOf(string + PERIODMIN)));
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | NullPointerException | InvocationTargetException | RejectedExecutionException | ConfigurationException exception) {
                logger.error("Cannot schedule " + entry.getValue().getName() + ". Reason: " + exception.getMessage(), exception);
            }
        }
    }

    private void scheduleExecutions(boolean bl, CollecTorMain collecTorMain, int n, int n2) {
        if (bl) {
            logger.info("Single run for " + collecTorMain.getClass().getName() + ".");
            this.scheduler.execute(collecTorMain);
        } else {
            logger.info("Periodic updater started for " + collecTorMain.getClass().getName() + "; offset=" + n + ", period=" + n2 + ".");
            long l = (long)n2 * 60000L;
            long l2 = Scheduler.computeInitialDelayMillis(System.currentTimeMillis(), (long)n * 60000L, l);
            logger.info("Periodic updater will first run in {} and then every {} minutes.", (Object)(l2 < 60000L ? "under 1 minute" : l2 / 60000L + " minute(s)"), (Object)n2);
            this.scheduler.scheduleAtFixedRate(collecTorMain, l2, l, TimeUnit.MILLISECONDS);
        }
    }

    protected static long computeInitialDelayMillis(long l, long l2, long l3) {
        return (l3 - l % l3 + l2) % l3;
    }

    public void shutdownScheduler() {
        block2: {
            try {
                this.scheduler.shutdown();
                this.scheduler.awaitTermination(20L, TimeUnit.MINUTES);
                logger.info("Shutdown of all scheduled tasks completed successfully.");
            }
            catch (InterruptedException interruptedException) {
                List<Runnable> list = this.scheduler.shutdownNow();
                logger.error("Regular shutdown failed for: " + list);
                if (list.isEmpty()) break block2;
                logger.error("Forced shutdown failed for: " + list);
            }
        }
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = this.threads.newThread(runnable);
        thread.setName("CollecTor-Scheduled-Thread-" + ++this.currentThreadNo);
        logger.info("New Thread created: " + thread.getName());
        return thread;
    }
}

