/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.collector.conf;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.util.Map;
import java.util.Observable;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.collector.conf.ConfigurationException;
import org.torproject.collector.conf.Key;

public class Configuration
extends Observable
implements Cloneable {
    private static final Logger logger = LoggerFactory.getLogger(Configuration.class);
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    public static final String FIELDSEP = ",";
    public static final String ARRAYSEP = ";";
    private final Properties props = new Properties();
    private Path configurationFile;
    private FileTime ft;

    public void setWatchableSourceAndLoad(final Path path) throws ConfigurationException {
        this.configurationFile = path;
        try {
            this.ft = Files.getLastModifiedTime(path, new LinkOption[0]);
            this.reload();
        }
        catch (IOException iOException) {
            throw new ConfigurationException("Cannot watch configuration file. Reason: " + iOException.getMessage(), iOException);
        }
        this.scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                logger.trace("Check configuration file.");
                try {
                    FileTime fileTime = Files.getLastModifiedTime(path, new LinkOption[0]);
                    if (Configuration.this.ft.compareTo(fileTime) < 0) {
                        logger.info("Configuration file was changed.");
                        Configuration.this.reload();
                        Configuration.this.setChanged();
                        Configuration.this.notifyObservers(null);
                    }
                    Configuration.this.ft = fileTime;
                }
                catch (Throwable throwable) {
                    logger.error("Cannot reload configuration file.", throwable);
                }
            }
        }, 5L, 5L, TimeUnit.SECONDS);
    }

    private final void reload() throws IOException {
        this.props.clear();
        try (FileInputStream fileInputStream = new FileInputStream(this.configurationFile.toFile());){
            this.props.load(fileInputStream);
        }
    }

    public Properties getPropertiesCopy() {
        return (Properties)this.props.clone();
    }

    public void load(InputStream inputStream) throws IOException {
        this.props.load(inputStream);
    }

    public String getProperty(String string) {
        return this.props.getProperty(string);
    }

    public void setProperty(String string, String string2) {
        this.props.setProperty(string, string2);
    }

    public void clear() {
        this.props.clear();
    }

    public void putAll(Properties properties) {
        this.props.putAll((Map<?, ?>)properties);
    }

    public int size() {
        return this.props.size();
    }

    public String[][] getStringArrayArray(Key key) throws ConfigurationException {
        try {
            this.checkClass(key, String[][].class);
            String[] stringArray = this.props.getProperty(key.name()).split(ARRAYSEP);
            String[][] stringArray2 = new String[stringArray.length][];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray2[i] = stringArray[i].trim().split(FIELDSEP);
                for (int j = 0; j < stringArray2[i].length; ++j) {
                    stringArray2[i][j] = stringArray2[i][j].trim();
                }
            }
            return stringArray2;
        }
        catch (RuntimeException runtimeException) {
            throw new ConfigurationException("Corrupt property: " + (Object)((Object)key) + " reason: " + runtimeException.getMessage(), runtimeException);
        }
    }

    public String[] getStringArray(Key key) throws ConfigurationException {
        try {
            this.checkClass(key, String[].class);
            String[] stringArray = this.props.getProperty(key.name()).split(FIELDSEP);
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringArray[i].trim();
            }
            return stringArray;
        }
        catch (RuntimeException runtimeException) {
            throw new ConfigurationException("Corrupt property: " + (Object)((Object)key) + " reason: " + runtimeException.getMessage(), runtimeException);
        }
    }

    private void checkClass(Key key, Class clazz) {
        if (!key.keyClass().getSimpleName().equals(clazz.getSimpleName())) {
            throw new RuntimeException("Wrong type wanted! My class is " + key.keyClass().getSimpleName());
        }
    }

    public boolean getBool(Key key) throws ConfigurationException {
        try {
            this.checkClass(key, Boolean.class);
            return Boolean.parseBoolean(this.props.getProperty(key.name()));
        }
        catch (RuntimeException runtimeException) {
            throw new ConfigurationException("Corrupt property: " + (Object)((Object)key) + " reason: " + runtimeException.getMessage(), runtimeException);
        }
    }

    public int getInt(Key key) throws ConfigurationException {
        try {
            this.checkClass(key, Integer.class);
            String string = this.props.getProperty(key.name());
            if ("inf".equals(string)) {
                return Integer.MAX_VALUE;
            }
            return Integer.parseInt(string);
        }
        catch (RuntimeException runtimeException) {
            throw new ConfigurationException("Corrupt property: " + (Object)((Object)key) + " reason: " + runtimeException.getMessage(), runtimeException);
        }
    }

    public Path getPath(Key key) throws ConfigurationException {
        try {
            this.checkClass(key, Path.class);
            return Paths.get(this.props.getProperty(key.name()), new String[0]);
        }
        catch (RuntimeException runtimeException) {
            throw new ConfigurationException("Corrupt property: " + (Object)((Object)key) + " reason: " + runtimeException.getMessage(), runtimeException);
        }
    }

    public URL getUrl(Key key) throws ConfigurationException {
        try {
            this.checkClass(key, URL.class);
            return new URL(this.props.getProperty(key.name()));
        }
        catch (MalformedURLException malformedURLException) {
            throw new ConfigurationException("Corrupt property: " + (Object)((Object)key) + " reason: " + malformedURLException.getMessage(), malformedURLException);
        }
    }
}

