/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.collector.bridgedescs;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import java.util.HashSet;
import java.util.Stack;
import java.util.TreeSet;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.collector.bridgedescs.BridgeDescriptorParser;
import org.torproject.collector.conf.ConfigurationException;

public class BridgeSnapshotReader {
    private static final Logger logger = LoggerFactory.getLogger(BridgeSnapshotReader.class);

    public BridgeSnapshotReader(BridgeDescriptorParser bridgeDescriptorParser, File file, File file2) throws ConfigurationException {
        if (bridgeDescriptorParser == null || file == null || file2 == null) {
            throw new IllegalArgumentException();
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        File file3 = file;
        File file4 = new File(file2, "parsed-bridge-directories");
        boolean bl = false;
        if (file3.exists()) {
            Object object;
            Object object2;
            if (file4.exists()) {
                logger.debug("Reading file " + file4.getAbsolutePath() + "...");
                try {
                    object2 = new BufferedReader(new FileReader(file4));
                    String string = null;
                    while ((string = ((BufferedReader)object2).readLine()) != null) {
                        treeSet.add(string);
                    }
                    ((BufferedReader)object2).close();
                    logger.debug("Finished reading file " + file4.getAbsolutePath() + ".");
                }
                catch (IOException iOException) {
                    logger.warn("Failed reading file " + file4.getAbsolutePath() + "!", iOException);
                    return;
                }
            }
            logger.debug("Importing files in directory " + file + "/...");
            object2 = new HashSet();
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            Stack<Object> stack = new Stack<Object>();
            stack.add(file3);
            while (!stack.isEmpty()) {
                object = (File)stack.pop();
                if (((File)object).isDirectory()) {
                    for (File file5 : ((File)object).listFiles()) {
                        stack.add(file5);
                    }
                    continue;
                }
                if (treeSet.contains(((File)object).getName())) continue;
                try {
                    FileInputStream fileInputStream = new FileInputStream((File)object);
                    if (fileInputStream.available() > 0) {
                        TarArchiveInputStream tarArchiveInputStream = null;
                        if (((File)object).getName().endsWith(".tar.gz")) {
                            GzipCompressorInputStream gzipCompressorInputStream = new GzipCompressorInputStream(fileInputStream);
                            tarArchiveInputStream = new TarArchiveInputStream(gzipCompressorInputStream);
                        } else {
                            if (!((File)object).getName().endsWith(".tar")) continue;
                            tarArchiveInputStream = new TarArchiveInputStream(fileInputStream);
                        }
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(tarArchiveInputStream);
                        String string = ((File)object).getName();
                        String string2 = string.substring(11, 21) + " " + string.substring(22, 24) + ":" + string.substring(24, 26) + ":" + string.substring(26, 28);
                        while (tarArchiveInputStream.getNextTarEntry() != null) {
                            int n8;
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                            byte[] byArray = new byte[1024];
                            while ((n8 = bufferedInputStream.read(byArray, 0, 1024)) >= 0) {
                                byteArrayOutputStream.write(byArray, 0, n8);
                            }
                            byte[] byArray2 = byteArrayOutputStream.toByteArray();
                            if (byArray2.length == 0) continue;
                            String string3 = Hex.encodeHexString(DigestUtils.sha(byArray2));
                            String string4 = new String(byArray2, "US-ASCII");
                            BufferedReader bufferedReader = new BufferedReader(new StringReader(string4));
                            String string5 = null;
                            while ((string5 = bufferedReader.readLine()) != null && string5.startsWith("@")) {
                            }
                            if (string5.startsWith("published ") || string5.startsWith("flag-thresholds ") || string5.startsWith("r ")) {
                                bridgeDescriptorParser.parse(byArray2, string2);
                                ++n3;
                            } else {
                                if (object2.contains(string3)) {
                                    ++n2;
                                    continue;
                                }
                                int n9 = -1;
                                int n10 = -1;
                                int n11 = -1;
                                String string6 = string5.startsWith("router ") ? "router " : "extra-info ";
                                String string7 = "\nrouter-signature\n";
                                String string8 = "\n-----END SIGNATURE-----\n";
                                while (n11 < string4.length() && (n9 = string4.indexOf(string6, n11)) >= 0 && (n10 = string4.indexOf(string7, n9)) >= 0 && (n11 = string4.indexOf(string8, n10 += string7.length())) >= 0) {
                                    byte[] byArray3 = new byte[(n11 += string8.length()) - n9];
                                    System.arraycopy(byArray2, n9, byArray3, 0, n11 - n9);
                                    String string9 = Hex.encodeHexString(DigestUtils.sha(byArray3));
                                    if (!object2.contains(string9)) {
                                        bridgeDescriptorParser.parse(byArray3, string2);
                                        object2.add(string9);
                                        if (string5.startsWith("router ")) {
                                            ++n4;
                                            continue;
                                        }
                                        ++n6;
                                        continue;
                                    }
                                    if (string5.startsWith("router ")) {
                                        ++n5;
                                        continue;
                                    }
                                    ++n7;
                                }
                            }
                            object2.add(string3);
                            ++n;
                        }
                        bufferedInputStream.close();
                    }
                    fileInputStream.close();
                    System.gc();
                    treeSet.add(((File)object).getName());
                    bl = true;
                }
                catch (IOException iOException) {
                    logger.warn("Could not parse bridge snapshot " + ((File)object).getName() + "!", iOException);
                }
            }
            logger.debug("Finished importing files in directory " + file + "/.  In total, we parsed " + n + " files (skipped " + n2 + ") containing " + n3 + " statuses, " + n4 + " server descriptors (skipped " + n5 + "), and " + n6 + " extra-info descriptors (skipped " + n7 + ").");
            if (!treeSet.isEmpty() && bl) {
                logger.debug("Writing file " + file4.getAbsolutePath() + "...");
                try {
                    file4.getParentFile().mkdirs();
                    object = new BufferedWriter(new FileWriter(file4));
                    for (String string : treeSet) {
                        ((Writer)object).append(string + "\n");
                    }
                    ((BufferedWriter)object).close();
                    logger.debug("Finished writing file " + file4.getAbsolutePath() + ".");
                }
                catch (IOException iOException) {
                    logger.warn("Failed writing file " + file4.getAbsolutePath() + "!", iOException);
                }
            }
        }
    }
}

