/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.collector.relaydescs;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Stack;
import java.util.TimeZone;
import java.util.TreeSet;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.collector.relaydescs.RelayDescriptorParser;

public class CachedRelayDescriptorReader {
    private static final Logger logger = LoggerFactory.getLogger(CachedRelayDescriptorReader.class);

    public CachedRelayDescriptorReader(RelayDescriptorParser relayDescriptorParser, String[] stringArray, File file) {
        Object object;
        if (relayDescriptorParser == null || stringArray == null || stringArray.length == 0 || file == null) {
            throw new IllegalArgumentException();
        }
        StringBuilder stringBuilder = new StringBuilder("Finished importing relay descriptors from local Tor data directories:");
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        File file2 = new File(file, "cacheddesc-import-history");
        if (file2.exists()) {
            try {
                String string;
                object = new BufferedReader(new FileReader(file2));
                while ((string = ((BufferedReader)object).readLine()) != null) {
                    hashSet.add(string);
                }
                ((BufferedReader)object).close();
            }
            catch (IOException iOException) {
                logger.warn("Could not read import history from " + file2.getAbsolutePath() + ".", iOException);
            }
        }
        for (String string : stringArray) {
            File file3 = new File(string);
            if (!file3.exists()) {
                logger.warn("Directory " + file3.getAbsolutePath() + " does not exist. Skipping.");
                continue;
            }
            logger.debug("Reading " + file3.getAbsolutePath() + " directory.");
            TreeSet<Object> treeSet = new TreeSet<Object>();
            Stack<File> stack = new Stack<File>();
            stack.add(file3);
            while (!stack.isEmpty()) {
                File file4 = (File)stack.pop();
                if (file4.isDirectory()) {
                    stack.addAll(Arrays.asList(file4.listFiles()));
                    continue;
                }
                treeSet.add(file4);
            }
            for (File file5 : treeSet) {
                try {
                    Object object2;
                    int n;
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file5));
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    byte[] byArray = new byte[1024];
                    while ((n = bufferedInputStream.read(byArray, 0, 1024)) >= 0) {
                        byteArrayOutputStream.write(byArray, 0, n);
                    }
                    bufferedInputStream.close();
                    byte[] byArray2 = byteArrayOutputStream.toByteArray();
                    if (file5.getName().equals("cached-consensus")) {
                        Object object3;
                        object2 = new BufferedReader(new StringReader(new String(byArray2, "US-ASCII")));
                        String string2 = null;
                        while ((string2 = ((BufferedReader)object2).readLine()) != null) {
                            if (!string2.startsWith("valid-after ")) continue;
                            stringBuilder.append("\n" + file5.getName() + ": " + string2.substring("valid-after ".length()));
                            object3 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            ((DateFormat)object3).setTimeZone(TimeZone.getTimeZone("UTC"));
                            if (((DateFormat)object3).parse(string2.substring("valid-after ".length())).getTime() >= System.currentTimeMillis() - 21600000L) break;
                            logger.warn("Cached descriptor files in " + file3.getAbsolutePath() + " are stale. The valid-after line in cached-consensus is '" + string2 + "'.");
                            stringBuilder.append(" (stale!)");
                            break;
                        }
                        ((BufferedReader)object2).close();
                        if (relayDescriptorParser == null) continue;
                        object3 = Hex.encodeHexString(DigestUtils.sha(byArray2));
                        if (!hashSet.contains(object3) && !hashSet2.contains(object3)) {
                            relayDescriptorParser.parse(byArray2);
                        } else {
                            stringBuilder.append(" (skipped)");
                        }
                        hashSet2.add((String)object3);
                        continue;
                    }
                    if (file5.getName().equals("v3-status-votes")) {
                        int n2 = 0;
                        int n3 = 0;
                        String string3 = new String(byArray2, "US-ASCII");
                        String string4 = "network-status-version ";
                        int n4 = string3.length();
                        int n5 = string3.indexOf(string4);
                        while (n5 >= 0 && n5 < n4) {
                            int n6 = string3.indexOf(string4, n5 + 1);
                            if (n6 < 0) {
                                n6 = n4;
                            }
                            if (n5 < n6) {
                                byte[] byArray3 = new byte[n6 - n5];
                                System.arraycopy(byArray2, n5, byArray3, 0, n6 - n5);
                                if (relayDescriptorParser != null) {
                                    String string5 = Hex.encodeHexString(DigestUtils.sha(byArray3));
                                    if (!hashSet.contains(string5) && !hashSet2.contains(string5)) {
                                        relayDescriptorParser.parse(byArray3);
                                        ++n2;
                                    } else {
                                        ++n3;
                                    }
                                    hashSet2.add(string5);
                                }
                            }
                            n5 = n6;
                        }
                        stringBuilder.append("\n" + file5.getName() + ": parsed " + n2 + ", skipped " + n3 + " votes");
                        continue;
                    }
                    if (!file5.getName().startsWith("cached-descriptors") && !file5.getName().startsWith("cached-extrainfo")) continue;
                    object2 = new String(byArray2, "US-ASCII");
                    int n7 = -1;
                    int n8 = -1;
                    int n9 = -1;
                    String string6 = file5.getName().startsWith("cached-descriptors") ? "router " : "extra-info ";
                    String string7 = "\nrouter-signature\n";
                    String string8 = "\n-----END SIGNATURE-----\n";
                    int n10 = 0;
                    int n11 = 0;
                    while (n9 < ((String)object2).length() && (n7 = ((String)object2).indexOf(string6, n9)) >= 0 && (n8 = ((String)object2).indexOf(string7, n7)) >= 0 && (n9 = ((String)object2).indexOf(string8, n8 += string7.length())) >= 0) {
                        byte[] byArray4 = new byte[(n9 += string8.length()) - n7];
                        System.arraycopy(byArray2, n7, byArray4, 0, n9 - n7);
                        if (relayDescriptorParser == null) continue;
                        String string9 = Hex.encodeHexString(DigestUtils.sha(byArray4));
                        if (!hashSet.contains(string9) && !hashSet2.contains(string9)) {
                            relayDescriptorParser.parse(byArray4);
                            ++n10;
                        } else {
                            ++n11;
                        }
                        hashSet2.add(string9);
                    }
                    stringBuilder.append("\n" + file5.getName() + ": parsed " + n10 + ", skipped " + n11 + " " + (file5.getName().startsWith("cached-descriptors") ? "server" : "extra-info") + " descriptors");
                }
                catch (IOException iOException) {
                    logger.warn("Failed reading " + file3.getAbsolutePath() + " directory.", iOException);
                }
                catch (ParseException parseException) {
                    logger.warn("Failed reading " + file3.getAbsolutePath() + " directory.", parseException);
                }
            }
            logger.debug("Finished reading " + file3.getAbsolutePath() + " directory.");
        }
        try {
            file2.getParentFile().mkdirs();
            object = new BufferedWriter(new FileWriter(file2));
            for (String string : hashSet2) {
                ((Writer)object).write(string + "\n");
            }
            ((BufferedWriter)object).close();
        }
        catch (IOException iOException) {
            logger.warn("Could not write import history to " + file2.getAbsolutePath() + ".", iOException);
        }
        logger.info(stringBuilder.toString());
    }
}

