/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.collector.bridgedescs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.collector.bridgedescs.SanitizedBridgesWriter;
import org.torproject.collector.conf.ConfigurationException;

public class BridgeDescriptorParser {
    private SanitizedBridgesWriter sbw;
    private static final Logger logger = LoggerFactory.getLogger(BridgeDescriptorParser.class);

    public BridgeDescriptorParser(SanitizedBridgesWriter sanitizedBridgesWriter) {
        this.sbw = sanitizedBridgesWriter;
    }

    public void parse(byte[] byArray, String string) throws ConfigurationException {
        try {
            BufferedReader bufferedReader = new BufferedReader(new StringReader(new String(byArray, "US-ASCII")));
            String string2 = bufferedReader.readLine();
            if (string2 == null) {
                return;
            }
            if (string2.startsWith("router ")) {
                if (this.sbw != null) {
                    this.sbw.sanitizeAndStoreServerDescriptor(byArray);
                }
            } else if (string2.startsWith("extra-info ")) {
                if (this.sbw != null) {
                    this.sbw.sanitizeAndStoreExtraInfoDescriptor(byArray);
                }
            } else if (this.sbw != null) {
                this.sbw.sanitizeAndStoreNetworkStatus(byArray, string);
            }
        }
        catch (IOException iOException) {
            logger.warn("Could not parse bridge descriptor.", iOException);
            return;
        }
    }
}

