let postcss = require('postcss')
let { test } = require('uvu')
let { equal } = require('uvu/assert')

let autoprefixer = require('..')

test('works with other PostCSS plugins', () => {
  let plugin = () => {
    return {
      AtRule: {
        mixin: (atRule, { Declaration }) => {
          atRule.replaceWith(
            new Declaration({ prop: 'user-select', value: 'none' })
          )
        }
      },
      postcssPlugin: 'test',
      Rule(rule) {
        rule.selector = 'b'
      }
    }
  }
  plugin.postcss = true

  let result = postcss([
    plugin(),
    autoprefixer({ overrideBrowserslist: 'chrome 40' })
  ]).process('a{ @mixin; }', {
    from: 'a.css'
  })

  equal(result.css, 'b{ -webkit-user-select: none; user-select: none; }')
})

test.run()
