//
// File: test_cborpsmmap.cpp
// Created by: Olivier Langella
// Created on: 8/7/2025
//
/*******************************************************************************
 * Copyright (c) 2025 Olivier Langella <Olivier.Langella@universite-paris-saclay.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/


// ./tests/catch2-only-tests [psmmap] -s

#include <catch2/catch_test_macros.hpp>
#include <pappsomspp/core/processing/cbor/psm/psmproteinmap.h>
#include <QBuffer>

TEST_CASE("cbor psm map test suite.", "[psmmap]")
{
  // Set the debugging message formatting pattern.
  qSetMessagePattern(QString("%{file}@%{line}, %{function}(): %{message}"));

  SECTION("..:: PSM cbor map ::..", "[psmmap]")
  {
    pappso::cbor::psm::PsmProteinMap protein_map;

    pappso::cbor::psm::PsmProtein psm_protein;
    psm_protein.protein_sp = std::make_shared<pappso::Protein>(
      "cry1Ac", "MDNNPNINECIPYNCLSNPEVEVLGGERIETGYTPIDISLSLTQFLLSEFVPGAGFVLGLVDIIWGIFGPSQWD");

    psm_protein.isTarget = false;

    protein_map.insert(psm_protein);

    psm_protein.protein_sp = std::make_shared<pappso::Protein>(
      "cry1Ac-2 the protein I like",
      "MDNNPNINECIPYNCLSNPEVEVLGGERIETGYTPIDISLSLTQFLLSEFVPGAGFVLGLVDIIWGIFGPSQWD");

    psm_protein.isTarget = true;


    protein_map.insert(psm_protein);

    REQUIRE(protein_map.size() == 2);

    QBuffer buffer;
    buffer.open(QIODevice::ReadWrite);
    pappso::cbor::CborStreamWriter writer(&buffer);

    protein_map.writeMap(writer);


    pappso::cbor::psm::PsmProteinMap new_protein_map;

    buffer.seek(0);
    pappso::cbor::CborStreamReader reader(&buffer);
    new_protein_map.readMap(reader);


    REQUIRE(new_protein_map.size() == 2);
    REQUIRE(
      new_protein_map.getByAccession("cry1Ac-2").protein_sp.get()->getAccession().toStdString() ==
      "cry1Ac-2");
    REQUIRE(
      new_protein_map.getByAccession("cry1Ac-2").protein_sp.get()->getDescription().toStdString() ==
      "the protein I like");
    REQUIRE(new_protein_map.getByAccession("cry1Ac-2").isTarget == true);
    REQUIRE(new_protein_map.getByAccession("cry1Ac").isTarget == false);
  }
}
