
BEGIN {
  unless ($ENV{AUTHOR_TESTING}) {
    require Test::More;
    Test::More::plan(skip_all => 'these tests are for testing by the author');
  }
}

use strict;
use warnings;

# this test was generated with Dist::Zilla::Plugin::Test::EOL 0.18

use Test::More 0.88;
use Test::EOL;

my @files = (
    'bin/hid',
    'lib/HiD.pm',
    'lib/HiD/App.pm',
    'lib/HiD/App/Command.pm',
    'lib/HiD/App/Command/config.pm',
    'lib/HiD/App/Command/init.pm',
    'lib/HiD/App/Command/publish.pm',
    'lib/HiD/App/Command/server.pm',
    'lib/HiD/File.pm',
    'lib/HiD/Generator.pm',
    'lib/HiD/Generator/ArchivePage.pm',
    'lib/HiD/Generator/AtomFeed.pm',
    'lib/HiD/Generator/CategoryPages.pm',
    'lib/HiD/Generator/RSSFeed.pm',
    'lib/HiD/Generator/TagPages.pm',
    'lib/HiD/Layout.pm',
    'lib/HiD/Page.pm',
    'lib/HiD/Pager.pm',
    'lib/HiD/Plugin.pm',
    'lib/HiD/Post.pm',
    'lib/HiD/Processor.pm',
    'lib/HiD/Processor/Handlebars.pm',
    'lib/HiD/Processor/IIBlog.pm',
    'lib/HiD/Processor/Template.pm',
    'lib/HiD/Role/DoesLogging.pm',
    'lib/HiD/Role/IsConverted.pm',
    'lib/HiD/Role/IsPost.pm',
    'lib/HiD/Role/IsPublished.pm',
    'lib/HiD/Role/PublishesDrafts.pm',
    'lib/HiD/Server.pm',
    'lib/HiD/Server/Handler.pm',
    'lib/HiD/Server/Loader.pm',
    'lib/HiD/Types.pm',
    'lib/HiD/VirtualPage.pm',
    't/00-compile.t',
    't/author-eol.t',
    't/cmd-config.t',
    't/cmd-help.t',
    't/cmd-init.t',
    't/cmd-publish.t',
    't/config.t',
    't/file.t',
    't/hid.t',
    't/jekyll_test_source/_includes/sig.markdown',
    't/jekyll_test_source/_layouts/default.html',
    't/jekyll_test_source/_layouts/simple.html',
    't/jekyll_test_source/_posts/2008-02-02-not-published.textile',
    't/jekyll_test_source/_posts/2008-02-02-published.textile',
    't/jekyll_test_source/_posts/2008-10-18-foo-bar.textile',
    't/jekyll_test_source/_posts/2008-11-21-complex.textile',
    't/jekyll_test_source/_posts/2008-12-03-permalinked-post.textile',
    't/jekyll_test_source/_posts/2008-12-13-include.markdown',
    't/jekyll_test_source/_posts/2009-01-27-array-categories.textile',
    't/jekyll_test_source/_posts/2009-01-27-categories.textile',
    't/jekyll_test_source/_posts/2009-01-27-category.textile',
    't/jekyll_test_source/_posts/2009-01-27-empty-categories.textile',
    't/jekyll_test_source/_posts/2009-01-27-empty-category.textile',
    't/jekyll_test_source/_posts/2009-03-12-hash-#1.markdown',
    't/jekyll_test_source/_posts/2009-05-18-empty-tag.textile',
    't/jekyll_test_source/_posts/2009-05-18-empty-tags.textile',
    't/jekyll_test_source/_posts/2009-05-18-tag.textile',
    't/jekyll_test_source/_posts/2009-05-18-tags.textile',
    't/jekyll_test_source/_posts/2009-06-22-empty-yaml.textile',
    't/jekyll_test_source/_posts/2009-06-22-no-yaml.textile',
    't/jekyll_test_source/_posts/2010-01-08-triple-dash.markdown',
    't/jekyll_test_source/_posts/2010-01-09-date-override.textile',
    't/jekyll_test_source/_posts/2010-01-09-time-override.textile',
    't/jekyll_test_source/_posts/2010-01-09-timezone-override.textile',
    't/jekyll_test_source/_posts/2010-01-16-override-data.textile',
    't/jekyll_test_source/_posts/2011-04-12-md-extension.md',
    't/jekyll_test_source/_posts/2011-04-12-text-extension.text',
    't/jekyll_test_source/about.html',
    't/jekyll_test_source/category/_posts/2008-9-23-categories.textile',
    't/jekyll_test_source/contacts.html',
    't/jekyll_test_source/css/index.css',
    't/jekyll_test_source/css/screen.css',
    't/jekyll_test_source/deal.with.dots.html',
    't/jekyll_test_source/foo/_posts/bar/2008-12-12-topical-post.textile',
    't/jekyll_test_source/index.html',
    't/jekyll_test_source/sitemap.xml',
    't/jekyll_test_source/win/_posts/2009-05-24-yaml-linebreak.markdown',
    't/jekyll_test_source/z_category/_posts/2008-9-23-categories.textile',
    't/layout.t',
    't/lib/Test/HiD/File.pm',
    't/lib/Test/HiD/Layout.pm',
    't/lib/Test/HiD/Page.pm',
    't/lib/Test/HiD/Post.pm',
    't/lib/Test/HiD/Role/IsConverted.pm',
    't/lib/Test/HiD/Role/IsPost.pm',
    't/lib/Test/HiD/Role/IsPublished.pm',
    't/lib/Test/HiD/Util.pm',
    't/page.t',
    't/post-twitter.t',
    't/post.t',
    't/release-pod-coverage.t',
    't/release-pod-syntax.t'
);

eol_unix_ok($_, { trailing_whitespace => 1 }) foreach @files;
done_testing;
