#########################################################################################
# Package        HiPi::Graphics::BitmapFont::SerifEPD76
# Description  : Monochrome OLED Font
# License      : This is free software; you can redistribute it and/or modify it under
#                the same terms as the Perl 5 programming language system itself.
#########################################################################################

package HiPi::Graphics::BitmapFont::SerifEPD76;

#########################################################################################

use utf8;
use strict;
use warnings;
use parent qw( HiPi::Graphics::BitmapFont);

our $VERSION ='0.01';

my $gap_width = 0;
my $char_height = 76;
my $line_spacing = 0;
my $name = 'Serif 76';
my $space_width = 20;
 
my $symbols = {
    '33' => {    # '!'
        'width'    => 8, 
        'xoffset'  => 9, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0x7E, ##   000000 
            0x7E, ##   000000 
            0x7E, ##   000000 
            0x7E, ##   000000 
            0x7E, ##   000000 
            0x7E, ##   000000 
            0x7E, ##   000000 
            0x7E, ##   000000 
            0x7E, ##   000000 
            0x7E, ##   000000 
            0x7E, ##   000000 
            0x7E, ##   000000 
            0x7E, ##   000000 
            0x3E, ##    00000 
            0x3C, ##    0000  
            0x3C, ##    0000  
            0x3C, ##    0000  
            0x3C, ##    0000  
            0x3C, ##    0000  
            0x3C, ##    0000  
            0x3C, ##    0000  
            0x3C, ##    0000  
            0x3C, ##    0000  
            0x3C, ##    0000  
            0x3C, ##    0000  
            0x3C, ##    0000  
            0x3C, ##    0000  
            0x3C, ##    0000  
            0x00, ##          
            0x00, ##          
            0x00, ##          
            0x00, ##          
            0x00, ##          
            0x00, ##          
            0x3C, ##    0000  
            0x7E, ##   000000 
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0x7E, ##   000000 
            0x3C, ##    0000  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '34' => {    # '"'
        'width'    => 17, 
        'xoffset'  => 6, 
        'xadvance' => 29, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xF8, 0x0F, 0x80, ##  00000       00000
            0xF8, 0x0F, 0x80, ##  00000       00000
            0xF8, 0x0F, 0x80, ##  00000       00000
            0xF8, 0x0F, 0x80, ##  00000       00000
            0xF8, 0x0F, 0x80, ##  00000       00000
            0xF8, 0x0F, 0x80, ##  00000       00000
            0xF8, 0x0F, 0x80, ##  00000       00000
            0xF8, 0x0F, 0x80, ##  00000       00000
            0xF8, 0x0F, 0x80, ##  00000       00000
            0xF8, 0x0F, 0x80, ##  00000       00000
            0xF8, 0x0F, 0x80, ##  00000       00000
            0xF8, 0x0F, 0x80, ##  00000       00000
            0xF8, 0x0F, 0x80, ##  00000       00000
            0xF8, 0x0F, 0x80, ##  00000       00000
            0xF8, 0x0F, 0x80, ##  00000       00000
            0xF8, 0x0F, 0x80, ##  00000       00000
            0xF8, 0x0F, 0x80, ##  00000       00000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '35' => {    # '#'
        'width'    => 44, 
        'xoffset'  => 5, 
        'xadvance' => 54, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x3E, 0x00, 0xF8, 0x00, ##                    00000         00000       
            0x00, 0x00, 0x3E, 0x00, 0xF8, 0x00, ##                    00000         00000       
            0x00, 0x00, 0x7E, 0x01, 0xF8, 0x00, ##                   000000        000000       
            0x00, 0x00, 0x7C, 0x01, 0xF0, 0x00, ##                   00000         00000        
            0x00, 0x00, 0x7C, 0x01, 0xF0, 0x00, ##                   00000         00000        
            0x00, 0x00, 0x7C, 0x01, 0xF0, 0x00, ##                   00000         00000        
            0x00, 0x00, 0xFC, 0x03, 0xF0, 0x00, ##                  000000        000000        
            0x00, 0x00, 0xFC, 0x03, 0xE0, 0x00, ##                  000000        00000         
            0x00, 0x00, 0xF8, 0x03, 0xE0, 0x00, ##                  00000         00000         
            0x00, 0x00, 0xF8, 0x03, 0xE0, 0x00, ##                  00000         00000         
            0x00, 0x00, 0xF8, 0x07, 0xE0, 0x00, ##                  00000        000000         
            0x00, 0x01, 0xF8, 0x07, 0xC0, 0x00, ##                 000000        00000          
            0x00, 0x01, 0xF0, 0x07, 0xC0, 0x00, ##                 00000         00000          
            0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, ##      0000000000000000000000000000000000000000
            0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, ##      0000000000000000000000000000000000000000
            0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, ##      0000000000000000000000000000000000000000
            0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, ##      0000000000000000000000000000000000000000
            0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, ##      0000000000000000000000000000000000000000
            0x00, 0x03, 0xE0, 0x0F, 0x80, 0x00, ##                00000         00000           
            0x00, 0x07, 0xE0, 0x1F, 0x80, 0x00, ##               000000        000000           
            0x00, 0x07, 0xC0, 0x1F, 0x00, 0x00, ##               00000         00000            
            0x00, 0x07, 0xC0, 0x1F, 0x00, 0x00, ##               00000         00000            
            0x00, 0x07, 0xC0, 0x1F, 0x00, 0x00, ##               00000         00000            
            0x00, 0x0F, 0xC0, 0x3F, 0x00, 0x00, ##              000000        000000            
            0x00, 0x0F, 0x80, 0x3E, 0x00, 0x00, ##              00000         00000             
            0x00, 0x0F, 0x80, 0x3E, 0x00, 0x00, ##              00000         00000             
            0x00, 0x0F, 0x80, 0x3E, 0x00, 0x00, ##              00000         00000             
            0x00, 0x1F, 0x80, 0x7E, 0x00, 0x00, ##             000000        000000             
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, ##  0000000000000000000000000000000000000000    
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, ##  0000000000000000000000000000000000000000    
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, ##  0000000000000000000000000000000000000000    
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, ##  0000000000000000000000000000000000000000    
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, ##  0000000000000000000000000000000000000000    
            0x00, 0x3E, 0x00, 0xF8, 0x00, 0x00, ##            00000         00000               
            0x00, 0x3E, 0x00, 0xF8, 0x00, 0x00, ##            00000         00000               
            0x00, 0x7E, 0x01, 0xF8, 0x00, 0x00, ##           000000        000000               
            0x00, 0x7C, 0x01, 0xF0, 0x00, 0x00, ##           00000         00000                
            0x00, 0x7C, 0x01, 0xF0, 0x00, 0x00, ##           00000         00000                
            0x00, 0x7C, 0x01, 0xF0, 0x00, 0x00, ##           00000         00000                
            0x00, 0xFC, 0x03, 0xF0, 0x00, 0x00, ##          000000        000000                
            0x00, 0xF8, 0x03, 0xE0, 0x00, 0x00, ##          00000         00000                 
            0x00, 0xF8, 0x03, 0xE0, 0x00, 0x00, ##          00000         00000                 
            0x00, 0xF8, 0x03, 0xE0, 0x00, 0x00, ##          00000         00000                 
            0x01, 0xF8, 0x07, 0xE0, 0x00, 0x00, ##         000000        000000                 
            0x01, 0xF0, 0x07, 0xC0, 0x00, 0x00, ##         00000         00000                  
            0x01, 0xF0, 0x07, 0xC0, 0x00, 0x00, ##         00000         00000                  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '36' => {    # '$'
        'width'    => 30, 
        'xoffset'  => 5, 
        'xadvance' => 40, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x07, 0x00, 0x00, ##               000              
            0x00, 0x07, 0x00, 0x00, ##               000              
            0x00, 0x07, 0x00, 0x00, ##               000              
            0x00, 0x07, 0x00, 0x00, ##               000              
            0x00, 0x07, 0x00, 0x00, ##               000              
            0x00, 0x07, 0x00, 0x00, ##               000              
            0x00, 0x07, 0x00, 0x00, ##               000              
            0x00, 0x07, 0x00, 0x00, ##               000              
            0x00, 0x7F, 0xF8, 0x00, ##           000000000000         
            0x03, 0xFF, 0xFF, 0x00, ##        000000000000000000      
            0x0F, 0xFF, 0xFF, 0xE0, ##      00000000000000000000000   
            0x1F, 0xC7, 0x1F, 0xF0, ##     0000000   000   000000000  
            0x3F, 0x07, 0x07, 0xF0, ##    000000     000     0000000  
            0x7E, 0x07, 0x03, 0xF0, ##   000000      000      000000  
            0x7E, 0x07, 0x01, 0xF0, ##   000000      000       00000  
            0x7C, 0x07, 0x01, 0xF0, ##   00000       000       00000  
            0xFC, 0x07, 0x00, 0xF0, ##  000000       000        0000  
            0xFC, 0x07, 0x00, 0xF0, ##  000000       000        0000  
            0xFC, 0x07, 0x00, 0xF0, ##  000000       000        0000  
            0xFC, 0x07, 0x00, 0x00, ##  000000       000              
            0xFE, 0x07, 0x00, 0x00, ##  0000000      000              
            0xFF, 0x07, 0x00, 0x00, ##  00000000     000              
            0xFF, 0x87, 0x00, 0x00, ##  000000000    000              
            0x7F, 0xE7, 0x00, 0x00, ##   0000000000  000              
            0x7F, 0xFF, 0x00, 0x00, ##   000000000000000              
            0x3F, 0xFF, 0x80, 0x00, ##    000000000000000             
            0x1F, 0xFF, 0xF0, 0x00, ##     00000000000000000          
            0x07, 0xFF, 0xFE, 0x00, ##       000000000000000000       
            0x01, 0xFF, 0xFF, 0x80, ##         000000000000000000     
            0x00, 0x7F, 0xFF, 0xC0, ##           00000000000000000    
            0x00, 0x0F, 0xFF, 0xE0, ##              000000000000000   
            0x00, 0x07, 0xFF, 0xF0, ##               000000000000000  
            0x00, 0x07, 0x3F, 0xF8, ##               000  00000000000 
            0x00, 0x07, 0x0F, 0xF8, ##               000    000000000 
            0x00, 0x07, 0x07, 0xFC, ##               000     000000000
            0x00, 0x07, 0x03, 0xFC, ##               000      00000000
            0x00, 0x07, 0x03, 0xFC, ##               000      00000000
            0xE0, 0x07, 0x01, 0xFC, ##  000          000       0000000
            0xE0, 0x07, 0x01, 0xFC, ##  000          000       0000000
            0xE0, 0x07, 0x01, 0xFC, ##  000          000       0000000
            0xE0, 0x07, 0x01, 0xFC, ##  000          000       0000000
            0xF0, 0x07, 0x01, 0xF8, ##  0000         000       000000 
            0xF0, 0x07, 0x03, 0xF8, ##  0000         000      0000000 
            0xF8, 0x07, 0x03, 0xF0, ##  00000        000      000000  
            0xFC, 0x07, 0x07, 0xF0, ##  000000       000     0000000  
            0xFF, 0x87, 0x1F, 0xE0, ##  000000000    000   00000000   
            0x7F, 0xFF, 0xFF, 0x80, ##   000000000000000000000000     
            0x0F, 0xFF, 0xFF, 0x00, ##      00000000000000000000      
            0x00, 0xFF, 0xF8, 0x00, ##          0000000000000         
            0x00, 0x07, 0x00, 0x00, ##               000              
            0x00, 0x07, 0x00, 0x00, ##               000              
            0x00, 0x07, 0x00, 0x00, ##               000              
            0x00, 0x07, 0x00, 0x00, ##               000              
            0x00, 0x07, 0x00, 0x00, ##               000              
            0x00, 0x07, 0x00, 0x00, ##               000              
            0x00, 0x07, 0x00, 0x00, ##               000              
            0x00, 0x07, 0x00, 0x00, ##               000              
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '37' => {    # '%'
        'width'    => 54, 
        'xoffset'  => 4, 
        'xadvance' => 62, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0xFC, 0x00, 0x00, 0x01, 0xF0, 0x00, ##          000000                         00000          
            0x07, 0xFF, 0x80, 0x00, 0x03, 0xE0, 0x00, ##       000000000000                     00000           
            0x0F, 0xFF, 0xC0, 0x00, 0x07, 0xC0, 0x00, ##      00000000000000                   00000            
            0x1F, 0x87, 0xE0, 0x00, 0x07, 0xC0, 0x00, ##     000000    000000                  00000            
            0x3E, 0x01, 0xF0, 0x00, 0x0F, 0x80, 0x00, ##    00000        00000                00000             
            0x3E, 0x01, 0xF0, 0x00, 0x0F, 0x80, 0x00, ##    00000        00000                00000             
            0x7C, 0x00, 0xF8, 0x00, 0x1F, 0x00, 0x00, ##   00000          00000              00000              
            0x7C, 0x00, 0xF8, 0x00, 0x3E, 0x00, 0x00, ##   00000          00000             00000               
            0xF8, 0x00, 0xF8, 0x00, 0x3E, 0x00, 0x00, ##  00000           00000             00000               
            0xF8, 0x00, 0x7C, 0x00, 0x7C, 0x00, 0x00, ##  00000            00000           00000                
            0xF8, 0x00, 0x7C, 0x00, 0x7C, 0x00, 0x00, ##  00000            00000           00000                
            0xF8, 0x00, 0x7C, 0x00, 0xF8, 0x00, 0x00, ##  00000            00000          00000                 
            0xF8, 0x00, 0x7C, 0x01, 0xF0, 0x00, 0x00, ##  00000            00000         00000                  
            0xF8, 0x00, 0x7C, 0x01, 0xF0, 0x00, 0x00, ##  00000            00000         00000                  
            0xF8, 0x00, 0x7C, 0x03, 0xE0, 0x00, 0x00, ##  00000            00000        00000                   
            0xF8, 0x00, 0x7C, 0x03, 0xE0, 0x00, 0x00, ##  00000            00000        00000                   
            0xF8, 0x00, 0x7C, 0x07, 0xC0, 0x00, 0x00, ##  00000            00000       00000                    
            0xF8, 0x00, 0xF8, 0x0F, 0x80, 0x00, 0x00, ##  00000           00000       00000                     
            0x7C, 0x00, 0xF8, 0x0F, 0x80, 0x00, 0x00, ##   00000          00000       00000                     
            0x7C, 0x00, 0xF8, 0x1F, 0x00, 0x00, 0x00, ##   00000          00000      00000                      
            0x3E, 0x01, 0xF0, 0x1F, 0x00, 0x00, 0x00, ##    00000        00000       00000                      
            0x3E, 0x01, 0xF0, 0x3E, 0x00, 0x00, 0x00, ##    00000        00000      00000                       
            0x1F, 0x87, 0xE0, 0x7C, 0x00, 0x00, 0x00, ##     000000    000000      00000                        
            0x0F, 0xFF, 0xC0, 0x7C, 0x01, 0xFE, 0x00, ##      00000000000000       00000         00000000       
            0x07, 0xFF, 0x80, 0xF8, 0x07, 0xFF, 0x80, ##       000000000000       00000        000000000000     
            0x01, 0xFE, 0x00, 0xF8, 0x0F, 0xFF, 0xC0, ##         00000000         00000       00000000000000    
            0x00, 0x00, 0x01, 0xF0, 0x1F, 0x87, 0xE0, ##                         00000       000000    000000   
            0x00, 0x00, 0x03, 0xE0, 0x3E, 0x01, 0xF0, ##                        00000       00000        00000  
            0x00, 0x00, 0x03, 0xE0, 0x7E, 0x01, 0xF0, ##                        00000      000000        00000  
            0x00, 0x00, 0x07, 0xC0, 0x7C, 0x00, 0xF8, ##                       00000       00000          00000 
            0x00, 0x00, 0x07, 0xC0, 0x7C, 0x00, 0xF8, ##                       00000       00000          00000 
            0x00, 0x00, 0x0F, 0x80, 0xF8, 0x00, 0x7C, ##                      00000       00000            00000
            0x00, 0x00, 0x1F, 0x00, 0xF8, 0x00, 0x7C, ##                     00000        00000            00000
            0x00, 0x00, 0x1F, 0x00, 0xF8, 0x00, 0x7C, ##                     00000        00000            00000
            0x00, 0x00, 0x3E, 0x00, 0xF8, 0x00, 0x7C, ##                    00000         00000            00000
            0x00, 0x00, 0x3E, 0x00, 0xF8, 0x00, 0x7C, ##                    00000         00000            00000
            0x00, 0x00, 0x7C, 0x00, 0xF8, 0x00, 0x7C, ##                   00000          00000            00000
            0x00, 0x00, 0xF8, 0x00, 0xF8, 0x00, 0x7C, ##                  00000           00000            00000
            0x00, 0x00, 0xF8, 0x00, 0xF8, 0x00, 0x7C, ##                  00000           00000            00000
            0x00, 0x01, 0xF0, 0x00, 0xF8, 0x00, 0x7C, ##                 00000            00000            00000
            0x00, 0x01, 0xF0, 0x00, 0x7C, 0x00, 0xF8, ##                 00000             00000          00000 
            0x00, 0x03, 0xE0, 0x00, 0x7C, 0x00, 0xF8, ##                00000              00000          00000 
            0x00, 0x07, 0xC0, 0x00, 0x7E, 0x01, 0xF0, ##               00000               000000        00000  
            0x00, 0x07, 0xC0, 0x00, 0x3E, 0x01, 0xF0, ##               00000                00000        00000  
            0x00, 0x0F, 0x80, 0x00, 0x1F, 0x87, 0xE0, ##              00000                  000000    000000   
            0x00, 0x0F, 0x80, 0x00, 0x0F, 0xFF, 0xC0, ##              00000                   00000000000000    
            0x00, 0x1F, 0x00, 0x00, 0x07, 0xFF, 0x80, ##             00000                     000000000000     
            0x00, 0x3E, 0x00, 0x00, 0x01, 0xFE, 0x00, ##            00000                        00000000       
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '38' => {    # '&'
        'width'    => 50, 
        'xoffset'  => 5, 
        'xadvance' => 58, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x01, 0xFF, 0x80, 0x00, 0x00, 0x00, ##                 0000000000                         
            0x00, 0x07, 0xFF, 0xF8, 0x00, 0x00, 0x00, ##               0000000000000000                     
            0x00, 0x1F, 0xFF, 0xFE, 0x00, 0x00, 0x00, ##             00000000000000000000                   
            0x00, 0x3F, 0x81, 0xFE, 0x00, 0x00, 0x00, ##            0000000      00000000                   
            0x00, 0x7E, 0x00, 0x7E, 0x00, 0x00, 0x00, ##           000000          000000                   
            0x00, 0xFC, 0x00, 0x3E, 0x00, 0x00, 0x00, ##          000000            00000                   
            0x00, 0xFC, 0x00, 0x3E, 0x00, 0x00, 0x00, ##          000000            00000                   
            0x01, 0xF8, 0x00, 0x1E, 0x00, 0x00, 0x00, ##         000000              0000                   
            0x01, 0xF8, 0x00, 0x1E, 0x00, 0x00, 0x00, ##         000000              0000                   
            0x01, 0xF8, 0x00, 0x1E, 0x00, 0x00, 0x00, ##         000000              0000                   
            0x01, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, ##         000000                                     
            0x01, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, ##         000000                                     
            0x01, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, ##         0000000                                    
            0x01, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, ##         0000000                                    
            0x00, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##          0000000                                   
            0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, ##          00000000                                  
            0x00, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, ##           0000000                                  
            0x00, 0x7F, 0x80, 0x00, 0x00, 0x00, 0x00, ##           00000000                                 
            0x00, 0x3F, 0xC0, 0x00, 0x00, 0x00, 0x00, ##            00000000                                
            0x00, 0x7F, 0xE0, 0x00, 0x00, 0x00, 0x00, ##           0000000000                               
            0x01, 0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, ##         0000000000000                              
            0x03, 0xF7, 0xF8, 0x00, 0x7F, 0xFF, 0x00, ##        000000 00000000            000000000000000  
            0x07, 0xE3, 0xFC, 0x00, 0x7F, 0xFF, 0x00, ##       000000   00000000           000000000000000  
            0x0F, 0xC1, 0xFE, 0x00, 0x7F, 0xFF, 0x00, ##      000000     00000000          000000000000000  
            0x1F, 0x80, 0xFF, 0x00, 0x01, 0xC0, 0x00, ##     000000       00000000               000        
            0x3F, 0x80, 0x7F, 0x80, 0x03, 0xC0, 0x00, ##    0000000        00000000             0000        
            0x3F, 0x00, 0x3F, 0x80, 0x03, 0xC0, 0x00, ##    000000          0000000             0000        
            0x7F, 0x00, 0x1F, 0xC0, 0x03, 0xC0, 0x00, ##   0000000           0000000            0000        
            0x7E, 0x00, 0x1F, 0xE0, 0x03, 0xC0, 0x00, ##   000000            00000000           0000        
            0xFE, 0x00, 0x0F, 0xF0, 0x07, 0x80, 0x00, ##  0000000             00000000         0000         
            0xFE, 0x00, 0x07, 0xF8, 0x07, 0x80, 0x00, ##  0000000              00000000        0000         
            0xFE, 0x00, 0x03, 0xFC, 0x07, 0x80, 0x00, ##  0000000               00000000       0000         
            0xFE, 0x00, 0x01, 0xFE, 0x0F, 0x00, 0x00, ##  0000000                00000000     0000          
            0xFE, 0x00, 0x00, 0xFF, 0x1F, 0x00, 0x00, ##  0000000                 00000000   00000          
            0xFE, 0x00, 0x00, 0x7F, 0x9E, 0x00, 0x00, ##  0000000                  00000000  0000           
            0xFE, 0x00, 0x00, 0x3F, 0xFC, 0x00, 0x00, ##  0000000                   000000000000            
            0xFF, 0x00, 0x00, 0x1F, 0xFC, 0x00, 0x00, ##  00000000                   00000000000            
            0x7F, 0x00, 0x00, 0x0F, 0xF8, 0x00, 0x00, ##   0000000                    000000000             
            0x7F, 0x80, 0x00, 0x07, 0xF0, 0x00, 0x00, ##   00000000                    0000000              
            0x7F, 0xC0, 0x00, 0x03, 0xF8, 0x00, 0x00, ##   000000000                    0000000             
            0x3F, 0xC0, 0x00, 0x03, 0xFC, 0x00, 0x00, ##    00000000                    00000000            
            0x3F, 0xF0, 0x00, 0x0F, 0xFE, 0x00, 0x00, ##    0000000000                00000000000           
            0x1F, 0xF8, 0x00, 0x3F, 0xFF, 0x00, 0x00, ##     0000000000             00000000000000          
            0x0F, 0xFF, 0x00, 0xFE, 0x7F, 0x80, 0x00, ##      000000000000        0000000  00000000         
            0x07, 0xFF, 0xFF, 0xFC, 0x3F, 0xFF, 0xC0, ##       0000000000000000000000000    0000000000000000
            0x01, 0xFF, 0xFF, 0xF0, 0x1F, 0xFF, 0xC0, ##         000000000000000000000       000000000000000
            0x00, 0x7F, 0xFF, 0xC0, 0x0F, 0xFF, 0xC0, ##           00000000000000000          00000000000000
            0x00, 0x0F, 0xFC, 0x00, 0x00, 0x00, 0x00, ##              0000000000                            
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '39' => {    # '''
        'width'    => 5, 
        'xoffset'  => 6, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '40' => {    # '('
        'width'    => 16, 
        'xoffset'  => 5, 
        'xadvance' => 25, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x03, ##                00
            0x00, 0x0F, ##              0000
            0x00, 0x3F, ##            000000
            0x00, 0x7C, ##           00000  
            0x00, 0xF8, ##          00000   
            0x01, 0xF0, ##         00000    
            0x03, 0xF0, ##        000000    
            0x03, 0xE0, ##        00000     
            0x07, 0xC0, ##       00000      
            0x0F, 0xC0, ##      000000      
            0x0F, 0x80, ##      00000       
            0x1F, 0x80, ##     000000       
            0x1F, 0x80, ##     000000       
            0x3F, 0x80, ##    0000000       
            0x3F, 0x00, ##    000000        
            0x3F, 0x00, ##    000000        
            0x7F, 0x00, ##   0000000        
            0x7F, 0x00, ##   0000000        
            0x7F, 0x00, ##   0000000        
            0x7E, 0x00, ##   000000         
            0x7E, 0x00, ##   000000         
            0xFE, 0x00, ##  0000000         
            0xFE, 0x00, ##  0000000         
            0xFE, 0x00, ##  0000000         
            0xFE, 0x00, ##  0000000         
            0xFE, 0x00, ##  0000000         
            0xFE, 0x00, ##  0000000         
            0xFE, 0x00, ##  0000000         
            0xFE, 0x00, ##  0000000         
            0xFE, 0x00, ##  0000000         
            0xFE, 0x00, ##  0000000         
            0xFE, 0x00, ##  0000000         
            0xFE, 0x00, ##  0000000         
            0xFE, 0x00, ##  0000000         
            0xFE, 0x00, ##  0000000         
            0xFE, 0x00, ##  0000000         
            0x7E, 0x00, ##   000000         
            0x7E, 0x00, ##   000000         
            0x7E, 0x00, ##   000000         
            0x7F, 0x00, ##   0000000        
            0x7F, 0x00, ##   0000000        
            0x3F, 0x00, ##    000000        
            0x3F, 0x00, ##    000000        
            0x3F, 0x00, ##    000000        
            0x1F, 0x80, ##     000000       
            0x1F, 0x80, ##     000000       
            0x0F, 0x80, ##      00000       
            0x0F, 0xC0, ##      000000      
            0x07, 0xC0, ##       00000      
            0x07, 0xE0, ##       000000     
            0x03, 0xE0, ##        00000     
            0x01, 0xF0, ##         00000    
            0x00, 0xF8, ##          00000   
            0x00, 0x7C, ##           00000  
            0x00, 0x3E, ##            00000 
            0x00, 0x1F, ##             00000
            0x00, 0x07, ##               000
            0x00, 0x01, ##                 0
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '41' => {    # ')'
        'width'    => 16, 
        'xoffset'  => 5, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xC0, 0x00, ##  00              
            0xF0, 0x00, ##  0000            
            0xF8, 0x00, ##  00000           
            0x7C, 0x00, ##   00000          
            0x3F, 0x00, ##    000000        
            0x1F, 0x80, ##     000000       
            0x0F, 0x80, ##      00000       
            0x07, 0xC0, ##       00000      
            0x07, 0xE0, ##       000000     
            0x03, 0xE0, ##        00000     
            0x03, 0xF0, ##        000000    
            0x01, 0xF8, ##         000000   
            0x01, 0xF8, ##         000000   
            0x01, 0xF8, ##         000000   
            0x00, 0xFC, ##          000000  
            0x00, 0xFC, ##          000000  
            0x00, 0xFC, ##          000000  
            0x00, 0xFE, ##          0000000 
            0x00, 0xFE, ##          0000000 
            0x00, 0xFE, ##          0000000 
            0x00, 0x7E, ##           000000 
            0x00, 0x7E, ##           000000 
            0x00, 0x7F, ##           0000000
            0x00, 0x7F, ##           0000000
            0x00, 0x7F, ##           0000000
            0x00, 0x7F, ##           0000000
            0x00, 0x7F, ##           0000000
            0x00, 0x7F, ##           0000000
            0x00, 0x7F, ##           0000000
            0x00, 0x7F, ##           0000000
            0x00, 0x7F, ##           0000000
            0x00, 0x7F, ##           0000000
            0x00, 0x7F, ##           0000000
            0x00, 0x7F, ##           0000000
            0x00, 0x7F, ##           0000000
            0x00, 0x7F, ##           0000000
            0x00, 0x7E, ##           000000 
            0x00, 0x7E, ##           000000 
            0x00, 0xFE, ##          0000000 
            0x00, 0xFE, ##          0000000 
            0x00, 0xFE, ##          0000000 
            0x00, 0xFC, ##          000000  
            0x00, 0xFC, ##          000000  
            0x01, 0xFC, ##         0000000  
            0x01, 0xF8, ##         000000   
            0x01, 0xF8, ##         000000   
            0x01, 0xF0, ##         00000    
            0x03, 0xF0, ##        000000    
            0x03, 0xE0, ##        00000     
            0x07, 0xE0, ##       000000     
            0x0F, 0xC0, ##      000000      
            0x0F, 0x80, ##      00000       
            0x1F, 0x00, ##     00000        
            0x3E, 0x00, ##    00000         
            0x7C, 0x00, ##   00000          
            0xF8, 0x00, ##  00000           
            0xE0, 0x00, ##  000             
            0x80, 0x00, ##  0               
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '42' => {    # '*'
        'width'    => 30, 
        'xoffset'  => 1, 
        'xadvance' => 32, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x07, 0x80, 0x00, ##               0000             
            0x00, 0x07, 0x80, 0x00, ##               0000             
            0x00, 0x07, 0x80, 0x00, ##               0000             
            0x00, 0x07, 0x80, 0x00, ##               0000             
            0x00, 0x07, 0x80, 0x00, ##               0000             
            0x20, 0x07, 0x80, 0x10, ##    0          0000          0  
            0x78, 0x07, 0x80, 0x78, ##   0000        0000        0000 
            0x7C, 0x07, 0x80, 0xF8, ##   00000       0000       00000 
            0xFF, 0x07, 0x83, 0xFC, ##  00000000     0000     00000000
            0x7F, 0x87, 0x87, 0xF8, ##   00000000    0000    00000000 
            0x0F, 0xE7, 0x9F, 0xC0, ##      0000000  0000  0000000    
            0x03, 0xF7, 0xBF, 0x00, ##        000000 0000 000000      
            0x00, 0xFF, 0xFC, 0x00, ##          00000000000000        
            0x00, 0x3F, 0xF0, 0x00, ##            0000000000          
            0x00, 0x0F, 0xC0, 0x00, ##              000000            
            0x00, 0x3F, 0xF0, 0x00, ##            0000000000          
            0x00, 0xFF, 0xFC, 0x00, ##          00000000000000        
            0x03, 0xF7, 0xBF, 0x00, ##        000000 0000 000000      
            0x0F, 0xE7, 0x9F, 0xC0, ##      0000000  0000  0000000    
            0x3F, 0x87, 0x87, 0xF8, ##    0000000    0000    00000000 
            0xFF, 0x07, 0x83, 0xFC, ##  00000000     0000     00000000
            0x7C, 0x07, 0x80, 0xF8, ##   00000       0000       00000 
            0x78, 0x07, 0x80, 0x78, ##   0000        0000        0000 
            0x20, 0x07, 0x80, 0x10, ##    0          0000          0  
            0x00, 0x07, 0x80, 0x00, ##               0000             
            0x00, 0x07, 0x80, 0x00, ##               0000             
            0x00, 0x07, 0x80, 0x00, ##               0000             
            0x00, 0x07, 0x80, 0x00, ##               0000             
            0x00, 0x07, 0x80, 0x00, ##               0000             
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '43' => {    # '+'
        'width'    => 40, 
        'xoffset'  => 7, 
        'xadvance' => 54, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '44' => {    # ','
        'width'    => 12, 
        'xoffset'  => 2, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x03, 0xF0, ##        000000
            0x03, 0xF0, ##        000000
            0x03, 0xF0, ##        000000
            0x03, 0xF0, ##        000000
            0x03, 0xF0, ##        000000
            0x03, 0xE0, ##        00000 
            0x07, 0xE0, ##       000000 
            0x07, 0xE0, ##       000000 
            0x0F, 0xC0, ##      000000  
            0x0F, 0x80, ##      00000   
            0x1F, 0x80, ##     000000   
            0x3F, 0x00, ##    000000    
            0x7E, 0x00, ##   000000     
            0x7C, 0x00, ##   00000      
            0x38, 0x00, ##    000       
            0x00, 0x00, ##              
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '45' => {    # '-'
        'width'    => 16, 
        'xoffset'  => 3, 
        'xadvance' => 22, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xFF, ##  0000000000000000
            0xFF, 0xFF, ##  0000000000000000
            0xFF, 0xFF, ##  0000000000000000
            0xFF, 0xFF, ##  0000000000000000
            0xFF, 0xFF, ##  0000000000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '46' => {    # '.'
        'width'    => 8, 
        'xoffset'  => 6, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x3C, ##    0000  
            0x7E, ##   000000 
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0x7E, ##   000000 
            0x3C, ##    0000  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '47' => {    # '/'
        'width'    => 22, 
        'xoffset'  => 0, 
        'xadvance' => 22, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x7C, ##                   00000
            0x00, 0x00, 0xF8, ##                  00000 
            0x00, 0x00, 0xF8, ##                  00000 
            0x00, 0x00, 0xF8, ##                  00000 
            0x00, 0x01, 0xF0, ##                 00000  
            0x00, 0x01, 0xF0, ##                 00000  
            0x00, 0x01, 0xF0, ##                 00000  
            0x00, 0x03, 0xE0, ##                00000   
            0x00, 0x03, 0xE0, ##                00000   
            0x00, 0x03, 0xE0, ##                00000   
            0x00, 0x07, 0xC0, ##               00000    
            0x00, 0x07, 0xC0, ##               00000    
            0x00, 0x07, 0xC0, ##               00000    
            0x00, 0x0F, 0x80, ##              00000     
            0x00, 0x0F, 0x80, ##              00000     
            0x00, 0x0F, 0x80, ##              00000     
            0x00, 0x1F, 0x80, ##             000000     
            0x00, 0x1F, 0x00, ##             00000      
            0x00, 0x1F, 0x00, ##             00000      
            0x00, 0x1F, 0x00, ##             00000      
            0x00, 0x3E, 0x00, ##            00000       
            0x00, 0x3E, 0x00, ##            00000       
            0x00, 0x3E, 0x00, ##            00000       
            0x00, 0x7C, 0x00, ##           00000        
            0x00, 0x7C, 0x00, ##           00000        
            0x00, 0x7C, 0x00, ##           00000        
            0x00, 0xF8, 0x00, ##          00000         
            0x00, 0xF8, 0x00, ##          00000         
            0x00, 0xF8, 0x00, ##          00000         
            0x01, 0xF0, 0x00, ##         00000          
            0x01, 0xF0, 0x00, ##         00000          
            0x01, 0xF0, 0x00, ##         00000          
            0x03, 0xE0, 0x00, ##        00000           
            0x03, 0xE0, 0x00, ##        00000           
            0x03, 0xE0, 0x00, ##        00000           
            0x03, 0xE0, 0x00, ##        00000           
            0x07, 0xC0, 0x00, ##       00000            
            0x07, 0xC0, 0x00, ##       00000            
            0x07, 0xC0, 0x00, ##       00000            
            0x0F, 0x80, 0x00, ##      00000             
            0x0F, 0x80, 0x00, ##      00000             
            0x0F, 0x80, 0x00, ##      00000             
            0x1F, 0x00, 0x00, ##     00000              
            0x1F, 0x00, 0x00, ##     00000              
            0x1F, 0x00, 0x00, ##     00000              
            0x3E, 0x00, 0x00, ##    00000               
            0x3E, 0x00, 0x00, ##    00000               
            0x3E, 0x00, 0x00, ##    00000               
            0x7C, 0x00, 0x00, ##   00000                
            0x7C, 0x00, 0x00, ##   00000                
            0x7C, 0x00, 0x00, ##   00000                
            0xF8, 0x00, 0x00, ##  00000                 
            0xF8, 0x00, 0x00, ##  00000                 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '48' => {    # '0'
        'width'    => 32, 
        'xoffset'  => 4, 
        'xadvance' => 40, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x0F, 0xF0, 0x00, ##              00000000            
            0x00, 0x7F, 0xFE, 0x00, ##           00000000000000         
            0x00, 0xFF, 0xFF, 0x00, ##          0000000000000000        
            0x01, 0xFC, 0x3F, 0x80, ##         0000000    0000000       
            0x03, 0xF0, 0x0F, 0xC0, ##        000000        000000      
            0x07, 0xE0, 0x07, 0xE0, ##       000000          000000     
            0x0F, 0xC0, 0x03, 0xF0, ##      000000            000000    
            0x1F, 0xC0, 0x03, 0xF0, ##     0000000            000000    
            0x1F, 0x80, 0x01, 0xF8, ##     000000              000000   
            0x3F, 0x80, 0x01, 0xF8, ##    0000000              000000   
            0x3F, 0x00, 0x00, 0xFC, ##    000000                000000  
            0x3F, 0x00, 0x00, 0xFC, ##    000000                000000  
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x7E, 0x00, 0x00, 0x7E, ##   000000                  000000 
            0x7E, 0x00, 0x00, 0x7E, ##   000000                  000000 
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0x7E, 0x00, 0x00, 0x7E, ##   000000                  000000 
            0x7E, 0x00, 0x00, 0x7E, ##   000000                  000000 
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x3F, 0x00, 0x00, 0xFC, ##    000000                000000  
            0x3F, 0x00, 0x00, 0xFC, ##    000000                000000  
            0x3F, 0x80, 0x01, 0xF8, ##    0000000              000000   
            0x1F, 0x80, 0x01, 0xF8, ##     000000              000000   
            0x1F, 0xC0, 0x03, 0xF8, ##     0000000            0000000   
            0x0F, 0xC0, 0x03, 0xF0, ##      000000            000000    
            0x07, 0xE0, 0x07, 0xE0, ##       000000          000000     
            0x03, 0xF0, 0x0F, 0xC0, ##        000000        000000      
            0x01, 0xF8, 0x1F, 0x80, ##         000000      000000       
            0x00, 0xFF, 0xFF, 0x00, ##          0000000000000000        
            0x00, 0x7F, 0xFE, 0x00, ##           00000000000000         
            0x00, 0x0F, 0xF0, 0x00, ##              00000000            
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '49' => {    # '1'
        'width'    => 24, 
        'xoffset'  => 8, 
        'xadvance' => 41, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x3F, 0x00, ##            000000        
            0x00, 0x7F, 0x00, ##           0000000        
            0x01, 0xFF, 0x00, ##         000000000        
            0x03, 0xFF, 0x00, ##        0000000000        
            0x0F, 0xFF, 0x00, ##      000000000000        
            0x3F, 0xFF, 0x00, ##    00000000000000        
            0x7E, 0x7F, 0x00, ##   000000  0000000        
            0xFC, 0x7F, 0x00, ##  000000   0000000        
            0xF0, 0x7F, 0x00, ##  0000     0000000        
            0xE0, 0x7F, 0x00, ##  000      0000000        
            0x80, 0x7F, 0x00, ##  0        0000000        
            0x00, 0x7F, 0x00, ##           0000000        
            0x00, 0x7F, 0x00, ##           0000000        
            0x00, 0x7F, 0x00, ##           0000000        
            0x00, 0x7F, 0x00, ##           0000000        
            0x00, 0x7F, 0x00, ##           0000000        
            0x00, 0x7F, 0x00, ##           0000000        
            0x00, 0x7F, 0x00, ##           0000000        
            0x00, 0x7F, 0x00, ##           0000000        
            0x00, 0x7F, 0x00, ##           0000000        
            0x00, 0x7F, 0x00, ##           0000000        
            0x00, 0x7F, 0x00, ##           0000000        
            0x00, 0x7F, 0x00, ##           0000000        
            0x00, 0x7F, 0x00, ##           0000000        
            0x00, 0x7F, 0x00, ##           0000000        
            0x00, 0x7F, 0x00, ##           0000000        
            0x00, 0x7F, 0x00, ##           0000000        
            0x00, 0x7F, 0x00, ##           0000000        
            0x00, 0x7F, 0x00, ##           0000000        
            0x00, 0x7F, 0x00, ##           0000000        
            0x00, 0x7F, 0x00, ##           0000000        
            0x00, 0x7F, 0x00, ##           0000000        
            0x00, 0x7F, 0x00, ##           0000000        
            0x00, 0x7F, 0x00, ##           0000000        
            0x00, 0x7F, 0x00, ##           0000000        
            0x00, 0x7F, 0x00, ##           0000000        
            0x00, 0x7F, 0x00, ##           0000000        
            0x00, 0x7F, 0x00, ##           0000000        
            0x00, 0x7F, 0x00, ##           0000000        
            0x00, 0x7F, 0x00, ##           0000000        
            0x00, 0x7F, 0x00, ##           0000000        
            0x00, 0x7F, 0x00, ##           0000000        
            0x00, 0x7F, 0x00, ##           0000000        
            0x00, 0x7F, 0x00, ##           0000000        
            0x7F, 0xFF, 0xFF, ##   00000000000000000000000
            0x7F, 0xFF, 0xFF, ##   00000000000000000000000
            0x7F, 0xFF, 0xFF, ##   00000000000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '50' => {    # '2'
        'width'    => 30, 
        'xoffset'  => 4, 
        'xadvance' => 40, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x7F, 0xE0, 0x00, ##           0000000000           
            0x07, 0xFF, 0xFC, 0x00, ##       00000000000000000        
            0x1F, 0xFF, 0xFF, 0x00, ##     000000000000000000000      
            0xFF, 0xC0, 0x7F, 0xC0, ##  0000000000       000000000    
            0xFF, 0x00, 0x1F, 0xE0, ##  00000000           00000000   
            0xFC, 0x00, 0x0F, 0xF0, ##  000000              00000000  
            0xFC, 0x00, 0x07, 0xF0, ##  000000               0000000  
            0xF8, 0x00, 0x03, 0xF8, ##  00000                 0000000 
            0xF8, 0x00, 0x03, 0xF8, ##  00000                 0000000 
            0xF0, 0x00, 0x01, 0xFC, ##  0000                   0000000
            0xF0, 0x00, 0x01, 0xFC, ##  0000                   0000000
            0xF0, 0x00, 0x01, 0xFC, ##  0000                   0000000
            0x00, 0x00, 0x01, 0xFC, ##                         0000000
            0x00, 0x00, 0x01, 0xFC, ##                         0000000
            0x00, 0x00, 0x01, 0xFC, ##                         0000000
            0x00, 0x00, 0x01, 0xFC, ##                         0000000
            0x00, 0x00, 0x01, 0xF8, ##                         000000 
            0x00, 0x00, 0x03, 0xF8, ##                        0000000 
            0x00, 0x00, 0x03, 0xF8, ##                        0000000 
            0x00, 0x00, 0x03, 0xF0, ##                        000000  
            0x00, 0x00, 0x07, 0xF0, ##                       0000000  
            0x00, 0x00, 0x07, 0xE0, ##                       000000   
            0x00, 0x00, 0x0F, 0xC0, ##                      000000    
            0x00, 0x00, 0x0F, 0x80, ##                      00000     
            0x00, 0x00, 0x1F, 0x80, ##                     000000     
            0x00, 0x00, 0x3F, 0x00, ##                    000000      
            0x00, 0x00, 0x7E, 0x00, ##                   000000       
            0x00, 0x00, 0xFC, 0x00, ##                  000000        
            0x00, 0x01, 0xF8, 0x00, ##                 000000         
            0x00, 0x03, 0xF0, 0x00, ##                000000          
            0x00, 0x07, 0xE0, 0x00, ##               000000           
            0x00, 0x0F, 0xC0, 0x00, ##              000000            
            0x00, 0x1F, 0x80, 0x00, ##             000000             
            0x00, 0x3F, 0x00, 0x00, ##            000000              
            0x00, 0x7E, 0x00, 0x00, ##           000000               
            0x00, 0xFC, 0x00, 0x00, ##          000000                
            0x01, 0xF8, 0x00, 0x3C, ##         000000             0000
            0x03, 0xF0, 0x00, 0x3C, ##        000000              0000
            0x07, 0xE0, 0x00, 0x3C, ##       000000               0000
            0x0F, 0xC0, 0x00, 0x3C, ##      000000                0000
            0x1F, 0x80, 0x00, 0x3C, ##     000000                 0000
            0x3F, 0x00, 0x00, 0x3C, ##    000000                  0000
            0x7F, 0xFF, 0xFF, 0xFC, ##   00000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '51' => {    # '3'
        'width'    => 31, 
        'xoffset'  => 5, 
        'xadvance' => 41, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x3F, 0xF0, 0x00, ##            0000000000           
            0x07, 0xFF, 0xFE, 0x00, ##       000000000000000000        
            0x3F, 0xFF, 0xFF, 0x80, ##    00000000000000000000000      
            0x7F, 0xE0, 0x3F, 0xE0, ##   0000000000       000000000    
            0x7F, 0x80, 0x0F, 0xF0, ##   00000000           00000000   
            0x7E, 0x00, 0x07, 0xF0, ##   000000              0000000   
            0x7E, 0x00, 0x03, 0xF8, ##   000000               0000000  
            0x7C, 0x00, 0x03, 0xF8, ##   00000                0000000  
            0x7C, 0x00, 0x01, 0xFC, ##   00000                 0000000 
            0x78, 0x00, 0x01, 0xFC, ##   0000                  0000000 
            0x78, 0x00, 0x01, 0xFC, ##   0000                  0000000 
            0x00, 0x00, 0x01, 0xFC, ##                         0000000 
            0x00, 0x00, 0x01, 0xFC, ##                         0000000 
            0x00, 0x00, 0x01, 0xFC, ##                         0000000 
            0x00, 0x00, 0x01, 0xFC, ##                         0000000 
            0x00, 0x00, 0x03, 0xF8, ##                        0000000  
            0x00, 0x00, 0x03, 0xF8, ##                        0000000  
            0x00, 0x00, 0x07, 0xF0, ##                       0000000   
            0x00, 0x00, 0x0F, 0xE0, ##                      0000000    
            0x00, 0x00, 0x1F, 0xC0, ##                     0000000     
            0x00, 0x00, 0xFF, 0x00, ##                  00000000       
            0x00, 0x1F, 0xFC, 0x00, ##             00000000000         
            0x00, 0x1F, 0xF0, 0x00, ##             000000000           
            0x00, 0x1F, 0xFF, 0x00, ##             0000000000000       
            0x00, 0x00, 0x7F, 0xC0, ##                   000000000     
            0x00, 0x00, 0x0F, 0xE0, ##                      0000000    
            0x00, 0x00, 0x07, 0xF0, ##                       0000000   
            0x00, 0x00, 0x03, 0xF8, ##                        0000000  
            0x00, 0x00, 0x01, 0xF8, ##                         000000  
            0x00, 0x00, 0x01, 0xFC, ##                         0000000 
            0x00, 0x00, 0x01, 0xFC, ##                         0000000 
            0x00, 0x00, 0x00, 0xFE, ##                          0000000
            0x00, 0x00, 0x00, 0xFE, ##                          0000000
            0x00, 0x00, 0x00, 0xFE, ##                          0000000
            0x00, 0x00, 0x00, 0xFE, ##                          0000000
            0x00, 0x00, 0x00, 0xFE, ##                          0000000
            0xF0, 0x00, 0x00, 0xFE, ##  0000                    0000000
            0xF0, 0x00, 0x00, 0xFE, ##  0000                    0000000
            0xF0, 0x00, 0x01, 0xFE, ##  0000                   00000000
            0xF0, 0x00, 0x01, 0xFC, ##  0000                   0000000 
            0xF8, 0x00, 0x01, 0xFC, ##  00000                  0000000 
            0xF8, 0x00, 0x03, 0xF8, ##  00000                 0000000  
            0xFC, 0x00, 0x07, 0xF8, ##  000000               00000000  
            0xFF, 0x00, 0x0F, 0xF0, ##  00000000            00000000   
            0xFF, 0xC0, 0x3F, 0xE0, ##  0000000000        000000000    
            0x7F, 0xFF, 0xFF, 0x80, ##   000000000000000000000000      
            0x0F, 0xFF, 0xFE, 0x00, ##      0000000000000000000        
            0x00, 0xFF, 0xF0, 0x00, ##          000000000000           
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '52' => {    # '4'
        'width'    => 36, 
        'xoffset'  => 2, 
        'xadvance' => 41, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x07, 0xE0, 0x00, ##                       000000         
            0x00, 0x00, 0x0F, 0xE0, 0x00, ##                      0000000         
            0x00, 0x00, 0x1F, 0xE0, 0x00, ##                     00000000         
            0x00, 0x00, 0x1F, 0xE0, 0x00, ##                     00000000         
            0x00, 0x00, 0x3F, 0xE0, 0x00, ##                    000000000         
            0x00, 0x00, 0x7F, 0xE0, 0x00, ##                   0000000000         
            0x00, 0x00, 0x7F, 0xE0, 0x00, ##                   0000000000         
            0x00, 0x00, 0xFF, 0xE0, 0x00, ##                  00000000000         
            0x00, 0x01, 0xF7, 0xE0, 0x00, ##                 00000 000000         
            0x00, 0x01, 0xE7, 0xE0, 0x00, ##                 0000  000000         
            0x00, 0x03, 0xE7, 0xE0, 0x00, ##                00000  000000         
            0x00, 0x07, 0xC7, 0xE0, 0x00, ##               00000   000000         
            0x00, 0x07, 0x87, 0xE0, 0x00, ##               0000    000000         
            0x00, 0x0F, 0x87, 0xE0, 0x00, ##              00000    000000         
            0x00, 0x1F, 0x07, 0xE0, 0x00, ##             00000     000000         
            0x00, 0x1E, 0x07, 0xE0, 0x00, ##             0000      000000         
            0x00, 0x3E, 0x07, 0xE0, 0x00, ##            00000      000000         
            0x00, 0x7C, 0x07, 0xE0, 0x00, ##           00000       000000         
            0x00, 0x78, 0x07, 0xE0, 0x00, ##           0000        000000         
            0x00, 0xF8, 0x07, 0xE0, 0x00, ##          00000        000000         
            0x00, 0xF0, 0x07, 0xE0, 0x00, ##          0000         000000         
            0x01, 0xE0, 0x07, 0xE0, 0x00, ##         0000          000000         
            0x03, 0xE0, 0x07, 0xE0, 0x00, ##        00000          000000         
            0x03, 0xC0, 0x07, 0xE0, 0x00, ##        0000           000000         
            0x07, 0x80, 0x07, 0xE0, 0x00, ##       0000            000000         
            0x0F, 0x80, 0x07, 0xE0, 0x00, ##      00000            000000         
            0x0F, 0x00, 0x07, 0xE0, 0x00, ##      0000             000000         
            0x1E, 0x00, 0x07, 0xE0, 0x00, ##     0000              000000         
            0x3E, 0x00, 0x07, 0xE0, 0x00, ##    00000              000000         
            0x3C, 0x00, 0x07, 0xE0, 0x00, ##    0000               000000         
            0x78, 0x00, 0x07, 0xE0, 0x00, ##   0000                000000         
            0xF8, 0x00, 0x07, 0xE0, 0x00, ##  00000                000000         
            0xFF, 0xFF, 0xFF, 0xFF, 0xF0, ##  000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xF0, ##  000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xF0, ##  000000000000000000000000000000000000
            0x00, 0x00, 0x07, 0xE0, 0x00, ##                       000000         
            0x00, 0x00, 0x07, 0xE0, 0x00, ##                       000000         
            0x00, 0x00, 0x07, 0xE0, 0x00, ##                       000000         
            0x00, 0x00, 0x07, 0xE0, 0x00, ##                       000000         
            0x00, 0x00, 0x07, 0xE0, 0x00, ##                       000000         
            0x00, 0x00, 0x07, 0xE0, 0x00, ##                       000000         
            0x00, 0x00, 0x07, 0xE0, 0x00, ##                       000000         
            0x00, 0x00, 0x07, 0xE0, 0x00, ##                       000000         
            0x00, 0x00, 0x07, 0xE0, 0x00, ##                       000000         
            0x00, 0x07, 0xFF, 0xFF, 0xC0, ##               000000000000000000000  
            0x00, 0x07, 0xFF, 0xFF, 0xC0, ##               000000000000000000000  
            0x00, 0x07, 0xFF, 0xFF, 0xC0, ##               000000000000000000000  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '53' => {    # '5'
        'width'    => 31, 
        'xoffset'  => 5, 
        'xadvance' => 41, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x3F, 0xFF, 0xFF, 0xE0, ##    0000000000000000000000000    
            0x3F, 0xFF, 0xFF, 0xE0, ##    0000000000000000000000000    
            0x3F, 0xFF, 0xFF, 0xE0, ##    0000000000000000000000000    
            0x3F, 0xFF, 0xFF, 0xE0, ##    0000000000000000000000000    
            0x3F, 0xFF, 0xFF, 0xE0, ##    0000000000000000000000000    
            0x38, 0x00, 0x00, 0x00, ##    000                          
            0x38, 0x00, 0x00, 0x00, ##    000                          
            0x38, 0x00, 0x00, 0x00, ##    000                          
            0x38, 0x00, 0x00, 0x00, ##    000                          
            0x38, 0x00, 0x00, 0x00, ##    000                          
            0x38, 0x00, 0x00, 0x00, ##    000                          
            0x38, 0x00, 0x00, 0x00, ##    000                          
            0x38, 0x00, 0x00, 0x00, ##    000                          
            0x38, 0x00, 0x00, 0x00, ##    000                          
            0x38, 0x00, 0x00, 0x00, ##    000                          
            0x38, 0x00, 0x00, 0x00, ##    000                          
            0x38, 0x7F, 0xE0, 0x00, ##    000    0000000000            
            0x3B, 0xFF, 0xFC, 0x00, ##    000 0000000000000000         
            0x3F, 0xFF, 0xFF, 0x00, ##    0000000000000000000000       
            0x3F, 0xC0, 0x7F, 0xC0, ##    00000000       000000000     
            0x3F, 0x00, 0x1F, 0xE0, ##    000000           00000000    
            0x3C, 0x00, 0x07, 0xF0, ##    0000               0000000   
            0x38, 0x00, 0x03, 0xF0, ##    000                 000000   
            0x00, 0x00, 0x03, 0xF8, ##                        0000000  
            0x00, 0x00, 0x01, 0xFC, ##                         0000000 
            0x00, 0x00, 0x01, 0xFC, ##                         0000000 
            0x00, 0x00, 0x01, 0xFC, ##                         0000000 
            0x00, 0x00, 0x00, 0xFE, ##                          0000000
            0x00, 0x00, 0x00, 0xFE, ##                          0000000
            0x00, 0x00, 0x00, 0xFE, ##                          0000000
            0x00, 0x00, 0x00, 0xFE, ##                          0000000
            0x00, 0x00, 0x00, 0xFE, ##                          0000000
            0x00, 0x00, 0x00, 0xFE, ##                          0000000
            0x00, 0x00, 0x00, 0xFE, ##                          0000000
            0x00, 0x00, 0x00, 0xFE, ##                          0000000
            0xF0, 0x00, 0x00, 0xFE, ##  0000                    0000000
            0xF0, 0x00, 0x01, 0xFC, ##  0000                   0000000 
            0xF0, 0x00, 0x01, 0xFC, ##  0000                   0000000 
            0xF8, 0x00, 0x01, 0xFC, ##  00000                  0000000 
            0xF8, 0x00, 0x03, 0xF8, ##  00000                 0000000  
            0xF8, 0x00, 0x03, 0xF8, ##  00000                 0000000  
            0xFC, 0x00, 0x07, 0xF0, ##  000000               0000000   
            0xFF, 0x00, 0x1F, 0xE0, ##  00000000           00000000    
            0xFF, 0xC0, 0x7F, 0xC0, ##  0000000000       000000000     
            0x7F, 0xFF, 0xFF, 0x00, ##   00000000000000000000000       
            0x0F, 0xFF, 0xFC, 0x00, ##      000000000000000000         
            0x00, 0xFF, 0xE0, 0x00, ##          00000000000            
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '54' => {    # '6'
        'width'    => 33, 
        'xoffset'  => 4, 
        'xadvance' => 41, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x01, 0xFF, 0x80, 0x00, ##                 0000000000        
            0x00, 0x0F, 0xFF, 0xF8, 0x00, ##              00000000000000000    
            0x00, 0x3F, 0xFF, 0xFC, 0x00, ##            00000000000000000000   
            0x00, 0xFE, 0x03, 0xFC, 0x00, ##          0000000       00000000   
            0x01, 0xF0, 0x00, 0xFC, 0x00, ##         00000            000000   
            0x03, 0xE0, 0x00, 0x7C, 0x00, ##        00000              00000   
            0x07, 0xC0, 0x00, 0x3C, 0x00, ##       00000                0000   
            0x0F, 0x80, 0x00, 0x3C, 0x00, ##      00000                 0000   
            0x0F, 0x80, 0x00, 0x3C, 0x00, ##      00000                 0000   
            0x1F, 0x00, 0x00, 0x00, 0x00, ##     00000                         
            0x1F, 0x00, 0x00, 0x00, 0x00, ##     00000                         
            0x3E, 0x00, 0x00, 0x00, 0x00, ##    00000                          
            0x3E, 0x00, 0x00, 0x00, 0x00, ##    00000                          
            0x3E, 0x00, 0x00, 0x00, 0x00, ##    00000                          
            0x7E, 0x00, 0x00, 0x00, 0x00, ##   000000                          
            0x7C, 0x00, 0x00, 0x00, 0x00, ##   00000                           
            0x7C, 0x00, 0x00, 0x00, 0x00, ##   00000                           
            0x7C, 0x07, 0xFC, 0x00, 0x00, ##   00000       000000000           
            0xFC, 0x3F, 0xFF, 0x80, 0x00, ##  000000    000000000000000        
            0xFC, 0xFF, 0xFF, 0xE0, 0x00, ##  000000  0000000000000000000      
            0xFD, 0xF8, 0x0F, 0xF0, 0x00, ##  000000 000000       00000000     
            0xFF, 0xE0, 0x03, 0xF8, 0x00, ##  00000000000           0000000    
            0xFF, 0xC0, 0x01, 0xFC, 0x00, ##  0000000000             0000000   
            0xFF, 0x80, 0x00, 0xFE, 0x00, ##  000000000               0000000  
            0xFF, 0x80, 0x00, 0xFE, 0x00, ##  000000000               0000000  
            0xFF, 0x00, 0x00, 0x7F, 0x00, ##  00000000                 0000000 
            0xFF, 0x00, 0x00, 0x7F, 0x00, ##  00000000                 0000000 
            0xFE, 0x00, 0x00, 0x7F, 0x00, ##  0000000                  0000000 
            0xFE, 0x00, 0x00, 0x3F, 0x80, ##  0000000                   0000000
            0xFE, 0x00, 0x00, 0x3F, 0x80, ##  0000000                   0000000
            0xFE, 0x00, 0x00, 0x3F, 0x80, ##  0000000                   0000000
            0xFE, 0x00, 0x00, 0x3F, 0x80, ##  0000000                   0000000
            0x7E, 0x00, 0x00, 0x3F, 0x80, ##   000000                   0000000
            0x7E, 0x00, 0x00, 0x3F, 0x80, ##   000000                   0000000
            0x7E, 0x00, 0x00, 0x3F, 0x80, ##   000000                   0000000
            0x7E, 0x00, 0x00, 0x3F, 0x80, ##   000000                   0000000
            0x7E, 0x00, 0x00, 0x3F, 0x80, ##   000000                   0000000
            0x3F, 0x00, 0x00, 0x7F, 0x00, ##    000000                 0000000 
            0x3F, 0x00, 0x00, 0x7F, 0x00, ##    000000                 0000000 
            0x1F, 0x00, 0x00, 0x7F, 0x00, ##     00000                 0000000 
            0x1F, 0x80, 0x00, 0xFE, 0x00, ##     000000               0000000  
            0x0F, 0x80, 0x00, 0xFE, 0x00, ##      00000               0000000  
            0x07, 0xC0, 0x01, 0xFC, 0x00, ##       00000             0000000   
            0x07, 0xE0, 0x03, 0xF8, 0x00, ##       000000           0000000    
            0x03, 0xF8, 0x0F, 0xF0, 0x00, ##        0000000       00000000     
            0x00, 0xFF, 0xFF, 0xC0, 0x00, ##          000000000000000000       
            0x00, 0x7F, 0xFF, 0x80, 0x00, ##           0000000000000000        
            0x00, 0x0F, 0xF8, 0x00, 0x00, ##              000000000            
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '55' => {    # '7'
        'width'    => 31, 
        'xoffset'  => 5, 
        'xadvance' => 40, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFF, 0xFE, ##  0000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFE, ##  0000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFE, ##  0000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000 
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000 
            0xF0, 0x00, 0x00, 0x7C, ##  0000                     00000 
            0xF0, 0x00, 0x00, 0xF8, ##  0000                    00000  
            0xF0, 0x00, 0x00, 0xF8, ##  0000                    00000  
            0xF0, 0x00, 0x00, 0xF0, ##  0000                    0000   
            0xF0, 0x00, 0x01, 0xF0, ##  0000                   00000   
            0xF0, 0x00, 0x01, 0xE0, ##  0000                   0000    
            0x00, 0x00, 0x03, 0xE0, ##                        00000    
            0x00, 0x00, 0x03, 0xE0, ##                        00000    
            0x00, 0x00, 0x03, 0xC0, ##                        0000     
            0x00, 0x00, 0x07, 0xC0, ##                       00000     
            0x00, 0x00, 0x07, 0x80, ##                       0000      
            0x00, 0x00, 0x0F, 0x80, ##                      00000      
            0x00, 0x00, 0x0F, 0x80, ##                      00000      
            0x00, 0x00, 0x0F, 0x00, ##                      0000       
            0x00, 0x00, 0x1F, 0x00, ##                     00000       
            0x00, 0x00, 0x1E, 0x00, ##                     0000        
            0x00, 0x00, 0x3E, 0x00, ##                    00000        
            0x00, 0x00, 0x3E, 0x00, ##                    00000        
            0x00, 0x00, 0x7C, 0x00, ##                   00000         
            0x00, 0x00, 0x7C, 0x00, ##                   00000         
            0x00, 0x00, 0x78, 0x00, ##                   0000          
            0x00, 0x00, 0xF8, 0x00, ##                  00000          
            0x00, 0x00, 0xF0, 0x00, ##                  0000           
            0x00, 0x01, 0xF0, 0x00, ##                 00000           
            0x00, 0x01, 0xF0, 0x00, ##                 00000           
            0x00, 0x01, 0xE0, 0x00, ##                 0000            
            0x00, 0x03, 0xE0, 0x00, ##                00000            
            0x00, 0x03, 0xC0, 0x00, ##                0000             
            0x00, 0x07, 0xC0, 0x00, ##               00000             
            0x00, 0x07, 0xC0, 0x00, ##               00000             
            0x00, 0x07, 0x80, 0x00, ##               0000              
            0x00, 0x0F, 0x80, 0x00, ##              00000              
            0x00, 0x0F, 0x00, 0x00, ##              0000               
            0x00, 0x1F, 0x00, 0x00, ##             00000               
            0x00, 0x1F, 0x00, 0x00, ##             00000               
            0x00, 0x1E, 0x00, 0x00, ##             0000                
            0x00, 0x3E, 0x00, 0x00, ##            00000                
            0x00, 0x3C, 0x00, 0x00, ##            0000                 
            0x00, 0x7C, 0x00, 0x00, ##           00000                 
            0x00, 0x78, 0x00, 0x00, ##           0000                  
            0x00, 0xF8, 0x00, 0x00, ##          00000                  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '56' => {    # '8'
        'width'    => 32, 
        'xoffset'  => 4, 
        'xadvance' => 40, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x1F, 0xF8, 0x00, ##             0000000000           
            0x00, 0xFF, 0xFF, 0x00, ##          0000000000000000        
            0x03, 0xFF, 0xFF, 0xC0, ##        00000000000000000000      
            0x07, 0xF8, 0x1F, 0xE0, ##       00000000      00000000     
            0x0F, 0xE0, 0x07, 0xF0, ##      0000000          0000000    
            0x1F, 0xC0, 0x03, 0xF8, ##     0000000            0000000   
            0x3F, 0x80, 0x01, 0xFC, ##    0000000              0000000  
            0x3F, 0x80, 0x01, 0xFC, ##    0000000              0000000  
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x3F, 0x00, 0x00, 0xFC, ##    000000                000000  
            0x3F, 0x80, 0x01, 0xFC, ##    0000000              0000000  
            0x3F, 0x80, 0x01, 0xFC, ##    0000000              0000000  
            0x1F, 0xC0, 0x03, 0xF8, ##     0000000            0000000   
            0x0F, 0xE0, 0x07, 0xF0, ##      0000000          0000000    
            0x03, 0xF8, 0x1F, 0xE0, ##        0000000      00000000     
            0x00, 0xFF, 0xFF, 0x80, ##          00000000000000000       
            0x00, 0x1F, 0xF8, 0x00, ##             0000000000           
            0x01, 0xFF, 0xFF, 0x80, ##         000000000000000000       
            0x07, 0xF8, 0x1F, 0xE0, ##       00000000      00000000     
            0x0F, 0xE0, 0x07, 0xF0, ##      0000000          0000000    
            0x1F, 0xC0, 0x03, 0xF8, ##     0000000            0000000   
            0x3F, 0x80, 0x01, 0xFC, ##    0000000              0000000  
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x7E, 0x00, 0x00, 0x7E, ##   000000                  000000 
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x3F, 0x80, 0x01, 0xFC, ##    0000000              0000000  
            0x3F, 0xC0, 0x03, 0xFC, ##    00000000            00000000  
            0x1F, 0xE0, 0x07, 0xF8, ##     00000000          00000000   
            0x0F, 0xF8, 0x1F, 0xF0, ##      000000000      000000000    
            0x07, 0xFF, 0xFF, 0xC0, ##       000000000000000000000      
            0x01, 0xFF, 0xFF, 0x80, ##         000000000000000000       
            0x00, 0x1F, 0xF8, 0x00, ##             0000000000           
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '57' => {    # '9'
        'width'    => 33, 
        'xoffset'  => 4, 
        'xadvance' => 41, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x0F, 0xF8, 0x00, 0x00, ##              000000000            
            0x00, 0x7F, 0xFE, 0x00, 0x00, ##           00000000000000          
            0x01, 0xFF, 0xFF, 0x80, 0x00, ##         000000000000000000        
            0x07, 0xF8, 0x1F, 0xE0, 0x00, ##       00000000      00000000      
            0x0F, 0xE0, 0x07, 0xF0, 0x00, ##      0000000          0000000     
            0x1F, 0xC0, 0x03, 0xF0, 0x00, ##     0000000            000000     
            0x3F, 0x80, 0x01, 0xF8, 0x00, ##    0000000              000000    
            0x3F, 0x80, 0x01, 0xFC, 0x00, ##    0000000              0000000   
            0x7F, 0x00, 0x00, 0xFC, 0x00, ##   0000000                000000   
            0x7F, 0x00, 0x00, 0xFE, 0x00, ##   0000000                0000000  
            0x7E, 0x00, 0x00, 0xFE, 0x00, ##   000000                 0000000  
            0xFE, 0x00, 0x00, 0x7E, 0x00, ##  0000000                  000000  
            0xFE, 0x00, 0x00, 0x7F, 0x00, ##  0000000                  0000000 
            0xFE, 0x00, 0x00, 0x7F, 0x00, ##  0000000                  0000000 
            0xFE, 0x00, 0x00, 0x7F, 0x00, ##  0000000                  0000000 
            0xFE, 0x00, 0x00, 0x7F, 0x00, ##  0000000                  0000000 
            0xFE, 0x00, 0x00, 0x7F, 0x80, ##  0000000                  00000000
            0xFE, 0x00, 0x00, 0x7F, 0x80, ##  0000000                  00000000
            0xFE, 0x00, 0x00, 0x7F, 0x80, ##  0000000                  00000000
            0xFE, 0x00, 0x00, 0x7F, 0x80, ##  0000000                  00000000
            0x7E, 0x00, 0x00, 0x7F, 0x80, ##   000000                  00000000
            0x7F, 0x00, 0x00, 0xFF, 0x80, ##   0000000                000000000
            0x7F, 0x00, 0x00, 0xFF, 0x80, ##   0000000                000000000
            0x3F, 0x80, 0x00, 0xFF, 0x80, ##    0000000               000000000
            0x3F, 0x80, 0x01, 0xFF, 0x80, ##    0000000              0000000000
            0x1F, 0xC0, 0x03, 0xFF, 0x80, ##     0000000            00000000000
            0x0F, 0xE0, 0x07, 0xFF, 0x80, ##      0000000          000000000000
            0x07, 0xF8, 0x1F, 0xBF, 0x80, ##       00000000      000000 0000000
            0x03, 0xFF, 0xFF, 0x3F, 0x80, ##        000000000000000000  0000000
            0x00, 0xFF, 0xFC, 0x3F, 0x80, ##          00000000000000    0000000
            0x00, 0x3F, 0xE0, 0x3F, 0x00, ##            000000000       000000 
            0x00, 0x00, 0x00, 0x3F, 0x00, ##                            000000 
            0x00, 0x00, 0x00, 0x3F, 0x00, ##                            000000 
            0x00, 0x00, 0x00, 0x7F, 0x00, ##                           0000000 
            0x00, 0x00, 0x00, 0x7E, 0x00, ##                           000000  
            0x00, 0x00, 0x00, 0x7E, 0x00, ##                           000000  
            0x00, 0x00, 0x00, 0x7E, 0x00, ##                           000000  
            0x00, 0x00, 0x00, 0xFC, 0x00, ##                          000000   
            0x1C, 0x00, 0x00, 0xFC, 0x00, ##     000                  000000   
            0x1C, 0x00, 0x00, 0xF8, 0x00, ##     000                  00000    
            0x1E, 0x00, 0x01, 0xF0, 0x00, ##     0000                00000     
            0x1E, 0x00, 0x03, 0xF0, 0x00, ##     0000               000000     
            0x1F, 0x00, 0x07, 0xE0, 0x00, ##     00000             000000      
            0x1F, 0x80, 0x0F, 0xC0, 0x00, ##     000000           000000       
            0x1F, 0xE0, 0x3F, 0x80, 0x00, ##     00000000       0000000        
            0x1F, 0xFF, 0xFE, 0x00, 0x00, ##     00000000000000000000          
            0x0F, 0xFF, 0xF8, 0x00, 0x00, ##      00000000000000000            
            0x00, 0xFF, 0xC0, 0x00, 0x00, ##          0000000000               
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '58' => {    # ':'
        'width'    => 8, 
        'xoffset'  => 7, 
        'xadvance' => 22, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x3C, ##    0000  
            0x7E, ##   000000 
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0x7E, ##   000000 
            0x3C, ##    0000  
            0x00, ##          
            0x00, ##          
            0x00, ##          
            0x00, ##          
            0x00, ##          
            0x00, ##          
            0x00, ##          
            0x00, ##          
            0x00, ##          
            0x00, ##          
            0x00, ##          
            0x00, ##          
            0x3C, ##    0000  
            0x7E, ##   000000 
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0x7E, ##   000000 
            0x3C, ##    0000  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '59' => {    # ';'
        'width'    => 12, 
        'xoffset'  => 3, 
        'xadvance' => 21, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x03, 0xC0, ##        0000  
            0x07, 0xE0, ##       000000 
            0x0F, 0xF0, ##      00000000
            0x0F, 0xF0, ##      00000000
            0x0F, 0xF0, ##      00000000
            0x0F, 0xF0, ##      00000000
            0x07, 0xE0, ##       000000 
            0x03, 0xC0, ##        0000  
            0x00, 0x00, ##              
            0x00, 0x00, ##              
            0x00, 0x00, ##              
            0x00, 0x00, ##              
            0x00, 0x00, ##              
            0x00, 0x00, ##              
            0x00, 0x00, ##              
            0x00, 0x00, ##              
            0x00, 0x00, ##              
            0x00, 0x00, ##              
            0x00, 0x00, ##              
            0x00, 0x00, ##              
            0x07, 0xE0, ##       000000 
            0x07, 0xE0, ##       000000 
            0x07, 0xE0, ##       000000 
            0x07, 0xE0, ##       000000 
            0x07, 0xE0, ##       000000 
            0x07, 0xC0, ##       00000  
            0x0F, 0xC0, ##      000000  
            0x0F, 0xC0, ##      000000  
            0x0F, 0x80, ##      00000   
            0x1F, 0x80, ##     000000   
            0x1F, 0x00, ##     00000    
            0x3F, 0x00, ##    000000    
            0x7E, 0x00, ##   000000     
            0xFC, 0x00, ##  000000      
            0xF8, 0x00, ##  00000       
            0x60, 0x00, ##   00         
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '60' => {    # '<'
        'width'    => 40, 
        'xoffset'  => 7, 
        'xadvance' => 54, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x03, ##                                        00
            0x00, 0x00, 0x00, 0x00, 0x0F, ##                                      0000
            0x00, 0x00, 0x00, 0x00, 0x7F, ##                                   0000000
            0x00, 0x00, 0x00, 0x03, 0xFF, ##                                0000000000
            0x00, 0x00, 0x00, 0x1F, 0xFF, ##                             0000000000000
            0x00, 0x00, 0x00, 0x7F, 0xFE, ##                           00000000000000 
            0x00, 0x00, 0x03, 0xFF, 0xF8, ##                        000000000000000   
            0x00, 0x00, 0x1F, 0xFF, 0xC0, ##                     000000000000000      
            0x00, 0x00, 0xFF, 0xFE, 0x00, ##                  000000000000000         
            0x00, 0x03, 0xFF, 0xF0, 0x00, ##                00000000000000            
            0x00, 0x1F, 0xFF, 0xC0, 0x00, ##             000000000000000              
            0x00, 0xFF, 0xFE, 0x00, 0x00, ##          000000000000000                 
            0x07, 0xFF, 0xF0, 0x00, 0x00, ##       000000000000000                    
            0x1F, 0xFF, 0x80, 0x00, 0x00, ##     00000000000000                       
            0xFF, 0xFE, 0x00, 0x00, 0x00, ##  000000000000000                         
            0xFF, 0xF0, 0x00, 0x00, 0x00, ##  000000000000                            
            0xFF, 0x80, 0x00, 0x00, 0x00, ##  000000000                               
            0xFF, 0x80, 0x00, 0x00, 0x00, ##  000000000                               
            0xFF, 0xF0, 0x00, 0x00, 0x00, ##  000000000000                            
            0xFF, 0xFC, 0x00, 0x00, 0x00, ##  00000000000000                          
            0x1F, 0xFF, 0x80, 0x00, 0x00, ##     00000000000000                       
            0x07, 0xFF, 0xF0, 0x00, 0x00, ##       000000000000000                    
            0x00, 0xFF, 0xFE, 0x00, 0x00, ##          000000000000000                 
            0x00, 0x1F, 0xFF, 0x80, 0x00, ##             00000000000000               
            0x00, 0x03, 0xFF, 0xF0, 0x00, ##                00000000000000            
            0x00, 0x00, 0xFF, 0xFE, 0x00, ##                  000000000000000         
            0x00, 0x00, 0x1F, 0xFF, 0xC0, ##                     000000000000000      
            0x00, 0x00, 0x03, 0xFF, 0xF0, ##                        00000000000000    
            0x00, 0x00, 0x00, 0x7F, 0xFE, ##                           00000000000000 
            0x00, 0x00, 0x00, 0x1F, 0xFF, ##                             0000000000000
            0x00, 0x00, 0x00, 0x03, 0xFF, ##                                0000000000
            0x00, 0x00, 0x00, 0x00, 0x7F, ##                                   0000000
            0x00, 0x00, 0x00, 0x00, 0x0F, ##                                      0000
            0x00, 0x00, 0x00, 0x00, 0x03, ##                                        00
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '61' => {    # '='
        'width'    => 40, 
        'xoffset'  => 7, 
        'xadvance' => 54, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                          
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                          
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                          
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                          
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                          
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                          
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                          
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                          
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '62' => {    # '>'
        'width'    => 40, 
        'xoffset'  => 7, 
        'xadvance' => 54, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xC0, 0x00, 0x00, 0x00, 0x00, ##  00                                      
            0xF0, 0x00, 0x00, 0x00, 0x00, ##  0000                                    
            0xFE, 0x00, 0x00, 0x00, 0x00, ##  0000000                                 
            0xFF, 0xC0, 0x00, 0x00, 0x00, ##  0000000000                              
            0xFF, 0xF8, 0x00, 0x00, 0x00, ##  0000000000000                           
            0x7F, 0xFE, 0x00, 0x00, 0x00, ##   00000000000000                         
            0x1F, 0xFF, 0xC0, 0x00, 0x00, ##     000000000000000                      
            0x03, 0xFF, 0xF8, 0x00, 0x00, ##        000000000000000                   
            0x00, 0x7F, 0xFF, 0x00, 0x00, ##           000000000000000                
            0x00, 0x0F, 0xFF, 0xC0, 0x00, ##              00000000000000              
            0x00, 0x03, 0xFF, 0xF8, 0x00, ##                000000000000000           
            0x00, 0x00, 0x7F, 0xFF, 0x00, ##                   000000000000000        
            0x00, 0x00, 0x0F, 0xFF, 0xE0, ##                      000000000000000     
            0x00, 0x00, 0x01, 0xFF, 0xF8, ##                         00000000000000   
            0x00, 0x00, 0x00, 0x7F, 0xFF, ##                           000000000000000
            0x00, 0x00, 0x00, 0x0F, 0xFF, ##                              000000000000
            0x00, 0x00, 0x00, 0x01, 0xFF, ##                                 000000000
            0x00, 0x00, 0x00, 0x01, 0xFF, ##                                 000000000
            0x00, 0x00, 0x00, 0x0F, 0xFF, ##                              000000000000
            0x00, 0x00, 0x00, 0x3F, 0xFF, ##                            00000000000000
            0x00, 0x00, 0x01, 0xFF, 0xFC, ##                         000000000000000  
            0x00, 0x00, 0x0F, 0xFF, 0xE0, ##                      000000000000000     
            0x00, 0x00, 0x7F, 0xFF, 0x00, ##                   000000000000000        
            0x00, 0x01, 0xFF, 0xF8, 0x00, ##                 00000000000000           
            0x00, 0x0F, 0xFF, 0xC0, 0x00, ##              00000000000000              
            0x00, 0x7F, 0xFF, 0x00, 0x00, ##           000000000000000                
            0x03, 0xFF, 0xF8, 0x00, 0x00, ##        000000000000000                   
            0x0F, 0xFF, 0xC0, 0x00, 0x00, ##      00000000000000                      
            0x7F, 0xFE, 0x00, 0x00, 0x00, ##   00000000000000                         
            0xFF, 0xF8, 0x00, 0x00, 0x00, ##  0000000000000                           
            0xFF, 0xC0, 0x00, 0x00, 0x00, ##  0000000000                              
            0xFE, 0x00, 0x00, 0x00, 0x00, ##  0000000                                 
            0xF0, 0x00, 0x00, 0x00, 0x00, ##  0000                                    
            0xC0, 0x00, 0x00, 0x00, 0x00, ##  00                                      
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '63' => {    # '?'
        'width'    => 27, 
        'xoffset'  => 4, 
        'xadvance' => 34, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x01, 0xFF, 0x80, 0x00, ##         0000000000          
            0x0F, 0xFF, 0xF0, 0x00, ##      0000000000000000       
            0x7F, 0xFF, 0xFC, 0x00, ##   000000000000000000000     
            0xFF, 0x81, 0xFE, 0x00, ##  000000000      00000000    
            0xFE, 0x00, 0x7F, 0x00, ##  0000000          0000000   
            0xFC, 0x00, 0x3F, 0x80, ##  000000            0000000  
            0xF8, 0x00, 0x3F, 0xC0, ##  00000             00000000 
            0xF0, 0x00, 0x1F, 0xC0, ##  0000               0000000 
            0xF0, 0x00, 0x1F, 0xC0, ##  0000               0000000 
            0xE0, 0x00, 0x0F, 0xE0, ##  000                 0000000
            0xE0, 0x00, 0x0F, 0xE0, ##  000                 0000000
            0x00, 0x00, 0x0F, 0xE0, ##                      0000000
            0x00, 0x00, 0x0F, 0xE0, ##                      0000000
            0x00, 0x00, 0x0F, 0xE0, ##                      0000000
            0x00, 0x00, 0x0F, 0xE0, ##                      0000000
            0x00, 0x00, 0x0F, 0xE0, ##                      0000000
            0x00, 0x00, 0x1F, 0xC0, ##                     0000000 
            0x00, 0x00, 0x1F, 0xC0, ##                     0000000 
            0x00, 0x00, 0x3F, 0xC0, ##                    00000000 
            0x00, 0x00, 0x3F, 0x80, ##                    0000000  
            0x00, 0x00, 0x7F, 0x80, ##                   00000000  
            0x00, 0x00, 0xFF, 0x00, ##                  00000000   
            0x00, 0x01, 0xFE, 0x00, ##                 00000000    
            0x00, 0x07, 0xFC, 0x00, ##               000000000     
            0x00, 0x3F, 0xF0, 0x00, ##            0000000000       
            0x00, 0x7F, 0xC0, 0x00, ##           000000000         
            0x00, 0x7E, 0x00, 0x00, ##           000000            
            0x00, 0x78, 0x00, 0x00, ##           0000              
            0x00, 0x78, 0x00, 0x00, ##           0000              
            0x00, 0x78, 0x00, 0x00, ##           0000              
            0x00, 0x78, 0x00, 0x00, ##           0000              
            0x00, 0x78, 0x00, 0x00, ##           0000              
            0x00, 0x78, 0x00, 0x00, ##           0000              
            0x00, 0x78, 0x00, 0x00, ##           0000              
            0x00, 0x78, 0x00, 0x00, ##           0000              
            0x00, 0x00, 0x00, 0x00, ##                             
            0x00, 0x00, 0x00, 0x00, ##                             
            0x00, 0x00, 0x00, 0x00, ##                             
            0x00, 0x00, 0x00, 0x00, ##                             
            0x00, 0x00, 0x00, 0x00, ##                             
            0x00, 0x78, 0x00, 0x00, ##           0000              
            0x00, 0xFC, 0x00, 0x00, ##          000000             
            0x01, 0xFE, 0x00, 0x00, ##         00000000            
            0x01, 0xFE, 0x00, 0x00, ##         00000000            
            0x01, 0xFE, 0x00, 0x00, ##         00000000            
            0x01, 0xFE, 0x00, 0x00, ##         00000000            
            0x00, 0xFC, 0x00, 0x00, ##          000000             
            0x00, 0x78, 0x00, 0x00, ##           0000              
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '64' => {    # '@'
        'width'    => 55, 
        'xoffset'  => 4, 
        'xadvance' => 64, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x01, 0xFF, 0xC0, 0x00, 0x00, ##                         00000000000                     
            0x00, 0x00, 0x1F, 0xFF, 0xFC, 0x00, 0x00, ##                     0000000000000000000                 
            0x00, 0x00, 0x7F, 0xFF, 0xFF, 0x80, 0x00, ##                   000000000000000000000000              
            0x00, 0x03, 0xFF, 0x00, 0x3F, 0xE0, 0x00, ##                0000000000          000000000            
            0x00, 0x07, 0xF8, 0x00, 0x03, 0xF0, 0x00, ##               00000000                 000000           
            0x00, 0x1F, 0xC0, 0x00, 0x00, 0xFC, 0x00, ##             0000000                      000000         
            0x00, 0x3F, 0x00, 0x00, 0x00, 0x3E, 0x00, ##            000000                          00000        
            0x00, 0x7E, 0x00, 0x00, 0x00, 0x1F, 0x00, ##           000000                            00000       
            0x00, 0xF8, 0x00, 0x00, 0x00, 0x07, 0x80, ##          00000                                0000      
            0x01, 0xF0, 0x00, 0x00, 0x00, 0x03, 0xC0, ##         00000                                  0000     
            0x03, 0xE0, 0x00, 0x00, 0x00, 0x01, 0xE0, ##        00000                                    0000    
            0x07, 0xC0, 0x00, 0x00, 0x00, 0x00, 0xE0, ##       00000                                      000    
            0x07, 0xC0, 0x00, 0x00, 0x00, 0x00, 0xF0, ##       00000                                      0000   
            0x0F, 0x80, 0x00, 0x00, 0x00, 0x00, 0x70, ##      00000                                        000   
            0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, ##     00000                                          000  
            0x1F, 0x00, 0x01, 0xFC, 0x0F, 0x80, 0x38, ##     00000               0000000      00000         000  
            0x3E, 0x00, 0x0F, 0xFF, 0x8F, 0x80, 0x1C, ##    00000             0000000000000   00000          000 
            0x3E, 0x00, 0x1F, 0xFF, 0xCF, 0x80, 0x1C, ##    00000            000000000000000  00000          000 
            0x3E, 0x00, 0x3F, 0x81, 0xEF, 0x80, 0x1C, ##    00000           0000000      0000 00000          000 
            0x7C, 0x00, 0x7E, 0x00, 0x7F, 0x80, 0x1E, ##   00000           000000          00000000          0000
            0x7C, 0x00, 0xFC, 0x00, 0x3F, 0x80, 0x0E, ##   00000          000000            0000000           000
            0x7C, 0x01, 0xFC, 0x00, 0x1F, 0x80, 0x0E, ##   00000         0000000             000000           000
            0xF8, 0x01, 0xF8, 0x00, 0x1F, 0x80, 0x0E, ##  00000          000000              000000           000
            0xF8, 0x01, 0xF8, 0x00, 0x0F, 0x80, 0x0E, ##  00000          000000               00000           000
            0xF8, 0x03, 0xF0, 0x00, 0x0F, 0x80, 0x0E, ##  00000         000000                00000           000
            0xF8, 0x03, 0xF0, 0x00, 0x0F, 0x80, 0x0E, ##  00000         000000                00000           000
            0xF8, 0x03, 0xF0, 0x00, 0x0F, 0x80, 0x0E, ##  00000         000000                00000           000
            0xF8, 0x03, 0xF0, 0x00, 0x0F, 0x80, 0x0E, ##  00000         000000                00000           000
            0xF8, 0x03, 0xF0, 0x00, 0x0F, 0x80, 0x0E, ##  00000         000000                00000           000
            0xF8, 0x03, 0xF0, 0x00, 0x0F, 0x80, 0x1C, ##  00000         000000                00000          000 
            0xF8, 0x03, 0xF0, 0x00, 0x0F, 0x80, 0x1C, ##  00000         000000                00000          000 
            0xF8, 0x03, 0xF0, 0x00, 0x0F, 0x80, 0x1C, ##  00000         000000                00000          000 
            0xF8, 0x03, 0xF0, 0x00, 0x0F, 0x80, 0x38, ##  00000         000000                00000         000  
            0xF8, 0x01, 0xF8, 0x00, 0x1F, 0x80, 0x78, ##  00000          000000              000000        0000  
            0x7C, 0x01, 0xF8, 0x00, 0x1F, 0x80, 0x70, ##   00000         000000              000000        000   
            0x7C, 0x00, 0xFC, 0x00, 0x1F, 0x80, 0xE0, ##   00000          000000             000000       000    
            0x7C, 0x00, 0xFC, 0x00, 0x3F, 0x81, 0xE0, ##   00000          000000            0000000      0000    
            0x7C, 0x00, 0x7E, 0x00, 0x7F, 0x87, 0xC0, ##   00000           000000          00000000    00000     
            0x3E, 0x00, 0x3F, 0x81, 0xEF, 0x9F, 0x00, ##    00000           0000000      0000 00000  00000       
            0x3E, 0x00, 0x1F, 0xFF, 0xCF, 0xFE, 0x00, ##    00000            000000000000000  00000000000        
            0x1F, 0x00, 0x0F, 0xFF, 0x8F, 0xF8, 0x00, ##     00000            0000000000000   000000000          
            0x1F, 0x00, 0x01, 0xFC, 0x0F, 0x80, 0x00, ##     00000               0000000      00000              
            0x0F, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, ##      00000                                              
            0x0F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, ##      000000                                             
            0x07, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, ##       00000                                             
            0x03, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, ##        00000                                            
            0x01, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000                                           
            0x00, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, ##          00000                                          
            0x00, 0x7E, 0x00, 0x00, 0x00, 0x10, 0x00, ##           000000                            0           
            0x00, 0x3F, 0x00, 0x00, 0x00, 0x78, 0x00, ##            000000                         0000          
            0x00, 0x1F, 0xC0, 0x00, 0x00, 0xF8, 0x00, ##             0000000                      00000          
            0x00, 0x0F, 0xF0, 0x00, 0x03, 0xF0, 0x00, ##              00000000                  000000           
            0x00, 0x03, 0xFF, 0x00, 0x3F, 0xC0, 0x00, ##                0000000000          00000000             
            0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x00, 0x00, ##                  000000000000000000000000               
            0x00, 0x00, 0x1F, 0xFF, 0xFC, 0x00, 0x00, ##                     0000000000000000000                 
            0x00, 0x00, 0x01, 0xFF, 0xC0, 0x00, 0x00, ##                         00000000000                     
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '65' => {    # 'A'
        'width'    => 47, 
        'xoffset'  => 0, 
        'xadvance' => 47, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x07, 0xC0, 0x00, 0x00, ##                       00000                     
            0x00, 0x00, 0x0F, 0xC0, 0x00, 0x00, ##                      000000                     
            0x00, 0x00, 0x0F, 0xE0, 0x00, 0x00, ##                      0000000                    
            0x00, 0x00, 0x1F, 0xE0, 0x00, 0x00, ##                     00000000                    
            0x00, 0x00, 0x1F, 0xE0, 0x00, 0x00, ##                     00000000                    
            0x00, 0x00, 0x1F, 0xF0, 0x00, 0x00, ##                     000000000                   
            0x00, 0x00, 0x3F, 0xF0, 0x00, 0x00, ##                    0000000000                   
            0x00, 0x00, 0x3F, 0xF0, 0x00, 0x00, ##                    0000000000                   
            0x00, 0x00, 0x7B, 0xF8, 0x00, 0x00, ##                   0000 0000000                  
            0x00, 0x00, 0x7B, 0xF8, 0x00, 0x00, ##                   0000 0000000                  
            0x00, 0x00, 0x79, 0xFC, 0x00, 0x00, ##                   0000  0000000                 
            0x00, 0x00, 0xF1, 0xFC, 0x00, 0x00, ##                  0000   0000000                 
            0x00, 0x00, 0xF1, 0xFC, 0x00, 0x00, ##                  0000   0000000                 
            0x00, 0x00, 0xE0, 0xFE, 0x00, 0x00, ##                  000     0000000                
            0x00, 0x01, 0xE0, 0xFE, 0x00, 0x00, ##                 0000     0000000                
            0x00, 0x01, 0xE0, 0xFE, 0x00, 0x00, ##                 0000     0000000                
            0x00, 0x03, 0xC0, 0x7F, 0x00, 0x00, ##                0000       0000000               
            0x00, 0x03, 0xC0, 0x7F, 0x00, 0x00, ##                0000       0000000               
            0x00, 0x03, 0xC0, 0x3F, 0x80, 0x00, ##                0000        0000000              
            0x00, 0x07, 0x80, 0x3F, 0x80, 0x00, ##               0000         0000000              
            0x00, 0x07, 0x80, 0x3F, 0x80, 0x00, ##               0000         0000000              
            0x00, 0x07, 0x00, 0x1F, 0xC0, 0x00, ##               000           0000000             
            0x00, 0x0F, 0x00, 0x1F, 0xC0, 0x00, ##              0000           0000000             
            0x00, 0x0F, 0x00, 0x0F, 0xE0, 0x00, ##              0000            0000000            
            0x00, 0x1E, 0x00, 0x0F, 0xE0, 0x00, ##             0000             0000000            
            0x00, 0x1E, 0x00, 0x0F, 0xE0, 0x00, ##             0000             0000000            
            0x00, 0x1C, 0x00, 0x07, 0xF0, 0x00, ##             000               0000000           
            0x00, 0x3C, 0x00, 0x07, 0xF0, 0x00, ##            0000               0000000           
            0x00, 0x3C, 0x00, 0x07, 0xF0, 0x00, ##            0000               0000000           
            0x00, 0x38, 0x00, 0x03, 0xF8, 0x00, ##            000                 0000000          
            0x00, 0x7F, 0xFF, 0xFF, 0xF8, 0x00, ##           0000000000000000000000000000          
            0x00, 0x7F, 0xFF, 0xFF, 0xFC, 0x00, ##           00000000000000000000000000000         
            0x00, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, ##          000000000000000000000000000000         
            0x00, 0xF0, 0x00, 0x01, 0xFC, 0x00, ##          0000                   0000000         
            0x00, 0xE0, 0x00, 0x00, 0xFE, 0x00, ##          000                     0000000        
            0x01, 0xE0, 0x00, 0x00, 0xFE, 0x00, ##         0000                     0000000        
            0x01, 0xE0, 0x00, 0x00, 0x7F, 0x00, ##         0000                      0000000       
            0x01, 0xC0, 0x00, 0x00, 0x7F, 0x00, ##         000                       0000000       
            0x03, 0xC0, 0x00, 0x00, 0x7F, 0x00, ##        0000                       0000000       
            0x03, 0xC0, 0x00, 0x00, 0x3F, 0x80, ##        0000                        0000000      
            0x07, 0x80, 0x00, 0x00, 0x3F, 0x80, ##       0000                         0000000      
            0x07, 0x80, 0x00, 0x00, 0x3F, 0x80, ##       0000                         0000000      
            0x07, 0x00, 0x00, 0x00, 0x1F, 0xC0, ##       000                           0000000     
            0x0F, 0x00, 0x00, 0x00, 0x1F, 0xC0, ##      0000                           0000000     
            0xFF, 0xF8, 0x00, 0x03, 0xFF, 0xFE, ##  0000000000000                 00000000000000000
            0xFF, 0xF8, 0x00, 0x03, 0xFF, 0xFE, ##  0000000000000                 00000000000000000
            0xFF, 0xF8, 0x00, 0x03, 0xFF, 0xFE, ##  0000000000000                 00000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '66' => {    # 'B'
        'width'    => 40, 
        'xoffset'  => 4, 
        'xadvance' => 48, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFF, 0xF0, 0x00, ##  0000000000000000000000000000            
            0xFF, 0xFF, 0xFF, 0xFE, 0x00, ##  0000000000000000000000000000000         
            0xFF, 0xFF, 0xFF, 0xFF, 0x80, ##  000000000000000000000000000000000       
            0x03, 0xF8, 0x00, 0x7F, 0xC0, ##        0000000            000000000      
            0x03, 0xF8, 0x00, 0x1F, 0xE0, ##        0000000              00000000     
            0x03, 0xF8, 0x00, 0x0F, 0xF0, ##        0000000               00000000    
            0x03, 0xF8, 0x00, 0x07, 0xF0, ##        0000000                0000000    
            0x03, 0xF8, 0x00, 0x07, 0xF8, ##        0000000                00000000   
            0x03, 0xF8, 0x00, 0x03, 0xF8, ##        0000000                 0000000   
            0x03, 0xF8, 0x00, 0x03, 0xF8, ##        0000000                 0000000   
            0x03, 0xF8, 0x00, 0x03, 0xF8, ##        0000000                 0000000   
            0x03, 0xF8, 0x00, 0x03, 0xF8, ##        0000000                 0000000   
            0x03, 0xF8, 0x00, 0x03, 0xF8, ##        0000000                 0000000   
            0x03, 0xF8, 0x00, 0x03, 0xF8, ##        0000000                 0000000   
            0x03, 0xF8, 0x00, 0x07, 0xF0, ##        0000000                0000000    
            0x03, 0xF8, 0x00, 0x07, 0xF0, ##        0000000                0000000    
            0x03, 0xF8, 0x00, 0x0F, 0xE0, ##        0000000               0000000     
            0x03, 0xF8, 0x00, 0x1F, 0xE0, ##        0000000              00000000     
            0x03, 0xF8, 0x00, 0x7F, 0x80, ##        0000000            00000000       
            0x03, 0xFF, 0xFF, 0xFE, 0x00, ##        0000000000000000000000000         
            0x03, 0xFF, 0xFF, 0xF8, 0x00, ##        00000000000000000000000           
            0x03, 0xFF, 0xFF, 0xFF, 0x00, ##        00000000000000000000000000        
            0x03, 0xF8, 0x00, 0x1F, 0xE0, ##        0000000              00000000     
            0x03, 0xF8, 0x00, 0x07, 0xF0, ##        0000000                0000000    
            0x03, 0xF8, 0x00, 0x03, 0xF8, ##        0000000                 0000000   
            0x03, 0xF8, 0x00, 0x01, 0xFC, ##        0000000                  0000000  
            0x03, 0xF8, 0x00, 0x00, 0xFE, ##        0000000                   0000000 
            0x03, 0xF8, 0x00, 0x00, 0xFE, ##        0000000                   0000000 
            0x03, 0xF8, 0x00, 0x00, 0x7E, ##        0000000                    000000 
            0x03, 0xF8, 0x00, 0x00, 0x7F, ##        0000000                    0000000
            0x03, 0xF8, 0x00, 0x00, 0x7F, ##        0000000                    0000000
            0x03, 0xF8, 0x00, 0x00, 0x7F, ##        0000000                    0000000
            0x03, 0xF8, 0x00, 0x00, 0x7F, ##        0000000                    0000000
            0x03, 0xF8, 0x00, 0x00, 0x7F, ##        0000000                    0000000
            0x03, 0xF8, 0x00, 0x00, 0x7F, ##        0000000                    0000000
            0x03, 0xF8, 0x00, 0x00, 0x7F, ##        0000000                    0000000
            0x03, 0xF8, 0x00, 0x00, 0x7F, ##        0000000                    0000000
            0x03, 0xF8, 0x00, 0x00, 0xFE, ##        0000000                   0000000 
            0x03, 0xF8, 0x00, 0x00, 0xFE, ##        0000000                   0000000 
            0x03, 0xF8, 0x00, 0x01, 0xFC, ##        0000000                  0000000  
            0x03, 0xF8, 0x00, 0x03, 0xFC, ##        0000000                 00000000  
            0x03, 0xF8, 0x00, 0x07, 0xF8, ##        0000000                00000000   
            0x03, 0xF8, 0x00, 0x3F, 0xF0, ##        0000000             0000000000    
            0xFF, 0xFF, 0xFF, 0xFF, 0xC0, ##  0000000000000000000000000000000000      
            0xFF, 0xFF, 0xFF, 0xFF, 0x00, ##  00000000000000000000000000000000        
            0xFF, 0xFF, 0xFF, 0xF0, 0x00, ##  0000000000000000000000000000            
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '67' => {    # 'C'
        'width'    => 42, 
        'xoffset'  => 4, 
        'xadvance' => 50, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x3F, 0xF8, 0x00, 0x00, ##                    00000000000             
            0x00, 0x03, 0xFF, 0xFF, 0xC0, 0x00, ##                00000000000000000000        
            0x00, 0x0F, 0xFF, 0xFF, 0xF8, 0x00, ##              0000000000000000000000000     
            0x00, 0x3F, 0xC0, 0x1F, 0xFF, 0x00, ##            00000000         0000000000000  
            0x00, 0x7E, 0x00, 0x03, 0xFF, 0x80, ##           000000               00000000000 
            0x01, 0xFC, 0x00, 0x00, 0xFF, 0x80, ##         0000000                  000000000 
            0x03, 0xF8, 0x00, 0x00, 0x7F, 0x80, ##        0000000                    00000000 
            0x03, 0xF0, 0x00, 0x00, 0x3F, 0x80, ##        000000                      0000000 
            0x07, 0xE0, 0x00, 0x00, 0x1F, 0x80, ##       000000                        000000 
            0x0F, 0xC0, 0x00, 0x00, 0x1F, 0x80, ##      000000                         000000 
            0x1F, 0xC0, 0x00, 0x00, 0x0F, 0x80, ##     0000000                          00000 
            0x1F, 0x80, 0x00, 0x00, 0x0F, 0x80, ##     000000                           00000 
            0x3F, 0x80, 0x00, 0x00, 0x0F, 0x80, ##    0000000                           00000 
            0x3F, 0x00, 0x00, 0x00, 0x07, 0x80, ##    000000                             0000 
            0x7F, 0x00, 0x00, 0x00, 0x07, 0x80, ##   0000000                             0000 
            0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, ##   0000000                                  
            0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, ##   0000000                                  
            0x7E, 0x00, 0x00, 0x00, 0x00, 0x00, ##   000000                                   
            0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000000                                   
            0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000000                                   
            0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000000                                   
            0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000000                                   
            0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000000                                   
            0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000000                                   
            0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000000                                   
            0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000000                                   
            0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000000                                   
            0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000000                                   
            0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000000                                   
            0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000000                                   
            0x7E, 0x00, 0x00, 0x00, 0x00, 0x00, ##   000000                                   
            0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, ##   0000000                                  
            0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, ##   0000000                                  
            0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, ##   0000000                                  
            0x3F, 0x00, 0x00, 0x00, 0x00, 0x00, ##    000000                                  
            0x3F, 0x80, 0x00, 0x00, 0x0F, 0xC0, ##    0000000                           000000
            0x1F, 0x80, 0x00, 0x00, 0x1F, 0x80, ##     000000                          000000 
            0x1F, 0xC0, 0x00, 0x00, 0x1F, 0x80, ##     0000000                         000000 
            0x0F, 0xC0, 0x00, 0x00, 0x3F, 0x00, ##      000000                        000000  
            0x07, 0xE0, 0x00, 0x00, 0x3F, 0x00, ##       000000                       000000  
            0x03, 0xF0, 0x00, 0x00, 0x7E, 0x00, ##        000000                     000000   
            0x01, 0xF0, 0x00, 0x00, 0xFC, 0x00, ##         00000                    000000    
            0x00, 0xFC, 0x00, 0x01, 0xF8, 0x00, ##          000000                 000000     
            0x00, 0x7E, 0x00, 0x07, 0xF0, 0x00, ##           000000              0000000      
            0x00, 0x3F, 0xC0, 0x1F, 0xE0, 0x00, ##            00000000         00000000       
            0x00, 0x0F, 0xFF, 0xFF, 0xC0, 0x00, ##              0000000000000000000000        
            0x00, 0x03, 0xFF, 0xFE, 0x00, 0x00, ##                00000000000000000           
            0x00, 0x00, 0x3F, 0xF0, 0x00, 0x00, ##                    0000000000              
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '68' => {    # 'D'
        'width'    => 44, 
        'xoffset'  => 4, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x00, ##  0000000000000000000000000                   
            0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x00, ##  00000000000000000000000000000               
            0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, ##  00000000000000000000000000000000            
            0x03, 0xF8, 0x00, 0xFF, 0xC0, 0x00, ##        0000000           0000000000          
            0x03, 0xF8, 0x00, 0x1F, 0xE0, 0x00, ##        0000000              00000000         
            0x03, 0xF8, 0x00, 0x07, 0xF8, 0x00, ##        0000000                00000000       
            0x03, 0xF8, 0x00, 0x03, 0xFC, 0x00, ##        0000000                 00000000      
            0x03, 0xF8, 0x00, 0x00, 0xFE, 0x00, ##        0000000                   0000000     
            0x03, 0xF8, 0x00, 0x00, 0x7F, 0x00, ##        0000000                    0000000    
            0x03, 0xF8, 0x00, 0x00, 0x7F, 0x00, ##        0000000                    0000000    
            0x03, 0xF8, 0x00, 0x00, 0x3F, 0x80, ##        0000000                     0000000   
            0x03, 0xF8, 0x00, 0x00, 0x1F, 0x80, ##        0000000                      000000   
            0x03, 0xF8, 0x00, 0x00, 0x1F, 0xC0, ##        0000000                      0000000  
            0x03, 0xF8, 0x00, 0x00, 0x1F, 0xC0, ##        0000000                      0000000  
            0x03, 0xF8, 0x00, 0x00, 0x0F, 0xE0, ##        0000000                       0000000 
            0x03, 0xF8, 0x00, 0x00, 0x0F, 0xE0, ##        0000000                       0000000 
            0x03, 0xF8, 0x00, 0x00, 0x0F, 0xE0, ##        0000000                       0000000 
            0x03, 0xF8, 0x00, 0x00, 0x07, 0xF0, ##        0000000                        0000000
            0x03, 0xF8, 0x00, 0x00, 0x07, 0xF0, ##        0000000                        0000000
            0x03, 0xF8, 0x00, 0x00, 0x07, 0xF0, ##        0000000                        0000000
            0x03, 0xF8, 0x00, 0x00, 0x07, 0xF0, ##        0000000                        0000000
            0x03, 0xF8, 0x00, 0x00, 0x07, 0xF0, ##        0000000                        0000000
            0x03, 0xF8, 0x00, 0x00, 0x07, 0xF0, ##        0000000                        0000000
            0x03, 0xF8, 0x00, 0x00, 0x07, 0xF0, ##        0000000                        0000000
            0x03, 0xF8, 0x00, 0x00, 0x07, 0xF0, ##        0000000                        0000000
            0x03, 0xF8, 0x00, 0x00, 0x07, 0xF0, ##        0000000                        0000000
            0x03, 0xF8, 0x00, 0x00, 0x07, 0xF0, ##        0000000                        0000000
            0x03, 0xF8, 0x00, 0x00, 0x07, 0xF0, ##        0000000                        0000000
            0x03, 0xF8, 0x00, 0x00, 0x07, 0xF0, ##        0000000                        0000000
            0x03, 0xF8, 0x00, 0x00, 0x0F, 0xE0, ##        0000000                       0000000 
            0x03, 0xF8, 0x00, 0x00, 0x0F, 0xE0, ##        0000000                       0000000 
            0x03, 0xF8, 0x00, 0x00, 0x0F, 0xE0, ##        0000000                       0000000 
            0x03, 0xF8, 0x00, 0x00, 0x1F, 0xC0, ##        0000000                      0000000  
            0x03, 0xF8, 0x00, 0x00, 0x1F, 0xC0, ##        0000000                      0000000  
            0x03, 0xF8, 0x00, 0x00, 0x1F, 0x80, ##        0000000                      000000   
            0x03, 0xF8, 0x00, 0x00, 0x3F, 0x80, ##        0000000                     0000000   
            0x03, 0xF8, 0x00, 0x00, 0x7F, 0x00, ##        0000000                    0000000    
            0x03, 0xF8, 0x00, 0x00, 0x7F, 0x00, ##        0000000                    0000000    
            0x03, 0xF8, 0x00, 0x00, 0xFE, 0x00, ##        0000000                   0000000     
            0x03, 0xF8, 0x00, 0x03, 0xFC, 0x00, ##        0000000                 00000000      
            0x03, 0xF8, 0x00, 0x07, 0xF8, 0x00, ##        0000000                00000000       
            0x03, 0xF8, 0x00, 0x1F, 0xE0, 0x00, ##        0000000              00000000         
            0x03, 0xF8, 0x00, 0xFF, 0xC0, 0x00, ##        0000000           0000000000          
            0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, ##  00000000000000000000000000000000            
            0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x00, ##  00000000000000000000000000000               
            0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x00, ##  0000000000000000000000000                   
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '69' => {    # 'E'
        'width'    => 38, 
        'xoffset'  => 4, 
        'xadvance' => 47, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xFF, 0xFF, 0xFF, 0x00, ##        00000000000000000000000000      
            0x03, 0xFF, 0xFF, 0xFF, 0x00, ##        00000000000000000000000000      
            0x03, 0xFF, 0xFF, 0xFF, 0x00, ##        00000000000000000000000000      
            0x03, 0xFF, 0xFF, 0xFF, 0x00, ##        00000000000000000000000000      
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xFF, 0xFF, 0xFF, 0xFC, ##        00000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '70' => {    # 'F'
        'width'    => 38, 
        'xoffset'  => 4, 
        'xadvance' => 45, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xFF, 0xFF, 0xFF, 0x00, ##        00000000000000000000000000      
            0x03, 0xFF, 0xFF, 0xFF, 0x00, ##        00000000000000000000000000      
            0x03, 0xFF, 0xFF, 0xFF, 0x00, ##        00000000000000000000000000      
            0x03, 0xFF, 0xFF, 0xFF, 0x00, ##        00000000000000000000000000      
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0xFF, 0xFF, 0xF0, 0x00, 0x00, ##  00000000000000000000                  
            0xFF, 0xFF, 0xF0, 0x00, 0x00, ##  00000000000000000000                  
            0xFF, 0xFF, 0xF0, 0x00, 0x00, ##  00000000000000000000                  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '71' => {    # 'G'
        'width'    => 43, 
        'xoffset'  => 4, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x3F, 0xFC, 0x00, 0x00, ##                    000000000000             
            0x00, 0x03, 0xFF, 0xFF, 0xE0, 0x00, ##                000000000000000000000        
            0x00, 0x0F, 0xFF, 0xFF, 0xFC, 0x00, ##              00000000000000000000000000     
            0x00, 0x3F, 0xE0, 0x0F, 0xFF, 0x80, ##            000000000         0000000000000  
            0x00, 0x7F, 0x00, 0x01, 0xFF, 0x80, ##           0000000               0000000000  
            0x00, 0xFC, 0x00, 0x00, 0xFF, 0x80, ##          000000                  000000000  
            0x03, 0xF8, 0x00, 0x00, 0x7F, 0x80, ##        0000000                    00000000  
            0x03, 0xF0, 0x00, 0x00, 0x3F, 0x80, ##        000000                      0000000  
            0x07, 0xE0, 0x00, 0x00, 0x1F, 0x80, ##       000000                        000000  
            0x0F, 0xC0, 0x00, 0x00, 0x0F, 0x80, ##      000000                          00000  
            0x1F, 0xC0, 0x00, 0x00, 0x0F, 0x80, ##     0000000                          00000  
            0x1F, 0x80, 0x00, 0x00, 0x07, 0x80, ##     000000                            0000  
            0x3F, 0x80, 0x00, 0x00, 0x07, 0x80, ##    0000000                            0000  
            0x3F, 0x00, 0x00, 0x00, 0x07, 0x80, ##    000000                             0000  
            0x7F, 0x00, 0x00, 0x00, 0x07, 0x80, ##   0000000                             0000  
            0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, ##   0000000                                   
            0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, ##   0000000                                   
            0x7E, 0x00, 0x00, 0x00, 0x00, 0x00, ##   000000                                    
            0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000000                                    
            0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000000                                    
            0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000000                                    
            0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000000                                    
            0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000000                                    
            0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000000                                    
            0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000000                                    
            0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000000                                    
            0xFE, 0x00, 0x00, 0x1F, 0xFF, 0xE0, ##  0000000                    0000000000000000
            0xFE, 0x00, 0x00, 0x1F, 0xFF, 0xE0, ##  0000000                    0000000000000000
            0xFE, 0x00, 0x00, 0x1F, 0xFF, 0xE0, ##  0000000                    0000000000000000
            0xFE, 0x00, 0x00, 0x00, 0x0F, 0xE0, ##  0000000                             0000000
            0x7E, 0x00, 0x00, 0x00, 0x0F, 0xE0, ##   000000                             0000000
            0x7F, 0x00, 0x00, 0x00, 0x0F, 0xE0, ##   0000000                            0000000
            0x7F, 0x00, 0x00, 0x00, 0x0F, 0xE0, ##   0000000                            0000000
            0x7F, 0x00, 0x00, 0x00, 0x0F, 0xE0, ##   0000000                            0000000
            0x3F, 0x00, 0x00, 0x00, 0x0F, 0xE0, ##    000000                            0000000
            0x3F, 0x80, 0x00, 0x00, 0x0F, 0xE0, ##    0000000                           0000000
            0x1F, 0x80, 0x00, 0x00, 0x0F, 0xE0, ##     000000                           0000000
            0x1F, 0xC0, 0x00, 0x00, 0x0F, 0xE0, ##     0000000                          0000000
            0x0F, 0xC0, 0x00, 0x00, 0x0F, 0xE0, ##      000000                          0000000
            0x07, 0xE0, 0x00, 0x00, 0x0F, 0xE0, ##       000000                         0000000
            0x03, 0xF0, 0x00, 0x00, 0x0F, 0xE0, ##        000000                        0000000
            0x03, 0xF8, 0x00, 0x00, 0x0F, 0xE0, ##        0000000                       0000000
            0x00, 0xFC, 0x00, 0x00, 0x3F, 0xE0, ##          000000                    000000000
            0x00, 0x7F, 0x00, 0x00, 0xFF, 0xE0, ##           0000000                00000000000
            0x00, 0x3F, 0xE0, 0x0F, 0xFF, 0x80, ##            000000000         0000000000000  
            0x00, 0x0F, 0xFF, 0xFF, 0xFE, 0x00, ##              000000000000000000000000000    
            0x00, 0x03, 0xFF, 0xFF, 0xE0, 0x00, ##                000000000000000000000        
            0x00, 0x00, 0x3F, 0xFE, 0x00, 0x00, ##                    0000000000000            
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '72' => {    # 'H'
        'width'    => 49, 
        'xoffset'  => 4, 
        'xadvance' => 57, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xC0, 0x01, 0xFF, 0xFF, 0x80, ##  000000000000000000             000000000000000000
            0xFF, 0xFF, 0xC0, 0x01, 0xFF, 0xFF, 0x80, ##  000000000000000000             000000000000000000
            0xFF, 0xFF, 0xC0, 0x01, 0xFF, 0xFF, 0x80, ##  000000000000000000             000000000000000000
            0x03, 0xF8, 0x00, 0x00, 0x0F, 0xE0, 0x00, ##        0000000                       0000000      
            0x03, 0xF8, 0x00, 0x00, 0x0F, 0xE0, 0x00, ##        0000000                       0000000      
            0x03, 0xF8, 0x00, 0x00, 0x0F, 0xE0, 0x00, ##        0000000                       0000000      
            0x03, 0xF8, 0x00, 0x00, 0x0F, 0xE0, 0x00, ##        0000000                       0000000      
            0x03, 0xF8, 0x00, 0x00, 0x0F, 0xE0, 0x00, ##        0000000                       0000000      
            0x03, 0xF8, 0x00, 0x00, 0x0F, 0xE0, 0x00, ##        0000000                       0000000      
            0x03, 0xF8, 0x00, 0x00, 0x0F, 0xE0, 0x00, ##        0000000                       0000000      
            0x03, 0xF8, 0x00, 0x00, 0x0F, 0xE0, 0x00, ##        0000000                       0000000      
            0x03, 0xF8, 0x00, 0x00, 0x0F, 0xE0, 0x00, ##        0000000                       0000000      
            0x03, 0xF8, 0x00, 0x00, 0x0F, 0xE0, 0x00, ##        0000000                       0000000      
            0x03, 0xF8, 0x00, 0x00, 0x0F, 0xE0, 0x00, ##        0000000                       0000000      
            0x03, 0xF8, 0x00, 0x00, 0x0F, 0xE0, 0x00, ##        0000000                       0000000      
            0x03, 0xF8, 0x00, 0x00, 0x0F, 0xE0, 0x00, ##        0000000                       0000000      
            0x03, 0xF8, 0x00, 0x00, 0x0F, 0xE0, 0x00, ##        0000000                       0000000      
            0x03, 0xF8, 0x00, 0x00, 0x0F, 0xE0, 0x00, ##        0000000                       0000000      
            0x03, 0xF8, 0x00, 0x00, 0x0F, 0xE0, 0x00, ##        0000000                       0000000      
            0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##        0000000000000000000000000000000000000      
            0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##        0000000000000000000000000000000000000      
            0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##        0000000000000000000000000000000000000      
            0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##        0000000000000000000000000000000000000      
            0x03, 0xF8, 0x00, 0x00, 0x0F, 0xE0, 0x00, ##        0000000                       0000000      
            0x03, 0xF8, 0x00, 0x00, 0x0F, 0xE0, 0x00, ##        0000000                       0000000      
            0x03, 0xF8, 0x00, 0x00, 0x0F, 0xE0, 0x00, ##        0000000                       0000000      
            0x03, 0xF8, 0x00, 0x00, 0x0F, 0xE0, 0x00, ##        0000000                       0000000      
            0x03, 0xF8, 0x00, 0x00, 0x0F, 0xE0, 0x00, ##        0000000                       0000000      
            0x03, 0xF8, 0x00, 0x00, 0x0F, 0xE0, 0x00, ##        0000000                       0000000      
            0x03, 0xF8, 0x00, 0x00, 0x0F, 0xE0, 0x00, ##        0000000                       0000000      
            0x03, 0xF8, 0x00, 0x00, 0x0F, 0xE0, 0x00, ##        0000000                       0000000      
            0x03, 0xF8, 0x00, 0x00, 0x0F, 0xE0, 0x00, ##        0000000                       0000000      
            0x03, 0xF8, 0x00, 0x00, 0x0F, 0xE0, 0x00, ##        0000000                       0000000      
            0x03, 0xF8, 0x00, 0x00, 0x0F, 0xE0, 0x00, ##        0000000                       0000000      
            0x03, 0xF8, 0x00, 0x00, 0x0F, 0xE0, 0x00, ##        0000000                       0000000      
            0x03, 0xF8, 0x00, 0x00, 0x0F, 0xE0, 0x00, ##        0000000                       0000000      
            0x03, 0xF8, 0x00, 0x00, 0x0F, 0xE0, 0x00, ##        0000000                       0000000      
            0x03, 0xF8, 0x00, 0x00, 0x0F, 0xE0, 0x00, ##        0000000                       0000000      
            0x03, 0xF8, 0x00, 0x00, 0x0F, 0xE0, 0x00, ##        0000000                       0000000      
            0x03, 0xF8, 0x00, 0x00, 0x0F, 0xE0, 0x00, ##        0000000                       0000000      
            0x03, 0xF8, 0x00, 0x00, 0x0F, 0xE0, 0x00, ##        0000000                       0000000      
            0x03, 0xF8, 0x00, 0x00, 0x0F, 0xE0, 0x00, ##        0000000                       0000000      
            0x03, 0xF8, 0x00, 0x00, 0x0F, 0xE0, 0x00, ##        0000000                       0000000      
            0xFF, 0xFF, 0xC0, 0x01, 0xFF, 0xFF, 0x80, ##  000000000000000000             000000000000000000
            0xFF, 0xFF, 0xC0, 0x01, 0xFF, 0xFF, 0x80, ##  000000000000000000             000000000000000000
            0xFF, 0xFF, 0xC0, 0x01, 0xFF, 0xFF, 0x80, ##  000000000000000000             000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '73' => {    # 'I'
        'width'    => 18, 
        'xoffset'  => 4, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xC0, ##  000000000000000000
            0xFF, 0xFF, 0xC0, ##  000000000000000000
            0xFF, 0xFF, 0xC0, ##  000000000000000000
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0xFF, 0xFF, 0xC0, ##  000000000000000000
            0xFF, 0xFF, 0xC0, ##  000000000000000000
            0xFF, 0xFF, 0xC0, ##  000000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '74' => {    # 'J'
        'width'    => 28, 
        'xoffset'  => -5, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0xFF, 0xFF, 0xF0, ##          00000000000000000000
            0x00, 0xFF, 0xFF, 0xF0, ##          00000000000000000000
            0x00, 0xFF, 0xFF, 0xF0, ##          00000000000000000000
            0x00, 0x01, 0xFC, 0x00, ##                 0000000      
            0x00, 0x01, 0xFC, 0x00, ##                 0000000      
            0x00, 0x01, 0xFC, 0x00, ##                 0000000      
            0x00, 0x01, 0xFC, 0x00, ##                 0000000      
            0x00, 0x01, 0xFC, 0x00, ##                 0000000      
            0x00, 0x01, 0xFC, 0x00, ##                 0000000      
            0x00, 0x01, 0xFC, 0x00, ##                 0000000      
            0x00, 0x01, 0xFC, 0x00, ##                 0000000      
            0x00, 0x01, 0xFC, 0x00, ##                 0000000      
            0x00, 0x01, 0xFC, 0x00, ##                 0000000      
            0x00, 0x01, 0xFC, 0x00, ##                 0000000      
            0x00, 0x01, 0xFC, 0x00, ##                 0000000      
            0x00, 0x01, 0xFC, 0x00, ##                 0000000      
            0x00, 0x01, 0xFC, 0x00, ##                 0000000      
            0x00, 0x01, 0xFC, 0x00, ##                 0000000      
            0x00, 0x01, 0xFC, 0x00, ##                 0000000      
            0x00, 0x01, 0xFC, 0x00, ##                 0000000      
            0x00, 0x01, 0xFC, 0x00, ##                 0000000      
            0x00, 0x01, 0xFC, 0x00, ##                 0000000      
            0x00, 0x01, 0xFC, 0x00, ##                 0000000      
            0x00, 0x01, 0xFC, 0x00, ##                 0000000      
            0x00, 0x01, 0xFC, 0x00, ##                 0000000      
            0x00, 0x01, 0xFC, 0x00, ##                 0000000      
            0x00, 0x01, 0xFC, 0x00, ##                 0000000      
            0x00, 0x01, 0xFC, 0x00, ##                 0000000      
            0x00, 0x01, 0xFC, 0x00, ##                 0000000      
            0x00, 0x01, 0xFC, 0x00, ##                 0000000      
            0x00, 0x01, 0xFC, 0x00, ##                 0000000      
            0x00, 0x01, 0xFC, 0x00, ##                 0000000      
            0x00, 0x01, 0xFC, 0x00, ##                 0000000      
            0x00, 0x01, 0xFC, 0x00, ##                 0000000      
            0x00, 0x01, 0xFC, 0x00, ##                 0000000      
            0x00, 0x01, 0xFC, 0x00, ##                 0000000      
            0x00, 0x01, 0xFC, 0x00, ##                 0000000      
            0x00, 0x01, 0xFC, 0x00, ##                 0000000      
            0x00, 0x01, 0xFC, 0x00, ##                 0000000      
            0x00, 0x01, 0xFC, 0x00, ##                 0000000      
            0x00, 0x01, 0xFC, 0x00, ##                 0000000      
            0x00, 0x01, 0xFC, 0x00, ##                 0000000      
            0x00, 0x01, 0xFC, 0x00, ##                 0000000      
            0x00, 0x01, 0xFC, 0x00, ##                 0000000      
            0x00, 0x01, 0xFC, 0x00, ##                 0000000      
            0x00, 0x01, 0xFC, 0x00, ##                 0000000      
            0x00, 0x01, 0xFC, 0x00, ##                 0000000      
            0x00, 0x01, 0xFC, 0x00, ##                 0000000      
            0x00, 0x01, 0xFC, 0x00, ##                 0000000      
            0x00, 0x01, 0xFC, 0x00, ##                 0000000      
            0x00, 0x01, 0xFC, 0x00, ##                 0000000      
            0xF0, 0x01, 0xF8, 0x00, ##  0000           000000       
            0xF0, 0x03, 0xF8, 0x00, ##  0000          0000000       
            0xF0, 0x03, 0xF8, 0x00, ##  0000          0000000       
            0xF8, 0x03, 0xF0, 0x00, ##  00000         000000        
            0xF8, 0x07, 0xF0, 0x00, ##  00000        0000000        
            0xFE, 0x0F, 0xE0, 0x00, ##  0000000     0000000         
            0xFF, 0xFF, 0xC0, 0x00, ##  000000000000000000          
            0x7F, 0xFF, 0x00, 0x00, ##   000000000000000            
            0x0F, 0xFC, 0x00, 0x00, ##      0000000000              
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '75' => {    # 'K'
        'width'    => 46, 
        'xoffset'  => 4, 
        'xadvance' => 49, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xC0, 0x1F, 0xFF, 0xE0, ##  000000000000000000         0000000000000000   
            0xFF, 0xFF, 0xC0, 0x1F, 0xFF, 0xE0, ##  000000000000000000         0000000000000000   
            0xFF, 0xFF, 0xC0, 0x1F, 0xFF, 0xE0, ##  000000000000000000         0000000000000000   
            0x03, 0xF8, 0x00, 0x00, 0xF8, 0x00, ##        0000000                   00000         
            0x03, 0xF8, 0x00, 0x01, 0xF0, 0x00, ##        0000000                  00000          
            0x03, 0xF8, 0x00, 0x07, 0xE0, 0x00, ##        0000000                000000           
            0x03, 0xF8, 0x00, 0x0F, 0xC0, 0x00, ##        0000000               000000            
            0x03, 0xF8, 0x00, 0x1F, 0x00, 0x00, ##        0000000              00000              
            0x03, 0xF8, 0x00, 0x3E, 0x00, 0x00, ##        0000000             00000               
            0x03, 0xF8, 0x00, 0x7C, 0x00, 0x00, ##        0000000            00000                
            0x03, 0xF8, 0x00, 0xF8, 0x00, 0x00, ##        0000000           00000                 
            0x03, 0xF8, 0x01, 0xF0, 0x00, 0x00, ##        0000000          00000                  
            0x03, 0xF8, 0x03, 0xE0, 0x00, 0x00, ##        0000000         00000                   
            0x03, 0xF8, 0x07, 0xC0, 0x00, 0x00, ##        0000000        00000                    
            0x03, 0xF8, 0x0F, 0x00, 0x00, 0x00, ##        0000000       0000                      
            0x03, 0xF8, 0x1E, 0x00, 0x00, 0x00, ##        0000000      0000                       
            0x03, 0xF8, 0x3C, 0x00, 0x00, 0x00, ##        0000000     0000                        
            0x03, 0xF8, 0xF8, 0x00, 0x00, 0x00, ##        0000000   00000                         
            0x03, 0xF9, 0xF0, 0x00, 0x00, 0x00, ##        0000000  00000                          
            0x03, 0xFB, 0xE0, 0x00, 0x00, 0x00, ##        0000000 00000                           
            0x03, 0xFF, 0xC0, 0x00, 0x00, 0x00, ##        000000000000                            
            0x03, 0xFF, 0xC0, 0x00, 0x00, 0x00, ##        000000000000                            
            0x03, 0xFF, 0xE0, 0x00, 0x00, 0x00, ##        0000000000000                           
            0x03, 0xFF, 0xF0, 0x00, 0x00, 0x00, ##        00000000000000                          
            0x03, 0xFF, 0xF8, 0x00, 0x00, 0x00, ##        000000000000000                         
            0x03, 0xFB, 0xFC, 0x00, 0x00, 0x00, ##        0000000 00000000                        
            0x03, 0xF9, 0xFE, 0x00, 0x00, 0x00, ##        0000000  00000000                       
            0x03, 0xF8, 0xFF, 0x00, 0x00, 0x00, ##        0000000   00000000                      
            0x03, 0xF8, 0x7F, 0x80, 0x00, 0x00, ##        0000000    00000000                     
            0x03, 0xF8, 0x3F, 0xC0, 0x00, 0x00, ##        0000000     00000000                    
            0x03, 0xF8, 0x1F, 0xE0, 0x00, 0x00, ##        0000000      00000000                   
            0x03, 0xF8, 0x0F, 0xF0, 0x00, 0x00, ##        0000000       00000000                  
            0x03, 0xF8, 0x07, 0xF8, 0x00, 0x00, ##        0000000        00000000                 
            0x03, 0xF8, 0x03, 0xFC, 0x00, 0x00, ##        0000000         00000000                
            0x03, 0xF8, 0x01, 0xFE, 0x00, 0x00, ##        0000000          00000000               
            0x03, 0xF8, 0x00, 0xFF, 0x00, 0x00, ##        0000000           00000000              
            0x03, 0xF8, 0x00, 0x7F, 0x80, 0x00, ##        0000000            00000000             
            0x03, 0xF8, 0x00, 0x3F, 0xC0, 0x00, ##        0000000             00000000            
            0x03, 0xF8, 0x00, 0x1F, 0xE0, 0x00, ##        0000000              00000000           
            0x03, 0xF8, 0x00, 0x0F, 0xF8, 0x00, ##        0000000               000000000         
            0x03, 0xF8, 0x00, 0x07, 0xFC, 0x00, ##        0000000                000000000        
            0x03, 0xF8, 0x00, 0x03, 0xFE, 0x00, ##        0000000                 000000000       
            0x03, 0xF8, 0x00, 0x01, 0xFF, 0x00, ##        0000000                  000000000      
            0xFF, 0xFF, 0xC0, 0x00, 0xFF, 0xFC, ##  000000000000000000              00000000000000
            0xFF, 0xFF, 0xC0, 0x00, 0x7F, 0xFC, ##  000000000000000000               0000000000000
            0xFF, 0xFF, 0xC0, 0x00, 0x3F, 0xFC, ##  000000000000000000                000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '76' => {    # 'L'
        'width'    => 38, 
        'xoffset'  => 4, 
        'xadvance' => 44, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xC0, 0x00, 0x00, ##  000000000000000000                    
            0xFF, 0xFF, 0xC0, 0x00, 0x00, ##  000000000000000000                    
            0xFF, 0xFF, 0xC0, 0x00, 0x00, ##  000000000000000000                    
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xFF, 0xFF, 0xFF, 0xFC, ##        00000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '77' => {    # 'M'
        'width'    => 59, 
        'xoffset'  => 3, 
        'xadvance' => 65, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFC, 0x00, 0x00, 0x00, 0x03, 0xFF, 0xE0, ##  00000000000000                                0000000000000
            0xFF, 0xFC, 0x00, 0x00, 0x00, 0x07, 0xFF, 0xE0, ##  00000000000000                               00000000000000
            0xFF, 0xFE, 0x00, 0x00, 0x00, 0x07, 0xFF, 0xE0, ##  000000000000000                              00000000000000
            0x03, 0xFE, 0x00, 0x00, 0x00, 0x0F, 0xF8, 0x00, ##        000000000                             000000000      
            0x03, 0xFF, 0x00, 0x00, 0x00, 0x0F, 0xF8, 0x00, ##        0000000000                            000000000      
            0x03, 0xFF, 0x00, 0x00, 0x00, 0x1F, 0xF8, 0x00, ##        0000000000                           0000000000      
            0x03, 0xFF, 0x80, 0x00, 0x00, 0x1F, 0xF8, 0x00, ##        00000000000                          0000000000      
            0x03, 0xFF, 0x80, 0x00, 0x00, 0x3F, 0xF8, 0x00, ##        00000000000                         00000000000      
            0x03, 0xDF, 0xC0, 0x00, 0x00, 0x3B, 0xF8, 0x00, ##        0000 0000000                        000 0000000      
            0x03, 0xDF, 0xC0, 0x00, 0x00, 0x7B, 0xF8, 0x00, ##        0000 0000000                       0000 0000000      
            0x03, 0xCF, 0xE0, 0x00, 0x00, 0x73, 0xF8, 0x00, ##        0000  0000000                      000  0000000      
            0x03, 0xCF, 0xE0, 0x00, 0x00, 0xF3, 0xF8, 0x00, ##        0000  0000000                     0000  0000000      
            0x03, 0xC7, 0xF0, 0x00, 0x00, 0xE3, 0xF8, 0x00, ##        0000   0000000                    000   0000000      
            0x03, 0xC7, 0xF0, 0x00, 0x01, 0xE3, 0xF8, 0x00, ##        0000   0000000                   0000   0000000      
            0x03, 0xC3, 0xF8, 0x00, 0x01, 0xC3, 0xF8, 0x00, ##        0000    0000000                  000    0000000      
            0x03, 0xC3, 0xF8, 0x00, 0x03, 0xC3, 0xF8, 0x00, ##        0000    0000000                 0000    0000000      
            0x03, 0xC1, 0xFC, 0x00, 0x03, 0xC3, 0xF8, 0x00, ##        0000     0000000                0000    0000000      
            0x03, 0xC1, 0xFC, 0x00, 0x07, 0x83, 0xF8, 0x00, ##        0000     0000000               0000     0000000      
            0x03, 0xC0, 0xFE, 0x00, 0x07, 0x83, 0xF8, 0x00, ##        0000      0000000              0000     0000000      
            0x03, 0xC0, 0xFE, 0x00, 0x07, 0x03, 0xF8, 0x00, ##        0000      0000000              000      0000000      
            0x03, 0xC0, 0x7F, 0x00, 0x0F, 0x03, 0xF8, 0x00, ##        0000       0000000            0000      0000000      
            0x03, 0xC0, 0x7F, 0x00, 0x0E, 0x03, 0xF8, 0x00, ##        0000       0000000            000       0000000      
            0x03, 0xC0, 0x3F, 0x80, 0x1E, 0x03, 0xF8, 0x00, ##        0000        0000000          0000       0000000      
            0x03, 0xC0, 0x3F, 0x80, 0x1C, 0x03, 0xF8, 0x00, ##        0000        0000000          000        0000000      
            0x03, 0xC0, 0x1F, 0xC0, 0x3C, 0x03, 0xF8, 0x00, ##        0000         0000000        0000        0000000      
            0x03, 0xC0, 0x1F, 0xC0, 0x38, 0x03, 0xF8, 0x00, ##        0000         0000000        000         0000000      
            0x03, 0xC0, 0x0F, 0xE0, 0x78, 0x03, 0xF8, 0x00, ##        0000          0000000      0000         0000000      
            0x03, 0xC0, 0x0F, 0xE0, 0x70, 0x03, 0xF8, 0x00, ##        0000          0000000      000          0000000      
            0x03, 0xC0, 0x07, 0xF0, 0xF0, 0x03, 0xF8, 0x00, ##        0000           0000000    0000          0000000      
            0x03, 0xC0, 0x07, 0xF0, 0xE0, 0x03, 0xF8, 0x00, ##        0000           0000000    000           0000000      
            0x03, 0xC0, 0x03, 0xF9, 0xE0, 0x03, 0xF8, 0x00, ##        0000            0000000  0000           0000000      
            0x03, 0xC0, 0x03, 0xF9, 0xC0, 0x03, 0xF8, 0x00, ##        0000            0000000  000            0000000      
            0x03, 0xC0, 0x01, 0xFF, 0xC0, 0x03, 0xF8, 0x00, ##        0000             00000000000            0000000      
            0x03, 0xC0, 0x01, 0xFF, 0xC0, 0x03, 0xF8, 0x00, ##        0000             00000000000            0000000      
            0x03, 0xC0, 0x00, 0xFF, 0x80, 0x03, 0xF8, 0x00, ##        0000              000000000             0000000      
            0x03, 0xC0, 0x00, 0xFF, 0x80, 0x03, 0xF8, 0x00, ##        0000              000000000             0000000      
            0x03, 0xC0, 0x00, 0x7F, 0x00, 0x03, 0xF8, 0x00, ##        0000               0000000              0000000      
            0x03, 0xC0, 0x00, 0x7F, 0x00, 0x03, 0xF8, 0x00, ##        0000               0000000              0000000      
            0x03, 0xC0, 0x00, 0x3E, 0x00, 0x03, 0xF8, 0x00, ##        0000                00000               0000000      
            0x03, 0xC0, 0x00, 0x00, 0x00, 0x03, 0xF8, 0x00, ##        0000                                    0000000      
            0x03, 0xC0, 0x00, 0x00, 0x00, 0x03, 0xF8, 0x00, ##        0000                                    0000000      
            0x03, 0xC0, 0x00, 0x00, 0x00, 0x03, 0xF8, 0x00, ##        0000                                    0000000      
            0x03, 0xC0, 0x00, 0x00, 0x00, 0x03, 0xF8, 0x00, ##        0000                                    0000000      
            0xFF, 0xFF, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xE0, ##  0000000000000000                         000000000000000000
            0xFF, 0xFF, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xE0, ##  0000000000000000                         000000000000000000
            0xFF, 0xFF, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xE0, ##  0000000000000000                         000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '78' => {    # 'N'
        'width'    => 50, 
        'xoffset'  => 3, 
        'xadvance' => 56, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xF0, 0x00, 0x00, 0x3F, 0xFF, 0xC0, ##  000000000000                      0000000000000000
            0xFF, 0xF8, 0x00, 0x00, 0x3F, 0xFF, 0xC0, ##  0000000000000                     0000000000000000
            0xFF, 0xFC, 0x00, 0x00, 0x3F, 0xFF, 0xC0, ##  00000000000000                    0000000000000000
            0x03, 0xFC, 0x00, 0x00, 0x00, 0xF0, 0x00, ##        00000000                          0000      
            0x03, 0xFE, 0x00, 0x00, 0x00, 0xF0, 0x00, ##        000000000                         0000      
            0x03, 0xFF, 0x00, 0x00, 0x00, 0xF0, 0x00, ##        0000000000                        0000      
            0x03, 0xFF, 0x80, 0x00, 0x00, 0xF0, 0x00, ##        00000000000                       0000      
            0x03, 0xFF, 0xC0, 0x00, 0x00, 0xF0, 0x00, ##        000000000000                      0000      
            0x03, 0xFF, 0xC0, 0x00, 0x00, 0xF0, 0x00, ##        000000000000                      0000      
            0x03, 0xDF, 0xE0, 0x00, 0x00, 0xF0, 0x00, ##        0000 00000000                     0000      
            0x03, 0xCF, 0xF0, 0x00, 0x00, 0xF0, 0x00, ##        0000  00000000                    0000      
            0x03, 0xC7, 0xF8, 0x00, 0x00, 0xF0, 0x00, ##        0000   00000000                   0000      
            0x03, 0xC3, 0xF8, 0x00, 0x00, 0xF0, 0x00, ##        0000    0000000                   0000      
            0x03, 0xC3, 0xFC, 0x00, 0x00, 0xF0, 0x00, ##        0000    00000000                  0000      
            0x03, 0xC1, 0xFE, 0x00, 0x00, 0xF0, 0x00, ##        0000     00000000                 0000      
            0x03, 0xC0, 0xFF, 0x00, 0x00, 0xF0, 0x00, ##        0000      00000000                0000      
            0x03, 0xC0, 0x7F, 0x80, 0x00, 0xF0, 0x00, ##        0000       00000000               0000      
            0x03, 0xC0, 0x7F, 0x80, 0x00, 0xF0, 0x00, ##        0000       00000000               0000      
            0x03, 0xC0, 0x3F, 0xC0, 0x00, 0xF0, 0x00, ##        0000        00000000              0000      
            0x03, 0xC0, 0x1F, 0xE0, 0x00, 0xF0, 0x00, ##        0000         00000000             0000      
            0x03, 0xC0, 0x0F, 0xF0, 0x00, 0xF0, 0x00, ##        0000          00000000            0000      
            0x03, 0xC0, 0x0F, 0xF0, 0x00, 0xF0, 0x00, ##        0000          00000000            0000      
            0x03, 0xC0, 0x07, 0xF8, 0x00, 0xF0, 0x00, ##        0000           00000000           0000      
            0x03, 0xC0, 0x03, 0xFC, 0x00, 0xF0, 0x00, ##        0000            00000000          0000      
            0x03, 0xC0, 0x01, 0xFE, 0x00, 0xF0, 0x00, ##        0000             00000000         0000      
            0x03, 0xC0, 0x00, 0xFF, 0x00, 0xF0, 0x00, ##        0000              00000000        0000      
            0x03, 0xC0, 0x00, 0xFF, 0x00, 0xF0, 0x00, ##        0000              00000000        0000      
            0x03, 0xC0, 0x00, 0x7F, 0x80, 0xF0, 0x00, ##        0000               00000000       0000      
            0x03, 0xC0, 0x00, 0x3F, 0xC0, 0xF0, 0x00, ##        0000                00000000      0000      
            0x03, 0xC0, 0x00, 0x1F, 0xE0, 0xF0, 0x00, ##        0000                 00000000     0000      
            0x03, 0xC0, 0x00, 0x1F, 0xE0, 0xF0, 0x00, ##        0000                 00000000     0000      
            0x03, 0xC0, 0x00, 0x0F, 0xF0, 0xF0, 0x00, ##        0000                  00000000    0000      
            0x03, 0xC0, 0x00, 0x07, 0xF8, 0xF0, 0x00, ##        0000                   00000000   0000      
            0x03, 0xC0, 0x00, 0x03, 0xFC, 0xF0, 0x00, ##        0000                    00000000  0000      
            0x03, 0xC0, 0x00, 0x03, 0xFC, 0xF0, 0x00, ##        0000                    00000000  0000      
            0x03, 0xC0, 0x00, 0x01, 0xFE, 0xF0, 0x00, ##        0000                     00000000 0000      
            0x03, 0xC0, 0x00, 0x00, 0xFF, 0xF0, 0x00, ##        0000                      000000000000      
            0x03, 0xC0, 0x00, 0x00, 0x7F, 0xF0, 0x00, ##        0000                       00000000000      
            0x03, 0xC0, 0x00, 0x00, 0x3F, 0xF0, 0x00, ##        0000                        0000000000      
            0x03, 0xC0, 0x00, 0x00, 0x3F, 0xF0, 0x00, ##        0000                        0000000000      
            0x03, 0xC0, 0x00, 0x00, 0x1F, 0xF0, 0x00, ##        0000                         000000000      
            0x03, 0xC0, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##        0000                          00000000      
            0x03, 0xC0, 0x00, 0x00, 0x07, 0xF0, 0x00, ##        0000                           0000000      
            0xFF, 0xFF, 0x00, 0x00, 0x07, 0xF0, 0x00, ##  0000000000000000                     0000000      
            0xFF, 0xFF, 0x00, 0x00, 0x03, 0xF0, 0x00, ##  0000000000000000                      000000      
            0xFF, 0xFF, 0x00, 0x00, 0x01, 0xF0, 0x00, ##  0000000000000000                       00000      
            0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x00, ##                                          0000      
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '79' => {    # 'O'
        'width'    => 45, 
        'xoffset'  => 4, 
        'xadvance' => 53, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x7F, 0xF0, 0x00, 0x00, ##                   00000000000                 
            0x00, 0x03, 0xFF, 0xFE, 0x00, 0x00, ##                00000000000000000              
            0x00, 0x0F, 0xFF, 0xFF, 0x80, 0x00, ##              000000000000000000000            
            0x00, 0x3F, 0xC0, 0x1F, 0xE0, 0x00, ##            00000000         00000000          
            0x00, 0x7E, 0x00, 0x03, 0xF0, 0x00, ##           000000               000000         
            0x01, 0xFC, 0x00, 0x01, 0xFC, 0x00, ##         0000000                 0000000       
            0x03, 0xF8, 0x00, 0x00, 0xFE, 0x00, ##        0000000                   0000000      
            0x03, 0xF0, 0x00, 0x00, 0x7F, 0x00, ##        000000                     0000000     
            0x07, 0xE0, 0x00, 0x00, 0x3F, 0x00, ##       000000                       000000     
            0x0F, 0xC0, 0x00, 0x00, 0x1F, 0x80, ##      000000                         000000    
            0x1F, 0xC0, 0x00, 0x00, 0x1F, 0xC0, ##     0000000                         0000000   
            0x1F, 0x80, 0x00, 0x00, 0x0F, 0xC0, ##     000000                           000000   
            0x3F, 0x80, 0x00, 0x00, 0x0F, 0xE0, ##    0000000                           0000000  
            0x3F, 0x00, 0x00, 0x00, 0x07, 0xE0, ##    000000                             000000  
            0x7F, 0x00, 0x00, 0x00, 0x07, 0xF0, ##   0000000                             0000000 
            0x7F, 0x00, 0x00, 0x00, 0x07, 0xF0, ##   0000000                             0000000 
            0x7F, 0x00, 0x00, 0x00, 0x07, 0xF0, ##   0000000                             0000000 
            0x7E, 0x00, 0x00, 0x00, 0x03, 0xF0, ##   000000                               000000 
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0x7E, 0x00, 0x00, 0x00, 0x03, 0xF0, ##   000000                               000000 
            0x7F, 0x00, 0x00, 0x00, 0x07, 0xF0, ##   0000000                             0000000 
            0x7F, 0x00, 0x00, 0x00, 0x07, 0xF0, ##   0000000                             0000000 
            0x7F, 0x00, 0x00, 0x00, 0x07, 0xE0, ##   0000000                             000000  
            0x3F, 0x00, 0x00, 0x00, 0x07, 0xE0, ##    000000                             000000  
            0x3F, 0x80, 0x00, 0x00, 0x0F, 0xE0, ##    0000000                           0000000  
            0x1F, 0x80, 0x00, 0x00, 0x0F, 0xC0, ##     000000                           000000   
            0x1F, 0xC0, 0x00, 0x00, 0x1F, 0xC0, ##     0000000                         0000000   
            0x0F, 0xC0, 0x00, 0x00, 0x1F, 0x80, ##      000000                         000000    
            0x07, 0xE0, 0x00, 0x00, 0x3F, 0x00, ##       000000                       000000     
            0x03, 0xF0, 0x00, 0x00, 0x7E, 0x00, ##        000000                     000000      
            0x03, 0xF0, 0x00, 0x00, 0xFE, 0x00, ##        000000                    0000000      
            0x01, 0xFC, 0x00, 0x01, 0xF8, 0x00, ##         0000000                 000000        
            0x00, 0x7E, 0x00, 0x03, 0xF0, 0x00, ##           000000               000000         
            0x00, 0x3F, 0xC0, 0x1F, 0xE0, 0x00, ##            00000000         00000000          
            0x00, 0x0F, 0xFF, 0xFF, 0x80, 0x00, ##              000000000000000000000            
            0x00, 0x03, 0xFF, 0xFE, 0x00, 0x00, ##                00000000000000000              
            0x00, 0x00, 0x7F, 0xF0, 0x00, 0x00, ##                   00000000000                 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '80' => {    # 'P'
        'width'    => 37, 
        'xoffset'  => 4, 
        'xadvance' => 43, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##  000000000000000000000000000          
            0xFF, 0xFF, 0xFF, 0xFC, 0x00, ##  000000000000000000000000000000       
            0xFF, 0xFF, 0xFF, 0xFF, 0x00, ##  00000000000000000000000000000000     
            0x03, 0xF8, 0x00, 0xFF, 0x80, ##        0000000           000000000    
            0x03, 0xF8, 0x00, 0x3F, 0xC0, ##        0000000             00000000   
            0x03, 0xF8, 0x00, 0x0F, 0xE0, ##        0000000               0000000  
            0x03, 0xF8, 0x00, 0x0F, 0xE0, ##        0000000               0000000  
            0x03, 0xF8, 0x00, 0x07, 0xF0, ##        0000000                0000000 
            0x03, 0xF8, 0x00, 0x07, 0xF0, ##        0000000                0000000 
            0x03, 0xF8, 0x00, 0x03, 0xF8, ##        0000000                 0000000
            0x03, 0xF8, 0x00, 0x03, 0xF8, ##        0000000                 0000000
            0x03, 0xF8, 0x00, 0x03, 0xF8, ##        0000000                 0000000
            0x03, 0xF8, 0x00, 0x03, 0xF8, ##        0000000                 0000000
            0x03, 0xF8, 0x00, 0x03, 0xF8, ##        0000000                 0000000
            0x03, 0xF8, 0x00, 0x03, 0xF8, ##        0000000                 0000000
            0x03, 0xF8, 0x00, 0x03, 0xF8, ##        0000000                 0000000
            0x03, 0xF8, 0x00, 0x03, 0xF8, ##        0000000                 0000000
            0x03, 0xF8, 0x00, 0x07, 0xF0, ##        0000000                0000000 
            0x03, 0xF8, 0x00, 0x07, 0xF0, ##        0000000                0000000 
            0x03, 0xF8, 0x00, 0x0F, 0xE0, ##        0000000               0000000  
            0x03, 0xF8, 0x00, 0x0F, 0xE0, ##        0000000               0000000  
            0x03, 0xF8, 0x00, 0x3F, 0xC0, ##        0000000             00000000   
            0x03, 0xF8, 0x00, 0xFF, 0x80, ##        0000000           000000000    
            0x03, 0xFF, 0xFF, 0xFF, 0x00, ##        00000000000000000000000000     
            0x03, 0xFF, 0xFF, 0xFC, 0x00, ##        000000000000000000000000       
            0x03, 0xFF, 0xFF, 0xE0, 0x00, ##        000000000000000000000          
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                        
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                        
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                        
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                        
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                        
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                        
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                        
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                        
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                        
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                        
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                        
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                        
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                        
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                        
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                        
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                        
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                        
            0xFF, 0xFF, 0xF0, 0x00, 0x00, ##  00000000000000000000                 
            0xFF, 0xFF, 0xF0, 0x00, 0x00, ##  00000000000000000000                 
            0xFF, 0xFF, 0xF0, 0x00, 0x00, ##  00000000000000000000                 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '81' => {    # 'Q'
        'width'    => 45, 
        'xoffset'  => 4, 
        'xadvance' => 53, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x7F, 0xF0, 0x00, 0x00, ##                   00000000000                 
            0x00, 0x03, 0xFF, 0xFE, 0x00, 0x00, ##                00000000000000000              
            0x00, 0x0F, 0xFF, 0xFF, 0x80, 0x00, ##              000000000000000000000            
            0x00, 0x3F, 0xC0, 0x1F, 0xE0, 0x00, ##            00000000         00000000          
            0x00, 0x7E, 0x00, 0x03, 0xF0, 0x00, ##           000000               000000         
            0x01, 0xFC, 0x00, 0x01, 0xFC, 0x00, ##         0000000                 0000000       
            0x03, 0xF8, 0x00, 0x00, 0xFE, 0x00, ##        0000000                   0000000      
            0x03, 0xF0, 0x00, 0x00, 0x7F, 0x00, ##        000000                     0000000     
            0x07, 0xE0, 0x00, 0x00, 0x3F, 0x00, ##       000000                       000000     
            0x0F, 0xC0, 0x00, 0x00, 0x1F, 0x80, ##      000000                         000000    
            0x1F, 0xC0, 0x00, 0x00, 0x1F, 0xC0, ##     0000000                         0000000   
            0x1F, 0x80, 0x00, 0x00, 0x0F, 0xC0, ##     000000                           000000   
            0x3F, 0x80, 0x00, 0x00, 0x0F, 0xE0, ##    0000000                           0000000  
            0x3F, 0x00, 0x00, 0x00, 0x07, 0xE0, ##    000000                             000000  
            0x7F, 0x00, 0x00, 0x00, 0x07, 0xE0, ##   0000000                             000000  
            0x7F, 0x00, 0x00, 0x00, 0x07, 0xF0, ##   0000000                             0000000 
            0x7F, 0x00, 0x00, 0x00, 0x07, 0xF0, ##   0000000                             0000000 
            0x7E, 0x00, 0x00, 0x00, 0x03, 0xF0, ##   000000                               000000 
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0x7E, 0x00, 0x00, 0x00, 0x03, 0xF0, ##   000000                               000000 
            0x7F, 0x00, 0x00, 0x00, 0x07, 0xF0, ##   0000000                             0000000 
            0x7F, 0x00, 0x00, 0x00, 0x07, 0xF0, ##   0000000                             0000000 
            0x7F, 0x00, 0x00, 0x00, 0x07, 0xE0, ##   0000000                             000000  
            0x3F, 0x00, 0x00, 0x00, 0x07, 0xE0, ##    000000                             000000  
            0x3F, 0x80, 0x00, 0x00, 0x0F, 0xE0, ##    0000000                           0000000  
            0x1F, 0x80, 0x00, 0x00, 0x0F, 0xC0, ##     000000                           000000   
            0x1F, 0xC0, 0x00, 0x00, 0x1F, 0xC0, ##     0000000                         0000000   
            0x0F, 0xC0, 0x00, 0x00, 0x1F, 0x80, ##      000000                         000000    
            0x07, 0xE0, 0x00, 0x00, 0x3F, 0x00, ##       000000                       000000     
            0x07, 0xF0, 0x00, 0x00, 0x7F, 0x00, ##       0000000                     0000000     
            0x03, 0xF0, 0x00, 0x00, 0xFE, 0x00, ##        000000                    0000000      
            0x01, 0xFC, 0x00, 0x01, 0xFC, 0x00, ##         0000000                 0000000       
            0x00, 0x7E, 0x00, 0x03, 0xF0, 0x00, ##           000000               000000         
            0x00, 0x3F, 0xC0, 0x1F, 0xE0, 0x00, ##            00000000         00000000          
            0x00, 0x0F, 0xFF, 0xFF, 0x80, 0x00, ##              000000000000000000000            
            0x00, 0x03, 0xFF, 0xFE, 0x00, 0x00, ##                00000000000000000              
            0x00, 0x00, 0x3F, 0xF0, 0x00, 0x00, ##                    0000000000                 
            0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, ##                          0000                 
            0x00, 0x00, 0x00, 0xF8, 0x00, 0x00, ##                          00000                
            0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, ##                           000000              
            0x00, 0x00, 0x00, 0x3F, 0x80, 0x00, ##                            0000000            
            0x00, 0x00, 0x00, 0x1F, 0xFC, 0x00, ##                             00000000000       
            0x00, 0x00, 0x00, 0x0F, 0xFC, 0x00, ##                              0000000000       
            0x00, 0x00, 0x00, 0x07, 0xFC, 0x00, ##                               000000000       
            0x00, 0x00, 0x00, 0x01, 0xFC, 0x00, ##                                 0000000       
            0x00, 0x00, 0x00, 0x00, 0x3C, 0x00, ##                                    0000       
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '82' => {    # 'R'
        'width'    => 46, 
        'xoffset'  => 4, 
        'xadvance' => 49, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x00, ##  00000000000000000000000000000                 
            0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, ##  00000000000000000000000000000000              
            0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00, ##  000000000000000000000000000000000             
            0x03, 0xF8, 0x00, 0x3F, 0xE0, 0x00, ##        0000000             000000000           
            0x03, 0xF8, 0x00, 0x0F, 0xE0, 0x00, ##        0000000               0000000           
            0x03, 0xF8, 0x00, 0x07, 0xF0, 0x00, ##        0000000                0000000          
            0x03, 0xF8, 0x00, 0x03, 0xF8, 0x00, ##        0000000                 0000000         
            0x03, 0xF8, 0x00, 0x03, 0xF8, 0x00, ##        0000000                 0000000         
            0x03, 0xF8, 0x00, 0x01, 0xFC, 0x00, ##        0000000                  0000000        
            0x03, 0xF8, 0x00, 0x01, 0xFC, 0x00, ##        0000000                  0000000        
            0x03, 0xF8, 0x00, 0x01, 0xFC, 0x00, ##        0000000                  0000000        
            0x03, 0xF8, 0x00, 0x01, 0xFC, 0x00, ##        0000000                  0000000        
            0x03, 0xF8, 0x00, 0x01, 0xFC, 0x00, ##        0000000                  0000000        
            0x03, 0xF8, 0x00, 0x01, 0xFC, 0x00, ##        0000000                  0000000        
            0x03, 0xF8, 0x00, 0x01, 0xFC, 0x00, ##        0000000                  0000000        
            0x03, 0xF8, 0x00, 0x01, 0xFC, 0x00, ##        0000000                  0000000        
            0x03, 0xF8, 0x00, 0x03, 0xF8, 0x00, ##        0000000                 0000000         
            0x03, 0xF8, 0x00, 0x03, 0xF8, 0x00, ##        0000000                 0000000         
            0x03, 0xF8, 0x00, 0x07, 0xF0, 0x00, ##        0000000                0000000          
            0x03, 0xF8, 0x00, 0x0F, 0xF0, 0x00, ##        0000000               00000000          
            0x03, 0xF8, 0x00, 0x3F, 0xE0, 0x00, ##        0000000             000000000           
            0x03, 0xFF, 0xFF, 0xFF, 0x80, 0x00, ##        000000000000000000000000000             
            0x03, 0xFF, 0xFF, 0xFE, 0x00, 0x00, ##        0000000000000000000000000               
            0x03, 0xFF, 0xFF, 0xF0, 0x00, 0x00, ##        0000000000000000000000                  
            0x03, 0xF8, 0x01, 0xFC, 0x00, 0x00, ##        0000000          0000000                
            0x03, 0xF8, 0x00, 0x7E, 0x00, 0x00, ##        0000000            000000               
            0x03, 0xF8, 0x00, 0x3F, 0x00, 0x00, ##        0000000             000000              
            0x03, 0xF8, 0x00, 0x3F, 0x80, 0x00, ##        0000000             0000000             
            0x03, 0xF8, 0x00, 0x1F, 0x80, 0x00, ##        0000000              000000             
            0x03, 0xF8, 0x00, 0x0F, 0xC0, 0x00, ##        0000000               000000            
            0x03, 0xF8, 0x00, 0x0F, 0xC0, 0x00, ##        0000000               000000            
            0x03, 0xF8, 0x00, 0x07, 0xE0, 0x00, ##        0000000                000000           
            0x03, 0xF8, 0x00, 0x07, 0xE0, 0x00, ##        0000000                000000           
            0x03, 0xF8, 0x00, 0x07, 0xF0, 0x00, ##        0000000                0000000          
            0x03, 0xF8, 0x00, 0x03, 0xF0, 0x00, ##        0000000                 000000          
            0x03, 0xF8, 0x00, 0x03, 0xF8, 0x00, ##        0000000                 0000000         
            0x03, 0xF8, 0x00, 0x01, 0xF8, 0x00, ##        0000000                  000000         
            0x03, 0xF8, 0x00, 0x01, 0xFC, 0x00, ##        0000000                  0000000        
            0x03, 0xF8, 0x00, 0x00, 0xFC, 0x00, ##        0000000                   000000        
            0x03, 0xF8, 0x00, 0x00, 0xFE, 0x00, ##        0000000                   0000000       
            0x03, 0xF8, 0x00, 0x00, 0x7E, 0x00, ##        0000000                    000000       
            0x03, 0xF8, 0x00, 0x00, 0x7F, 0x00, ##        0000000                    0000000      
            0x03, 0xF8, 0x00, 0x00, 0x3F, 0x00, ##        0000000                     000000      
            0xFF, 0xFF, 0xE0, 0x00, 0x3F, 0xFC, ##  0000000000000000000               000000000000
            0xFF, 0xFF, 0xE0, 0x00, 0x1F, 0xFC, ##  0000000000000000000                00000000000
            0xFF, 0xFF, 0xE0, 0x00, 0x1F, 0xFC, ##  0000000000000000000                00000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '83' => {    # 'S'
        'width'    => 34, 
        'xoffset'  => 5, 
        'xadvance' => 44, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x1F, 0xFC, 0x00, 0x00, ##             00000000000            
            0x01, 0xFF, 0xFF, 0xF0, 0x00, ##         000000000000000000000      
            0x07, 0xFF, 0xFF, 0xFF, 0x00, ##       000000000000000000000000000  
            0x0F, 0xF0, 0x07, 0xFF, 0x00, ##      00000000         00000000000  
            0x1F, 0x80, 0x00, 0xFF, 0x00, ##     000000               00000000  
            0x3F, 0x00, 0x00, 0x7F, 0x00, ##    000000                 0000000  
            0x7E, 0x00, 0x00, 0x3F, 0x00, ##   000000                   000000  
            0x7E, 0x00, 0x00, 0x1F, 0x00, ##   000000                    00000  
            0x7C, 0x00, 0x00, 0x1F, 0x00, ##   00000                     00000  
            0xFC, 0x00, 0x00, 0x0F, 0x00, ##  000000                      0000  
            0xFC, 0x00, 0x00, 0x0F, 0x00, ##  000000                      0000  
            0xFC, 0x00, 0x00, 0x0F, 0x00, ##  000000                      0000  
            0xFC, 0x00, 0x00, 0x00, 0x00, ##  000000                            
            0xFC, 0x00, 0x00, 0x00, 0x00, ##  000000                            
            0xFE, 0x00, 0x00, 0x00, 0x00, ##  0000000                           
            0xFE, 0x00, 0x00, 0x00, 0x00, ##  0000000                           
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                          
            0x7F, 0xC0, 0x00, 0x00, 0x00, ##   000000000                        
            0x7F, 0xF0, 0x00, 0x00, 0x00, ##   00000000000                      
            0x3F, 0xFE, 0x00, 0x00, 0x00, ##    0000000000000                   
            0x1F, 0xFF, 0xC0, 0x00, 0x00, ##     000000000000000                
            0x1F, 0xFF, 0xFC, 0x00, 0x00, ##     0000000000000000000            
            0x07, 0xFF, 0xFF, 0x80, 0x00, ##       00000000000000000000         
            0x03, 0xFF, 0xFF, 0xE0, 0x00, ##        000000000000000000000       
            0x00, 0x7F, 0xFF, 0xF8, 0x00, ##           00000000000000000000     
            0x00, 0x1F, 0xFF, 0xFC, 0x00, ##             0000000000000000000    
            0x00, 0x01, 0xFF, 0xFE, 0x00, ##                 0000000000000000   
            0x00, 0x00, 0x3F, 0xFF, 0x00, ##                    00000000000000  
            0x00, 0x00, 0x07, 0xFF, 0x80, ##                       000000000000 
            0x00, 0x00, 0x00, 0xFF, 0x80, ##                          000000000 
            0x00, 0x00, 0x00, 0x7F, 0x80, ##                           00000000 
            0x00, 0x00, 0x00, 0x3F, 0xC0, ##                            00000000
            0x00, 0x00, 0x00, 0x1F, 0xC0, ##                             0000000
            0x00, 0x00, 0x00, 0x0F, 0xC0, ##                              000000
            0x00, 0x00, 0x00, 0x0F, 0xC0, ##                              000000
            0xF0, 0x00, 0x00, 0x0F, 0xC0, ##  0000                        000000
            0xF0, 0x00, 0x00, 0x0F, 0xC0, ##  0000                        000000
            0xF0, 0x00, 0x00, 0x0F, 0xC0, ##  0000                        000000
            0xF0, 0x00, 0x00, 0x0F, 0xC0, ##  0000                        000000
            0xF8, 0x00, 0x00, 0x1F, 0x80, ##  00000                      000000 
            0xF8, 0x00, 0x00, 0x1F, 0x80, ##  00000                      000000 
            0xFC, 0x00, 0x00, 0x3F, 0x00, ##  000000                    000000  
            0xFE, 0x00, 0x00, 0x7F, 0x00, ##  0000000                  0000000  
            0xFF, 0x80, 0x00, 0xFE, 0x00, ##  000000000               0000000   
            0xFF, 0xF0, 0x07, 0xFC, 0x00, ##  000000000000         000000000    
            0x7F, 0xFF, 0xFF, 0xF0, 0x00, ##   000000000000000000000000000      
            0x07, 0xFF, 0xFF, 0xC0, 0x00, ##       000000000000000000000        
            0x00, 0x3F, 0xFC, 0x00, 0x00, ##            000000000000            
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '84' => {    # 'T'
        'width'    => 42, 
        'xoffset'  => 1, 
        'xadvance' => 44, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, ##  000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, ##  000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, ##  000000000000000000000000000000000000000000
            0xF0, 0x00, 0x7F, 0x00, 0x03, 0xC0, ##  0000             0000000              0000
            0xF0, 0x00, 0x7F, 0x00, 0x03, 0xC0, ##  0000             0000000              0000
            0xF0, 0x00, 0x7F, 0x00, 0x03, 0xC0, ##  0000             0000000              0000
            0xF0, 0x00, 0x7F, 0x00, 0x03, 0xC0, ##  0000             0000000              0000
            0xF0, 0x00, 0x7F, 0x00, 0x03, 0xC0, ##  0000             0000000              0000
            0xF0, 0x00, 0x7F, 0x00, 0x03, 0xC0, ##  0000             0000000              0000
            0xF0, 0x00, 0x7F, 0x00, 0x03, 0xC0, ##  0000             0000000              0000
            0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, ##                   0000000                  
            0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, ##                   0000000                  
            0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, ##                   0000000                  
            0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, ##                   0000000                  
            0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, ##                   0000000                  
            0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, ##                   0000000                  
            0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, ##                   0000000                  
            0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, ##                   0000000                  
            0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, ##                   0000000                  
            0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, ##                   0000000                  
            0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, ##                   0000000                  
            0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, ##                   0000000                  
            0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, ##                   0000000                  
            0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, ##                   0000000                  
            0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, ##                   0000000                  
            0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, ##                   0000000                  
            0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, ##                   0000000                  
            0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, ##                   0000000                  
            0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, ##                   0000000                  
            0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, ##                   0000000                  
            0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, ##                   0000000                  
            0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, ##                   0000000                  
            0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, ##                   0000000                  
            0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, ##                   0000000                  
            0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, ##                   0000000                  
            0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, ##                   0000000                  
            0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, ##                   0000000                  
            0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, ##                   0000000                  
            0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, ##                   0000000                  
            0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, ##                   0000000                  
            0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, ##                   0000000                  
            0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, ##                   0000000                  
            0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, ##                   0000000                  
            0x00, 0x0F, 0xFF, 0xFC, 0x00, 0x00, ##              000000000000000000            
            0x00, 0x0F, 0xFF, 0xFC, 0x00, 0x00, ##              000000000000000000            
            0x00, 0x0F, 0xFF, 0xFC, 0x00, 0x00, ##              000000000000000000            
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '85' => {    # 'U'
        'width'    => 48, 
        'xoffset'  => 3, 
        'xadvance' => 54, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xC0, 0x00, 0xFF, 0xFF, ##  000000000000000000              0000000000000000
            0xFF, 0xFF, 0xC0, 0x00, 0xFF, 0xFF, ##  000000000000000000              0000000000000000
            0xFF, 0xFF, 0xC0, 0x00, 0xFF, 0xFF, ##  000000000000000000              0000000000000000
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x07, 0xC0, ##        0000000                        00000      
            0x01, 0xFC, 0x00, 0x00, 0x07, 0x80, ##         0000000                       0000       
            0x01, 0xFC, 0x00, 0x00, 0x07, 0x80, ##         0000000                       0000       
            0x01, 0xFC, 0x00, 0x00, 0x07, 0x80, ##         0000000                       0000       
            0x01, 0xFE, 0x00, 0x00, 0x0F, 0x80, ##         00000000                     00000       
            0x00, 0xFE, 0x00, 0x00, 0x0F, 0x00, ##          0000000                     0000        
            0x00, 0xFF, 0x00, 0x00, 0x1F, 0x00, ##          00000000                   00000        
            0x00, 0x7F, 0x80, 0x00, 0x3E, 0x00, ##           00000000                 00000         
            0x00, 0x7F, 0xC0, 0x00, 0x7E, 0x00, ##           000000000               000000         
            0x00, 0x3F, 0xF8, 0x03, 0xFC, 0x00, ##            00000000000         00000000          
            0x00, 0x1F, 0xFF, 0xFF, 0xF8, 0x00, ##             00000000000000000000000000           
            0x00, 0x07, 0xFF, 0xFF, 0xF0, 0x00, ##               00000000000000000000000            
            0x00, 0x01, 0xFF, 0xFF, 0xC0, 0x00, ##                 0000000000000000000              
            0x00, 0x00, 0x3F, 0xFC, 0x00, 0x00, ##                    000000000000                  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '86' => {    # 'V'
        'width'    => 48, 
        'xoffset'  => -1, 
        'xadvance' => 46, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0x80, 0x00, 0x3F, 0xFF, ##  00000000000000000                 00000000000000
            0xFF, 0xFF, 0x80, 0x00, 0x3F, 0xFF, ##  00000000000000000                 00000000000000
            0xFF, 0xFF, 0x80, 0x00, 0x3F, 0xFF, ##  00000000000000000                 00000000000000
            0x07, 0xF0, 0x00, 0x00, 0x01, 0xE0, ##       0000000                           0000     
            0x07, 0xF0, 0x00, 0x00, 0x01, 0xE0, ##       0000000                           0000     
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xFC, 0x00, 0x00, 0x03, 0xC0, ##        00000000                        0000      
            0x01, 0xFC, 0x00, 0x00, 0x07, 0x80, ##         0000000                       0000       
            0x01, 0xFC, 0x00, 0x00, 0x07, 0x80, ##         0000000                       0000       
            0x00, 0xFE, 0x00, 0x00, 0x0F, 0x00, ##          0000000                     0000        
            0x00, 0xFE, 0x00, 0x00, 0x0F, 0x00, ##          0000000                     0000        
            0x00, 0xFE, 0x00, 0x00, 0x0F, 0x00, ##          0000000                     0000        
            0x00, 0x7F, 0x00, 0x00, 0x1E, 0x00, ##           0000000                   0000         
            0x00, 0x7F, 0x00, 0x00, 0x1E, 0x00, ##           0000000                   0000         
            0x00, 0x7F, 0x80, 0x00, 0x3C, 0x00, ##           00000000                 0000          
            0x00, 0x3F, 0x80, 0x00, 0x3C, 0x00, ##            0000000                 0000          
            0x00, 0x3F, 0x80, 0x00, 0x3C, 0x00, ##            0000000                 0000          
            0x00, 0x1F, 0xC0, 0x00, 0x78, 0x00, ##             0000000               0000           
            0x00, 0x1F, 0xC0, 0x00, 0x78, 0x00, ##             0000000               0000           
            0x00, 0x1F, 0xE0, 0x00, 0x78, 0x00, ##             00000000              0000           
            0x00, 0x0F, 0xE0, 0x00, 0xF0, 0x00, ##              0000000             0000            
            0x00, 0x0F, 0xE0, 0x00, 0xF0, 0x00, ##              0000000             0000            
            0x00, 0x07, 0xF0, 0x01, 0xE0, 0x00, ##               0000000           0000             
            0x00, 0x07, 0xF0, 0x01, 0xE0, 0x00, ##               0000000           0000             
            0x00, 0x07, 0xF8, 0x01, 0xE0, 0x00, ##               00000000          0000             
            0x00, 0x03, 0xF8, 0x03, 0xC0, 0x00, ##                0000000         0000              
            0x00, 0x03, 0xF8, 0x03, 0xC0, 0x00, ##                0000000         0000              
            0x00, 0x03, 0xFC, 0x07, 0x80, 0x00, ##                00000000       0000               
            0x00, 0x01, 0xFC, 0x07, 0x80, 0x00, ##                 0000000       0000               
            0x00, 0x01, 0xFC, 0x07, 0x80, 0x00, ##                 0000000       0000               
            0x00, 0x00, 0xFE, 0x0F, 0x00, 0x00, ##                  0000000     0000                
            0x00, 0x00, 0xFE, 0x0F, 0x00, 0x00, ##                  0000000     0000                
            0x00, 0x00, 0xFF, 0x1E, 0x00, 0x00, ##                  00000000   0000                 
            0x00, 0x00, 0x7F, 0x1E, 0x00, 0x00, ##                   0000000   0000                 
            0x00, 0x00, 0x7F, 0x1E, 0x00, 0x00, ##                   0000000   0000                 
            0x00, 0x00, 0x3F, 0xBC, 0x00, 0x00, ##                    0000000 0000                  
            0x00, 0x00, 0x3F, 0xBC, 0x00, 0x00, ##                    0000000 0000                  
            0x00, 0x00, 0x3F, 0xF8, 0x00, 0x00, ##                    00000000000                   
            0x00, 0x00, 0x1F, 0xF8, 0x00, 0x00, ##                     0000000000                   
            0x00, 0x00, 0x1F, 0xF8, 0x00, 0x00, ##                     0000000000                   
            0x00, 0x00, 0x1F, 0xF0, 0x00, 0x00, ##                     000000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x07, 0xE0, 0x00, 0x00, ##                       000000                     
            0x00, 0x00, 0x07, 0xE0, 0x00, 0x00, ##                       000000                     
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '87' => {    # 'W'
        'width'    => 65, 
        'xoffset'  => 1, 
        'xadvance' => 67, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0xFF, 0x80, 0x01, 0xF8, 0x00, 0x0F, 0xFF, 0x80, ##  00000000000000000              000000               0000000000000
            0x00, 0xFF, 0x80, 0x01, 0xF8, 0x00, 0x0F, 0xFF, 0x80, ##  00000000000000000              000000               0000000000000
            0x00, 0xFF, 0x80, 0x01, 0xF8, 0x00, 0x0F, 0xFF, 0x80, ##  00000000000000000              000000               0000000000000
            0x00, 0xE0, 0x00, 0x01, 0xFC, 0x00, 0x00, 0x70, 0x00, ##       000000                    0000000                   000     
            0x00, 0xF0, 0x00, 0x03, 0xFC, 0x00, 0x00, 0x70, 0x00, ##       0000000                  00000000                   000     
            0x00, 0xF0, 0x00, 0x03, 0xFC, 0x00, 0x00, 0xF0, 0x00, ##       0000000                  00000000                  0000     
            0x00, 0xF0, 0x00, 0x03, 0xFE, 0x00, 0x00, 0xF0, 0x00, ##        000000                  000000000                 0000     
            0x00, 0xF0, 0x00, 0x07, 0xFE, 0x00, 0x00, 0xE0, 0x00, ##        000000                 0000000000                 000      
            0x00, 0xF8, 0x00, 0x07, 0xFE, 0x00, 0x00, 0xE0, 0x00, ##        0000000                0000000000                 000      
            0x00, 0xF8, 0x00, 0x07, 0x7E, 0x00, 0x01, 0xE0, 0x00, ##        0000000                000 000000                0000      
            0x00, 0xF8, 0x00, 0x07, 0x7F, 0x00, 0x01, 0xC0, 0x00, ##         000000                000 0000000               000       
            0x00, 0xFC, 0x00, 0x0F, 0x3F, 0x00, 0x01, 0xC0, 0x00, ##         0000000              0000  000000               000       
            0x00, 0xFC, 0x00, 0x0F, 0x3F, 0x00, 0x01, 0xC0, 0x00, ##         0000000              0000  000000               000       
            0x00, 0xFC, 0x00, 0x0E, 0x3F, 0x80, 0x03, 0xC0, 0x00, ##          000000              000   0000000             0000       
            0x00, 0xFC, 0x00, 0x1E, 0x3F, 0x80, 0x03, 0x80, 0x00, ##          000000             0000   0000000             000        
            0x00, 0xFE, 0x00, 0x1E, 0x1F, 0x80, 0x03, 0x80, 0x00, ##          0000000            0000    000000             000        
            0x00, 0xFE, 0x00, 0x1C, 0x1F, 0x80, 0x07, 0x80, 0x00, ##          0000000            000     000000            0000        
            0x00, 0x7E, 0x00, 0x1C, 0x1F, 0xC0, 0x07, 0x80, 0x00, ##           000000            000     0000000           0000        
            0x00, 0x7F, 0x00, 0x3C, 0x0F, 0xC0, 0x07, 0x00, 0x00, ##           0000000          0000      000000           000         
            0x00, 0x7F, 0x00, 0x3C, 0x0F, 0xC0, 0x07, 0x00, 0x00, ##           0000000          0000      000000           000         
            0x00, 0x3F, 0x00, 0x38, 0x0F, 0xE0, 0x0F, 0x00, 0x00, ##            000000          000       0000000         0000         
            0x00, 0x3F, 0x00, 0x78, 0x0F, 0xE0, 0x0E, 0x00, 0x00, ##            000000         0000       0000000         000          
            0x00, 0x3F, 0x80, 0x78, 0x07, 0xE0, 0x0E, 0x00, 0x00, ##            0000000        0000        000000         000          
            0x00, 0x3F, 0x80, 0x70, 0x07, 0xE0, 0x1E, 0x00, 0x00, ##            0000000        000         000000        0000          
            0x00, 0x1F, 0x80, 0x70, 0x07, 0xF0, 0x1E, 0x00, 0x00, ##             000000        000         0000000       0000          
            0x00, 0x1F, 0xC0, 0xF0, 0x03, 0xF0, 0x1C, 0x00, 0x00, ##             0000000      0000          000000       000           
            0x00, 0x1F, 0xC0, 0xF0, 0x03, 0xF0, 0x1C, 0x00, 0x00, ##             0000000      0000          000000       000           
            0x00, 0x0F, 0xC0, 0xE0, 0x03, 0xF8, 0x3C, 0x00, 0x00, ##              000000      000           0000000     0000           
            0x00, 0x0F, 0xC1, 0xE0, 0x03, 0xF8, 0x38, 0x00, 0x00, ##              000000     0000           0000000     000            
            0x00, 0x0F, 0xE1, 0xE0, 0x01, 0xF8, 0x38, 0x00, 0x00, ##              0000000    0000            000000     000            
            0x00, 0x0F, 0xE1, 0xC0, 0x01, 0xFC, 0x38, 0x00, 0x00, ##              0000000    000             0000000    000            
            0x00, 0x07, 0xE1, 0xC0, 0x01, 0xFC, 0x78, 0x00, 0x00, ##               000000    000             0000000   0000            
            0x00, 0x07, 0xF3, 0xC0, 0x00, 0xFC, 0x70, 0x00, 0x00, ##               0000000  0000              000000   000             
            0x00, 0x07, 0xF3, 0xC0, 0x00, 0xFC, 0x70, 0x00, 0x00, ##               0000000  0000              000000   000             
            0x00, 0x03, 0xF3, 0x80, 0x00, 0xFE, 0xF0, 0x00, 0x00, ##                000000  000               0000000 0000             
            0x00, 0x03, 0xF7, 0x80, 0x00, 0xFE, 0xF0, 0x00, 0x00, ##                000000 0000               0000000 0000             
            0x00, 0x03, 0xFF, 0x80, 0x00, 0x7E, 0xE0, 0x00, 0x00, ##                00000000000                000000 000              
            0x00, 0x03, 0xFF, 0x00, 0x00, 0x7F, 0xE0, 0x00, 0x00, ##                0000000000                 0000000000              
            0x00, 0x01, 0xFF, 0x00, 0x00, 0x7F, 0xE0, 0x00, 0x00, ##                 000000000                 0000000000              
            0x00, 0x01, 0xFF, 0x00, 0x00, 0x3F, 0xC0, 0x00, 0x00, ##                 000000000                  00000000               
            0x00, 0x01, 0xFF, 0x00, 0x00, 0x3F, 0xC0, 0x00, 0x00, ##                 000000000                  00000000               
            0x00, 0x00, 0xFE, 0x00, 0x00, 0x3F, 0xC0, 0x00, 0x00, ##                  0000000                   00000000               
            0x00, 0x00, 0xFE, 0x00, 0x00, 0x3F, 0xC0, 0x00, 0x00, ##                  0000000                   00000000               
            0x00, 0x00, 0xFE, 0x00, 0x00, 0x1F, 0x80, 0x00, 0x00, ##                  0000000                    000000                
            0x00, 0x00, 0xFC, 0x00, 0x00, 0x1F, 0x80, 0x00, 0x00, ##                  000000                     000000                
            0x00, 0x00, 0x7C, 0x00, 0x00, 0x1F, 0x80, 0x00, 0x00, ##                   00000                     000000                
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '88' => {    # 'X'
        'width'    => 45, 
        'xoffset'  => 1, 
        'xadvance' => 47, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xE0, 0x0F, 0xFF, 0xE0, ##  0000000000000000000         000000000000000  
            0xFF, 0xFF, 0xE0, 0x0F, 0xFF, 0xE0, ##  0000000000000000000         000000000000000  
            0xFF, 0xFF, 0xE0, 0x0F, 0xFF, 0xE0, ##  0000000000000000000         000000000000000  
            0x07, 0xF8, 0x00, 0x00, 0x38, 0x00, ##       00000000                     000        
            0x03, 0xFC, 0x00, 0x00, 0x78, 0x00, ##        00000000                   0000        
            0x01, 0xFE, 0x00, 0x00, 0xF0, 0x00, ##         00000000                 0000         
            0x01, 0xFE, 0x00, 0x01, 0xE0, 0x00, ##         00000000                0000          
            0x00, 0xFF, 0x00, 0x01, 0xE0, 0x00, ##          00000000               0000          
            0x00, 0x7F, 0x80, 0x03, 0xC0, 0x00, ##           00000000             0000           
            0x00, 0x3F, 0x80, 0x07, 0x80, 0x00, ##            0000000            0000            
            0x00, 0x3F, 0xC0, 0x0F, 0x00, 0x00, ##            00000000          0000             
            0x00, 0x1F, 0xE0, 0x0F, 0x00, 0x00, ##             00000000         0000             
            0x00, 0x0F, 0xE0, 0x1E, 0x00, 0x00, ##              0000000        0000              
            0x00, 0x0F, 0xF0, 0x3C, 0x00, 0x00, ##              00000000      0000               
            0x00, 0x07, 0xF8, 0x3C, 0x00, 0x00, ##               00000000     0000               
            0x00, 0x03, 0xF8, 0x78, 0x00, 0x00, ##                0000000    0000                
            0x00, 0x03, 0xFC, 0xF0, 0x00, 0x00, ##                00000000  0000                 
            0x00, 0x01, 0xFF, 0xE0, 0x00, 0x00, ##                 000000000000                  
            0x00, 0x00, 0xFF, 0xE0, 0x00, 0x00, ##                  00000000000                  
            0x00, 0x00, 0xFF, 0xC0, 0x00, 0x00, ##                  0000000000                   
            0x00, 0x00, 0x7F, 0x80, 0x00, 0x00, ##                   00000000                    
            0x00, 0x00, 0x3F, 0x80, 0x00, 0x00, ##                    0000000                    
            0x00, 0x00, 0x3F, 0xC0, 0x00, 0x00, ##                    00000000                   
            0x00, 0x00, 0x1F, 0xE0, 0x00, 0x00, ##                     00000000                  
            0x00, 0x00, 0x3F, 0xE0, 0x00, 0x00, ##                    000000000                  
            0x00, 0x00, 0x3F, 0xF0, 0x00, 0x00, ##                    0000000000                 
            0x00, 0x00, 0x7F, 0xF8, 0x00, 0x00, ##                   000000000000                
            0x00, 0x00, 0xF3, 0xF8, 0x00, 0x00, ##                  0000  0000000                
            0x00, 0x01, 0xE3, 0xFC, 0x00, 0x00, ##                 0000   00000000               
            0x00, 0x01, 0xE1, 0xFE, 0x00, 0x00, ##                 0000    00000000              
            0x00, 0x03, 0xC0, 0xFF, 0x00, 0x00, ##                0000      00000000             
            0x00, 0x07, 0x80, 0xFF, 0x00, 0x00, ##               0000       00000000             
            0x00, 0x07, 0x80, 0x7F, 0x80, 0x00, ##               0000        00000000            
            0x00, 0x0F, 0x00, 0x3F, 0xC0, 0x00, ##              0000          00000000           
            0x00, 0x1E, 0x00, 0x1F, 0xC0, 0x00, ##             0000            0000000           
            0x00, 0x1C, 0x00, 0x1F, 0xE0, 0x00, ##             000             00000000          
            0x00, 0x3C, 0x00, 0x0F, 0xF0, 0x00, ##            0000              00000000         
            0x00, 0x78, 0x00, 0x07, 0xF0, 0x00, ##           0000                0000000         
            0x00, 0xF0, 0x00, 0x07, 0xF8, 0x00, ##          0000                 00000000        
            0x00, 0xF0, 0x00, 0x03, 0xFC, 0x00, ##          0000                  00000000       
            0x01, 0xE0, 0x00, 0x01, 0xFC, 0x00, ##         0000                    0000000       
            0x03, 0xC0, 0x00, 0x01, 0xFE, 0x00, ##        0000                     00000000      
            0x03, 0xC0, 0x00, 0x00, 0xFF, 0x00, ##        0000                      00000000     
            0xFF, 0xFE, 0x00, 0x3F, 0xFF, 0xF8, ##  000000000000000           0000000000000000000
            0xFF, 0xFE, 0x00, 0x3F, 0xFF, 0xF8, ##  000000000000000           0000000000000000000
            0xFF, 0xFE, 0x00, 0x3F, 0xFF, 0xF8, ##  000000000000000           0000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '89' => {    # 'Y'
        'width'    => 44, 
        'xoffset'  => -1, 
        'xadvance' => 43, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0x80, 0x03, 0xFF, 0xF0, ##  00000000000000000             00000000000000
            0xFF, 0xFF, 0x80, 0x03, 0xFF, 0xF0, ##  00000000000000000             00000000000000
            0xFF, 0xFF, 0x80, 0x03, 0xFF, 0xF0, ##  00000000000000000             00000000000000
            0x07, 0xF0, 0x00, 0x00, 0x1E, 0x00, ##       0000000                       0000     
            0x07, 0xF8, 0x00, 0x00, 0x3C, 0x00, ##       00000000                     0000      
            0x03, 0xFC, 0x00, 0x00, 0x3C, 0x00, ##        00000000                    0000      
            0x03, 0xFC, 0x00, 0x00, 0x78, 0x00, ##        00000000                   0000       
            0x01, 0xFE, 0x00, 0x00, 0xF8, 0x00, ##         00000000                 00000       
            0x00, 0xFE, 0x00, 0x00, 0xF0, 0x00, ##          0000000                 0000        
            0x00, 0xFF, 0x00, 0x01, 0xE0, 0x00, ##          00000000               0000         
            0x00, 0x7F, 0x80, 0x01, 0xE0, 0x00, ##           00000000              0000         
            0x00, 0x7F, 0x80, 0x03, 0xC0, 0x00, ##           00000000             0000          
            0x00, 0x3F, 0xC0, 0x07, 0x80, 0x00, ##            00000000           0000           
            0x00, 0x1F, 0xC0, 0x07, 0x80, 0x00, ##             0000000           0000           
            0x00, 0x1F, 0xE0, 0x0F, 0x00, 0x00, ##             00000000         0000            
            0x00, 0x0F, 0xF0, 0x1E, 0x00, 0x00, ##              00000000       0000             
            0x00, 0x0F, 0xF0, 0x1E, 0x00, 0x00, ##              00000000       0000             
            0x00, 0x07, 0xF8, 0x3C, 0x00, 0x00, ##               00000000     0000              
            0x00, 0x07, 0xF8, 0x7C, 0x00, 0x00, ##               00000000    00000              
            0x00, 0x03, 0xFC, 0x78, 0x00, 0x00, ##                00000000   0000               
            0x00, 0x01, 0xFC, 0xF0, 0x00, 0x00, ##                 0000000  0000                
            0x00, 0x01, 0xFE, 0xF0, 0x00, 0x00, ##                 00000000 0000                
            0x00, 0x00, 0xFF, 0xE0, 0x00, 0x00, ##                  00000000000                 
            0x00, 0x00, 0xFF, 0xC0, 0x00, 0x00, ##                  0000000000                  
            0x00, 0x00, 0x7F, 0xC0, 0x00, 0x00, ##                   000000000                  
            0x00, 0x00, 0x3F, 0x80, 0x00, 0x00, ##                    0000000                   
            0x00, 0x00, 0x3F, 0x80, 0x00, 0x00, ##                    0000000                   
            0x00, 0x00, 0x3F, 0x80, 0x00, 0x00, ##                    0000000                   
            0x00, 0x00, 0x3F, 0x80, 0x00, 0x00, ##                    0000000                   
            0x00, 0x00, 0x3F, 0x80, 0x00, 0x00, ##                    0000000                   
            0x00, 0x00, 0x3F, 0x80, 0x00, 0x00, ##                    0000000                   
            0x00, 0x00, 0x3F, 0x80, 0x00, 0x00, ##                    0000000                   
            0x00, 0x00, 0x3F, 0x80, 0x00, 0x00, ##                    0000000                   
            0x00, 0x00, 0x3F, 0x80, 0x00, 0x00, ##                    0000000                   
            0x00, 0x00, 0x3F, 0x80, 0x00, 0x00, ##                    0000000                   
            0x00, 0x00, 0x3F, 0x80, 0x00, 0x00, ##                    0000000                   
            0x00, 0x00, 0x3F, 0x80, 0x00, 0x00, ##                    0000000                   
            0x00, 0x00, 0x3F, 0x80, 0x00, 0x00, ##                    0000000                   
            0x00, 0x00, 0x3F, 0x80, 0x00, 0x00, ##                    0000000                   
            0x00, 0x00, 0x3F, 0x80, 0x00, 0x00, ##                    0000000                   
            0x00, 0x00, 0x3F, 0x80, 0x00, 0x00, ##                    0000000                   
            0x00, 0x00, 0x3F, 0x80, 0x00, 0x00, ##                    0000000                   
            0x00, 0x00, 0x3F, 0x80, 0x00, 0x00, ##                    0000000                   
            0x00, 0x07, 0xFF, 0xFE, 0x00, 0x00, ##               000000000000000000             
            0x00, 0x07, 0xFF, 0xFE, 0x00, 0x00, ##               000000000000000000             
            0x00, 0x07, 0xFF, 0xFE, 0x00, 0x00, ##               000000000000000000             
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '90' => {    # 'Z'
        'width'    => 39, 
        'xoffset'  => 3, 
        'xadvance' => 45, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x7F, 0xFF, 0xFF, 0xFF, 0xFC, ##   0000000000000000000000000000000000000 
            0x7F, 0xFF, 0xFF, 0xFF, 0xFC, ##   0000000000000000000000000000000000000 
            0x7F, 0xFF, 0xFF, 0xFF, 0xFC, ##   0000000000000000000000000000000000000 
            0x7F, 0xFF, 0xFF, 0xFF, 0xF8, ##   000000000000000000000000000000000000  
            0x78, 0x00, 0x00, 0x0F, 0xF0, ##   0000                       00000000   
            0x78, 0x00, 0x00, 0x0F, 0xF0, ##   0000                       00000000   
            0x78, 0x00, 0x00, 0x1F, 0xE0, ##   0000                      00000000    
            0x78, 0x00, 0x00, 0x3F, 0xC0, ##   0000                     00000000     
            0x78, 0x00, 0x00, 0x3F, 0x80, ##   0000                     0000000      
            0x78, 0x00, 0x00, 0x7F, 0x80, ##   0000                    00000000      
            0x78, 0x00, 0x00, 0xFF, 0x00, ##   0000                   00000000       
            0x00, 0x00, 0x00, 0xFE, 0x00, ##                          0000000        
            0x00, 0x00, 0x01, 0xFE, 0x00, ##                         00000000        
            0x00, 0x00, 0x03, 0xFC, 0x00, ##                        00000000         
            0x00, 0x00, 0x07, 0xF8, 0x00, ##                       00000000          
            0x00, 0x00, 0x07, 0xF0, 0x00, ##                       0000000           
            0x00, 0x00, 0x0F, 0xF0, 0x00, ##                      00000000           
            0x00, 0x00, 0x1F, 0xE0, 0x00, ##                     00000000            
            0x00, 0x00, 0x1F, 0xC0, 0x00, ##                     0000000             
            0x00, 0x00, 0x3F, 0xC0, 0x00, ##                    00000000             
            0x00, 0x00, 0x7F, 0x80, 0x00, ##                   00000000              
            0x00, 0x00, 0xFF, 0x00, 0x00, ##                  00000000               
            0x00, 0x00, 0xFF, 0x00, 0x00, ##                  00000000               
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000                
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000                 
            0x00, 0x03, 0xF8, 0x00, 0x00, ##                0000000                  
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                  
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000                   
            0x00, 0x1F, 0xE0, 0x00, 0x00, ##             00000000                    
            0x00, 0x1F, 0xE0, 0x00, 0x00, ##             00000000                    
            0x00, 0x3F, 0xC0, 0x00, 0x00, ##            00000000                     
            0x00, 0x7F, 0x80, 0x00, 0x00, ##           00000000                      
            0x00, 0x7F, 0x00, 0x00, 0x00, ##           0000000                       
            0x00, 0xFF, 0x00, 0x00, 0x00, ##          00000000                       
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                        
            0x03, 0xFC, 0x00, 0x00, 0x00, ##        00000000                         
            0x03, 0xFC, 0x00, 0x00, 0x1E, ##        00000000                     0000
            0x07, 0xF8, 0x00, 0x00, 0x1E, ##       00000000                      0000
            0x0F, 0xF0, 0x00, 0x00, 0x1E, ##      00000000                       0000
            0x0F, 0xE0, 0x00, 0x00, 0x1E, ##      0000000                        0000
            0x1F, 0xE0, 0x00, 0x00, 0x1E, ##     00000000                        0000
            0x3F, 0xC0, 0x00, 0x00, 0x1E, ##    00000000                         0000
            0x3F, 0x80, 0x00, 0x00, 0x1E, ##    0000000                          0000
            0x7F, 0xFF, 0xFF, 0xFF, 0xFE, ##   00000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFE, ##  000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFE, ##  000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFE, ##  000000000000000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '91' => {    # '['
        'width'    => 15, 
        'xoffset'  => 5, 
        'xadvance' => 24, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xFE, ##  000000000000000
            0xFF, 0xFE, ##  000000000000000
            0xFF, 0xFE, ##  000000000000000
            0xFC, 0x00, ##  000000         
            0xFC, 0x00, ##  000000         
            0xFC, 0x00, ##  000000         
            0xFC, 0x00, ##  000000         
            0xFC, 0x00, ##  000000         
            0xFC, 0x00, ##  000000         
            0xFC, 0x00, ##  000000         
            0xFC, 0x00, ##  000000         
            0xFC, 0x00, ##  000000         
            0xFC, 0x00, ##  000000         
            0xFC, 0x00, ##  000000         
            0xFC, 0x00, ##  000000         
            0xFC, 0x00, ##  000000         
            0xFC, 0x00, ##  000000         
            0xFC, 0x00, ##  000000         
            0xFC, 0x00, ##  000000         
            0xFC, 0x00, ##  000000         
            0xFC, 0x00, ##  000000         
            0xFC, 0x00, ##  000000         
            0xFC, 0x00, ##  000000         
            0xFC, 0x00, ##  000000         
            0xFC, 0x00, ##  000000         
            0xFC, 0x00, ##  000000         
            0xFC, 0x00, ##  000000         
            0xFC, 0x00, ##  000000         
            0xFC, 0x00, ##  000000         
            0xFC, 0x00, ##  000000         
            0xFC, 0x00, ##  000000         
            0xFC, 0x00, ##  000000         
            0xFC, 0x00, ##  000000         
            0xFC, 0x00, ##  000000         
            0xFC, 0x00, ##  000000         
            0xFC, 0x00, ##  000000         
            0xFC, 0x00, ##  000000         
            0xFC, 0x00, ##  000000         
            0xFC, 0x00, ##  000000         
            0xFC, 0x00, ##  000000         
            0xFC, 0x00, ##  000000         
            0xFC, 0x00, ##  000000         
            0xFC, 0x00, ##  000000         
            0xFC, 0x00, ##  000000         
            0xFC, 0x00, ##  000000         
            0xFC, 0x00, ##  000000         
            0xFC, 0x00, ##  000000         
            0xFC, 0x00, ##  000000         
            0xFC, 0x00, ##  000000         
            0xFC, 0x00, ##  000000         
            0xFC, 0x00, ##  000000         
            0xFC, 0x00, ##  000000         
            0xFC, 0x00, ##  000000         
            0xFC, 0x00, ##  000000         
            0xFF, 0xFE, ##  000000000000000
            0xFF, 0xFE, ##  000000000000000
            0xFF, 0xFE, ##  000000000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '92' => {    # '\'
        'width'    => 22, 
        'xoffset'  => 0, 
        'xadvance' => 22, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xF8, 0x00, 0x00, ##  00000                 
            0xF8, 0x00, 0x00, ##  00000                 
            0x7C, 0x00, 0x00, ##   00000                
            0x7C, 0x00, 0x00, ##   00000                
            0x7C, 0x00, 0x00, ##   00000                
            0x3E, 0x00, 0x00, ##    00000               
            0x3E, 0x00, 0x00, ##    00000               
            0x3E, 0x00, 0x00, ##    00000               
            0x1F, 0x00, 0x00, ##     00000              
            0x1F, 0x00, 0x00, ##     00000              
            0x1F, 0x00, 0x00, ##     00000              
            0x1F, 0x00, 0x00, ##     00000              
            0x0F, 0x80, 0x00, ##      00000             
            0x0F, 0x80, 0x00, ##      00000             
            0x0F, 0x80, 0x00, ##      00000             
            0x07, 0xC0, 0x00, ##       00000            
            0x07, 0xC0, 0x00, ##       00000            
            0x07, 0xC0, 0x00, ##       00000            
            0x03, 0xE0, 0x00, ##        00000           
            0x03, 0xE0, 0x00, ##        00000           
            0x03, 0xE0, 0x00, ##        00000           
            0x01, 0xF0, 0x00, ##         00000          
            0x01, 0xF0, 0x00, ##         00000          
            0x01, 0xF0, 0x00, ##         00000          
            0x00, 0xF8, 0x00, ##          00000         
            0x00, 0xF8, 0x00, ##          00000         
            0x00, 0xF8, 0x00, ##          00000         
            0x00, 0x7C, 0x00, ##           00000        
            0x00, 0x7C, 0x00, ##           00000        
            0x00, 0x7C, 0x00, ##           00000        
            0x00, 0x7C, 0x00, ##           00000        
            0x00, 0x3E, 0x00, ##            00000       
            0x00, 0x3E, 0x00, ##            00000       
            0x00, 0x3E, 0x00, ##            00000       
            0x00, 0x1F, 0x00, ##             00000      
            0x00, 0x1F, 0x00, ##             00000      
            0x00, 0x1F, 0x00, ##             00000      
            0x00, 0x0F, 0x80, ##              00000     
            0x00, 0x0F, 0x80, ##              00000     
            0x00, 0x0F, 0x80, ##              00000     
            0x00, 0x07, 0xC0, ##               00000    
            0x00, 0x07, 0xC0, ##               00000    
            0x00, 0x07, 0xC0, ##               00000    
            0x00, 0x03, 0xE0, ##                00000   
            0x00, 0x03, 0xE0, ##                00000   
            0x00, 0x03, 0xE0, ##                00000   
            0x00, 0x01, 0xF0, ##                 00000  
            0x00, 0x01, 0xF0, ##                 00000  
            0x00, 0x01, 0xF0, ##                 00000  
            0x00, 0x01, 0xF0, ##                 00000  
            0x00, 0x00, 0xF8, ##                  00000 
            0x00, 0x00, 0xF8, ##                  00000 
            0x00, 0x00, 0xF8, ##                  00000 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '93' => {    # ']'
        'width'    => 14, 
        'xoffset'  => 5, 
        'xadvance' => 25, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xFC, ##  00000000000000
            0xFF, 0xFC, ##  00000000000000
            0xFF, 0xFC, ##  00000000000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0xFF, 0xFC, ##  00000000000000
            0xFF, 0xFC, ##  00000000000000
            0xFF, 0xFC, ##  00000000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '94' => {    # '^'
        'width'    => 40, 
        'xoffset'  => 7, 
        'xadvance' => 54, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x7E, 0x00, 0x00, ##                   000000                 
            0x00, 0x00, 0xFF, 0x00, 0x00, ##                  00000000                
            0x00, 0x01, 0xFF, 0x80, 0x00, ##                 0000000000               
            0x00, 0x03, 0xFF, 0xC0, 0x00, ##                000000000000              
            0x00, 0x07, 0xFF, 0xE0, 0x00, ##               00000000000000             
            0x00, 0x0F, 0xFF, 0xF0, 0x00, ##              0000000000000000            
            0x00, 0x1F, 0xEF, 0xF8, 0x00, ##             00000000 000000000           
            0x00, 0x3F, 0xC3, 0xFC, 0x00, ##            00000000    00000000          
            0x00, 0x7F, 0x81, 0xFE, 0x00, ##           00000000      00000000         
            0x00, 0xFE, 0x00, 0xFF, 0x00, ##          0000000         00000000        
            0x01, 0xFC, 0x00, 0x3F, 0x80, ##         0000000            0000000       
            0x03, 0xF8, 0x00, 0x1F, 0xC0, ##        0000000              0000000      
            0x07, 0xF0, 0x00, 0x0F, 0xE0, ##       0000000                0000000     
            0x0F, 0xC0, 0x00, 0x07, 0xE0, ##      000000                   000000     
            0x1F, 0x80, 0x00, 0x01, 0xF0, ##     000000                      00000    
            0x3F, 0x00, 0x00, 0x00, 0xF8, ##    000000                        00000   
            0x7E, 0x00, 0x00, 0x00, 0x7C, ##   000000                          00000  
            0xF8, 0x00, 0x00, 0x00, 0x3E, ##  00000                             00000 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '95' => {    # '_'
        'width'    => 32, 
        'xoffset'  => 0, 
        'xadvance' => 32, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFF, 0xFF, ##  00000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, ##  00000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, ##  00000000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '96' => {    # '`'
        'width'    => 15, 
        'xoffset'  => 5, 
        'xadvance' => 32, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFC, 0x00, ##  000000         
            0x7E, 0x00, ##   000000        
            0x3F, 0x00, ##    000000       
            0x1F, 0x80, ##     000000      
            0x0F, 0x80, ##      00000      
            0x07, 0xC0, ##       00000     
            0x03, 0xE0, ##        00000    
            0x01, 0xE0, ##         0000    
            0x00, 0xF0, ##          0000   
            0x00, 0x78, ##           0000  
            0x00, 0x3C, ##            0000 
            0x00, 0x3C, ##            0000 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '97' => {    # 'a'
        'width'    => 33, 
        'xoffset'  => 3, 
        'xadvance' => 38, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x7F, 0xE0, 0x00, 0x00, ##           0000000000              
            0x07, 0xFF, 0xFC, 0x00, 0x00, ##       00000000000000000           
            0x1F, 0xFF, 0xFE, 0x00, 0x00, ##     00000000000000000000          
            0x1F, 0xE0, 0x7F, 0x00, 0x00, ##     00000000      0000000         
            0x1F, 0x80, 0x1F, 0x80, 0x00, ##     000000          000000        
            0x1F, 0x00, 0x0F, 0xC0, 0x00, ##     00000            000000       
            0x1E, 0x00, 0x07, 0xE0, 0x00, ##     0000              000000      
            0x1E, 0x00, 0x07, 0xE0, 0x00, ##     0000              000000      
            0x1C, 0x00, 0x03, 0xE0, 0x00, ##     000                00000      
            0x1C, 0x00, 0x03, 0xF0, 0x00, ##     000                000000     
            0x00, 0x00, 0x03, 0xF0, 0x00, ##                        000000     
            0x00, 0x00, 0x03, 0xF0, 0x00, ##                        000000     
            0x00, 0x00, 0x03, 0xF0, 0x00, ##                        000000     
            0x00, 0x00, 0x03, 0xF0, 0x00, ##                        000000     
            0x00, 0x7F, 0xFF, 0xF0, 0x00, ##           0000000000000000000     
            0x03, 0xFF, 0xFF, 0xF0, 0x00, ##        0000000000000000000000     
            0x0F, 0xFF, 0xFF, 0xF0, 0x00, ##      000000000000000000000000     
            0x1F, 0xE0, 0x03, 0xF0, 0x00, ##     00000000           000000     
            0x3F, 0x80, 0x03, 0xF0, 0x00, ##    0000000             000000     
            0x7F, 0x00, 0x03, 0xF0, 0x00, ##   0000000              000000     
            0x7F, 0x00, 0x03, 0xF0, 0x00, ##   0000000              000000     
            0xFE, 0x00, 0x03, 0xF0, 0x00, ##  0000000               000000     
            0xFE, 0x00, 0x03, 0xF0, 0x00, ##  0000000               000000     
            0xFE, 0x00, 0x03, 0xF0, 0x00, ##  0000000               000000     
            0xFE, 0x00, 0x03, 0xF0, 0x00, ##  0000000               000000     
            0xFE, 0x00, 0x03, 0xF0, 0x00, ##  0000000               000000     
            0xFE, 0x00, 0x03, 0xF0, 0x00, ##  0000000               000000     
            0xFE, 0x00, 0x07, 0xF0, 0x00, ##  0000000              0000000     
            0x7F, 0x00, 0x07, 0xF0, 0x00, ##   0000000             0000000     
            0x7F, 0x80, 0x0F, 0xF0, 0x00, ##   00000000           00000000     
            0x3F, 0xC0, 0x1F, 0xF0, 0x00, ##    00000000         000000000     
            0x3F, 0xE0, 0x7B, 0xFF, 0x80, ##    000000000      0000 00000000000
            0x0F, 0xFF, 0xF3, 0xFF, 0x80, ##      0000000000000000  00000000000
            0x07, 0xFF, 0xE3, 0xFF, 0x80, ##       00000000000000   00000000000
            0x00, 0xFF, 0x00, 0x00, 0x00, ##          00000000                 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '98' => {    # 'b'
        'width'    => 36, 
        'xoffset'  => 2, 
        'xadvance' => 41, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xE0, 0x00, 0x00, 0x00, ##  00000000000                         
            0xFF, 0xE0, 0x00, 0x00, 0x00, ##  00000000000                         
            0xFF, 0xE0, 0x00, 0x00, 0x00, ##  00000000000                         
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                         
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                         
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                         
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                         
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                         
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                         
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                         
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                         
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                         
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                         
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                         
            0x07, 0xE0, 0x3F, 0xC0, 0x00, ##       000000       00000000          
            0x07, 0xE1, 0xFF, 0xF0, 0x00, ##       000000    0000000000000        
            0x07, 0xE3, 0xFF, 0xFC, 0x00, ##       000000   0000000000000000      
            0x07, 0xE7, 0x81, 0xFE, 0x00, ##       000000  0000      00000000     
            0x07, 0xEE, 0x00, 0x7F, 0x00, ##       000000 000          0000000    
            0x07, 0xFC, 0x00, 0x3F, 0x80, ##       000000000            0000000   
            0x07, 0xF8, 0x00, 0x1F, 0x80, ##       00000000              000000   
            0x07, 0xF8, 0x00, 0x1F, 0xC0, ##       00000000              0000000  
            0x07, 0xF0, 0x00, 0x0F, 0xC0, ##       0000000                000000  
            0x07, 0xF0, 0x00, 0x0F, 0xE0, ##       0000000                0000000 
            0x07, 0xF0, 0x00, 0x0F, 0xE0, ##       0000000                0000000 
            0x07, 0xE0, 0x00, 0x0F, 0xE0, ##       000000                 0000000 
            0x07, 0xE0, 0x00, 0x07, 0xF0, ##       000000                  0000000
            0x07, 0xE0, 0x00, 0x07, 0xF0, ##       000000                  0000000
            0x07, 0xE0, 0x00, 0x07, 0xF0, ##       000000                  0000000
            0x07, 0xE0, 0x00, 0x07, 0xF0, ##       000000                  0000000
            0x07, 0xE0, 0x00, 0x07, 0xF0, ##       000000                  0000000
            0x07, 0xE0, 0x00, 0x07, 0xF0, ##       000000                  0000000
            0x07, 0xE0, 0x00, 0x07, 0xF0, ##       000000                  0000000
            0x07, 0xE0, 0x00, 0x07, 0xF0, ##       000000                  0000000
            0x07, 0xE0, 0x00, 0x07, 0xF0, ##       000000                  0000000
            0x07, 0xE0, 0x00, 0x07, 0xF0, ##       000000                  0000000
            0x07, 0xE0, 0x00, 0x07, 0xF0, ##       000000                  0000000
            0x07, 0xE0, 0x00, 0x0F, 0xE0, ##       000000                 0000000 
            0x07, 0xF0, 0x00, 0x0F, 0xE0, ##       0000000                0000000 
            0x07, 0xF0, 0x00, 0x0F, 0xE0, ##       0000000                0000000 
            0x07, 0xF0, 0x00, 0x0F, 0xC0, ##       0000000                000000  
            0x07, 0xF8, 0x00, 0x1F, 0xC0, ##       00000000              0000000  
            0x07, 0xF8, 0x00, 0x1F, 0x80, ##       00000000              000000   
            0x07, 0xFC, 0x00, 0x3F, 0x80, ##       000000000            0000000   
            0x07, 0xEE, 0x00, 0x7F, 0x00, ##       000000 000          0000000    
            0xFF, 0xE7, 0x81, 0xFE, 0x00, ##  00000000000  0000      00000000     
            0xFF, 0xE3, 0xFF, 0xFC, 0x00, ##  00000000000   0000000000000000      
            0xFF, 0xE1, 0xFF, 0xF0, 0x00, ##  00000000000    0000000000000        
            0x00, 0x00, 0x3F, 0xC0, 0x00, ##                    00000000          
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '99' => {    # 'c'
        'width'    => 30, 
        'xoffset'  => 3, 
        'xadvance' => 36, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x0F, 0xF8, 0x00, ##              000000000         
            0x00, 0x7F, 0xFF, 0x80, ##           0000000000000000     
            0x01, 0xFF, 0xFF, 0xF0, ##         000000000000000000000  
            0x03, 0xF8, 0x0F, 0xF8, ##        0000000       000000000 
            0x07, 0xE0, 0x03, 0xF8, ##       000000           0000000 
            0x0F, 0xC0, 0x01, 0xF8, ##      000000             000000 
            0x1F, 0x80, 0x00, 0xF8, ##     000000               00000 
            0x3F, 0x80, 0x00, 0xF8, ##    0000000               00000 
            0x3F, 0x00, 0x00, 0x78, ##    000000                 0000 
            0x7F, 0x00, 0x00, 0x78, ##   0000000                 0000 
            0x7F, 0x00, 0x00, 0x78, ##   0000000                 0000 
            0x7F, 0x00, 0x00, 0x00, ##   0000000                      
            0xFE, 0x00, 0x00, 0x00, ##  0000000                       
            0xFE, 0x00, 0x00, 0x00, ##  0000000                       
            0xFE, 0x00, 0x00, 0x00, ##  0000000                       
            0xFE, 0x00, 0x00, 0x00, ##  0000000                       
            0xFE, 0x00, 0x00, 0x00, ##  0000000                       
            0xFE, 0x00, 0x00, 0x00, ##  0000000                       
            0xFE, 0x00, 0x00, 0x00, ##  0000000                       
            0xFE, 0x00, 0x00, 0x00, ##  0000000                       
            0xFE, 0x00, 0x00, 0x00, ##  0000000                       
            0xFE, 0x00, 0x00, 0x00, ##  0000000                       
            0xFE, 0x00, 0x00, 0x00, ##  0000000                       
            0x7E, 0x00, 0x00, 0x00, ##   000000                       
            0x7F, 0x00, 0x00, 0x7C, ##   0000000                 00000
            0x7F, 0x00, 0x00, 0x78, ##   0000000                 0000 
            0x3F, 0x00, 0x00, 0xF8, ##    000000                00000 
            0x3F, 0x80, 0x00, 0xF8, ##    0000000               00000 
            0x1F, 0x80, 0x01, 0xF0, ##     000000              00000  
            0x0F, 0xC0, 0x01, 0xE0, ##      000000             0000   
            0x07, 0xE0, 0x07, 0xE0, ##       000000          000000   
            0x03, 0xF8, 0x0F, 0xC0, ##        0000000       000000    
            0x01, 0xFF, 0xFF, 0x80, ##         000000000000000000     
            0x00, 0x7F, 0xFE, 0x00, ##           00000000000000       
            0x00, 0x0F, 0xF0, 0x00, ##              00000000          
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '100' => {    # 'd'
        'width'    => 36, 
        'xoffset'  => 3, 
        'xadvance' => 41, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x0F, 0xFE, 0x00, ##                      00000000000     
            0x00, 0x00, 0x0F, 0xFE, 0x00, ##                      00000000000     
            0x00, 0x00, 0x0F, 0xFE, 0x00, ##                      00000000000     
            0x00, 0x00, 0x00, 0x7E, 0x00, ##                           000000     
            0x00, 0x00, 0x00, 0x7E, 0x00, ##                           000000     
            0x00, 0x00, 0x00, 0x7E, 0x00, ##                           000000     
            0x00, 0x00, 0x00, 0x7E, 0x00, ##                           000000     
            0x00, 0x00, 0x00, 0x7E, 0x00, ##                           000000     
            0x00, 0x00, 0x00, 0x7E, 0x00, ##                           000000     
            0x00, 0x00, 0x00, 0x7E, 0x00, ##                           000000     
            0x00, 0x00, 0x00, 0x7E, 0x00, ##                           000000     
            0x00, 0x00, 0x00, 0x7E, 0x00, ##                           000000     
            0x00, 0x00, 0x00, 0x7E, 0x00, ##                           000000     
            0x00, 0x00, 0x00, 0x7E, 0x00, ##                           000000     
            0x00, 0x3F, 0xC0, 0x7E, 0x00, ##            00000000       000000     
            0x00, 0xFF, 0xF8, 0x7E, 0x00, ##          0000000000000    000000     
            0x03, 0xFF, 0xFC, 0x7E, 0x00, ##        0000000000000000   000000     
            0x07, 0xF8, 0x1E, 0x7E, 0x00, ##       00000000      0000  000000     
            0x0F, 0xE0, 0x07, 0x7E, 0x00, ##      0000000          000 000000     
            0x1F, 0xC0, 0x03, 0xFE, 0x00, ##     0000000            000000000     
            0x1F, 0x80, 0x01, 0xFE, 0x00, ##     000000              00000000     
            0x3F, 0x80, 0x01, 0xFE, 0x00, ##    0000000              00000000     
            0x3F, 0x00, 0x00, 0xFE, 0x00, ##    000000                0000000     
            0x7F, 0x00, 0x00, 0xFE, 0x00, ##   0000000                0000000     
            0x7F, 0x00, 0x00, 0xFE, 0x00, ##   0000000                0000000     
            0x7F, 0x00, 0x00, 0x7E, 0x00, ##   0000000                 000000     
            0xFE, 0x00, 0x00, 0x7E, 0x00, ##  0000000                  000000     
            0xFE, 0x00, 0x00, 0x7E, 0x00, ##  0000000                  000000     
            0xFE, 0x00, 0x00, 0x7E, 0x00, ##  0000000                  000000     
            0xFE, 0x00, 0x00, 0x7E, 0x00, ##  0000000                  000000     
            0xFE, 0x00, 0x00, 0x7E, 0x00, ##  0000000                  000000     
            0xFE, 0x00, 0x00, 0x7E, 0x00, ##  0000000                  000000     
            0xFE, 0x00, 0x00, 0x7E, 0x00, ##  0000000                  000000     
            0xFE, 0x00, 0x00, 0x7E, 0x00, ##  0000000                  000000     
            0xFE, 0x00, 0x00, 0x7E, 0x00, ##  0000000                  000000     
            0xFE, 0x00, 0x00, 0x7E, 0x00, ##  0000000                  000000     
            0xFE, 0x00, 0x00, 0x7E, 0x00, ##  0000000                  000000     
            0x7E, 0x00, 0x00, 0x7E, 0x00, ##   000000                  000000     
            0x7F, 0x00, 0x00, 0xFE, 0x00, ##   0000000                0000000     
            0x7F, 0x00, 0x00, 0xFE, 0x00, ##   0000000                0000000     
            0x3F, 0x00, 0x00, 0xFE, 0x00, ##    000000                0000000     
            0x3F, 0x80, 0x01, 0xFE, 0x00, ##    0000000              00000000     
            0x1F, 0x80, 0x01, 0xFE, 0x00, ##     000000              00000000     
            0x1F, 0xC0, 0x03, 0xFE, 0x00, ##     0000000            000000000     
            0x0F, 0xE0, 0x07, 0x7E, 0x00, ##      0000000          000 000000     
            0x07, 0xF8, 0x1E, 0x7F, 0xF0, ##       00000000      0000  00000000000
            0x03, 0xFF, 0xFC, 0x7F, 0xF0, ##        0000000000000000   00000000000
            0x00, 0xFF, 0xF8, 0x7F, 0xF0, ##          0000000000000    00000000000
            0x00, 0x3F, 0xC0, 0x00, 0x00, ##            00000000                  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '101' => {    # 'e'
        'width'    => 32, 
        'xoffset'  => 3, 
        'xadvance' => 38, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x0F, 0xF8, 0x00, ##              000000000           
            0x00, 0x7F, 0xFF, 0x00, ##           000000000000000        
            0x01, 0xFF, 0xFF, 0x80, ##         000000000000000000       
            0x03, 0xF8, 0x1F, 0xE0, ##        0000000      00000000     
            0x07, 0xE0, 0x07, 0xF0, ##       000000          0000000    
            0x0F, 0xC0, 0x03, 0xF8, ##      000000            0000000   
            0x1F, 0x80, 0x01, 0xF8, ##     000000              000000   
            0x3F, 0x80, 0x00, 0xFC, ##    0000000               000000  
            0x3F, 0x00, 0x00, 0xFC, ##    000000                000000  
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x7F, 0x00, 0x00, 0x7E, ##   0000000                 000000 
            0x7F, 0x00, 0x00, 0x7E, ##   0000000                 000000 
            0xFE, 0x00, 0x00, 0x7E, ##  0000000                  000000 
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFF, 0xFF, 0xFF, 0xFF, ##  00000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, ##  00000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, ##  00000000000000000000000000000000
            0xFE, 0x00, 0x00, 0x00, ##  0000000                         
            0xFE, 0x00, 0x00, 0x00, ##  0000000                         
            0xFE, 0x00, 0x00, 0x00, ##  0000000                         
            0xFE, 0x00, 0x00, 0x00, ##  0000000                         
            0xFE, 0x00, 0x00, 0x00, ##  0000000                         
            0x7E, 0x00, 0x00, 0x00, ##   000000                         
            0x7F, 0x00, 0x00, 0x1E, ##   0000000                   0000 
            0x7F, 0x00, 0x00, 0x3E, ##   0000000                  00000 
            0x3F, 0x00, 0x00, 0x3E, ##    000000                  00000 
            0x3F, 0x80, 0x00, 0x7C, ##    0000000                00000  
            0x1F, 0xC0, 0x00, 0x7C, ##     0000000               00000  
            0x0F, 0xC0, 0x00, 0xF8, ##      000000              00000   
            0x07, 0xF0, 0x01, 0xF0, ##       0000000           00000    
            0x03, 0xFC, 0x07, 0xE0, ##        00000000       000000     
            0x01, 0xFF, 0xFF, 0xC0, ##         0000000000000000000      
            0x00, 0x7F, 0xFF, 0x00, ##           000000000000000        
            0x00, 0x0F, 0xF8, 0x00, ##              000000000           
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '102' => {    # 'f'
        'width'    => 25, 
        'xoffset'  => 2, 
        'xadvance' => 23, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x0F, 0xF8, 0x00, ##              000000000    
            0x00, 0x3F, 0xFF, 0x80, ##            000000000000000
            0x00, 0xFF, 0xFF, 0x80, ##          00000000000000000
            0x01, 0xFC, 0x0F, 0x80, ##         0000000      00000
            0x01, 0xF8, 0x07, 0x80, ##         000000        0000
            0x03, 0xF0, 0x03, 0x80, ##        000000          000
            0x03, 0xE0, 0x03, 0x80, ##        00000           000
            0x07, 0xE0, 0x03, 0x80, ##       000000           000
            0x07, 0xE0, 0x00, 0x00, ##       000000              
            0x07, 0xE0, 0x00, 0x00, ##       000000              
            0x07, 0xE0, 0x00, 0x00, ##       000000              
            0x07, 0xE0, 0x00, 0x00, ##       000000              
            0x07, 0xE0, 0x00, 0x00, ##       000000              
            0x07, 0xE0, 0x00, 0x00, ##       000000              
            0x07, 0xE0, 0x00, 0x00, ##       000000              
            0xFF, 0xFF, 0xF8, 0x00, ##  000000000000000000000    
            0xFF, 0xFF, 0xF8, 0x00, ##  000000000000000000000    
            0xFF, 0xFF, 0xF8, 0x00, ##  000000000000000000000    
            0x07, 0xE0, 0x00, 0x00, ##       000000              
            0x07, 0xE0, 0x00, 0x00, ##       000000              
            0x07, 0xE0, 0x00, 0x00, ##       000000              
            0x07, 0xE0, 0x00, 0x00, ##       000000              
            0x07, 0xE0, 0x00, 0x00, ##       000000              
            0x07, 0xE0, 0x00, 0x00, ##       000000              
            0x07, 0xE0, 0x00, 0x00, ##       000000              
            0x07, 0xE0, 0x00, 0x00, ##       000000              
            0x07, 0xE0, 0x00, 0x00, ##       000000              
            0x07, 0xE0, 0x00, 0x00, ##       000000              
            0x07, 0xE0, 0x00, 0x00, ##       000000              
            0x07, 0xE0, 0x00, 0x00, ##       000000              
            0x07, 0xE0, 0x00, 0x00, ##       000000              
            0x07, 0xE0, 0x00, 0x00, ##       000000              
            0x07, 0xE0, 0x00, 0x00, ##       000000              
            0x07, 0xE0, 0x00, 0x00, ##       000000              
            0x07, 0xE0, 0x00, 0x00, ##       000000              
            0x07, 0xE0, 0x00, 0x00, ##       000000              
            0x07, 0xE0, 0x00, 0x00, ##       000000              
            0x07, 0xE0, 0x00, 0x00, ##       000000              
            0x07, 0xE0, 0x00, 0x00, ##       000000              
            0x07, 0xE0, 0x00, 0x00, ##       000000              
            0x07, 0xE0, 0x00, 0x00, ##       000000              
            0x07, 0xE0, 0x00, 0x00, ##       000000              
            0x07, 0xE0, 0x00, 0x00, ##       000000              
            0x07, 0xE0, 0x00, 0x00, ##       000000              
            0x07, 0xE0, 0x00, 0x00, ##       000000              
            0xFF, 0xFF, 0xE0, 0x00, ##  0000000000000000000      
            0xFF, 0xFF, 0xE0, 0x00, ##  0000000000000000000      
            0xFF, 0xFF, 0xE0, 0x00, ##  0000000000000000000      
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '103' => {    # 'g'
        'width'    => 36, 
        'xoffset'  => 3, 
        'xadvance' => 41, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x3F, 0xC0, 0x00, 0x00, ##            00000000                  
            0x00, 0xFF, 0xF8, 0x7F, 0xF0, ##          0000000000000    00000000000
            0x03, 0xFF, 0xFC, 0x7F, 0xF0, ##        0000000000000000   00000000000
            0x07, 0xF8, 0x1E, 0x7F, 0xF0, ##       00000000      0000  00000000000
            0x0F, 0xE0, 0x07, 0x7E, 0x00, ##      0000000          000 000000     
            0x1F, 0xC0, 0x03, 0xFE, 0x00, ##     0000000            000000000     
            0x1F, 0x80, 0x01, 0xFE, 0x00, ##     000000              00000000     
            0x3F, 0x80, 0x01, 0xFE, 0x00, ##    0000000              00000000     
            0x3F, 0x00, 0x00, 0xFE, 0x00, ##    000000                0000000     
            0x7F, 0x00, 0x00, 0xFE, 0x00, ##   0000000                0000000     
            0x7F, 0x00, 0x00, 0x7E, 0x00, ##   0000000                 000000     
            0x7E, 0x00, 0x00, 0x7E, 0x00, ##   000000                  000000     
            0xFE, 0x00, 0x00, 0x7E, 0x00, ##  0000000                  000000     
            0xFE, 0x00, 0x00, 0x7E, 0x00, ##  0000000                  000000     
            0xFE, 0x00, 0x00, 0x7E, 0x00, ##  0000000                  000000     
            0xFE, 0x00, 0x00, 0x7E, 0x00, ##  0000000                  000000     
            0xFE, 0x00, 0x00, 0x7E, 0x00, ##  0000000                  000000     
            0xFE, 0x00, 0x00, 0x7E, 0x00, ##  0000000                  000000     
            0xFE, 0x00, 0x00, 0x7E, 0x00, ##  0000000                  000000     
            0xFE, 0x00, 0x00, 0x7E, 0x00, ##  0000000                  000000     
            0xFE, 0x00, 0x00, 0x7E, 0x00, ##  0000000                  000000     
            0xFE, 0x00, 0x00, 0x7E, 0x00, ##  0000000                  000000     
            0x7E, 0x00, 0x00, 0x7E, 0x00, ##   000000                  000000     
            0x7F, 0x00, 0x00, 0x7E, 0x00, ##   0000000                 000000     
            0x7F, 0x00, 0x00, 0xFE, 0x00, ##   0000000                0000000     
            0x3F, 0x00, 0x00, 0xFE, 0x00, ##    000000                0000000     
            0x3F, 0x80, 0x01, 0xFE, 0x00, ##    0000000              00000000     
            0x1F, 0x80, 0x01, 0xFE, 0x00, ##     000000              00000000     
            0x1F, 0xC0, 0x03, 0xFE, 0x00, ##     0000000            000000000     
            0x0F, 0xE0, 0x07, 0x7E, 0x00, ##      0000000          000 000000     
            0x07, 0xF8, 0x1F, 0x7E, 0x00, ##       00000000      00000 000000     
            0x03, 0xFF, 0xFC, 0x7E, 0x00, ##        0000000000000000   000000     
            0x00, 0xFF, 0xF8, 0x7E, 0x00, ##          0000000000000    000000     
            0x00, 0x3F, 0xC0, 0x7E, 0x00, ##            00000000       000000     
            0x00, 0x00, 0x00, 0x7E, 0x00, ##                           000000     
            0x00, 0x00, 0x00, 0x7E, 0x00, ##                           000000     
            0x00, 0x00, 0x00, 0x7E, 0x00, ##                           000000     
            0x00, 0x00, 0x00, 0x7E, 0x00, ##                           000000     
            0x1E, 0x00, 0x00, 0xFC, 0x00, ##     0000                 000000      
            0x1E, 0x00, 0x00, 0xFC, 0x00, ##     0000                 000000      
            0x1E, 0x00, 0x00, 0xFC, 0x00, ##     0000                 000000      
            0x1F, 0x00, 0x01, 0xF8, 0x00, ##     00000               000000       
            0x1F, 0x00, 0x03, 0xF0, 0x00, ##     00000              000000        
            0x1F, 0x80, 0x07, 0xF0, 0x00, ##     000000            0000000        
            0x1F, 0xE0, 0x1F, 0xE0, 0x00, ##     00000000        00000000         
            0x1F, 0xFF, 0xFF, 0x80, 0x00, ##     0000000000000000000000           
            0x03, 0xFF, 0xFF, 0x00, 0x00, ##        000000000000000000            
            0x00, 0x3F, 0xF0, 0x00, 0x00, ##            0000000000                
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '104' => {    # 'h'
        'width'    => 37, 
        'xoffset'  => 3, 
        'xadvance' => 42, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xE0, 0x00, 0x00, 0x00, ##  00000000000                          
            0xFF, 0xE0, 0x00, 0x00, 0x00, ##  00000000000                          
            0xFF, 0xE0, 0x00, 0x00, 0x00, ##  00000000000                          
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                          
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                          
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                          
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                          
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                          
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                          
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                          
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                          
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                          
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                          
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                          
            0x07, 0xE0, 0x3F, 0x80, 0x00, ##       000000       0000000            
            0x07, 0xE1, 0xFF, 0xE0, 0x00, ##       000000    000000000000          
            0x07, 0xE3, 0xFF, 0xF8, 0x00, ##       000000   000000000000000        
            0x07, 0xE7, 0xFF, 0xFC, 0x00, ##       000000  00000000000000000       
            0x07, 0xEF, 0x03, 0xFC, 0x00, ##       000000 0000      00000000       
            0x07, 0xEC, 0x00, 0xFE, 0x00, ##       000000 00          0000000      
            0x07, 0xF8, 0x00, 0x7E, 0x00, ##       00000000            000000      
            0x07, 0xF8, 0x00, 0x7E, 0x00, ##       00000000            000000      
            0x07, 0xF0, 0x00, 0x7F, 0x00, ##       0000000             0000000     
            0x07, 0xF0, 0x00, 0x3F, 0x00, ##       0000000              000000     
            0x07, 0xF0, 0x00, 0x3F, 0x00, ##       0000000              000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0xFF, 0xFF, 0x07, 0xFF, 0xF8, ##  0000000000000000     0000000000000000
            0xFF, 0xFF, 0x07, 0xFF, 0xF8, ##  0000000000000000     0000000000000000
            0xFF, 0xFF, 0x07, 0xFF, 0xF8, ##  0000000000000000     0000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '105' => {    # 'i'
        'width'    => 17, 
        'xoffset'  => 2, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x03, 0x80, 0x00, ##        000        
            0x07, 0xC0, 0x00, ##       00000       
            0x0F, 0xE0, 0x00, ##      0000000      
            0x0F, 0xE0, 0x00, ##      0000000      
            0x0F, 0xE0, 0x00, ##      0000000      
            0x07, 0xC0, 0x00, ##       00000       
            0x03, 0x80, 0x00, ##        000        
            0x00, 0x00, 0x00, ##                   
            0x00, 0x00, 0x00, ##                   
            0x00, 0x00, 0x00, ##                   
            0x00, 0x00, 0x00, ##                   
            0x00, 0x00, 0x00, ##                   
            0x00, 0x00, 0x00, ##                   
            0x00, 0x00, 0x00, ##                   
            0xFF, 0xE0, 0x00, ##  00000000000      
            0xFF, 0xE0, 0x00, ##  00000000000      
            0xFF, 0xE0, 0x00, ##  00000000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '106' => {    # 'j'
        'width'    => 19, 
        'xoffset'  => -6, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x03, 0x80, ##                000  
            0x00, 0x07, 0xC0, ##               00000 
            0x00, 0x0F, 0xE0, ##              0000000
            0x00, 0x0F, 0xE0, ##              0000000
            0x00, 0x0F, 0xE0, ##              0000000
            0x00, 0x07, 0xC0, ##               00000 
            0x00, 0x03, 0x80, ##                000  
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x00, 0xFF, 0xE0, ##          00000000000
            0x00, 0xFF, 0xE0, ##          00000000000
            0x00, 0xFF, 0xE0, ##          00000000000
            0x00, 0x07, 0xE0, ##               000000
            0x00, 0x07, 0xE0, ##               000000
            0x00, 0x07, 0xE0, ##               000000
            0x00, 0x07, 0xE0, ##               000000
            0x00, 0x07, 0xE0, ##               000000
            0x00, 0x07, 0xE0, ##               000000
            0x00, 0x07, 0xE0, ##               000000
            0x00, 0x07, 0xE0, ##               000000
            0x00, 0x07, 0xE0, ##               000000
            0x00, 0x07, 0xE0, ##               000000
            0x00, 0x07, 0xE0, ##               000000
            0x00, 0x07, 0xE0, ##               000000
            0x00, 0x07, 0xE0, ##               000000
            0x00, 0x07, 0xE0, ##               000000
            0x00, 0x07, 0xE0, ##               000000
            0x00, 0x07, 0xE0, ##               000000
            0x00, 0x07, 0xE0, ##               000000
            0x00, 0x07, 0xE0, ##               000000
            0x00, 0x07, 0xE0, ##               000000
            0x00, 0x07, 0xE0, ##               000000
            0x00, 0x07, 0xE0, ##               000000
            0x00, 0x07, 0xE0, ##               000000
            0x00, 0x07, 0xE0, ##               000000
            0x00, 0x07, 0xE0, ##               000000
            0x00, 0x07, 0xE0, ##               000000
            0x00, 0x07, 0xE0, ##               000000
            0x00, 0x07, 0xE0, ##               000000
            0x00, 0x07, 0xE0, ##               000000
            0x00, 0x07, 0xE0, ##               000000
            0x00, 0x07, 0xE0, ##               000000
            0x00, 0x07, 0xE0, ##               000000
            0x00, 0x07, 0xE0, ##               000000
            0x00, 0x07, 0xE0, ##               000000
            0x00, 0x07, 0xE0, ##               000000
            0x00, 0x07, 0xE0, ##               000000
            0xC0, 0x07, 0xE0, ##  00           000000
            0xE0, 0x07, 0xE0, ##  000          000000
            0xE0, 0x0F, 0xC0, ##  000         000000 
            0xE0, 0x0F, 0xC0, ##  000         000000 
            0xF0, 0x1F, 0x80, ##  0000       000000  
            0xF8, 0x3F, 0x80, ##  00000     0000000  
            0xFF, 0xFF, 0x00, ##  0000000000000000   
            0x7F, 0xFC, 0x00, ##   0000000000000     
            0x1F, 0xF0, 0x00, ##     000000000       
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '107' => {    # 'k'
        'width'    => 37, 
        'xoffset'  => 2, 
        'xadvance' => 39, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xE0, 0x00, 0x00, 0x00, ##  00000000000                          
            0xFF, 0xE0, 0x00, 0x00, 0x00, ##  00000000000                          
            0xFF, 0xE0, 0x00, 0x00, 0x00, ##  00000000000                          
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                          
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                          
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                          
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                          
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                          
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                          
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                          
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                          
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                          
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                          
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                          
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                          
            0x07, 0xE0, 0x0F, 0xFF, 0xE0, ##       000000         000000000000000  
            0x07, 0xE0, 0x0F, 0xFF, 0xE0, ##       000000         000000000000000  
            0x07, 0xE0, 0x0F, 0xFF, 0xE0, ##       000000         000000000000000  
            0x07, 0xE0, 0x00, 0x78, 0x00, ##       000000              0000        
            0x07, 0xE0, 0x01, 0xF0, 0x00, ##       000000            00000         
            0x07, 0xE0, 0x03, 0xE0, 0x00, ##       000000           00000          
            0x07, 0xE0, 0x07, 0xC0, 0x00, ##       000000          00000           
            0x07, 0xE0, 0x0F, 0x80, 0x00, ##       000000         00000            
            0x07, 0xE0, 0x1F, 0x00, 0x00, ##       000000        00000             
            0x07, 0xE0, 0x3C, 0x00, 0x00, ##       000000       0000               
            0x07, 0xE0, 0x78, 0x00, 0x00, ##       000000      0000                
            0x07, 0xE0, 0xF0, 0x00, 0x00, ##       000000     0000                 
            0x07, 0xE1, 0xF0, 0x00, 0x00, ##       000000    00000                 
            0x07, 0xE3, 0xF0, 0x00, 0x00, ##       000000   000000                 
            0x07, 0xE7, 0xF8, 0x00, 0x00, ##       000000  00000000                
            0x07, 0xEF, 0xFC, 0x00, 0x00, ##       000000 0000000000               
            0x07, 0xFE, 0xFC, 0x00, 0x00, ##       0000000000 000000               
            0x07, 0xFC, 0xFE, 0x00, 0x00, ##       000000000  0000000              
            0x07, 0xF8, 0x7F, 0x00, 0x00, ##       00000000    0000000             
            0x07, 0xF0, 0x3F, 0x80, 0x00, ##       0000000      0000000            
            0x07, 0xE0, 0x1F, 0x80, 0x00, ##       000000        000000            
            0x07, 0xE0, 0x1F, 0xC0, 0x00, ##       000000        0000000           
            0x07, 0xE0, 0x0F, 0xE0, 0x00, ##       000000         0000000          
            0x07, 0xE0, 0x07, 0xF0, 0x00, ##       000000          0000000         
            0x07, 0xE0, 0x03, 0xF0, 0x00, ##       000000           000000         
            0x07, 0xE0, 0x03, 0xF8, 0x00, ##       000000           0000000        
            0x07, 0xE0, 0x01, 0xFC, 0x00, ##       000000            0000000       
            0x07, 0xE0, 0x00, 0xFC, 0x00, ##       000000             000000       
            0x07, 0xE0, 0x00, 0xFE, 0x00, ##       000000             0000000      
            0x07, 0xE0, 0x00, 0x7F, 0x00, ##       000000              0000000     
            0xFF, 0xFF, 0x07, 0xFF, 0xF8, ##  0000000000000000     0000000000000000
            0xFF, 0xFF, 0x07, 0xFF, 0xF8, ##  0000000000000000     0000000000000000
            0xFF, 0xFF, 0x07, 0xFF, 0xF8, ##  0000000000000000     0000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '108' => {    # 'l'
        'width'    => 17, 
        'xoffset'  => 2, 
        'xadvance' => 21, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0xE0, 0x00, ##  00000000000      
            0xFF, 0xE0, 0x00, ##  00000000000      
            0xFF, 0xE0, 0x00, ##  00000000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0x07, 0xE0, 0x00, ##       000000      
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '109' => {    # 'm'
        'width'    => 56, 
        'xoffset'  => 3, 
        'xadvance' => 61, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x7F, 0x00, 0x07, 0xF0, 0x00, ##                   0000000             0000000            
            0xFF, 0xE1, 0xFF, 0xC0, 0x1F, 0xFE, 0x00, ##  00000000000    00000000000         000000000000         
            0xFF, 0xE3, 0xFF, 0xF0, 0x3F, 0xFF, 0x00, ##  00000000000   00000000000000      00000000000000        
            0xFF, 0xE7, 0xFF, 0xF8, 0x7F, 0xFF, 0x80, ##  00000000000  0000000000000000    0000000000000000       
            0x07, 0xEF, 0x07, 0xF8, 0xF0, 0x7F, 0x80, ##       000000 0000     00000000   0000     00000000       
            0x07, 0xEC, 0x01, 0xFD, 0xC0, 0x1F, 0xC0, ##       000000 00         0000000 000         0000000      
            0x07, 0xF8, 0x00, 0xFD, 0x80, 0x0F, 0xC0, ##       00000000           000000 00           000000      
            0x07, 0xF8, 0x00, 0xFF, 0x80, 0x0F, 0xC0, ##       00000000           000000000           000000      
            0x07, 0xF0, 0x00, 0xFF, 0x00, 0x0F, 0xE0, ##       0000000            00000000            0000000     
            0x07, 0xF0, 0x00, 0x7F, 0x00, 0x07, 0xE0, ##       0000000             0000000             000000     
            0x07, 0xF0, 0x00, 0x7F, 0x00, 0x07, 0xE0, ##       0000000             0000000             000000     
            0x07, 0xE0, 0x00, 0x7E, 0x00, 0x07, 0xE0, ##       000000              000000              000000     
            0x07, 0xE0, 0x00, 0x7E, 0x00, 0x07, 0xE0, ##       000000              000000              000000     
            0x07, 0xE0, 0x00, 0x7E, 0x00, 0x07, 0xE0, ##       000000              000000              000000     
            0x07, 0xE0, 0x00, 0x7E, 0x00, 0x07, 0xE0, ##       000000              000000              000000     
            0x07, 0xE0, 0x00, 0x7E, 0x00, 0x07, 0xE0, ##       000000              000000              000000     
            0x07, 0xE0, 0x00, 0x7E, 0x00, 0x07, 0xE0, ##       000000              000000              000000     
            0x07, 0xE0, 0x00, 0x7E, 0x00, 0x07, 0xE0, ##       000000              000000              000000     
            0x07, 0xE0, 0x00, 0x7E, 0x00, 0x07, 0xE0, ##       000000              000000              000000     
            0x07, 0xE0, 0x00, 0x7E, 0x00, 0x07, 0xE0, ##       000000              000000              000000     
            0x07, 0xE0, 0x00, 0x7E, 0x00, 0x07, 0xE0, ##       000000              000000              000000     
            0x07, 0xE0, 0x00, 0x7E, 0x00, 0x07, 0xE0, ##       000000              000000              000000     
            0x07, 0xE0, 0x00, 0x7E, 0x00, 0x07, 0xE0, ##       000000              000000              000000     
            0x07, 0xE0, 0x00, 0x7E, 0x00, 0x07, 0xE0, ##       000000              000000              000000     
            0x07, 0xE0, 0x00, 0x7E, 0x00, 0x07, 0xE0, ##       000000              000000              000000     
            0x07, 0xE0, 0x00, 0x7E, 0x00, 0x07, 0xE0, ##       000000              000000              000000     
            0x07, 0xE0, 0x00, 0x7E, 0x00, 0x07, 0xE0, ##       000000              000000              000000     
            0x07, 0xE0, 0x00, 0x7E, 0x00, 0x07, 0xE0, ##       000000              000000              000000     
            0x07, 0xE0, 0x00, 0x7E, 0x00, 0x07, 0xE0, ##       000000              000000              000000     
            0x07, 0xE0, 0x00, 0x7E, 0x00, 0x07, 0xE0, ##       000000              000000              000000     
            0x07, 0xE0, 0x00, 0x7E, 0x00, 0x07, 0xE0, ##       000000              000000              000000     
            0xFF, 0xFF, 0x0F, 0xFF, 0xF0, 0xFF, 0xFF, ##  0000000000000000    0000000000000000    0000000000000000
            0xFF, 0xFF, 0x0F, 0xFF, 0xF0, 0xFF, 0xFF, ##  0000000000000000    0000000000000000    0000000000000000
            0xFF, 0xFF, 0x0F, 0xFF, 0xF0, 0xFF, 0xFF, ##  0000000000000000    0000000000000000    0000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '110' => {    # 'n'
        'width'    => 37, 
        'xoffset'  => 3, 
        'xadvance' => 42, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x3F, 0x80, 0x00, ##                    0000000            
            0xFF, 0xE1, 0xFF, 0xE0, 0x00, ##  00000000000    000000000000          
            0xFF, 0xE3, 0xFF, 0xF8, 0x00, ##  00000000000   000000000000000        
            0xFF, 0xE7, 0xFF, 0xFC, 0x00, ##  00000000000  00000000000000000       
            0x07, 0xEF, 0x03, 0xFC, 0x00, ##       000000 0000      00000000       
            0x07, 0xEC, 0x00, 0xFE, 0x00, ##       000000 00          0000000      
            0x07, 0xF8, 0x00, 0x7E, 0x00, ##       00000000            000000      
            0x07, 0xF8, 0x00, 0x7E, 0x00, ##       00000000            000000      
            0x07, 0xF0, 0x00, 0x7F, 0x00, ##       0000000             0000000     
            0x07, 0xF0, 0x00, 0x3F, 0x00, ##       0000000              000000     
            0x07, 0xF0, 0x00, 0x3F, 0x00, ##       0000000              000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0xFF, 0xFF, 0x07, 0xFF, 0xF8, ##  0000000000000000     0000000000000000
            0xFF, 0xFF, 0x07, 0xFF, 0xF8, ##  0000000000000000     0000000000000000
            0xFF, 0xFF, 0x07, 0xFF, 0xF8, ##  0000000000000000     0000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '111' => {    # 'o'
        'width'    => 32, 
        'xoffset'  => 3, 
        'xadvance' => 38, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x0F, 0xF0, 0x00, ##              00000000            
            0x00, 0x7F, 0xFE, 0x00, ##           00000000000000         
            0x01, 0xFF, 0xFF, 0x80, ##         000000000000000000       
            0x03, 0xF8, 0x1F, 0xC0, ##        0000000      0000000      
            0x07, 0xE0, 0x07, 0xE0, ##       000000          000000     
            0x0F, 0xC0, 0x03, 0xF0, ##      000000            000000    
            0x1F, 0x80, 0x01, 0xF8, ##     000000              000000   
            0x3F, 0x80, 0x01, 0xFC, ##    0000000              0000000  
            0x3F, 0x00, 0x00, 0xFC, ##    000000                000000  
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0xFE, 0x00, 0x00, 0x7E, ##  0000000                  000000 
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7E, ##  0000000                  000000 
            0x7E, 0x00, 0x00, 0xFE, ##   000000                 0000000 
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x3F, 0x00, 0x00, 0xFC, ##    000000                000000  
            0x3F, 0x80, 0x01, 0xFC, ##    0000000              0000000  
            0x1F, 0x80, 0x01, 0xF8, ##     000000              000000   
            0x0F, 0xC0, 0x03, 0xF0, ##      000000            000000    
            0x07, 0xE0, 0x07, 0xE0, ##       000000          000000     
            0x03, 0xF8, 0x1F, 0xC0, ##        0000000      0000000      
            0x01, 0xFF, 0xFF, 0x80, ##         000000000000000000       
            0x00, 0x7F, 0xFE, 0x00, ##           00000000000000         
            0x00, 0x0F, 0xF0, 0x00, ##              00000000            
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '112' => {    # 'p'
        'width'    => 36, 
        'xoffset'  => 2, 
        'xadvance' => 41, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x3F, 0xC0, 0x00, ##                    00000000          
            0xFF, 0xE1, 0xFF, 0xF0, 0x00, ##  00000000000    0000000000000        
            0xFF, 0xE3, 0xFF, 0xFC, 0x00, ##  00000000000   0000000000000000      
            0xFF, 0xE7, 0x81, 0xFE, 0x00, ##  00000000000  0000      00000000     
            0x07, 0xEE, 0x00, 0x7F, 0x00, ##       000000 000          0000000    
            0x07, 0xFC, 0x00, 0x3F, 0x80, ##       000000000            0000000   
            0x07, 0xF8, 0x00, 0x1F, 0x80, ##       00000000              000000   
            0x07, 0xF8, 0x00, 0x1F, 0xC0, ##       00000000              0000000  
            0x07, 0xF0, 0x00, 0x0F, 0xC0, ##       0000000                000000  
            0x07, 0xF0, 0x00, 0x0F, 0xE0, ##       0000000                0000000 
            0x07, 0xE0, 0x00, 0x0F, 0xE0, ##       000000                 0000000 
            0x07, 0xE0, 0x00, 0x07, 0xE0, ##       000000                  000000 
            0x07, 0xE0, 0x00, 0x07, 0xF0, ##       000000                  0000000
            0x07, 0xE0, 0x00, 0x07, 0xF0, ##       000000                  0000000
            0x07, 0xE0, 0x00, 0x07, 0xF0, ##       000000                  0000000
            0x07, 0xE0, 0x00, 0x07, 0xF0, ##       000000                  0000000
            0x07, 0xE0, 0x00, 0x07, 0xF0, ##       000000                  0000000
            0x07, 0xE0, 0x00, 0x07, 0xF0, ##       000000                  0000000
            0x07, 0xE0, 0x00, 0x07, 0xF0, ##       000000                  0000000
            0x07, 0xE0, 0x00, 0x07, 0xF0, ##       000000                  0000000
            0x07, 0xE0, 0x00, 0x07, 0xF0, ##       000000                  0000000
            0x07, 0xE0, 0x00, 0x07, 0xF0, ##       000000                  0000000
            0x07, 0xE0, 0x00, 0x07, 0xE0, ##       000000                  000000 
            0x07, 0xE0, 0x00, 0x0F, 0xE0, ##       000000                 0000000 
            0x07, 0xF0, 0x00, 0x0F, 0xE0, ##       0000000                0000000 
            0x07, 0xF0, 0x00, 0x0F, 0xC0, ##       0000000                000000  
            0x07, 0xF0, 0x00, 0x1F, 0xC0, ##       0000000               0000000  
            0x07, 0xF8, 0x00, 0x1F, 0x80, ##       00000000              000000   
            0x07, 0xFC, 0x00, 0x3F, 0x80, ##       000000000            0000000   
            0x07, 0xEE, 0x00, 0x7F, 0x00, ##       000000 000          0000000    
            0x07, 0xEF, 0x81, 0xFE, 0x00, ##       000000 00000      00000000     
            0x07, 0xE3, 0xFF, 0xFC, 0x00, ##       000000   0000000000000000      
            0x07, 0xE1, 0xFF, 0xF0, 0x00, ##       000000    0000000000000        
            0x07, 0xE0, 0x3F, 0xC0, 0x00, ##       000000       00000000          
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                         
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                         
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                         
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                         
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                         
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                         
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                         
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                         
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                         
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                         
            0xFF, 0xFF, 0x80, 0x00, 0x00, ##  00000000000000000                   
            0xFF, 0xFF, 0x80, 0x00, 0x00, ##  00000000000000000                   
            0xFF, 0xFF, 0x80, 0x00, 0x00, ##  00000000000000000                   
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '113' => {    # 'q'
        'width'    => 36, 
        'xoffset'  => 3, 
        'xadvance' => 41, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x3F, 0xC0, 0x00, 0x00, ##            00000000                  
            0x00, 0xFF, 0xF8, 0x7F, 0xF0, ##          0000000000000    00000000000
            0x03, 0xFF, 0xFC, 0x7F, 0xF0, ##        0000000000000000   00000000000
            0x07, 0xF8, 0x1E, 0x7F, 0xF0, ##       00000000      0000  00000000000
            0x0F, 0xE0, 0x07, 0x7E, 0x00, ##      0000000          000 000000     
            0x1F, 0xC0, 0x03, 0xFE, 0x00, ##     0000000            000000000     
            0x1F, 0x80, 0x01, 0xFE, 0x00, ##     000000              00000000     
            0x3F, 0x80, 0x01, 0xFE, 0x00, ##    0000000              00000000     
            0x3F, 0x00, 0x00, 0xFE, 0x00, ##    000000                0000000     
            0x7F, 0x00, 0x00, 0xFE, 0x00, ##   0000000                0000000     
            0x7F, 0x00, 0x00, 0x7E, 0x00, ##   0000000                 000000     
            0x7E, 0x00, 0x00, 0x7E, 0x00, ##   000000                  000000     
            0xFE, 0x00, 0x00, 0x7E, 0x00, ##  0000000                  000000     
            0xFE, 0x00, 0x00, 0x7E, 0x00, ##  0000000                  000000     
            0xFE, 0x00, 0x00, 0x7E, 0x00, ##  0000000                  000000     
            0xFE, 0x00, 0x00, 0x7E, 0x00, ##  0000000                  000000     
            0xFE, 0x00, 0x00, 0x7E, 0x00, ##  0000000                  000000     
            0xFE, 0x00, 0x00, 0x7E, 0x00, ##  0000000                  000000     
            0xFE, 0x00, 0x00, 0x7E, 0x00, ##  0000000                  000000     
            0xFE, 0x00, 0x00, 0x7E, 0x00, ##  0000000                  000000     
            0xFE, 0x00, 0x00, 0x7E, 0x00, ##  0000000                  000000     
            0xFE, 0x00, 0x00, 0x7E, 0x00, ##  0000000                  000000     
            0x7E, 0x00, 0x00, 0x7E, 0x00, ##   000000                  000000     
            0x7F, 0x00, 0x00, 0x7E, 0x00, ##   0000000                 000000     
            0x7F, 0x00, 0x00, 0xFE, 0x00, ##   0000000                0000000     
            0x3F, 0x00, 0x00, 0xFE, 0x00, ##    000000                0000000     
            0x3F, 0x80, 0x01, 0xFE, 0x00, ##    0000000              00000000     
            0x1F, 0x80, 0x01, 0xFE, 0x00, ##     000000              00000000     
            0x1F, 0xC0, 0x03, 0xFE, 0x00, ##     0000000            000000000     
            0x0F, 0xE0, 0x07, 0x7E, 0x00, ##      0000000          000 000000     
            0x07, 0xF8, 0x1F, 0x7E, 0x00, ##       00000000      00000 000000     
            0x03, 0xFF, 0xFC, 0x7E, 0x00, ##        0000000000000000   000000     
            0x00, 0xFF, 0xF8, 0x7E, 0x00, ##          0000000000000    000000     
            0x00, 0x3F, 0xC0, 0x7E, 0x00, ##            00000000       000000     
            0x00, 0x00, 0x00, 0x7E, 0x00, ##                           000000     
            0x00, 0x00, 0x00, 0x7E, 0x00, ##                           000000     
            0x00, 0x00, 0x00, 0x7E, 0x00, ##                           000000     
            0x00, 0x00, 0x00, 0x7E, 0x00, ##                           000000     
            0x00, 0x00, 0x00, 0x7E, 0x00, ##                           000000     
            0x00, 0x00, 0x00, 0x7E, 0x00, ##                           000000     
            0x00, 0x00, 0x00, 0x7E, 0x00, ##                           000000     
            0x00, 0x00, 0x00, 0x7E, 0x00, ##                           000000     
            0x00, 0x00, 0x00, 0x7E, 0x00, ##                           000000     
            0x00, 0x00, 0x00, 0x7E, 0x00, ##                           000000     
            0x00, 0x00, 0x1F, 0xFF, 0xF0, ##                     00000000000000000
            0x00, 0x00, 0x1F, 0xFF, 0xF0, ##                     00000000000000000
            0x00, 0x00, 0x1F, 0xFF, 0xF0, ##                     00000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '114' => {    # 'r'
        'width'    => 28, 
        'xoffset'  => 3, 
        'xadvance' => 31, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x3F, 0xC0, ##                    00000000  
            0xFF, 0xE0, 0xFF, 0xF0, ##  00000000000     000000000000
            0xFF, 0xE3, 0xFF, 0xF0, ##  00000000000   00000000000000
            0xFF, 0xE7, 0xFF, 0xF0, ##  00000000000  000000000000000
            0x07, 0xEF, 0x81, 0xF0, ##       000000 00000      00000
            0x07, 0xEE, 0x00, 0xF0, ##       000000 000         0000
            0x07, 0xFC, 0x00, 0x70, ##       000000000           000
            0x07, 0xF8, 0x00, 0x70, ##       00000000            000
            0x07, 0xF0, 0x00, 0x70, ##       0000000             000
            0x07, 0xF0, 0x00, 0x00, ##       0000000                
            0x07, 0xF0, 0x00, 0x00, ##       0000000                
            0x07, 0xE0, 0x00, 0x00, ##       000000                 
            0x07, 0xE0, 0x00, 0x00, ##       000000                 
            0x07, 0xE0, 0x00, 0x00, ##       000000                 
            0x07, 0xE0, 0x00, 0x00, ##       000000                 
            0x07, 0xE0, 0x00, 0x00, ##       000000                 
            0x07, 0xE0, 0x00, 0x00, ##       000000                 
            0x07, 0xE0, 0x00, 0x00, ##       000000                 
            0x07, 0xE0, 0x00, 0x00, ##       000000                 
            0x07, 0xE0, 0x00, 0x00, ##       000000                 
            0x07, 0xE0, 0x00, 0x00, ##       000000                 
            0x07, 0xE0, 0x00, 0x00, ##       000000                 
            0x07, 0xE0, 0x00, 0x00, ##       000000                 
            0x07, 0xE0, 0x00, 0x00, ##       000000                 
            0x07, 0xE0, 0x00, 0x00, ##       000000                 
            0x07, 0xE0, 0x00, 0x00, ##       000000                 
            0x07, 0xE0, 0x00, 0x00, ##       000000                 
            0x07, 0xE0, 0x00, 0x00, ##       000000                 
            0x07, 0xE0, 0x00, 0x00, ##       000000                 
            0x07, 0xE0, 0x00, 0x00, ##       000000                 
            0x07, 0xE0, 0x00, 0x00, ##       000000                 
            0xFF, 0xFF, 0xC0, 0x00, ##  000000000000000000          
            0xFF, 0xFF, 0xC0, 0x00, ##  000000000000000000          
            0xFF, 0xFF, 0xC0, 0x00, ##  000000000000000000          
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '115' => {    # 's'
        'width'    => 26, 
        'xoffset'  => 4, 
        'xadvance' => 33, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0xFF, 0x80, 0x00, ##          000000000         
            0x07, 0xFF, 0xF8, 0x00, ##       0000000000000000     
            0x1F, 0xFF, 0xFF, 0x00, ##     000000000000000000000  
            0x3F, 0xC0, 0x7F, 0x00, ##    00000000       0000000  
            0x3F, 0x00, 0x3F, 0x00, ##    000000          000000  
            0x7E, 0x00, 0x0F, 0x00, ##   000000             0000  
            0x7C, 0x00, 0x0F, 0x00, ##   00000              0000  
            0xFC, 0x00, 0x07, 0x00, ##  000000               000  
            0xFC, 0x00, 0x07, 0x00, ##  000000               000  
            0xFC, 0x00, 0x07, 0x00, ##  000000               000  
            0xFE, 0x00, 0x00, 0x00, ##  0000000                   
            0xFE, 0x00, 0x00, 0x00, ##  0000000                   
            0xFF, 0x80, 0x00, 0x00, ##  000000000                 
            0x7F, 0xE0, 0x00, 0x00, ##   0000000000               
            0x7F, 0xFC, 0x00, 0x00, ##   0000000000000            
            0x3F, 0xFF, 0x80, 0x00, ##    000000000000000         
            0x0F, 0xFF, 0xF0, 0x00, ##      0000000000000000      
            0x03, 0xFF, 0xFC, 0x00, ##        0000000000000000    
            0x00, 0xFF, 0xFE, 0x00, ##          000000000000000   
            0x00, 0x1F, 0xFF, 0x00, ##             0000000000000  
            0x00, 0x03, 0xFF, 0x80, ##                00000000000 
            0x00, 0x00, 0xFF, 0x80, ##                  000000000 
            0x00, 0x00, 0x3F, 0xC0, ##                    00000000
            0x00, 0x00, 0x1F, 0xC0, ##                     0000000
            0x00, 0x00, 0x0F, 0xC0, ##                      000000
            0xE0, 0x00, 0x0F, 0xC0, ##  000                 000000
            0xE0, 0x00, 0x0F, 0xC0, ##  000                 000000
            0xE0, 0x00, 0x0F, 0xC0, ##  000                 000000
            0xF0, 0x00, 0x0F, 0x80, ##  0000                00000 
            0xF8, 0x00, 0x1F, 0x80, ##  00000              000000 
            0xFC, 0x00, 0x3F, 0x00, ##  000000            000000  
            0xFF, 0x00, 0xFE, 0x00, ##  00000000        0000000   
            0xFF, 0xFF, 0xFC, 0x00, ##  0000000000000000000000    
            0x1F, 0xFF, 0xF0, 0x00, ##     00000000000000000      
            0x01, 0xFF, 0x80, 0x00, ##         0000000000         
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '116' => {    # 't'
        'width'    => 23, 
        'xoffset'  => 2, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000 
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000 
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000 
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x1E, ##       000000        0000
            0x07, 0xE0, 0x1E, ##       000000        0000
            0x07, 0xE0, 0x1E, ##       000000        0000
            0x07, 0xE0, 0x1E, ##       000000        0000
            0x03, 0xF0, 0x3C, ##        000000      0000 
            0x03, 0xF8, 0x7C, ##        0000000    00000 
            0x01, 0xFF, 0xF8, ##         00000000000000  
            0x00, 0xFF, 0xF0, ##          000000000000   
            0x00, 0x3F, 0xC0, ##            00000000     
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '117' => {    # 'u'
        'width'    => 37, 
        'xoffset'  => 2, 
        'xadvance' => 41, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xE0, 0x07, 0xFF, 0x00, ##  00000000000          00000000000     
            0xFF, 0xE0, 0x07, 0xFF, 0x00, ##  00000000000          00000000000     
            0xFF, 0xE0, 0x07, 0xFF, 0x00, ##  00000000000          00000000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x7F, 0x00, ##       000000              0000000     
            0x07, 0xE0, 0x00, 0x7F, 0x00, ##       000000              0000000     
            0x07, 0xF0, 0x00, 0x7F, 0x00, ##       0000000             0000000     
            0x03, 0xF0, 0x00, 0xFF, 0x00, ##        000000            00000000     
            0x03, 0xF0, 0x00, 0xFF, 0x00, ##        000000            00000000     
            0x03, 0xF8, 0x03, 0xBF, 0x00, ##        0000000         000 000000     
            0x01, 0xFE, 0x07, 0xBF, 0x00, ##         00000000      0000 000000     
            0x01, 0xFF, 0xFF, 0x3F, 0xF8, ##         00000000000000000  00000000000
            0x00, 0xFF, 0xFE, 0x3F, 0xF8, ##          000000000000000   00000000000
            0x00, 0x3F, 0xFC, 0x3F, 0xF8, ##            000000000000    00000000000
            0x00, 0x0F, 0xE0, 0x00, 0x00, ##              0000000                  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '118' => {    # 'v'
        'width'    => 36, 
        'xoffset'  => 0, 
        'xadvance' => 37, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFE, 0x00, 0xFF, 0xF0, ##  000000000000000         000000000000
            0xFF, 0xFE, 0x00, 0xFF, 0xF0, ##  000000000000000         000000000000
            0xFF, 0xFE, 0x00, 0xFF, 0xF0, ##  000000000000000         000000000000
            0x0F, 0xC0, 0x00, 0x07, 0x00, ##      000000                   000    
            0x0F, 0xC0, 0x00, 0x0F, 0x00, ##      000000                  0000    
            0x07, 0xE0, 0x00, 0x0E, 0x00, ##       000000                 000     
            0x07, 0xE0, 0x00, 0x1E, 0x00, ##       000000                0000     
            0x03, 0xF0, 0x00, 0x1E, 0x00, ##        000000               0000     
            0x03, 0xF0, 0x00, 0x1C, 0x00, ##        000000               000      
            0x03, 0xF0, 0x00, 0x3C, 0x00, ##        000000              0000      
            0x01, 0xF8, 0x00, 0x38, 0x00, ##         000000             000       
            0x01, 0xF8, 0x00, 0x78, 0x00, ##         000000            0000       
            0x00, 0xFC, 0x00, 0x78, 0x00, ##          000000           0000       
            0x00, 0xFC, 0x00, 0xF0, 0x00, ##          000000          0000        
            0x00, 0xFE, 0x00, 0xF0, 0x00, ##          0000000         0000        
            0x00, 0x7E, 0x00, 0xE0, 0x00, ##           000000         000         
            0x00, 0x7E, 0x01, 0xE0, 0x00, ##           000000        0000         
            0x00, 0x3F, 0x01, 0xE0, 0x00, ##            000000       0000         
            0x00, 0x3F, 0x03, 0xC0, 0x00, ##            000000      0000          
            0x00, 0x3F, 0x83, 0xC0, 0x00, ##            0000000     0000          
            0x00, 0x1F, 0x83, 0x80, 0x00, ##             000000     000           
            0x00, 0x1F, 0x87, 0x80, 0x00, ##             000000    0000           
            0x00, 0x0F, 0xC7, 0x80, 0x00, ##              000000   0000           
            0x00, 0x0F, 0xCF, 0x00, 0x00, ##              000000  0000            
            0x00, 0x0F, 0xEF, 0x00, 0x00, ##              0000000 0000            
            0x00, 0x07, 0xFE, 0x00, 0x00, ##               0000000000             
            0x00, 0x07, 0xFE, 0x00, 0x00, ##               0000000000             
            0x00, 0x03, 0xFE, 0x00, 0x00, ##                000000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000              
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000              
            0x00, 0x01, 0xF8, 0x00, 0x00, ##                 000000               
            0x00, 0x01, 0xF8, 0x00, 0x00, ##                 000000               
            0x00, 0x00, 0xF0, 0x00, 0x00, ##                  0000                
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '119' => {    # 'w'
        'width'    => 53, 
        'xoffset'  => 1, 
        'xadvance' => 55, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFE, 0x00, 0x3C, 0x00, 0x7F, 0xF8, ##  000000000000000           0000           000000000000
            0xFF, 0xFE, 0x00, 0x7C, 0x00, 0x7F, 0xF8, ##  000000000000000          00000           000000000000
            0xFF, 0xFE, 0x00, 0x7E, 0x00, 0x7F, 0xF8, ##  000000000000000          000000          000000000000
            0x0F, 0xC0, 0x00, 0xFE, 0x00, 0x03, 0x80, ##      000000              0000000               000    
            0x0F, 0xC0, 0x00, 0xFE, 0x00, 0x07, 0x80, ##      000000              0000000              0000    
            0x07, 0xC0, 0x00, 0xFF, 0x00, 0x07, 0x80, ##       00000              00000000             0000    
            0x07, 0xE0, 0x01, 0xFF, 0x00, 0x07, 0x00, ##       000000            000000000             000     
            0x07, 0xE0, 0x01, 0xFF, 0x00, 0x0F, 0x00, ##       000000            000000000            0000     
            0x03, 0xE0, 0x01, 0xDF, 0x80, 0x0F, 0x00, ##        00000            000 000000           0000     
            0x03, 0xF0, 0x03, 0xDF, 0x80, 0x0E, 0x00, ##        000000          0000 000000           000      
            0x03, 0xF0, 0x03, 0xDF, 0x80, 0x1E, 0x00, ##        000000          0000 000000          0000      
            0x01, 0xF0, 0x03, 0x8F, 0xC0, 0x1E, 0x00, ##         00000          000   000000         0000      
            0x01, 0xF8, 0x07, 0x8F, 0xC0, 0x1C, 0x00, ##         000000        0000   000000         000       
            0x01, 0xF8, 0x07, 0x8F, 0xC0, 0x3C, 0x00, ##         000000        0000   000000        0000       
            0x01, 0xF8, 0x07, 0x07, 0xE0, 0x3C, 0x00, ##         000000        000     000000       0000       
            0x00, 0xFC, 0x0F, 0x07, 0xE0, 0x38, 0x00, ##          000000      0000     000000       000        
            0x00, 0xFC, 0x0F, 0x07, 0xE0, 0x78, 0x00, ##          000000      0000     000000      0000        
            0x00, 0xFC, 0x0E, 0x03, 0xF0, 0x78, 0x00, ##          000000      000       000000     0000        
            0x00, 0x7E, 0x1E, 0x03, 0xF0, 0x70, 0x00, ##           000000    0000       000000     000         
            0x00, 0x7E, 0x1E, 0x03, 0xF0, 0xF0, 0x00, ##           000000    0000       000000    0000         
            0x00, 0x7E, 0x1C, 0x01, 0xF8, 0xF0, 0x00, ##           000000    000         000000   0000         
            0x00, 0x3F, 0x3C, 0x01, 0xF8, 0xE0, 0x00, ##            000000  0000         000000   000          
            0x00, 0x3F, 0x3C, 0x01, 0xF9, 0xE0, 0x00, ##            000000  0000         000000  0000          
            0x00, 0x3F, 0x38, 0x00, 0xFD, 0xE0, 0x00, ##            000000  000           000000 0000          
            0x00, 0x1F, 0xF8, 0x00, 0xFD, 0xC0, 0x00, ##             0000000000           000000 000           
            0x00, 0x1F, 0xF8, 0x00, 0xFF, 0xC0, 0x00, ##             0000000000           0000000000           
            0x00, 0x1F, 0xF0, 0x00, 0x7F, 0xC0, 0x00, ##             000000000             000000000           
            0x00, 0x0F, 0xF0, 0x00, 0x7F, 0x80, 0x00, ##              00000000             00000000            
            0x00, 0x0F, 0xF0, 0x00, 0x7F, 0x80, 0x00, ##              00000000             00000000            
            0x00, 0x0F, 0xE0, 0x00, 0x7F, 0x80, 0x00, ##              0000000              00000000            
            0x00, 0x07, 0xE0, 0x00, 0x3F, 0x00, 0x00, ##               000000               000000             
            0x00, 0x07, 0xE0, 0x00, 0x3F, 0x00, 0x00, ##               000000               000000             
            0x00, 0x07, 0xC0, 0x00, 0x3F, 0x00, 0x00, ##               00000                000000             
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '120' => {    # 'x'
        'width'    => 34, 
        'xoffset'  => 1, 
        'xadvance' => 36, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFE, 0x0F, 0xFF, 0x80, ##  000000000000000     0000000000000 
            0xFF, 0xFE, 0x0F, 0xFF, 0x80, ##  000000000000000     0000000000000 
            0xFF, 0xFE, 0x0F, 0xFF, 0x80, ##  000000000000000     0000000000000 
            0x0F, 0xE0, 0x00, 0xF0, 0x00, ##      0000000             0000      
            0x07, 0xF0, 0x01, 0xE0, 0x00, ##       0000000           0000       
            0x07, 0xF0, 0x01, 0xE0, 0x00, ##       0000000           0000       
            0x03, 0xF8, 0x03, 0xC0, 0x00, ##        0000000         0000        
            0x01, 0xFC, 0x07, 0x80, 0x00, ##         0000000       0000         
            0x00, 0xFE, 0x07, 0x80, 0x00, ##          0000000      0000         
            0x00, 0xFE, 0x0F, 0x00, 0x00, ##          0000000     0000          
            0x00, 0x7F, 0x1E, 0x00, 0x00, ##           0000000   0000           
            0x00, 0x3F, 0xBC, 0x00, 0x00, ##            0000000 0000            
            0x00, 0x1F, 0xBC, 0x00, 0x00, ##             000000 0000            
            0x00, 0x1F, 0xF8, 0x00, 0x00, ##             0000000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000              
            0x00, 0x07, 0xF0, 0x00, 0x00, ##               0000000              
            0x00, 0x03, 0xF0, 0x00, 0x00, ##                000000              
            0x00, 0x03, 0xF8, 0x00, 0x00, ##                0000000             
            0x00, 0x07, 0xFC, 0x00, 0x00, ##               000000000            
            0x00, 0x0F, 0xFC, 0x00, 0x00, ##              0000000000            
            0x00, 0x0F, 0x7E, 0x00, 0x00, ##              0000 000000           
            0x00, 0x1E, 0x7F, 0x00, 0x00, ##             0000  0000000          
            0x00, 0x3C, 0x3F, 0x80, 0x00, ##            0000    0000000         
            0x00, 0x7C, 0x1F, 0x80, 0x00, ##           00000     000000         
            0x00, 0x78, 0x1F, 0xC0, 0x00, ##           0000      0000000        
            0x00, 0xF0, 0x0F, 0xE0, 0x00, ##          0000        0000000       
            0x01, 0xE0, 0x07, 0xE0, 0x00, ##         0000          000000       
            0x03, 0xC0, 0x07, 0xF0, 0x00, ##        0000           0000000      
            0x03, 0xC0, 0x03, 0xF8, 0x00, ##        0000            0000000     
            0x07, 0x80, 0x01, 0xFC, 0x00, ##       0000              0000000    
            0xFF, 0xF8, 0x1F, 0xFF, 0xC0, ##  0000000000000      000000000000000
            0xFF, 0xF8, 0x1F, 0xFF, 0xC0, ##  0000000000000      000000000000000
            0xFF, 0xF8, 0x1F, 0xFF, 0xC0, ##  0000000000000      000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '121' => {    # 'y'
        'width'    => 36, 
        'xoffset'  => 0, 
        'xadvance' => 37, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFE, 0x00, 0xFF, 0xF0, ##  000000000000000         000000000000
            0xFF, 0xFE, 0x00, 0xFF, 0xF0, ##  000000000000000         000000000000
            0xFF, 0xFE, 0x00, 0xFF, 0xF0, ##  000000000000000         000000000000
            0x0F, 0xC0, 0x00, 0x07, 0x00, ##      000000                   000    
            0x0F, 0xC0, 0x00, 0x0F, 0x00, ##      000000                  0000    
            0x07, 0xE0, 0x00, 0x0E, 0x00, ##       000000                 000     
            0x07, 0xE0, 0x00, 0x1E, 0x00, ##       000000                0000     
            0x03, 0xF0, 0x00, 0x1E, 0x00, ##        000000               0000     
            0x03, 0xF0, 0x00, 0x1C, 0x00, ##        000000               000      
            0x03, 0xF0, 0x00, 0x3C, 0x00, ##        000000              0000      
            0x01, 0xF8, 0x00, 0x38, 0x00, ##         000000             000       
            0x01, 0xF8, 0x00, 0x78, 0x00, ##         000000            0000       
            0x00, 0xFC, 0x00, 0x78, 0x00, ##          000000           0000       
            0x00, 0xFC, 0x00, 0xF0, 0x00, ##          000000          0000        
            0x00, 0xFE, 0x00, 0xF0, 0x00, ##          0000000         0000        
            0x00, 0x7E, 0x00, 0xE0, 0x00, ##           000000         000         
            0x00, 0x7E, 0x01, 0xE0, 0x00, ##           000000        0000         
            0x00, 0x3F, 0x01, 0xE0, 0x00, ##            000000       0000         
            0x00, 0x3F, 0x03, 0xC0, 0x00, ##            000000      0000          
            0x00, 0x3F, 0x83, 0xC0, 0x00, ##            0000000     0000          
            0x00, 0x1F, 0x83, 0x80, 0x00, ##             000000     000           
            0x00, 0x1F, 0x87, 0x80, 0x00, ##             000000    0000           
            0x00, 0x0F, 0xC7, 0x00, 0x00, ##              000000   000            
            0x00, 0x0F, 0xCF, 0x00, 0x00, ##              000000  0000            
            0x00, 0x0F, 0xEF, 0x00, 0x00, ##              0000000 0000            
            0x00, 0x07, 0xEE, 0x00, 0x00, ##               000000 000             
            0x00, 0x07, 0xFE, 0x00, 0x00, ##               0000000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000              
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000              
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000              
            0x00, 0x01, 0xF8, 0x00, 0x00, ##                 000000               
            0x00, 0x01, 0xF8, 0x00, 0x00, ##                 000000               
            0x00, 0x00, 0xF0, 0x00, 0x00, ##                  0000                
            0x00, 0x00, 0xF0, 0x00, 0x00, ##                  0000                
            0x00, 0x00, 0xF0, 0x00, 0x00, ##                  0000                
            0x00, 0x01, 0xE0, 0x00, 0x00, ##                 0000                 
            0x00, 0x01, 0xE0, 0x00, 0x00, ##                 0000                 
            0x00, 0x01, 0xC0, 0x00, 0x00, ##                 000                  
            0x00, 0x03, 0xC0, 0x00, 0x00, ##                0000                  
            0x00, 0x03, 0xC0, 0x00, 0x00, ##                0000                  
            0x38, 0x07, 0x80, 0x00, 0x00, ##    000        0000                   
            0x38, 0x07, 0x80, 0x00, 0x00, ##    000        0000                   
            0x3C, 0x0F, 0x00, 0x00, 0x00, ##    0000      0000                    
            0x3E, 0x1F, 0x00, 0x00, 0x00, ##    00000    00000                    
            0x3F, 0xFE, 0x00, 0x00, 0x00, ##    0000000000000                     
            0x3F, 0xFC, 0x00, 0x00, 0x00, ##    000000000000                      
            0x0F, 0xF0, 0x00, 0x00, 0x00, ##      00000000                        
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '122' => {    # 'z'
        'width'    => 29, 
        'xoffset'  => 3, 
        'xadvance' => 34, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x7F, 0xFF, 0xFF, 0xF0, ##   000000000000000000000000000 
            0x7F, 0xFF, 0xFF, 0xF0, ##   000000000000000000000000000 
            0x7F, 0xFF, 0xFF, 0xF0, ##   000000000000000000000000000 
            0x70, 0x00, 0x07, 0xF0, ##   000                 0000000 
            0x70, 0x00, 0x0F, 0xE0, ##   000                0000000  
            0x70, 0x00, 0x1F, 0xC0, ##   000               0000000   
            0x70, 0x00, 0x3F, 0x80, ##   000              0000000    
            0x70, 0x00, 0x3F, 0x80, ##   000              0000000    
            0x70, 0x00, 0x7F, 0x00, ##   000             0000000     
            0x00, 0x00, 0xFE, 0x00, ##                  0000000      
            0x00, 0x01, 0xFC, 0x00, ##                 0000000       
            0x00, 0x01, 0xF8, 0x00, ##                 000000        
            0x00, 0x03, 0xF8, 0x00, ##                0000000        
            0x00, 0x07, 0xF0, 0x00, ##               0000000         
            0x00, 0x0F, 0xE0, 0x00, ##              0000000          
            0x00, 0x0F, 0xC0, 0x00, ##              000000           
            0x00, 0x1F, 0xC0, 0x00, ##             0000000           
            0x00, 0x3F, 0x80, 0x00, ##            0000000            
            0x00, 0x7F, 0x00, 0x00, ##           0000000             
            0x00, 0xFE, 0x00, 0x00, ##          0000000              
            0x00, 0xFE, 0x00, 0x00, ##          0000000              
            0x01, 0xFC, 0x00, 0x00, ##         0000000               
            0x03, 0xF8, 0x00, 0x00, ##        0000000                
            0x07, 0xF0, 0x00, 0x00, ##       0000000                 
            0x07, 0xE0, 0x00, 0x38, ##       000000               000
            0x0F, 0xE0, 0x00, 0x38, ##      0000000               000
            0x1F, 0xC0, 0x00, 0x38, ##     0000000                000
            0x3F, 0x80, 0x00, 0x38, ##    0000000                 000
            0x3F, 0x00, 0x00, 0x38, ##    000000                  000
            0x7F, 0x00, 0x00, 0x38, ##   0000000                  000
            0xFF, 0xFF, 0xFF, 0xF8, ##  00000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xF8, ##  00000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xF8, ##  00000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '123' => {    # '{'
        'width'    => 24, 
        'xoffset'  => 8, 
        'xadvance' => 40, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0xFF, ##                  00000000
            0x00, 0x07, 0xFF, ##               00000000000
            0x00, 0x1F, 0xFF, ##             0000000000000
            0x00, 0x1F, 0xC0, ##             0000000      
            0x00, 0x3F, 0x00, ##            000000        
            0x00, 0x3F, 0x00, ##            000000        
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0xFC, 0x00, ##          000000          
            0x00, 0xFC, 0x00, ##          000000          
            0x01, 0xF8, 0x00, ##         000000           
            0x07, 0xF0, 0x00, ##       0000000            
            0xFF, 0xE0, 0x00, ##  00000000000             
            0xFF, 0x00, 0x00, ##  00000000                
            0xFF, 0xC0, 0x00, ##  0000000000              
            0x07, 0xF0, 0x00, ##       0000000            
            0x01, 0xF8, 0x00, ##         000000           
            0x00, 0xFC, 0x00, ##          000000          
            0x00, 0xFC, 0x00, ##          000000          
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x3F, 0x00, ##            000000        
            0x00, 0x3F, 0x00, ##            000000        
            0x00, 0x1F, 0xC0, ##             0000000      
            0x00, 0x1F, 0xFF, ##             0000000000000
            0x00, 0x07, 0xFF, ##               00000000000
            0x00, 0x00, 0xFF, ##                  00000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '124' => {    # '|'
        'width'    => 5, 
        'xoffset'  => 8, 
        'xadvance' => 21, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0x00, ##  
        ], 
    }, 
    '125' => {    # '}'
        'width'    => 25, 
        'xoffset'  => 8, 
        'xadvance' => 41, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0x00, 0x00, 0x00, ##  00000000                 
            0xFF, 0xE0, 0x00, 0x00, ##  00000000000              
            0xFF, 0xF8, 0x00, 0x00, ##  0000000000000            
            0x03, 0xF8, 0x00, 0x00, ##        0000000            
            0x00, 0xFC, 0x00, 0x00, ##          000000           
            0x00, 0xFC, 0x00, 0x00, ##          000000           
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x3F, 0x00, 0x00, ##            000000         
            0x00, 0x3F, 0x00, 0x00, ##            000000         
            0x00, 0x1F, 0x80, 0x00, ##             000000        
            0x00, 0x0F, 0xE0, 0x00, ##              0000000      
            0x00, 0x07, 0xFF, 0x80, ##               000000000000
            0x00, 0x00, 0xFF, 0x80, ##                  000000000
            0x00, 0x07, 0xFF, 0x80, ##               000000000000
            0x00, 0x0F, 0xE0, 0x00, ##              0000000      
            0x00, 0x1F, 0x80, 0x00, ##             000000        
            0x00, 0x3F, 0x00, 0x00, ##            000000         
            0x00, 0x3F, 0x00, 0x00, ##            000000         
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0xFC, 0x00, 0x00, ##          000000           
            0x00, 0xFC, 0x00, 0x00, ##          000000           
            0x03, 0xF8, 0x00, 0x00, ##        0000000            
            0xFF, 0xF8, 0x00, 0x00, ##  0000000000000            
            0xFF, 0xE0, 0x00, 0x00, ##  00000000000              
            0xFF, 0x00, 0x00, 0x00, ##  00000000                 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '126' => {    # '~'
        'width'    => 40, 
        'xoffset'  => 7, 
        'xadvance' => 54, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0xFE, 0x00, 0x00, 0x01, ##          0000000                        0
            0x07, 0xFF, 0xC0, 0x00, 0x03, ##       0000000000000                    00
            0x1F, 0xFF, 0xF0, 0x00, 0x07, ##     00000000000000000                 000
            0x3F, 0xFF, 0xFE, 0x00, 0x1F, ##    000000000000000000000            00000
            0x7F, 0xFF, 0xFF, 0xC0, 0xFF, ##   0000000000000000000000000      00000000
            0xFF, 0x03, 0xFF, 0xFF, 0xFE, ##  00000000      0000000000000000000000000 
            0xF8, 0x00, 0x7F, 0xFF, 0xFC, ##  00000            000000000000000000000  
            0xE0, 0x00, 0x0F, 0xFF, 0xF0, ##  000                 0000000000000000    
            0xC0, 0x00, 0x03, 0xFF, 0xE0, ##  00                    0000000000000     
            0x80, 0x00, 0x00, 0x7F, 0x00, ##  0                        0000000        
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '160' => {    # ' '
        'width'    => 0, 
        'xoffset'  => 0, 
        'xadvance' => 41, 
        'bitmap'   => [ 
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
        ], 
    }, 
    '161' => {    # '¡'
        'width'    => 8, 
        'xoffset'  => 9, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x3C, ##    0000  
            0x7E, ##   000000 
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0x7E, ##   000000 
            0x3C, ##    0000  
            0x00, ##          
            0x00, ##          
            0x00, ##          
            0x00, ##          
            0x00, ##          
            0x00, ##          
            0x3C, ##    0000  
            0x3C, ##    0000  
            0x3C, ##    0000  
            0x3C, ##    0000  
            0x3C, ##    0000  
            0x3C, ##    0000  
            0x3C, ##    0000  
            0x3C, ##    0000  
            0x3C, ##    0000  
            0x3C, ##    0000  
            0x3C, ##    0000  
            0x3C, ##    0000  
            0x3C, ##    0000  
            0x3C, ##    0000  
            0x7E, ##   000000 
            0x7E, ##   000000 
            0x7E, ##   000000 
            0x7E, ##   000000 
            0x7E, ##   000000 
            0x7E, ##   000000 
            0x7E, ##   000000 
            0x7E, ##   000000 
            0x7E, ##   000000 
            0x7E, ##   000000 
            0x7E, ##   000000 
            0x7E, ##   000000 
            0x7E, ##   000000 
            0xFE, ##  0000000 
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '162' => {    # '¢'
        'width'    => 30, 
        'xoffset'  => 5, 
        'xadvance' => 41, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x01, 0xC0, 0x00, ##                 000            
            0x00, 0x01, 0xC0, 0x00, ##                 000            
            0x00, 0x01, 0xC0, 0x00, ##                 000            
            0x00, 0x01, 0xC0, 0x00, ##                 000            
            0x00, 0x01, 0xC0, 0x00, ##                 000            
            0x00, 0x01, 0xC0, 0x00, ##                 000            
            0x00, 0x01, 0xC0, 0x00, ##                 000            
            0x00, 0x01, 0xC0, 0x00, ##                 000            
            0x00, 0x01, 0xC0, 0x00, ##                 000            
            0x00, 0x1F, 0xFE, 0x00, ##             000000000000       
            0x00, 0xFF, 0xFF, 0xC0, ##          000000000000000000    
            0x01, 0xFF, 0xFF, 0xF0, ##         000000000000000000000  
            0x07, 0xF9, 0xC7, 0xF8, ##       00000000  000   00000000 
            0x0F, 0xE1, 0xC3, 0xF8, ##      0000000    000    0000000 
            0x0F, 0xC1, 0xC1, 0xF8, ##      000000     000     000000 
            0x1F, 0x81, 0xC0, 0xF8, ##     000000      000      00000 
            0x3F, 0x81, 0xC0, 0xF8, ##    0000000      000      00000 
            0x3F, 0x01, 0xC0, 0x78, ##    000000       000       0000 
            0x7F, 0x01, 0xC0, 0x78, ##   0000000       000       0000 
            0x7F, 0x01, 0xC0, 0x78, ##   0000000       000       0000 
            0x7E, 0x01, 0xC0, 0x00, ##   000000        000            
            0xFE, 0x01, 0xC0, 0x00, ##  0000000        000            
            0xFE, 0x01, 0xC0, 0x00, ##  0000000        000            
            0xFE, 0x01, 0xC0, 0x00, ##  0000000        000            
            0xFE, 0x01, 0xC0, 0x00, ##  0000000        000            
            0xFE, 0x01, 0xC0, 0x00, ##  0000000        000            
            0xFE, 0x01, 0xC0, 0x00, ##  0000000        000            
            0xFE, 0x01, 0xC0, 0x00, ##  0000000        000            
            0xFE, 0x01, 0xC0, 0x00, ##  0000000        000            
            0xFE, 0x01, 0xC0, 0x00, ##  0000000        000            
            0xFE, 0x01, 0xC0, 0x00, ##  0000000        000            
            0x7E, 0x01, 0xC0, 0x00, ##   000000        000            
            0x7F, 0x01, 0xC0, 0x00, ##   0000000       000            
            0x7F, 0x01, 0xC0, 0x78, ##   0000000       000       0000 
            0x3F, 0x01, 0xC0, 0x78, ##    000000       000       0000 
            0x3F, 0x01, 0xC0, 0xF8, ##    000000       000      00000 
            0x1F, 0x81, 0xC0, 0xF0, ##     000000      000      0000  
            0x1F, 0xC1, 0xC1, 0xF0, ##     0000000     000     00000  
            0x0F, 0xC1, 0xC3, 0xE0, ##      000000     000    00000   
            0x07, 0xF1, 0xC7, 0xE0, ##       0000000   000   000000   
            0x03, 0xFD, 0xDF, 0xC0, ##        00000000 000 0000000    
            0x00, 0xFF, 0xFF, 0x00, ##          0000000000000000      
            0x00, 0x3F, 0xFC, 0x00, ##            000000000000        
            0x00, 0x03, 0xE0, 0x00, ##                00000           
            0x00, 0x01, 0xC0, 0x00, ##                 000            
            0x00, 0x01, 0xC0, 0x00, ##                 000            
            0x00, 0x01, 0xC0, 0x00, ##                 000            
            0x00, 0x01, 0xC0, 0x00, ##                 000            
            0x00, 0x01, 0xC0, 0x00, ##                 000            
            0x00, 0x01, 0xC0, 0x00, ##                 000            
            0x00, 0x01, 0xC0, 0x00, ##                 000            
            0x00, 0x01, 0xC0, 0x00, ##                 000            
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '163' => {    # '£'
        'width'    => 31, 
        'xoffset'  => 4, 
        'xadvance' => 41, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x01, 0xFF, 0xC0, ##                 00000000000     
            0x00, 0x0F, 0xFF, 0xFC, ##              000000000000000000 
            0x00, 0x1F, 0xFF, 0xFC, ##             0000000000000000000 
            0x00, 0x7F, 0x81, 0xFC, ##           00000000      0000000 
            0x00, 0xFE, 0x00, 0xFC, ##          0000000         000000 
            0x00, 0xFC, 0x00, 0x7C, ##          000000           00000 
            0x01, 0xF8, 0x00, 0x3C, ##         000000             0000 
            0x01, 0xF8, 0x00, 0x3C, ##         000000             0000 
            0x03, 0xF0, 0x00, 0x1C, ##        000000               000 
            0x03, 0xF0, 0x00, 0x00, ##        000000                   
            0x03, 0xF0, 0x00, 0x00, ##        000000                   
            0x03, 0xF0, 0x00, 0x00, ##        000000                   
            0x03, 0xF0, 0x00, 0x00, ##        000000                   
            0x03, 0xF0, 0x00, 0x00, ##        000000                   
            0x03, 0xF0, 0x00, 0x00, ##        000000                   
            0x03, 0xF0, 0x00, 0x00, ##        000000                   
            0x03, 0xF0, 0x00, 0x00, ##        000000                   
            0x03, 0xF0, 0x00, 0x00, ##        000000                   
            0x03, 0xF0, 0x00, 0x00, ##        000000                   
            0x03, 0xF0, 0x00, 0x00, ##        000000                   
            0x03, 0xF0, 0x00, 0x00, ##        000000                   
            0x03, 0xF0, 0x00, 0x00, ##        000000                   
            0xFF, 0xFF, 0xFF, 0x80, ##  0000000000000000000000000      
            0xFF, 0xFF, 0xFF, 0x80, ##  0000000000000000000000000      
            0xFF, 0xFF, 0xFF, 0x80, ##  0000000000000000000000000      
            0x03, 0xF0, 0x00, 0x00, ##        000000                   
            0x03, 0xF0, 0x00, 0x00, ##        000000                   
            0x03, 0xF0, 0x00, 0x00, ##        000000                   
            0x03, 0xF0, 0x00, 0x00, ##        000000                   
            0x03, 0xF0, 0x00, 0x00, ##        000000                   
            0x03, 0xF0, 0x00, 0x00, ##        000000                   
            0x03, 0xF0, 0x00, 0x00, ##        000000                   
            0x03, 0xF0, 0x00, 0x00, ##        000000                   
            0x03, 0xF0, 0x00, 0x00, ##        000000                   
            0x03, 0xF0, 0x00, 0x00, ##        000000                   
            0x03, 0xF0, 0x00, 0x00, ##        000000                   
            0x03, 0xF0, 0x00, 0x1E, ##        000000               0000
            0x03, 0xF0, 0x00, 0x1E, ##        000000               0000
            0x03, 0xF0, 0x00, 0x1E, ##        000000               0000
            0x03, 0xF0, 0x00, 0x1E, ##        000000               0000
            0x03, 0xF0, 0x00, 0x1E, ##        000000               0000
            0x03, 0xF0, 0x00, 0x1E, ##        000000               0000
            0x03, 0xF0, 0x00, 0x1E, ##        000000               0000
            0xFF, 0xFF, 0xFF, 0xFE, ##  0000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFE, ##  0000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFE, ##  0000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFE, ##  0000000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '164' => {    # '¤'
        'width'    => 35, 
        'xoffset'  => 3, 
        'xadvance' => 41, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                     
            0x30, 0x00, 0x00, 0x01, 0x80, ##    00                           00  
            0x78, 0x00, 0x00, 0x07, 0xC0, ##   0000                        00000 
            0x7C, 0x00, 0x00, 0x0F, 0xC0, ##   00000                      000000 
            0x3E, 0x03, 0xF8, 0x1F, 0x80, ##    00000       0000000      000000  
            0x1F, 0x8F, 0xFF, 0x3F, 0x00, ##     000000   000000000000  000000   
            0x0F, 0xFF, 0xFF, 0xFE, 0x00, ##      000000000000000000000000000    
            0x07, 0xFF, 0xFF, 0xFC, 0x00, ##       0000000000000000000000000     
            0x03, 0xFF, 0xFF, 0xF8, 0x00, ##        00000000000000000000000      
            0x01, 0xFE, 0x0F, 0xF0, 0x00, ##         00000000     00000000       
            0x03, 0xF8, 0x03, 0xF8, 0x00, ##        0000000         0000000      
            0x03, 0xE0, 0x00, 0xF8, 0x00, ##        00000             00000      
            0x07, 0xE0, 0x00, 0xFC, 0x00, ##       000000             000000     
            0x07, 0xC0, 0x00, 0x7C, 0x00, ##       00000               00000     
            0x0F, 0x80, 0x00, 0x7E, 0x00, ##      00000                000000    
            0x0F, 0x80, 0x00, 0x3E, 0x00, ##      00000                 00000    
            0x0F, 0x80, 0x00, 0x3E, 0x00, ##      00000                 00000    
            0x0F, 0x80, 0x00, 0x3E, 0x00, ##      00000                 00000    
            0x0F, 0x80, 0x00, 0x3E, 0x00, ##      00000                 00000    
            0x0F, 0x80, 0x00, 0x3E, 0x00, ##      00000                 00000    
            0x0F, 0x80, 0x00, 0x7E, 0x00, ##      00000                000000    
            0x07, 0xC0, 0x00, 0x7C, 0x00, ##       00000               00000     
            0x07, 0xE0, 0x00, 0xFC, 0x00, ##       000000             000000     
            0x07, 0xE0, 0x00, 0xF8, 0x00, ##       000000             00000      
            0x03, 0xF8, 0x03, 0xF8, 0x00, ##        0000000         0000000      
            0x03, 0xFE, 0x0F, 0xF8, 0x00, ##        000000000     000000000      
            0x07, 0xFF, 0xFF, 0xFC, 0x00, ##       0000000000000000000000000     
            0x0F, 0xFF, 0xFF, 0xFE, 0x00, ##      000000000000000000000000000    
            0x1F, 0xBF, 0xFF, 0xFF, 0x00, ##     000000 0000000000000000000000   
            0x1F, 0x1F, 0xFE, 0x3F, 0x80, ##     00000   000000000000   0000000  
            0x3E, 0x03, 0xF8, 0x1F, 0xC0, ##    00000       0000000      0000000 
            0x7C, 0x00, 0x00, 0x07, 0xE0, ##   00000                       000000
            0x78, 0x00, 0x00, 0x03, 0xC0, ##   0000                         0000 
            0x30, 0x00, 0x00, 0x01, 0x80, ##    00                           00  
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                     
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '165' => {    # '¥'
        'width'    => 42, 
        'xoffset'  => 0, 
        'xadvance' => 42, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0x80, 0x0F, 0xFF, 0xC0, ##  00000000000000000           00000000000000
            0xFF, 0xFF, 0x80, 0x0F, 0xFF, 0xC0, ##  00000000000000000           00000000000000
            0xFF, 0xFF, 0x80, 0x0F, 0xFF, 0xC0, ##  00000000000000000           00000000000000
            0x07, 0xF0, 0x00, 0x00, 0x78, 0x00, ##       0000000                     0000     
            0x07, 0xF8, 0x00, 0x00, 0xF0, 0x00, ##       00000000                   0000      
            0x03, 0xF8, 0x00, 0x00, 0xF0, 0x00, ##        0000000                   0000      
            0x03, 0xFC, 0x00, 0x01, 0xE0, 0x00, ##        00000000                 0000       
            0x01, 0xFE, 0x00, 0x01, 0xE0, 0x00, ##         00000000                0000       
            0x00, 0xFE, 0x00, 0x03, 0xC0, 0x00, ##          0000000               0000        
            0x00, 0xFF, 0x00, 0x07, 0x80, 0x00, ##          00000000             0000         
            0x00, 0x7F, 0x00, 0x07, 0x80, 0x00, ##           0000000             0000         
            0x00, 0x7F, 0x80, 0x0F, 0x00, 0x00, ##           00000000           0000          
            0x00, 0x3F, 0x80, 0x0F, 0x00, 0x00, ##            0000000           0000          
            0x00, 0x1F, 0xC0, 0x1E, 0x00, 0x00, ##             0000000         0000           
            0x00, 0x1F, 0xE0, 0x3C, 0x00, 0x00, ##             00000000       0000            
            0x00, 0x0F, 0xE0, 0x3C, 0x00, 0x00, ##              0000000       0000            
            0x00, 0x0F, 0xF0, 0x78, 0x00, 0x00, ##              00000000     0000             
            0x00, 0x07, 0xF0, 0x78, 0x00, 0x00, ##               0000000     0000             
            0x07, 0xFF, 0xF8, 0xFF, 0xF8, 0x00, ##       0000000000000000   0000000000000     
            0x07, 0xFF, 0xF9, 0xFF, 0xF8, 0x00, ##       0000000000000000  00000000000000     
            0x07, 0xFF, 0xFD, 0xFF, 0xF8, 0x00, ##       00000000000000000 00000000000000     
            0x00, 0x01, 0xFF, 0xC0, 0x00, 0x00, ##                 00000000000                
            0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                  000000000                 
            0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                  000000000                 
            0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, ##                  00000000                  
            0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, ##                   0000000                  
            0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, ##                   0000000                  
            0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, ##                   0000000                  
            0x07, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, ##       00000000000000000000000000000000     
            0x07, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, ##       00000000000000000000000000000000     
            0x07, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, ##       00000000000000000000000000000000     
            0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, ##                   0000000                  
            0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, ##                   0000000                  
            0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, ##                   0000000                  
            0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, ##                   0000000                  
            0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, ##                   0000000                  
            0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, ##                   0000000                  
            0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, ##                   0000000                  
            0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, ##                   0000000                  
            0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, ##                   0000000                  
            0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, ##                   0000000                  
            0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, ##                   0000000                  
            0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, ##                   0000000                  
            0x00, 0x0F, 0xFF, 0xFC, 0x00, 0x00, ##              000000000000000000            
            0x00, 0x0F, 0xFF, 0xFC, 0x00, 0x00, ##              000000000000000000            
            0x00, 0x0F, 0xFF, 0xFC, 0x00, 0x00, ##              000000000000000000            
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '166' => {    # '¦'
        'width'    => 5, 
        'xoffset'  => 8, 
        'xadvance' => 21, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0x00, ##       
            0x00, ##       
            0x00, ##       
            0x00, ##       
            0x00, ##       
            0x00, ##       
            0x00, ##       
            0x00, ##       
            0x00, ##       
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '167' => {    # '§'
        'width'    => 26, 
        'xoffset'  => 3, 
        'xadvance' => 32, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x7F, 0xE0, 0x00, ##           0000000000       
            0x01, 0xFF, 0xFE, 0x00, ##         0000000000000000   
            0x07, 0xFF, 0xFE, 0x00, ##       000000000000000000   
            0x0F, 0xE0, 0x7E, 0x00, ##      0000000      000000   
            0x1F, 0x80, 0x1E, 0x00, ##     000000          0000   
            0x1F, 0x00, 0x1E, 0x00, ##     00000           0000   
            0x3E, 0x00, 0x0E, 0x00, ##    00000             000   
            0x3E, 0x00, 0x0E, 0x00, ##    00000             000   
            0x3E, 0x00, 0x00, 0x00, ##    00000                   
            0x3E, 0x00, 0x00, 0x00, ##    00000                   
            0x3F, 0x00, 0x00, 0x00, ##    000000                  
            0x3F, 0x00, 0x00, 0x00, ##    000000                  
            0x1F, 0xC0, 0x00, 0x00, ##     0000000                
            0x1F, 0xE0, 0x00, 0x00, ##     00000000               
            0x0F, 0xF0, 0x00, 0x00, ##      00000000              
            0x07, 0xFC, 0x00, 0x00, ##       000000000            
            0x03, 0xFF, 0x00, 0x00, ##        0000000000          
            0x07, 0xFF, 0xC0, 0x00, ##       0000000000000        
            0x1F, 0x3F, 0xE0, 0x00, ##     00000  000000000       
            0x3E, 0x0F, 0xF8, 0x00, ##    00000     000000000     
            0x7C, 0x07, 0xFC, 0x00, ##   00000       000000000    
            0x78, 0x01, 0xFE, 0x00, ##   0000          00000000   
            0xF8, 0x00, 0xFF, 0x00, ##  00000           00000000  
            0xF8, 0x00, 0x3F, 0x80, ##  00000             0000000 
            0xF8, 0x00, 0x1F, 0x80, ##  00000              000000 
            0xF8, 0x00, 0x0F, 0xC0, ##  00000               000000
            0xFC, 0x00, 0x0F, 0xC0, ##  000000              000000
            0xFE, 0x00, 0x07, 0xC0, ##  0000000              00000
            0x7F, 0x00, 0x07, 0xC0, ##   0000000             00000
            0x7F, 0x80, 0x07, 0xC0, ##   00000000            00000
            0x3F, 0xE0, 0x07, 0xC0, ##    000000000          00000
            0x1F, 0xF0, 0x0F, 0x80, ##     000000000        00000 
            0x07, 0xFC, 0x0F, 0x80, ##       000000000      00000 
            0x03, 0xFE, 0x1F, 0x00, ##        000000000    00000  
            0x00, 0xFF, 0xBC, 0x00, ##          000000000 0000    
            0x00, 0x7F, 0xF8, 0x00, ##           000000000000     
            0x00, 0x1F, 0xF0, 0x00, ##             000000000      
            0x00, 0x07, 0xF8, 0x00, ##               00000000     
            0x00, 0x03, 0xFC, 0x00, ##                00000000    
            0x00, 0x00, 0xFE, 0x00, ##                  0000000   
            0x00, 0x00, 0x7E, 0x00, ##                   000000   
            0x00, 0x00, 0x3F, 0x00, ##                    000000  
            0x00, 0x00, 0x1F, 0x00, ##                     00000  
            0x00, 0x00, 0x1F, 0x00, ##                     00000  
            0x00, 0x00, 0x1F, 0x00, ##                     00000  
            0x38, 0x00, 0x1F, 0x00, ##    000              00000  
            0x38, 0x00, 0x1F, 0x00, ##    000              00000  
            0x3C, 0x00, 0x3E, 0x00, ##    0000            00000   
            0x3C, 0x00, 0x7E, 0x00, ##    0000           000000   
            0x3F, 0x01, 0xFC, 0x00, ##    000000       0000000    
            0x3F, 0xFF, 0xF8, 0x00, ##    0000000000000000000     
            0x3F, 0xFF, 0xE0, 0x00, ##    00000000000000000       
            0x03, 0xFF, 0x80, 0x00, ##        00000000000         
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '168' => {    # '¨'
        'width'    => 19, 
        'xoffset'  => 6, 
        'xadvance' => 31, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x38, 0x03, 0x80, ##    000         000  
            0x7C, 0x07, 0xC0, ##   00000       00000 
            0xFE, 0x0F, 0xE0, ##  0000000     0000000
            0xFE, 0x0F, 0xE0, ##  0000000     0000000
            0xFE, 0x0F, 0xE0, ##  0000000     0000000
            0x7C, 0x07, 0xC0, ##   00000       00000 
            0x38, 0x03, 0x80, ##    000         000  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '169' => {    # '©'
        'width'    => 46, 
        'xoffset'  => 9, 
        'xadvance' => 64, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x3F, 0xF0, 0x00, 0x00, ##                    0000000000                  
            0x00, 0x01, 0xFF, 0xFE, 0x00, 0x00, ##                 0000000000000000               
            0x00, 0x07, 0xFF, 0xFF, 0x80, 0x00, ##               00000000000000000000             
            0x00, 0x1F, 0xE0, 0x1F, 0xE0, 0x00, ##             00000000        00000000           
            0x00, 0x7E, 0x00, 0x01, 0xF8, 0x00, ##           000000                000000         
            0x00, 0xF8, 0x00, 0x00, 0x7C, 0x00, ##          00000                    00000        
            0x01, 0xF0, 0x00, 0x00, 0x3E, 0x00, ##         00000                      00000       
            0x03, 0xC0, 0x00, 0x00, 0x0F, 0x00, ##        0000                          0000      
            0x07, 0x80, 0x00, 0x00, 0x07, 0x80, ##       0000                            0000     
            0x0F, 0x00, 0x0F, 0xE0, 0x03, 0xC0, ##      0000            0000000           0000    
            0x0E, 0x00, 0x7F, 0xFC, 0x01, 0xC0, ##      000          0000000000000         000    
            0x1E, 0x00, 0xFF, 0xFF, 0x01, 0xE0, ##     0000         0000000000000000       0000   
            0x3C, 0x01, 0xF8, 0x1F, 0x80, 0xE0, ##    0000         000000      000000       000   
            0x38, 0x03, 0xE0, 0x0F, 0x80, 0x70, ##    000         00000         00000        000  
            0x38, 0x07, 0xC0, 0x07, 0x80, 0x70, ##    000        00000           0000        000  
            0x70, 0x07, 0x80, 0x03, 0x80, 0x38, ##   000         0000             000         000 
            0x70, 0x0F, 0x80, 0x03, 0x80, 0x38, ##   000        00000             000         000 
            0x70, 0x0F, 0x80, 0x03, 0x80, 0x38, ##   000        00000             000         000 
            0xE0, 0x1F, 0x00, 0x00, 0x00, 0x1C, ##  000        00000                           000
            0xE0, 0x1F, 0x00, 0x00, 0x00, 0x1C, ##  000        00000                           000
            0xE0, 0x1F, 0x00, 0x00, 0x00, 0x1C, ##  000        00000                           000
            0xE0, 0x1F, 0x00, 0x00, 0x00, 0x1C, ##  000        00000                           000
            0xE0, 0x1F, 0x00, 0x00, 0x00, 0x1C, ##  000        00000                           000
            0xE0, 0x1F, 0x00, 0x00, 0x00, 0x1C, ##  000        00000                           000
            0xE0, 0x1F, 0x00, 0x00, 0x00, 0x1C, ##  000        00000                           000
            0xE0, 0x1F, 0x00, 0x00, 0x00, 0x1C, ##  000        00000                           000
            0xE0, 0x1F, 0x00, 0x00, 0x00, 0x1C, ##  000        00000                           000
            0xE0, 0x1F, 0x00, 0x00, 0x00, 0x3C, ##  000        00000                          0000
            0x70, 0x0F, 0x80, 0x03, 0xC0, 0x38, ##   000        00000             0000        000 
            0x70, 0x0F, 0x80, 0x03, 0xC0, 0x38, ##   000        00000             0000        000 
            0x70, 0x07, 0x80, 0x03, 0x80, 0x38, ##   000         0000             000         000 
            0x38, 0x07, 0xC0, 0x07, 0x80, 0x70, ##    000        00000           0000        000  
            0x38, 0x03, 0xE0, 0x0F, 0x00, 0x70, ##    000         00000         0000         000  
            0x3C, 0x01, 0xF8, 0x3F, 0x00, 0xF0, ##    0000         000000     000000        0000  
            0x1E, 0x00, 0xFF, 0xFE, 0x01, 0xE0, ##     0000         000000000000000        0000   
            0x0E, 0x00, 0x7F, 0xF8, 0x01, 0xC0, ##      000          000000000000          000    
            0x0F, 0x00, 0x0F, 0xE0, 0x03, 0xC0, ##      0000            0000000           0000    
            0x07, 0x80, 0x00, 0x00, 0x07, 0x80, ##       0000                            0000     
            0x03, 0xC0, 0x00, 0x00, 0x0F, 0x00, ##        0000                          0000      
            0x01, 0xF0, 0x00, 0x00, 0x3E, 0x00, ##         00000                      00000       
            0x00, 0xF8, 0x00, 0x00, 0x7C, 0x00, ##          00000                    00000        
            0x00, 0x7E, 0x00, 0x01, 0xF8, 0x00, ##           000000                000000         
            0x00, 0x1F, 0xC0, 0x0F, 0xE0, 0x00, ##             0000000          0000000           
            0x00, 0x0F, 0xFF, 0xFF, 0xC0, 0x00, ##              0000000000000000000000            
            0x00, 0x01, 0xFF, 0xFE, 0x00, 0x00, ##                 0000000000000000               
            0x00, 0x00, 0x3F, 0xF0, 0x00, 0x00, ##                    0000000000                  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '170' => {    # 'ª'
        'width'    => 24, 
        'xoffset'  => 4, 
        'xadvance' => 30, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x03, 0xFE, 0x00, ##        000000000         
            0x3F, 0xFF, 0xC0, ##    0000000000000000      
            0x3E, 0x07, 0xE0, ##    00000      000000     
            0x3C, 0x01, 0xF0, ##    0000         00000    
            0x38, 0x00, 0xF8, ##    000           00000   
            0x30, 0x00, 0x78, ##    00             0000   
            0x00, 0x00, 0x7C, ##                   00000  
            0x00, 0x00, 0x7C, ##                   00000  
            0x00, 0x00, 0x7C, ##                   00000  
            0x03, 0xFF, 0xFC, ##        0000000000000000  
            0x0F, 0xFF, 0xFC, ##      000000000000000000  
            0x3F, 0x00, 0x7C, ##    000000         00000  
            0x7C, 0x00, 0x7C, ##   00000           00000  
            0x7C, 0x00, 0x7C, ##   00000           00000  
            0xF8, 0x00, 0x7C, ##  00000            00000  
            0xF8, 0x00, 0x7C, ##  00000            00000  
            0xF8, 0x00, 0x7C, ##  00000            00000  
            0xF8, 0x00, 0x7C, ##  00000            00000  
            0xF8, 0x00, 0x7C, ##  00000            00000  
            0x7C, 0x00, 0xFC, ##   00000          000000  
            0x7C, 0x01, 0xFC, ##   00000         0000000  
            0x3F, 0x03, 0xFF, ##    000000      0000000000
            0x1F, 0xFE, 0x7F, ##     000000000000  0000000
            0x07, 0xF8, 0x00, ##       00000000           
            0x00, 0x00, 0x00, ##                          
            0x00, 0x00, 0x00, ##                          
            0x00, 0x00, 0x00, ##                          
            0x7F, 0xFF, 0xFE, ##   0000000000000000000000 
            0x7F, 0xFF, 0xFE, ##   0000000000000000000000 
            0x7F, 0xFF, 0xFE, ##   0000000000000000000000 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '171' => {    # '«'
        'width'    => 28, 
        'xoffset'  => 5, 
        'xadvance' => 39, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x02, 0x00, 0x10, ##                0            0
            0x00, 0x06, 0x00, 0x30, ##               00           00
            0x00, 0x0E, 0x00, 0x70, ##              000          000
            0x00, 0x1E, 0x00, 0xF0, ##             0000         0000
            0x00, 0x3C, 0x01, 0xE0, ##            0000         0000 
            0x00, 0xF8, 0x03, 0xC0, ##          00000         0000  
            0x01, 0xF0, 0x07, 0xC0, ##         00000         00000  
            0x03, 0xE0, 0x0F, 0x80, ##        00000         00000   
            0x07, 0xC0, 0x1F, 0x00, ##       00000         00000    
            0x0F, 0x80, 0x7E, 0x00, ##      00000        000000     
            0x1F, 0x80, 0xFC, 0x00, ##     000000       000000      
            0x3F, 0x01, 0xF8, 0x00, ##    000000       000000       
            0x7E, 0x03, 0xF0, 0x00, ##   000000       000000        
            0xFC, 0x07, 0xE0, 0x00, ##  000000       000000         
            0xFC, 0x07, 0xE0, 0x00, ##  000000       000000         
            0xFC, 0x07, 0xF0, 0x00, ##  000000       0000000        
            0x7E, 0x01, 0xF8, 0x00, ##   000000        000000       
            0x3F, 0x00, 0xFC, 0x00, ##    000000        000000      
            0x1F, 0x80, 0x7C, 0x00, ##     000000        00000      
            0x0F, 0xC0, 0x3E, 0x00, ##      000000        00000     
            0x07, 0xE0, 0x1F, 0x00, ##       000000        00000    
            0x01, 0xE0, 0x0F, 0x80, ##         0000         00000   
            0x00, 0xF0, 0x07, 0xC0, ##          0000         00000  
            0x00, 0x78, 0x03, 0xE0, ##           0000         00000 
            0x00, 0x3C, 0x01, 0xF0, ##            0000         00000
            0x00, 0x1E, 0x00, 0x70, ##             0000          000
            0x00, 0x0E, 0x00, 0x30, ##              000           00
            0x00, 0x06, 0x00, 0x10, ##               00            0
            0x00, 0x02, 0x00, 0x00, ##                0             
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '172' => {    # '¬'
        'width'    => 40, 
        'xoffset'  => 7, 
        'xadvance' => 54, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x1F, ##                                     00000
            0x00, 0x00, 0x00, 0x00, 0x1F, ##                                     00000
            0x00, 0x00, 0x00, 0x00, 0x1F, ##                                     00000
            0x00, 0x00, 0x00, 0x00, 0x1F, ##                                     00000
            0x00, 0x00, 0x00, 0x00, 0x1F, ##                                     00000
            0x00, 0x00, 0x00, 0x00, 0x1F, ##                                     00000
            0x00, 0x00, 0x00, 0x00, 0x1F, ##                                     00000
            0x00, 0x00, 0x00, 0x00, 0x1F, ##                                     00000
            0x00, 0x00, 0x00, 0x00, 0x1F, ##                                     00000
            0x00, 0x00, 0x00, 0x00, 0x1F, ##                                     00000
            0x00, 0x00, 0x00, 0x00, 0x1F, ##                                     00000
            0x00, 0x00, 0x00, 0x00, 0x1F, ##                                     00000
            0x00, 0x00, 0x00, 0x00, 0x1F, ##                                     00000
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '173' => {    # '­'
        'width'    => 16, 
        'xoffset'  => 3, 
        'xadvance' => 22, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xFF, ##  0000000000000000
            0xFF, 0xFF, ##  0000000000000000
            0xFF, 0xFF, ##  0000000000000000
            0xFF, 0xFF, ##  0000000000000000
            0xFF, 0xFF, ##  0000000000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '174' => {    # '®'
        'width'    => 46, 
        'xoffset'  => 9, 
        'xadvance' => 64, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x3F, 0xF0, 0x00, 0x00, ##                    0000000000                  
            0x00, 0x01, 0xFF, 0xFE, 0x00, 0x00, ##                 0000000000000000               
            0x00, 0x07, 0xFF, 0xFF, 0x80, 0x00, ##               00000000000000000000             
            0x00, 0x1F, 0xE0, 0x1F, 0xE0, 0x00, ##             00000000        00000000           
            0x00, 0x7E, 0x00, 0x01, 0xF8, 0x00, ##           000000                000000         
            0x00, 0xF8, 0x00, 0x00, 0x7C, 0x00, ##          00000                    00000        
            0x01, 0xF0, 0x00, 0x00, 0x3E, 0x00, ##         00000                      00000       
            0x03, 0xC0, 0x00, 0x00, 0x0F, 0x00, ##        0000                          0000      
            0x07, 0x80, 0x00, 0x00, 0x07, 0x80, ##       0000                            0000     
            0x0F, 0x00, 0x00, 0x00, 0x03, 0xC0, ##      0000                              0000    
            0x0E, 0x0F, 0xFF, 0xF8, 0x01, 0xC0, ##      000     00000000000000000          000    
            0x1E, 0x0F, 0xFF, 0xFE, 0x01, 0xE0, ##     0000     0000000000000000000        0000   
            0x3C, 0x03, 0xE0, 0x3F, 0x00, 0xE0, ##    0000        00000       000000        000   
            0x38, 0x03, 0xE0, 0x1F, 0x00, 0x70, ##    000         00000        00000         000  
            0x38, 0x03, 0xE0, 0x0F, 0x80, 0x70, ##    000         00000         00000        000  
            0x70, 0x03, 0xE0, 0x0F, 0x80, 0x38, ##   000          00000         00000         000 
            0x70, 0x03, 0xE0, 0x0F, 0x80, 0x38, ##   000          00000         00000         000 
            0x70, 0x03, 0xE0, 0x0F, 0x80, 0x38, ##   000          00000         00000         000 
            0xE0, 0x03, 0xE0, 0x0F, 0x80, 0x1C, ##  000           00000         00000          000
            0xE0, 0x03, 0xE0, 0x1F, 0x00, 0x1C, ##  000           00000        00000           000
            0xE0, 0x03, 0xE0, 0x3F, 0x00, 0x1C, ##  000           00000       000000           000
            0xE0, 0x03, 0xFF, 0xFE, 0x00, 0x1C, ##  000           00000000000000000            000
            0xE0, 0x03, 0xFF, 0xF0, 0x00, 0x1C, ##  000           00000000000000               000
            0xE0, 0x03, 0xE0, 0xF8, 0x00, 0x1C, ##  000           00000     00000              000
            0xE0, 0x03, 0xE0, 0x7C, 0x00, 0x1C, ##  000           00000      00000             000
            0xE0, 0x03, 0xE0, 0x3E, 0x00, 0x1C, ##  000           00000       00000            000
            0xE0, 0x03, 0xE0, 0x3E, 0x00, 0x1C, ##  000           00000       00000            000
            0xE0, 0x03, 0xE0, 0x1F, 0x00, 0x3C, ##  000           00000        00000          0000
            0x70, 0x03, 0xE0, 0x1F, 0x00, 0x38, ##   000          00000        00000          000 
            0x70, 0x03, 0xE0, 0x0F, 0x80, 0x38, ##   000          00000         00000         000 
            0x70, 0x03, 0xE0, 0x0F, 0x80, 0x38, ##   000          00000         00000         000 
            0x38, 0x03, 0xE0, 0x07, 0xC0, 0x70, ##    000         00000          00000       000  
            0x38, 0x03, 0xE0, 0x07, 0xC0, 0x70, ##    000         00000          00000       000  
            0x3C, 0x0F, 0xFC, 0x03, 0xF8, 0xF0, ##    0000      0000000000        0000000   0000  
            0x1E, 0x0F, 0xFC, 0x03, 0xF9, 0xE0, ##     0000     0000000000        0000000  0000   
            0x0E, 0x00, 0x00, 0x00, 0x01, 0xC0, ##      000                                000    
            0x0F, 0x00, 0x00, 0x00, 0x03, 0xC0, ##      0000                              0000    
            0x07, 0x80, 0x00, 0x00, 0x07, 0x80, ##       0000                            0000     
            0x03, 0xC0, 0x00, 0x00, 0x0F, 0x00, ##        0000                          0000      
            0x01, 0xF0, 0x00, 0x00, 0x3E, 0x00, ##         00000                      00000       
            0x00, 0xF8, 0x00, 0x00, 0x7C, 0x00, ##          00000                    00000        
            0x00, 0x7E, 0x00, 0x01, 0xF8, 0x00, ##           000000                000000         
            0x00, 0x1F, 0xC0, 0x0F, 0xE0, 0x00, ##             0000000          0000000           
            0x00, 0x0F, 0xFF, 0xFF, 0xC0, 0x00, ##              0000000000000000000000            
            0x00, 0x01, 0xFF, 0xFE, 0x00, 0x00, ##                 0000000000000000               
            0x00, 0x00, 0x3F, 0xF0, 0x00, 0x00, ##                    0000000000                  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '175' => {    # '¯'
        'width'    => 19, 
        'xoffset'  => 7, 
        'xadvance' => 33, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '176' => {    # '°'
        'width'    => 20, 
        'xoffset'  => 6, 
        'xadvance' => 32, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x01, 0xF8, 0x00, ##         000000       
            0x07, 0xFE, 0x00, ##       0000000000     
            0x1F, 0xFF, 0x80, ##     00000000000000   
            0x3F, 0xFF, 0xC0, ##    0000000000000000  
            0x3F, 0x0F, 0xC0, ##    000000    000000  
            0x7C, 0x03, 0xE0, ##   00000        00000 
            0x78, 0x01, 0xE0, ##   0000          0000 
            0xF8, 0x01, 0xF0, ##  00000          00000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x01, 0xF0, ##  0000           00000
            0x78, 0x01, 0xE0, ##   0000          0000 
            0x7C, 0x03, 0xE0, ##   00000        00000 
            0x7E, 0x0F, 0xC0, ##   000000     000000  
            0x3F, 0xFF, 0xC0, ##    0000000000000000  
            0x1F, 0xFF, 0x80, ##     00000000000000   
            0x0F, 0xFE, 0x00, ##      00000000000     
            0x01, 0xF8, 0x00, ##         000000       
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '177' => {    # '±'
        'width'    => 40, 
        'xoffset'  => 7, 
        'xadvance' => 54, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                          
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                          
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                          
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                          
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                          
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                          
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '178' => {    # '²'
        'width'    => 19, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x07, 0xF8, 0x00, ##       00000000      
            0x7F, 0xFE, 0x00, ##   00000000000000    
            0xFC, 0x1F, 0x80, ##  000000     000000  
            0xF0, 0x0F, 0xC0, ##  0000        000000 
            0xE0, 0x07, 0xC0, ##  000          00000 
            0xE0, 0x03, 0xE0, ##  000           00000
            0xE0, 0x03, 0xE0, ##  000           00000
            0x00, 0x03, 0xE0, ##                00000
            0x00, 0x03, 0xE0, ##                00000
            0x00, 0x03, 0xE0, ##                00000
            0x00, 0x03, 0xC0, ##                0000 
            0x00, 0x07, 0xC0, ##               00000 
            0x00, 0x0F, 0x80, ##              00000  
            0x00, 0x0F, 0x00, ##              0000   
            0x00, 0x1E, 0x00, ##             0000    
            0x00, 0x3C, 0x00, ##            0000     
            0x00, 0x78, 0x00, ##           0000      
            0x00, 0xF0, 0x00, ##          0000       
            0x01, 0xE0, 0x00, ##         0000        
            0x07, 0xC0, 0x00, ##       00000         
            0x0F, 0x00, 0x00, ##      0000           
            0x1E, 0x00, 0x60, ##     0000          00
            0x3C, 0x00, 0x60, ##    0000           00
            0x78, 0x00, 0x60, ##   0000            00
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '179' => {    # '³'
        'width'    => 19, 
        'xoffset'  => 3, 
        'xadvance' => 25, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x0F, 0xF8, 0x00, ##      000000000      
            0x7F, 0xFE, 0x00, ##   00000000000000    
            0x78, 0x1F, 0x80, ##   0000      000000  
            0x70, 0x0F, 0x80, ##   000        00000  
            0x60, 0x07, 0xC0, ##   00          00000 
            0x60, 0x07, 0xC0, ##   00          00000 
            0x00, 0x07, 0xC0, ##               00000 
            0x00, 0x07, 0xC0, ##               00000 
            0x00, 0x07, 0x80, ##               0000  
            0x00, 0x0F, 0x80, ##              00000  
            0x00, 0x3F, 0x00, ##            000000   
            0x03, 0xF8, 0x00, ##        0000000      
            0x03, 0xFC, 0x00, ##        00000000     
            0x00, 0x1F, 0x00, ##             00000   
            0x00, 0x0F, 0x80, ##              00000  
            0x00, 0x07, 0xC0, ##               00000 
            0x00, 0x03, 0xC0, ##                0000 
            0x00, 0x03, 0xE0, ##                00000
            0x00, 0x03, 0xE0, ##                00000
            0x00, 0x03, 0xE0, ##                00000
            0xC0, 0x03, 0xE0, ##  00            00000
            0xC0, 0x03, 0xE0, ##  00            00000
            0xE0, 0x07, 0xC0, ##  000          00000 
            0xE0, 0x0F, 0xC0, ##  000         000000 
            0xF8, 0x1F, 0x80, ##  00000      000000  
            0xFF, 0xFF, 0x00, ##  0000000000000000   
            0x0F, 0xF8, 0x00, ##      000000000      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '180' => {    # '´'
        'width'    => 15, 
        'xoffset'  => 12, 
        'xadvance' => 32, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0xFE, ##          0000000
            0x00, 0xFC, ##          000000 
            0x01, 0xF8, ##         000000  
            0x03, 0xF0, ##        000000   
            0x03, 0xE0, ##        00000    
            0x07, 0xC0, ##       00000     
            0x0F, 0x80, ##      00000      
            0x1F, 0x00, ##     00000       
            0x1E, 0x00, ##     0000        
            0x3C, 0x00, ##    0000         
            0x78, 0x00, ##   0000          
            0x70, 0x00, ##   000           
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '181' => {    # 'µ'
        'width'    => 38, 
        'xoffset'  => 2, 
        'xadvance' => 42, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xE0, 0x07, 0xFF, 0x00, ##  00000000000          00000000000      
            0xFF, 0xE0, 0x07, 0xFF, 0x00, ##  00000000000          00000000000      
            0xFF, 0xE0, 0x07, 0xFF, 0x00, ##  00000000000          00000000000      
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000      
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000      
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000      
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000      
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000      
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000      
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000      
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000      
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000      
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000      
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000      
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000      
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000      
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000      
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000      
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000      
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000      
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000      
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000      
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000      
            0x07, 0xE0, 0x00, 0x7F, 0x00, ##       000000              0000000      
            0x07, 0xE0, 0x00, 0x7F, 0x00, ##       000000              0000000      
            0x07, 0xF0, 0x00, 0x7F, 0x00, ##       0000000             0000000      
            0x07, 0xF0, 0x00, 0xFF, 0x00, ##       0000000            00000000      
            0x07, 0xF0, 0x00, 0xFF, 0x00, ##       0000000            00000000      
            0x07, 0xF8, 0x03, 0xBF, 0x00, ##       00000000         000 000000      
            0x07, 0xFE, 0x07, 0xBF, 0x00, ##       0000000000      0000 000000      
            0x07, 0xFF, 0xFF, 0x3F, 0xFC, ##       0000000000000000000  000000000000
            0x07, 0xFF, 0xFE, 0x3F, 0xFC, ##       000000000000000000   000000000000
            0x07, 0xEF, 0xFC, 0x3F, 0xFC, ##       000000 0000000000    000000000000
            0x07, 0xE3, 0xF0, 0x00, 0x00, ##       000000   000000                  
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                           
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                           
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                           
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                           
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                           
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                           
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                           
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                           
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                           
            0xFF, 0xFF, 0x80, 0x00, 0x00, ##  00000000000000000                     
            0xFF, 0xFF, 0x80, 0x00, 0x00, ##  00000000000000000                     
            0xFF, 0xFF, 0x80, 0x00, 0x00, ##  00000000000000000                     
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '182' => {    # '¶'
        'width'    => 32, 
        'xoffset'  => 5, 
        'xadvance' => 41, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x3F, 0xFF, 0xFF, ##            0000000000000000000000
            0x01, 0xFF, 0xFF, 0xFF, ##         0000000000000000000000000
            0x07, 0xFF, 0xFF, 0xFF, ##       000000000000000000000000000
            0x0F, 0xFF, 0x80, 0x70, ##      0000000000000        000    
            0x1F, 0xFF, 0x80, 0x70, ##     00000000000000        000    
            0x3F, 0xFF, 0x80, 0x70, ##    000000000000000        000    
            0x3F, 0xFF, 0x80, 0x70, ##    000000000000000        000    
            0x7F, 0xFF, 0x80, 0x70, ##   0000000000000000        000    
            0x7F, 0xFF, 0x80, 0x70, ##   0000000000000000        000    
            0xFF, 0xFF, 0x80, 0x70, ##  00000000000000000        000    
            0xFF, 0xFF, 0x80, 0x70, ##  00000000000000000        000    
            0xFF, 0xFF, 0x80, 0x70, ##  00000000000000000        000    
            0xFF, 0xFF, 0x80, 0x70, ##  00000000000000000        000    
            0xFF, 0xFF, 0x80, 0x70, ##  00000000000000000        000    
            0xFF, 0xFF, 0x80, 0x70, ##  00000000000000000        000    
            0xFF, 0xFF, 0x80, 0x70, ##  00000000000000000        000    
            0xFF, 0xFF, 0x80, 0x70, ##  00000000000000000        000    
            0x7F, 0xFF, 0x80, 0x70, ##   0000000000000000        000    
            0x7F, 0xFF, 0x80, 0x70, ##   0000000000000000        000    
            0x3F, 0xFF, 0x80, 0x70, ##    000000000000000        000    
            0x3F, 0xFF, 0x80, 0x70, ##    000000000000000        000    
            0x1F, 0xFF, 0x80, 0x70, ##     00000000000000        000    
            0x0F, 0xFF, 0x80, 0x70, ##      0000000000000        000    
            0x07, 0xFF, 0x80, 0x70, ##       000000000000        000    
            0x01, 0xFF, 0x80, 0x70, ##         0000000000        000    
            0x00, 0x3F, 0x80, 0x70, ##            0000000        000    
            0x00, 0x03, 0x80, 0x70, ##                000        000    
            0x00, 0x03, 0x80, 0x70, ##                000        000    
            0x00, 0x03, 0x80, 0x70, ##                000        000    
            0x00, 0x03, 0x80, 0x70, ##                000        000    
            0x00, 0x03, 0x80, 0x70, ##                000        000    
            0x00, 0x03, 0x80, 0x70, ##                000        000    
            0x00, 0x03, 0x80, 0x70, ##                000        000    
            0x00, 0x03, 0x80, 0x70, ##                000        000    
            0x00, 0x03, 0x80, 0x70, ##                000        000    
            0x00, 0x03, 0x80, 0x70, ##                000        000    
            0x00, 0x03, 0x80, 0x70, ##                000        000    
            0x00, 0x03, 0x80, 0x70, ##                000        000    
            0x00, 0x03, 0x80, 0x70, ##                000        000    
            0x00, 0x03, 0x80, 0x70, ##                000        000    
            0x00, 0x03, 0x80, 0x70, ##                000        000    
            0x00, 0x03, 0x80, 0x70, ##                000        000    
            0x00, 0x03, 0x80, 0x70, ##                000        000    
            0x00, 0x03, 0x80, 0x70, ##                000        000    
            0x00, 0x03, 0x80, 0x70, ##                000        000    
            0x00, 0x03, 0x80, 0x70, ##                000        000    
            0x00, 0x03, 0x80, 0x70, ##                000        000    
            0x00, 0x03, 0x80, 0x70, ##                000        000    
            0x00, 0x03, 0x80, 0x70, ##                000        000    
            0x00, 0x03, 0x80, 0x70, ##                000        000    
            0x00, 0x03, 0x80, 0x70, ##                000        000    
            0x00, 0x03, 0x80, 0x70, ##                000        000    
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '183' => {    # '·'
        'width'    => 8, 
        'xoffset'  => 6, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x3C, ##    0000  
            0x7E, ##   000000 
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0x7E, ##   000000 
            0x3C, ##    0000  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '184' => {    # '¸'
        'width'    => 12, 
        'xoffset'  => 10, 
        'xadvance' => 32, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x07, 0x00, ##       000    
            0x03, 0x80, ##        000   
            0x01, 0xC0, ##         000  
            0x01, 0xE0, ##         0000 
            0x00, 0xE0, ##          000 
            0x00, 0xF0, ##          0000
            0x00, 0xF0, ##          0000
            0x00, 0xF0, ##          0000
            0x83, 0xF0, ##  0     000000
            0xFF, 0xF0, ##  000000000000
            0xFF, 0xE0, ##  00000000000 
            0xFF, 0xC0, ##  0000000000  
            0x7F, 0x00, ##   0000000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '185' => {    # '¹'
        'width'    => 16, 
        'xoffset'  => 5, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x01, 0xE0, ##         0000     
            0x07, 0xE0, ##       000000     
            0x1F, 0xE0, ##     00000000     
            0x7F, 0xE0, ##   0000000000     
            0xF9, 0xE0, ##  00000  0000     
            0xE1, 0xE0, ##  000    0000     
            0x81, 0xE0, ##  0      0000     
            0x01, 0xE0, ##         0000     
            0x01, 0xE0, ##         0000     
            0x01, 0xE0, ##         0000     
            0x01, 0xE0, ##         0000     
            0x01, 0xE0, ##         0000     
            0x01, 0xE0, ##         0000     
            0x01, 0xE0, ##         0000     
            0x01, 0xE0, ##         0000     
            0x01, 0xE0, ##         0000     
            0x01, 0xE0, ##         0000     
            0x01, 0xE0, ##         0000     
            0x01, 0xE0, ##         0000     
            0x01, 0xE0, ##         0000     
            0x01, 0xE0, ##         0000     
            0x01, 0xE0, ##         0000     
            0x01, 0xE0, ##         0000     
            0x01, 0xE0, ##         0000     
            0x7F, 0xFF, ##   000000000000000
            0x7F, 0xFF, ##   000000000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '186' => {    # 'º'
        'width'    => 24, 
        'xoffset'  => 3, 
        'xadvance' => 30, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0xFF, 0x00, ##          00000000        
            0x03, 0xFF, 0xC0, ##        000000000000      
            0x0F, 0x81, 0xF0, ##      00000      00000    
            0x1F, 0x00, 0xF8, ##     00000        00000   
            0x3E, 0x00, 0x7C, ##    00000          00000  
            0x3C, 0x00, 0x3C, ##    0000            0000  
            0x7C, 0x00, 0x3E, ##   00000            00000 
            0x7C, 0x00, 0x3E, ##   00000            00000 
            0xF8, 0x00, 0x1F, ##  00000              00000
            0xF8, 0x00, 0x1F, ##  00000              00000
            0xF8, 0x00, 0x1F, ##  00000              00000
            0xF8, 0x00, 0x1F, ##  00000              00000
            0xF8, 0x00, 0x1F, ##  00000              00000
            0xF8, 0x00, 0x1F, ##  00000              00000
            0xF8, 0x00, 0x1F, ##  00000              00000
            0xF8, 0x00, 0x1F, ##  00000              00000
            0x78, 0x00, 0x3E, ##   0000             00000 
            0x7C, 0x00, 0x3E, ##   00000            00000 
            0x3C, 0x00, 0x3C, ##    0000            0000  
            0x3E, 0x00, 0x7C, ##    00000          00000  
            0x1F, 0x00, 0xF8, ##     00000        00000   
            0x0F, 0x81, 0xF0, ##      00000      00000    
            0x03, 0xFF, 0xC0, ##        000000000000      
            0x00, 0xFF, 0x00, ##          00000000        
            0x00, 0x00, 0x00, ##                          
            0x00, 0x00, 0x00, ##                          
            0x00, 0x00, 0x00, ##                          
            0x7F, 0xFF, 0xFE, ##   0000000000000000000000 
            0x7F, 0xFF, 0xFE, ##   0000000000000000000000 
            0x7F, 0xFF, 0xFE, ##   0000000000000000000000 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '187' => {    # '»'
        'width'    => 28, 
        'xoffset'  => 6, 
        'xadvance' => 39, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x80, 0x04, 0x00, 0x00, ##  0            0              
            0xC0, 0x06, 0x00, 0x00, ##  00           00             
            0xE0, 0x07, 0x00, 0x00, ##  000          000            
            0xF0, 0x07, 0x80, 0x00, ##  0000         0000           
            0x78, 0x03, 0xC0, 0x00, ##   0000         0000          
            0x3C, 0x01, 0xF0, 0x00, ##    0000         00000        
            0x3E, 0x00, 0xF8, 0x00, ##    00000         00000       
            0x1F, 0x00, 0x7C, 0x00, ##     00000         00000      
            0x0F, 0x80, 0x3E, 0x00, ##      00000         00000     
            0x07, 0xE0, 0x1F, 0x00, ##       000000        00000    
            0x03, 0xF0, 0x1F, 0x80, ##        000000       000000   
            0x01, 0xF8, 0x0F, 0xC0, ##         000000       000000  
            0x00, 0xFC, 0x07, 0xE0, ##          000000       000000 
            0x00, 0xFE, 0x03, 0xF0, ##          0000000       000000
            0x00, 0x7E, 0x03, 0xF0, ##           000000       000000
            0x00, 0xFE, 0x03, 0xF0, ##          0000000       000000
            0x01, 0xF8, 0x07, 0xE0, ##         000000        000000 
            0x03, 0xF0, 0x0F, 0xC0, ##        000000        000000  
            0x03, 0xE0, 0x1F, 0x80, ##        00000        000000   
            0x07, 0xC0, 0x3F, 0x00, ##       00000        000000    
            0x0F, 0x80, 0x7E, 0x00, ##      00000        000000     
            0x1F, 0x00, 0x78, 0x00, ##     00000         0000       
            0x3E, 0x00, 0xF0, 0x00, ##    00000         0000        
            0x7C, 0x01, 0xE0, 0x00, ##   00000         0000         
            0xF8, 0x03, 0xC0, 0x00, ##  00000         0000          
            0xE0, 0x07, 0x80, 0x00, ##  000          0000           
            0xC0, 0x07, 0x00, 0x00, ##  00           000            
            0x80, 0x06, 0x00, 0x00, ##  0            00             
            0x00, 0x04, 0x00, 0x00, ##               0              
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '188' => {    # '¼'
        'width'    => 56, 
        'xoffset'  => 5, 
        'xadvance' => 63, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x01, 0xE0, 0x00, ##                                         0000             
            0x01, 0xE0, 0x00, 0x00, 0x03, 0xE0, 0x00, ##         0000                           00000             
            0x07, 0xE0, 0x00, 0x00, 0x03, 0xC0, 0x00, ##       000000                           0000              
            0x1F, 0xE0, 0x00, 0x00, 0x07, 0xC0, 0x00, ##     00000000                          00000              
            0x7F, 0xE0, 0x00, 0x00, 0x0F, 0x80, 0x00, ##   0000000000                         00000               
            0xF9, 0xE0, 0x00, 0x00, 0x0F, 0x00, 0x00, ##  00000  0000                         0000                
            0xE1, 0xE0, 0x00, 0x00, 0x1F, 0x00, 0x00, ##  000    0000                        00000                
            0x81, 0xE0, 0x00, 0x00, 0x1E, 0x00, 0x00, ##  0      0000                        0000                 
            0x01, 0xE0, 0x00, 0x00, 0x3E, 0x00, 0x00, ##         0000                       00000                 
            0x01, 0xE0, 0x00, 0x00, 0x7C, 0x00, 0x00, ##         0000                      00000                  
            0x01, 0xE0, 0x00, 0x00, 0x78, 0x00, 0x00, ##         0000                      0000                   
            0x01, 0xE0, 0x00, 0x00, 0xF8, 0x00, 0x00, ##         0000                     00000                   
            0x01, 0xE0, 0x00, 0x00, 0xF0, 0x00, 0x00, ##         0000                     0000                    
            0x01, 0xE0, 0x00, 0x01, 0xF0, 0x00, 0x00, ##         0000                    00000                    
            0x01, 0xE0, 0x00, 0x03, 0xE0, 0x00, 0x00, ##         0000                   00000                     
            0x01, 0xE0, 0x00, 0x03, 0xC0, 0x00, 0x00, ##         0000                   0000                      
            0x01, 0xE0, 0x00, 0x07, 0xC0, 0x00, 0x00, ##         0000                  00000                      
            0x01, 0xE0, 0x00, 0x07, 0x80, 0x00, 0x00, ##         0000                  0000                       
            0x01, 0xE0, 0x00, 0x0F, 0x80, 0x00, 0x00, ##         0000                 00000                       
            0x01, 0xE0, 0x00, 0x1F, 0x00, 0x00, 0x00, ##         0000                00000                        
            0x01, 0xE0, 0x00, 0x1E, 0x00, 0x00, 0x00, ##         0000                0000                         
            0x01, 0xE0, 0x00, 0x3E, 0x00, 0x00, 0x00, ##         0000               00000                         
            0x01, 0xE0, 0x00, 0x3C, 0x00, 0x03, 0xC0, ##         0000               0000                0000      
            0x01, 0xE0, 0x00, 0x7C, 0x00, 0x07, 0xC0, ##         0000              00000               00000      
            0x7F, 0xFF, 0x00, 0xF8, 0x00, 0x0F, 0xC0, ##   000000000000000        00000               000000      
            0x7F, 0xFF, 0x00, 0xF0, 0x00, 0x1F, 0xC0, ##   000000000000000        0000               0000000      
            0x7F, 0xFF, 0x01, 0xF0, 0x00, 0x1B, 0xC0, ##   000000000000000       00000               00 0000      
            0x00, 0x00, 0x01, 0xE0, 0x00, 0x33, 0xC0, ##                         0000               00  0000      
            0x00, 0x00, 0x03, 0xC0, 0x00, 0x73, 0xC0, ##                        0000               000  0000      
            0x00, 0x00, 0x07, 0xC0, 0x00, 0xE3, 0xC0, ##                       00000              000   0000      
            0x00, 0x00, 0x07, 0x80, 0x00, 0xC3, 0xC0, ##                       0000               00    0000      
            0x00, 0x00, 0x0F, 0x80, 0x01, 0x83, 0xC0, ##                      00000              00     0000      
            0x00, 0x00, 0x0F, 0x00, 0x03, 0x83, 0xC0, ##                      0000              000     0000      
            0x00, 0x00, 0x1E, 0x00, 0x07, 0x03, 0xC0, ##                     0000              000      0000      
            0x00, 0x00, 0x3E, 0x00, 0x06, 0x03, 0xC0, ##                    00000              00       0000      
            0x00, 0x00, 0x3C, 0x00, 0x0C, 0x03, 0xC0, ##                    0000              00        0000      
            0x00, 0x00, 0x7C, 0x00, 0x1C, 0x03, 0xC0, ##                   00000             000        0000      
            0x00, 0x00, 0x78, 0x00, 0x38, 0x03, 0xC0, ##                   0000             000         0000      
            0x00, 0x00, 0xF0, 0x00, 0x3F, 0xFF, 0xFF, ##                  0000              0000000000000000000000
            0x00, 0x01, 0xF0, 0x00, 0x3F, 0xFF, 0xFF, ##                 00000              0000000000000000000000
            0x00, 0x01, 0xE0, 0x00, 0x3F, 0xFF, 0xFF, ##                 0000               0000000000000000000000
            0x00, 0x03, 0xE0, 0x00, 0x00, 0x03, 0xC0, ##                00000                           0000      
            0x00, 0x03, 0xC0, 0x00, 0x00, 0x03, 0xC0, ##                0000                            0000      
            0x00, 0x07, 0x80, 0x00, 0x00, 0x03, 0xC0, ##               0000                             0000      
            0x00, 0x0F, 0x80, 0x00, 0x00, 0x03, 0xC0, ##              00000                             0000      
            0x00, 0x0F, 0x00, 0x00, 0x00, 0x7F, 0xFE, ##              0000                         00000000000000 
            0x00, 0x1F, 0x00, 0x00, 0x00, 0x7F, 0xFE, ##             00000                         00000000000000 
            0x00, 0x1E, 0x00, 0x00, 0x00, 0x7F, 0xFE, ##             0000                          00000000000000 
            0x00, 0x3C, 0x00, 0x00, 0x00, 0x00, 0x00, ##            0000                                          
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '189' => {    # '½'
        'width'    => 53, 
        'xoffset'  => 5, 
        'xadvance' => 62, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x03, 0xE0, 0x00, ##                                        00000          
            0x01, 0xE0, 0x00, 0x00, 0x03, 0xC0, 0x00, ##         0000                           0000           
            0x07, 0xE0, 0x00, 0x00, 0x07, 0xC0, 0x00, ##       000000                          00000           
            0x1F, 0xE0, 0x00, 0x00, 0x07, 0x80, 0x00, ##     00000000                          0000            
            0x7F, 0xE0, 0x00, 0x00, 0x0F, 0x80, 0x00, ##   0000000000                         00000            
            0xF9, 0xE0, 0x00, 0x00, 0x1F, 0x00, 0x00, ##  00000  0000                        00000             
            0xE1, 0xE0, 0x00, 0x00, 0x1E, 0x00, 0x00, ##  000    0000                        0000              
            0x81, 0xE0, 0x00, 0x00, 0x3E, 0x00, 0x00, ##  0      0000                       00000              
            0x01, 0xE0, 0x00, 0x00, 0x3C, 0x00, 0x00, ##         0000                       0000               
            0x01, 0xE0, 0x00, 0x00, 0x7C, 0x00, 0x00, ##         0000                      00000               
            0x01, 0xE0, 0x00, 0x00, 0x78, 0x00, 0x00, ##         0000                      0000                
            0x01, 0xE0, 0x00, 0x00, 0xF8, 0x00, 0x00, ##         0000                     00000                
            0x01, 0xE0, 0x00, 0x01, 0xF0, 0x00, 0x00, ##         0000                    00000                 
            0x01, 0xE0, 0x00, 0x01, 0xE0, 0x00, 0x00, ##         0000                    0000                  
            0x01, 0xE0, 0x00, 0x03, 0xE0, 0x00, 0x00, ##         0000                   00000                  
            0x01, 0xE0, 0x00, 0x03, 0xC0, 0x00, 0x00, ##         0000                   0000                   
            0x01, 0xE0, 0x00, 0x07, 0xC0, 0x00, 0x00, ##         0000                  00000                   
            0x01, 0xE0, 0x00, 0x0F, 0x80, 0x00, 0x00, ##         0000                 00000                    
            0x01, 0xE0, 0x00, 0x0F, 0x00, 0x00, 0x00, ##         0000                 0000                     
            0x01, 0xE0, 0x00, 0x1F, 0x00, 0x00, 0x00, ##         0000                00000                     
            0x01, 0xE0, 0x00, 0x1E, 0x00, 0x00, 0x00, ##         0000                0000                      
            0x01, 0xE0, 0x00, 0x3E, 0x00, 0xFE, 0x00, ##         0000               00000         0000000      
            0x01, 0xE0, 0x00, 0x7C, 0x07, 0xFF, 0x80, ##         0000              00000       000000000000    
            0x01, 0xE0, 0x00, 0x78, 0x1F, 0xFF, 0xE0, ##         0000              0000      0000000000000000  
            0x7F, 0xFF, 0x00, 0xF8, 0x1F, 0x07, 0xF0, ##   000000000000000        00000      00000     0000000 
            0x7F, 0xFF, 0x00, 0xF0, 0x1C, 0x03, 0xF0, ##   000000000000000        0000       000        000000 
            0x7F, 0xFF, 0x01, 0xF0, 0x18, 0x01, 0xF8, ##   000000000000000       00000       00          000000
            0x00, 0x00, 0x03, 0xE0, 0x18, 0x00, 0xF8, ##                        00000        00           00000
            0x00, 0x00, 0x03, 0xC0, 0x00, 0x00, 0xF8, ##                        0000                      00000
            0x00, 0x00, 0x07, 0xC0, 0x00, 0x00, 0xF8, ##                       00000                      00000
            0x00, 0x00, 0x07, 0x80, 0x00, 0x00, 0xF8, ##                       0000                       00000
            0x00, 0x00, 0x0F, 0x80, 0x00, 0x00, 0xF0, ##                      00000                       0000 
            0x00, 0x00, 0x0F, 0x00, 0x00, 0x01, 0xF0, ##                      0000                       00000 
            0x00, 0x00, 0x1E, 0x00, 0x00, 0x01, 0xE0, ##                     0000                        0000  
            0x00, 0x00, 0x3E, 0x00, 0x00, 0x03, 0xC0, ##                    00000                       0000   
            0x00, 0x00, 0x3C, 0x00, 0x00, 0x07, 0x80, ##                    0000                       0000    
            0x00, 0x00, 0x7C, 0x00, 0x00, 0x0F, 0x00, ##                   00000                      0000     
            0x00, 0x00, 0x78, 0x00, 0x00, 0x1E, 0x00, ##                   0000                      0000      
            0x00, 0x00, 0xF0, 0x00, 0x00, 0x3C, 0x00, ##                  0000                      0000       
            0x00, 0x01, 0xF0, 0x00, 0x00, 0x78, 0x00, ##                 00000                     0000        
            0x00, 0x01, 0xE0, 0x00, 0x00, 0xF0, 0x00, ##                 0000                     0000         
            0x00, 0x03, 0xE0, 0x00, 0x01, 0xE0, 0x00, ##                00000                    0000          
            0x00, 0x03, 0xC0, 0x00, 0x03, 0x80, 0x18, ##                0000                    000          00
            0x00, 0x07, 0x80, 0x00, 0x0F, 0x00, 0x18, ##               0000                   0000           00
            0x00, 0x0F, 0x80, 0x00, 0x1E, 0x00, 0x18, ##              00000                  0000            00
            0x00, 0x0F, 0x00, 0x00, 0x3F, 0xFF, 0xF8, ##              0000                  0000000000000000000
            0x00, 0x1F, 0x00, 0x00, 0x3F, 0xFF, 0xF8, ##             00000                  0000000000000000000
            0x00, 0x1E, 0x00, 0x00, 0x3F, 0xFF, 0xF8, ##             0000                   0000000000000000000
            0x00, 0x3C, 0x00, 0x00, 0x00, 0x00, 0x00, ##            0000                                       
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '190' => {    # '¾'
        'width'    => 57, 
        'xoffset'  => 3, 
        'xadvance' => 62, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x07, 0xF8, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x00, ##       00000000                           00000            
            0x3F, 0xFE, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, ##    0000000000000                         0000             
            0x7F, 0xFF, 0x00, 0x00, 0x01, 0xF0, 0x00, 0x00, ##   000000000000000                       00000             
            0x78, 0x1F, 0x80, 0x00, 0x03, 0xE0, 0x00, 0x00, ##   0000      000000                     00000              
            0x70, 0x0F, 0xC0, 0x00, 0x03, 0xE0, 0x00, 0x00, ##   000        000000                    00000              
            0x60, 0x07, 0xC0, 0x00, 0x07, 0xC0, 0x00, 0x00, ##   00          00000                   00000               
            0x60, 0x07, 0xC0, 0x00, 0x0F, 0x80, 0x00, 0x00, ##   00          00000                  00000                
            0x00, 0x07, 0xC0, 0x00, 0x0F, 0x80, 0x00, 0x00, ##               00000                  00000                
            0x00, 0x07, 0xC0, 0x00, 0x1F, 0x00, 0x00, 0x00, ##               00000                 00000                 
            0x00, 0x07, 0x80, 0x00, 0x1F, 0x00, 0x00, 0x00, ##               0000                  00000                 
            0x00, 0x0F, 0x80, 0x00, 0x3E, 0x00, 0x00, 0x00, ##              00000                 00000                  
            0x00, 0x3F, 0x00, 0x00, 0x7C, 0x00, 0x00, 0x00, ##            000000                 00000                   
            0x03, 0xFC, 0x00, 0x00, 0x7C, 0x00, 0x00, 0x00, ##        00000000                   00000                   
            0x03, 0xF0, 0x00, 0x00, 0xF8, 0x00, 0x00, 0x00, ##        000000                    00000                    
            0x03, 0xFE, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, ##        000000000                 0000                     
            0x00, 0x1F, 0x80, 0x01, 0xF0, 0x00, 0x00, 0x00, ##             000000              00000                     
            0x00, 0x07, 0xC0, 0x03, 0xE0, 0x00, 0x00, 0x00, ##               00000            00000                      
            0x00, 0x07, 0xC0, 0x03, 0xE0, 0x00, 0x00, 0x00, ##               00000            00000                      
            0x00, 0x03, 0xE0, 0x07, 0xC0, 0x00, 0x00, 0x00, ##                00000          00000                       
            0x00, 0x03, 0xE0, 0x07, 0x80, 0x00, 0x00, 0x00, ##                00000          0000                        
            0x00, 0x03, 0xE0, 0x0F, 0x80, 0x00, 0x00, 0x00, ##                00000         00000                        
            0xC0, 0x03, 0xE0, 0x1F, 0x00, 0x00, 0x00, 0x00, ##  00            00000        00000                         
            0xC0, 0x07, 0xE0, 0x1F, 0x00, 0x00, 0xF0, 0x00, ##  00           000000        00000                0000     
            0xE0, 0x07, 0xC0, 0x3E, 0x00, 0x01, 0xF0, 0x00, ##  000          00000        00000                00000     
            0xF8, 0x1F, 0xC0, 0x7C, 0x00, 0x03, 0xF0, 0x00, ##  00000      0000000       00000                000000     
            0xFF, 0xFF, 0x80, 0x7C, 0x00, 0x07, 0xF0, 0x00, ##  00000000000000000        00000               0000000     
            0x3F, 0xFF, 0x00, 0xF8, 0x00, 0x0E, 0xF0, 0x00, ##    00000000000000        00000               000 0000     
            0x07, 0xF8, 0x00, 0xF0, 0x00, 0x0E, 0xF0, 0x00, ##       00000000           0000                000 0000     
            0x00, 0x00, 0x01, 0xF0, 0x00, 0x1C, 0xF0, 0x00, ##                         00000               000  0000     
            0x00, 0x00, 0x03, 0xE0, 0x00, 0x38, 0xF0, 0x00, ##                        00000               000   0000     
            0x00, 0x00, 0x03, 0xE0, 0x00, 0x70, 0xF0, 0x00, ##                        00000              000    0000     
            0x00, 0x00, 0x07, 0xC0, 0x00, 0xE0, 0xF0, 0x00, ##                       00000              000     0000     
            0x00, 0x00, 0x07, 0x80, 0x01, 0xC0, 0xF0, 0x00, ##                       0000              000      0000     
            0x00, 0x00, 0x0F, 0x80, 0x01, 0xC0, 0xF0, 0x00, ##                      00000              000      0000     
            0x00, 0x00, 0x1F, 0x00, 0x03, 0x80, 0xF0, 0x00, ##                     00000              000       0000     
            0x00, 0x00, 0x1F, 0x00, 0x07, 0x00, 0xF0, 0x00, ##                     00000             000        0000     
            0x00, 0x00, 0x3E, 0x00, 0x0E, 0x00, 0xF0, 0x00, ##                    00000             000         0000     
            0x00, 0x00, 0x7C, 0x00, 0x1C, 0x00, 0xF0, 0x00, ##                   00000             000          0000     
            0x00, 0x00, 0x7C, 0x00, 0x1F, 0xFF, 0xFF, 0x80, ##                   00000             0000000000000000000000
            0x00, 0x00, 0xF8, 0x00, 0x1F, 0xFF, 0xFF, 0x80, ##                  00000              0000000000000000000000
            0x00, 0x00, 0xF0, 0x00, 0x1F, 0xFF, 0xFF, 0x80, ##                  0000               0000000000000000000000
            0x00, 0x01, 0xF0, 0x00, 0x00, 0x00, 0xF0, 0x00, ##                 00000                            0000     
            0x00, 0x03, 0xE0, 0x00, 0x00, 0x00, 0xF0, 0x00, ##                00000                             0000     
            0x00, 0x03, 0xE0, 0x00, 0x00, 0x00, 0xF0, 0x00, ##                00000                             0000     
            0x00, 0x07, 0xC0, 0x00, 0x00, 0x00, 0xF0, 0x00, ##               00000                              0000     
            0x00, 0x07, 0x80, 0x00, 0x00, 0x1F, 0xFF, 0x80, ##               0000                          00000000000000
            0x00, 0x0F, 0x80, 0x00, 0x00, 0x1F, 0xFF, 0x80, ##              00000                          00000000000000
            0x00, 0x1F, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0x80, ##             00000                           00000000000000
            0x00, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##             00000                                         
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '191' => {    # '¿'
        'width'    => 27, 
        'xoffset'  => 4, 
        'xadvance' => 34, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x03, 0xC0, 0x00, ##                0000         
            0x00, 0x07, 0xE0, 0x00, ##               000000        
            0x00, 0x0F, 0xF0, 0x00, ##              00000000       
            0x00, 0x0F, 0xF0, 0x00, ##              00000000       
            0x00, 0x0F, 0xF0, 0x00, ##              00000000       
            0x00, 0x0F, 0xF0, 0x00, ##              00000000       
            0x00, 0x07, 0xE0, 0x00, ##               000000        
            0x00, 0x03, 0xC0, 0x00, ##                0000         
            0x00, 0x00, 0x00, 0x00, ##                             
            0x00, 0x00, 0x00, 0x00, ##                             
            0x00, 0x00, 0x00, 0x00, ##                             
            0x00, 0x00, 0x00, 0x00, ##                             
            0x00, 0x00, 0x00, 0x00, ##                             
            0x00, 0x03, 0xC0, 0x00, ##                0000         
            0x00, 0x03, 0xC0, 0x00, ##                0000         
            0x00, 0x03, 0xC0, 0x00, ##                0000         
            0x00, 0x03, 0xC0, 0x00, ##                0000         
            0x00, 0x03, 0xC0, 0x00, ##                0000         
            0x00, 0x03, 0xC0, 0x00, ##                0000         
            0x00, 0x03, 0xC0, 0x00, ##                0000         
            0x00, 0x03, 0xC0, 0x00, ##                0000         
            0x00, 0x0F, 0xC0, 0x00, ##              000000         
            0x00, 0x7F, 0xC0, 0x00, ##           000000000         
            0x01, 0xFF, 0x80, 0x00, ##         0000000000          
            0x07, 0xFC, 0x00, 0x00, ##       000000000             
            0x0F, 0xF0, 0x00, 0x00, ##      00000000               
            0x1F, 0xE0, 0x00, 0x00, ##     00000000                
            0x3F, 0xC0, 0x00, 0x00, ##    00000000                 
            0x3F, 0x80, 0x00, 0x00, ##    0000000                  
            0x7F, 0x80, 0x00, 0x00, ##   00000000                  
            0x7F, 0x00, 0x00, 0x00, ##   0000000                   
            0x7F, 0x00, 0x00, 0x00, ##   0000000                   
            0xFE, 0x00, 0x00, 0x00, ##  0000000                    
            0xFE, 0x00, 0x00, 0x00, ##  0000000                    
            0xFE, 0x00, 0x00, 0x00, ##  0000000                    
            0xFE, 0x00, 0x00, 0x00, ##  0000000                    
            0xFE, 0x00, 0x00, 0x00, ##  0000000                    
            0xFE, 0x00, 0x00, 0xE0, ##  0000000                 000
            0xFE, 0x00, 0x00, 0xE0, ##  0000000                 000
            0x7F, 0x00, 0x01, 0xE0, ##   0000000               0000
            0x7F, 0x00, 0x01, 0xE0, ##   0000000               0000
            0x7F, 0x00, 0x03, 0xE0, ##   0000000              00000
            0x3F, 0x80, 0x03, 0xE0, ##    0000000             00000
            0x1F, 0xC0, 0x0F, 0xE0, ##     0000000          0000000
            0x0F, 0xF0, 0x1F, 0xE0, ##      00000000       00000000
            0x07, 0xFF, 0xFF, 0xC0, ##       000000000000000000000 
            0x01, 0xFF, 0xFF, 0x00, ##         00000000000000000   
            0x00, 0x3F, 0xF0, 0x00, ##            0000000000       
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '192' => {    # 'À'
        'width'    => 47, 
        'xoffset'  => 0, 
        'xadvance' => 47, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0xF8, 0x00, 0x00, 0x00, ##                  00000                          
            0x00, 0x00, 0x7C, 0x00, 0x00, 0x00, ##                   00000                         
            0x00, 0x00, 0x3E, 0x00, 0x00, 0x00, ##                    00000                        
            0x00, 0x00, 0x1F, 0x00, 0x00, 0x00, ##                     00000                       
            0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, ##                      0000                       
            0x00, 0x00, 0x07, 0x80, 0x00, 0x00, ##                       0000                      
            0x00, 0x00, 0x03, 0xC0, 0x00, 0x00, ##                        0000                     
            0x00, 0x00, 0x01, 0xC0, 0x00, 0x00, ##                         000                     
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                 
            0x00, 0x00, 0x07, 0xC0, 0x00, 0x00, ##                       00000                     
            0x00, 0x00, 0x0F, 0xC0, 0x00, 0x00, ##                      000000                     
            0x00, 0x00, 0x0F, 0xE0, 0x00, 0x00, ##                      0000000                    
            0x00, 0x00, 0x1F, 0xE0, 0x00, 0x00, ##                     00000000                    
            0x00, 0x00, 0x1F, 0xE0, 0x00, 0x00, ##                     00000000                    
            0x00, 0x00, 0x1F, 0xF0, 0x00, 0x00, ##                     000000000                   
            0x00, 0x00, 0x3F, 0xF0, 0x00, 0x00, ##                    0000000000                   
            0x00, 0x00, 0x3F, 0xF0, 0x00, 0x00, ##                    0000000000                   
            0x00, 0x00, 0x7B, 0xF8, 0x00, 0x00, ##                   0000 0000000                  
            0x00, 0x00, 0x7B, 0xF8, 0x00, 0x00, ##                   0000 0000000                  
            0x00, 0x00, 0x79, 0xFC, 0x00, 0x00, ##                   0000  0000000                 
            0x00, 0x00, 0xF1, 0xFC, 0x00, 0x00, ##                  0000   0000000                 
            0x00, 0x00, 0xF1, 0xFC, 0x00, 0x00, ##                  0000   0000000                 
            0x00, 0x00, 0xE0, 0xFE, 0x00, 0x00, ##                  000     0000000                
            0x00, 0x01, 0xE0, 0xFE, 0x00, 0x00, ##                 0000     0000000                
            0x00, 0x01, 0xE0, 0xFE, 0x00, 0x00, ##                 0000     0000000                
            0x00, 0x03, 0xC0, 0x7F, 0x00, 0x00, ##                0000       0000000               
            0x00, 0x03, 0xC0, 0x7F, 0x00, 0x00, ##                0000       0000000               
            0x00, 0x03, 0xC0, 0x3F, 0x80, 0x00, ##                0000        0000000              
            0x00, 0x07, 0x80, 0x3F, 0x80, 0x00, ##               0000         0000000              
            0x00, 0x07, 0x80, 0x3F, 0x80, 0x00, ##               0000         0000000              
            0x00, 0x07, 0x00, 0x1F, 0xC0, 0x00, ##               000           0000000             
            0x00, 0x0F, 0x00, 0x1F, 0xC0, 0x00, ##              0000           0000000             
            0x00, 0x0F, 0x00, 0x0F, 0xE0, 0x00, ##              0000            0000000            
            0x00, 0x1E, 0x00, 0x0F, 0xE0, 0x00, ##             0000             0000000            
            0x00, 0x1E, 0x00, 0x0F, 0xE0, 0x00, ##             0000             0000000            
            0x00, 0x1C, 0x00, 0x07, 0xF0, 0x00, ##             000               0000000           
            0x00, 0x3C, 0x00, 0x07, 0xF0, 0x00, ##            0000               0000000           
            0x00, 0x3C, 0x00, 0x07, 0xF0, 0x00, ##            0000               0000000           
            0x00, 0x38, 0x00, 0x03, 0xF8, 0x00, ##            000                 0000000          
            0x00, 0x7F, 0xFF, 0xFF, 0xF8, 0x00, ##           0000000000000000000000000000          
            0x00, 0x7F, 0xFF, 0xFF, 0xFC, 0x00, ##           00000000000000000000000000000         
            0x00, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, ##          000000000000000000000000000000         
            0x00, 0xF0, 0x00, 0x01, 0xFC, 0x00, ##          0000                   0000000         
            0x00, 0xE0, 0x00, 0x00, 0xFE, 0x00, ##          000                     0000000        
            0x01, 0xE0, 0x00, 0x00, 0xFE, 0x00, ##         0000                     0000000        
            0x01, 0xE0, 0x00, 0x00, 0x7F, 0x00, ##         0000                      0000000       
            0x01, 0xC0, 0x00, 0x00, 0x7F, 0x00, ##         000                       0000000       
            0x03, 0xC0, 0x00, 0x00, 0x7F, 0x00, ##        0000                       0000000       
            0x03, 0xC0, 0x00, 0x00, 0x3F, 0x80, ##        0000                        0000000      
            0x07, 0x80, 0x00, 0x00, 0x3F, 0x80, ##       0000                         0000000      
            0x07, 0x80, 0x00, 0x00, 0x3F, 0x80, ##       0000                         0000000      
            0x07, 0x00, 0x00, 0x00, 0x1F, 0xC0, ##       000                           0000000     
            0x0F, 0x00, 0x00, 0x00, 0x1F, 0xC0, ##      0000                           0000000     
            0xFF, 0xF8, 0x00, 0x03, 0xFF, 0xFE, ##  0000000000000                 00000000000000000
            0xFF, 0xF8, 0x00, 0x03, 0xFF, 0xFE, ##  0000000000000                 00000000000000000
            0xFF, 0xF8, 0x00, 0x03, 0xFF, 0xFE, ##  0000000000000                 00000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '193' => {    # 'Á'
        'width'    => 47, 
        'xoffset'  => 0, 
        'xadvance' => 47, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, ##                           000000                
            0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, ##                          000000                 
            0x00, 0x00, 0x01, 0xF8, 0x00, 0x00, ##                         000000                  
            0x00, 0x00, 0x01, 0xF0, 0x00, 0x00, ##                         00000                   
            0x00, 0x00, 0x03, 0xE0, 0x00, 0x00, ##                        00000                    
            0x00, 0x00, 0x07, 0xC0, 0x00, 0x00, ##                       00000                     
            0x00, 0x00, 0x07, 0x80, 0x00, 0x00, ##                       0000                      
            0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, ##                      0000                       
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                 
            0x00, 0x00, 0x07, 0xC0, 0x00, 0x00, ##                       00000                     
            0x00, 0x00, 0x0F, 0xC0, 0x00, 0x00, ##                      000000                     
            0x00, 0x00, 0x0F, 0xE0, 0x00, 0x00, ##                      0000000                    
            0x00, 0x00, 0x1F, 0xE0, 0x00, 0x00, ##                     00000000                    
            0x00, 0x00, 0x1F, 0xE0, 0x00, 0x00, ##                     00000000                    
            0x00, 0x00, 0x1F, 0xF0, 0x00, 0x00, ##                     000000000                   
            0x00, 0x00, 0x3F, 0xF0, 0x00, 0x00, ##                    0000000000                   
            0x00, 0x00, 0x3F, 0xF0, 0x00, 0x00, ##                    0000000000                   
            0x00, 0x00, 0x7B, 0xF8, 0x00, 0x00, ##                   0000 0000000                  
            0x00, 0x00, 0x7B, 0xF8, 0x00, 0x00, ##                   0000 0000000                  
            0x00, 0x00, 0x79, 0xFC, 0x00, 0x00, ##                   0000  0000000                 
            0x00, 0x00, 0xF1, 0xFC, 0x00, 0x00, ##                  0000   0000000                 
            0x00, 0x00, 0xF1, 0xFC, 0x00, 0x00, ##                  0000   0000000                 
            0x00, 0x00, 0xE0, 0xFE, 0x00, 0x00, ##                  000     0000000                
            0x00, 0x01, 0xE0, 0xFE, 0x00, 0x00, ##                 0000     0000000                
            0x00, 0x01, 0xE0, 0xFE, 0x00, 0x00, ##                 0000     0000000                
            0x00, 0x03, 0xC0, 0x7F, 0x00, 0x00, ##                0000       0000000               
            0x00, 0x03, 0xC0, 0x7F, 0x00, 0x00, ##                0000       0000000               
            0x00, 0x03, 0xC0, 0x3F, 0x80, 0x00, ##                0000        0000000              
            0x00, 0x07, 0x80, 0x3F, 0x80, 0x00, ##               0000         0000000              
            0x00, 0x07, 0x80, 0x3F, 0x80, 0x00, ##               0000         0000000              
            0x00, 0x07, 0x00, 0x1F, 0xC0, 0x00, ##               000           0000000             
            0x00, 0x0F, 0x00, 0x1F, 0xC0, 0x00, ##              0000           0000000             
            0x00, 0x0F, 0x00, 0x0F, 0xE0, 0x00, ##              0000            0000000            
            0x00, 0x1E, 0x00, 0x0F, 0xE0, 0x00, ##             0000             0000000            
            0x00, 0x1E, 0x00, 0x0F, 0xE0, 0x00, ##             0000             0000000            
            0x00, 0x1C, 0x00, 0x07, 0xF0, 0x00, ##             000               0000000           
            0x00, 0x3C, 0x00, 0x07, 0xF0, 0x00, ##            0000               0000000           
            0x00, 0x3C, 0x00, 0x07, 0xF0, 0x00, ##            0000               0000000           
            0x00, 0x38, 0x00, 0x03, 0xF8, 0x00, ##            000                 0000000          
            0x00, 0x7F, 0xFF, 0xFF, 0xF8, 0x00, ##           0000000000000000000000000000          
            0x00, 0x7F, 0xFF, 0xFF, 0xFC, 0x00, ##           00000000000000000000000000000         
            0x00, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, ##          000000000000000000000000000000         
            0x00, 0xF0, 0x00, 0x01, 0xFC, 0x00, ##          0000                   0000000         
            0x00, 0xE0, 0x00, 0x00, 0xFE, 0x00, ##          000                     0000000        
            0x01, 0xE0, 0x00, 0x00, 0xFE, 0x00, ##         0000                     0000000        
            0x01, 0xE0, 0x00, 0x00, 0x7F, 0x00, ##         0000                      0000000       
            0x01, 0xC0, 0x00, 0x00, 0x7F, 0x00, ##         000                       0000000       
            0x03, 0xC0, 0x00, 0x00, 0x7F, 0x00, ##        0000                       0000000       
            0x03, 0xC0, 0x00, 0x00, 0x3F, 0x80, ##        0000                        0000000      
            0x07, 0x80, 0x00, 0x00, 0x3F, 0x80, ##       0000                         0000000      
            0x07, 0x80, 0x00, 0x00, 0x3F, 0x80, ##       0000                         0000000      
            0x07, 0x00, 0x00, 0x00, 0x1F, 0xC0, ##       000                           0000000     
            0x0F, 0x00, 0x00, 0x00, 0x1F, 0xC0, ##      0000                           0000000     
            0xFF, 0xF8, 0x00, 0x03, 0xFF, 0xFE, ##  0000000000000                 00000000000000000
            0xFF, 0xF8, 0x00, 0x03, 0xFF, 0xFE, ##  0000000000000                 00000000000000000
            0xFF, 0xF8, 0x00, 0x03, 0xFF, 0xFE, ##  0000000000000                 00000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '194' => {    # 'Â'
        'width'    => 47, 
        'xoffset'  => 0, 
        'xadvance' => 47, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x0F, 0xC0, 0x00, 0x00, ##                      000000                     
            0x00, 0x00, 0x1F, 0xE0, 0x00, 0x00, ##                     00000000                    
            0x00, 0x00, 0x3F, 0xF0, 0x00, 0x00, ##                    0000000000                   
            0x00, 0x00, 0x7E, 0xF8, 0x00, 0x00, ##                   000000 00000                  
            0x00, 0x00, 0xFC, 0x7C, 0x00, 0x00, ##                  000000   00000                 
            0x00, 0x00, 0xF0, 0x3E, 0x00, 0x00, ##                  0000      00000                
            0x00, 0x01, 0xE0, 0x0F, 0x00, 0x00, ##                 0000         0000               
            0x00, 0x03, 0xC0, 0x07, 0x80, 0x00, ##                0000           0000              
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                 
            0x00, 0x00, 0x07, 0xC0, 0x00, 0x00, ##                       00000                     
            0x00, 0x00, 0x0F, 0xC0, 0x00, 0x00, ##                      000000                     
            0x00, 0x00, 0x0F, 0xE0, 0x00, 0x00, ##                      0000000                    
            0x00, 0x00, 0x1F, 0xE0, 0x00, 0x00, ##                     00000000                    
            0x00, 0x00, 0x1F, 0xE0, 0x00, 0x00, ##                     00000000                    
            0x00, 0x00, 0x1F, 0xF0, 0x00, 0x00, ##                     000000000                   
            0x00, 0x00, 0x3F, 0xF0, 0x00, 0x00, ##                    0000000000                   
            0x00, 0x00, 0x3F, 0xF0, 0x00, 0x00, ##                    0000000000                   
            0x00, 0x00, 0x7B, 0xF8, 0x00, 0x00, ##                   0000 0000000                  
            0x00, 0x00, 0x7B, 0xF8, 0x00, 0x00, ##                   0000 0000000                  
            0x00, 0x00, 0x79, 0xFC, 0x00, 0x00, ##                   0000  0000000                 
            0x00, 0x00, 0xF1, 0xFC, 0x00, 0x00, ##                  0000   0000000                 
            0x00, 0x00, 0xF1, 0xFC, 0x00, 0x00, ##                  0000   0000000                 
            0x00, 0x00, 0xE0, 0xFE, 0x00, 0x00, ##                  000     0000000                
            0x00, 0x01, 0xE0, 0xFE, 0x00, 0x00, ##                 0000     0000000                
            0x00, 0x01, 0xE0, 0xFE, 0x00, 0x00, ##                 0000     0000000                
            0x00, 0x03, 0xC0, 0x7F, 0x00, 0x00, ##                0000       0000000               
            0x00, 0x03, 0xC0, 0x7F, 0x00, 0x00, ##                0000       0000000               
            0x00, 0x03, 0xC0, 0x3F, 0x80, 0x00, ##                0000        0000000              
            0x00, 0x07, 0x80, 0x3F, 0x80, 0x00, ##               0000         0000000              
            0x00, 0x07, 0x80, 0x3F, 0x80, 0x00, ##               0000         0000000              
            0x00, 0x07, 0x00, 0x1F, 0xC0, 0x00, ##               000           0000000             
            0x00, 0x0F, 0x00, 0x1F, 0xC0, 0x00, ##              0000           0000000             
            0x00, 0x0F, 0x00, 0x0F, 0xE0, 0x00, ##              0000            0000000            
            0x00, 0x1E, 0x00, 0x0F, 0xE0, 0x00, ##             0000             0000000            
            0x00, 0x1E, 0x00, 0x0F, 0xE0, 0x00, ##             0000             0000000            
            0x00, 0x1C, 0x00, 0x07, 0xF0, 0x00, ##             000               0000000           
            0x00, 0x3C, 0x00, 0x07, 0xF0, 0x00, ##            0000               0000000           
            0x00, 0x3C, 0x00, 0x07, 0xF0, 0x00, ##            0000               0000000           
            0x00, 0x38, 0x00, 0x03, 0xF8, 0x00, ##            000                 0000000          
            0x00, 0x7F, 0xFF, 0xFF, 0xF8, 0x00, ##           0000000000000000000000000000          
            0x00, 0x7F, 0xFF, 0xFF, 0xFC, 0x00, ##           00000000000000000000000000000         
            0x00, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, ##          000000000000000000000000000000         
            0x00, 0xF0, 0x00, 0x01, 0xFC, 0x00, ##          0000                   0000000         
            0x00, 0xE0, 0x00, 0x00, 0xFE, 0x00, ##          000                     0000000        
            0x01, 0xE0, 0x00, 0x00, 0xFE, 0x00, ##         0000                     0000000        
            0x01, 0xE0, 0x00, 0x00, 0x7F, 0x00, ##         0000                      0000000       
            0x01, 0xC0, 0x00, 0x00, 0x7F, 0x00, ##         000                       0000000       
            0x03, 0xC0, 0x00, 0x00, 0x7F, 0x00, ##        0000                       0000000       
            0x03, 0xC0, 0x00, 0x00, 0x3F, 0x80, ##        0000                        0000000      
            0x07, 0x80, 0x00, 0x00, 0x3F, 0x80, ##       0000                         0000000      
            0x07, 0x80, 0x00, 0x00, 0x3F, 0x80, ##       0000                         0000000      
            0x07, 0x00, 0x00, 0x00, 0x1F, 0xC0, ##       000                           0000000     
            0x0F, 0x00, 0x00, 0x00, 0x1F, 0xC0, ##      0000                           0000000     
            0xFF, 0xF8, 0x00, 0x03, 0xFF, 0xFE, ##  0000000000000                 00000000000000000
            0xFF, 0xF8, 0x00, 0x03, 0xFF, 0xFE, ##  0000000000000                 00000000000000000
            0xFF, 0xF8, 0x00, 0x03, 0xFF, 0xFE, ##  0000000000000                 00000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '195' => {    # 'Ã'
        'width'    => 47, 
        'xoffset'  => 0, 
        'xadvance' => 47, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0xFC, 0x01, 0xC0, 0x00, ##                  000000         000             
            0x00, 0x01, 0xFF, 0x01, 0xC0, 0x00, ##                 000000000       000             
            0x00, 0x03, 0xFF, 0xC3, 0xC0, 0x00, ##                000000000000    0000             
            0x00, 0x07, 0x87, 0xFF, 0x80, 0x00, ##               0000    000000000000              
            0x00, 0x07, 0x01, 0xFF, 0x00, 0x00, ##               000       000000000               
            0x00, 0x07, 0x00, 0x7E, 0x00, 0x00, ##               000         000000                
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                 
            0x00, 0x00, 0x0F, 0xC0, 0x00, 0x00, ##                      000000                     
            0x00, 0x00, 0x0F, 0xC0, 0x00, 0x00, ##                      000000                     
            0x00, 0x00, 0x0F, 0xE0, 0x00, 0x00, ##                      0000000                    
            0x00, 0x00, 0x1F, 0xE0, 0x00, 0x00, ##                     00000000                    
            0x00, 0x00, 0x1F, 0xE0, 0x00, 0x00, ##                     00000000                    
            0x00, 0x00, 0x1F, 0xF0, 0x00, 0x00, ##                     000000000                   
            0x00, 0x00, 0x3F, 0xF0, 0x00, 0x00, ##                    0000000000                   
            0x00, 0x00, 0x3F, 0xF0, 0x00, 0x00, ##                    0000000000                   
            0x00, 0x00, 0x7B, 0xF8, 0x00, 0x00, ##                   0000 0000000                  
            0x00, 0x00, 0x7B, 0xF8, 0x00, 0x00, ##                   0000 0000000                  
            0x00, 0x00, 0x79, 0xFC, 0x00, 0x00, ##                   0000  0000000                 
            0x00, 0x00, 0xF1, 0xFC, 0x00, 0x00, ##                  0000   0000000                 
            0x00, 0x00, 0xF1, 0xFC, 0x00, 0x00, ##                  0000   0000000                 
            0x00, 0x00, 0xE0, 0xFE, 0x00, 0x00, ##                  000     0000000                
            0x00, 0x01, 0xE0, 0xFE, 0x00, 0x00, ##                 0000     0000000                
            0x00, 0x01, 0xE0, 0x7F, 0x00, 0x00, ##                 0000      0000000               
            0x00, 0x03, 0xC0, 0x7F, 0x00, 0x00, ##                0000       0000000               
            0x00, 0x03, 0xC0, 0x7F, 0x00, 0x00, ##                0000       0000000               
            0x00, 0x03, 0xC0, 0x3F, 0x80, 0x00, ##                0000        0000000              
            0x00, 0x07, 0x80, 0x3F, 0x80, 0x00, ##               0000         0000000              
            0x00, 0x07, 0x80, 0x3F, 0x80, 0x00, ##               0000         0000000              
            0x00, 0x07, 0x00, 0x1F, 0xC0, 0x00, ##               000           0000000             
            0x00, 0x0F, 0x00, 0x1F, 0xC0, 0x00, ##              0000           0000000             
            0x00, 0x0F, 0x00, 0x0F, 0xE0, 0x00, ##              0000            0000000            
            0x00, 0x1E, 0x00, 0x0F, 0xE0, 0x00, ##             0000             0000000            
            0x00, 0x1E, 0x00, 0x0F, 0xE0, 0x00, ##             0000             0000000            
            0x00, 0x1C, 0x00, 0x07, 0xF0, 0x00, ##             000               0000000           
            0x00, 0x3C, 0x00, 0x07, 0xF0, 0x00, ##            0000               0000000           
            0x00, 0x3C, 0x00, 0x03, 0xF8, 0x00, ##            0000                0000000          
            0x00, 0x38, 0x00, 0x03, 0xF8, 0x00, ##            000                 0000000          
            0x00, 0x7F, 0xFF, 0xFF, 0xF8, 0x00, ##           0000000000000000000000000000          
            0x00, 0x7F, 0xFF, 0xFF, 0xFC, 0x00, ##           00000000000000000000000000000         
            0x00, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, ##          000000000000000000000000000000         
            0x00, 0xF0, 0x00, 0x00, 0xFE, 0x00, ##          0000                    0000000        
            0x00, 0xE0, 0x00, 0x00, 0xFE, 0x00, ##          000                     0000000        
            0x01, 0xE0, 0x00, 0x00, 0x7E, 0x00, ##         0000                      000000        
            0x01, 0xE0, 0x00, 0x00, 0x7F, 0x00, ##         0000                      0000000       
            0x01, 0xC0, 0x00, 0x00, 0x7F, 0x00, ##         000                       0000000       
            0x03, 0xC0, 0x00, 0x00, 0x3F, 0x00, ##        0000                        000000       
            0x03, 0xC0, 0x00, 0x00, 0x3F, 0x80, ##        0000                        0000000      
            0x07, 0x80, 0x00, 0x00, 0x3F, 0x80, ##       0000                         0000000      
            0x07, 0x80, 0x00, 0x00, 0x1F, 0xC0, ##       0000                          0000000     
            0x07, 0x00, 0x00, 0x00, 0x1F, 0xC0, ##       000                           0000000     
            0x0F, 0x00, 0x00, 0x00, 0x1F, 0xC0, ##      0000                           0000000     
            0xFF, 0xF8, 0x00, 0x03, 0xFF, 0xFE, ##  0000000000000                 00000000000000000
            0xFF, 0xF8, 0x00, 0x03, 0xFF, 0xFE, ##  0000000000000                 00000000000000000
            0xFF, 0xF8, 0x00, 0x03, 0xFF, 0xFE, ##  0000000000000                 00000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '196' => {    # 'Ä'
        'width'    => 47, 
        'xoffset'  => 0, 
        'xadvance' => 47, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0xE0, 0x0E, 0x00, 0x00, ##                  000         000                
            0x00, 0x01, 0xF0, 0x1F, 0x00, 0x00, ##                 00000       00000               
            0x00, 0x03, 0xF8, 0x3F, 0x80, 0x00, ##                0000000     0000000              
            0x00, 0x03, 0xF8, 0x3F, 0x80, 0x00, ##                0000000     0000000              
            0x00, 0x03, 0xF8, 0x3F, 0x80, 0x00, ##                0000000     0000000              
            0x00, 0x01, 0xF0, 0x1F, 0x00, 0x00, ##                 00000       00000               
            0x00, 0x00, 0xE0, 0x0E, 0x00, 0x00, ##                  000         000                
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                 
            0x00, 0x00, 0x0F, 0xC0, 0x00, 0x00, ##                      000000                     
            0x00, 0x00, 0x0F, 0xE0, 0x00, 0x00, ##                      0000000                    
            0x00, 0x00, 0x0F, 0xE0, 0x00, 0x00, ##                      0000000                    
            0x00, 0x00, 0x1F, 0xE0, 0x00, 0x00, ##                     00000000                    
            0x00, 0x00, 0x1F, 0xF0, 0x00, 0x00, ##                     000000000                   
            0x00, 0x00, 0x1F, 0xF0, 0x00, 0x00, ##                     000000000                   
            0x00, 0x00, 0x3F, 0xF0, 0x00, 0x00, ##                    0000000000                   
            0x00, 0x00, 0x3F, 0xF8, 0x00, 0x00, ##                    00000000000                  
            0x00, 0x00, 0x7B, 0xF8, 0x00, 0x00, ##                   0000 0000000                  
            0x00, 0x00, 0x7B, 0xFC, 0x00, 0x00, ##                   0000 00000000                 
            0x00, 0x00, 0x79, 0xFC, 0x00, 0x00, ##                   0000  0000000                 
            0x00, 0x00, 0xF1, 0xFC, 0x00, 0x00, ##                  0000   0000000                 
            0x00, 0x00, 0xF0, 0xFE, 0x00, 0x00, ##                  0000    0000000                
            0x00, 0x00, 0xE0, 0xFE, 0x00, 0x00, ##                  000     0000000                
            0x00, 0x01, 0xE0, 0xFE, 0x00, 0x00, ##                 0000     0000000                
            0x00, 0x01, 0xE0, 0x7F, 0x00, 0x00, ##                 0000      0000000               
            0x00, 0x03, 0xC0, 0x7F, 0x00, 0x00, ##                0000       0000000               
            0x00, 0x03, 0xC0, 0x7F, 0x80, 0x00, ##                0000       00000000              
            0x00, 0x03, 0xC0, 0x3F, 0x80, 0x00, ##                0000        0000000              
            0x00, 0x07, 0x80, 0x3F, 0x80, 0x00, ##               0000         0000000              
            0x00, 0x07, 0x80, 0x1F, 0xC0, 0x00, ##               0000          0000000             
            0x00, 0x07, 0x00, 0x1F, 0xC0, 0x00, ##               000           0000000             
            0x00, 0x0F, 0x00, 0x1F, 0xC0, 0x00, ##              0000           0000000             
            0x00, 0x0F, 0x00, 0x0F, 0xE0, 0x00, ##              0000            0000000            
            0x00, 0x1E, 0x00, 0x0F, 0xE0, 0x00, ##             0000             0000000            
            0x00, 0x1E, 0x00, 0x0F, 0xF0, 0x00, ##             0000             00000000           
            0x00, 0x1C, 0x00, 0x07, 0xF0, 0x00, ##             000               0000000           
            0x00, 0x3C, 0x00, 0x07, 0xF0, 0x00, ##            0000               0000000           
            0x00, 0x3C, 0x00, 0x03, 0xF8, 0x00, ##            0000                0000000          
            0x00, 0x38, 0x00, 0x03, 0xF8, 0x00, ##            000                 0000000          
            0x00, 0x7F, 0xFF, 0xFF, 0xF8, 0x00, ##           0000000000000000000000000000          
            0x00, 0x7F, 0xFF, 0xFF, 0xFC, 0x00, ##           00000000000000000000000000000         
            0x00, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, ##          000000000000000000000000000000         
            0x00, 0xF0, 0x00, 0x01, 0xFE, 0x00, ##          0000                   00000000        
            0x00, 0xE0, 0x00, 0x00, 0xFE, 0x00, ##          000                     0000000        
            0x01, 0xE0, 0x00, 0x00, 0xFE, 0x00, ##         0000                     0000000        
            0x01, 0xE0, 0x00, 0x00, 0x7F, 0x00, ##         0000                      0000000       
            0x01, 0xC0, 0x00, 0x00, 0x7F, 0x00, ##         000                       0000000       
            0x03, 0xC0, 0x00, 0x00, 0x7F, 0x00, ##        0000                       0000000       
            0x03, 0xC0, 0x00, 0x00, 0x3F, 0x80, ##        0000                        0000000      
            0x07, 0x80, 0x00, 0x00, 0x3F, 0x80, ##       0000                         0000000      
            0x07, 0x80, 0x00, 0x00, 0x3F, 0x80, ##       0000                         0000000      
            0x07, 0x00, 0x00, 0x00, 0x1F, 0xC0, ##       000                           0000000     
            0x0F, 0x00, 0x00, 0x00, 0x1F, 0xC0, ##      0000                           0000000     
            0xFF, 0xF8, 0x00, 0x03, 0xFF, 0xFE, ##  0000000000000                 00000000000000000
            0xFF, 0xF8, 0x00, 0x03, 0xFF, 0xFE, ##  0000000000000                 00000000000000000
            0xFF, 0xF8, 0x00, 0x03, 0xFF, 0xFE, ##  0000000000000                 00000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '197' => {    # 'Å'
        'width'    => 47, 
        'xoffset'  => 0, 
        'xadvance' => 47, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x07, 0xC0, 0x00, 0x00, ##                       00000                     
            0x00, 0x00, 0x1F, 0xF0, 0x00, 0x00, ##                     000000000                   
            0x00, 0x00, 0x7F, 0xF8, 0x00, 0x00, ##                   000000000000                  
            0x00, 0x00, 0x7F, 0xFC, 0x00, 0x00, ##                   0000000000000                 
            0x00, 0x00, 0xF8, 0x7E, 0x00, 0x00, ##                  00000    000000                
            0x00, 0x00, 0xF0, 0x1E, 0x00, 0x00, ##                  0000       0000                
            0x00, 0x01, 0xE0, 0x1F, 0x00, 0x00, ##                 0000        00000               
            0x00, 0x01, 0xE0, 0x0F, 0x00, 0x00, ##                 0000         0000               
            0x00, 0x01, 0xE0, 0x0F, 0x00, 0x00, ##                 0000         0000               
            0x00, 0x01, 0xE0, 0x0F, 0x00, 0x00, ##                 0000         0000               
            0x00, 0x01, 0xE0, 0x0F, 0x00, 0x00, ##                 0000         0000               
            0x00, 0x01, 0xF0, 0x1F, 0x00, 0x00, ##                 00000       00000               
            0x00, 0x00, 0xF8, 0x3E, 0x00, 0x00, ##                  00000     00000                
            0x00, 0x00, 0xFF, 0xFC, 0x00, 0x00, ##                  00000000000000                 
            0x00, 0x00, 0x7F, 0xFC, 0x00, 0x00, ##                   0000000000000                 
            0x00, 0x00, 0x1F, 0xF0, 0x00, 0x00, ##                     000000000                   
            0x00, 0x00, 0x0F, 0xE0, 0x00, 0x00, ##                      0000000                    
            0x00, 0x00, 0x1F, 0xF0, 0x00, 0x00, ##                     000000000                   
            0x00, 0x00, 0x1F, 0xF0, 0x00, 0x00, ##                     000000000                   
            0x00, 0x00, 0x3F, 0xF8, 0x00, 0x00, ##                    00000000000                  
            0x00, 0x00, 0x3F, 0xF8, 0x00, 0x00, ##                    00000000000                  
            0x00, 0x00, 0x3B, 0xF8, 0x00, 0x00, ##                    000 0000000                  
            0x00, 0x00, 0x79, 0xFC, 0x00, 0x00, ##                   0000  0000000                 
            0x00, 0x00, 0x79, 0xFC, 0x00, 0x00, ##                   0000  0000000                 
            0x00, 0x00, 0xF0, 0xFC, 0x00, 0x00, ##                  0000    000000                 
            0x00, 0x00, 0xF0, 0xFE, 0x00, 0x00, ##                  0000    0000000                
            0x00, 0x00, 0xE0, 0xFE, 0x00, 0x00, ##                  000     0000000                
            0x00, 0x01, 0xE0, 0x7F, 0x00, 0x00, ##                 0000      0000000               
            0x00, 0x01, 0xE0, 0x7F, 0x00, 0x00, ##                 0000      0000000               
            0x00, 0x03, 0xC0, 0x7F, 0x00, 0x00, ##                0000       0000000               
            0x00, 0x03, 0xC0, 0x3F, 0x80, 0x00, ##                0000        0000000              
            0x00, 0x03, 0x80, 0x3F, 0x80, 0x00, ##                000         0000000              
            0x00, 0x07, 0x80, 0x3F, 0x80, 0x00, ##               0000         0000000              
            0x00, 0x07, 0x80, 0x1F, 0xC0, 0x00, ##               0000          0000000             
            0x00, 0x0F, 0x00, 0x1F, 0xC0, 0x00, ##              0000           0000000             
            0x00, 0x0F, 0x00, 0x0F, 0xE0, 0x00, ##              0000            0000000            
            0x00, 0x0E, 0x00, 0x0F, 0xE0, 0x00, ##              000             0000000            
            0x00, 0x1E, 0x00, 0x0F, 0xE0, 0x00, ##             0000             0000000            
            0x00, 0x1E, 0x00, 0x07, 0xF0, 0x00, ##             0000              0000000           
            0x00, 0x1C, 0x00, 0x07, 0xF0, 0x00, ##             000               0000000           
            0x00, 0x3C, 0x00, 0x07, 0xF8, 0x00, ##            0000               00000000          
            0x00, 0x38, 0x00, 0x03, 0xF8, 0x00, ##            000                 0000000          
            0x00, 0x7F, 0xFF, 0xFF, 0xF8, 0x00, ##           0000000000000000000000000000          
            0x00, 0x7F, 0xFF, 0xFF, 0xFC, 0x00, ##           00000000000000000000000000000         
            0x00, 0x7F, 0xFF, 0xFF, 0xFC, 0x00, ##           00000000000000000000000000000         
            0x00, 0xF0, 0x00, 0x00, 0xFC, 0x00, ##          0000                    000000         
            0x00, 0xE0, 0x00, 0x00, 0xFE, 0x00, ##          000                     0000000        
            0x01, 0xE0, 0x00, 0x00, 0xFE, 0x00, ##         0000                     0000000        
            0x01, 0xE0, 0x00, 0x00, 0x7F, 0x00, ##         0000                      0000000       
            0x01, 0xC0, 0x00, 0x00, 0x7F, 0x00, ##         000                       0000000       
            0x03, 0xC0, 0x00, 0x00, 0x7F, 0x00, ##        0000                       0000000       
            0x03, 0xC0, 0x00, 0x00, 0x3F, 0x80, ##        0000                        0000000      
            0x07, 0x80, 0x00, 0x00, 0x3F, 0x80, ##       0000                         0000000      
            0x07, 0x80, 0x00, 0x00, 0x1F, 0xC0, ##       0000                          0000000     
            0x07, 0x00, 0x00, 0x00, 0x1F, 0xC0, ##       000                           0000000     
            0x0F, 0x00, 0x00, 0x00, 0x1F, 0xC0, ##      0000                           0000000     
            0xFF, 0xF8, 0x00, 0x03, 0xFF, 0xFE, ##  0000000000000                 00000000000000000
            0xFF, 0xF8, 0x00, 0x03, 0xFF, 0xFE, ##  0000000000000                 00000000000000000
            0xFF, 0xF8, 0x00, 0x03, 0xFF, 0xFE, ##  0000000000000                 00000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '198' => {    # 'Æ'
        'width'    => 62, 
        'xoffset'  => -1, 
        'xadvance' => 64, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##                 0000000000000000000000000000000000000000000000 
            0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##                 0000000000000000000000000000000000000000000000 
            0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##                 0000000000000000000000000000000000000000000000 
            0x00, 0x01, 0xFF, 0xC7, 0xFF, 0xFF, 0xFF, 0xF8, ##                 00000000000   00000000000000000000000000000000 
            0x00, 0x00, 0x03, 0xC7, 0xF0, 0x00, 0x00, 0x78, ##                        0000   0000000                     0000 
            0x00, 0x00, 0x07, 0x87, 0xF0, 0x00, 0x00, 0x78, ##                       0000    0000000                     0000 
            0x00, 0x00, 0x07, 0x87, 0xF0, 0x00, 0x00, 0x78, ##                       0000    0000000                     0000 
            0x00, 0x00, 0x0F, 0x07, 0xF0, 0x00, 0x00, 0x78, ##                      0000     0000000                     0000 
            0x00, 0x00, 0x0F, 0x07, 0xF0, 0x00, 0x00, 0x78, ##                      0000     0000000                     0000 
            0x00, 0x00, 0x1E, 0x07, 0xF0, 0x00, 0x00, 0x78, ##                     0000      0000000                     0000 
            0x00, 0x00, 0x1E, 0x07, 0xF0, 0x00, 0x00, 0x78, ##                     0000      0000000                     0000 
            0x00, 0x00, 0x3C, 0x07, 0xF0, 0x00, 0x00, 0x00, ##                    0000       0000000                          
            0x00, 0x00, 0x3C, 0x07, 0xF0, 0x00, 0x00, 0x00, ##                    0000       0000000                          
            0x00, 0x00, 0x3C, 0x07, 0xF0, 0x00, 0x00, 0x00, ##                    0000       0000000                          
            0x00, 0x00, 0x78, 0x07, 0xF0, 0x00, 0x1E, 0x00, ##                   0000        0000000               0000       
            0x00, 0x00, 0x78, 0x07, 0xF0, 0x00, 0x1E, 0x00, ##                   0000        0000000               0000       
            0x00, 0x00, 0xF0, 0x07, 0xF0, 0x00, 0x1E, 0x00, ##                  0000         0000000               0000       
            0x00, 0x00, 0xF0, 0x07, 0xF0, 0x00, 0x1E, 0x00, ##                  0000         0000000               0000       
            0x00, 0x01, 0xE0, 0x07, 0xF0, 0x00, 0x1E, 0x00, ##                 0000          0000000               0000       
            0x00, 0x01, 0xE0, 0x07, 0xF0, 0x00, 0x1E, 0x00, ##                 0000          0000000               0000       
            0x00, 0x03, 0xC0, 0x07, 0xFF, 0xFF, 0xFE, 0x00, ##                0000           00000000000000000000000000       
            0x00, 0x03, 0xC0, 0x07, 0xFF, 0xFF, 0xFE, 0x00, ##                0000           00000000000000000000000000       
            0x00, 0x03, 0x80, 0x07, 0xFF, 0xFF, 0xFE, 0x00, ##                000            00000000000000000000000000       
            0x00, 0x07, 0x80, 0x07, 0xFF, 0xFF, 0xFE, 0x00, ##               0000            00000000000000000000000000       
            0x00, 0x07, 0x80, 0x07, 0xF0, 0x00, 0x1E, 0x00, ##               0000            0000000               0000       
            0x00, 0x0F, 0x00, 0x07, 0xF0, 0x00, 0x1E, 0x00, ##              0000             0000000               0000       
            0x00, 0x0F, 0x00, 0x07, 0xF0, 0x00, 0x1E, 0x00, ##              0000             0000000               0000       
            0x00, 0x1E, 0x00, 0x07, 0xF0, 0x00, 0x1E, 0x00, ##             0000              0000000               0000       
            0x00, 0x1E, 0x00, 0x07, 0xF0, 0x00, 0x1E, 0x00, ##             0000              0000000               0000       
            0x00, 0x3C, 0x00, 0x07, 0xF0, 0x00, 0x00, 0x00, ##            0000               0000000                          
            0x00, 0x3F, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00, ##            00000000000000000000000000                          
            0x00, 0x3F, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00, ##            00000000000000000000000000                          
            0x00, 0x7F, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00, ##           000000000000000000000000000                          
            0x00, 0x70, 0x00, 0x07, 0xF0, 0x00, 0x00, 0x00, ##           000                 0000000                          
            0x00, 0xF0, 0x00, 0x07, 0xF0, 0x00, 0x00, 0x00, ##          0000                 0000000                          
            0x00, 0xF0, 0x00, 0x07, 0xF0, 0x00, 0x00, 0x00, ##          0000                 0000000                          
            0x01, 0xE0, 0x00, 0x07, 0xF0, 0x00, 0x00, 0x3C, ##         0000                  0000000                      0000
            0x01, 0xE0, 0x00, 0x07, 0xF0, 0x00, 0x00, 0x3C, ##         0000                  0000000                      0000
            0x03, 0xC0, 0x00, 0x07, 0xF0, 0x00, 0x00, 0x3C, ##        0000                   0000000                      0000
            0x03, 0xC0, 0x00, 0x07, 0xF0, 0x00, 0x00, 0x3C, ##        0000                   0000000                      0000
            0x03, 0x80, 0x00, 0x07, 0xF0, 0x00, 0x00, 0x3C, ##        000                    0000000                      0000
            0x07, 0x80, 0x00, 0x07, 0xF0, 0x00, 0x00, 0x3C, ##       0000                    0000000                      0000
            0x07, 0x80, 0x00, 0x07, 0xF0, 0x00, 0x00, 0x3C, ##       0000                    0000000                      0000
            0x0F, 0x00, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFC, ##      0000                     000000000000000000000000000000000
            0xFF, 0xF8, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  0000000000000          000000000000000000000000000000000000000
            0xFF, 0xF8, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  0000000000000          000000000000000000000000000000000000000
            0xFF, 0xF8, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  0000000000000          000000000000000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '199' => {    # 'Ç'
        'width'    => 42, 
        'xoffset'  => 4, 
        'xadvance' => 50, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x3F, 0xF8, 0x00, 0x00, ##                    00000000000             
            0x00, 0x03, 0xFF, 0xFF, 0xC0, 0x00, ##                00000000000000000000        
            0x00, 0x0F, 0xFF, 0xFF, 0xF8, 0x00, ##              0000000000000000000000000     
            0x00, 0x3F, 0xC0, 0x1F, 0xFF, 0x00, ##            00000000         0000000000000  
            0x00, 0x7E, 0x00, 0x03, 0xFF, 0x80, ##           000000               00000000000 
            0x01, 0xFC, 0x00, 0x00, 0xFF, 0x80, ##         0000000                  000000000 
            0x03, 0xF8, 0x00, 0x00, 0x7F, 0x80, ##        0000000                    00000000 
            0x03, 0xF0, 0x00, 0x00, 0x3F, 0x80, ##        000000                      0000000 
            0x07, 0xE0, 0x00, 0x00, 0x1F, 0x80, ##       000000                        000000 
            0x0F, 0xC0, 0x00, 0x00, 0x1F, 0x80, ##      000000                         000000 
            0x1F, 0xC0, 0x00, 0x00, 0x0F, 0x80, ##     0000000                          00000 
            0x1F, 0x80, 0x00, 0x00, 0x0F, 0x80, ##     000000                           00000 
            0x3F, 0x80, 0x00, 0x00, 0x0F, 0x80, ##    0000000                           00000 
            0x3F, 0x00, 0x00, 0x00, 0x07, 0x80, ##    000000                             0000 
            0x7F, 0x00, 0x00, 0x00, 0x07, 0x80, ##   0000000                             0000 
            0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, ##   0000000                                  
            0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, ##   0000000                                  
            0x7E, 0x00, 0x00, 0x00, 0x00, 0x00, ##   000000                                   
            0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000000                                   
            0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000000                                   
            0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000000                                   
            0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000000                                   
            0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000000                                   
            0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000000                                   
            0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000000                                   
            0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000000                                   
            0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000000                                   
            0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000000                                   
            0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000000                                   
            0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000000                                   
            0x7E, 0x00, 0x00, 0x00, 0x00, 0x00, ##   000000                                   
            0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, ##   0000000                                  
            0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, ##   0000000                                  
            0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, ##   0000000                                  
            0x3F, 0x00, 0x00, 0x00, 0x00, 0x00, ##    000000                                  
            0x3F, 0x80, 0x00, 0x00, 0x0F, 0xC0, ##    0000000                           000000
            0x1F, 0x80, 0x00, 0x00, 0x1F, 0x80, ##     000000                          000000 
            0x1F, 0xC0, 0x00, 0x00, 0x1F, 0x80, ##     0000000                         000000 
            0x0F, 0xC0, 0x00, 0x00, 0x1F, 0x00, ##      000000                         00000  
            0x07, 0xE0, 0x00, 0x00, 0x3F, 0x00, ##       000000                       000000  
            0x03, 0xF0, 0x00, 0x00, 0x7E, 0x00, ##        000000                     000000   
            0x01, 0xF0, 0x00, 0x00, 0xFC, 0x00, ##         00000                    000000    
            0x00, 0xFC, 0x00, 0x01, 0xF8, 0x00, ##          000000                 000000     
            0x00, 0x7E, 0x00, 0x07, 0xF0, 0x00, ##           000000              0000000      
            0x00, 0x3F, 0xC0, 0x1F, 0xE0, 0x00, ##            00000000         00000000       
            0x00, 0x0F, 0xFF, 0xFF, 0xC0, 0x00, ##              0000000000000000000000        
            0x00, 0x03, 0xFF, 0xFE, 0x00, 0x00, ##                00000000000000000           
            0x00, 0x00, 0x7F, 0xF0, 0x00, 0x00, ##                   00000000000              
            0x00, 0x00, 0x01, 0xC0, 0x00, 0x00, ##                         000                
            0x00, 0x00, 0x00, 0xE0, 0x00, 0x00, ##                          000               
            0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, ##                          0000              
            0x00, 0x00, 0x00, 0x70, 0x00, 0x00, ##                           000              
            0x00, 0x00, 0x00, 0x78, 0x00, 0x00, ##                           0000             
            0x00, 0x00, 0x00, 0x78, 0x00, 0x00, ##                           0000             
            0x00, 0x00, 0x81, 0xF8, 0x00, 0x00, ##                  0      000000             
            0x00, 0x00, 0xFF, 0xF8, 0x00, 0x00, ##                  0000000000000             
            0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00, ##                  000000000000              
            0x00, 0x00, 0xFF, 0xE0, 0x00, 0x00, ##                  00000000000               
            0x00, 0x00, 0x7F, 0x80, 0x00, 0x00, ##                   00000000                 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '200' => {    # 'È'
        'width'    => 38, 
        'xoffset'  => 4, 
        'xadvance' => 47, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x07, 0xE0, 0x00, 0x00, ##               000000                   
            0x00, 0x03, 0xE0, 0x00, 0x00, ##                00000                   
            0x00, 0x01, 0xF0, 0x00, 0x00, ##                 00000                  
            0x00, 0x00, 0xF8, 0x00, 0x00, ##                  00000                 
            0x00, 0x00, 0x78, 0x00, 0x00, ##                   0000                 
            0x00, 0x00, 0x3C, 0x00, 0x00, ##                    0000                
            0x00, 0x00, 0x1E, 0x00, 0x00, ##                     0000               
            0x00, 0x00, 0x0F, 0x00, 0x00, ##                      0000              
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                        
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                        
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                        
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                        
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xFF, 0xFF, 0xFF, 0x00, ##        00000000000000000000000000      
            0x03, 0xFF, 0xFF, 0xFF, 0x00, ##        00000000000000000000000000      
            0x03, 0xFF, 0xFF, 0xFF, 0x00, ##        00000000000000000000000000      
            0x03, 0xFF, 0xFF, 0xFF, 0x00, ##        00000000000000000000000000      
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xFF, 0xFF, 0xFF, 0xFC, ##        00000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '201' => {    # 'É'
        'width'    => 38, 
        'xoffset'  => 4, 
        'xadvance' => 47, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x03, 0xF0, 0x00, ##                        000000          
            0x00, 0x00, 0x07, 0xE0, 0x00, ##                       000000           
            0x00, 0x00, 0x07, 0xC0, 0x00, ##                       00000            
            0x00, 0x00, 0x0F, 0x80, 0x00, ##                      00000             
            0x00, 0x00, 0x1F, 0x00, 0x00, ##                     00000              
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000               
            0x00, 0x00, 0x3C, 0x00, 0x00, ##                    0000                
            0x00, 0x00, 0x78, 0x00, 0x00, ##                   0000                 
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                        
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                        
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                        
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                        
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xFF, 0xFF, 0xFF, 0x00, ##        00000000000000000000000000      
            0x03, 0xFF, 0xFF, 0xFF, 0x00, ##        00000000000000000000000000      
            0x03, 0xFF, 0xFF, 0xFF, 0x00, ##        00000000000000000000000000      
            0x03, 0xFF, 0xFF, 0xFF, 0x00, ##        00000000000000000000000000      
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xFF, 0xFF, 0xFF, 0xFC, ##        00000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '202' => {    # 'Ê'
        'width'    => 38, 
        'xoffset'  => 4, 
        'xadvance' => 47, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x7F, 0x00, 0x00, ##                   0000000              
            0x00, 0x00, 0xFF, 0x00, 0x00, ##                  00000000              
            0x00, 0x01, 0xFF, 0x80, 0x00, ##                 0000000000             
            0x00, 0x03, 0xF7, 0xC0, 0x00, ##                000000 00000            
            0x00, 0x03, 0xE3, 0xE0, 0x00, ##                00000   00000           
            0x00, 0x07, 0x81, 0xF0, 0x00, ##               0000      00000          
            0x00, 0x0F, 0x00, 0x78, 0x00, ##              0000         0000         
            0x00, 0x1E, 0x00, 0x3C, 0x00, ##             0000           0000        
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                        
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                        
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                        
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                        
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xFF, 0xFF, 0xFF, 0x00, ##        00000000000000000000000000      
            0x03, 0xFF, 0xFF, 0xFF, 0x00, ##        00000000000000000000000000      
            0x03, 0xFF, 0xFF, 0xFF, 0x00, ##        00000000000000000000000000      
            0x03, 0xFF, 0xFF, 0xFF, 0x00, ##        00000000000000000000000000      
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xFF, 0xFF, 0xFF, 0xFC, ##        00000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '203' => {    # 'Ë'
        'width'    => 38, 
        'xoffset'  => 4, 
        'xadvance' => 47, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x0E, 0x00, 0xE0, 0x00, ##              000         000           
            0x00, 0x1F, 0x01, 0xF0, 0x00, ##             00000       00000          
            0x00, 0x3F, 0x83, 0xF8, 0x00, ##            0000000     0000000         
            0x00, 0x3F, 0x83, 0xF8, 0x00, ##            0000000     0000000         
            0x00, 0x3F, 0x83, 0xF8, 0x00, ##            0000000     0000000         
            0x00, 0x1F, 0x01, 0xF0, 0x00, ##             00000       00000          
            0x00, 0x0E, 0x00, 0xE0, 0x00, ##              000         000           
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                        
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                        
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                        
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                        
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                        
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xFF, 0xFF, 0xFF, 0x00, ##        00000000000000000000000000      
            0x03, 0xFF, 0xFF, 0xFF, 0x00, ##        00000000000000000000000000      
            0x03, 0xFF, 0xFF, 0xFF, 0x00, ##        00000000000000000000000000      
            0x03, 0xFF, 0xFF, 0xFF, 0x00, ##        00000000000000000000000000      
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xF8, 0x00, 0x0F, 0x00, ##        0000000               0000      
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xF8, 0x00, 0x00, 0x3C, ##        0000000                     0000
            0x03, 0xFF, 0xFF, 0xFF, 0xFC, ##        00000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '204' => {    # 'Ì'
        'width'    => 18, 
        'xoffset'  => 4, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x7F, 0x00, 0x00, ##   0000000          
            0x3F, 0x00, 0x00, ##    000000          
            0x0F, 0x80, 0x00, ##      00000         
            0x07, 0xC0, 0x00, ##       00000        
            0x03, 0xE0, 0x00, ##        00000       
            0x01, 0xE0, 0x00, ##         0000       
            0x00, 0xF0, 0x00, ##          0000      
            0x00, 0x78, 0x00, ##           0000     
            0x00, 0x00, 0x00, ##                    
            0x00, 0x00, 0x00, ##                    
            0x00, 0x00, 0x00, ##                    
            0x00, 0x00, 0x00, ##                    
            0x00, 0x00, 0x00, ##                    
            0xFF, 0xFF, 0xC0, ##  000000000000000000
            0xFF, 0xFF, 0xC0, ##  000000000000000000
            0xFF, 0xFF, 0xC0, ##  000000000000000000
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0xFF, 0xFF, 0xC0, ##  000000000000000000
            0xFF, 0xFF, 0xC0, ##  000000000000000000
            0xFF, 0xFF, 0xC0, ##  000000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '205' => {    # 'Í'
        'width'    => 18, 
        'xoffset'  => 4, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x1F, 0x80, ##             000000 
            0x00, 0x1F, 0x00, ##             00000  
            0x00, 0x3E, 0x00, ##            00000   
            0x00, 0x7C, 0x00, ##           00000    
            0x00, 0xF8, 0x00, ##          00000     
            0x01, 0xF0, 0x00, ##         00000      
            0x01, 0xE0, 0x00, ##         0000       
            0x03, 0xC0, 0x00, ##        0000        
            0x00, 0x00, 0x00, ##                    
            0x00, 0x00, 0x00, ##                    
            0x00, 0x00, 0x00, ##                    
            0x00, 0x00, 0x00, ##                    
            0x00, 0x00, 0x00, ##                    
            0xFF, 0xFF, 0xC0, ##  000000000000000000
            0xFF, 0xFF, 0xC0, ##  000000000000000000
            0xFF, 0xFF, 0xC0, ##  000000000000000000
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0x03, 0xF8, 0x00, ##        0000000     
            0xFF, 0xFF, 0xC0, ##  000000000000000000
            0xFF, 0xFF, 0xC0, ##  000000000000000000
            0xFF, 0xFF, 0xC0, ##  000000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '206' => {    # 'Î'
        'width'    => 20, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x01, 0xFC, 0x00, ##         0000000      
            0x03, 0xFE, 0x00, ##        000000000     
            0x07, 0xFF, 0x00, ##       00000000000    
            0x0F, 0xDF, 0x00, ##      000000 00000    
            0x1F, 0x8F, 0x80, ##     000000   00000   
            0x3E, 0x03, 0xC0, ##    00000       0000  
            0x3C, 0x01, 0xE0, ##    0000         0000 
            0x78, 0x00, 0xF0, ##   0000           0000
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x7F, 0xFF, 0xE0, ##   000000000000000000 
            0x7F, 0xFF, 0xE0, ##   000000000000000000 
            0x7F, 0xFF, 0xE0, ##   000000000000000000 
            0x01, 0xFC, 0x00, ##         0000000      
            0x01, 0xFC, 0x00, ##         0000000      
            0x01, 0xFC, 0x00, ##         0000000      
            0x01, 0xFC, 0x00, ##         0000000      
            0x01, 0xFC, 0x00, ##         0000000      
            0x01, 0xFC, 0x00, ##         0000000      
            0x01, 0xFC, 0x00, ##         0000000      
            0x01, 0xFC, 0x00, ##         0000000      
            0x01, 0xFC, 0x00, ##         0000000      
            0x01, 0xFC, 0x00, ##         0000000      
            0x01, 0xFC, 0x00, ##         0000000      
            0x01, 0xFC, 0x00, ##         0000000      
            0x01, 0xFC, 0x00, ##         0000000      
            0x01, 0xFC, 0x00, ##         0000000      
            0x01, 0xFC, 0x00, ##         0000000      
            0x01, 0xFC, 0x00, ##         0000000      
            0x01, 0xFC, 0x00, ##         0000000      
            0x01, 0xFC, 0x00, ##         0000000      
            0x01, 0xFC, 0x00, ##         0000000      
            0x01, 0xFC, 0x00, ##         0000000      
            0x01, 0xFC, 0x00, ##         0000000      
            0x01, 0xFC, 0x00, ##         0000000      
            0x01, 0xFC, 0x00, ##         0000000      
            0x01, 0xFC, 0x00, ##         0000000      
            0x01, 0xFC, 0x00, ##         0000000      
            0x01, 0xFC, 0x00, ##         0000000      
            0x01, 0xFC, 0x00, ##         0000000      
            0x01, 0xFC, 0x00, ##         0000000      
            0x01, 0xFC, 0x00, ##         0000000      
            0x01, 0xFC, 0x00, ##         0000000      
            0x01, 0xFC, 0x00, ##         0000000      
            0x01, 0xFC, 0x00, ##         0000000      
            0x01, 0xFC, 0x00, ##         0000000      
            0x01, 0xFC, 0x00, ##         0000000      
            0x01, 0xFC, 0x00, ##         0000000      
            0x01, 0xFC, 0x00, ##         0000000      
            0x01, 0xFC, 0x00, ##         0000000      
            0x01, 0xFC, 0x00, ##         0000000      
            0x01, 0xFC, 0x00, ##         0000000      
            0x01, 0xFC, 0x00, ##         0000000      
            0x7F, 0xFF, 0xE0, ##   000000000000000000 
            0x7F, 0xFF, 0xE0, ##   000000000000000000 
            0x7F, 0xFF, 0xE0, ##   000000000000000000 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '207' => {    # 'Ï'
        'width'    => 19, 
        'xoffset'  => 3, 
        'xadvance' => 25, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x38, 0x03, 0x80, ##    000         000  
            0x7C, 0x07, 0xC0, ##   00000       00000 
            0xFE, 0x0F, 0xE0, ##  0000000     0000000
            0xFE, 0x0F, 0xE0, ##  0000000     0000000
            0xFE, 0x0F, 0xE0, ##  0000000     0000000
            0x7C, 0x07, 0xC0, ##   00000       00000 
            0x38, 0x03, 0x80, ##    000         000  
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x7F, 0xFF, 0xE0, ##   000000000000000000
            0x7F, 0xFF, 0xE0, ##   000000000000000000
            0x7F, 0xFF, 0xE0, ##   000000000000000000
            0x03, 0xF8, 0x00, ##        0000000      
            0x03, 0xF8, 0x00, ##        0000000      
            0x03, 0xF8, 0x00, ##        0000000      
            0x03, 0xF8, 0x00, ##        0000000      
            0x03, 0xF8, 0x00, ##        0000000      
            0x03, 0xF8, 0x00, ##        0000000      
            0x03, 0xF8, 0x00, ##        0000000      
            0x03, 0xF8, 0x00, ##        0000000      
            0x03, 0xF8, 0x00, ##        0000000      
            0x03, 0xF8, 0x00, ##        0000000      
            0x03, 0xF8, 0x00, ##        0000000      
            0x03, 0xF8, 0x00, ##        0000000      
            0x03, 0xF8, 0x00, ##        0000000      
            0x03, 0xF8, 0x00, ##        0000000      
            0x03, 0xF8, 0x00, ##        0000000      
            0x03, 0xF8, 0x00, ##        0000000      
            0x03, 0xF8, 0x00, ##        0000000      
            0x03, 0xF8, 0x00, ##        0000000      
            0x03, 0xF8, 0x00, ##        0000000      
            0x03, 0xF8, 0x00, ##        0000000      
            0x03, 0xF8, 0x00, ##        0000000      
            0x03, 0xF8, 0x00, ##        0000000      
            0x03, 0xF8, 0x00, ##        0000000      
            0x03, 0xF8, 0x00, ##        0000000      
            0x03, 0xF8, 0x00, ##        0000000      
            0x03, 0xF8, 0x00, ##        0000000      
            0x03, 0xF8, 0x00, ##        0000000      
            0x03, 0xF8, 0x00, ##        0000000      
            0x03, 0xF8, 0x00, ##        0000000      
            0x03, 0xF8, 0x00, ##        0000000      
            0x03, 0xF8, 0x00, ##        0000000      
            0x03, 0xF8, 0x00, ##        0000000      
            0x03, 0xF8, 0x00, ##        0000000      
            0x03, 0xF8, 0x00, ##        0000000      
            0x03, 0xF8, 0x00, ##        0000000      
            0x03, 0xF8, 0x00, ##        0000000      
            0x03, 0xF8, 0x00, ##        0000000      
            0x03, 0xF8, 0x00, ##        0000000      
            0x03, 0xF8, 0x00, ##        0000000      
            0x03, 0xF8, 0x00, ##        0000000      
            0x7F, 0xFF, 0xE0, ##   000000000000000000
            0x7F, 0xFF, 0xE0, ##   000000000000000000
            0x7F, 0xFF, 0xE0, ##   000000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '208' => {    # 'Ð'
        'width'    => 44, 
        'xoffset'  => 4, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x00, ##  0000000000000000000000000                   
            0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x00, ##  00000000000000000000000000000               
            0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, ##  00000000000000000000000000000000            
            0x03, 0xF8, 0x00, 0xFF, 0xC0, 0x00, ##        0000000           0000000000          
            0x03, 0xF8, 0x00, 0x1F, 0xE0, 0x00, ##        0000000              00000000         
            0x03, 0xF8, 0x00, 0x07, 0xF8, 0x00, ##        0000000                00000000       
            0x03, 0xF8, 0x00, 0x03, 0xFC, 0x00, ##        0000000                 00000000      
            0x03, 0xF8, 0x00, 0x00, 0xFE, 0x00, ##        0000000                   0000000     
            0x03, 0xF8, 0x00, 0x00, 0x7F, 0x00, ##        0000000                    0000000    
            0x03, 0xF8, 0x00, 0x00, 0x7F, 0x00, ##        0000000                    0000000    
            0x03, 0xF8, 0x00, 0x00, 0x3F, 0x80, ##        0000000                     0000000   
            0x03, 0xF8, 0x00, 0x00, 0x1F, 0x80, ##        0000000                      000000   
            0x03, 0xF8, 0x00, 0x00, 0x1F, 0xC0, ##        0000000                      0000000  
            0x03, 0xF8, 0x00, 0x00, 0x1F, 0xC0, ##        0000000                      0000000  
            0x03, 0xF8, 0x00, 0x00, 0x0F, 0xE0, ##        0000000                       0000000 
            0x03, 0xF8, 0x00, 0x00, 0x0F, 0xE0, ##        0000000                       0000000 
            0x03, 0xF8, 0x00, 0x00, 0x0F, 0xE0, ##        0000000                       0000000 
            0x03, 0xF8, 0x00, 0x00, 0x07, 0xF0, ##        0000000                        0000000
            0x03, 0xF8, 0x00, 0x00, 0x07, 0xF0, ##        0000000                        0000000
            0x03, 0xF8, 0x00, 0x00, 0x07, 0xF0, ##        0000000                        0000000
            0xFF, 0xFF, 0xFE, 0x00, 0x07, 0xF0, ##  00000000000000000000000              0000000
            0xFF, 0xFF, 0xFE, 0x00, 0x07, 0xF0, ##  00000000000000000000000              0000000
            0xFF, 0xFF, 0xFE, 0x00, 0x07, 0xF0, ##  00000000000000000000000              0000000
            0xFF, 0xFF, 0xFE, 0x00, 0x07, 0xF0, ##  00000000000000000000000              0000000
            0x03, 0xF8, 0x00, 0x00, 0x07, 0xF0, ##        0000000                        0000000
            0x03, 0xF8, 0x00, 0x00, 0x07, 0xF0, ##        0000000                        0000000
            0x03, 0xF8, 0x00, 0x00, 0x07, 0xF0, ##        0000000                        0000000
            0x03, 0xF8, 0x00, 0x00, 0x07, 0xF0, ##        0000000                        0000000
            0x03, 0xF8, 0x00, 0x00, 0x07, 0xF0, ##        0000000                        0000000
            0x03, 0xF8, 0x00, 0x00, 0x0F, 0xE0, ##        0000000                       0000000 
            0x03, 0xF8, 0x00, 0x00, 0x0F, 0xE0, ##        0000000                       0000000 
            0x03, 0xF8, 0x00, 0x00, 0x0F, 0xE0, ##        0000000                       0000000 
            0x03, 0xF8, 0x00, 0x00, 0x1F, 0xC0, ##        0000000                      0000000  
            0x03, 0xF8, 0x00, 0x00, 0x1F, 0xC0, ##        0000000                      0000000  
            0x03, 0xF8, 0x00, 0x00, 0x1F, 0x80, ##        0000000                      000000   
            0x03, 0xF8, 0x00, 0x00, 0x3F, 0x80, ##        0000000                     0000000   
            0x03, 0xF8, 0x00, 0x00, 0x7F, 0x00, ##        0000000                    0000000    
            0x03, 0xF8, 0x00, 0x00, 0x7F, 0x00, ##        0000000                    0000000    
            0x03, 0xF8, 0x00, 0x00, 0xFE, 0x00, ##        0000000                   0000000     
            0x03, 0xF8, 0x00, 0x03, 0xFC, 0x00, ##        0000000                 00000000      
            0x03, 0xF8, 0x00, 0x07, 0xF8, 0x00, ##        0000000                00000000       
            0x03, 0xF8, 0x00, 0x1F, 0xE0, 0x00, ##        0000000              00000000         
            0x03, 0xF8, 0x00, 0xFF, 0xC0, 0x00, ##        0000000           0000000000          
            0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, ##  00000000000000000000000000000000            
            0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x00, ##  00000000000000000000000000000               
            0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x00, ##  0000000000000000000000000                   
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '209' => {    # 'Ñ'
        'width'    => 50, 
        'xoffset'  => 3, 
        'xadvance' => 56, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x3E, 0x00, 0xE0, 0x00, 0x00, ##                    00000         000               
            0x00, 0x00, 0xFF, 0x80, 0xE0, 0x00, 0x00, ##                  000000000       000               
            0x00, 0x01, 0xFF, 0xE1, 0xE0, 0x00, 0x00, ##                 000000000000    0000               
            0x00, 0x01, 0xE3, 0xFF, 0xC0, 0x00, 0x00, ##                 0000   000000000000                
            0x00, 0x03, 0xC0, 0xFF, 0x80, 0x00, 0x00, ##                0000      000000000                 
            0x00, 0x03, 0x80, 0x3F, 0x00, 0x00, 0x00, ##                000         000000                  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                    
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                    
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                    
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                    
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                    
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                    
            0xFF, 0xF0, 0x00, 0x00, 0x3F, 0xFF, 0xC0, ##  000000000000                      0000000000000000
            0xFF, 0xF8, 0x00, 0x00, 0x3F, 0xFF, 0xC0, ##  0000000000000                     0000000000000000
            0xFF, 0xFC, 0x00, 0x00, 0x3F, 0xFF, 0xC0, ##  00000000000000                    0000000000000000
            0x03, 0xFC, 0x00, 0x00, 0x00, 0xF0, 0x00, ##        00000000                          0000      
            0x03, 0xFE, 0x00, 0x00, 0x00, 0xF0, 0x00, ##        000000000                         0000      
            0x03, 0xFF, 0x00, 0x00, 0x00, 0xF0, 0x00, ##        0000000000                        0000      
            0x03, 0xFF, 0x80, 0x00, 0x00, 0xF0, 0x00, ##        00000000000                       0000      
            0x03, 0xFF, 0xC0, 0x00, 0x00, 0xF0, 0x00, ##        000000000000                      0000      
            0x03, 0xFF, 0xC0, 0x00, 0x00, 0xF0, 0x00, ##        000000000000                      0000      
            0x03, 0xDF, 0xE0, 0x00, 0x00, 0xF0, 0x00, ##        0000 00000000                     0000      
            0x03, 0xCF, 0xF0, 0x00, 0x00, 0xF0, 0x00, ##        0000  00000000                    0000      
            0x03, 0xC7, 0xF8, 0x00, 0x00, 0xF0, 0x00, ##        0000   00000000                   0000      
            0x03, 0xC3, 0xF8, 0x00, 0x00, 0xF0, 0x00, ##        0000    0000000                   0000      
            0x03, 0xC3, 0xFC, 0x00, 0x00, 0xF0, 0x00, ##        0000    00000000                  0000      
            0x03, 0xC1, 0xFE, 0x00, 0x00, 0xF0, 0x00, ##        0000     00000000                 0000      
            0x03, 0xC0, 0xFF, 0x00, 0x00, 0xF0, 0x00, ##        0000      00000000                0000      
            0x03, 0xC0, 0x7F, 0x80, 0x00, 0xF0, 0x00, ##        0000       00000000               0000      
            0x03, 0xC0, 0x7F, 0x80, 0x00, 0xF0, 0x00, ##        0000       00000000               0000      
            0x03, 0xC0, 0x3F, 0xC0, 0x00, 0xF0, 0x00, ##        0000        00000000              0000      
            0x03, 0xC0, 0x1F, 0xE0, 0x00, 0xF0, 0x00, ##        0000         00000000             0000      
            0x03, 0xC0, 0x0F, 0xF0, 0x00, 0xF0, 0x00, ##        0000          00000000            0000      
            0x03, 0xC0, 0x0F, 0xF0, 0x00, 0xF0, 0x00, ##        0000          00000000            0000      
            0x03, 0xC0, 0x07, 0xF8, 0x00, 0xF0, 0x00, ##        0000           00000000           0000      
            0x03, 0xC0, 0x03, 0xFC, 0x00, 0xF0, 0x00, ##        0000            00000000          0000      
            0x03, 0xC0, 0x01, 0xFE, 0x00, 0xF0, 0x00, ##        0000             00000000         0000      
            0x03, 0xC0, 0x00, 0xFF, 0x00, 0xF0, 0x00, ##        0000              00000000        0000      
            0x03, 0xC0, 0x00, 0xFF, 0x00, 0xF0, 0x00, ##        0000              00000000        0000      
            0x03, 0xC0, 0x00, 0x7F, 0x80, 0xF0, 0x00, ##        0000               00000000       0000      
            0x03, 0xC0, 0x00, 0x3F, 0xC0, 0xF0, 0x00, ##        0000                00000000      0000      
            0x03, 0xC0, 0x00, 0x1F, 0xE0, 0xF0, 0x00, ##        0000                 00000000     0000      
            0x03, 0xC0, 0x00, 0x1F, 0xE0, 0xF0, 0x00, ##        0000                 00000000     0000      
            0x03, 0xC0, 0x00, 0x0F, 0xF0, 0xF0, 0x00, ##        0000                  00000000    0000      
            0x03, 0xC0, 0x00, 0x07, 0xF8, 0xF0, 0x00, ##        0000                   00000000   0000      
            0x03, 0xC0, 0x00, 0x03, 0xFC, 0xF0, 0x00, ##        0000                    00000000  0000      
            0x03, 0xC0, 0x00, 0x03, 0xFC, 0xF0, 0x00, ##        0000                    00000000  0000      
            0x03, 0xC0, 0x00, 0x01, 0xFE, 0xF0, 0x00, ##        0000                     00000000 0000      
            0x03, 0xC0, 0x00, 0x00, 0xFF, 0xF0, 0x00, ##        0000                      000000000000      
            0x03, 0xC0, 0x00, 0x00, 0x7F, 0xF0, 0x00, ##        0000                       00000000000      
            0x03, 0xC0, 0x00, 0x00, 0x3F, 0xF0, 0x00, ##        0000                        0000000000      
            0x03, 0xC0, 0x00, 0x00, 0x3F, 0xF0, 0x00, ##        0000                        0000000000      
            0x03, 0xC0, 0x00, 0x00, 0x1F, 0xF0, 0x00, ##        0000                         000000000      
            0x03, 0xC0, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##        0000                          00000000      
            0x03, 0xC0, 0x00, 0x00, 0x07, 0xF0, 0x00, ##        0000                           0000000      
            0xFF, 0xFF, 0x00, 0x00, 0x07, 0xF0, 0x00, ##  0000000000000000                     0000000      
            0xFF, 0xFF, 0x00, 0x00, 0x03, 0xF0, 0x00, ##  0000000000000000                      000000      
            0xFF, 0xFF, 0x00, 0x00, 0x01, 0xF0, 0x00, ##  0000000000000000                       00000      
            0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x00, ##                                          0000      
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '210' => {    # 'Ò'
        'width'    => 45, 
        'xoffset'  => 4, 
        'xadvance' => 53, 
        'bitmap'   => [ 
            0x00, 0x01, 0xF8, 0x00, 0x00, 0x00, ##                 000000                        
            0x00, 0x00, 0xF8, 0x00, 0x00, 0x00, ##                  00000                        
            0x00, 0x00, 0x7C, 0x00, 0x00, 0x00, ##                   00000                       
            0x00, 0x00, 0x3E, 0x00, 0x00, 0x00, ##                    00000                      
            0x00, 0x00, 0x1F, 0x00, 0x00, 0x00, ##                     00000                     
            0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, ##                      0000                     
            0x00, 0x00, 0x07, 0x80, 0x00, 0x00, ##                       0000                    
            0x00, 0x00, 0x03, 0xC0, 0x00, 0x00, ##                        0000                   
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                               
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                               
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                               
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                               
            0x00, 0x00, 0x7F, 0xF0, 0x00, 0x00, ##                   00000000000                 
            0x00, 0x03, 0xFF, 0xFE, 0x00, 0x00, ##                00000000000000000              
            0x00, 0x0F, 0xFF, 0xFF, 0x80, 0x00, ##              000000000000000000000            
            0x00, 0x3F, 0xC0, 0x1F, 0xE0, 0x00, ##            00000000         00000000          
            0x00, 0x7E, 0x00, 0x03, 0xF0, 0x00, ##           000000               000000         
            0x01, 0xFC, 0x00, 0x01, 0xFC, 0x00, ##         0000000                 0000000       
            0x03, 0xF8, 0x00, 0x00, 0xFE, 0x00, ##        0000000                   0000000      
            0x03, 0xF0, 0x00, 0x00, 0x7F, 0x00, ##        000000                     0000000     
            0x07, 0xE0, 0x00, 0x00, 0x3F, 0x00, ##       000000                       000000     
            0x0F, 0xC0, 0x00, 0x00, 0x1F, 0x80, ##      000000                         000000    
            0x1F, 0xC0, 0x00, 0x00, 0x1F, 0xC0, ##     0000000                         0000000   
            0x1F, 0x80, 0x00, 0x00, 0x0F, 0xC0, ##     000000                           000000   
            0x3F, 0x80, 0x00, 0x00, 0x0F, 0xE0, ##    0000000                           0000000  
            0x3F, 0x00, 0x00, 0x00, 0x07, 0xE0, ##    000000                             000000  
            0x7F, 0x00, 0x00, 0x00, 0x07, 0xF0, ##   0000000                             0000000 
            0x7F, 0x00, 0x00, 0x00, 0x07, 0xF0, ##   0000000                             0000000 
            0x7F, 0x00, 0x00, 0x00, 0x07, 0xF0, ##   0000000                             0000000 
            0x7E, 0x00, 0x00, 0x00, 0x03, 0xF0, ##   000000                               000000 
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0x7E, 0x00, 0x00, 0x00, 0x03, 0xF0, ##   000000                               000000 
            0x7F, 0x00, 0x00, 0x00, 0x07, 0xF0, ##   0000000                             0000000 
            0x7F, 0x00, 0x00, 0x00, 0x07, 0xF0, ##   0000000                             0000000 
            0x7F, 0x00, 0x00, 0x00, 0x07, 0xE0, ##   0000000                             000000  
            0x3F, 0x00, 0x00, 0x00, 0x07, 0xE0, ##    000000                             000000  
            0x3F, 0x80, 0x00, 0x00, 0x0F, 0xE0, ##    0000000                           0000000  
            0x1F, 0x80, 0x00, 0x00, 0x0F, 0xC0, ##     000000                           000000   
            0x1F, 0xC0, 0x00, 0x00, 0x1F, 0xC0, ##     0000000                         0000000   
            0x0F, 0xC0, 0x00, 0x00, 0x1F, 0x80, ##      000000                         000000    
            0x07, 0xE0, 0x00, 0x00, 0x3F, 0x00, ##       000000                       000000     
            0x03, 0xF0, 0x00, 0x00, 0x7E, 0x00, ##        000000                     000000      
            0x03, 0xF0, 0x00, 0x00, 0xFE, 0x00, ##        000000                    0000000      
            0x01, 0xFC, 0x00, 0x01, 0xF8, 0x00, ##         0000000                 000000        
            0x00, 0x7E, 0x00, 0x03, 0xF0, 0x00, ##           000000               000000         
            0x00, 0x3F, 0xC0, 0x1F, 0xE0, 0x00, ##            00000000         00000000          
            0x00, 0x0F, 0xFF, 0xFF, 0x80, 0x00, ##              000000000000000000000            
            0x00, 0x03, 0xFF, 0xFE, 0x00, 0x00, ##                00000000000000000              
            0x00, 0x00, 0x7F, 0xF0, 0x00, 0x00, ##                   00000000000                 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '211' => {    # 'Ó'
        'width'    => 45, 
        'xoffset'  => 4, 
        'xadvance' => 53, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, ##                          000000               
            0x00, 0x00, 0x01, 0xF8, 0x00, 0x00, ##                         000000                
            0x00, 0x00, 0x01, 0xF0, 0x00, 0x00, ##                         00000                 
            0x00, 0x00, 0x03, 0xE0, 0x00, 0x00, ##                        00000                  
            0x00, 0x00, 0x07, 0xC0, 0x00, 0x00, ##                       00000                   
            0x00, 0x00, 0x07, 0x80, 0x00, 0x00, ##                       0000                    
            0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, ##                      0000                     
            0x00, 0x00, 0x1E, 0x00, 0x00, 0x00, ##                     0000                      
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                               
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                               
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                               
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                               
            0x00, 0x00, 0x7F, 0xF0, 0x00, 0x00, ##                   00000000000                 
            0x00, 0x03, 0xFF, 0xFE, 0x00, 0x00, ##                00000000000000000              
            0x00, 0x0F, 0xFF, 0xFF, 0x80, 0x00, ##              000000000000000000000            
            0x00, 0x3F, 0xC0, 0x1F, 0xE0, 0x00, ##            00000000         00000000          
            0x00, 0x7E, 0x00, 0x03, 0xF0, 0x00, ##           000000               000000         
            0x01, 0xFC, 0x00, 0x01, 0xFC, 0x00, ##         0000000                 0000000       
            0x03, 0xF8, 0x00, 0x00, 0xFE, 0x00, ##        0000000                   0000000      
            0x03, 0xF0, 0x00, 0x00, 0x7F, 0x00, ##        000000                     0000000     
            0x07, 0xE0, 0x00, 0x00, 0x3F, 0x00, ##       000000                       000000     
            0x0F, 0xC0, 0x00, 0x00, 0x1F, 0x80, ##      000000                         000000    
            0x1F, 0xC0, 0x00, 0x00, 0x1F, 0xC0, ##     0000000                         0000000   
            0x1F, 0x80, 0x00, 0x00, 0x0F, 0xC0, ##     000000                           000000   
            0x3F, 0x80, 0x00, 0x00, 0x0F, 0xE0, ##    0000000                           0000000  
            0x3F, 0x00, 0x00, 0x00, 0x07, 0xE0, ##    000000                             000000  
            0x7F, 0x00, 0x00, 0x00, 0x07, 0xF0, ##   0000000                             0000000 
            0x7F, 0x00, 0x00, 0x00, 0x07, 0xF0, ##   0000000                             0000000 
            0x7F, 0x00, 0x00, 0x00, 0x07, 0xF0, ##   0000000                             0000000 
            0x7E, 0x00, 0x00, 0x00, 0x03, 0xF0, ##   000000                               000000 
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0x7E, 0x00, 0x00, 0x00, 0x03, 0xF0, ##   000000                               000000 
            0x7F, 0x00, 0x00, 0x00, 0x07, 0xF0, ##   0000000                             0000000 
            0x7F, 0x00, 0x00, 0x00, 0x07, 0xF0, ##   0000000                             0000000 
            0x7F, 0x00, 0x00, 0x00, 0x07, 0xE0, ##   0000000                             000000  
            0x3F, 0x00, 0x00, 0x00, 0x07, 0xE0, ##    000000                             000000  
            0x3F, 0x80, 0x00, 0x00, 0x0F, 0xE0, ##    0000000                           0000000  
            0x1F, 0x80, 0x00, 0x00, 0x0F, 0xC0, ##     000000                           000000   
            0x1F, 0xC0, 0x00, 0x00, 0x1F, 0xC0, ##     0000000                         0000000   
            0x0F, 0xC0, 0x00, 0x00, 0x1F, 0x80, ##      000000                         000000    
            0x07, 0xE0, 0x00, 0x00, 0x3F, 0x00, ##       000000                       000000     
            0x03, 0xF0, 0x00, 0x00, 0x7E, 0x00, ##        000000                     000000      
            0x03, 0xF0, 0x00, 0x00, 0xFE, 0x00, ##        000000                    0000000      
            0x01, 0xFC, 0x00, 0x01, 0xF8, 0x00, ##         0000000                 000000        
            0x00, 0x7E, 0x00, 0x03, 0xF0, 0x00, ##           000000               000000         
            0x00, 0x3F, 0xC0, 0x1F, 0xE0, 0x00, ##            00000000         00000000          
            0x00, 0x0F, 0xFF, 0xFF, 0x80, 0x00, ##              000000000000000000000            
            0x00, 0x03, 0xFF, 0xFE, 0x00, 0x00, ##                00000000000000000              
            0x00, 0x00, 0x7F, 0xF0, 0x00, 0x00, ##                   00000000000                 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '212' => {    # 'Ô'
        'width'    => 45, 
        'xoffset'  => 4, 
        'xadvance' => 53, 
        'bitmap'   => [ 
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x3F, 0xE0, 0x00, 0x00, ##                    000000000                  
            0x00, 0x00, 0x7F, 0xF0, 0x00, 0x00, ##                   00000000000                 
            0x00, 0x00, 0x7D, 0xF0, 0x00, 0x00, ##                   00000 00000                 
            0x00, 0x00, 0xF8, 0xF8, 0x00, 0x00, ##                  00000   00000                
            0x00, 0x01, 0xE0, 0x3C, 0x00, 0x00, ##                 0000       0000               
            0x00, 0x03, 0xC0, 0x1E, 0x00, 0x00, ##                0000         0000              
            0x00, 0x07, 0x80, 0x0F, 0x00, 0x00, ##               0000           0000             
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                               
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                               
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                               
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                               
            0x00, 0x00, 0x7F, 0xF0, 0x00, 0x00, ##                   00000000000                 
            0x00, 0x03, 0xFF, 0xFE, 0x00, 0x00, ##                00000000000000000              
            0x00, 0x0F, 0xFF, 0xFF, 0x80, 0x00, ##              000000000000000000000            
            0x00, 0x3F, 0xC0, 0x1F, 0xE0, 0x00, ##            00000000         00000000          
            0x00, 0x7E, 0x00, 0x03, 0xF0, 0x00, ##           000000               000000         
            0x01, 0xFC, 0x00, 0x01, 0xFC, 0x00, ##         0000000                 0000000       
            0x03, 0xF8, 0x00, 0x00, 0xFE, 0x00, ##        0000000                   0000000      
            0x03, 0xF0, 0x00, 0x00, 0x7F, 0x00, ##        000000                     0000000     
            0x07, 0xE0, 0x00, 0x00, 0x3F, 0x00, ##       000000                       000000     
            0x0F, 0xC0, 0x00, 0x00, 0x1F, 0x80, ##      000000                         000000    
            0x1F, 0xC0, 0x00, 0x00, 0x1F, 0xC0, ##     0000000                         0000000   
            0x1F, 0x80, 0x00, 0x00, 0x0F, 0xC0, ##     000000                           000000   
            0x3F, 0x80, 0x00, 0x00, 0x0F, 0xE0, ##    0000000                           0000000  
            0x3F, 0x00, 0x00, 0x00, 0x07, 0xE0, ##    000000                             000000  
            0x7F, 0x00, 0x00, 0x00, 0x07, 0xF0, ##   0000000                             0000000 
            0x7F, 0x00, 0x00, 0x00, 0x07, 0xF0, ##   0000000                             0000000 
            0x7F, 0x00, 0x00, 0x00, 0x07, 0xF0, ##   0000000                             0000000 
            0x7E, 0x00, 0x00, 0x00, 0x03, 0xF0, ##   000000                               000000 
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0x7E, 0x00, 0x00, 0x00, 0x03, 0xF0, ##   000000                               000000 
            0x7F, 0x00, 0x00, 0x00, 0x07, 0xF0, ##   0000000                             0000000 
            0x7F, 0x00, 0x00, 0x00, 0x07, 0xF0, ##   0000000                             0000000 
            0x7F, 0x00, 0x00, 0x00, 0x07, 0xE0, ##   0000000                             000000  
            0x3F, 0x00, 0x00, 0x00, 0x07, 0xE0, ##    000000                             000000  
            0x3F, 0x80, 0x00, 0x00, 0x0F, 0xE0, ##    0000000                           0000000  
            0x1F, 0x80, 0x00, 0x00, 0x0F, 0xC0, ##     000000                           000000   
            0x1F, 0xC0, 0x00, 0x00, 0x1F, 0xC0, ##     0000000                         0000000   
            0x0F, 0xC0, 0x00, 0x00, 0x1F, 0x80, ##      000000                         000000    
            0x07, 0xE0, 0x00, 0x00, 0x3F, 0x00, ##       000000                       000000     
            0x03, 0xF0, 0x00, 0x00, 0x7E, 0x00, ##        000000                     000000      
            0x03, 0xF0, 0x00, 0x00, 0xFE, 0x00, ##        000000                    0000000      
            0x01, 0xFC, 0x00, 0x01, 0xF8, 0x00, ##         0000000                 000000        
            0x00, 0x7E, 0x00, 0x03, 0xF0, 0x00, ##           000000               000000         
            0x00, 0x3F, 0xC0, 0x1F, 0xE0, 0x00, ##            00000000         00000000          
            0x00, 0x0F, 0xFF, 0xFF, 0x80, 0x00, ##              000000000000000000000            
            0x00, 0x03, 0xFF, 0xFE, 0x00, 0x00, ##                00000000000000000              
            0x00, 0x00, 0x7F, 0xF0, 0x00, 0x00, ##                   00000000000                 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '213' => {    # 'Õ'
        'width'    => 45, 
        'xoffset'  => 4, 
        'xadvance' => 53, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0xF8, 0x03, 0x80, 0x00, ##                  00000         000            
            0x00, 0x03, 0xFE, 0x03, 0x80, 0x00, ##                000000000       000            
            0x00, 0x07, 0xFF, 0x87, 0x80, 0x00, ##               000000000000    0000            
            0x00, 0x07, 0x8F, 0xFF, 0x00, 0x00, ##               0000   000000000000             
            0x00, 0x0F, 0x03, 0xFE, 0x00, 0x00, ##              0000      000000000              
            0x00, 0x0E, 0x00, 0xFC, 0x00, 0x00, ##              000         000000               
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                               
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                               
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                               
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                               
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                               
            0x00, 0x00, 0x7F, 0xF0, 0x00, 0x00, ##                   00000000000                 
            0x00, 0x03, 0xFF, 0xFE, 0x00, 0x00, ##                00000000000000000              
            0x00, 0x0F, 0xFF, 0xFF, 0x80, 0x00, ##              000000000000000000000            
            0x00, 0x3F, 0xC0, 0x1F, 0xE0, 0x00, ##            00000000         00000000          
            0x00, 0x7E, 0x00, 0x03, 0xF0, 0x00, ##           000000               000000         
            0x01, 0xFC, 0x00, 0x01, 0xFC, 0x00, ##         0000000                 0000000       
            0x03, 0xF8, 0x00, 0x00, 0xFE, 0x00, ##        0000000                   0000000      
            0x03, 0xF0, 0x00, 0x00, 0x7F, 0x00, ##        000000                     0000000     
            0x07, 0xE0, 0x00, 0x00, 0x3F, 0x00, ##       000000                       000000     
            0x0F, 0xC0, 0x00, 0x00, 0x1F, 0x80, ##      000000                         000000    
            0x1F, 0xC0, 0x00, 0x00, 0x1F, 0xC0, ##     0000000                         0000000   
            0x1F, 0x80, 0x00, 0x00, 0x0F, 0xC0, ##     000000                           000000   
            0x3F, 0x80, 0x00, 0x00, 0x0F, 0xE0, ##    0000000                           0000000  
            0x3F, 0x00, 0x00, 0x00, 0x07, 0xE0, ##    000000                             000000  
            0x7F, 0x00, 0x00, 0x00, 0x07, 0xF0, ##   0000000                             0000000 
            0x7F, 0x00, 0x00, 0x00, 0x07, 0xF0, ##   0000000                             0000000 
            0x7F, 0x00, 0x00, 0x00, 0x07, 0xF0, ##   0000000                             0000000 
            0x7E, 0x00, 0x00, 0x00, 0x03, 0xF0, ##   000000                               000000 
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0x7E, 0x00, 0x00, 0x00, 0x03, 0xF0, ##   000000                               000000 
            0x7F, 0x00, 0x00, 0x00, 0x07, 0xF0, ##   0000000                             0000000 
            0x7F, 0x00, 0x00, 0x00, 0x07, 0xF0, ##   0000000                             0000000 
            0x7F, 0x00, 0x00, 0x00, 0x07, 0xE0, ##   0000000                             000000  
            0x3F, 0x00, 0x00, 0x00, 0x07, 0xE0, ##    000000                             000000  
            0x3F, 0x80, 0x00, 0x00, 0x0F, 0xE0, ##    0000000                           0000000  
            0x1F, 0x80, 0x00, 0x00, 0x0F, 0xC0, ##     000000                           000000   
            0x1F, 0xC0, 0x00, 0x00, 0x1F, 0xC0, ##     0000000                         0000000   
            0x0F, 0xC0, 0x00, 0x00, 0x1F, 0x80, ##      000000                         000000    
            0x07, 0xE0, 0x00, 0x00, 0x3F, 0x00, ##       000000                       000000     
            0x03, 0xF0, 0x00, 0x00, 0x7E, 0x00, ##        000000                     000000      
            0x03, 0xF0, 0x00, 0x00, 0xFE, 0x00, ##        000000                    0000000      
            0x01, 0xFC, 0x00, 0x01, 0xF8, 0x00, ##         0000000                 000000        
            0x00, 0x7E, 0x00, 0x03, 0xF0, 0x00, ##           000000               000000         
            0x00, 0x3F, 0xC0, 0x1F, 0xE0, 0x00, ##            00000000         00000000          
            0x00, 0x0F, 0xFF, 0xFF, 0x80, 0x00, ##              000000000000000000000            
            0x00, 0x03, 0xFF, 0xFE, 0x00, 0x00, ##                00000000000000000              
            0x00, 0x00, 0x7F, 0xF0, 0x00, 0x00, ##                   00000000000                 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '214' => {    # 'Ö'
        'width'    => 45, 
        'xoffset'  => 4, 
        'xadvance' => 53, 
        'bitmap'   => [ 
            0x00, 0x01, 0xC0, 0x1C, 0x00, 0x00, ##                 000         000               
            0x00, 0x03, 0xE0, 0x3E, 0x00, 0x00, ##                00000       00000              
            0x00, 0x07, 0xF0, 0x7F, 0x00, 0x00, ##               0000000     0000000             
            0x00, 0x07, 0xF0, 0x7F, 0x00, 0x00, ##               0000000     0000000             
            0x00, 0x07, 0xF0, 0x7F, 0x00, 0x00, ##               0000000     0000000             
            0x00, 0x03, 0xE0, 0x3E, 0x00, 0x00, ##                00000       00000              
            0x00, 0x01, 0xC0, 0x1C, 0x00, 0x00, ##                 000         000               
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                               
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                               
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                               
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                               
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                               
            0x00, 0x00, 0x7F, 0xF0, 0x00, 0x00, ##                   00000000000                 
            0x00, 0x03, 0xFF, 0xFE, 0x00, 0x00, ##                00000000000000000              
            0x00, 0x0F, 0xFF, 0xFF, 0x80, 0x00, ##              000000000000000000000            
            0x00, 0x3F, 0xC0, 0x1F, 0xE0, 0x00, ##            00000000         00000000          
            0x00, 0x7E, 0x00, 0x03, 0xF0, 0x00, ##           000000               000000         
            0x01, 0xFC, 0x00, 0x01, 0xFC, 0x00, ##         0000000                 0000000       
            0x03, 0xF8, 0x00, 0x00, 0xFE, 0x00, ##        0000000                   0000000      
            0x03, 0xF0, 0x00, 0x00, 0x7F, 0x00, ##        000000                     0000000     
            0x07, 0xE0, 0x00, 0x00, 0x3F, 0x00, ##       000000                       000000     
            0x0F, 0xC0, 0x00, 0x00, 0x1F, 0x80, ##      000000                         000000    
            0x1F, 0xC0, 0x00, 0x00, 0x1F, 0xC0, ##     0000000                         0000000   
            0x1F, 0x80, 0x00, 0x00, 0x0F, 0xC0, ##     000000                           000000   
            0x3F, 0x80, 0x00, 0x00, 0x0F, 0xE0, ##    0000000                           0000000  
            0x3F, 0x00, 0x00, 0x00, 0x07, 0xE0, ##    000000                             000000  
            0x7F, 0x00, 0x00, 0x00, 0x07, 0xF0, ##   0000000                             0000000 
            0x7F, 0x00, 0x00, 0x00, 0x07, 0xF0, ##   0000000                             0000000 
            0x7F, 0x00, 0x00, 0x00, 0x07, 0xF0, ##   0000000                             0000000 
            0x7E, 0x00, 0x00, 0x00, 0x03, 0xF0, ##   000000                               000000 
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0xFE, 0x00, 0x00, 0x00, 0x03, 0xF8, ##  0000000                               0000000
            0x7E, 0x00, 0x00, 0x00, 0x03, 0xF0, ##   000000                               000000 
            0x7F, 0x00, 0x00, 0x00, 0x07, 0xF0, ##   0000000                             0000000 
            0x7F, 0x00, 0x00, 0x00, 0x07, 0xF0, ##   0000000                             0000000 
            0x7F, 0x00, 0x00, 0x00, 0x07, 0xE0, ##   0000000                             000000  
            0x3F, 0x00, 0x00, 0x00, 0x07, 0xE0, ##    000000                             000000  
            0x3F, 0x80, 0x00, 0x00, 0x0F, 0xE0, ##    0000000                           0000000  
            0x1F, 0x80, 0x00, 0x00, 0x0F, 0xC0, ##     000000                           000000   
            0x1F, 0xC0, 0x00, 0x00, 0x1F, 0xC0, ##     0000000                         0000000   
            0x0F, 0xC0, 0x00, 0x00, 0x1F, 0x80, ##      000000                         000000    
            0x07, 0xE0, 0x00, 0x00, 0x3F, 0x00, ##       000000                       000000     
            0x03, 0xF0, 0x00, 0x00, 0x7E, 0x00, ##        000000                     000000      
            0x03, 0xF0, 0x00, 0x00, 0xFE, 0x00, ##        000000                    0000000      
            0x01, 0xFC, 0x00, 0x01, 0xF8, 0x00, ##         0000000                 000000        
            0x00, 0x7E, 0x00, 0x03, 0xF0, 0x00, ##           000000               000000         
            0x00, 0x3F, 0xC0, 0x1F, 0xE0, 0x00, ##            00000000         00000000          
            0x00, 0x0F, 0xFF, 0xFF, 0x80, 0x00, ##              000000000000000000000            
            0x00, 0x03, 0xFF, 0xFE, 0x00, 0x00, ##                00000000000000000              
            0x00, 0x00, 0x7F, 0xF0, 0x00, 0x00, ##                   00000000000                 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '215' => {    # '×'
        'width'    => 36, 
        'xoffset'  => 9, 
        'xadvance' => 54, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x10, 0x00, 0x00, 0x00, 0x80, ##     0                            0   
            0x38, 0x00, 0x00, 0x01, 0xC0, ##    000                          000  
            0x7C, 0x00, 0x00, 0x03, 0xE0, ##   00000                        00000 
            0xFE, 0x00, 0x00, 0x07, 0xF0, ##  0000000                      0000000
            0x7F, 0x00, 0x00, 0x0F, 0xE0, ##   0000000                    0000000 
            0x3F, 0x80, 0x00, 0x1F, 0xC0, ##    0000000                  0000000  
            0x1F, 0xC0, 0x00, 0x3F, 0x80, ##     0000000                0000000   
            0x0F, 0xE0, 0x00, 0x7F, 0x00, ##      0000000              0000000    
            0x07, 0xF0, 0x00, 0xFE, 0x00, ##       0000000            0000000     
            0x03, 0xF8, 0x01, 0xFC, 0x00, ##        0000000          0000000      
            0x01, 0xFC, 0x03, 0xF8, 0x00, ##         0000000        0000000       
            0x00, 0xFE, 0x07, 0xF0, 0x00, ##          0000000      0000000        
            0x00, 0x7F, 0x0F, 0xE0, 0x00, ##           0000000    0000000         
            0x00, 0x3F, 0x9F, 0xC0, 0x00, ##            0000000  0000000          
            0x00, 0x1F, 0xFF, 0x80, 0x00, ##             00000000000000           
            0x00, 0x0F, 0xFF, 0x00, 0x00, ##              000000000000            
            0x00, 0x07, 0xFE, 0x00, 0x00, ##               0000000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000              
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000              
            0x00, 0x07, 0xFE, 0x00, 0x00, ##               0000000000             
            0x00, 0x0F, 0xFF, 0x00, 0x00, ##              000000000000            
            0x00, 0x1F, 0xFF, 0x80, 0x00, ##             00000000000000           
            0x00, 0x3F, 0x9F, 0xC0, 0x00, ##            0000000  0000000          
            0x00, 0x7F, 0x0F, 0xE0, 0x00, ##           0000000    0000000         
            0x00, 0xFE, 0x07, 0xF0, 0x00, ##          0000000      0000000        
            0x01, 0xFC, 0x03, 0xF8, 0x00, ##         0000000        0000000       
            0x03, 0xF8, 0x01, 0xFC, 0x00, ##        0000000          0000000      
            0x07, 0xF0, 0x00, 0xFE, 0x00, ##       0000000            0000000     
            0x0F, 0xE0, 0x00, 0x7F, 0x00, ##      0000000              0000000    
            0x1F, 0xC0, 0x00, 0x3F, 0x80, ##     0000000                0000000   
            0x3F, 0x80, 0x00, 0x1F, 0xC0, ##    0000000                  0000000  
            0x7F, 0x00, 0x00, 0x0F, 0xE0, ##   0000000                    0000000 
            0xFE, 0x00, 0x00, 0x07, 0xF0, ##  0000000                      0000000
            0x7C, 0x00, 0x00, 0x03, 0xE0, ##   00000                        00000 
            0x38, 0x00, 0x00, 0x01, 0xC0, ##    000                          000  
            0x10, 0x00, 0x00, 0x00, 0x80, ##     0                            0   
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '216' => {    # 'Ø'
        'width'    => 45, 
        'xoffset'  => 4, 
        'xadvance' => 53, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x20, ##                                            0  
            0x00, 0x00, 0x7F, 0xF0, 0x00, 0x38, ##                   00000000000              000
            0x00, 0x03, 0xFF, 0xFE, 0x00, 0x78, ##                00000000000000000          0000
            0x00, 0x0F, 0xFF, 0xFF, 0xC0, 0xF0, ##              0000000000000000000000      0000 
            0x00, 0x3F, 0xC0, 0x1F, 0xE1, 0xE0, ##            00000000         00000000    0000  
            0x00, 0x7E, 0x00, 0x03, 0xFB, 0xC0, ##           000000               0000000 0000   
            0x01, 0xFC, 0x00, 0x01, 0xFF, 0x80, ##         0000000                 0000000000    
            0x03, 0xF8, 0x00, 0x00, 0xFF, 0x00, ##        0000000                   00000000     
            0x03, 0xF0, 0x00, 0x00, 0x7F, 0x00, ##        000000                     0000000     
            0x07, 0xE0, 0x00, 0x00, 0x3F, 0x00, ##       000000                       000000     
            0x0F, 0xC0, 0x00, 0x00, 0x7F, 0x80, ##      000000                       00000000    
            0x1F, 0xC0, 0x00, 0x00, 0xFF, 0xC0, ##     0000000                      0000000000   
            0x1F, 0x80, 0x00, 0x01, 0xFF, 0xC0, ##     000000                      00000000000   
            0x3F, 0x80, 0x00, 0x01, 0xEF, 0xE0, ##    0000000                      0000 0000000  
            0x3F, 0x00, 0x00, 0x03, 0xC7, 0xE0, ##    000000                      0000   000000  
            0x3F, 0x00, 0x00, 0x07, 0x87, 0xE0, ##    000000                     0000    000000  
            0x7F, 0x00, 0x00, 0x0F, 0x07, 0xF0, ##   0000000                    0000     0000000 
            0x7F, 0x00, 0x00, 0x1E, 0x07, 0xF0, ##   0000000                   0000      0000000 
            0x7E, 0x00, 0x00, 0x3E, 0x03, 0xF0, ##   000000                   00000       000000 
            0xFE, 0x00, 0x00, 0x7C, 0x03, 0xF8, ##  0000000                  00000        0000000
            0xFE, 0x00, 0x00, 0xF8, 0x03, 0xF8, ##  0000000                 00000         0000000
            0xFE, 0x00, 0x01, 0xF0, 0x03, 0xF8, ##  0000000                00000          0000000
            0xFE, 0x00, 0x03, 0xE0, 0x03, 0xF8, ##  0000000               00000           0000000
            0xFE, 0x00, 0x03, 0xC0, 0x03, 0xF8, ##  0000000               0000            0000000
            0xFE, 0x00, 0x07, 0x80, 0x03, 0xF8, ##  0000000              0000             0000000
            0xFE, 0x00, 0x0F, 0x00, 0x03, 0xF8, ##  0000000             0000              0000000
            0xFE, 0x00, 0x1E, 0x00, 0x03, 0xF8, ##  0000000            0000               0000000
            0xFE, 0x00, 0x3C, 0x00, 0x03, 0xF8, ##  0000000           0000                0000000
            0xFE, 0x00, 0x7C, 0x00, 0x03, 0xF8, ##  0000000          00000                0000000
            0xFE, 0x00, 0xF8, 0x00, 0x03, 0xF8, ##  0000000         00000                 0000000
            0xFE, 0x01, 0xF0, 0x00, 0x03, 0xF8, ##  0000000        00000                  0000000
            0x7E, 0x03, 0xE0, 0x00, 0x03, 0xF0, ##   000000       00000                   000000 
            0x7F, 0x07, 0xC0, 0x00, 0x07, 0xF0, ##   0000000     00000                   0000000 
            0x7F, 0x07, 0x80, 0x00, 0x07, 0xF0, ##   0000000     0000                    0000000 
            0x7F, 0x0F, 0x00, 0x00, 0x07, 0xF0, ##   0000000    0000                     0000000 
            0x3F, 0x1E, 0x00, 0x00, 0x07, 0xE0, ##    000000   0000                      000000  
            0x3F, 0xBC, 0x00, 0x00, 0x0F, 0xE0, ##    0000000 0000                      0000000  
            0x1F, 0xF8, 0x00, 0x00, 0x0F, 0xC0, ##     0000000000                       000000   
            0x1F, 0xF0, 0x00, 0x00, 0x1F, 0xC0, ##     000000000                       0000000   
            0x0F, 0xF0, 0x00, 0x00, 0x1F, 0x80, ##      00000000                       000000    
            0x0F, 0xE0, 0x00, 0x00, 0x3F, 0x00, ##      0000000                       000000     
            0x07, 0xF0, 0x00, 0x00, 0x7F, 0x00, ##       0000000                     0000000     
            0x0F, 0xF8, 0x00, 0x00, 0xFE, 0x00, ##      000000000                   0000000      
            0x1F, 0xFC, 0x00, 0x01, 0xFC, 0x00, ##     00000000000                 0000000       
            0x1E, 0xFE, 0x00, 0x03, 0xF0, 0x00, ##     0000 0000000               000000         
            0x3C, 0x3F, 0xC0, 0x1F, 0xE0, 0x00, ##    0000    00000000         00000000          
            0x78, 0x1F, 0xFF, 0xFF, 0x80, 0x00, ##   0000      0000000000000000000000            
            0xF0, 0x03, 0xFF, 0xFE, 0x00, 0x00, ##  0000          00000000000000000              
            0xE0, 0x00, 0x7F, 0xF0, 0x00, 0x00, ##  000              00000000000                 
            0x40, 0x00, 0x00, 0x00, 0x00, 0x00, ##   0                                           
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '217' => {    # 'Ù'
        'width'    => 48, 
        'xoffset'  => 3, 
        'xadvance' => 54, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x7E, 0x00, 0x00, 0x00, ##                   000000                         
            0x00, 0x00, 0x3F, 0x00, 0x00, 0x00, ##                    000000                        
            0x00, 0x00, 0x1F, 0x80, 0x00, 0x00, ##                     000000                       
            0x00, 0x00, 0x0F, 0x80, 0x00, 0x00, ##                      00000                       
            0x00, 0x00, 0x07, 0xC0, 0x00, 0x00, ##                       00000                      
            0x00, 0x00, 0x03, 0xE0, 0x00, 0x00, ##                        00000                     
            0x00, 0x00, 0x01, 0xE0, 0x00, 0x00, ##                         0000                     
            0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, ##                          0000                    
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                  
            0xFF, 0xFF, 0xC0, 0x00, 0xFF, 0xFF, ##  000000000000000000              0000000000000000
            0xFF, 0xFF, 0xC0, 0x00, 0xFF, 0xFF, ##  000000000000000000              0000000000000000
            0xFF, 0xFF, 0xC0, 0x00, 0xFF, 0xFF, ##  000000000000000000              0000000000000000
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x07, 0xC0, ##        0000000                        00000      
            0x01, 0xFC, 0x00, 0x00, 0x07, 0x80, ##         0000000                       0000       
            0x01, 0xFC, 0x00, 0x00, 0x07, 0x80, ##         0000000                       0000       
            0x01, 0xFC, 0x00, 0x00, 0x07, 0x80, ##         0000000                       0000       
            0x01, 0xFE, 0x00, 0x00, 0x0F, 0x80, ##         00000000                     00000       
            0x00, 0xFE, 0x00, 0x00, 0x0F, 0x00, ##          0000000                     0000        
            0x00, 0xFF, 0x00, 0x00, 0x1F, 0x00, ##          00000000                   00000        
            0x00, 0x7F, 0x80, 0x00, 0x3E, 0x00, ##           00000000                 00000         
            0x00, 0x7F, 0xC0, 0x00, 0x7E, 0x00, ##           000000000               000000         
            0x00, 0x3F, 0xF8, 0x03, 0xFC, 0x00, ##            00000000000         00000000          
            0x00, 0x1F, 0xFF, 0xFF, 0xF8, 0x00, ##             00000000000000000000000000           
            0x00, 0x07, 0xFF, 0xFF, 0xF0, 0x00, ##               00000000000000000000000            
            0x00, 0x01, 0xFF, 0xFF, 0xC0, 0x00, ##                 0000000000000000000              
            0x00, 0x00, 0x3F, 0xFC, 0x00, 0x00, ##                    000000000000                  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '218' => {    # 'Ú'
        'width'    => 48, 
        'xoffset'  => 3, 
        'xadvance' => 54, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x1F, 0x80, 0x00, ##                             000000               
            0x00, 0x00, 0x00, 0x3F, 0x00, 0x00, ##                            000000                
            0x00, 0x00, 0x00, 0x7C, 0x00, 0x00, ##                           00000                  
            0x00, 0x00, 0x00, 0xF8, 0x00, 0x00, ##                          00000                   
            0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, ##                          0000                    
            0x00, 0x00, 0x01, 0xE0, 0x00, 0x00, ##                         0000                     
            0x00, 0x00, 0x03, 0xC0, 0x00, 0x00, ##                        0000                      
            0x00, 0x00, 0x03, 0x80, 0x00, 0x00, ##                        000                       
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                  
            0xFF, 0xFF, 0xC0, 0x00, 0xFF, 0xFF, ##  000000000000000000              0000000000000000
            0xFF, 0xFF, 0xC0, 0x00, 0xFF, 0xFF, ##  000000000000000000              0000000000000000
            0xFF, 0xFF, 0xC0, 0x00, 0xFF, 0xFF, ##  000000000000000000              0000000000000000
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x07, 0xC0, ##        0000000                        00000      
            0x01, 0xFC, 0x00, 0x00, 0x07, 0x80, ##         0000000                       0000       
            0x01, 0xFC, 0x00, 0x00, 0x07, 0x80, ##         0000000                       0000       
            0x01, 0xFC, 0x00, 0x00, 0x07, 0x80, ##         0000000                       0000       
            0x01, 0xFE, 0x00, 0x00, 0x0F, 0x80, ##         00000000                     00000       
            0x00, 0xFE, 0x00, 0x00, 0x0F, 0x00, ##          0000000                     0000        
            0x00, 0xFF, 0x00, 0x00, 0x1F, 0x00, ##          00000000                   00000        
            0x00, 0x7F, 0x80, 0x00, 0x3E, 0x00, ##           00000000                 00000         
            0x00, 0x7F, 0xC0, 0x00, 0x7E, 0x00, ##           000000000               000000         
            0x00, 0x3F, 0xF8, 0x03, 0xFC, 0x00, ##            00000000000         00000000          
            0x00, 0x1F, 0xFF, 0xFF, 0xF8, 0x00, ##             00000000000000000000000000           
            0x00, 0x07, 0xFF, 0xFF, 0xF0, 0x00, ##               00000000000000000000000            
            0x00, 0x01, 0xFF, 0xFF, 0xC0, 0x00, ##                 0000000000000000000              
            0x00, 0x00, 0x3F, 0xFC, 0x00, 0x00, ##                    000000000000                  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '219' => {    # 'Û'
        'width'    => 48, 
        'xoffset'  => 3, 
        'xadvance' => 54, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x03, 0xF0, 0x00, 0x00, ##                        000000                    
            0x00, 0x00, 0x07, 0xF8, 0x00, 0x00, ##                       00000000                   
            0x00, 0x00, 0x0F, 0xFC, 0x00, 0x00, ##                      0000000000                  
            0x00, 0x00, 0x1F, 0x7E, 0x00, 0x00, ##                     00000 000000                 
            0x00, 0x00, 0x3E, 0x1F, 0x00, 0x00, ##                    00000    00000                
            0x00, 0x00, 0x3C, 0x0F, 0x80, 0x00, ##                    0000      00000               
            0x00, 0x00, 0x78, 0x07, 0xC0, 0x00, ##                   0000        00000              
            0x00, 0x00, 0xE0, 0x01, 0xC0, 0x00, ##                  000            000              
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                  
            0xFF, 0xFF, 0xC0, 0x00, 0xFF, 0xFF, ##  000000000000000000              0000000000000000
            0xFF, 0xFF, 0xC0, 0x00, 0xFF, 0xFF, ##  000000000000000000              0000000000000000
            0xFF, 0xFF, 0xC0, 0x00, 0xFF, 0xFF, ##  000000000000000000              0000000000000000
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x07, 0xC0, ##        0000000                        00000      
            0x01, 0xFC, 0x00, 0x00, 0x07, 0x80, ##         0000000                       0000       
            0x01, 0xFC, 0x00, 0x00, 0x07, 0x80, ##         0000000                       0000       
            0x01, 0xFC, 0x00, 0x00, 0x07, 0x80, ##         0000000                       0000       
            0x01, 0xFE, 0x00, 0x00, 0x0F, 0x80, ##         00000000                     00000       
            0x00, 0xFE, 0x00, 0x00, 0x0F, 0x00, ##          0000000                     0000        
            0x00, 0xFF, 0x00, 0x00, 0x1F, 0x00, ##          00000000                   00000        
            0x00, 0x7F, 0x80, 0x00, 0x3E, 0x00, ##           00000000                 00000         
            0x00, 0x7F, 0xC0, 0x00, 0x7E, 0x00, ##           000000000               000000         
            0x00, 0x3F, 0xF8, 0x03, 0xFC, 0x00, ##            00000000000         00000000          
            0x00, 0x1F, 0xFF, 0xFF, 0xF8, 0x00, ##             00000000000000000000000000           
            0x00, 0x07, 0xFF, 0xFF, 0xF0, 0x00, ##               00000000000000000000000            
            0x00, 0x01, 0xFF, 0xFF, 0xC0, 0x00, ##                 0000000000000000000              
            0x00, 0x00, 0x3F, 0xFC, 0x00, 0x00, ##                    000000000000                  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '220' => {    # 'Ü'
        'width'    => 48, 
        'xoffset'  => 3, 
        'xadvance' => 54, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x38, 0x03, 0x80, 0x00, ##                    000         000               
            0x00, 0x00, 0x7C, 0x07, 0xC0, 0x00, ##                   00000       00000              
            0x00, 0x00, 0xFE, 0x0F, 0xE0, 0x00, ##                  0000000     0000000             
            0x00, 0x00, 0xFE, 0x0F, 0xE0, 0x00, ##                  0000000     0000000             
            0x00, 0x00, 0xFE, 0x0F, 0xE0, 0x00, ##                  0000000     0000000             
            0x00, 0x00, 0x7C, 0x07, 0xC0, 0x00, ##                   00000       00000              
            0x00, 0x00, 0x38, 0x03, 0x80, 0x00, ##                    000         000               
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                  
            0xFF, 0xFF, 0xC0, 0x00, 0xFF, 0xFF, ##  000000000000000000              0000000000000000
            0xFF, 0xFF, 0xC0, 0x00, 0xFF, 0xFF, ##  000000000000000000              0000000000000000
            0xFF, 0xFF, 0xC0, 0x00, 0xFF, 0xFF, ##  000000000000000000              0000000000000000
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x03, 0xC0, ##        0000000                         0000      
            0x03, 0xF8, 0x00, 0x00, 0x07, 0xC0, ##        0000000                        00000      
            0x01, 0xFC, 0x00, 0x00, 0x07, 0x80, ##         0000000                       0000       
            0x01, 0xFC, 0x00, 0x00, 0x07, 0x80, ##         0000000                       0000       
            0x01, 0xFC, 0x00, 0x00, 0x07, 0x80, ##         0000000                       0000       
            0x01, 0xFE, 0x00, 0x00, 0x0F, 0x80, ##         00000000                     00000       
            0x00, 0xFE, 0x00, 0x00, 0x0F, 0x00, ##          0000000                     0000        
            0x00, 0xFF, 0x00, 0x00, 0x1F, 0x00, ##          00000000                   00000        
            0x00, 0x7F, 0x80, 0x00, 0x3E, 0x00, ##           00000000                 00000         
            0x00, 0x7F, 0xC0, 0x00, 0x7E, 0x00, ##           000000000               000000         
            0x00, 0x3F, 0xF8, 0x03, 0xFC, 0x00, ##            00000000000         00000000          
            0x00, 0x1F, 0xFF, 0xFF, 0xF8, 0x00, ##             00000000000000000000000000           
            0x00, 0x07, 0xFF, 0xFF, 0xF0, 0x00, ##               00000000000000000000000            
            0x00, 0x01, 0xFF, 0xFF, 0xC0, 0x00, ##                 0000000000000000000              
            0x00, 0x00, 0x3F, 0xFC, 0x00, 0x00, ##                    000000000000                  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '221' => {    # 'Ý'
        'width'    => 44, 
        'xoffset'  => -1, 
        'xadvance' => 43, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x01, 0xF8, 0x00, 0x00, ##                         000000               
            0x00, 0x00, 0x03, 0xF0, 0x00, 0x00, ##                        000000                
            0x00, 0x00, 0x03, 0xE0, 0x00, 0x00, ##                        00000                 
            0x00, 0x00, 0x07, 0xC0, 0x00, 0x00, ##                       00000                  
            0x00, 0x00, 0x0F, 0x80, 0x00, 0x00, ##                      00000                   
            0x00, 0x00, 0x1F, 0x00, 0x00, 0x00, ##                     00000                    
            0x00, 0x00, 0x1E, 0x00, 0x00, 0x00, ##                     0000                     
            0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, ##                    0000                      
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                              
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                              
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                              
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                              
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                              
            0xFF, 0xFF, 0x80, 0x03, 0xFF, 0xF0, ##  00000000000000000             00000000000000
            0xFF, 0xFF, 0x80, 0x03, 0xFF, 0xF0, ##  00000000000000000             00000000000000
            0xFF, 0xFF, 0x80, 0x03, 0xFF, 0xF0, ##  00000000000000000             00000000000000
            0x07, 0xF0, 0x00, 0x00, 0x1E, 0x00, ##       0000000                       0000     
            0x07, 0xF8, 0x00, 0x00, 0x3C, 0x00, ##       00000000                     0000      
            0x03, 0xFC, 0x00, 0x00, 0x3C, 0x00, ##        00000000                    0000      
            0x03, 0xFC, 0x00, 0x00, 0x78, 0x00, ##        00000000                   0000       
            0x01, 0xFE, 0x00, 0x00, 0xF8, 0x00, ##         00000000                 00000       
            0x00, 0xFE, 0x00, 0x00, 0xF0, 0x00, ##          0000000                 0000        
            0x00, 0xFF, 0x00, 0x01, 0xE0, 0x00, ##          00000000               0000         
            0x00, 0x7F, 0x80, 0x01, 0xE0, 0x00, ##           00000000              0000         
            0x00, 0x7F, 0x80, 0x03, 0xC0, 0x00, ##           00000000             0000          
            0x00, 0x3F, 0xC0, 0x07, 0x80, 0x00, ##            00000000           0000           
            0x00, 0x1F, 0xC0, 0x07, 0x80, 0x00, ##             0000000           0000           
            0x00, 0x1F, 0xE0, 0x0F, 0x00, 0x00, ##             00000000         0000            
            0x00, 0x0F, 0xF0, 0x1E, 0x00, 0x00, ##              00000000       0000             
            0x00, 0x0F, 0xF0, 0x1E, 0x00, 0x00, ##              00000000       0000             
            0x00, 0x07, 0xF8, 0x3C, 0x00, 0x00, ##               00000000     0000              
            0x00, 0x07, 0xF8, 0x7C, 0x00, 0x00, ##               00000000    00000              
            0x00, 0x03, 0xFC, 0x78, 0x00, 0x00, ##                00000000   0000               
            0x00, 0x01, 0xFC, 0xF0, 0x00, 0x00, ##                 0000000  0000                
            0x00, 0x01, 0xFE, 0xF0, 0x00, 0x00, ##                 00000000 0000                
            0x00, 0x00, 0xFF, 0xE0, 0x00, 0x00, ##                  00000000000                 
            0x00, 0x00, 0xFF, 0xC0, 0x00, 0x00, ##                  0000000000                  
            0x00, 0x00, 0x7F, 0xC0, 0x00, 0x00, ##                   000000000                  
            0x00, 0x00, 0x3F, 0x80, 0x00, 0x00, ##                    0000000                   
            0x00, 0x00, 0x3F, 0x80, 0x00, 0x00, ##                    0000000                   
            0x00, 0x00, 0x3F, 0x80, 0x00, 0x00, ##                    0000000                   
            0x00, 0x00, 0x3F, 0x80, 0x00, 0x00, ##                    0000000                   
            0x00, 0x00, 0x3F, 0x80, 0x00, 0x00, ##                    0000000                   
            0x00, 0x00, 0x3F, 0x80, 0x00, 0x00, ##                    0000000                   
            0x00, 0x00, 0x3F, 0x80, 0x00, 0x00, ##                    0000000                   
            0x00, 0x00, 0x3F, 0x80, 0x00, 0x00, ##                    0000000                   
            0x00, 0x00, 0x3F, 0x80, 0x00, 0x00, ##                    0000000                   
            0x00, 0x00, 0x3F, 0x80, 0x00, 0x00, ##                    0000000                   
            0x00, 0x00, 0x3F, 0x80, 0x00, 0x00, ##                    0000000                   
            0x00, 0x00, 0x3F, 0x80, 0x00, 0x00, ##                    0000000                   
            0x00, 0x00, 0x3F, 0x80, 0x00, 0x00, ##                    0000000                   
            0x00, 0x00, 0x3F, 0x80, 0x00, 0x00, ##                    0000000                   
            0x00, 0x00, 0x3F, 0x80, 0x00, 0x00, ##                    0000000                   
            0x00, 0x00, 0x3F, 0x80, 0x00, 0x00, ##                    0000000                   
            0x00, 0x00, 0x3F, 0x80, 0x00, 0x00, ##                    0000000                   
            0x00, 0x00, 0x3F, 0x80, 0x00, 0x00, ##                    0000000                   
            0x00, 0x07, 0xFF, 0xFE, 0x00, 0x00, ##               000000000000000000             
            0x00, 0x07, 0xFF, 0xFE, 0x00, 0x00, ##               000000000000000000             
            0x00, 0x07, 0xFF, 0xFE, 0x00, 0x00, ##               000000000000000000             
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '222' => {    # 'Þ'
        'width'    => 37, 
        'xoffset'  => 4, 
        'xadvance' => 43, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xF0, 0x00, 0x00, ##  00000000000000000000                 
            0xFF, 0xFF, 0xF0, 0x00, 0x00, ##  00000000000000000000                 
            0xFF, 0xFF, 0xF0, 0x00, 0x00, ##  00000000000000000000                 
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                        
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                        
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                        
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                        
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                        
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                        
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                        
            0x03, 0xFF, 0xFF, 0xE0, 0x00, ##        000000000000000000000          
            0x03, 0xFF, 0xFF, 0xFC, 0x00, ##        000000000000000000000000       
            0x03, 0xFF, 0xFF, 0xFF, 0x00, ##        00000000000000000000000000     
            0x03, 0xF8, 0x00, 0xFF, 0x80, ##        0000000           000000000    
            0x03, 0xF8, 0x00, 0x3F, 0xC0, ##        0000000             00000000   
            0x03, 0xF8, 0x00, 0x0F, 0xE0, ##        0000000               0000000  
            0x03, 0xF8, 0x00, 0x0F, 0xE0, ##        0000000               0000000  
            0x03, 0xF8, 0x00, 0x07, 0xF0, ##        0000000                0000000 
            0x03, 0xF8, 0x00, 0x07, 0xF0, ##        0000000                0000000 
            0x03, 0xF8, 0x00, 0x03, 0xF8, ##        0000000                 0000000
            0x03, 0xF8, 0x00, 0x03, 0xF8, ##        0000000                 0000000
            0x03, 0xF8, 0x00, 0x03, 0xF8, ##        0000000                 0000000
            0x03, 0xF8, 0x00, 0x03, 0xF8, ##        0000000                 0000000
            0x03, 0xF8, 0x00, 0x03, 0xF8, ##        0000000                 0000000
            0x03, 0xF8, 0x00, 0x03, 0xF8, ##        0000000                 0000000
            0x03, 0xF8, 0x00, 0x03, 0xF8, ##        0000000                 0000000
            0x03, 0xF8, 0x00, 0x03, 0xF8, ##        0000000                 0000000
            0x03, 0xF8, 0x00, 0x07, 0xF0, ##        0000000                0000000 
            0x03, 0xF8, 0x00, 0x07, 0xF0, ##        0000000                0000000 
            0x03, 0xF8, 0x00, 0x0F, 0xE0, ##        0000000               0000000  
            0x03, 0xF8, 0x00, 0x0F, 0xE0, ##        0000000               0000000  
            0x03, 0xF8, 0x00, 0x3F, 0xC0, ##        0000000             00000000   
            0x03, 0xF8, 0x00, 0xFF, 0x80, ##        0000000           000000000    
            0x03, 0xFF, 0xFF, 0xFF, 0x00, ##        00000000000000000000000000     
            0x03, 0xFF, 0xFF, 0xFC, 0x00, ##        000000000000000000000000       
            0x03, 0xFF, 0xFF, 0xE0, 0x00, ##        000000000000000000000          
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                        
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                        
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                        
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                        
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                        
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                        
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                        
            0xFF, 0xFF, 0xF0, 0x00, 0x00, ##  00000000000000000000                 
            0xFF, 0xFF, 0xF0, 0x00, 0x00, ##  00000000000000000000                 
            0xFF, 0xFF, 0xF0, 0x00, 0x00, ##  00000000000000000000                 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '223' => {    # 'ß'
        'width'    => 38, 
        'xoffset'  => 2, 
        'xadvance' => 43, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x03, 0xFF, 0x00, 0x00, ##                0000000000              
            0x00, 0x1F, 0xFF, 0xE0, 0x00, ##             0000000000000000           
            0x00, 0x7F, 0xFF, 0xF0, 0x00, ##           0000000000000000000          
            0x00, 0xFE, 0x03, 0xFC, 0x00, ##          0000000       00000000        
            0x01, 0xF8, 0x00, 0xFE, 0x00, ##         000000           0000000       
            0x03, 0xF0, 0x00, 0x7E, 0x00, ##        000000             000000       
            0x03, 0xF0, 0x00, 0x3F, 0x00, ##        000000              000000      
            0x03, 0xF0, 0x00, 0x3F, 0x00, ##        000000              000000      
            0x07, 0xE0, 0x00, 0x1F, 0x00, ##       000000                00000      
            0x07, 0xE0, 0x00, 0x1F, 0x80, ##       000000                000000     
            0x07, 0xE0, 0x00, 0x1F, 0x80, ##       000000                000000     
            0x07, 0xE0, 0x00, 0xFF, 0x80, ##       000000             000000000     
            0x07, 0xE0, 0x03, 0xFF, 0x80, ##       000000           00000000000     
            0x07, 0xE0, 0x0F, 0xF0, 0x00, ##       000000         00000000          
            0x07, 0xE0, 0x1F, 0x80, 0x00, ##       000000        000000             
            0x07, 0xE0, 0x3F, 0x00, 0x00, ##       000000       000000              
            0x07, 0xE0, 0x3E, 0x00, 0x00, ##       000000       00000               
            0x07, 0xE0, 0x7C, 0x00, 0x00, ##       000000      00000                
            0x07, 0xE0, 0x7C, 0x00, 0x00, ##       000000      00000                
            0x07, 0xE0, 0x7C, 0x00, 0x00, ##       000000      00000                
            0x07, 0xE0, 0x7C, 0x00, 0x00, ##       000000      00000                
            0x07, 0xE0, 0x7E, 0x00, 0x00, ##       000000      000000               
            0x07, 0xE0, 0x7E, 0x00, 0x00, ##       000000      000000               
            0x07, 0xE0, 0x3F, 0x00, 0x00, ##       000000       000000              
            0x07, 0xE0, 0x3F, 0xC0, 0x00, ##       000000       00000000            
            0x07, 0xE0, 0x1F, 0xF0, 0x00, ##       000000        000000000          
            0x07, 0xE0, 0x0F, 0xF8, 0x00, ##       000000         000000000         
            0x07, 0xE0, 0x07, 0xFE, 0x00, ##       000000          0000000000       
            0x07, 0xE0, 0x03, 0xFF, 0x00, ##       000000           0000000000      
            0x07, 0xE0, 0x00, 0xFF, 0xC0, ##       000000             0000000000    
            0x07, 0xE0, 0x00, 0x3F, 0xE0, ##       000000               000000000   
            0x07, 0xE0, 0x00, 0x1F, 0xF0, ##       000000                000000000  
            0x07, 0xE0, 0x00, 0x07, 0xF0, ##       000000                  0000000  
            0x07, 0xE0, 0x00, 0x03, 0xF8, ##       000000                   0000000 
            0x07, 0xE0, 0x00, 0x01, 0xF8, ##       000000                    000000 
            0x07, 0xE0, 0x00, 0x01, 0xFC, ##       000000                    0000000
            0x07, 0xE0, 0x00, 0x00, 0xFC, ##       000000                     000000
            0x07, 0xE0, 0x00, 0x00, 0xFC, ##       000000                     000000
            0x07, 0xE0, 0x00, 0x00, 0xFC, ##       000000                     000000
            0x07, 0xE0, 0x00, 0x00, 0xFC, ##       000000                     000000
            0x07, 0xE3, 0x80, 0x00, 0xFC, ##       000000   000               000000
            0x07, 0xE3, 0x80, 0x00, 0xF8, ##       000000   000               00000 
            0x07, 0xE3, 0x80, 0x01, 0xF8, ##       000000   000              000000 
            0x07, 0xE3, 0xC0, 0x03, 0xF8, ##       000000   0000            0000000 
            0x07, 0xE3, 0xE0, 0x07, 0xF0, ##       000000   00000          0000000  
            0xFF, 0xE3, 0xF8, 0x1F, 0xE0, ##  00000000000   0000000      00000000   
            0xFF, 0xE3, 0xFF, 0xFF, 0xC0, ##  00000000000   00000000000000000000    
            0xFF, 0xE0, 0xFF, 0xFF, 0x00, ##  00000000000     0000000000000000      
            0x00, 0x00, 0x0F, 0xF8, 0x00, ##                      000000000         
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '224' => {    # 'à'
        'width'    => 33, 
        'xoffset'  => 3, 
        'xadvance' => 38, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                      
            0x03, 0xE0, 0x00, 0x00, 0x00, ##        00000                      
            0x03, 0xF0, 0x00, 0x00, 0x00, ##        000000                     
            0x01, 0xF8, 0x00, 0x00, 0x00, ##         000000                    
            0x00, 0xF8, 0x00, 0x00, 0x00, ##          00000                    
            0x00, 0x7C, 0x00, 0x00, 0x00, ##           00000                   
            0x00, 0x3E, 0x00, 0x00, 0x00, ##            00000                  
            0x00, 0x1E, 0x00, 0x00, 0x00, ##             0000                  
            0x00, 0x0F, 0x00, 0x00, 0x00, ##              0000                 
            0x00, 0x07, 0x80, 0x00, 0x00, ##               0000                
            0x00, 0x03, 0x80, 0x00, 0x00, ##                000                
            0x00, 0x03, 0xC0, 0x00, 0x00, ##                0000               
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x00, 0x7F, 0xE0, 0x00, 0x00, ##           0000000000              
            0x07, 0xFF, 0xFC, 0x00, 0x00, ##       00000000000000000           
            0x1F, 0xFF, 0xFE, 0x00, 0x00, ##     00000000000000000000          
            0x1F, 0xC0, 0x7F, 0x00, 0x00, ##     0000000       0000000         
            0x1F, 0x00, 0x1F, 0x80, 0x00, ##     00000           000000        
            0x1E, 0x00, 0x0F, 0xC0, 0x00, ##     0000             000000       
            0x1E, 0x00, 0x07, 0xE0, 0x00, ##     0000              000000      
            0x1C, 0x00, 0x07, 0xE0, 0x00, ##     000               000000      
            0x1C, 0x00, 0x03, 0xE0, 0x00, ##     000                00000      
            0x00, 0x00, 0x03, 0xF0, 0x00, ##                        000000     
            0x00, 0x00, 0x03, 0xF0, 0x00, ##                        000000     
            0x00, 0x00, 0x03, 0xF0, 0x00, ##                        000000     
            0x00, 0x00, 0x03, 0xF0, 0x00, ##                        000000     
            0x00, 0x00, 0x03, 0xF0, 0x00, ##                        000000     
            0x00, 0x7F, 0xFF, 0xF0, 0x00, ##           0000000000000000000     
            0x03, 0xFF, 0xFF, 0xF0, 0x00, ##        0000000000000000000000     
            0x0F, 0xFF, 0xFF, 0xF0, 0x00, ##      000000000000000000000000     
            0x1F, 0xE0, 0x03, 0xF0, 0x00, ##     00000000           000000     
            0x3F, 0x80, 0x03, 0xF0, 0x00, ##    0000000             000000     
            0x7F, 0x00, 0x03, 0xF0, 0x00, ##   0000000              000000     
            0x7F, 0x00, 0x03, 0xF0, 0x00, ##   0000000              000000     
            0xFE, 0x00, 0x03, 0xF0, 0x00, ##  0000000               000000     
            0xFE, 0x00, 0x03, 0xF0, 0x00, ##  0000000               000000     
            0xFE, 0x00, 0x03, 0xF0, 0x00, ##  0000000               000000     
            0xFE, 0x00, 0x03, 0xF0, 0x00, ##  0000000               000000     
            0xFE, 0x00, 0x03, 0xF0, 0x00, ##  0000000               000000     
            0xFE, 0x00, 0x03, 0xF0, 0x00, ##  0000000               000000     
            0xFE, 0x00, 0x07, 0xF0, 0x00, ##  0000000              0000000     
            0x7F, 0x00, 0x07, 0xF0, 0x00, ##   0000000             0000000     
            0x7F, 0x80, 0x0F, 0xF0, 0x00, ##   00000000           00000000     
            0x3F, 0xC0, 0x1F, 0xF0, 0x00, ##    00000000         000000000     
            0x3F, 0xE0, 0x7B, 0xFF, 0x80, ##    000000000      0000 00000000000
            0x0F, 0xFF, 0xF3, 0xFF, 0x80, ##      0000000000000000  00000000000
            0x07, 0xFF, 0xE3, 0xFF, 0x80, ##       00000000000000   00000000000
            0x00, 0xFF, 0x00, 0x00, 0x00, ##          00000000                 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '225' => {    # 'á'
        'width'    => 33, 
        'xoffset'  => 3, 
        'xadvance' => 38, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x1F, 0x80, 0x00, ##                     000000        
            0x00, 0x00, 0x3F, 0x00, 0x00, ##                    000000         
            0x00, 0x00, 0x7E, 0x00, 0x00, ##                   000000          
            0x00, 0x00, 0x7C, 0x00, 0x00, ##                   00000           
            0x00, 0x00, 0xF8, 0x00, 0x00, ##                  00000            
            0x00, 0x01, 0xF0, 0x00, 0x00, ##                 00000             
            0x00, 0x01, 0xE0, 0x00, 0x00, ##                 0000              
            0x00, 0x03, 0xE0, 0x00, 0x00, ##                00000              
            0x00, 0x07, 0xC0, 0x00, 0x00, ##               00000               
            0x00, 0x07, 0x80, 0x00, 0x00, ##               0000                
            0x00, 0x0F, 0x00, 0x00, 0x00, ##              0000                 
            0x00, 0x0E, 0x00, 0x00, 0x00, ##              000                  
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x00, 0x7F, 0xE0, 0x00, 0x00, ##           0000000000              
            0x07, 0xFF, 0xFC, 0x00, 0x00, ##       00000000000000000           
            0x1F, 0xFF, 0xFE, 0x00, 0x00, ##     00000000000000000000          
            0x1F, 0xE0, 0x7F, 0x00, 0x00, ##     00000000      0000000         
            0x1F, 0x80, 0x1F, 0x80, 0x00, ##     000000          000000        
            0x1F, 0x00, 0x0F, 0xC0, 0x00, ##     00000            000000       
            0x1E, 0x00, 0x07, 0xE0, 0x00, ##     0000              000000      
            0x1E, 0x00, 0x07, 0xE0, 0x00, ##     0000              000000      
            0x1C, 0x00, 0x03, 0xE0, 0x00, ##     000                00000      
            0x1C, 0x00, 0x03, 0xF0, 0x00, ##     000                000000     
            0x00, 0x00, 0x03, 0xF0, 0x00, ##                        000000     
            0x00, 0x00, 0x03, 0xF0, 0x00, ##                        000000     
            0x00, 0x00, 0x03, 0xF0, 0x00, ##                        000000     
            0x00, 0x00, 0x03, 0xF0, 0x00, ##                        000000     
            0x00, 0x7F, 0xFF, 0xF0, 0x00, ##           0000000000000000000     
            0x03, 0xFF, 0xFF, 0xF0, 0x00, ##        0000000000000000000000     
            0x0F, 0xFF, 0xFF, 0xF0, 0x00, ##      000000000000000000000000     
            0x1F, 0xE0, 0x03, 0xF0, 0x00, ##     00000000           000000     
            0x3F, 0x80, 0x03, 0xF0, 0x00, ##    0000000             000000     
            0x7F, 0x00, 0x03, 0xF0, 0x00, ##   0000000              000000     
            0x7F, 0x00, 0x03, 0xF0, 0x00, ##   0000000              000000     
            0xFE, 0x00, 0x03, 0xF0, 0x00, ##  0000000               000000     
            0xFE, 0x00, 0x03, 0xF0, 0x00, ##  0000000               000000     
            0xFE, 0x00, 0x03, 0xF0, 0x00, ##  0000000               000000     
            0xFE, 0x00, 0x03, 0xF0, 0x00, ##  0000000               000000     
            0xFE, 0x00, 0x03, 0xF0, 0x00, ##  0000000               000000     
            0xFE, 0x00, 0x03, 0xF0, 0x00, ##  0000000               000000     
            0xFE, 0x00, 0x07, 0xF0, 0x00, ##  0000000              0000000     
            0x7F, 0x00, 0x07, 0xF0, 0x00, ##   0000000             0000000     
            0x7F, 0x80, 0x0F, 0xF0, 0x00, ##   00000000           00000000     
            0x3F, 0xC0, 0x1F, 0xF0, 0x00, ##    00000000         000000000     
            0x3F, 0xE0, 0x7B, 0xFF, 0x80, ##    000000000      0000 00000000000
            0x0F, 0xFF, 0xF3, 0xFF, 0x80, ##      0000000000000000  00000000000
            0x07, 0xFF, 0xE3, 0xFF, 0x80, ##       00000000000000   00000000000
            0x00, 0xFF, 0x00, 0x00, 0x00, ##          00000000                 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '226' => {    # 'â'
        'width'    => 33, 
        'xoffset'  => 3, 
        'xadvance' => 38, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x0F, 0xC0, 0x00, 0x00, ##              000000               
            0x00, 0x1F, 0xC0, 0x00, 0x00, ##             0000000               
            0x00, 0x1F, 0xE0, 0x00, 0x00, ##             00000000              
            0x00, 0x3F, 0xE0, 0x00, 0x00, ##            000000000              
            0x00, 0x3D, 0xF0, 0x00, 0x00, ##            0000 00000             
            0x00, 0x78, 0xF0, 0x00, 0x00, ##           0000   0000             
            0x00, 0xF8, 0x78, 0x00, 0x00, ##          00000    0000            
            0x00, 0xF0, 0x7C, 0x00, 0x00, ##          0000     00000           
            0x01, 0xE0, 0x3C, 0x00, 0x00, ##         0000       0000           
            0x01, 0xE0, 0x1E, 0x00, 0x00, ##         0000        0000          
            0x03, 0xC0, 0x0E, 0x00, 0x00, ##        0000          000          
            0x07, 0x80, 0x0F, 0x00, 0x00, ##       0000           0000         
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x00, 0x7F, 0xE0, 0x00, 0x00, ##           0000000000              
            0x07, 0xFF, 0xFC, 0x00, 0x00, ##       00000000000000000           
            0x1F, 0xFF, 0xFE, 0x00, 0x00, ##     00000000000000000000          
            0x1F, 0xE0, 0x7F, 0x00, 0x00, ##     00000000      0000000         
            0x1F, 0x80, 0x1F, 0x80, 0x00, ##     000000          000000        
            0x1F, 0x00, 0x0F, 0xC0, 0x00, ##     00000            000000       
            0x1E, 0x00, 0x07, 0xE0, 0x00, ##     0000              000000      
            0x1E, 0x00, 0x07, 0xE0, 0x00, ##     0000              000000      
            0x1C, 0x00, 0x03, 0xE0, 0x00, ##     000                00000      
            0x1C, 0x00, 0x03, 0xF0, 0x00, ##     000                000000     
            0x00, 0x00, 0x03, 0xF0, 0x00, ##                        000000     
            0x00, 0x00, 0x03, 0xF0, 0x00, ##                        000000     
            0x00, 0x00, 0x03, 0xF0, 0x00, ##                        000000     
            0x00, 0x00, 0x03, 0xF0, 0x00, ##                        000000     
            0x00, 0x7F, 0xFF, 0xF0, 0x00, ##           0000000000000000000     
            0x03, 0xFF, 0xFF, 0xF0, 0x00, ##        0000000000000000000000     
            0x0F, 0xFF, 0xFF, 0xF0, 0x00, ##      000000000000000000000000     
            0x1F, 0xE0, 0x03, 0xF0, 0x00, ##     00000000           000000     
            0x3F, 0x80, 0x03, 0xF0, 0x00, ##    0000000             000000     
            0x7F, 0x00, 0x03, 0xF0, 0x00, ##   0000000              000000     
            0x7F, 0x00, 0x03, 0xF0, 0x00, ##   0000000              000000     
            0xFE, 0x00, 0x03, 0xF0, 0x00, ##  0000000               000000     
            0xFE, 0x00, 0x03, 0xF0, 0x00, ##  0000000               000000     
            0xFE, 0x00, 0x03, 0xF0, 0x00, ##  0000000               000000     
            0xFE, 0x00, 0x03, 0xF0, 0x00, ##  0000000               000000     
            0xFE, 0x00, 0x03, 0xF0, 0x00, ##  0000000               000000     
            0xFE, 0x00, 0x03, 0xF0, 0x00, ##  0000000               000000     
            0xFE, 0x00, 0x07, 0xF0, 0x00, ##  0000000              0000000     
            0x7F, 0x00, 0x07, 0xF0, 0x00, ##   0000000             0000000     
            0x7F, 0x80, 0x0F, 0xF0, 0x00, ##   00000000           00000000     
            0x3F, 0xC0, 0x1F, 0xF0, 0x00, ##    00000000         000000000     
            0x3F, 0xE0, 0x7B, 0xFF, 0x80, ##    000000000      0000 00000000000
            0x0F, 0xFF, 0xF3, 0xFF, 0x80, ##      0000000000000000  00000000000
            0x07, 0xFF, 0xE3, 0xFF, 0x80, ##       00000000000000   00000000000
            0x00, 0xFF, 0x00, 0x00, 0x00, ##          00000000                 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '227' => {    # 'ã'
        'width'    => 33, 
        'xoffset'  => 3, 
        'xadvance' => 38, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0xF8, 0x03, 0x80, 0x00, ##          00000         000        
            0x03, 0xFE, 0x03, 0x80, 0x00, ##        000000000       000        
            0x07, 0xFF, 0x07, 0x80, 0x00, ##       00000000000     0000        
            0x07, 0xFF, 0x87, 0x80, 0x00, ##       000000000000    0000        
            0x0F, 0x0F, 0xFF, 0x00, 0x00, ##      0000    000000000000         
            0x0E, 0x07, 0xFF, 0x00, 0x00, ##      000      00000000000         
            0x0E, 0x03, 0xFE, 0x00, 0x00, ##      000       000000000          
            0x0E, 0x00, 0xF8, 0x00, 0x00, ##      000         00000            
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x00, 0x7F, 0xE0, 0x00, 0x00, ##           0000000000              
            0x07, 0xFF, 0xF8, 0x00, 0x00, ##       0000000000000000            
            0x3F, 0xFF, 0xFE, 0x00, 0x00, ##    000000000000000000000          
            0x3F, 0xC0, 0x7F, 0x00, 0x00, ##    00000000       0000000         
            0x3F, 0x00, 0x1F, 0x80, 0x00, ##    000000           000000        
            0x3E, 0x00, 0x0F, 0xC0, 0x00, ##    00000             000000       
            0x3E, 0x00, 0x07, 0xE0, 0x00, ##    00000              000000      
            0x3C, 0x00, 0x07, 0xE0, 0x00, ##    0000               000000      
            0x3C, 0x00, 0x03, 0xE0, 0x00, ##    0000                00000      
            0x3C, 0x00, 0x03, 0xF0, 0x00, ##    0000                000000     
            0x00, 0x00, 0x03, 0xF0, 0x00, ##                        000000     
            0x00, 0x00, 0x03, 0xF0, 0x00, ##                        000000     
            0x00, 0x00, 0x03, 0xF0, 0x00, ##                        000000     
            0x00, 0x00, 0x03, 0xF0, 0x00, ##                        000000     
            0x00, 0x7F, 0xFF, 0xF0, 0x00, ##           0000000000000000000     
            0x03, 0xFF, 0xFF, 0xF0, 0x00, ##        0000000000000000000000     
            0x0F, 0xFF, 0xFF, 0xF0, 0x00, ##      000000000000000000000000     
            0x1F, 0xE0, 0x03, 0xF0, 0x00, ##     00000000           000000     
            0x3F, 0x80, 0x03, 0xF0, 0x00, ##    0000000             000000     
            0x7F, 0x00, 0x03, 0xF0, 0x00, ##   0000000              000000     
            0x7F, 0x00, 0x03, 0xF0, 0x00, ##   0000000              000000     
            0xFE, 0x00, 0x03, 0xF0, 0x00, ##  0000000               000000     
            0xFE, 0x00, 0x03, 0xF0, 0x00, ##  0000000               000000     
            0xFE, 0x00, 0x03, 0xF0, 0x00, ##  0000000               000000     
            0xFE, 0x00, 0x03, 0xF0, 0x00, ##  0000000               000000     
            0xFE, 0x00, 0x03, 0xF0, 0x00, ##  0000000               000000     
            0xFE, 0x00, 0x03, 0xF0, 0x00, ##  0000000               000000     
            0xFE, 0x00, 0x07, 0xF0, 0x00, ##  0000000              0000000     
            0x7F, 0x00, 0x07, 0xF0, 0x00, ##   0000000             0000000     
            0x7F, 0x80, 0x0F, 0xF0, 0x00, ##   00000000           00000000     
            0x3F, 0xC0, 0x1F, 0xF0, 0x00, ##    00000000         000000000     
            0x3F, 0xE0, 0x7B, 0xFF, 0x80, ##    000000000      0000 00000000000
            0x0F, 0xFF, 0xF3, 0xFF, 0x80, ##      0000000000000000  00000000000
            0x07, 0xFF, 0xE3, 0xFF, 0x80, ##       00000000000000   00000000000
            0x00, 0xFF, 0x00, 0x00, 0x00, ##          00000000                 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '228' => {    # 'ä'
        'width'    => 33, 
        'xoffset'  => 3, 
        'xadvance' => 38, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x01, 0xC0, 0x1C, 0x00, 0x00, ##         000         000           
            0x03, 0xE0, 0x3E, 0x00, 0x00, ##        00000       00000          
            0x07, 0xF0, 0x7F, 0x00, 0x00, ##       0000000     0000000         
            0x07, 0xF0, 0x7F, 0x00, 0x00, ##       0000000     0000000         
            0x07, 0xF0, 0x7F, 0x00, 0x00, ##       0000000     0000000         
            0x03, 0xE0, 0x3E, 0x00, 0x00, ##        00000       00000          
            0x01, 0xC0, 0x1C, 0x00, 0x00, ##         000         000           
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x00, 0x7F, 0xE0, 0x00, 0x00, ##           0000000000              
            0x07, 0xFF, 0xFC, 0x00, 0x00, ##       00000000000000000           
            0x1F, 0xFF, 0xFE, 0x00, 0x00, ##     00000000000000000000          
            0x1F, 0xC0, 0x7F, 0x00, 0x00, ##     0000000       0000000         
            0x1F, 0x80, 0x1F, 0x80, 0x00, ##     000000          000000        
            0x1F, 0x00, 0x0F, 0xC0, 0x00, ##     00000            000000       
            0x1E, 0x00, 0x07, 0xE0, 0x00, ##     0000              000000      
            0x1C, 0x00, 0x07, 0xE0, 0x00, ##     000               000000      
            0x1C, 0x00, 0x03, 0xE0, 0x00, ##     000                00000      
            0x1C, 0x00, 0x03, 0xF0, 0x00, ##     000                000000     
            0x00, 0x00, 0x03, 0xF0, 0x00, ##                        000000     
            0x00, 0x00, 0x03, 0xF0, 0x00, ##                        000000     
            0x00, 0x00, 0x03, 0xF0, 0x00, ##                        000000     
            0x00, 0x00, 0x03, 0xF0, 0x00, ##                        000000     
            0x00, 0x7F, 0xFF, 0xF0, 0x00, ##           0000000000000000000     
            0x03, 0xFF, 0xFF, 0xF0, 0x00, ##        0000000000000000000000     
            0x0F, 0xFF, 0xFF, 0xF0, 0x00, ##      000000000000000000000000     
            0x1F, 0xE0, 0x03, 0xF0, 0x00, ##     00000000           000000     
            0x3F, 0x80, 0x03, 0xF0, 0x00, ##    0000000             000000     
            0x7F, 0x00, 0x03, 0xF0, 0x00, ##   0000000              000000     
            0x7F, 0x00, 0x03, 0xF0, 0x00, ##   0000000              000000     
            0xFE, 0x00, 0x03, 0xF0, 0x00, ##  0000000               000000     
            0xFE, 0x00, 0x03, 0xF0, 0x00, ##  0000000               000000     
            0xFE, 0x00, 0x03, 0xF0, 0x00, ##  0000000               000000     
            0xFE, 0x00, 0x03, 0xF0, 0x00, ##  0000000               000000     
            0xFE, 0x00, 0x03, 0xF0, 0x00, ##  0000000               000000     
            0xFE, 0x00, 0x03, 0xF0, 0x00, ##  0000000               000000     
            0xFE, 0x00, 0x07, 0xF0, 0x00, ##  0000000              0000000     
            0x7F, 0x00, 0x07, 0xF0, 0x00, ##   0000000             0000000     
            0x7F, 0x80, 0x0F, 0xF0, 0x00, ##   00000000           00000000     
            0x3F, 0xC0, 0x1F, 0xF0, 0x00, ##    00000000         000000000     
            0x3F, 0xE0, 0x7B, 0xFF, 0x80, ##    000000000      0000 00000000000
            0x0F, 0xFF, 0xF3, 0xFF, 0x80, ##      0000000000000000  00000000000
            0x07, 0xFF, 0xE3, 0xFF, 0x80, ##       00000000000000   00000000000
            0x00, 0xFF, 0x00, 0x00, 0x00, ##          00000000                 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '229' => {    # 'å'
        'width'    => 33, 
        'xoffset'  => 3, 
        'xadvance' => 38, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x0F, 0x80, 0x00, 0x00, ##              00000                
            0x00, 0x3F, 0xE0, 0x00, 0x00, ##            000000000              
            0x00, 0xFF, 0xF8, 0x00, 0x00, ##          0000000000000            
            0x00, 0xFF, 0xF8, 0x00, 0x00, ##          0000000000000            
            0x01, 0xF0, 0x7C, 0x00, 0x00, ##         00000     00000           
            0x03, 0xE0, 0x3C, 0x00, 0x00, ##        00000       0000           
            0x03, 0xC0, 0x1E, 0x00, 0x00, ##        0000         0000          
            0x03, 0xC0, 0x1E, 0x00, 0x00, ##        0000         0000          
            0x03, 0xC0, 0x1E, 0x00, 0x00, ##        0000         0000          
            0x03, 0xC0, 0x1E, 0x00, 0x00, ##        0000         0000          
            0x03, 0xC0, 0x1E, 0x00, 0x00, ##        0000         0000          
            0x03, 0xE0, 0x3C, 0x00, 0x00, ##        00000       0000           
            0x01, 0xF0, 0x7C, 0x00, 0x00, ##         00000     00000           
            0x00, 0xFF, 0xF8, 0x00, 0x00, ##          0000000000000            
            0x00, 0xFF, 0xF8, 0x00, 0x00, ##          0000000000000            
            0x00, 0x3F, 0xE0, 0x00, 0x00, ##            000000000              
            0x00, 0x0F, 0x80, 0x00, 0x00, ##              00000                
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x00, 0x7F, 0xE0, 0x00, 0x00, ##           0000000000              
            0x07, 0xFF, 0xFC, 0x00, 0x00, ##       00000000000000000           
            0x1F, 0xFF, 0xFE, 0x00, 0x00, ##     00000000000000000000          
            0x1F, 0xC0, 0x7F, 0x00, 0x00, ##     0000000       0000000         
            0x1F, 0x00, 0x1F, 0x80, 0x00, ##     00000           000000        
            0x1E, 0x00, 0x0F, 0xC0, 0x00, ##     0000             000000       
            0x1E, 0x00, 0x07, 0xE0, 0x00, ##     0000              000000      
            0x1C, 0x00, 0x07, 0xE0, 0x00, ##     000               000000      
            0x1C, 0x00, 0x03, 0xE0, 0x00, ##     000                00000      
            0x1C, 0x00, 0x03, 0xF0, 0x00, ##     000                000000     
            0x00, 0x00, 0x03, 0xF0, 0x00, ##                        000000     
            0x00, 0x00, 0x03, 0xF0, 0x00, ##                        000000     
            0x00, 0x00, 0x03, 0xF0, 0x00, ##                        000000     
            0x00, 0x00, 0x03, 0xF0, 0x00, ##                        000000     
            0x00, 0x7F, 0xFF, 0xF0, 0x00, ##           0000000000000000000     
            0x03, 0xFF, 0xFF, 0xF0, 0x00, ##        0000000000000000000000     
            0x0F, 0xFF, 0xFF, 0xF0, 0x00, ##      000000000000000000000000     
            0x1F, 0xE0, 0x03, 0xF0, 0x00, ##     00000000           000000     
            0x3F, 0x80, 0x03, 0xF0, 0x00, ##    0000000             000000     
            0x7F, 0x00, 0x03, 0xF0, 0x00, ##   0000000              000000     
            0x7F, 0x00, 0x03, 0xF0, 0x00, ##   0000000              000000     
            0xFE, 0x00, 0x03, 0xF0, 0x00, ##  0000000               000000     
            0xFE, 0x00, 0x03, 0xF0, 0x00, ##  0000000               000000     
            0xFE, 0x00, 0x03, 0xF0, 0x00, ##  0000000               000000     
            0xFE, 0x00, 0x03, 0xF0, 0x00, ##  0000000               000000     
            0xFE, 0x00, 0x03, 0xF0, 0x00, ##  0000000               000000     
            0xFE, 0x00, 0x03, 0xF0, 0x00, ##  0000000               000000     
            0xFE, 0x00, 0x07, 0xF0, 0x00, ##  0000000              0000000     
            0x7F, 0x00, 0x07, 0xF0, 0x00, ##   0000000             0000000     
            0x7F, 0x80, 0x0F, 0xF0, 0x00, ##   00000000           00000000     
            0x3F, 0xC0, 0x1F, 0xF0, 0x00, ##    00000000         000000000     
            0x3F, 0xE0, 0x7B, 0xFF, 0x80, ##    000000000      0000 00000000000
            0x0F, 0xFF, 0xF3, 0xFF, 0x80, ##      0000000000000000  00000000000
            0x07, 0xFF, 0xE3, 0xFF, 0x80, ##       00000000000000   00000000000
            0x00, 0xFF, 0x00, 0x00, 0x00, ##          00000000                 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '230' => {    # 'æ'
        'width'    => 54, 
        'xoffset'  => 3, 
        'xadvance' => 60, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x7F, 0xE0, 0x00, 0x3F, 0xE0, 0x00, ##           0000000000               000000000           
            0x07, 0xFF, 0xFC, 0x01, 0xFF, 0xFC, 0x00, ##       00000000000000000         000000000000000        
            0x1F, 0xFF, 0xFE, 0x07, 0xFF, 0xFE, 0x00, ##     00000000000000000000      000000000000000000       
            0x1F, 0xE0, 0x7F, 0x0F, 0xE0, 0x7F, 0x80, ##     00000000      0000000    0000000      00000000     
            0x1F, 0x80, 0x1F, 0x9F, 0x80, 0x1F, 0xC0, ##     000000          000000  000000          0000000    
            0x1F, 0x00, 0x0F, 0xFF, 0x00, 0x0F, 0xE0, ##     00000            000000000000            0000000   
            0x1E, 0x00, 0x07, 0xFE, 0x00, 0x07, 0xE0, ##     0000              0000000000              000000   
            0x1E, 0x00, 0x07, 0xFE, 0x00, 0x03, 0xF0, ##     0000              0000000000               000000  
            0x1C, 0x00, 0x03, 0xFC, 0x00, 0x03, 0xF0, ##     000                00000000                000000  
            0x1C, 0x00, 0x03, 0xFC, 0x00, 0x03, 0xF8, ##     000                00000000                0000000 
            0x00, 0x00, 0x03, 0xFC, 0x00, 0x01, 0xF8, ##                        00000000                 000000 
            0x00, 0x00, 0x03, 0xF8, 0x00, 0x01, 0xF8, ##                        0000000                  000000 
            0x00, 0x00, 0x03, 0xF8, 0x00, 0x01, 0xF8, ##                        0000000                  000000 
            0x00, 0x00, 0x03, 0xF8, 0x00, 0x01, 0xFC, ##                        0000000                  0000000
            0x00, 0x7F, 0xFF, 0xF8, 0x00, 0x01, 0xFC, ##           00000000000000000000                  0000000
            0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##        000000000000000000000000000000000000000000000000
            0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##      00000000000000000000000000000000000000000000000000
            0x1F, 0xE0, 0x03, 0xFF, 0xFF, 0xFF, 0xFC, ##     00000000           00000000000000000000000000000000
            0x3F, 0x80, 0x03, 0xF8, 0x00, 0x00, 0x00, ##    0000000             0000000                         
            0x7F, 0x00, 0x03, 0xF8, 0x00, 0x00, 0x00, ##   0000000              0000000                         
            0x7F, 0x00, 0x03, 0xF8, 0x00, 0x00, 0x00, ##   0000000              0000000                         
            0xFE, 0x00, 0x03, 0xF8, 0x00, 0x00, 0x00, ##  0000000               0000000                         
            0xFE, 0x00, 0x03, 0xF8, 0x00, 0x00, 0x00, ##  0000000               0000000                         
            0xFE, 0x00, 0x03, 0xF8, 0x00, 0x00, 0x00, ##  0000000               0000000                         
            0xFE, 0x00, 0x03, 0xFC, 0x00, 0x00, 0x78, ##  0000000               00000000                   0000 
            0xFE, 0x00, 0x03, 0xFC, 0x00, 0x00, 0xF8, ##  0000000               00000000                  00000 
            0xFE, 0x00, 0x03, 0xFC, 0x00, 0x00, 0xF8, ##  0000000               00000000                  00000 
            0xFE, 0x00, 0x07, 0xFE, 0x00, 0x01, 0xF0, ##  0000000              0000000000                00000  
            0x7F, 0x00, 0x07, 0xFF, 0x00, 0x01, 0xF0, ##   0000000             00000000000               00000  
            0x7F, 0x80, 0x0F, 0xFF, 0x00, 0x03, 0xE0, ##   00000000           000000000000              00000   
            0x3F, 0xC0, 0x1F, 0x9F, 0xC0, 0x07, 0xC0, ##    00000000         000000  0000000           00000    
            0x1F, 0xE0, 0x7F, 0x0F, 0xF0, 0x1F, 0x80, ##     00000000      0000000    00000000       000000     
            0x0F, 0xFF, 0xFC, 0x07, 0xFF, 0xFF, 0x00, ##      000000000000000000       0000000000000000000      
            0x07, 0xFF, 0xF0, 0x01, 0xFF, 0xFC, 0x00, ##       000000000000000           000000000000000        
            0x00, 0xFF, 0x80, 0x00, 0x3F, 0xE0, 0x00, ##          000000000                 000000000           
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '231' => {    # 'ç'
        'width'    => 30, 
        'xoffset'  => 3, 
        'xadvance' => 36, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x0F, 0xF8, 0x00, ##              000000000         
            0x00, 0x7F, 0xFF, 0x80, ##           0000000000000000     
            0x01, 0xFF, 0xFF, 0xF0, ##         000000000000000000000  
            0x03, 0xF8, 0x0F, 0xF8, ##        0000000       000000000 
            0x07, 0xE0, 0x03, 0xF8, ##       000000           0000000 
            0x0F, 0xC0, 0x01, 0xF8, ##      000000             000000 
            0x1F, 0x80, 0x00, 0xF8, ##     000000               00000 
            0x3F, 0x80, 0x00, 0xF8, ##    0000000               00000 
            0x3F, 0x00, 0x00, 0x78, ##    000000                 0000 
            0x7F, 0x00, 0x00, 0x78, ##   0000000                 0000 
            0x7F, 0x00, 0x00, 0x78, ##   0000000                 0000 
            0x7F, 0x00, 0x00, 0x00, ##   0000000                      
            0xFE, 0x00, 0x00, 0x00, ##  0000000                       
            0xFE, 0x00, 0x00, 0x00, ##  0000000                       
            0xFE, 0x00, 0x00, 0x00, ##  0000000                       
            0xFE, 0x00, 0x00, 0x00, ##  0000000                       
            0xFE, 0x00, 0x00, 0x00, ##  0000000                       
            0xFE, 0x00, 0x00, 0x00, ##  0000000                       
            0xFE, 0x00, 0x00, 0x00, ##  0000000                       
            0xFE, 0x00, 0x00, 0x00, ##  0000000                       
            0xFE, 0x00, 0x00, 0x00, ##  0000000                       
            0xFE, 0x00, 0x00, 0x00, ##  0000000                       
            0xFE, 0x00, 0x00, 0x00, ##  0000000                       
            0x7E, 0x00, 0x00, 0x00, ##   000000                       
            0x7F, 0x00, 0x00, 0x7C, ##   0000000                 00000
            0x7F, 0x00, 0x00, 0x78, ##   0000000                 0000 
            0x3F, 0x00, 0x00, 0xF8, ##    000000                00000 
            0x3F, 0x80, 0x00, 0xF8, ##    0000000               00000 
            0x1F, 0x80, 0x01, 0xF0, ##     000000              00000  
            0x0F, 0xC0, 0x01, 0xE0, ##      000000             0000   
            0x07, 0xE0, 0x07, 0xE0, ##       000000          000000   
            0x03, 0xF8, 0x0F, 0xC0, ##        0000000       000000    
            0x01, 0xFF, 0xFF, 0x80, ##         000000000000000000     
            0x00, 0x7F, 0xFE, 0x00, ##           00000000000000       
            0x00, 0x0F, 0xF0, 0x00, ##              00000000          
            0x00, 0x00, 0xF0, 0x00, ##                  0000          
            0x00, 0x00, 0x70, 0x00, ##                   000          
            0x00, 0x00, 0x78, 0x00, ##                   0000         
            0x00, 0x00, 0x38, 0x00, ##                    000         
            0x00, 0x00, 0x3C, 0x00, ##                    0000        
            0x00, 0x00, 0x3C, 0x00, ##                    0000        
            0x00, 0x60, 0x7C, 0x00, ##           00      00000        
            0x00, 0x7F, 0xFC, 0x00, ##           0000000000000        
            0x00, 0x7F, 0xF8, 0x00, ##           000000000000         
            0x00, 0x7F, 0xF0, 0x00, ##           00000000000          
            0x00, 0x1F, 0xC0, 0x00, ##             0000000            
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '232' => {    # 'è'
        'width'    => 32, 
        'xoffset'  => 3, 
        'xadvance' => 38, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x03, 0xF0, 0x00, 0x00, ##        000000                    
            0x01, 0xF8, 0x00, 0x00, ##         000000                   
            0x00, 0xF8, 0x00, 0x00, ##          00000                   
            0x00, 0xFC, 0x00, 0x00, ##          000000                  
            0x00, 0x7E, 0x00, 0x00, ##           000000                 
            0x00, 0x3E, 0x00, 0x00, ##            00000                 
            0x00, 0x1F, 0x00, 0x00, ##             00000                
            0x00, 0x0F, 0x80, 0x00, ##              00000               
            0x00, 0x07, 0x80, 0x00, ##               0000               
            0x00, 0x03, 0xC0, 0x00, ##                0000              
            0x00, 0x01, 0xE0, 0x00, ##                 0000             
            0x00, 0x00, 0xE0, 0x00, ##                  000             
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x0F, 0xF8, 0x00, ##              000000000           
            0x00, 0x7F, 0xFF, 0x00, ##           000000000000000        
            0x01, 0xFF, 0xFF, 0x80, ##         000000000000000000       
            0x03, 0xF8, 0x1F, 0xE0, ##        0000000      00000000     
            0x07, 0xE0, 0x07, 0xF0, ##       000000          0000000    
            0x0F, 0xC0, 0x03, 0xF8, ##      000000            0000000   
            0x1F, 0x80, 0x01, 0xF8, ##     000000              000000   
            0x3F, 0x80, 0x00, 0xFC, ##    0000000               000000  
            0x3F, 0x00, 0x00, 0xFC, ##    000000                000000  
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x7F, 0x00, 0x00, 0x7E, ##   0000000                 000000 
            0x7F, 0x00, 0x00, 0x7E, ##   0000000                 000000 
            0xFE, 0x00, 0x00, 0x7E, ##  0000000                  000000 
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFF, 0xFF, 0xFF, 0xFF, ##  00000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, ##  00000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, ##  00000000000000000000000000000000
            0xFE, 0x00, 0x00, 0x00, ##  0000000                         
            0xFE, 0x00, 0x00, 0x00, ##  0000000                         
            0xFE, 0x00, 0x00, 0x00, ##  0000000                         
            0xFE, 0x00, 0x00, 0x00, ##  0000000                         
            0xFE, 0x00, 0x00, 0x00, ##  0000000                         
            0x7E, 0x00, 0x00, 0x00, ##   000000                         
            0x7F, 0x00, 0x00, 0x1E, ##   0000000                   0000 
            0x7F, 0x00, 0x00, 0x3E, ##   0000000                  00000 
            0x3F, 0x00, 0x00, 0x3E, ##    000000                  00000 
            0x3F, 0x80, 0x00, 0x7C, ##    0000000                00000  
            0x1F, 0xC0, 0x00, 0x7C, ##     0000000               00000  
            0x0F, 0xC0, 0x00, 0xF8, ##      000000              00000   
            0x07, 0xF0, 0x01, 0xF0, ##       0000000           00000    
            0x03, 0xFC, 0x07, 0xE0, ##        00000000       000000     
            0x01, 0xFF, 0xFF, 0xC0, ##         0000000000000000000      
            0x00, 0x7F, 0xFF, 0x00, ##           000000000000000        
            0x00, 0x0F, 0xF8, 0x00, ##              000000000           
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '233' => {    # 'é'
        'width'    => 32, 
        'xoffset'  => 3, 
        'xadvance' => 38, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x0F, 0xC0, ##                      000000      
            0x00, 0x00, 0x1F, 0x80, ##                     000000       
            0x00, 0x00, 0x1F, 0x80, ##                     000000       
            0x00, 0x00, 0x3F, 0x00, ##                    000000        
            0x00, 0x00, 0x7E, 0x00, ##                   000000         
            0x00, 0x00, 0x7C, 0x00, ##                   00000          
            0x00, 0x00, 0xF8, 0x00, ##                  00000           
            0x00, 0x01, 0xF0, 0x00, ##                 00000            
            0x00, 0x01, 0xE0, 0x00, ##                 0000             
            0x00, 0x03, 0xC0, 0x00, ##                0000              
            0x00, 0x07, 0x80, 0x00, ##               0000               
            0x00, 0x07, 0x00, 0x00, ##               000                
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x0F, 0xF8, 0x00, ##              000000000           
            0x00, 0x7F, 0xFF, 0x00, ##           000000000000000        
            0x01, 0xFF, 0xFF, 0x80, ##         000000000000000000       
            0x03, 0xF8, 0x1F, 0xE0, ##        0000000      00000000     
            0x07, 0xE0, 0x07, 0xF0, ##       000000          0000000    
            0x0F, 0xC0, 0x03, 0xF8, ##      000000            0000000   
            0x1F, 0x80, 0x01, 0xF8, ##     000000              000000   
            0x3F, 0x80, 0x00, 0xFC, ##    0000000               000000  
            0x3F, 0x00, 0x00, 0xFC, ##    000000                000000  
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x7F, 0x00, 0x00, 0x7E, ##   0000000                 000000 
            0x7F, 0x00, 0x00, 0x7E, ##   0000000                 000000 
            0xFE, 0x00, 0x00, 0x7E, ##  0000000                  000000 
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFF, 0xFF, 0xFF, 0xFF, ##  00000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, ##  00000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, ##  00000000000000000000000000000000
            0xFE, 0x00, 0x00, 0x00, ##  0000000                         
            0xFE, 0x00, 0x00, 0x00, ##  0000000                         
            0xFE, 0x00, 0x00, 0x00, ##  0000000                         
            0xFE, 0x00, 0x00, 0x00, ##  0000000                         
            0xFE, 0x00, 0x00, 0x00, ##  0000000                         
            0x7E, 0x00, 0x00, 0x00, ##   000000                         
            0x7F, 0x00, 0x00, 0x1E, ##   0000000                   0000 
            0x7F, 0x00, 0x00, 0x3E, ##   0000000                  00000 
            0x3F, 0x00, 0x00, 0x3E, ##    000000                  00000 
            0x3F, 0x80, 0x00, 0x7C, ##    0000000                00000  
            0x1F, 0xC0, 0x00, 0x7C, ##     0000000               00000  
            0x0F, 0xC0, 0x00, 0xF8, ##      000000              00000   
            0x07, 0xF0, 0x01, 0xF0, ##       0000000           00000    
            0x03, 0xFC, 0x07, 0xE0, ##        00000000       000000     
            0x01, 0xFF, 0xFF, 0xC0, ##         0000000000000000000      
            0x00, 0x7F, 0xFF, 0x00, ##           000000000000000        
            0x00, 0x0F, 0xF8, 0x00, ##              000000000           
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '234' => {    # 'ê'
        'width'    => 32, 
        'xoffset'  => 3, 
        'xadvance' => 38, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x07, 0xE0, 0x00, ##               000000             
            0x00, 0x0F, 0xF0, 0x00, ##              00000000            
            0x00, 0x0F, 0xF0, 0x00, ##              00000000            
            0x00, 0x1F, 0xF8, 0x00, ##             0000000000           
            0x00, 0x1E, 0x7C, 0x00, ##             0000  00000          
            0x00, 0x3E, 0x7C, 0x00, ##            00000  00000          
            0x00, 0x7C, 0x3E, 0x00, ##           00000    00000         
            0x00, 0x78, 0x1E, 0x00, ##           0000      0000         
            0x00, 0xF0, 0x0F, 0x00, ##          0000        0000        
            0x00, 0xF0, 0x07, 0x80, ##          0000         0000       
            0x01, 0xE0, 0x07, 0x80, ##         0000          0000       
            0x03, 0xC0, 0x03, 0xC0, ##        0000            0000      
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x0F, 0xF8, 0x00, ##              000000000           
            0x00, 0x7F, 0xFF, 0x00, ##           000000000000000        
            0x01, 0xFF, 0xFF, 0x80, ##         000000000000000000       
            0x03, 0xF8, 0x1F, 0xE0, ##        0000000      00000000     
            0x07, 0xE0, 0x07, 0xF0, ##       000000          0000000    
            0x0F, 0xC0, 0x03, 0xF8, ##      000000            0000000   
            0x1F, 0x80, 0x01, 0xF8, ##     000000              000000   
            0x3F, 0x80, 0x00, 0xFC, ##    0000000               000000  
            0x3F, 0x00, 0x00, 0xFC, ##    000000                000000  
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x7F, 0x00, 0x00, 0x7E, ##   0000000                 000000 
            0x7F, 0x00, 0x00, 0x7E, ##   0000000                 000000 
            0xFE, 0x00, 0x00, 0x7E, ##  0000000                  000000 
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFF, 0xFF, 0xFF, 0xFF, ##  00000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, ##  00000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, ##  00000000000000000000000000000000
            0xFE, 0x00, 0x00, 0x00, ##  0000000                         
            0xFE, 0x00, 0x00, 0x00, ##  0000000                         
            0xFE, 0x00, 0x00, 0x00, ##  0000000                         
            0xFE, 0x00, 0x00, 0x00, ##  0000000                         
            0xFE, 0x00, 0x00, 0x00, ##  0000000                         
            0x7E, 0x00, 0x00, 0x00, ##   000000                         
            0x7F, 0x00, 0x00, 0x1E, ##   0000000                   0000 
            0x7F, 0x00, 0x00, 0x3E, ##   0000000                  00000 
            0x3F, 0x00, 0x00, 0x3E, ##    000000                  00000 
            0x3F, 0x80, 0x00, 0x7C, ##    0000000                00000  
            0x1F, 0xC0, 0x00, 0x7C, ##     0000000               00000  
            0x0F, 0xC0, 0x00, 0xF8, ##      000000              00000   
            0x07, 0xF0, 0x01, 0xF0, ##       0000000           00000    
            0x03, 0xFC, 0x07, 0xE0, ##        00000000       000000     
            0x01, 0xFF, 0xFF, 0xC0, ##         0000000000000000000      
            0x00, 0x7F, 0xFF, 0x00, ##           000000000000000        
            0x00, 0x0F, 0xF8, 0x00, ##              000000000           
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '235' => {    # 'ë'
        'width'    => 32, 
        'xoffset'  => 3, 
        'xadvance' => 38, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0xE0, 0x0E, 0x00, ##          000         000         
            0x01, 0xF0, 0x1F, 0x00, ##         00000       00000        
            0x03, 0xF8, 0x3F, 0x80, ##        0000000     0000000       
            0x03, 0xF8, 0x3F, 0x80, ##        0000000     0000000       
            0x03, 0xF8, 0x3F, 0x80, ##        0000000     0000000       
            0x01, 0xF0, 0x1F, 0x00, ##         00000       00000        
            0x00, 0xE0, 0x0E, 0x00, ##          000         000         
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x0F, 0xF8, 0x00, ##              000000000           
            0x00, 0x7F, 0xFF, 0x00, ##           000000000000000        
            0x01, 0xFF, 0xFF, 0x80, ##         000000000000000000       
            0x03, 0xF8, 0x1F, 0xE0, ##        0000000      00000000     
            0x07, 0xE0, 0x07, 0xF0, ##       000000          0000000    
            0x0F, 0xC0, 0x03, 0xF8, ##      000000            0000000   
            0x1F, 0x80, 0x01, 0xF8, ##     000000              000000   
            0x3F, 0x80, 0x00, 0xFC, ##    0000000               000000  
            0x3F, 0x00, 0x00, 0xFC, ##    000000                000000  
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x7F, 0x00, 0x00, 0x7E, ##   0000000                 000000 
            0x7F, 0x00, 0x00, 0x7E, ##   0000000                 000000 
            0xFE, 0x00, 0x00, 0x7E, ##  0000000                  000000 
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFF, 0xFF, 0xFF, 0xFF, ##  00000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, ##  00000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, ##  00000000000000000000000000000000
            0xFE, 0x00, 0x00, 0x00, ##  0000000                         
            0xFE, 0x00, 0x00, 0x00, ##  0000000                         
            0xFE, 0x00, 0x00, 0x00, ##  0000000                         
            0xFE, 0x00, 0x00, 0x00, ##  0000000                         
            0xFE, 0x00, 0x00, 0x00, ##  0000000                         
            0x7E, 0x00, 0x00, 0x00, ##   000000                         
            0x7F, 0x00, 0x00, 0x3E, ##   0000000                  00000 
            0x7F, 0x00, 0x00, 0x3E, ##   0000000                  00000 
            0x3F, 0x00, 0x00, 0x7E, ##    000000                 000000 
            0x3F, 0x80, 0x00, 0x7C, ##    0000000                00000  
            0x1F, 0x80, 0x00, 0xFC, ##     000000               000000  
            0x0F, 0xC0, 0x01, 0xF8, ##      000000             000000   
            0x07, 0xE0, 0x03, 0xF0, ##       000000           000000    
            0x03, 0xF8, 0x0F, 0xE0, ##        0000000       0000000     
            0x01, 0xFF, 0xFF, 0xC0, ##         0000000000000000000      
            0x00, 0x7F, 0xFF, 0x00, ##           000000000000000        
            0x00, 0x0F, 0xF8, 0x00, ##              000000000           
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '236' => {    # 'ì'
        'width'    => 20, 
        'xoffset'  => -1, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x7C, 0x00, 0x00, ##   00000              
            0x3E, 0x00, 0x00, ##    00000             
            0x3F, 0x00, 0x00, ##    000000            
            0x1F, 0x00, 0x00, ##     00000            
            0x0F, 0x80, 0x00, ##      00000           
            0x07, 0xC0, 0x00, ##       00000          
            0x03, 0xE0, 0x00, ##        00000         
            0x01, 0xE0, 0x00, ##         0000         
            0x00, 0xF0, 0x00, ##          0000        
            0x00, 0xF8, 0x00, ##          00000       
            0x00, 0x78, 0x00, ##           0000       
            0x00, 0x3C, 0x00, ##            0000      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x1F, 0xFC, 0x00, ##     00000000000      
            0x1F, 0xFC, 0x00, ##     00000000000      
            0x1F, 0xFC, 0x00, ##     00000000000      
            0x00, 0xFC, 0x00, ##          000000      
            0x00, 0xFC, 0x00, ##          000000      
            0x00, 0xFC, 0x00, ##          000000      
            0x00, 0xFC, 0x00, ##          000000      
            0x00, 0xFC, 0x00, ##          000000      
            0x00, 0xFC, 0x00, ##          000000      
            0x00, 0xFC, 0x00, ##          000000      
            0x00, 0xFC, 0x00, ##          000000      
            0x00, 0xFC, 0x00, ##          000000      
            0x00, 0xFC, 0x00, ##          000000      
            0x00, 0xFC, 0x00, ##          000000      
            0x00, 0xFC, 0x00, ##          000000      
            0x00, 0xFC, 0x00, ##          000000      
            0x00, 0xFC, 0x00, ##          000000      
            0x00, 0xFC, 0x00, ##          000000      
            0x00, 0xFC, 0x00, ##          000000      
            0x00, 0xFC, 0x00, ##          000000      
            0x00, 0xFC, 0x00, ##          000000      
            0x00, 0xFC, 0x00, ##          000000      
            0x00, 0xFC, 0x00, ##          000000      
            0x00, 0xFC, 0x00, ##          000000      
            0x00, 0xFC, 0x00, ##          000000      
            0x00, 0xFC, 0x00, ##          000000      
            0x00, 0xFC, 0x00, ##          000000      
            0x00, 0xFC, 0x00, ##          000000      
            0x00, 0xFC, 0x00, ##          000000      
            0x00, 0xFC, 0x00, ##          000000      
            0x1F, 0xFF, 0xF0, ##     00000000000000000
            0x1F, 0xFF, 0xF0, ##     00000000000000000
            0x1F, 0xFF, 0xF0, ##     00000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '237' => {    # 'í'
        'width'    => 19, 
        'xoffset'  => 2, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x0F, 0xC0, ##              000000 
            0x00, 0x1F, 0x80, ##             000000  
            0x00, 0x3F, 0x00, ##            000000   
            0x00, 0x3E, 0x00, ##            00000    
            0x00, 0x7C, 0x00, ##           00000     
            0x00, 0xF8, 0x00, ##          00000      
            0x01, 0xF0, 0x00, ##         00000       
            0x01, 0xE0, 0x00, ##         0000        
            0x03, 0xC0, 0x00, ##        0000         
            0x07, 0x80, 0x00, ##       0000          
            0x07, 0x00, 0x00, ##       000           
            0x0E, 0x00, 0x00, ##      000            
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0xFF, 0xE0, 0x00, ##  00000000000        
            0xFF, 0xE0, 0x00, ##  00000000000        
            0xFF, 0xE0, 0x00, ##  00000000000        
            0x07, 0xE0, 0x00, ##       000000        
            0x07, 0xE0, 0x00, ##       000000        
            0x07, 0xE0, 0x00, ##       000000        
            0x07, 0xE0, 0x00, ##       000000        
            0x07, 0xE0, 0x00, ##       000000        
            0x07, 0xE0, 0x00, ##       000000        
            0x07, 0xE0, 0x00, ##       000000        
            0x07, 0xE0, 0x00, ##       000000        
            0x07, 0xE0, 0x00, ##       000000        
            0x07, 0xE0, 0x00, ##       000000        
            0x07, 0xE0, 0x00, ##       000000        
            0x07, 0xE0, 0x00, ##       000000        
            0x07, 0xE0, 0x00, ##       000000        
            0x07, 0xE0, 0x00, ##       000000        
            0x07, 0xE0, 0x00, ##       000000        
            0x07, 0xE0, 0x00, ##       000000        
            0x07, 0xE0, 0x00, ##       000000        
            0x07, 0xE0, 0x00, ##       000000        
            0x07, 0xE0, 0x00, ##       000000        
            0x07, 0xE0, 0x00, ##       000000        
            0x07, 0xE0, 0x00, ##       000000        
            0x07, 0xE0, 0x00, ##       000000        
            0x07, 0xE0, 0x00, ##       000000        
            0x07, 0xE0, 0x00, ##       000000        
            0x07, 0xE0, 0x00, ##       000000        
            0x07, 0xE0, 0x00, ##       000000        
            0x07, 0xE0, 0x00, ##       000000        
            0xFF, 0xFF, 0x80, ##  00000000000000000  
            0xFF, 0xFF, 0x80, ##  00000000000000000  
            0xFF, 0xFF, 0x80, ##  00000000000000000  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '238' => {    # 'î'
        'width'    => 20, 
        'xoffset'  => 0, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x01, 0xF8, 0x00, ##         000000       
            0x03, 0xF8, 0x00, ##        0000000       
            0x07, 0xFC, 0x00, ##       000000000      
            0x07, 0xFE, 0x00, ##       0000000000     
            0x0F, 0xBE, 0x00, ##      00000 00000     
            0x0F, 0x1F, 0x00, ##      0000   00000    
            0x1E, 0x0F, 0x80, ##     0000     00000   
            0x3E, 0x07, 0x80, ##    00000      0000   
            0x3C, 0x03, 0xC0, ##    0000        0000  
            0x78, 0x01, 0xE0, ##   0000          0000 
            0x70, 0x01, 0xF0, ##   000           00000
            0xE0, 0x00, 0xF0, ##  000             0000
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x3F, 0xF8, 0x00, ##    00000000000       
            0x3F, 0xF8, 0x00, ##    00000000000       
            0x3F, 0xF8, 0x00, ##    00000000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x3F, 0xFF, 0xE0, ##    00000000000000000 
            0x3F, 0xFF, 0xE0, ##    00000000000000000 
            0x3F, 0xFF, 0xE0, ##    00000000000000000 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '239' => {    # 'ï'
        'width'    => 19, 
        'xoffset'  => 1, 
        'xadvance' => 21, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x38, 0x03, 0x80, ##    000         000  
            0x7C, 0x07, 0xC0, ##   00000       00000 
            0xFE, 0x0F, 0xE0, ##  0000000     0000000
            0xFE, 0x0F, 0xE0, ##  0000000     0000000
            0xFE, 0x0F, 0xE0, ##  0000000     0000000
            0x7C, 0x07, 0xC0, ##   00000       00000 
            0x38, 0x03, 0x80, ##    000         000  
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x00, 0x00, 0x00, ##                     
            0x3F, 0xF8, 0x00, ##    00000000000      
            0x3F, 0xF8, 0x00, ##    00000000000      
            0x3F, 0xF8, 0x00, ##    00000000000      
            0x01, 0xF8, 0x00, ##         000000      
            0x01, 0xF8, 0x00, ##         000000      
            0x01, 0xF8, 0x00, ##         000000      
            0x01, 0xF8, 0x00, ##         000000      
            0x01, 0xF8, 0x00, ##         000000      
            0x01, 0xF8, 0x00, ##         000000      
            0x01, 0xF8, 0x00, ##         000000      
            0x01, 0xF8, 0x00, ##         000000      
            0x01, 0xF8, 0x00, ##         000000      
            0x01, 0xF8, 0x00, ##         000000      
            0x01, 0xF8, 0x00, ##         000000      
            0x01, 0xF8, 0x00, ##         000000      
            0x01, 0xF8, 0x00, ##         000000      
            0x01, 0xF8, 0x00, ##         000000      
            0x01, 0xF8, 0x00, ##         000000      
            0x01, 0xF8, 0x00, ##         000000      
            0x01, 0xF8, 0x00, ##         000000      
            0x01, 0xF8, 0x00, ##         000000      
            0x01, 0xF8, 0x00, ##         000000      
            0x01, 0xF8, 0x00, ##         000000      
            0x01, 0xF8, 0x00, ##         000000      
            0x01, 0xF8, 0x00, ##         000000      
            0x01, 0xF8, 0x00, ##         000000      
            0x01, 0xF8, 0x00, ##         000000      
            0x01, 0xF8, 0x00, ##         000000      
            0x01, 0xF8, 0x00, ##         000000      
            0x01, 0xF8, 0x00, ##         000000      
            0x3F, 0xFF, 0xE0, ##    00000000000000000
            0x3F, 0xFF, 0xE0, ##    00000000000000000
            0x3F, 0xFF, 0xE0, ##    00000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '240' => {    # 'ð'
        'width'    => 32, 
        'xoffset'  => 3, 
        'xadvance' => 38, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x06, 0x00, 0x00, 0x00, ##       00                         
            0x07, 0xC0, 0x00, 0x00, ##       00000                      
            0x07, 0xF8, 0x00, 0x78, ##       00000000            0000   
            0x01, 0xFC, 0x01, 0xF8, ##         0000000         000000   
            0x00, 0x3F, 0x07, 0xE0, ##            000000     000000     
            0x00, 0x0F, 0xDF, 0x80, ##              000000 000000       
            0x00, 0x07, 0xFE, 0x00, ##               0000000000         
            0x00, 0x03, 0xF8, 0x00, ##                0000000           
            0x00, 0x07, 0xF8, 0x00, ##               00000000           
            0x00, 0x1F, 0xFC, 0x00, ##             00000000000          
            0x00, 0x7E, 0x7E, 0x00, ##           000000  000000         
            0x03, 0xF8, 0x3F, 0x00, ##        0000000     000000        
            0x03, 0xE0, 0x1F, 0x80, ##        00000        000000       
            0x03, 0x80, 0x1F, 0xC0, ##        000          0000000      
            0x00, 0x00, 0x0F, 0xC0, ##                      000000      
            0x00, 0x00, 0x0F, 0xE0, ##                      0000000     
            0x00, 0x1F, 0xFF, 0xF0, ##             00000000000000000    
            0x00, 0xFF, 0xFF, 0xF0, ##          00000000000000000000    
            0x01, 0xFF, 0xFF, 0xF8, ##         0000000000000000000000   
            0x07, 0xFC, 0x03, 0xF8, ##       000000000        0000000   
            0x0F, 0xE0, 0x01, 0xFC, ##      0000000            0000000  
            0x1F, 0xC0, 0x01, 0xFC, ##     0000000             0000000  
            0x1F, 0x80, 0x01, 0xFC, ##     000000              0000000  
            0x3F, 0x80, 0x00, 0xFE, ##    0000000               0000000 
            0x3F, 0x00, 0x00, 0xFE, ##    000000                0000000 
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x7F, 0x00, 0x00, 0xFF, ##   0000000                00000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0x7E, 0x00, 0x00, 0x7E, ##   000000                  000000 
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x3F, 0x00, 0x00, 0xFC, ##    000000                000000  
            0x3F, 0x80, 0x01, 0xFC, ##    0000000              0000000  
            0x1F, 0x80, 0x01, 0xF8, ##     000000              000000   
            0x0F, 0xC0, 0x03, 0xF0, ##      000000            000000    
            0x07, 0xE0, 0x07, 0xE0, ##       000000          000000     
            0x03, 0xF8, 0x1F, 0xC0, ##        0000000      0000000      
            0x01, 0xFF, 0xFF, 0x80, ##         000000000000000000       
            0x00, 0x7F, 0xFE, 0x00, ##           00000000000000         
            0x00, 0x0F, 0xF0, 0x00, ##              00000000            
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '241' => {    # 'ñ'
        'width'    => 37, 
        'xoffset'  => 3, 
        'xadvance' => 42, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x0F, 0x00, 0x70, 0x00, ##              0000         000         
            0x00, 0x3F, 0xC0, 0x70, 0x00, ##            00000000       000         
            0x00, 0x7F, 0xE0, 0x70, 0x00, ##           0000000000      000         
            0x00, 0x7F, 0xF0, 0xF0, 0x00, ##           00000000000    0000         
            0x00, 0x71, 0xF8, 0xE0, 0x00, ##           000   000000   000          
            0x00, 0xF0, 0xFF, 0xE0, 0x00, ##          0000    00000000000          
            0x00, 0xE0, 0x7F, 0xE0, 0x00, ##          000      0000000000          
            0x00, 0xE0, 0x3F, 0xC0, 0x00, ##          000       00000000           
            0x00, 0xE0, 0x0F, 0x00, 0x00, ##          000         0000             
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                       
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                       
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                       
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                       
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                       
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                       
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                       
            0x00, 0x00, 0x3F, 0x80, 0x00, ##                    0000000            
            0xFF, 0xE1, 0xFF, 0xE0, 0x00, ##  00000000000    000000000000          
            0xFF, 0xE3, 0xFF, 0xF8, 0x00, ##  00000000000   000000000000000        
            0xFF, 0xE7, 0xFF, 0xFC, 0x00, ##  00000000000  00000000000000000       
            0x07, 0xEF, 0x03, 0xFC, 0x00, ##       000000 0000      00000000       
            0x07, 0xEC, 0x00, 0xFE, 0x00, ##       000000 00          0000000      
            0x07, 0xF8, 0x00, 0x7E, 0x00, ##       00000000            000000      
            0x07, 0xF8, 0x00, 0x7E, 0x00, ##       00000000            000000      
            0x07, 0xF0, 0x00, 0x7F, 0x00, ##       0000000             0000000     
            0x07, 0xF0, 0x00, 0x3F, 0x00, ##       0000000              000000     
            0x07, 0xF0, 0x00, 0x3F, 0x00, ##       0000000              000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0xFF, 0xFF, 0x07, 0xFF, 0xF8, ##  0000000000000000     0000000000000000
            0xFF, 0xFF, 0x07, 0xFF, 0xF8, ##  0000000000000000     0000000000000000
            0xFF, 0xFF, 0x07, 0xFF, 0xF8, ##  0000000000000000     0000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '242' => {    # 'ò'
        'width'    => 32, 
        'xoffset'  => 3, 
        'xadvance' => 38, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x03, 0xF0, 0x00, 0x00, ##        000000                    
            0x01, 0xF8, 0x00, 0x00, ##         000000                   
            0x00, 0xF8, 0x00, 0x00, ##          00000                   
            0x00, 0x7C, 0x00, 0x00, ##           00000                  
            0x00, 0x7E, 0x00, 0x00, ##           000000                 
            0x00, 0x3E, 0x00, 0x00, ##            00000                 
            0x00, 0x1F, 0x00, 0x00, ##             00000                
            0x00, 0x0F, 0x80, 0x00, ##              00000               
            0x00, 0x07, 0x80, 0x00, ##               0000               
            0x00, 0x03, 0xC0, 0x00, ##                0000              
            0x00, 0x01, 0xC0, 0x00, ##                 000              
            0x00, 0x01, 0xE0, 0x00, ##                 0000             
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x0F, 0xF0, 0x00, ##              00000000            
            0x00, 0x7F, 0xFE, 0x00, ##           00000000000000         
            0x01, 0xFF, 0xFF, 0x80, ##         000000000000000000       
            0x03, 0xF8, 0x1F, 0xC0, ##        0000000      0000000      
            0x07, 0xE0, 0x07, 0xE0, ##       000000          000000     
            0x0F, 0xC0, 0x03, 0xF0, ##      000000            000000    
            0x1F, 0x80, 0x01, 0xF8, ##     000000              000000   
            0x3F, 0x80, 0x01, 0xFC, ##    0000000              0000000  
            0x3F, 0x00, 0x00, 0xFC, ##    000000                000000  
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0xFE, 0x00, 0x00, 0x7E, ##  0000000                  000000 
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7E, ##  0000000                  000000 
            0x7E, 0x00, 0x00, 0xFE, ##   000000                 0000000 
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x3F, 0x00, 0x00, 0xFC, ##    000000                000000  
            0x3F, 0x80, 0x01, 0xFC, ##    0000000              0000000  
            0x1F, 0x80, 0x01, 0xF8, ##     000000              000000   
            0x0F, 0xC0, 0x03, 0xF0, ##      000000            000000    
            0x07, 0xE0, 0x07, 0xE0, ##       000000          000000     
            0x03, 0xF8, 0x1F, 0xC0, ##        0000000      0000000      
            0x01, 0xFF, 0xFF, 0x80, ##         000000000000000000       
            0x00, 0x7F, 0xFE, 0x00, ##           00000000000000         
            0x00, 0x0F, 0xF0, 0x00, ##              00000000            
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '243' => {    # 'ó'
        'width'    => 32, 
        'xoffset'  => 3, 
        'xadvance' => 38, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x0F, 0xC0, ##                      000000      
            0x00, 0x00, 0x1F, 0x80, ##                     000000       
            0x00, 0x00, 0x1F, 0x00, ##                     00000        
            0x00, 0x00, 0x3E, 0x00, ##                    00000         
            0x00, 0x00, 0x7C, 0x00, ##                   00000          
            0x00, 0x00, 0x7C, 0x00, ##                   00000          
            0x00, 0x00, 0xF8, 0x00, ##                  00000           
            0x00, 0x01, 0xF0, 0x00, ##                 00000            
            0x00, 0x01, 0xE0, 0x00, ##                 0000             
            0x00, 0x03, 0xC0, 0x00, ##                0000              
            0x00, 0x07, 0x80, 0x00, ##               0000               
            0x00, 0x07, 0x00, 0x00, ##               000                
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x0F, 0xF0, 0x00, ##              00000000            
            0x00, 0x7F, 0xFE, 0x00, ##           00000000000000         
            0x01, 0xFF, 0xFF, 0x80, ##         000000000000000000       
            0x03, 0xF8, 0x1F, 0xC0, ##        0000000      0000000      
            0x07, 0xE0, 0x07, 0xE0, ##       000000          000000     
            0x0F, 0xC0, 0x03, 0xF0, ##      000000            000000    
            0x1F, 0x80, 0x01, 0xF8, ##     000000              000000   
            0x3F, 0x80, 0x01, 0xFC, ##    0000000              0000000  
            0x3F, 0x00, 0x00, 0xFC, ##    000000                000000  
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0xFE, 0x00, 0x00, 0x7E, ##  0000000                  000000 
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7E, ##  0000000                  000000 
            0x7E, 0x00, 0x00, 0xFE, ##   000000                 0000000 
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x3F, 0x00, 0x00, 0xFC, ##    000000                000000  
            0x3F, 0x80, 0x01, 0xFC, ##    0000000              0000000  
            0x1F, 0x80, 0x01, 0xF8, ##     000000              000000   
            0x0F, 0xC0, 0x03, 0xF0, ##      000000            000000    
            0x07, 0xE0, 0x07, 0xE0, ##       000000          000000     
            0x03, 0xF8, 0x1F, 0xC0, ##        0000000      0000000      
            0x01, 0xFF, 0xFF, 0x80, ##         000000000000000000       
            0x00, 0x7F, 0xFE, 0x00, ##           00000000000000         
            0x00, 0x0F, 0xF0, 0x00, ##              00000000            
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '244' => {    # 'ô'
        'width'    => 32, 
        'xoffset'  => 3, 
        'xadvance' => 38, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x07, 0xE0, 0x00, ##               000000             
            0x00, 0x07, 0xE0, 0x00, ##               000000             
            0x00, 0x0F, 0xF0, 0x00, ##              00000000            
            0x00, 0x1F, 0xF8, 0x00, ##             0000000000           
            0x00, 0x1E, 0x78, 0x00, ##             0000  0000           
            0x00, 0x3E, 0x7C, 0x00, ##            00000  00000          
            0x00, 0x3C, 0x3C, 0x00, ##            0000    0000          
            0x00, 0x78, 0x1E, 0x00, ##           0000      0000         
            0x00, 0xF0, 0x0F, 0x00, ##          0000        0000        
            0x00, 0xF0, 0x0F, 0x00, ##          0000        0000        
            0x01, 0xE0, 0x07, 0x80, ##         0000          0000       
            0x01, 0xC0, 0x03, 0x80, ##         000            000       
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x0F, 0xF0, 0x00, ##              00000000            
            0x00, 0x7F, 0xFE, 0x00, ##           00000000000000         
            0x01, 0xFF, 0xFF, 0x80, ##         000000000000000000       
            0x03, 0xF8, 0x1F, 0xC0, ##        0000000      0000000      
            0x07, 0xE0, 0x07, 0xE0, ##       000000          000000     
            0x0F, 0xC0, 0x03, 0xF0, ##      000000            000000    
            0x1F, 0x80, 0x01, 0xF8, ##     000000              000000   
            0x3F, 0x80, 0x01, 0xFC, ##    0000000              0000000  
            0x3F, 0x00, 0x00, 0xFC, ##    000000                000000  
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0xFE, 0x00, 0x00, 0x7E, ##  0000000                  000000 
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7E, ##  0000000                  000000 
            0x7E, 0x00, 0x00, 0xFE, ##   000000                 0000000 
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x3F, 0x00, 0x00, 0xFC, ##    000000                000000  
            0x3F, 0x80, 0x01, 0xFC, ##    0000000              0000000  
            0x1F, 0x80, 0x01, 0xF8, ##     000000              000000   
            0x0F, 0xC0, 0x03, 0xF0, ##      000000            000000    
            0x07, 0xE0, 0x07, 0xE0, ##       000000          000000     
            0x03, 0xF8, 0x1F, 0xC0, ##        0000000      0000000      
            0x01, 0xFF, 0xFF, 0x80, ##         000000000000000000       
            0x00, 0x7F, 0xFE, 0x00, ##           00000000000000         
            0x00, 0x0F, 0xF0, 0x00, ##              00000000            
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '245' => {    # 'õ'
        'width'    => 32, 
        'xoffset'  => 3, 
        'xadvance' => 38, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x7C, 0x01, 0xC0, ##           00000         000      
            0x00, 0xFF, 0x01, 0xC0, ##          00000000       000      
            0x01, 0xFF, 0x81, 0xC0, ##         0000000000      000      
            0x01, 0xFF, 0xE3, 0xC0, ##         000000000000   0000      
            0x03, 0xC7, 0xFF, 0x80, ##        0000   000000000000       
            0x03, 0x81, 0xFF, 0x80, ##        000      0000000000       
            0x03, 0x80, 0xFF, 0x00, ##        000       00000000        
            0x03, 0x80, 0x3E, 0x00, ##        000         00000         
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x0F, 0xF0, 0x00, ##              00000000            
            0x00, 0x7F, 0xFE, 0x00, ##           00000000000000         
            0x01, 0xFF, 0xFF, 0x80, ##         000000000000000000       
            0x03, 0xF8, 0x1F, 0xC0, ##        0000000      0000000      
            0x07, 0xE0, 0x07, 0xE0, ##       000000          000000     
            0x0F, 0xC0, 0x03, 0xF0, ##      000000            000000    
            0x1F, 0x80, 0x01, 0xF8, ##     000000              000000   
            0x3F, 0x80, 0x01, 0xFC, ##    0000000              0000000  
            0x3F, 0x00, 0x00, 0xFC, ##    000000                000000  
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0xFE, 0x00, 0x00, 0x7E, ##  0000000                  000000 
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7E, ##  0000000                  000000 
            0x7E, 0x00, 0x00, 0xFE, ##   000000                 0000000 
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x3F, 0x00, 0x00, 0xFC, ##    000000                000000  
            0x3F, 0x80, 0x01, 0xFC, ##    0000000              0000000  
            0x1F, 0x80, 0x01, 0xF8, ##     000000              000000   
            0x0F, 0xC0, 0x03, 0xF0, ##      000000            000000    
            0x07, 0xE0, 0x07, 0xE0, ##       000000          000000     
            0x03, 0xF8, 0x1F, 0xC0, ##        0000000      0000000      
            0x01, 0xFF, 0xFF, 0x80, ##         000000000000000000       
            0x00, 0x7F, 0xFE, 0x00, ##           00000000000000         
            0x00, 0x0F, 0xF0, 0x00, ##              00000000            
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '246' => {    # 'ö'
        'width'    => 32, 
        'xoffset'  => 3, 
        'xadvance' => 38, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0xE0, 0x07, 0x00, ##          000          000        
            0x01, 0xF0, 0x0F, 0x80, ##         00000        00000       
            0x03, 0xF8, 0x1F, 0xC0, ##        0000000      0000000      
            0x03, 0xF8, 0x1F, 0xC0, ##        0000000      0000000      
            0x03, 0xF8, 0x1F, 0xC0, ##        0000000      0000000      
            0x01, 0xF0, 0x0F, 0x80, ##         00000        00000       
            0x00, 0xE0, 0x07, 0x00, ##          000          000        
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x0F, 0xF0, 0x00, ##              00000000            
            0x00, 0x7F, 0xFE, 0x00, ##           00000000000000         
            0x01, 0xFF, 0xFF, 0x80, ##         000000000000000000       
            0x03, 0xF8, 0x1F, 0xC0, ##        0000000      0000000      
            0x07, 0xE0, 0x07, 0xE0, ##       000000          000000     
            0x0F, 0xC0, 0x03, 0xF0, ##      000000            000000    
            0x1F, 0x80, 0x01, 0xF8, ##     000000              000000   
            0x3F, 0x80, 0x01, 0xFC, ##    0000000              0000000  
            0x3F, 0x00, 0x00, 0xFC, ##    000000                000000  
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0xFE, 0x00, 0x00, 0x7E, ##  0000000                  000000 
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7E, ##  0000000                  000000 
            0x7E, 0x00, 0x00, 0xFE, ##   000000                 0000000 
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x3F, 0x00, 0x00, 0xFC, ##    000000                000000  
            0x3F, 0x80, 0x01, 0xFC, ##    0000000              0000000  
            0x1F, 0x80, 0x01, 0xF8, ##     000000              000000   
            0x0F, 0xC0, 0x03, 0xF0, ##      000000            000000    
            0x07, 0xE0, 0x07, 0xE0, ##       000000          000000     
            0x03, 0xF8, 0x1F, 0xC0, ##        0000000      0000000      
            0x01, 0xFF, 0xFF, 0x80, ##         000000000000000000       
            0x00, 0x7F, 0xFE, 0x00, ##           00000000000000         
            0x00, 0x0F, 0xF0, 0x00, ##              00000000            
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '247' => {    # '÷'
        'width'    => 40, 
        'xoffset'  => 7, 
        'xadvance' => 54, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x3C, 0x00, 0x00, ##                    0000                  
            0x00, 0x00, 0x7E, 0x00, 0x00, ##                   000000                 
            0x00, 0x00, 0xFF, 0x00, 0x00, ##                  00000000                
            0x00, 0x00, 0xFF, 0x00, 0x00, ##                  00000000                
            0x00, 0x00, 0xFF, 0x00, 0x00, ##                  00000000                
            0x00, 0x00, 0xFF, 0x00, 0x00, ##                  00000000                
            0x00, 0x00, 0x7E, 0x00, 0x00, ##                   000000                 
            0x00, 0x00, 0x3C, 0x00, 0x00, ##                    0000                  
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                          
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                          
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                          
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                          
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                          
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                          
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                          
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                          
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                          
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                          
            0x00, 0x00, 0x3C, 0x00, 0x00, ##                    0000                  
            0x00, 0x00, 0x7E, 0x00, 0x00, ##                   000000                 
            0x00, 0x00, 0xFF, 0x00, 0x00, ##                  00000000                
            0x00, 0x00, 0xFF, 0x00, 0x00, ##                  00000000                
            0x00, 0x00, 0xFF, 0x00, 0x00, ##                  00000000                
            0x00, 0x00, 0xFF, 0x00, 0x00, ##                  00000000                
            0x00, 0x00, 0x7E, 0x00, 0x00, ##                   000000                 
            0x00, 0x00, 0x3C, 0x00, 0x00, ##                    0000                  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '248' => {    # 'ø'
        'width'    => 34, 
        'xoffset'  => 2, 
        'xadvance' => 38, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x01, 0x00, ##                                 0  
            0x00, 0x00, 0x00, 0x03, 0x80, ##                                000 
            0x00, 0x07, 0xF8, 0x07, 0x80, ##               00000000        0000 
            0x00, 0x3F, 0xFF, 0x0F, 0x00, ##            00000000000000    0000  
            0x00, 0xFF, 0xFF, 0xDE, 0x00, ##          000000000000000000 0000   
            0x01, 0xFC, 0x0F, 0xFE, 0x00, ##         0000000      00000000000   
            0x03, 0xF0, 0x03, 0xFC, 0x00, ##        000000          00000000    
            0x07, 0xE0, 0x01, 0xF8, 0x00, ##       000000            000000     
            0x0F, 0xC0, 0x00, 0xFC, 0x00, ##      000000              000000    
            0x1F, 0xC0, 0x00, 0xFE, 0x00, ##     0000000              0000000   
            0x1F, 0x80, 0x01, 0xFE, 0x00, ##     000000              00000000   
            0x3F, 0x80, 0x03, 0xFF, 0x00, ##    0000000             0000000000  
            0x3F, 0x80, 0x07, 0x7F, 0x00, ##    0000000            000 0000000  
            0x3F, 0x80, 0x0F, 0x3F, 0x00, ##    0000000           0000  000000  
            0x7F, 0x00, 0x1E, 0x3F, 0x00, ##   0000000           0000   000000  
            0x7F, 0x00, 0x3C, 0x3F, 0x80, ##   0000000          0000    0000000 
            0x7F, 0x00, 0x38, 0x3F, 0x80, ##   0000000          000     0000000 
            0x7F, 0x00, 0x70, 0x3F, 0x80, ##   0000000         000      0000000 
            0x7F, 0x00, 0xE0, 0x3F, 0x80, ##   0000000        000       0000000 
            0x7F, 0x01, 0xE0, 0x3F, 0x80, ##   0000000       0000       0000000 
            0x7F, 0x03, 0xC0, 0x3F, 0x80, ##   0000000      0000        0000000 
            0x7F, 0x07, 0x80, 0x3F, 0x80, ##   0000000     0000         0000000 
            0x7F, 0x07, 0x00, 0x3F, 0x80, ##   0000000     000          0000000 
            0x7F, 0x0E, 0x00, 0x3F, 0x80, ##   0000000    000           0000000 
            0x3F, 0x1C, 0x00, 0x3F, 0x00, ##    000000   000            000000  
            0x3F, 0xBC, 0x00, 0x7F, 0x00, ##    0000000 0000           0000000  
            0x3F, 0xF8, 0x00, 0x7F, 0x00, ##    00000000000            0000000  
            0x3F, 0xF0, 0x00, 0x7F, 0x00, ##    0000000000             0000000  
            0x1F, 0xE0, 0x00, 0x7E, 0x00, ##     00000000              000000   
            0x0F, 0xC0, 0x00, 0xFE, 0x00, ##      000000              0000000   
            0x0F, 0xC0, 0x01, 0xFC, 0x00, ##      000000             0000000    
            0x07, 0xE0, 0x01, 0xF8, 0x00, ##       000000            000000     
            0x0F, 0xF0, 0x03, 0xF0, 0x00, ##      00000000          000000      
            0x1F, 0xFC, 0x0F, 0xE0, 0x00, ##     00000000000      0000000       
            0x3E, 0xFF, 0xFF, 0xC0, 0x00, ##    00000 000000000000000000        
            0x3C, 0x3F, 0xFF, 0x00, 0x00, ##    0000    00000000000000          
            0x78, 0x07, 0xF8, 0x00, 0x00, ##   0000        00000000             
            0x70, 0x00, 0x00, 0x00, 0x00, ##   000                              
            0x20, 0x00, 0x00, 0x00, 0x00, ##    0                               
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '249' => {    # 'ù'
        'width'    => 37, 
        'xoffset'  => 2, 
        'xadvance' => 41, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x03, 0xF0, 0x00, 0x00, 0x00, ##        000000                         
            0x01, 0xF8, 0x00, 0x00, 0x00, ##         000000                        
            0x00, 0xFC, 0x00, 0x00, 0x00, ##          000000                       
            0x00, 0x7C, 0x00, 0x00, 0x00, ##           00000                       
            0x00, 0x3E, 0x00, 0x00, 0x00, ##            00000                      
            0x00, 0x1F, 0x00, 0x00, 0x00, ##             00000                     
            0x00, 0x0F, 0x00, 0x00, 0x00, ##              0000                     
            0x00, 0x0F, 0x80, 0x00, 0x00, ##              00000                    
            0x00, 0x07, 0xC0, 0x00, 0x00, ##               00000                   
            0x00, 0x03, 0xC0, 0x00, 0x00, ##                0000                   
            0x00, 0x01, 0xE0, 0x00, 0x00, ##                 0000                  
            0x00, 0x00, 0xF0, 0x00, 0x00, ##                  0000                 
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                       
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                       
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                       
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                       
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                       
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                       
            0xFF, 0xE0, 0x07, 0xFF, 0x00, ##  00000000000          00000000000     
            0xFF, 0xE0, 0x07, 0xFF, 0x00, ##  00000000000          00000000000     
            0xFF, 0xE0, 0x07, 0xFF, 0x00, ##  00000000000          00000000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x7F, 0x00, ##       000000              0000000     
            0x07, 0xE0, 0x00, 0x7F, 0x00, ##       000000              0000000     
            0x07, 0xF0, 0x00, 0x7F, 0x00, ##       0000000             0000000     
            0x03, 0xF0, 0x00, 0xFF, 0x00, ##        000000            00000000     
            0x03, 0xF0, 0x00, 0xFF, 0x00, ##        000000            00000000     
            0x03, 0xF8, 0x03, 0xBF, 0x00, ##        0000000         000 000000     
            0x01, 0xFE, 0x07, 0xBF, 0x00, ##         00000000      0000 000000     
            0x01, 0xFF, 0xFF, 0x3F, 0xF8, ##         00000000000000000  00000000000
            0x00, 0xFF, 0xFE, 0x3F, 0xF8, ##          000000000000000   00000000000
            0x00, 0x3F, 0xFC, 0x3F, 0xF8, ##            000000000000    00000000000
            0x00, 0x0F, 0xE0, 0x00, 0x00, ##              0000000                  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '250' => {    # 'ú'
        'width'    => 37, 
        'xoffset'  => 2, 
        'xadvance' => 41, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x07, 0xE0, 0x00, ##                       000000          
            0x00, 0x00, 0x0F, 0xC0, 0x00, ##                      000000           
            0x00, 0x00, 0x1F, 0x80, 0x00, ##                     000000            
            0x00, 0x00, 0x1F, 0x00, 0x00, ##                     00000             
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000              
            0x00, 0x00, 0x7C, 0x00, 0x00, ##                   00000               
            0x00, 0x00, 0x78, 0x00, 0x00, ##                   0000                
            0x00, 0x00, 0xF8, 0x00, 0x00, ##                  00000                
            0x00, 0x01, 0xF0, 0x00, 0x00, ##                 00000                 
            0x00, 0x01, 0xE0, 0x00, 0x00, ##                 0000                  
            0x00, 0x03, 0xC0, 0x00, 0x00, ##                0000                   
            0x00, 0x07, 0x80, 0x00, 0x00, ##               0000                    
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                       
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                       
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                       
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                       
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                       
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                       
            0xFF, 0xE0, 0x07, 0xFF, 0x00, ##  00000000000          00000000000     
            0xFF, 0xE0, 0x07, 0xFF, 0x00, ##  00000000000          00000000000     
            0xFF, 0xE0, 0x07, 0xFF, 0x00, ##  00000000000          00000000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x7F, 0x00, ##       000000              0000000     
            0x07, 0xE0, 0x00, 0x7F, 0x00, ##       000000              0000000     
            0x07, 0xF0, 0x00, 0x7F, 0x00, ##       0000000             0000000     
            0x03, 0xF0, 0x00, 0xFF, 0x00, ##        000000            00000000     
            0x03, 0xF0, 0x00, 0xFF, 0x00, ##        000000            00000000     
            0x03, 0xF8, 0x03, 0xBF, 0x00, ##        0000000         000 000000     
            0x01, 0xFE, 0x07, 0xBF, 0x00, ##         00000000      0000 000000     
            0x01, 0xFF, 0xFF, 0x3F, 0xF8, ##         00000000000000000  00000000000
            0x00, 0xFF, 0xFE, 0x3F, 0xF8, ##          000000000000000   00000000000
            0x00, 0x3F, 0xFC, 0x3F, 0xF8, ##            000000000000    00000000000
            0x00, 0x0F, 0xE0, 0x00, 0x00, ##              0000000                  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '251' => {    # 'û'
        'width'    => 37, 
        'xoffset'  => 2, 
        'xadvance' => 41, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x03, 0xF0, 0x00, 0x00, ##                000000                 
            0x00, 0x07, 0xF0, 0x00, 0x00, ##               0000000                 
            0x00, 0x0F, 0xF8, 0x00, 0x00, ##              000000000                
            0x00, 0x0F, 0xF8, 0x00, 0x00, ##              000000000                
            0x00, 0x1F, 0x7C, 0x00, 0x00, ##             00000 00000               
            0x00, 0x3E, 0x3E, 0x00, 0x00, ##            00000   00000              
            0x00, 0x3C, 0x1E, 0x00, 0x00, ##            0000     0000              
            0x00, 0x7C, 0x1F, 0x00, 0x00, ##           00000     00000             
            0x00, 0x78, 0x0F, 0x00, 0x00, ##           0000       0000             
            0x00, 0xF0, 0x07, 0x80, 0x00, ##          0000         0000            
            0x01, 0xE0, 0x03, 0xC0, 0x00, ##         0000           0000           
            0x01, 0xE0, 0x01, 0xC0, 0x00, ##         0000            000           
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                       
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                       
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                       
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                       
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                       
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                       
            0xFF, 0xE0, 0x07, 0xFF, 0x00, ##  00000000000          00000000000     
            0xFF, 0xE0, 0x07, 0xFF, 0x00, ##  00000000000          00000000000     
            0xFF, 0xE0, 0x07, 0xFF, 0x00, ##  00000000000          00000000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x7F, 0x00, ##       000000              0000000     
            0x07, 0xE0, 0x00, 0x7F, 0x00, ##       000000              0000000     
            0x07, 0xF0, 0x00, 0x7F, 0x00, ##       0000000             0000000     
            0x03, 0xF0, 0x00, 0xFF, 0x00, ##        000000            00000000     
            0x03, 0xF0, 0x00, 0xFF, 0x00, ##        000000            00000000     
            0x03, 0xF8, 0x03, 0xBF, 0x00, ##        0000000         000 000000     
            0x01, 0xFE, 0x07, 0xBF, 0x00, ##         00000000      0000 000000     
            0x01, 0xFF, 0xFF, 0x3F, 0xF8, ##         00000000000000000  00000000000
            0x00, 0xFF, 0xFE, 0x3F, 0xF8, ##          000000000000000   00000000000
            0x00, 0x3F, 0xFC, 0x3F, 0xF8, ##            000000000000    00000000000
            0x00, 0x0F, 0xE0, 0x00, 0x00, ##              0000000                  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '252' => {    # 'ü'
        'width'    => 37, 
        'xoffset'  => 2, 
        'xadvance' => 41, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x70, 0x07, 0x00, 0x00, ##           000         000             
            0x00, 0xF8, 0x0F, 0x80, 0x00, ##          00000       00000            
            0x01, 0xFC, 0x1F, 0xC0, 0x00, ##         0000000     0000000           
            0x01, 0xFC, 0x1F, 0xC0, 0x00, ##         0000000     0000000           
            0x01, 0xFC, 0x1F, 0xC0, 0x00, ##         0000000     0000000           
            0x00, 0xF8, 0x0F, 0x80, 0x00, ##          00000       00000            
            0x00, 0x70, 0x07, 0x00, 0x00, ##           000         000             
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                       
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                       
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                       
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                       
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                       
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                       
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                       
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                       
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                       
            0xFF, 0xE0, 0x07, 0xFF, 0x00, ##  00000000000          00000000000     
            0xFF, 0xE0, 0x07, 0xFF, 0x00, ##  00000000000          00000000000     
            0xFF, 0xE0, 0x07, 0xFF, 0x00, ##  00000000000          00000000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x3F, 0x00, ##       000000               000000     
            0x07, 0xE0, 0x00, 0x7F, 0x00, ##       000000              0000000     
            0x07, 0xE0, 0x00, 0x7F, 0x00, ##       000000              0000000     
            0x07, 0xF0, 0x00, 0x7F, 0x00, ##       0000000             0000000     
            0x03, 0xF0, 0x00, 0xFF, 0x00, ##        000000            00000000     
            0x03, 0xF0, 0x00, 0xFF, 0x00, ##        000000            00000000     
            0x03, 0xF8, 0x03, 0xBF, 0x00, ##        0000000         000 000000     
            0x01, 0xFE, 0x07, 0xBF, 0x00, ##         00000000      0000 000000     
            0x01, 0xFF, 0xFF, 0x3F, 0xF8, ##         00000000000000000  00000000000
            0x00, 0xFF, 0xFE, 0x3F, 0xF8, ##          000000000000000   00000000000
            0x00, 0x3F, 0xFC, 0x3F, 0xF8, ##            000000000000    00000000000
            0x00, 0x0F, 0xE0, 0x00, 0x00, ##              0000000                  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '253' => {    # 'ý'
        'width'    => 36, 
        'xoffset'  => 0, 
        'xadvance' => 37, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x01, 0xF8, 0x00, ##                         000000       
            0x00, 0x00, 0x03, 0xF0, 0x00, ##                        000000        
            0x00, 0x00, 0x07, 0xE0, 0x00, ##                       000000         
            0x00, 0x00, 0x0F, 0xC0, 0x00, ##                      000000          
            0x00, 0x00, 0x0F, 0x80, 0x00, ##                      00000           
            0x00, 0x00, 0x1F, 0x00, 0x00, ##                     00000            
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000             
            0x00, 0x00, 0x7C, 0x00, 0x00, ##                   00000              
            0x00, 0x00, 0x78, 0x00, 0x00, ##                   0000               
            0x00, 0x00, 0xF0, 0x00, 0x00, ##                  0000                
            0x00, 0x01, 0xE0, 0x00, 0x00, ##                 0000                 
            0x00, 0x03, 0xC0, 0x00, 0x00, ##                0000                  
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                      
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                      
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                      
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                      
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                      
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                      
            0xFF, 0xFE, 0x00, 0xFF, 0xF0, ##  000000000000000         000000000000
            0xFF, 0xFE, 0x00, 0xFF, 0xF0, ##  000000000000000         000000000000
            0xFF, 0xFE, 0x00, 0xFF, 0xF0, ##  000000000000000         000000000000
            0x0F, 0xC0, 0x00, 0x07, 0x00, ##      000000                   000    
            0x0F, 0xC0, 0x00, 0x0F, 0x00, ##      000000                  0000    
            0x07, 0xE0, 0x00, 0x0E, 0x00, ##       000000                 000     
            0x07, 0xE0, 0x00, 0x1E, 0x00, ##       000000                0000     
            0x03, 0xF0, 0x00, 0x1E, 0x00, ##        000000               0000     
            0x03, 0xF0, 0x00, 0x1C, 0x00, ##        000000               000      
            0x03, 0xF0, 0x00, 0x3C, 0x00, ##        000000              0000      
            0x01, 0xF8, 0x00, 0x38, 0x00, ##         000000             000       
            0x01, 0xF8, 0x00, 0x78, 0x00, ##         000000            0000       
            0x00, 0xFC, 0x00, 0x78, 0x00, ##          000000           0000       
            0x00, 0xFC, 0x00, 0xF0, 0x00, ##          000000          0000        
            0x00, 0xFE, 0x00, 0xF0, 0x00, ##          0000000         0000        
            0x00, 0x7E, 0x00, 0xE0, 0x00, ##           000000         000         
            0x00, 0x7E, 0x01, 0xE0, 0x00, ##           000000        0000         
            0x00, 0x3F, 0x01, 0xE0, 0x00, ##            000000       0000         
            0x00, 0x3F, 0x03, 0xC0, 0x00, ##            000000      0000          
            0x00, 0x3F, 0x83, 0xC0, 0x00, ##            0000000     0000          
            0x00, 0x1F, 0x83, 0x80, 0x00, ##             000000     000           
            0x00, 0x1F, 0x87, 0x80, 0x00, ##             000000    0000           
            0x00, 0x0F, 0xC7, 0x00, 0x00, ##              000000   000            
            0x00, 0x0F, 0xCF, 0x00, 0x00, ##              000000  0000            
            0x00, 0x0F, 0xEF, 0x00, 0x00, ##              0000000 0000            
            0x00, 0x07, 0xEE, 0x00, 0x00, ##               000000 000             
            0x00, 0x07, 0xFE, 0x00, 0x00, ##               0000000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000              
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000              
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000              
            0x00, 0x01, 0xF8, 0x00, 0x00, ##                 000000               
            0x00, 0x01, 0xF8, 0x00, 0x00, ##                 000000               
            0x00, 0x00, 0xF0, 0x00, 0x00, ##                  0000                
            0x00, 0x00, 0xF0, 0x00, 0x00, ##                  0000                
            0x00, 0x00, 0xF0, 0x00, 0x00, ##                  0000                
            0x00, 0x01, 0xE0, 0x00, 0x00, ##                 0000                 
            0x00, 0x01, 0xE0, 0x00, 0x00, ##                 0000                 
            0x00, 0x01, 0xC0, 0x00, 0x00, ##                 000                  
            0x00, 0x03, 0xC0, 0x00, 0x00, ##                0000                  
            0x00, 0x03, 0xC0, 0x00, 0x00, ##                0000                  
            0x38, 0x07, 0x80, 0x00, 0x00, ##    000        0000                   
            0x38, 0x07, 0x80, 0x00, 0x00, ##    000        0000                   
            0x3C, 0x0F, 0x00, 0x00, 0x00, ##    0000      0000                    
            0x3E, 0x1F, 0x00, 0x00, 0x00, ##    00000    00000                    
            0x3F, 0xFE, 0x00, 0x00, 0x00, ##    0000000000000                     
            0x3F, 0xFC, 0x00, 0x00, 0x00, ##    000000000000                      
            0x0F, 0xF0, 0x00, 0x00, 0x00, ##      00000000                        
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '254' => {    # 'þ'
        'width'    => 36, 
        'xoffset'  => 2, 
        'xadvance' => 41, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xE0, 0x00, 0x00, 0x00, ##  00000000000                         
            0xFF, 0xE0, 0x00, 0x00, 0x00, ##  00000000000                         
            0xFF, 0xE0, 0x00, 0x00, 0x00, ##  00000000000                         
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                         
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                         
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                         
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                         
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                         
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                         
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                         
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                         
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                         
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                         
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                         
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                         
            0x07, 0xE0, 0x3F, 0xC0, 0x00, ##       000000       00000000          
            0x07, 0xE1, 0xFF, 0xF0, 0x00, ##       000000    0000000000000        
            0x07, 0xE3, 0xFF, 0xFC, 0x00, ##       000000   0000000000000000      
            0x07, 0xEF, 0x81, 0xFE, 0x00, ##       000000 00000      00000000     
            0x07, 0xEE, 0x00, 0x7F, 0x00, ##       000000 000          0000000    
            0x07, 0xFC, 0x00, 0x3F, 0x80, ##       000000000            0000000   
            0x07, 0xF8, 0x00, 0x1F, 0x80, ##       00000000              000000   
            0x07, 0xF8, 0x00, 0x1F, 0xC0, ##       00000000              0000000  
            0x07, 0xF0, 0x00, 0x0F, 0xC0, ##       0000000                000000  
            0x07, 0xF0, 0x00, 0x0F, 0xE0, ##       0000000                0000000 
            0x07, 0xE0, 0x00, 0x0F, 0xE0, ##       000000                 0000000 
            0x07, 0xE0, 0x00, 0x07, 0xE0, ##       000000                  000000 
            0x07, 0xE0, 0x00, 0x07, 0xF0, ##       000000                  0000000
            0x07, 0xE0, 0x00, 0x07, 0xF0, ##       000000                  0000000
            0x07, 0xE0, 0x00, 0x07, 0xF0, ##       000000                  0000000
            0x07, 0xE0, 0x00, 0x07, 0xF0, ##       000000                  0000000
            0x07, 0xE0, 0x00, 0x07, 0xF0, ##       000000                  0000000
            0x07, 0xE0, 0x00, 0x07, 0xF0, ##       000000                  0000000
            0x07, 0xE0, 0x00, 0x07, 0xF0, ##       000000                  0000000
            0x07, 0xE0, 0x00, 0x07, 0xF0, ##       000000                  0000000
            0x07, 0xE0, 0x00, 0x07, 0xF0, ##       000000                  0000000
            0x07, 0xE0, 0x00, 0x07, 0xF0, ##       000000                  0000000
            0x07, 0xE0, 0x00, 0x07, 0xE0, ##       000000                  000000 
            0x07, 0xE0, 0x00, 0x0F, 0xE0, ##       000000                 0000000 
            0x07, 0xF0, 0x00, 0x0F, 0xE0, ##       0000000                0000000 
            0x07, 0xF0, 0x00, 0x0F, 0xC0, ##       0000000                000000  
            0x07, 0xF0, 0x00, 0x1F, 0xC0, ##       0000000               0000000  
            0x07, 0xF8, 0x00, 0x1F, 0x80, ##       00000000              000000   
            0x07, 0xFC, 0x00, 0x3F, 0x80, ##       000000000            0000000   
            0x07, 0xEE, 0x00, 0x7F, 0x00, ##       000000 000          0000000    
            0x07, 0xEF, 0x81, 0xFE, 0x00, ##       000000 00000      00000000     
            0x07, 0xE3, 0xFF, 0xFC, 0x00, ##       000000   0000000000000000      
            0x07, 0xE1, 0xFF, 0xF0, 0x00, ##       000000    0000000000000        
            0x07, 0xE0, 0x3F, 0xC0, 0x00, ##       000000       00000000          
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                         
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                         
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                         
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                         
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                         
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                         
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                         
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                         
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                         
            0x07, 0xE0, 0x00, 0x00, 0x00, ##       000000                         
            0xFF, 0xFF, 0x80, 0x00, 0x00, ##  00000000000000000                   
            0xFF, 0xFF, 0x80, 0x00, 0x00, ##  00000000000000000                   
            0xFF, 0xFF, 0x80, 0x00, 0x00, ##  00000000000000000                   
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '255' => {    # 'ÿ'
        'width'    => 36, 
        'xoffset'  => 0, 
        'xadvance' => 37, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x1C, 0x01, 0xC0, 0x00, ##             000         000          
            0x00, 0x3E, 0x03, 0xE0, 0x00, ##            00000       00000         
            0x00, 0x7F, 0x07, 0xF0, 0x00, ##           0000000     0000000        
            0x00, 0x7F, 0x07, 0xF0, 0x00, ##           0000000     0000000        
            0x00, 0x7F, 0x07, 0xF0, 0x00, ##           0000000     0000000        
            0x00, 0x3E, 0x03, 0xE0, 0x00, ##            00000       00000         
            0x00, 0x1C, 0x01, 0xC0, 0x00, ##             000         000          
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                      
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                      
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                      
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                      
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                      
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                      
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                      
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                      
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                      
            0xFF, 0xFE, 0x00, 0xFF, 0xF0, ##  000000000000000         000000000000
            0xFF, 0xFE, 0x00, 0xFF, 0xF0, ##  000000000000000         000000000000
            0xFF, 0xFE, 0x00, 0xFF, 0xF0, ##  000000000000000         000000000000
            0x0F, 0xC0, 0x00, 0x0F, 0x00, ##      000000                  0000    
            0x07, 0xE0, 0x00, 0x0F, 0x00, ##       000000                 0000    
            0x07, 0xE0, 0x00, 0x0E, 0x00, ##       000000                 000     
            0x07, 0xF0, 0x00, 0x1E, 0x00, ##       0000000               0000     
            0x03, 0xF0, 0x00, 0x1E, 0x00, ##        000000               0000     
            0x03, 0xF0, 0x00, 0x3C, 0x00, ##        000000              0000      
            0x01, 0xF8, 0x00, 0x3C, 0x00, ##         000000             0000      
            0x01, 0xF8, 0x00, 0x38, 0x00, ##         000000             000       
            0x01, 0xFC, 0x00, 0x78, 0x00, ##         0000000           0000       
            0x00, 0xFC, 0x00, 0x78, 0x00, ##          000000           0000       
            0x00, 0xFC, 0x00, 0xF0, 0x00, ##          000000          0000        
            0x00, 0x7E, 0x00, 0xF0, 0x00, ##           000000         0000        
            0x00, 0x7E, 0x00, 0xE0, 0x00, ##           000000         000         
            0x00, 0x7F, 0x01, 0xE0, 0x00, ##           0000000       0000         
            0x00, 0x3F, 0x01, 0xC0, 0x00, ##            000000       000          
            0x00, 0x3F, 0x83, 0xC0, 0x00, ##            0000000     0000          
            0x00, 0x1F, 0x83, 0xC0, 0x00, ##             000000     0000          
            0x00, 0x1F, 0x83, 0x80, 0x00, ##             000000     000           
            0x00, 0x0F, 0xC7, 0x80, 0x00, ##              000000   0000           
            0x00, 0x0F, 0xC7, 0x00, 0x00, ##              000000   000            
            0x00, 0x0F, 0xEF, 0x00, 0x00, ##              0000000 0000            
            0x00, 0x07, 0xEF, 0x00, 0x00, ##               000000 0000            
            0x00, 0x07, 0xEE, 0x00, 0x00, ##               000000 000             
            0x00, 0x03, 0xFE, 0x00, 0x00, ##                000000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000              
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000              
            0x00, 0x01, 0xFC, 0x00, 0x00, ##                 0000000              
            0x00, 0x01, 0xF8, 0x00, 0x00, ##                 000000               
            0x00, 0x00, 0xF8, 0x00, 0x00, ##                  00000               
            0x00, 0x00, 0xF0, 0x00, 0x00, ##                  0000                
            0x00, 0x00, 0xF0, 0x00, 0x00, ##                  0000                
            0x00, 0x00, 0xF0, 0x00, 0x00, ##                  0000                
            0x00, 0x00, 0xE0, 0x00, 0x00, ##                  000                 
            0x00, 0x01, 0xE0, 0x00, 0x00, ##                 0000                 
            0x00, 0x01, 0xC0, 0x00, 0x00, ##                 000                  
            0x00, 0x01, 0xC0, 0x00, 0x00, ##                 000                  
            0x00, 0x03, 0xC0, 0x00, 0x00, ##                0000                  
            0x38, 0x03, 0x80, 0x00, 0x00, ##    000         000                   
            0x3C, 0x07, 0x80, 0x00, 0x00, ##    0000       0000                   
            0x3C, 0x07, 0x00, 0x00, 0x00, ##    0000       000                    
            0x3E, 0x1F, 0x00, 0x00, 0x00, ##    00000    00000                    
            0x3F, 0xFE, 0x00, 0x00, 0x00, ##    0000000000000                     
            0x3F, 0xFC, 0x00, 0x00, 0x00, ##    000000000000                      
            0x0F, 0xF0, 0x00, 0x00, 0x00, ##      00000000                        
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
};
 
my $kerning = {
    '33' => { },  # !
    '34' => { },  # "
    '35' => { },  # #
    '36' => { },  # $
    '37' => { },  # %
    '38' => { },  # &
    '39' => { },  # '
    '40' => { },  # (
    '41' => { },  # )
    '42' => { },  # *
    '43' => { },  # +
    '44' => { },  # ,
    '45' => { '84' => -2, '86' => -5, '87' => -3, '88' => -2, '89' => -7, '221' => -7, },  # -
    '46' => { },  # .
    '47' => { },  # /
    '48' => { },  # 0
    '49' => { },  # 1
    '50' => { },  # 2
    '51' => { },  # 3
    '52' => { },  # 4
    '53' => { },  # 5
    '54' => { },  # 6
    '55' => { },  # 7
    '56' => { },  # 8
    '57' => { },  # 9
    '58' => { },  # :
    '59' => { },  # ;
    '60' => { },  # <
    '61' => { },  # =
    '62' => { },  # >
    '63' => { },  # ?
    '64' => { },  # @
    '65' => { '84' => -3, '86' => -3, '87' => -3, '89' => -3, '102' => -1, '116' => -1, '118' => -3, '119' => -3, '121' => -3, '221' => -3, '253' => -3, '255' => -3, },  # A
    '66' => { '45' => 1, '67' => 1, '71' => 1, '79' => 1, '89' => -1, '199' => 1, '210' => 1, '211' => 1, '212' => 1, '213' => 1, '214' => 1, '216' => 1, '221' => -1, },  # B
    '67' => { '44' => -2, '46' => -2, },  # C
    '68' => { '44' => -2, '45' => 1, '46' => -2, '86' => -1, },  # D
    '69' => { '45' => 1, },  # E
    '70' => { '44' => -10, '45' => -3, '46' => -10, '58' => -2, '59' => -2, '65' => -6, '97' => -4, '101' => -3, '111' => -3, '192' => -6, '193' => -6, '194' => -6, '195' => -6, '196' => -6, '224' => -4, '225' => -4, '226' => -4, '227' => -4, '228' => -4, '229' => -4, '230' => -4, '232' => -3, '233' => -3, '234' => -3, '235' => -3, '242' => -3, '243' => -3, '244' => -3, '245' => -3, '246' => -3, '248' => -3, },  # F
    '71' => { '44' => -2, '45' => 1, '46' => -2, '89' => -1, '221' => -1, },  # G
    '72' => { },  # H
    '73' => { },  # I
    '74' => { '44' => -4, '46' => -5, '58' => -3, '59' => -3, },  # J
    '75' => { '45' => -5, '65' => -3, '67' => -2, '79' => -2, '85' => -2, '87' => -2, '89' => -2, '101' => -2, '111' => -2, '117' => -1, '121' => -4, '192' => -3, '193' => -3, '194' => -3, '195' => -3, '196' => -3, '199' => -2, '210' => -2, '211' => -2, '212' => -2, '213' => -2, '214' => -2, '216' => -2, '217' => -2, '218' => -2, '219' => -2, '220' => -2, '221' => -2, '232' => -2, '233' => -2, '234' => -2, '235' => -2, '242' => -2, '243' => -2, '244' => -2, '245' => -2, '246' => -2, '248' => -1, '249' => -1, '250' => -1, '251' => -1, '252' => -1, '253' => -4, '255' => -4, },  # K
    '76' => { '84' => -5, '85' => -3, '86' => -8, '87' => -6, '89' => -4, '121' => -1, '217' => -3, '218' => -3, '219' => -3, '220' => -3, '221' => -4, '253' => -1, '255' => -1, },  # L
    '77' => { },  # M
    '78' => { '44' => -4, '46' => -4, '58' => -2, '59' => -2, },  # N
    '79' => { '44' => -4, '45' => 2, '46' => -4, '86' => -1, '88' => -1, },  # O
    '80' => { '44' => -13, '45' => -3, '46' => -13, '58' => -2, '59' => -2, '65' => -6, '85' => -1, '97' => -3, '101' => -3, '111' => -3, '115' => -2, '192' => -6, '193' => -6, '194' => -6, '195' => -6, '196' => -6, '217' => -1, '218' => -1, '219' => -1, '220' => -1, '224' => -3, '225' => -3, '226' => -3, '227' => -3, '228' => -3, '229' => -3, '230' => -3, '232' => -3, '233' => -3, '234' => -3, '235' => -3, '242' => -3, '243' => -3, '244' => -3, '245' => -3, '246' => -3, '248' => -3, },  # P
    '81' => { '44' => -3, '45' => 2, '46' => -3, },  # Q
    '82' => { '84' => -1, '86' => -2, '87' => -1, '89' => -2, '97' => 1, '121' => -1, '221' => -2, '224' => 1, '225' => 1, '226' => 1, '227' => 1, '228' => 1, '229' => 1, '230' => 1, '248' => 1, '253' => -1, '255' => -1, },  # R
    '83' => { '44' => -2, '45' => 2, '46' => -2, },  # S
    '84' => { '44' => -9, '45' => -8, '46' => -9, '58' => -2, '59' => -2, '65' => -3, '97' => -5, '99' => -5, '101' => -5, '111' => -5, '115' => -5, '119' => -2, '192' => -3, '193' => -3, '194' => -3, '195' => -3, '196' => -3, '224' => -5, '225' => -5, '226' => -5, '227' => -5, '228' => -5, '229' => -5, '230' => -5, '231' => -5, '232' => -5, '233' => -5, '234' => -5, '235' => -5, '242' => -5, '243' => -5, '244' => -5, '245' => -5, '246' => -5, '248' => -5, },  # T
    '85' => { '44' => -6, '45' => -1, '46' => -6, '58' => -2, '59' => -2, '65' => -2, '74' => -2, '192' => -2, '193' => -2, '194' => -2, '195' => -2, '196' => -2, },  # U
    '86' => { '44' => -11, '45' => -6, '46' => -11, '58' => -6, '59' => -6, '65' => -4, '79' => -1, '97' => -6, '101' => -6, '105' => -1, '111' => -6, '117' => -4, '121' => -3, '192' => -4, '193' => -4, '194' => -4, '195' => -4, '196' => -4, '210' => -1, '211' => -1, '212' => -1, '213' => -1, '214' => -1, '216' => -1, '224' => -6, '225' => -6, '226' => -6, '227' => -6, '228' => -6, '229' => -6, '230' => -6, '232' => -6, '233' => -6, '234' => -6, '235' => -6, '242' => -6, '243' => -6, '244' => -6, '245' => -6, '246' => -6, '248' => -6, '249' => -4, '250' => -4, '251' => -4, '252' => -4, '253' => -3, '255' => -3, },  # V
    '87' => { '44' => -11, '45' => -5, '46' => -11, '58' => -6, '59' => -6, '65' => -3, '97' => -6, '101' => -5, '105' => -1, '111' => -4, '114' => -3, '117' => -3, '121' => -1, '192' => -3, '193' => -3, '194' => -3, '195' => -3, '196' => -3, '224' => -6, '225' => -6, '226' => -6, '227' => -6, '228' => -6, '229' => -6, '230' => -4, '232' => -5, '233' => -5, '234' => -5, '235' => -5, '242' => -4, '243' => -4, '244' => -4, '245' => -4, '246' => -4, '248' => -4, '249' => -3, '250' => -3, '251' => -3, '252' => -3, '253' => -1, '255' => -1, },  # W
    '88' => { '45' => -2, '65' => -2, '67' => -1, '79' => -1, '192' => -2, '193' => -2, '194' => -2, '195' => -2, '196' => -2, '199' => -1, '210' => -1, '211' => -1, '212' => -1, '213' => -1, '214' => -1, '216' => -1, },  # X
    '89' => { '44' => -8, '45' => -7, '46' => -8, '58' => -8, '59' => -8, '65' => -5, '67' => -1, '97' => -5, '101' => -6, '105' => -1, '111' => -6, '117' => -6, '192' => -5, '193' => -5, '194' => -5, '195' => -5, '196' => -5, '199' => -1, '224' => -5, '225' => -5, '226' => -5, '227' => -5, '228' => -5, '229' => -5, '230' => -6, '232' => -6, '233' => -6, '234' => -6, '235' => -6, '242' => -6, '243' => -6, '244' => -6, '245' => -6, '246' => -6, '248' => -6, '249' => -6, '250' => -6, '251' => -6, '252' => -6, },  # Y
    '90' => { '44' => -1, '46' => -1, },  # Z
    '91' => { },  # [
    '92' => { },  # \
    '93' => { },  # ]
    '94' => { },  # ^
    '95' => { },  # _
    '96' => { },  # `
    '97' => { },  # a
    '98' => { },  # b
    '99' => { },  # c
    '100' => { },  # d
    '101' => { },  # e
    '102' => { '44' => -2, '45' => -2, '46' => -2, },  # f
    '103' => { },  # g
    '104' => { },  # h
    '105' => { },  # i
    '106' => { },  # j
    '107' => { '45' => -1, },  # k
    '108' => { },  # l
    '109' => { },  # m
    '110' => { },  # n
    '111' => { '46' => -1, },  # o
    '112' => { },  # p
    '113' => { },  # q
    '114' => { '44' => -7, '46' => -7, },  # r
    '115' => { },  # s
    '116' => { },  # t
    '117' => { },  # u
    '118' => { '44' => -8, '46' => -8, },  # v
    '119' => { '44' => -8, '46' => -8, },  # w
    '120' => { '45' => -1, },  # x
    '121' => { '44' => -8, '46' => -8, },  # y
    '122' => { },  # z
    '123' => { },  # {
    '124' => { },  # |
    '125' => { },  # }
    '126' => { },  # ~
    '160' => { },  #  
    '161' => { },  # ¡
    '162' => { },  # ¢
    '163' => { },  # £
    '164' => { },  # ¤
    '165' => { },  # ¥
    '166' => { },  # ¦
    '167' => { },  # §
    '168' => { },  # ¨
    '169' => { },  # ©
    '170' => { },  # ª
    '171' => { },  # «
    '172' => { },  # ¬
    '173' => { },  # ­
    '174' => { },  # ®
    '175' => { },  # ¯
    '176' => { },  # °
    '177' => { },  # ±
    '178' => { },  # ²
    '179' => { },  # ³
    '180' => { },  # ´
    '181' => { },  # µ
    '182' => { },  # ¶
    '183' => { },  # ·
    '184' => { },  # ¸
    '185' => { },  # ¹
    '186' => { },  # º
    '187' => { },  # »
    '188' => { },  # ¼
    '189' => { },  # ½
    '190' => { },  # ¾
    '191' => { },  # ¿
    '192' => { '84' => -3, '86' => -3, '87' => -3, '89' => -3, '102' => -1, '116' => -1, '118' => -3, '119' => -3, '121' => -3, '221' => -3, '253' => -3, '255' => -3, },  # À
    '193' => { '84' => -3, '86' => -3, '87' => -3, '89' => -3, '102' => -1, '116' => -1, '118' => -3, '119' => -3, '121' => -3, '221' => -3, '253' => -3, '255' => -3, },  # Á
    '194' => { '84' => -3, '86' => -3, '87' => -3, '89' => -3, '102' => -1, '116' => -1, '118' => -3, '119' => -3, '121' => -3, '221' => -3, '253' => -3, '255' => -3, },  # Â
    '195' => { '84' => -3, '86' => -3, '87' => -3, '89' => -3, '102' => -1, '116' => -1, '118' => -3, '119' => -3, '121' => -3, '221' => -3, '253' => -3, '255' => -3, },  # Ã
    '196' => { '84' => -3, '86' => -3, '87' => -3, '89' => -3, '102' => -1, '116' => -1, '118' => -3, '119' => -3, '121' => -3, '221' => -3, '253' => -3, '255' => -3, },  # Ä
    '197' => { },  # Å
    '198' => { '45' => 1, },  # Æ
    '199' => { '44' => -2, '46' => -2, },  # Ç
    '200' => { '45' => 1, },  # È
    '201' => { '45' => 1, },  # É
    '202' => { '45' => 1, },  # Ê
    '203' => { '45' => 1, },  # Ë
    '204' => { },  # Ì
    '205' => { },  # Í
    '206' => { },  # Î
    '207' => { },  # Ï
    '208' => { '44' => -2, '45' => 2, '46' => -2, '65' => -1, '86' => -1, '89' => -1, '192' => -1, '193' => -1, '194' => -1, '195' => -1, '196' => -1, '221' => -1, },  # Ð
    '209' => { '44' => -4, '46' => -4, '58' => -2, '59' => -2, },  # Ñ
    '210' => { '44' => -4, '45' => 2, '46' => -4, '86' => -1, '88' => -1, },  # Ò
    '211' => { '44' => -4, '45' => 2, '46' => -4, '86' => -1, '88' => -1, },  # Ó
    '212' => { '44' => -4, '45' => 2, '46' => -4, '86' => -1, '88' => -1, },  # Ô
    '213' => { '44' => -4, '45' => 2, '46' => -4, '86' => -1, '88' => -1, },  # Õ
    '214' => { '44' => -4, '45' => 2, '46' => -4, '86' => -1, '88' => -1, },  # Ö
    '215' => { },  # ×
    '216' => { '44' => -4, '45' => 2, '46' => -4, '86' => -1, '88' => -1, },  # Ø
    '217' => { '44' => -6, '45' => -1, '46' => -6, '58' => -2, '59' => -2, '65' => -2, '74' => -2, '192' => -2, '193' => -2, '194' => -2, '195' => -2, '196' => -2, },  # Ù
    '218' => { '44' => -6, '45' => -1, '46' => -6, '58' => -2, '59' => -2, '65' => -2, '74' => -2, '192' => -2, '193' => -2, '194' => -2, '195' => -2, '196' => -2, },  # Ú
    '219' => { '44' => -6, '45' => -1, '46' => -6, '58' => -2, '59' => -2, '65' => -2, '74' => -2, '192' => -2, '193' => -2, '194' => -2, '195' => -2, '196' => -2, },  # Û
    '220' => { '44' => -6, '45' => -1, '46' => -6, '58' => -2, '59' => -2, '65' => -2, '74' => -2, '192' => -2, '193' => -2, '194' => -2, '195' => -2, '196' => -2, },  # Ü
    '221' => { '44' => -8, '45' => -7, '46' => -8, '58' => -8, '59' => -8, '65' => -5, '67' => -1, '97' => -5, '101' => -6, '105' => -1, '111' => -6, '117' => -6, '192' => -5, '193' => -5, '194' => -5, '195' => -5, '196' => -5, '199' => -1, '224' => -5, '225' => -5, '226' => -5, '227' => -5, '228' => -5, '229' => -5, '230' => -6, '232' => -6, '233' => -6, '234' => -6, '235' => -6, '242' => -6, '243' => -6, '244' => -6, '245' => -6, '246' => -6, '248' => -6, '249' => -6, '250' => -6, '251' => -6, '252' => -6, },  # Ý
    '222' => { '44' => -11, '45' => 1, '46' => -11, },  # Þ
    '223' => { },  # ß
    '224' => { },  # à
    '225' => { },  # á
    '226' => { },  # â
    '227' => { },  # ã
    '228' => { },  # ä
    '229' => { },  # å
    '230' => { },  # æ
    '231' => { },  # ç
    '232' => { },  # è
    '233' => { },  # é
    '234' => { },  # ê
    '235' => { },  # ë
    '236' => { },  # ì
    '237' => { },  # í
    '238' => { },  # î
    '239' => { },  # ï
    '240' => { '46' => -1, },  # ð
    '241' => { },  # ñ
    '242' => { '46' => -1, },  # ò
    '243' => { '46' => -1, },  # ó
    '244' => { '46' => -1, },  # ô
    '245' => { '46' => -1, },  # õ
    '246' => { '46' => -1, },  # ö
    '247' => { },  # ÷
    '248' => { '46' => -1, },  # ø
    '249' => { },  # ù
    '250' => { },  # ú
    '251' => { },  # û
    '252' => { },  # ü
    '253' => { '44' => -8, '46' => -8, },  # ý
    '254' => { '44' => -1, '46' => -3, },  # þ
    '255' => { '44' => -8, '46' => -8, },  # ÿ
};


sub new {
    my($class) = @_;
    
    my $self = $class->SUPER::new(
        name        => $name,
        char_height => $char_height,
        space_width => $space_width,
        gap_width   => $gap_width,
        symbols     => $symbols,
        kerning     => $kerning,
        line_spacing => $line_spacing,
        class       => 'hipi_2',
    );
    
    return $self;
}

1;

__END__
